package software.amazon.awscdk.services.apigateway;

/**
 * Example:
 * <p>
 * <blockquote><pre>
 * RestApi api;
 * // We define the JSON Schema for the transformed valid response
 * Model responseModel = api.addModel("ResponseModel", ModelOptions.builder()
 *         .contentType("application/json")
 *         .modelName("ResponseModel")
 *         .schema(JsonSchema.builder()
 *                 .schema(JsonSchemaVersion.DRAFT4)
 *                 .title("pollResponse")
 *                 .type(JsonSchemaType.OBJECT)
 *                 .properties(Map.of(
 *                         "state", JsonSchema.builder().type(JsonSchemaType.STRING).build(),
 *                         "greeting", JsonSchema.builder().type(JsonSchemaType.STRING).build()))
 *                 .build())
 *         .build());
 * // We define the JSON Schema for the transformed error response
 * Model errorResponseModel = api.addModel("ErrorResponseModel", ModelOptions.builder()
 *         .contentType("application/json")
 *         .modelName("ErrorResponseModel")
 *         .schema(JsonSchema.builder()
 *                 .schema(JsonSchemaVersion.DRAFT4)
 *                 .title("errorResponse")
 *                 .type(JsonSchemaType.OBJECT)
 *                 .properties(Map.of(
 *                         "state", JsonSchema.builder().type(JsonSchemaType.STRING).build(),
 *                         "message", JsonSchema.builder().type(JsonSchemaType.STRING).build()))
 *                 .build())
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-01-25T00:20:49.997Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_apigateway.JsonSchemaType")
public enum JsonSchemaType {
    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    NULL,
    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    BOOLEAN,
    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    OBJECT,
    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    ARRAY,
    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    NUMBER,
    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    INTEGER,
    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    STRING,
}
