package software.amazon.awscdk.services.appmesh;

/**
 * Properties specific for a GRPC Based Routes.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * VirtualRouter router;
 * VirtualNode node;
 * router.addRoute("route-grpc-retry", RouteBaseProps.builder()
 *         .routeSpec(RouteSpec.grpc(GrpcRouteSpecOptions.builder()
 *                 .weightedTargets(List.of(WeightedTarget.builder().virtualNode(node).build()))
 *                 .match(GrpcRouteMatch.builder()
 *                         // When method name is specified, service name must be also specified.
 *                         .methodName("methodname")
 *                         .serviceName("servicename")
 *                         .metadata(List.of(HeaderMatch.valueStartsWith("Content-Type", "application/"), HeaderMatch.valueDoesNotStartWith("Content-Type", "text/")))
 *                         .build())
 *                 .build()))
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-01-25T00:20:50.715Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appmesh.GrpcRouteSpecOptions")
@software.amazon.jsii.Jsii.Proxy(GrpcRouteSpecOptions.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface GrpcRouteSpecOptions extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.appmesh.RouteSpecOptionsBase {

    /**
     * The criterion for determining a request match for this Route.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appmesh.GrpcRouteMatch getMatch();

    /**
     * List of targets that traffic is routed to when a request matches the route.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.services.appmesh.WeightedTarget> getWeightedTargets();

    /**
     * The retry policy.
     * <p>
     * Default: - no retry policy
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.appmesh.GrpcRetryPolicy getRetryPolicy() {
        return null;
    }

    /**
     * An object that represents a grpc timeout.
     * <p>
     * Default: - None
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.appmesh.GrpcTimeout getTimeout() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link GrpcRouteSpecOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link GrpcRouteSpecOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<GrpcRouteSpecOptions> {
        software.amazon.awscdk.services.appmesh.GrpcRouteMatch match;
        java.util.List<software.amazon.awscdk.services.appmesh.WeightedTarget> weightedTargets;
        software.amazon.awscdk.services.appmesh.GrpcRetryPolicy retryPolicy;
        software.amazon.awscdk.services.appmesh.GrpcTimeout timeout;
        java.lang.Number priority;

        /**
         * Sets the value of {@link GrpcRouteSpecOptions#getMatch}
         * @param match The criterion for determining a request match for this Route. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder match(software.amazon.awscdk.services.appmesh.GrpcRouteMatch match) {
            this.match = match;
            return this;
        }

        /**
         * Sets the value of {@link GrpcRouteSpecOptions#getWeightedTargets}
         * @param weightedTargets List of targets that traffic is routed to when a request matches the route. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder weightedTargets(java.util.List<? extends software.amazon.awscdk.services.appmesh.WeightedTarget> weightedTargets) {
            this.weightedTargets = (java.util.List<software.amazon.awscdk.services.appmesh.WeightedTarget>)weightedTargets;
            return this;
        }

        /**
         * Sets the value of {@link GrpcRouteSpecOptions#getRetryPolicy}
         * @param retryPolicy The retry policy.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder retryPolicy(software.amazon.awscdk.services.appmesh.GrpcRetryPolicy retryPolicy) {
            this.retryPolicy = retryPolicy;
            return this;
        }

        /**
         * Sets the value of {@link GrpcRouteSpecOptions#getTimeout}
         * @param timeout An object that represents a grpc timeout.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder timeout(software.amazon.awscdk.services.appmesh.GrpcTimeout timeout) {
            this.timeout = timeout;
            return this;
        }

        /**
         * Sets the value of {@link GrpcRouteSpecOptions#getPriority}
         * @param priority The priority for the route.
         *                 When a Virtual Router has multiple routes, route match is performed in the
         *                 order of specified value, where 0 is the highest priority, and first matched route is selected.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder priority(java.lang.Number priority) {
            this.priority = priority;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link GrpcRouteSpecOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public GrpcRouteSpecOptions build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link GrpcRouteSpecOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements GrpcRouteSpecOptions {
        private final software.amazon.awscdk.services.appmesh.GrpcRouteMatch match;
        private final java.util.List<software.amazon.awscdk.services.appmesh.WeightedTarget> weightedTargets;
        private final software.amazon.awscdk.services.appmesh.GrpcRetryPolicy retryPolicy;
        private final software.amazon.awscdk.services.appmesh.GrpcTimeout timeout;
        private final java.lang.Number priority;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.match = software.amazon.jsii.Kernel.get(this, "match", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appmesh.GrpcRouteMatch.class));
            this.weightedTargets = software.amazon.jsii.Kernel.get(this, "weightedTargets", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appmesh.WeightedTarget.class)));
            this.retryPolicy = software.amazon.jsii.Kernel.get(this, "retryPolicy", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appmesh.GrpcRetryPolicy.class));
            this.timeout = software.amazon.jsii.Kernel.get(this, "timeout", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appmesh.GrpcTimeout.class));
            this.priority = software.amazon.jsii.Kernel.get(this, "priority", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.match = java.util.Objects.requireNonNull(builder.match, "match is required");
            this.weightedTargets = (java.util.List<software.amazon.awscdk.services.appmesh.WeightedTarget>)java.util.Objects.requireNonNull(builder.weightedTargets, "weightedTargets is required");
            this.retryPolicy = builder.retryPolicy;
            this.timeout = builder.timeout;
            this.priority = builder.priority;
        }

        @Override
        public final software.amazon.awscdk.services.appmesh.GrpcRouteMatch getMatch() {
            return this.match;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.appmesh.WeightedTarget> getWeightedTargets() {
            return this.weightedTargets;
        }

        @Override
        public final software.amazon.awscdk.services.appmesh.GrpcRetryPolicy getRetryPolicy() {
            return this.retryPolicy;
        }

        @Override
        public final software.amazon.awscdk.services.appmesh.GrpcTimeout getTimeout() {
            return this.timeout;
        }

        @Override
        public final java.lang.Number getPriority() {
            return this.priority;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("match", om.valueToTree(this.getMatch()));
            data.set("weightedTargets", om.valueToTree(this.getWeightedTargets()));
            if (this.getRetryPolicy() != null) {
                data.set("retryPolicy", om.valueToTree(this.getRetryPolicy()));
            }
            if (this.getTimeout() != null) {
                data.set("timeout", om.valueToTree(this.getTimeout()));
            }
            if (this.getPriority() != null) {
                data.set("priority", om.valueToTree(this.getPriority()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appmesh.GrpcRouteSpecOptions"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            GrpcRouteSpecOptions.Jsii$Proxy that = (GrpcRouteSpecOptions.Jsii$Proxy) o;

            if (!match.equals(that.match)) return false;
            if (!weightedTargets.equals(that.weightedTargets)) return false;
            if (this.retryPolicy != null ? !this.retryPolicy.equals(that.retryPolicy) : that.retryPolicy != null) return false;
            if (this.timeout != null ? !this.timeout.equals(that.timeout) : that.timeout != null) return false;
            return this.priority != null ? this.priority.equals(that.priority) : that.priority == null;
        }

        @Override
        public final int hashCode() {
            int result = this.match.hashCode();
            result = 31 * result + (this.weightedTargets.hashCode());
            result = 31 * result + (this.retryPolicy != null ? this.retryPolicy.hashCode() : 0);
            result = 31 * result + (this.timeout != null ? this.timeout.hashCode() : 0);
            result = 31 * result + (this.priority != null ? this.priority.hashCode() : 0);
            return result;
        }
    }
}
