package software.amazon.awscdk.services.appsync;

/**
 * Properties for defining a <code>CfnResolver</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.appsync.*;
 * CfnResolverProps cfnResolverProps = CfnResolverProps.builder()
 *         .apiId("apiId")
 *         .fieldName("fieldName")
 *         .typeName("typeName")
 *         // the properties below are optional
 *         .cachingConfig(CachingConfigProperty.builder()
 *                 .ttl(123)
 *                 // the properties below are optional
 *                 .cachingKeys(List.of("cachingKeys"))
 *                 .build())
 *         .code("code")
 *         .codeS3Location("codeS3Location")
 *         .dataSourceName("dataSourceName")
 *         .kind("kind")
 *         .maxBatchSize(123)
 *         .metricsConfig("metricsConfig")
 *         .pipelineConfig(PipelineConfigProperty.builder()
 *                 .functions(List.of("functions"))
 *                 .build())
 *         .requestMappingTemplate("requestMappingTemplate")
 *         .requestMappingTemplateS3Location("requestMappingTemplateS3Location")
 *         .responseMappingTemplate("responseMappingTemplate")
 *         .responseMappingTemplateS3Location("responseMappingTemplateS3Location")
 *         .runtime(AppSyncRuntimeProperty.builder()
 *                 .name("name")
 *                 .runtimeVersion("runtimeVersion")
 *                 .build())
 *         .syncConfig(SyncConfigProperty.builder()
 *                 .conflictDetection("conflictDetection")
 *                 // the properties below are optional
 *                 .conflictHandler("conflictHandler")
 *                 .lambdaConflictHandlerConfig(LambdaConflictHandlerConfigProperty.builder()
 *                         .lambdaConflictHandlerArn("lambdaConflictHandlerArn")
 *                         .build())
 *                 .build())
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-resolver.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-resolver.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-01-25T00:20:50.947Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appsync.CfnResolverProps")
@software.amazon.jsii.Jsii.Proxy(CfnResolverProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnResolverProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The AWS AppSync GraphQL API to which you want to attach this resolver.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-resolver.html#cfn-appsync-resolver-apiid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-resolver.html#cfn-appsync-resolver-apiid</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getApiId();

    /**
     * The GraphQL field on a type that invokes the resolver.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-resolver.html#cfn-appsync-resolver-fieldname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-resolver.html#cfn-appsync-resolver-fieldname</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getFieldName();

    /**
     * The GraphQL type that invokes this resolver.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-resolver.html#cfn-appsync-resolver-typename">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-resolver.html#cfn-appsync-resolver-typename</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getTypeName();

    /**
     * The caching configuration for the resolver.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-resolver.html#cfn-appsync-resolver-cachingconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-resolver.html#cfn-appsync-resolver-cachingconfig</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getCachingConfig() {
        return null;
    }

    /**
     * The <code>resolver</code> code that contains the request and response functions.
     * <p>
     * When code is used, the <code>runtime</code> is required. The runtime value must be <code>APPSYNC_JS</code> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-resolver.html#cfn-appsync-resolver-code">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-resolver.html#cfn-appsync-resolver-code</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getCode() {
        return null;
    }

    /**
     * The Amazon S3 endpoint.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-resolver.html#cfn-appsync-resolver-codes3location">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-resolver.html#cfn-appsync-resolver-codes3location</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getCodeS3Location() {
        return null;
    }

    /**
     * The resolver data source name.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-resolver.html#cfn-appsync-resolver-datasourcename">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-resolver.html#cfn-appsync-resolver-datasourcename</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDataSourceName() {
        return null;
    }

    /**
     * The resolver type.
     * <p>
     * <ul>
     * <li><em>UNIT</em> : A UNIT resolver type. A UNIT resolver is the default resolver type. You can use a UNIT resolver to run a GraphQL query against a single data source.</li>
     * <li><em>PIPELINE</em> : A PIPELINE resolver type. You can use a PIPELINE resolver to invoke a series of <code>Function</code> objects in a serial manner. You can use a pipeline resolver to run a GraphQL query against multiple data sources.</li>
     * </ul>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-resolver.html#cfn-appsync-resolver-kind">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-resolver.html#cfn-appsync-resolver-kind</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getKind() {
        return null;
    }

    /**
     * The maximum number of resolver request inputs that will be sent to a single AWS Lambda function in a <code>BatchInvoke</code> operation.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-resolver.html#cfn-appsync-resolver-maxbatchsize">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-resolver.html#cfn-appsync-resolver-maxbatchsize</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getMaxBatchSize() {
        return null;
    }

    /**
     * Enables or disables enhanced resolver metrics for specified resolvers.
     * <p>
     * Note that <code>MetricsConfig</code> won't be used unless the <code>resolverLevelMetricsBehavior</code> value is set to <code>PER_RESOLVER_METRICS</code> . If the <code>resolverLevelMetricsBehavior</code> is set to <code>FULL_REQUEST_RESOLVER_METRICS</code> instead, <code>MetricsConfig</code> will be ignored. However, you can still set its value.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-resolver.html#cfn-appsync-resolver-metricsconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-resolver.html#cfn-appsync-resolver-metricsconfig</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getMetricsConfig() {
        return null;
    }

    /**
     * Functions linked with the pipeline resolver.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-resolver.html#cfn-appsync-resolver-pipelineconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-resolver.html#cfn-appsync-resolver-pipelineconfig</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getPipelineConfig() {
        return null;
    }

    /**
     * The request mapping template.
     * <p>
     * Request mapping templates are optional when using a Lambda data source. For all other data sources, a request mapping template is required.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-resolver.html#cfn-appsync-resolver-requestmappingtemplate">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-resolver.html#cfn-appsync-resolver-requestmappingtemplate</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getRequestMappingTemplate() {
        return null;
    }

    /**
     * The location of a request mapping template in an Amazon S3 bucket.
     * <p>
     * Use this if you want to provision with a template file in Amazon S3 rather than embedding it in your CloudFormation template.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-resolver.html#cfn-appsync-resolver-requestmappingtemplates3location">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-resolver.html#cfn-appsync-resolver-requestmappingtemplates3location</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getRequestMappingTemplateS3Location() {
        return null;
    }

    /**
     * The response mapping template.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-resolver.html#cfn-appsync-resolver-responsemappingtemplate">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-resolver.html#cfn-appsync-resolver-responsemappingtemplate</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getResponseMappingTemplate() {
        return null;
    }

    /**
     * The location of a response mapping template in an Amazon S3 bucket.
     * <p>
     * Use this if you want to provision with a template file in Amazon S3 rather than embedding it in your CloudFormation template.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-resolver.html#cfn-appsync-resolver-responsemappingtemplates3location">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-resolver.html#cfn-appsync-resolver-responsemappingtemplates3location</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getResponseMappingTemplateS3Location() {
        return null;
    }

    /**
     * Describes a runtime used by an AWS AppSync resolver or AWS AppSync function.
     * <p>
     * Specifies the name and version of the runtime to use. Note that if a runtime is specified, code must also be specified.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-resolver.html#cfn-appsync-resolver-runtime">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-resolver.html#cfn-appsync-resolver-runtime</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getRuntime() {
        return null;
    }

    /**
     * The <code>SyncConfig</code> for a resolver attached to a versioned data source.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-resolver.html#cfn-appsync-resolver-syncconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-resolver.html#cfn-appsync-resolver-syncconfig</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getSyncConfig() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnResolverProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnResolverProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnResolverProps> {
        java.lang.String apiId;
        java.lang.String fieldName;
        java.lang.String typeName;
        java.lang.Object cachingConfig;
        java.lang.String code;
        java.lang.String codeS3Location;
        java.lang.String dataSourceName;
        java.lang.String kind;
        java.lang.Number maxBatchSize;
        java.lang.String metricsConfig;
        java.lang.Object pipelineConfig;
        java.lang.String requestMappingTemplate;
        java.lang.String requestMappingTemplateS3Location;
        java.lang.String responseMappingTemplate;
        java.lang.String responseMappingTemplateS3Location;
        java.lang.Object runtime;
        java.lang.Object syncConfig;

        /**
         * Sets the value of {@link CfnResolverProps#getApiId}
         * @param apiId The AWS AppSync GraphQL API to which you want to attach this resolver. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder apiId(java.lang.String apiId) {
            this.apiId = apiId;
            return this;
        }

        /**
         * Sets the value of {@link CfnResolverProps#getFieldName}
         * @param fieldName The GraphQL field on a type that invokes the resolver. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder fieldName(java.lang.String fieldName) {
            this.fieldName = fieldName;
            return this;
        }

        /**
         * Sets the value of {@link CfnResolverProps#getTypeName}
         * @param typeName The GraphQL type that invokes this resolver. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder typeName(java.lang.String typeName) {
            this.typeName = typeName;
            return this;
        }

        /**
         * Sets the value of {@link CfnResolverProps#getCachingConfig}
         * @param cachingConfig The caching configuration for the resolver.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cachingConfig(software.amazon.awscdk.IResolvable cachingConfig) {
            this.cachingConfig = cachingConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnResolverProps#getCachingConfig}
         * @param cachingConfig The caching configuration for the resolver.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cachingConfig(software.amazon.awscdk.services.appsync.CfnResolver.CachingConfigProperty cachingConfig) {
            this.cachingConfig = cachingConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnResolverProps#getCode}
         * @param code The <code>resolver</code> code that contains the request and response functions.
         *             When code is used, the <code>runtime</code> is required. The runtime value must be <code>APPSYNC_JS</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder code(java.lang.String code) {
            this.code = code;
            return this;
        }

        /**
         * Sets the value of {@link CfnResolverProps#getCodeS3Location}
         * @param codeS3Location The Amazon S3 endpoint.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder codeS3Location(java.lang.String codeS3Location) {
            this.codeS3Location = codeS3Location;
            return this;
        }

        /**
         * Sets the value of {@link CfnResolverProps#getDataSourceName}
         * @param dataSourceName The resolver data source name.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dataSourceName(java.lang.String dataSourceName) {
            this.dataSourceName = dataSourceName;
            return this;
        }

        /**
         * Sets the value of {@link CfnResolverProps#getKind}
         * @param kind The resolver type.
         *             <ul>
         *             <li><em>UNIT</em> : A UNIT resolver type. A UNIT resolver is the default resolver type. You can use a UNIT resolver to run a GraphQL query against a single data source.</li>
         *             <li><em>PIPELINE</em> : A PIPELINE resolver type. You can use a PIPELINE resolver to invoke a series of <code>Function</code> objects in a serial manner. You can use a pipeline resolver to run a GraphQL query against multiple data sources.</li>
         *             </ul>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder kind(java.lang.String kind) {
            this.kind = kind;
            return this;
        }

        /**
         * Sets the value of {@link CfnResolverProps#getMaxBatchSize}
         * @param maxBatchSize The maximum number of resolver request inputs that will be sent to a single AWS Lambda function in a <code>BatchInvoke</code> operation.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxBatchSize(java.lang.Number maxBatchSize) {
            this.maxBatchSize = maxBatchSize;
            return this;
        }

        /**
         * Sets the value of {@link CfnResolverProps#getMetricsConfig}
         * @param metricsConfig Enables or disables enhanced resolver metrics for specified resolvers.
         *                      Note that <code>MetricsConfig</code> won't be used unless the <code>resolverLevelMetricsBehavior</code> value is set to <code>PER_RESOLVER_METRICS</code> . If the <code>resolverLevelMetricsBehavior</code> is set to <code>FULL_REQUEST_RESOLVER_METRICS</code> instead, <code>MetricsConfig</code> will be ignored. However, you can still set its value.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder metricsConfig(java.lang.String metricsConfig) {
            this.metricsConfig = metricsConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnResolverProps#getPipelineConfig}
         * @param pipelineConfig Functions linked with the pipeline resolver.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder pipelineConfig(software.amazon.awscdk.IResolvable pipelineConfig) {
            this.pipelineConfig = pipelineConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnResolverProps#getPipelineConfig}
         * @param pipelineConfig Functions linked with the pipeline resolver.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder pipelineConfig(software.amazon.awscdk.services.appsync.CfnResolver.PipelineConfigProperty pipelineConfig) {
            this.pipelineConfig = pipelineConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnResolverProps#getRequestMappingTemplate}
         * @param requestMappingTemplate The request mapping template.
         *                               Request mapping templates are optional when using a Lambda data source. For all other data sources, a request mapping template is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder requestMappingTemplate(java.lang.String requestMappingTemplate) {
            this.requestMappingTemplate = requestMappingTemplate;
            return this;
        }

        /**
         * Sets the value of {@link CfnResolverProps#getRequestMappingTemplateS3Location}
         * @param requestMappingTemplateS3Location The location of a request mapping template in an Amazon S3 bucket.
         *                                         Use this if you want to provision with a template file in Amazon S3 rather than embedding it in your CloudFormation template.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder requestMappingTemplateS3Location(java.lang.String requestMappingTemplateS3Location) {
            this.requestMappingTemplateS3Location = requestMappingTemplateS3Location;
            return this;
        }

        /**
         * Sets the value of {@link CfnResolverProps#getResponseMappingTemplate}
         * @param responseMappingTemplate The response mapping template.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder responseMappingTemplate(java.lang.String responseMappingTemplate) {
            this.responseMappingTemplate = responseMappingTemplate;
            return this;
        }

        /**
         * Sets the value of {@link CfnResolverProps#getResponseMappingTemplateS3Location}
         * @param responseMappingTemplateS3Location The location of a response mapping template in an Amazon S3 bucket.
         *                                          Use this if you want to provision with a template file in Amazon S3 rather than embedding it in your CloudFormation template.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder responseMappingTemplateS3Location(java.lang.String responseMappingTemplateS3Location) {
            this.responseMappingTemplateS3Location = responseMappingTemplateS3Location;
            return this;
        }

        /**
         * Sets the value of {@link CfnResolverProps#getRuntime}
         * @param runtime Describes a runtime used by an AWS AppSync resolver or AWS AppSync function.
         *                Specifies the name and version of the runtime to use. Note that if a runtime is specified, code must also be specified.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder runtime(software.amazon.awscdk.IResolvable runtime) {
            this.runtime = runtime;
            return this;
        }

        /**
         * Sets the value of {@link CfnResolverProps#getRuntime}
         * @param runtime Describes a runtime used by an AWS AppSync resolver or AWS AppSync function.
         *                Specifies the name and version of the runtime to use. Note that if a runtime is specified, code must also be specified.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder runtime(software.amazon.awscdk.services.appsync.CfnResolver.AppSyncRuntimeProperty runtime) {
            this.runtime = runtime;
            return this;
        }

        /**
         * Sets the value of {@link CfnResolverProps#getSyncConfig}
         * @param syncConfig The <code>SyncConfig</code> for a resolver attached to a versioned data source.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder syncConfig(software.amazon.awscdk.IResolvable syncConfig) {
            this.syncConfig = syncConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnResolverProps#getSyncConfig}
         * @param syncConfig The <code>SyncConfig</code> for a resolver attached to a versioned data source.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder syncConfig(software.amazon.awscdk.services.appsync.CfnResolver.SyncConfigProperty syncConfig) {
            this.syncConfig = syncConfig;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnResolverProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnResolverProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnResolverProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnResolverProps {
        private final java.lang.String apiId;
        private final java.lang.String fieldName;
        private final java.lang.String typeName;
        private final java.lang.Object cachingConfig;
        private final java.lang.String code;
        private final java.lang.String codeS3Location;
        private final java.lang.String dataSourceName;
        private final java.lang.String kind;
        private final java.lang.Number maxBatchSize;
        private final java.lang.String metricsConfig;
        private final java.lang.Object pipelineConfig;
        private final java.lang.String requestMappingTemplate;
        private final java.lang.String requestMappingTemplateS3Location;
        private final java.lang.String responseMappingTemplate;
        private final java.lang.String responseMappingTemplateS3Location;
        private final java.lang.Object runtime;
        private final java.lang.Object syncConfig;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.apiId = software.amazon.jsii.Kernel.get(this, "apiId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.fieldName = software.amazon.jsii.Kernel.get(this, "fieldName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.typeName = software.amazon.jsii.Kernel.get(this, "typeName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.cachingConfig = software.amazon.jsii.Kernel.get(this, "cachingConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.code = software.amazon.jsii.Kernel.get(this, "code", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.codeS3Location = software.amazon.jsii.Kernel.get(this, "codeS3Location", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.dataSourceName = software.amazon.jsii.Kernel.get(this, "dataSourceName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.kind = software.amazon.jsii.Kernel.get(this, "kind", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.maxBatchSize = software.amazon.jsii.Kernel.get(this, "maxBatchSize", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.metricsConfig = software.amazon.jsii.Kernel.get(this, "metricsConfig", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.pipelineConfig = software.amazon.jsii.Kernel.get(this, "pipelineConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.requestMappingTemplate = software.amazon.jsii.Kernel.get(this, "requestMappingTemplate", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.requestMappingTemplateS3Location = software.amazon.jsii.Kernel.get(this, "requestMappingTemplateS3Location", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.responseMappingTemplate = software.amazon.jsii.Kernel.get(this, "responseMappingTemplate", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.responseMappingTemplateS3Location = software.amazon.jsii.Kernel.get(this, "responseMappingTemplateS3Location", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.runtime = software.amazon.jsii.Kernel.get(this, "runtime", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.syncConfig = software.amazon.jsii.Kernel.get(this, "syncConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.apiId = java.util.Objects.requireNonNull(builder.apiId, "apiId is required");
            this.fieldName = java.util.Objects.requireNonNull(builder.fieldName, "fieldName is required");
            this.typeName = java.util.Objects.requireNonNull(builder.typeName, "typeName is required");
            this.cachingConfig = builder.cachingConfig;
            this.code = builder.code;
            this.codeS3Location = builder.codeS3Location;
            this.dataSourceName = builder.dataSourceName;
            this.kind = builder.kind;
            this.maxBatchSize = builder.maxBatchSize;
            this.metricsConfig = builder.metricsConfig;
            this.pipelineConfig = builder.pipelineConfig;
            this.requestMappingTemplate = builder.requestMappingTemplate;
            this.requestMappingTemplateS3Location = builder.requestMappingTemplateS3Location;
            this.responseMappingTemplate = builder.responseMappingTemplate;
            this.responseMappingTemplateS3Location = builder.responseMappingTemplateS3Location;
            this.runtime = builder.runtime;
            this.syncConfig = builder.syncConfig;
        }

        @Override
        public final java.lang.String getApiId() {
            return this.apiId;
        }

        @Override
        public final java.lang.String getFieldName() {
            return this.fieldName;
        }

        @Override
        public final java.lang.String getTypeName() {
            return this.typeName;
        }

        @Override
        public final java.lang.Object getCachingConfig() {
            return this.cachingConfig;
        }

        @Override
        public final java.lang.String getCode() {
            return this.code;
        }

        @Override
        public final java.lang.String getCodeS3Location() {
            return this.codeS3Location;
        }

        @Override
        public final java.lang.String getDataSourceName() {
            return this.dataSourceName;
        }

        @Override
        public final java.lang.String getKind() {
            return this.kind;
        }

        @Override
        public final java.lang.Number getMaxBatchSize() {
            return this.maxBatchSize;
        }

        @Override
        public final java.lang.String getMetricsConfig() {
            return this.metricsConfig;
        }

        @Override
        public final java.lang.Object getPipelineConfig() {
            return this.pipelineConfig;
        }

        @Override
        public final java.lang.String getRequestMappingTemplate() {
            return this.requestMappingTemplate;
        }

        @Override
        public final java.lang.String getRequestMappingTemplateS3Location() {
            return this.requestMappingTemplateS3Location;
        }

        @Override
        public final java.lang.String getResponseMappingTemplate() {
            return this.responseMappingTemplate;
        }

        @Override
        public final java.lang.String getResponseMappingTemplateS3Location() {
            return this.responseMappingTemplateS3Location;
        }

        @Override
        public final java.lang.Object getRuntime() {
            return this.runtime;
        }

        @Override
        public final java.lang.Object getSyncConfig() {
            return this.syncConfig;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("apiId", om.valueToTree(this.getApiId()));
            data.set("fieldName", om.valueToTree(this.getFieldName()));
            data.set("typeName", om.valueToTree(this.getTypeName()));
            if (this.getCachingConfig() != null) {
                data.set("cachingConfig", om.valueToTree(this.getCachingConfig()));
            }
            if (this.getCode() != null) {
                data.set("code", om.valueToTree(this.getCode()));
            }
            if (this.getCodeS3Location() != null) {
                data.set("codeS3Location", om.valueToTree(this.getCodeS3Location()));
            }
            if (this.getDataSourceName() != null) {
                data.set("dataSourceName", om.valueToTree(this.getDataSourceName()));
            }
            if (this.getKind() != null) {
                data.set("kind", om.valueToTree(this.getKind()));
            }
            if (this.getMaxBatchSize() != null) {
                data.set("maxBatchSize", om.valueToTree(this.getMaxBatchSize()));
            }
            if (this.getMetricsConfig() != null) {
                data.set("metricsConfig", om.valueToTree(this.getMetricsConfig()));
            }
            if (this.getPipelineConfig() != null) {
                data.set("pipelineConfig", om.valueToTree(this.getPipelineConfig()));
            }
            if (this.getRequestMappingTemplate() != null) {
                data.set("requestMappingTemplate", om.valueToTree(this.getRequestMappingTemplate()));
            }
            if (this.getRequestMappingTemplateS3Location() != null) {
                data.set("requestMappingTemplateS3Location", om.valueToTree(this.getRequestMappingTemplateS3Location()));
            }
            if (this.getResponseMappingTemplate() != null) {
                data.set("responseMappingTemplate", om.valueToTree(this.getResponseMappingTemplate()));
            }
            if (this.getResponseMappingTemplateS3Location() != null) {
                data.set("responseMappingTemplateS3Location", om.valueToTree(this.getResponseMappingTemplateS3Location()));
            }
            if (this.getRuntime() != null) {
                data.set("runtime", om.valueToTree(this.getRuntime()));
            }
            if (this.getSyncConfig() != null) {
                data.set("syncConfig", om.valueToTree(this.getSyncConfig()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appsync.CfnResolverProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnResolverProps.Jsii$Proxy that = (CfnResolverProps.Jsii$Proxy) o;

            if (!apiId.equals(that.apiId)) return false;
            if (!fieldName.equals(that.fieldName)) return false;
            if (!typeName.equals(that.typeName)) return false;
            if (this.cachingConfig != null ? !this.cachingConfig.equals(that.cachingConfig) : that.cachingConfig != null) return false;
            if (this.code != null ? !this.code.equals(that.code) : that.code != null) return false;
            if (this.codeS3Location != null ? !this.codeS3Location.equals(that.codeS3Location) : that.codeS3Location != null) return false;
            if (this.dataSourceName != null ? !this.dataSourceName.equals(that.dataSourceName) : that.dataSourceName != null) return false;
            if (this.kind != null ? !this.kind.equals(that.kind) : that.kind != null) return false;
            if (this.maxBatchSize != null ? !this.maxBatchSize.equals(that.maxBatchSize) : that.maxBatchSize != null) return false;
            if (this.metricsConfig != null ? !this.metricsConfig.equals(that.metricsConfig) : that.metricsConfig != null) return false;
            if (this.pipelineConfig != null ? !this.pipelineConfig.equals(that.pipelineConfig) : that.pipelineConfig != null) return false;
            if (this.requestMappingTemplate != null ? !this.requestMappingTemplate.equals(that.requestMappingTemplate) : that.requestMappingTemplate != null) return false;
            if (this.requestMappingTemplateS3Location != null ? !this.requestMappingTemplateS3Location.equals(that.requestMappingTemplateS3Location) : that.requestMappingTemplateS3Location != null) return false;
            if (this.responseMappingTemplate != null ? !this.responseMappingTemplate.equals(that.responseMappingTemplate) : that.responseMappingTemplate != null) return false;
            if (this.responseMappingTemplateS3Location != null ? !this.responseMappingTemplateS3Location.equals(that.responseMappingTemplateS3Location) : that.responseMappingTemplateS3Location != null) return false;
            if (this.runtime != null ? !this.runtime.equals(that.runtime) : that.runtime != null) return false;
            return this.syncConfig != null ? this.syncConfig.equals(that.syncConfig) : that.syncConfig == null;
        }

        @Override
        public final int hashCode() {
            int result = this.apiId.hashCode();
            result = 31 * result + (this.fieldName.hashCode());
            result = 31 * result + (this.typeName.hashCode());
            result = 31 * result + (this.cachingConfig != null ? this.cachingConfig.hashCode() : 0);
            result = 31 * result + (this.code != null ? this.code.hashCode() : 0);
            result = 31 * result + (this.codeS3Location != null ? this.codeS3Location.hashCode() : 0);
            result = 31 * result + (this.dataSourceName != null ? this.dataSourceName.hashCode() : 0);
            result = 31 * result + (this.kind != null ? this.kind.hashCode() : 0);
            result = 31 * result + (this.maxBatchSize != null ? this.maxBatchSize.hashCode() : 0);
            result = 31 * result + (this.metricsConfig != null ? this.metricsConfig.hashCode() : 0);
            result = 31 * result + (this.pipelineConfig != null ? this.pipelineConfig.hashCode() : 0);
            result = 31 * result + (this.requestMappingTemplate != null ? this.requestMappingTemplate.hashCode() : 0);
            result = 31 * result + (this.requestMappingTemplateS3Location != null ? this.requestMappingTemplateS3Location.hashCode() : 0);
            result = 31 * result + (this.responseMappingTemplate != null ? this.responseMappingTemplate.hashCode() : 0);
            result = 31 * result + (this.responseMappingTemplateS3Location != null ? this.responseMappingTemplateS3Location.hashCode() : 0);
            result = 31 * result + (this.runtime != null ? this.runtime.hashCode() : 0);
            result = 31 * result + (this.syncConfig != null ? this.syncConfig.hashCode() : 0);
            return result;
        }
    }
}
