package software.amazon.awscdk.services.autoscaling;

/**
 * Properties for defining a <code>CfnWarmPool</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.autoscaling.*;
 * CfnWarmPoolProps cfnWarmPoolProps = CfnWarmPoolProps.builder()
 *         .autoScalingGroupName("autoScalingGroupName")
 *         // the properties below are optional
 *         .instanceReusePolicy(InstanceReusePolicyProperty.builder()
 *                 .reuseOnScaleIn(false)
 *                 .build())
 *         .maxGroupPreparedCapacity(123)
 *         .minSize(123)
 *         .poolState("poolState")
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-autoscaling-warmpool.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-autoscaling-warmpool.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-01-25T00:20:51.205Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_autoscaling.CfnWarmPoolProps")
@software.amazon.jsii.Jsii.Proxy(CfnWarmPoolProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnWarmPoolProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The name of the Auto Scaling group.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-autoscaling-warmpool.html#cfn-autoscaling-warmpool-autoscalinggroupname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-autoscaling-warmpool.html#cfn-autoscaling-warmpool-autoscalinggroupname</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getAutoScalingGroupName();

    /**
     * Indicates whether instances in the Auto Scaling group can be returned to the warm pool on scale in.
     * <p>
     * The default is to terminate instances in the Auto Scaling group when the group scales in.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-autoscaling-warmpool.html#cfn-autoscaling-warmpool-instancereusepolicy">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-autoscaling-warmpool.html#cfn-autoscaling-warmpool-instancereusepolicy</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getInstanceReusePolicy() {
        return null;
    }

    /**
     * Specifies the maximum number of instances that are allowed to be in the warm pool or in any state except <code>Terminated</code> for the Auto Scaling group.
     * <p>
     * This is an optional property. Specify it only if you do not want the warm pool size to be determined by the difference between the group's maximum capacity and its desired capacity.
     * <p>
     * <blockquote>
     * <p>
     * If a value for <code>MaxGroupPreparedCapacity</code> is not specified, Amazon EC2 Auto Scaling launches and maintains the difference between the group's maximum capacity and its desired capacity. If you specify a value for <code>MaxGroupPreparedCapacity</code> , Amazon EC2 Auto Scaling uses the difference between the <code>MaxGroupPreparedCapacity</code> and the desired capacity instead.
     * <p>
     * The size of the warm pool is dynamic. Only when <code>MaxGroupPreparedCapacity</code> and <code>MinSize</code> are set to the same value does the warm pool have an absolute size.
     * <p>
     * </blockquote>
     * <p>
     * If the desired capacity of the Auto Scaling group is higher than the <code>MaxGroupPreparedCapacity</code> , the capacity of the warm pool is 0, unless you specify a value for <code>MinSize</code> . To remove a value that you previously set, include the property but specify -1 for the value.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-autoscaling-warmpool.html#cfn-autoscaling-warmpool-maxgrouppreparedcapacity">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-autoscaling-warmpool.html#cfn-autoscaling-warmpool-maxgrouppreparedcapacity</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getMaxGroupPreparedCapacity() {
        return null;
    }

    /**
     * Specifies the minimum number of instances to maintain in the warm pool.
     * <p>
     * This helps you to ensure that there is always a certain number of warmed instances available to handle traffic spikes. Defaults to 0 if not specified.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-autoscaling-warmpool.html#cfn-autoscaling-warmpool-minsize">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-autoscaling-warmpool.html#cfn-autoscaling-warmpool-minsize</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getMinSize() {
        return null;
    }

    /**
     * Sets the instance state to transition to after the lifecycle actions are complete.
     * <p>
     * Default is <code>Stopped</code> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-autoscaling-warmpool.html#cfn-autoscaling-warmpool-poolstate">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-autoscaling-warmpool.html#cfn-autoscaling-warmpool-poolstate</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getPoolState() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnWarmPoolProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnWarmPoolProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnWarmPoolProps> {
        java.lang.String autoScalingGroupName;
        java.lang.Object instanceReusePolicy;
        java.lang.Number maxGroupPreparedCapacity;
        java.lang.Number minSize;
        java.lang.String poolState;

        /**
         * Sets the value of {@link CfnWarmPoolProps#getAutoScalingGroupName}
         * @param autoScalingGroupName The name of the Auto Scaling group. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder autoScalingGroupName(java.lang.String autoScalingGroupName) {
            this.autoScalingGroupName = autoScalingGroupName;
            return this;
        }

        /**
         * Sets the value of {@link CfnWarmPoolProps#getInstanceReusePolicy}
         * @param instanceReusePolicy Indicates whether instances in the Auto Scaling group can be returned to the warm pool on scale in.
         *                            The default is to terminate instances in the Auto Scaling group when the group scales in.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder instanceReusePolicy(software.amazon.awscdk.IResolvable instanceReusePolicy) {
            this.instanceReusePolicy = instanceReusePolicy;
            return this;
        }

        /**
         * Sets the value of {@link CfnWarmPoolProps#getInstanceReusePolicy}
         * @param instanceReusePolicy Indicates whether instances in the Auto Scaling group can be returned to the warm pool on scale in.
         *                            The default is to terminate instances in the Auto Scaling group when the group scales in.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder instanceReusePolicy(software.amazon.awscdk.services.autoscaling.CfnWarmPool.InstanceReusePolicyProperty instanceReusePolicy) {
            this.instanceReusePolicy = instanceReusePolicy;
            return this;
        }

        /**
         * Sets the value of {@link CfnWarmPoolProps#getMaxGroupPreparedCapacity}
         * @param maxGroupPreparedCapacity Specifies the maximum number of instances that are allowed to be in the warm pool or in any state except <code>Terminated</code> for the Auto Scaling group.
         *                                 This is an optional property. Specify it only if you do not want the warm pool size to be determined by the difference between the group's maximum capacity and its desired capacity.
         *                                 <p>
         *                                 <blockquote>
         *                                 <p>
         *                                 If a value for <code>MaxGroupPreparedCapacity</code> is not specified, Amazon EC2 Auto Scaling launches and maintains the difference between the group's maximum capacity and its desired capacity. If you specify a value for <code>MaxGroupPreparedCapacity</code> , Amazon EC2 Auto Scaling uses the difference between the <code>MaxGroupPreparedCapacity</code> and the desired capacity instead.
         *                                 <p>
         *                                 The size of the warm pool is dynamic. Only when <code>MaxGroupPreparedCapacity</code> and <code>MinSize</code> are set to the same value does the warm pool have an absolute size.
         *                                 <p>
         *                                 </blockquote>
         *                                 <p>
         *                                 If the desired capacity of the Auto Scaling group is higher than the <code>MaxGroupPreparedCapacity</code> , the capacity of the warm pool is 0, unless you specify a value for <code>MinSize</code> . To remove a value that you previously set, include the property but specify -1 for the value.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxGroupPreparedCapacity(java.lang.Number maxGroupPreparedCapacity) {
            this.maxGroupPreparedCapacity = maxGroupPreparedCapacity;
            return this;
        }

        /**
         * Sets the value of {@link CfnWarmPoolProps#getMinSize}
         * @param minSize Specifies the minimum number of instances to maintain in the warm pool.
         *                This helps you to ensure that there is always a certain number of warmed instances available to handle traffic spikes. Defaults to 0 if not specified.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder minSize(java.lang.Number minSize) {
            this.minSize = minSize;
            return this;
        }

        /**
         * Sets the value of {@link CfnWarmPoolProps#getPoolState}
         * @param poolState Sets the instance state to transition to after the lifecycle actions are complete.
         *                  Default is <code>Stopped</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder poolState(java.lang.String poolState) {
            this.poolState = poolState;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnWarmPoolProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnWarmPoolProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnWarmPoolProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnWarmPoolProps {
        private final java.lang.String autoScalingGroupName;
        private final java.lang.Object instanceReusePolicy;
        private final java.lang.Number maxGroupPreparedCapacity;
        private final java.lang.Number minSize;
        private final java.lang.String poolState;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.autoScalingGroupName = software.amazon.jsii.Kernel.get(this, "autoScalingGroupName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.instanceReusePolicy = software.amazon.jsii.Kernel.get(this, "instanceReusePolicy", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.maxGroupPreparedCapacity = software.amazon.jsii.Kernel.get(this, "maxGroupPreparedCapacity", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.minSize = software.amazon.jsii.Kernel.get(this, "minSize", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.poolState = software.amazon.jsii.Kernel.get(this, "poolState", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.autoScalingGroupName = java.util.Objects.requireNonNull(builder.autoScalingGroupName, "autoScalingGroupName is required");
            this.instanceReusePolicy = builder.instanceReusePolicy;
            this.maxGroupPreparedCapacity = builder.maxGroupPreparedCapacity;
            this.minSize = builder.minSize;
            this.poolState = builder.poolState;
        }

        @Override
        public final java.lang.String getAutoScalingGroupName() {
            return this.autoScalingGroupName;
        }

        @Override
        public final java.lang.Object getInstanceReusePolicy() {
            return this.instanceReusePolicy;
        }

        @Override
        public final java.lang.Number getMaxGroupPreparedCapacity() {
            return this.maxGroupPreparedCapacity;
        }

        @Override
        public final java.lang.Number getMinSize() {
            return this.minSize;
        }

        @Override
        public final java.lang.String getPoolState() {
            return this.poolState;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("autoScalingGroupName", om.valueToTree(this.getAutoScalingGroupName()));
            if (this.getInstanceReusePolicy() != null) {
                data.set("instanceReusePolicy", om.valueToTree(this.getInstanceReusePolicy()));
            }
            if (this.getMaxGroupPreparedCapacity() != null) {
                data.set("maxGroupPreparedCapacity", om.valueToTree(this.getMaxGroupPreparedCapacity()));
            }
            if (this.getMinSize() != null) {
                data.set("minSize", om.valueToTree(this.getMinSize()));
            }
            if (this.getPoolState() != null) {
                data.set("poolState", om.valueToTree(this.getPoolState()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_autoscaling.CfnWarmPoolProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnWarmPoolProps.Jsii$Proxy that = (CfnWarmPoolProps.Jsii$Proxy) o;

            if (!autoScalingGroupName.equals(that.autoScalingGroupName)) return false;
            if (this.instanceReusePolicy != null ? !this.instanceReusePolicy.equals(that.instanceReusePolicy) : that.instanceReusePolicy != null) return false;
            if (this.maxGroupPreparedCapacity != null ? !this.maxGroupPreparedCapacity.equals(that.maxGroupPreparedCapacity) : that.maxGroupPreparedCapacity != null) return false;
            if (this.minSize != null ? !this.minSize.equals(that.minSize) : that.minSize != null) return false;
            return this.poolState != null ? this.poolState.equals(that.poolState) : that.poolState == null;
        }

        @Override
        public final int hashCode() {
            int result = this.autoScalingGroupName.hashCode();
            result = 31 * result + (this.instanceReusePolicy != null ? this.instanceReusePolicy.hashCode() : 0);
            result = 31 * result + (this.maxGroupPreparedCapacity != null ? this.maxGroupPreparedCapacity.hashCode() : 0);
            result = 31 * result + (this.minSize != null ? this.minSize.hashCode() : 0);
            result = 31 * result + (this.poolState != null ? this.poolState.hashCode() : 0);
            return result;
        }
    }
}
