package software.amazon.awscdk.services.autoscaling;

/**
 * A set of group metrics.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Vpc vpc;
 * InstanceType instanceType;
 * IMachineImage machineImage;
 * // Enable monitoring of all group metrics
 * // Enable monitoring of all group metrics
 * AutoScalingGroup.Builder.create(this, "ASG")
 *         .vpc(vpc)
 *         .instanceType(instanceType)
 *         .machineImage(machineImage)
 *         // ...
 *         .groupMetrics(List.of(GroupMetrics.all()))
 *         .build();
 * // Enable monitoring for a subset of group metrics
 * // Enable monitoring for a subset of group metrics
 * AutoScalingGroup.Builder.create(this, "ASG")
 *         .vpc(vpc)
 *         .instanceType(instanceType)
 *         .machineImage(machineImage)
 *         // ...
 *         .groupMetrics(List.of(new GroupMetrics(GroupMetric.MIN_SIZE, GroupMetric.MAX_SIZE)))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-01-25T00:20:51.213Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_autoscaling.GroupMetrics")
public class GroupMetrics extends software.amazon.jsii.JsiiObject {

    protected GroupMetrics(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected GroupMetrics(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param metrics This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public GroupMetrics(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.autoscaling.GroupMetric... metrics) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, java.util.Arrays.<Object>stream(metrics).toArray(Object[]::new));
    }

    /**
     * Report all group metrics.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.autoscaling.GroupMetrics all() {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.autoscaling.GroupMetrics.class, "all", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.autoscaling.GroupMetrics.class));
    }
}
