package software.amazon.awscdk.services.batch;

/**
 * A Kubernetes HostPath volume.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.batch.*;
 * HostPathVolume hostPathVolume = HostPathVolume.Builder.create()
 *         .hostPath("hostPath")
 *         .name("name")
 *         // the properties below are optional
 *         .mountPath("mountPath")
 *         .readonly(false)
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="https://kubernetes.io/docs/concepts/storage/volumes/#hostpath">https://kubernetes.io/docs/concepts/storage/volumes/#hostpath</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-01-25T00:20:51.481Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_batch.HostPathVolume")
public class HostPathVolume extends software.amazon.awscdk.services.batch.EksVolume {

    protected HostPathVolume(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected HostPathVolume(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param options This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public HostPathVolume(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.batch.HostPathVolumeOptions options) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(options, "options is required") });
    }

    /**
     * returns <code>true</code> if <code>x</code> is a HostPathVolume, <code>false</code> otherwise.
     * <p>
     * @param x This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.lang.Boolean isHostPathVolume(final @org.jetbrains.annotations.NotNull java.lang.Object x) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.batch.HostPathVolume.class, "isHostPathVolume", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class), new Object[] { x });
    }

    /**
     * The path of the file or directory on the host to mount into containers on the pod.
     * <p>
     * <em>Note</em>: HothPath Volumes present many security risks, and should be avoided when possible.
     * <p>
     * @see <a href="https://kubernetes.io/docs/concepts/storage/volumes/#hostpath">https://kubernetes.io/docs/concepts/storage/volumes/#hostpath</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getPath() {
        return software.amazon.jsii.Kernel.get(this, "path", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.batch.HostPathVolume}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.batch.HostPathVolume> {
        /**
         * @return a new instance of {@link Builder}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create() {
            return new Builder();
        }

        private final software.amazon.awscdk.services.batch.HostPathVolumeOptions.Builder options;

        private Builder() {
            this.options = new software.amazon.awscdk.services.batch.HostPathVolumeOptions.Builder();
        }

        /**
         * The name of this volume.
         * <p>
         * The name must be a valid DNS subdomain name.
         * <p>
         * @return {@code this}
         * @see <a href="https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#dns-subdomain-names">https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#dns-subdomain-names</a>
         * @param name The name of this volume. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(final java.lang.String name) {
            this.options.name(name);
            return this;
        }

        /**
         * The path on the container where the volume is mounted.
         * <p>
         * Default: - the volume is not mounted
         * <p>
         * @return {@code this}
         * @param mountPath The path on the container where the volume is mounted. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder mountPath(final java.lang.String mountPath) {
            this.options.mountPath(mountPath);
            return this;
        }

        /**
         * If specified, the container has readonly access to the volume.
         * <p>
         * Otherwise, the container has read/write access.
         * <p>
         * Default: false
         * <p>
         * @return {@code this}
         * @param readonly If specified, the container has readonly access to the volume. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder readonly(final java.lang.Boolean readonly) {
            this.options.readonly(readonly);
            return this;
        }

        /**
         * The path of the file or directory on the host to mount into containers on the pod.
         * <p>
         * <em>Note</em>: HothPath Volumes present many security risks, and should be avoided when possible.
         * <p>
         * @return {@code this}
         * @see <a href="https://kubernetes.io/docs/concepts/storage/volumes/#hostpath">https://kubernetes.io/docs/concepts/storage/volumes/#hostpath</a>
         * @param hostPath The path of the file or directory on the host to mount into containers on the pod. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder hostPath(final java.lang.String hostPath) {
            this.options.hostPath(hostPath);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.batch.HostPathVolume}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.batch.HostPathVolume build() {
            return new software.amazon.awscdk.services.batch.HostPathVolume(
                this.options.build()
            );
        }
    }
}
