package software.amazon.awscdk.services.batch;

/**
 * Unmanaged ComputeEnvironments do not provision or manage EC2 instances on your behalf.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.batch.*;
 * import software.amazon.awscdk.services.iam.*;
 * Role role;
 * UnmanagedComputeEnvironment unmanagedComputeEnvironment = UnmanagedComputeEnvironment.Builder.create(this, "MyUnmanagedComputeEnvironment")
 *         .computeEnvironmentName("computeEnvironmentName")
 *         .enabled(false)
 *         .serviceRole(role)
 *         .unmanagedvCpus(123)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-01-25T00:20:51.556Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_batch.UnmanagedComputeEnvironment")
public class UnmanagedComputeEnvironment extends software.amazon.awscdk.Resource implements software.amazon.awscdk.services.batch.IUnmanagedComputeEnvironment, software.amazon.awscdk.services.batch.IComputeEnvironment {

    protected UnmanagedComputeEnvironment(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected UnmanagedComputeEnvironment(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public UnmanagedComputeEnvironment(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.batch.UnmanagedComputeEnvironmentProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), props });
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public UnmanagedComputeEnvironment(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * Import an UnmanagedComputeEnvironment by its arn.
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param unmanagedComputeEnvironmentArn This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.batch.IUnmanagedComputeEnvironment fromUnmanagedComputeEnvironmentArn(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull java.lang.String unmanagedComputeEnvironmentArn) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.batch.UnmanagedComputeEnvironment.class, "fromUnmanagedComputeEnvironmentArn", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.batch.IUnmanagedComputeEnvironment.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(unmanagedComputeEnvironmentArn, "unmanagedComputeEnvironmentArn is required") });
    }

    /**
     * The ARN of this compute environment.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getComputeEnvironmentArn() {
        return software.amazon.jsii.Kernel.get(this, "computeEnvironmentArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the ComputeEnvironment.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getComputeEnvironmentName() {
        return software.amazon.jsii.Kernel.get(this, "computeEnvironmentName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Whether or not this ComputeEnvironment can accept jobs from a Queue.
     * <p>
     * Enabled ComputeEnvironments can accept jobs from a Queue and
     * can scale instances up or down.
     * Disabled ComputeEnvironments cannot accept jobs from a Queue or
     * scale instances up or down.
     * <p>
     * If you change a ComputeEnvironment from enabled to disabled while it is executing jobs,
     * Jobs in the <code>STARTED</code> or <code>RUNNING</code> states will not
     * be interrupted. As jobs complete, the ComputeEnvironment will scale instances down to <code>minvCpus</code>.
     * <p>
     * To ensure you aren't billed for unused capacity, set <code>minvCpus</code> to <code>0</code>.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Boolean getEnabled() {
        return software.amazon.jsii.Kernel.get(this, "enabled", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
    }

    /**
     * The role Batch uses to perform actions on your behalf in your account, such as provision instances to run your jobs.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.iam.IRole getServiceRole() {
        return software.amazon.jsii.Kernel.get(this, "serviceRole", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IRole.class));
    }

    /**
     * The vCPUs this Compute Environment provides. Used only by the scheduler to schedule jobs in <code>Queue</code>s that use <code>FairshareSchedulingPolicy</code>s.
     * <p>
     * <strong>If this parameter is not provided on a fairshare queue, no capacity is reserved</strong>;
     * that is, the <code>FairshareSchedulingPolicy</code> is ignored.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Number getUnmanagedvCPUs() {
        return software.amazon.jsii.Kernel.get(this, "unmanagedvCPUs", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.batch.UnmanagedComputeEnvironment}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.batch.UnmanagedComputeEnvironment> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private software.amazon.awscdk.services.batch.UnmanagedComputeEnvironmentProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
        }

        /**
         * The name of the ComputeEnvironment.
         * <p>
         * Default: - generated by CloudFormation
         * <p>
         * @return {@code this}
         * @param computeEnvironmentName The name of the ComputeEnvironment. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder computeEnvironmentName(final java.lang.String computeEnvironmentName) {
            this.props().computeEnvironmentName(computeEnvironmentName);
            return this;
        }

        /**
         * Whether or not this ComputeEnvironment can accept jobs from a Queue.
         * <p>
         * Enabled ComputeEnvironments can accept jobs from a Queue and
         * can scale instances up or down.
         * Disabled ComputeEnvironments cannot accept jobs from a Queue or
         * scale instances up or down.
         * <p>
         * If you change a ComputeEnvironment from enabled to disabled while it is executing jobs,
         * Jobs in the <code>STARTED</code> or <code>RUNNING</code> states will not
         * be interrupted. As jobs complete, the ComputeEnvironment will scale instances down to <code>minvCpus</code>.
         * <p>
         * To ensure you aren't billed for unused capacity, set <code>minvCpus</code> to <code>0</code>.
         * <p>
         * Default: true
         * <p>
         * @return {@code this}
         * @param enabled Whether or not this ComputeEnvironment can accept jobs from a Queue. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enabled(final java.lang.Boolean enabled) {
            this.props().enabled(enabled);
            return this;
        }

        /**
         * The role Batch uses to perform actions on your behalf in your account, such as provision instances to run your jobs.
         * <p>
         * Default: - a serviceRole will be created for managed CEs, none for unmanaged CEs
         * <p>
         * @return {@code this}
         * @param serviceRole The role Batch uses to perform actions on your behalf in your account, such as provision instances to run your jobs. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder serviceRole(final software.amazon.awscdk.services.iam.IRole serviceRole) {
            this.props().serviceRole(serviceRole);
            return this;
        }

        /**
         * The vCPUs this Compute Environment provides. Used only by the scheduler to schedule jobs in <code>Queue</code>s that use <code>FairshareSchedulingPolicy</code>s.
         * <p>
         * <strong>If this parameter is not provided on a fairshare queue, no capacity is reserved</strong>;
         * that is, the <code>FairshareSchedulingPolicy</code> is ignored.
         * <p>
         * Default: 0
         * <p>
         * @return {@code this}
         * @param unmanagedvCpus The vCPUs this Compute Environment provides. Used only by the scheduler to schedule jobs in <code>Queue</code>s that use <code>FairshareSchedulingPolicy</code>s. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder unmanagedvCpus(final java.lang.Number unmanagedvCpus) {
            this.props().unmanagedvCpus(unmanagedvCpus);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.batch.UnmanagedComputeEnvironment}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.batch.UnmanagedComputeEnvironment build() {
            return new software.amazon.awscdk.services.batch.UnmanagedComputeEnvironment(
                this.scope,
                this.id,
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.services.batch.UnmanagedComputeEnvironmentProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.services.batch.UnmanagedComputeEnvironmentProps.Builder();
            }
            return this.props;
        }
    }
}
