package software.amazon.awscdk.services.bedrock;

/**
 * Properties for defining a <code>CfnDataSource</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.bedrock.*;
 * CfnDataSourceProps cfnDataSourceProps = CfnDataSourceProps.builder()
 *         .dataSourceConfiguration(DataSourceConfigurationProperty.builder()
 *                 .type("type")
 *                 // the properties below are optional
 *                 .confluenceConfiguration(ConfluenceDataSourceConfigurationProperty.builder()
 *                         .sourceConfiguration(ConfluenceSourceConfigurationProperty.builder()
 *                                 .authType("authType")
 *                                 .credentialsSecretArn("credentialsSecretArn")
 *                                 .hostType("hostType")
 *                                 .hostUrl("hostUrl")
 *                                 .build())
 *                         // the properties below are optional
 *                         .crawlerConfiguration(ConfluenceCrawlerConfigurationProperty.builder()
 *                                 .filterConfiguration(CrawlFilterConfigurationProperty.builder()
 *                                         .type("type")
 *                                         // the properties below are optional
 *                                         .patternObjectFilter(PatternObjectFilterConfigurationProperty.builder()
 *                                                 .filters(List.of(PatternObjectFilterProperty.builder()
 *                                                         .objectType("objectType")
 *                                                         // the properties below are optional
 *                                                         .exclusionFilters(List.of("exclusionFilters"))
 *                                                         .inclusionFilters(List.of("inclusionFilters"))
 *                                                         .build()))
 *                                                 .build())
 *                                         .build())
 *                                 .build())
 *                         .build())
 *                 .s3Configuration(S3DataSourceConfigurationProperty.builder()
 *                         .bucketArn("bucketArn")
 *                         // the properties below are optional
 *                         .bucketOwnerAccountId("bucketOwnerAccountId")
 *                         .inclusionPrefixes(List.of("inclusionPrefixes"))
 *                         .build())
 *                 .salesforceConfiguration(SalesforceDataSourceConfigurationProperty.builder()
 *                         .sourceConfiguration(SalesforceSourceConfigurationProperty.builder()
 *                                 .authType("authType")
 *                                 .credentialsSecretArn("credentialsSecretArn")
 *                                 .hostUrl("hostUrl")
 *                                 .build())
 *                         // the properties below are optional
 *                         .crawlerConfiguration(SalesforceCrawlerConfigurationProperty.builder()
 *                                 .filterConfiguration(CrawlFilterConfigurationProperty.builder()
 *                                         .type("type")
 *                                         // the properties below are optional
 *                                         .patternObjectFilter(PatternObjectFilterConfigurationProperty.builder()
 *                                                 .filters(List.of(PatternObjectFilterProperty.builder()
 *                                                         .objectType("objectType")
 *                                                         // the properties below are optional
 *                                                         .exclusionFilters(List.of("exclusionFilters"))
 *                                                         .inclusionFilters(List.of("inclusionFilters"))
 *                                                         .build()))
 *                                                 .build())
 *                                         .build())
 *                                 .build())
 *                         .build())
 *                 .sharePointConfiguration(SharePointDataSourceConfigurationProperty.builder()
 *                         .sourceConfiguration(SharePointSourceConfigurationProperty.builder()
 *                                 .authType("authType")
 *                                 .credentialsSecretArn("credentialsSecretArn")
 *                                 .domain("domain")
 *                                 .hostType("hostType")
 *                                 .siteUrls(List.of("siteUrls"))
 *                                 // the properties below are optional
 *                                 .tenantId("tenantId")
 *                                 .build())
 *                         // the properties below are optional
 *                         .crawlerConfiguration(SharePointCrawlerConfigurationProperty.builder()
 *                                 .filterConfiguration(CrawlFilterConfigurationProperty.builder()
 *                                         .type("type")
 *                                         // the properties below are optional
 *                                         .patternObjectFilter(PatternObjectFilterConfigurationProperty.builder()
 *                                                 .filters(List.of(PatternObjectFilterProperty.builder()
 *                                                         .objectType("objectType")
 *                                                         // the properties below are optional
 *                                                         .exclusionFilters(List.of("exclusionFilters"))
 *                                                         .inclusionFilters(List.of("inclusionFilters"))
 *                                                         .build()))
 *                                                 .build())
 *                                         .build())
 *                                 .build())
 *                         .build())
 *                 .webConfiguration(WebDataSourceConfigurationProperty.builder()
 *                         .sourceConfiguration(WebSourceConfigurationProperty.builder()
 *                                 .urlConfiguration(UrlConfigurationProperty.builder()
 *                                         .seedUrls(List.of(SeedUrlProperty.builder()
 *                                                 .url("url")
 *                                                 .build()))
 *                                         .build())
 *                                 .build())
 *                         // the properties below are optional
 *                         .crawlerConfiguration(WebCrawlerConfigurationProperty.builder()
 *                                 .crawlerLimits(WebCrawlerLimitsProperty.builder()
 *                                         .rateLimit(123)
 *                                         .build())
 *                                 .exclusionFilters(List.of("exclusionFilters"))
 *                                 .inclusionFilters(List.of("inclusionFilters"))
 *                                 .scope("scope")
 *                                 .build())
 *                         .build())
 *                 .build())
 *         .knowledgeBaseId("knowledgeBaseId")
 *         .name("name")
 *         // the properties below are optional
 *         .dataDeletionPolicy("dataDeletionPolicy")
 *         .description("description")
 *         .serverSideEncryptionConfiguration(ServerSideEncryptionConfigurationProperty.builder()
 *                 .kmsKeyArn("kmsKeyArn")
 *                 .build())
 *         .vectorIngestionConfiguration(VectorIngestionConfigurationProperty.builder()
 *                 .chunkingConfiguration(ChunkingConfigurationProperty.builder()
 *                         .chunkingStrategy("chunkingStrategy")
 *                         // the properties below are optional
 *                         .fixedSizeChunkingConfiguration(FixedSizeChunkingConfigurationProperty.builder()
 *                                 .maxTokens(123)
 *                                 .overlapPercentage(123)
 *                                 .build())
 *                         .hierarchicalChunkingConfiguration(HierarchicalChunkingConfigurationProperty.builder()
 *                                 .levelConfigurations(List.of(HierarchicalChunkingLevelConfigurationProperty.builder()
 *                                         .maxTokens(123)
 *                                         .build()))
 *                                 .overlapTokens(123)
 *                                 .build())
 *                         .semanticChunkingConfiguration(SemanticChunkingConfigurationProperty.builder()
 *                                 .breakpointPercentileThreshold(123)
 *                                 .bufferSize(123)
 *                                 .maxTokens(123)
 *                                 .build())
 *                         .build())
 *                 .customTransformationConfiguration(CustomTransformationConfigurationProperty.builder()
 *                         .intermediateStorage(IntermediateStorageProperty.builder()
 *                                 .s3Location(S3LocationProperty.builder()
 *                                         .uri("uri")
 *                                         .build())
 *                                 .build())
 *                         .transformations(List.of(TransformationProperty.builder()
 *                                 .stepToApply("stepToApply")
 *                                 .transformationFunction(TransformationFunctionProperty.builder()
 *                                         .transformationLambdaConfiguration(TransformationLambdaConfigurationProperty.builder()
 *                                                 .lambdaArn("lambdaArn")
 *                                                 .build())
 *                                         .build())
 *                                 .build()))
 *                         .build())
 *                 .parsingConfiguration(ParsingConfigurationProperty.builder()
 *                         .parsingStrategy("parsingStrategy")
 *                         // the properties below are optional
 *                         .bedrockDataAutomationConfiguration(BedrockDataAutomationConfigurationProperty.builder()
 *                                 .parsingModality("parsingModality")
 *                                 .build())
 *                         .bedrockFoundationModelConfiguration(BedrockFoundationModelConfigurationProperty.builder()
 *                                 .modelArn("modelArn")
 *                                 // the properties below are optional
 *                                 .parsingModality("parsingModality")
 *                                 .parsingPrompt(ParsingPromptProperty.builder()
 *                                         .parsingPromptText("parsingPromptText")
 *                                         .build())
 *                                 .build())
 *                         .build())
 *                 .build())
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-datasource.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-datasource.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-01-25T00:20:51.612Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_bedrock.CfnDataSourceProps")
@software.amazon.jsii.Jsii.Proxy(CfnDataSourceProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnDataSourceProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The connection configuration for the data source.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-datasource.html#cfn-bedrock-datasource-datasourceconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-datasource.html#cfn-bedrock-datasource-datasourceconfiguration</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getDataSourceConfiguration();

    /**
     * The unique identifier of the knowledge base to which the data source belongs.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-datasource.html#cfn-bedrock-datasource-knowledgebaseid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-datasource.html#cfn-bedrock-datasource-knowledgebaseid</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getKnowledgeBaseId();

    /**
     * The name of the data source.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-datasource.html#cfn-bedrock-datasource-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-datasource.html#cfn-bedrock-datasource-name</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getName();

    /**
     * The data deletion policy for the data source.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-datasource.html#cfn-bedrock-datasource-datadeletionpolicy">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-datasource.html#cfn-bedrock-datasource-datadeletionpolicy</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDataDeletionPolicy() {
        return null;
    }

    /**
     * The description of the data source.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-datasource.html#cfn-bedrock-datasource-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-datasource.html#cfn-bedrock-datasource-description</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return null;
    }

    /**
     * Contains details about the configuration of the server-side encryption.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-datasource.html#cfn-bedrock-datasource-serversideencryptionconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-datasource.html#cfn-bedrock-datasource-serversideencryptionconfiguration</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getServerSideEncryptionConfiguration() {
        return null;
    }

    /**
     * Contains details about how to ingest the documents in the data source.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-datasource.html#cfn-bedrock-datasource-vectoringestionconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-datasource.html#cfn-bedrock-datasource-vectoringestionconfiguration</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getVectorIngestionConfiguration() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnDataSourceProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnDataSourceProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnDataSourceProps> {
        java.lang.Object dataSourceConfiguration;
        java.lang.String knowledgeBaseId;
        java.lang.String name;
        java.lang.String dataDeletionPolicy;
        java.lang.String description;
        java.lang.Object serverSideEncryptionConfiguration;
        java.lang.Object vectorIngestionConfiguration;

        /**
         * Sets the value of {@link CfnDataSourceProps#getDataSourceConfiguration}
         * @param dataSourceConfiguration The connection configuration for the data source. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dataSourceConfiguration(software.amazon.awscdk.IResolvable dataSourceConfiguration) {
            this.dataSourceConfiguration = dataSourceConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnDataSourceProps#getDataSourceConfiguration}
         * @param dataSourceConfiguration The connection configuration for the data source. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dataSourceConfiguration(software.amazon.awscdk.services.bedrock.CfnDataSource.DataSourceConfigurationProperty dataSourceConfiguration) {
            this.dataSourceConfiguration = dataSourceConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnDataSourceProps#getKnowledgeBaseId}
         * @param knowledgeBaseId The unique identifier of the knowledge base to which the data source belongs. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder knowledgeBaseId(java.lang.String knowledgeBaseId) {
            this.knowledgeBaseId = knowledgeBaseId;
            return this;
        }

        /**
         * Sets the value of {@link CfnDataSourceProps#getName}
         * @param name The name of the data source. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of {@link CfnDataSourceProps#getDataDeletionPolicy}
         * @param dataDeletionPolicy The data deletion policy for the data source.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dataDeletionPolicy(java.lang.String dataDeletionPolicy) {
            this.dataDeletionPolicy = dataDeletionPolicy;
            return this;
        }

        /**
         * Sets the value of {@link CfnDataSourceProps#getDescription}
         * @param description The description of the data source.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link CfnDataSourceProps#getServerSideEncryptionConfiguration}
         * @param serverSideEncryptionConfiguration Contains details about the configuration of the server-side encryption.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder serverSideEncryptionConfiguration(software.amazon.awscdk.IResolvable serverSideEncryptionConfiguration) {
            this.serverSideEncryptionConfiguration = serverSideEncryptionConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnDataSourceProps#getServerSideEncryptionConfiguration}
         * @param serverSideEncryptionConfiguration Contains details about the configuration of the server-side encryption.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder serverSideEncryptionConfiguration(software.amazon.awscdk.services.bedrock.CfnDataSource.ServerSideEncryptionConfigurationProperty serverSideEncryptionConfiguration) {
            this.serverSideEncryptionConfiguration = serverSideEncryptionConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnDataSourceProps#getVectorIngestionConfiguration}
         * @param vectorIngestionConfiguration Contains details about how to ingest the documents in the data source.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vectorIngestionConfiguration(software.amazon.awscdk.IResolvable vectorIngestionConfiguration) {
            this.vectorIngestionConfiguration = vectorIngestionConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnDataSourceProps#getVectorIngestionConfiguration}
         * @param vectorIngestionConfiguration Contains details about how to ingest the documents in the data source.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vectorIngestionConfiguration(software.amazon.awscdk.services.bedrock.CfnDataSource.VectorIngestionConfigurationProperty vectorIngestionConfiguration) {
            this.vectorIngestionConfiguration = vectorIngestionConfiguration;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnDataSourceProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnDataSourceProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnDataSourceProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnDataSourceProps {
        private final java.lang.Object dataSourceConfiguration;
        private final java.lang.String knowledgeBaseId;
        private final java.lang.String name;
        private final java.lang.String dataDeletionPolicy;
        private final java.lang.String description;
        private final java.lang.Object serverSideEncryptionConfiguration;
        private final java.lang.Object vectorIngestionConfiguration;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.dataSourceConfiguration = software.amazon.jsii.Kernel.get(this, "dataSourceConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.knowledgeBaseId = software.amazon.jsii.Kernel.get(this, "knowledgeBaseId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.dataDeletionPolicy = software.amazon.jsii.Kernel.get(this, "dataDeletionPolicy", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.serverSideEncryptionConfiguration = software.amazon.jsii.Kernel.get(this, "serverSideEncryptionConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.vectorIngestionConfiguration = software.amazon.jsii.Kernel.get(this, "vectorIngestionConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.dataSourceConfiguration = java.util.Objects.requireNonNull(builder.dataSourceConfiguration, "dataSourceConfiguration is required");
            this.knowledgeBaseId = java.util.Objects.requireNonNull(builder.knowledgeBaseId, "knowledgeBaseId is required");
            this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
            this.dataDeletionPolicy = builder.dataDeletionPolicy;
            this.description = builder.description;
            this.serverSideEncryptionConfiguration = builder.serverSideEncryptionConfiguration;
            this.vectorIngestionConfiguration = builder.vectorIngestionConfiguration;
        }

        @Override
        public final java.lang.Object getDataSourceConfiguration() {
            return this.dataSourceConfiguration;
        }

        @Override
        public final java.lang.String getKnowledgeBaseId() {
            return this.knowledgeBaseId;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        public final java.lang.String getDataDeletionPolicy() {
            return this.dataDeletionPolicy;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public final java.lang.Object getServerSideEncryptionConfiguration() {
            return this.serverSideEncryptionConfiguration;
        }

        @Override
        public final java.lang.Object getVectorIngestionConfiguration() {
            return this.vectorIngestionConfiguration;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("dataSourceConfiguration", om.valueToTree(this.getDataSourceConfiguration()));
            data.set("knowledgeBaseId", om.valueToTree(this.getKnowledgeBaseId()));
            data.set("name", om.valueToTree(this.getName()));
            if (this.getDataDeletionPolicy() != null) {
                data.set("dataDeletionPolicy", om.valueToTree(this.getDataDeletionPolicy()));
            }
            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getServerSideEncryptionConfiguration() != null) {
                data.set("serverSideEncryptionConfiguration", om.valueToTree(this.getServerSideEncryptionConfiguration()));
            }
            if (this.getVectorIngestionConfiguration() != null) {
                data.set("vectorIngestionConfiguration", om.valueToTree(this.getVectorIngestionConfiguration()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_bedrock.CfnDataSourceProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnDataSourceProps.Jsii$Proxy that = (CfnDataSourceProps.Jsii$Proxy) o;

            if (!dataSourceConfiguration.equals(that.dataSourceConfiguration)) return false;
            if (!knowledgeBaseId.equals(that.knowledgeBaseId)) return false;
            if (!name.equals(that.name)) return false;
            if (this.dataDeletionPolicy != null ? !this.dataDeletionPolicy.equals(that.dataDeletionPolicy) : that.dataDeletionPolicy != null) return false;
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            if (this.serverSideEncryptionConfiguration != null ? !this.serverSideEncryptionConfiguration.equals(that.serverSideEncryptionConfiguration) : that.serverSideEncryptionConfiguration != null) return false;
            return this.vectorIngestionConfiguration != null ? this.vectorIngestionConfiguration.equals(that.vectorIngestionConfiguration) : that.vectorIngestionConfiguration == null;
        }

        @Override
        public final int hashCode() {
            int result = this.dataSourceConfiguration.hashCode();
            result = 31 * result + (this.knowledgeBaseId.hashCode());
            result = 31 * result + (this.name.hashCode());
            result = 31 * result + (this.dataDeletionPolicy != null ? this.dataDeletionPolicy.hashCode() : 0);
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            result = 31 * result + (this.serverSideEncryptionConfiguration != null ? this.serverSideEncryptionConfiguration.hashCode() : 0);
            result = 31 * result + (this.vectorIngestionConfiguration != null ? this.vectorIngestionConfiguration.hashCode() : 0);
            return result;
        }
    }
}
