package software.amazon.awscdk.services.bedrock;

/**
 * Properties for defining a <code>CfnFlow</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.bedrock.*;
 * Object collector;
 * Object input;
 * Object iterator;
 * Object output;
 * CfnFlowProps cfnFlowProps = CfnFlowProps.builder()
 *         .executionRoleArn("executionRoleArn")
 *         .name("name")
 *         // the properties below are optional
 *         .customerEncryptionKeyArn("customerEncryptionKeyArn")
 *         .definition(FlowDefinitionProperty.builder()
 *                 .connections(List.of(FlowConnectionProperty.builder()
 *                         .name("name")
 *                         .source("source")
 *                         .target("target")
 *                         .type("type")
 *                         // the properties below are optional
 *                         .configuration(FlowConnectionConfigurationProperty.builder()
 *                                 .conditional(FlowConditionalConnectionConfigurationProperty.builder()
 *                                         .condition("condition")
 *                                         .build())
 *                                 .data(FlowDataConnectionConfigurationProperty.builder()
 *                                         .sourceOutput("sourceOutput")
 *                                         .targetInput("targetInput")
 *                                         .build())
 *                                 .build())
 *                         .build()))
 *                 .nodes(List.of(FlowNodeProperty.builder()
 *                         .name("name")
 *                         .type("type")
 *                         // the properties below are optional
 *                         .configuration(FlowNodeConfigurationProperty.builder()
 *                                 .agent(AgentFlowNodeConfigurationProperty.builder()
 *                                         .agentAliasArn("agentAliasArn")
 *                                         .build())
 *                                 .collector(collector)
 *                                 .condition(ConditionFlowNodeConfigurationProperty.builder()
 *                                         .conditions(List.of(FlowConditionProperty.builder()
 *                                                 .name("name")
 *                                                 // the properties below are optional
 *                                                 .expression("expression")
 *                                                 .build()))
 *                                         .build())
 *                                 .input(input)
 *                                 .iterator(iterator)
 *                                 .knowledgeBase(KnowledgeBaseFlowNodeConfigurationProperty.builder()
 *                                         .knowledgeBaseId("knowledgeBaseId")
 *                                         // the properties below are optional
 *                                         .guardrailConfiguration(GuardrailConfigurationProperty.builder()
 *                                                 .guardrailIdentifier("guardrailIdentifier")
 *                                                 .guardrailVersion("guardrailVersion")
 *                                                 .build())
 *                                         .modelId("modelId")
 *                                         .build())
 *                                 .lambdaFunction(LambdaFunctionFlowNodeConfigurationProperty.builder()
 *                                         .lambdaArn("lambdaArn")
 *                                         .build())
 *                                 .lex(LexFlowNodeConfigurationProperty.builder()
 *                                         .botAliasArn("botAliasArn")
 *                                         .localeId("localeId")
 *                                         .build())
 *                                 .output(output)
 *                                 .prompt(PromptFlowNodeConfigurationProperty.builder()
 *                                         .sourceConfiguration(PromptFlowNodeSourceConfigurationProperty.builder()
 *                                                 .inline(PromptFlowNodeInlineConfigurationProperty.builder()
 *                                                         .modelId("modelId")
 *                                                         .templateConfiguration(PromptTemplateConfigurationProperty.builder()
 *                                                                 .text(TextPromptTemplateConfigurationProperty.builder()
 *                                                                         .text("text")
 *                                                                         // the properties below are optional
 *                                                                         .inputVariables(List.of(PromptInputVariableProperty.builder()
 *                                                                                 .name("name")
 *                                                                                 .build()))
 *                                                                         .build())
 *                                                                 .build())
 *                                                         .templateType("templateType")
 *                                                         // the properties below are optional
 *                                                         .inferenceConfiguration(PromptInferenceConfigurationProperty.builder()
 *                                                                 .text(PromptModelInferenceConfigurationProperty.builder()
 *                                                                         .maxTokens(123)
 *                                                                         .stopSequences(List.of("stopSequences"))
 *                                                                         .temperature(123)
 *                                                                         .topP(123)
 *                                                                         .build())
 *                                                                 .build())
 *                                                         .build())
 *                                                 .resource(PromptFlowNodeResourceConfigurationProperty.builder()
 *                                                         .promptArn("promptArn")
 *                                                         .build())
 *                                                 .build())
 *                                         // the properties below are optional
 *                                         .guardrailConfiguration(GuardrailConfigurationProperty.builder()
 *                                                 .guardrailIdentifier("guardrailIdentifier")
 *                                                 .guardrailVersion("guardrailVersion")
 *                                                 .build())
 *                                         .build())
 *                                 .retrieval(RetrievalFlowNodeConfigurationProperty.builder()
 *                                         .serviceConfiguration(RetrievalFlowNodeServiceConfigurationProperty.builder()
 *                                                 .s3(RetrievalFlowNodeS3ConfigurationProperty.builder()
 *                                                         .bucketName("bucketName")
 *                                                         .build())
 *                                                 .build())
 *                                         .build())
 *                                 .storage(StorageFlowNodeConfigurationProperty.builder()
 *                                         .serviceConfiguration(StorageFlowNodeServiceConfigurationProperty.builder()
 *                                                 .s3(StorageFlowNodeS3ConfigurationProperty.builder()
 *                                                         .bucketName("bucketName")
 *                                                         .build())
 *                                                 .build())
 *                                         .build())
 *                                 .build())
 *                         .inputs(List.of(FlowNodeInputProperty.builder()
 *                                 .expression("expression")
 *                                 .name("name")
 *                                 .type("type")
 *                                 .build()))
 *                         .outputs(List.of(FlowNodeOutputProperty.builder()
 *                                 .name("name")
 *                                 .type("type")
 *                                 .build()))
 *                         .build()))
 *                 .build())
 *         .definitionS3Location(S3LocationProperty.builder()
 *                 .bucket("bucket")
 *                 .key("key")
 *                 // the properties below are optional
 *                 .version("version")
 *                 .build())
 *         .definitionString("definitionString")
 *         .definitionSubstitutions(Map.of(
 *                 "definitionSubstitutionsKey", "definitionSubstitutions"))
 *         .description("description")
 *         .tags(Map.of(
 *                 "tagsKey", "tags"))
 *         .testAliasTags(Map.of(
 *                 "testAliasTagsKey", "testAliasTags"))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-flow.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-flow.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-01-25T00:20:51.645Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_bedrock.CfnFlowProps")
@software.amazon.jsii.Jsii.Proxy(CfnFlowProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnFlowProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The Amazon Resource Name (ARN) of the service role with permissions to create a flow.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/flows-permissions.html">Create a service row for flows</a> in the Amazon Bedrock User Guide.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-flow.html#cfn-bedrock-flow-executionrolearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-flow.html#cfn-bedrock-flow-executionrolearn</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getExecutionRoleArn();

    /**
     * The name of the flow.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-flow.html#cfn-bedrock-flow-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-flow.html#cfn-bedrock-flow-name</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getName();

    /**
     * The Amazon Resource Name (ARN) of the KMS key that the flow is encrypted with.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-flow.html#cfn-bedrock-flow-customerencryptionkeyarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-flow.html#cfn-bedrock-flow-customerencryptionkeyarn</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getCustomerEncryptionKeyArn() {
        return null;
    }

    /**
     * The definition of the nodes and connections between the nodes in the flow.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-flow.html#cfn-bedrock-flow-definition">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-flow.html#cfn-bedrock-flow-definition</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getDefinition() {
        return null;
    }

    /**
     * The Amazon S3 location of the flow definition.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-flow.html#cfn-bedrock-flow-definitions3location">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-flow.html#cfn-bedrock-flow-definitions3location</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getDefinitionS3Location() {
        return null;
    }

    /**
     * The definition of the flow as a JSON-formatted string.
     * <p>
     * The string must match the format in <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flow-flowdefinition.html">FlowDefinition</a> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-flow.html#cfn-bedrock-flow-definitionstring">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-flow.html#cfn-bedrock-flow-definitionstring</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDefinitionString() {
        return null;
    }

    /**
     * A map that specifies the mappings for placeholder variables in the prompt flow definition.
     * <p>
     * This enables the customer to inject values obtained at runtime. Variables can be template parameter names, resource logical IDs, resource attributes, or a variable in a key-value map. Only supported with the <code>DefinitionString</code> and <code>DefinitionS3Location</code> fields.
     * <p>
     * Substitutions must follow the syntax: <code>${key_name}</code> or <code>${variable_1,variable_2,...}</code> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-flow.html#cfn-bedrock-flow-definitionsubstitutions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-flow.html#cfn-bedrock-flow-definitionsubstitutions</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getDefinitionSubstitutions() {
        return null;
    }

    /**
     * A description of the flow.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-flow.html#cfn-bedrock-flow-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-flow.html#cfn-bedrock-flow-description</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return null;
    }

    /**
     * Metadata that you can assign to a resource as key-value pairs. For more information, see the following resources:.
     * <p>
     * <ul>
     * <li><a href="https://docs.aws.amazon.com/tag-editor/latest/userguide/tagging.html#tag-conventions">Tag naming limits and requirements</a></li>
     * <li><a href="https://docs.aws.amazon.com/tag-editor/latest/userguide/tagging.html#tag-best-practices">Tagging best practices</a></li>
     * </ul>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-flow.html#cfn-bedrock-flow-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-flow.html#cfn-bedrock-flow-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> getTags() {
        return null;
    }

    /**
     * A map of tag keys and values.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-flow.html#cfn-bedrock-flow-testaliastags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-flow.html#cfn-bedrock-flow-testaliastags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getTestAliasTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnFlowProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnFlowProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnFlowProps> {
        java.lang.String executionRoleArn;
        java.lang.String name;
        java.lang.String customerEncryptionKeyArn;
        java.lang.Object definition;
        java.lang.Object definitionS3Location;
        java.lang.String definitionString;
        java.lang.Object definitionSubstitutions;
        java.lang.String description;
        java.util.Map<java.lang.String, java.lang.String> tags;
        java.lang.Object testAliasTags;

        /**
         * Sets the value of {@link CfnFlowProps#getExecutionRoleArn}
         * @param executionRoleArn The Amazon Resource Name (ARN) of the service role with permissions to create a flow. This parameter is required.
         *                         For more information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/flows-permissions.html">Create a service row for flows</a> in the Amazon Bedrock User Guide.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder executionRoleArn(java.lang.String executionRoleArn) {
            this.executionRoleArn = executionRoleArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnFlowProps#getName}
         * @param name The name of the flow. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of {@link CfnFlowProps#getCustomerEncryptionKeyArn}
         * @param customerEncryptionKeyArn The Amazon Resource Name (ARN) of the KMS key that the flow is encrypted with.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder customerEncryptionKeyArn(java.lang.String customerEncryptionKeyArn) {
            this.customerEncryptionKeyArn = customerEncryptionKeyArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnFlowProps#getDefinition}
         * @param definition The definition of the nodes and connections between the nodes in the flow.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder definition(software.amazon.awscdk.IResolvable definition) {
            this.definition = definition;
            return this;
        }

        /**
         * Sets the value of {@link CfnFlowProps#getDefinition}
         * @param definition The definition of the nodes and connections between the nodes in the flow.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder definition(software.amazon.awscdk.services.bedrock.CfnFlow.FlowDefinitionProperty definition) {
            this.definition = definition;
            return this;
        }

        /**
         * Sets the value of {@link CfnFlowProps#getDefinitionS3Location}
         * @param definitionS3Location The Amazon S3 location of the flow definition.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder definitionS3Location(software.amazon.awscdk.IResolvable definitionS3Location) {
            this.definitionS3Location = definitionS3Location;
            return this;
        }

        /**
         * Sets the value of {@link CfnFlowProps#getDefinitionS3Location}
         * @param definitionS3Location The Amazon S3 location of the flow definition.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder definitionS3Location(software.amazon.awscdk.services.bedrock.CfnFlow.S3LocationProperty definitionS3Location) {
            this.definitionS3Location = definitionS3Location;
            return this;
        }

        /**
         * Sets the value of {@link CfnFlowProps#getDefinitionString}
         * @param definitionString The definition of the flow as a JSON-formatted string.
         *                         The string must match the format in <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flow-flowdefinition.html">FlowDefinition</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder definitionString(java.lang.String definitionString) {
            this.definitionString = definitionString;
            return this;
        }

        /**
         * Sets the value of {@link CfnFlowProps#getDefinitionSubstitutions}
         * @param definitionSubstitutions A map that specifies the mappings for placeholder variables in the prompt flow definition.
         *                                This enables the customer to inject values obtained at runtime. Variables can be template parameter names, resource logical IDs, resource attributes, or a variable in a key-value map. Only supported with the <code>DefinitionString</code> and <code>DefinitionS3Location</code> fields.
         *                                <p>
         *                                Substitutions must follow the syntax: <code>${key_name}</code> or <code>${variable_1,variable_2,...}</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder definitionSubstitutions(software.amazon.awscdk.IResolvable definitionSubstitutions) {
            this.definitionSubstitutions = definitionSubstitutions;
            return this;
        }

        /**
         * Sets the value of {@link CfnFlowProps#getDefinitionSubstitutions}
         * @param definitionSubstitutions A map that specifies the mappings for placeholder variables in the prompt flow definition.
         *                                This enables the customer to inject values obtained at runtime. Variables can be template parameter names, resource logical IDs, resource attributes, or a variable in a key-value map. Only supported with the <code>DefinitionString</code> and <code>DefinitionS3Location</code> fields.
         *                                <p>
         *                                Substitutions must follow the syntax: <code>${key_name}</code> or <code>${variable_1,variable_2,...}</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder definitionSubstitutions(java.util.Map<java.lang.String, ? extends java.lang.Object> definitionSubstitutions) {
            this.definitionSubstitutions = definitionSubstitutions;
            return this;
        }

        /**
         * Sets the value of {@link CfnFlowProps#getDescription}
         * @param description A description of the flow.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link CfnFlowProps#getTags}
         * @param tags Metadata that you can assign to a resource as key-value pairs. For more information, see the following resources:.
         *             <ul>
         *             <li><a href="https://docs.aws.amazon.com/tag-editor/latest/userguide/tagging.html#tag-conventions">Tag naming limits and requirements</a></li>
         *             <li><a href="https://docs.aws.amazon.com/tag-editor/latest/userguide/tagging.html#tag-best-practices">Tagging best practices</a></li>
         *             </ul>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(java.util.Map<java.lang.String, java.lang.String> tags) {
            this.tags = tags;
            return this;
        }

        /**
         * Sets the value of {@link CfnFlowProps#getTestAliasTags}
         * @param testAliasTags A map of tag keys and values.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder testAliasTags(software.amazon.awscdk.IResolvable testAliasTags) {
            this.testAliasTags = testAliasTags;
            return this;
        }

        /**
         * Sets the value of {@link CfnFlowProps#getTestAliasTags}
         * @param testAliasTags A map of tag keys and values.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder testAliasTags(java.util.Map<java.lang.String, java.lang.String> testAliasTags) {
            this.testAliasTags = testAliasTags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnFlowProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnFlowProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnFlowProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnFlowProps {
        private final java.lang.String executionRoleArn;
        private final java.lang.String name;
        private final java.lang.String customerEncryptionKeyArn;
        private final java.lang.Object definition;
        private final java.lang.Object definitionS3Location;
        private final java.lang.String definitionString;
        private final java.lang.Object definitionSubstitutions;
        private final java.lang.String description;
        private final java.util.Map<java.lang.String, java.lang.String> tags;
        private final java.lang.Object testAliasTags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.executionRoleArn = software.amazon.jsii.Kernel.get(this, "executionRoleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.customerEncryptionKeyArn = software.amazon.jsii.Kernel.get(this, "customerEncryptionKeyArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.definition = software.amazon.jsii.Kernel.get(this, "definition", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.definitionS3Location = software.amazon.jsii.Kernel.get(this, "definitionS3Location", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.definitionString = software.amazon.jsii.Kernel.get(this, "definitionString", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.definitionSubstitutions = software.amazon.jsii.Kernel.get(this, "definitionSubstitutions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.testAliasTags = software.amazon.jsii.Kernel.get(this, "testAliasTags", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.executionRoleArn = java.util.Objects.requireNonNull(builder.executionRoleArn, "executionRoleArn is required");
            this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
            this.customerEncryptionKeyArn = builder.customerEncryptionKeyArn;
            this.definition = builder.definition;
            this.definitionS3Location = builder.definitionS3Location;
            this.definitionString = builder.definitionString;
            this.definitionSubstitutions = builder.definitionSubstitutions;
            this.description = builder.description;
            this.tags = builder.tags;
            this.testAliasTags = builder.testAliasTags;
        }

        @Override
        public final java.lang.String getExecutionRoleArn() {
            return this.executionRoleArn;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        public final java.lang.String getCustomerEncryptionKeyArn() {
            return this.customerEncryptionKeyArn;
        }

        @Override
        public final java.lang.Object getDefinition() {
            return this.definition;
        }

        @Override
        public final java.lang.Object getDefinitionS3Location() {
            return this.definitionS3Location;
        }

        @Override
        public final java.lang.String getDefinitionString() {
            return this.definitionString;
        }

        @Override
        public final java.lang.Object getDefinitionSubstitutions() {
            return this.definitionSubstitutions;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.String> getTags() {
            return this.tags;
        }

        @Override
        public final java.lang.Object getTestAliasTags() {
            return this.testAliasTags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("executionRoleArn", om.valueToTree(this.getExecutionRoleArn()));
            data.set("name", om.valueToTree(this.getName()));
            if (this.getCustomerEncryptionKeyArn() != null) {
                data.set("customerEncryptionKeyArn", om.valueToTree(this.getCustomerEncryptionKeyArn()));
            }
            if (this.getDefinition() != null) {
                data.set("definition", om.valueToTree(this.getDefinition()));
            }
            if (this.getDefinitionS3Location() != null) {
                data.set("definitionS3Location", om.valueToTree(this.getDefinitionS3Location()));
            }
            if (this.getDefinitionString() != null) {
                data.set("definitionString", om.valueToTree(this.getDefinitionString()));
            }
            if (this.getDefinitionSubstitutions() != null) {
                data.set("definitionSubstitutions", om.valueToTree(this.getDefinitionSubstitutions()));
            }
            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }
            if (this.getTestAliasTags() != null) {
                data.set("testAliasTags", om.valueToTree(this.getTestAliasTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_bedrock.CfnFlowProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnFlowProps.Jsii$Proxy that = (CfnFlowProps.Jsii$Proxy) o;

            if (!executionRoleArn.equals(that.executionRoleArn)) return false;
            if (!name.equals(that.name)) return false;
            if (this.customerEncryptionKeyArn != null ? !this.customerEncryptionKeyArn.equals(that.customerEncryptionKeyArn) : that.customerEncryptionKeyArn != null) return false;
            if (this.definition != null ? !this.definition.equals(that.definition) : that.definition != null) return false;
            if (this.definitionS3Location != null ? !this.definitionS3Location.equals(that.definitionS3Location) : that.definitionS3Location != null) return false;
            if (this.definitionString != null ? !this.definitionString.equals(that.definitionString) : that.definitionString != null) return false;
            if (this.definitionSubstitutions != null ? !this.definitionSubstitutions.equals(that.definitionSubstitutions) : that.definitionSubstitutions != null) return false;
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            if (this.tags != null ? !this.tags.equals(that.tags) : that.tags != null) return false;
            return this.testAliasTags != null ? this.testAliasTags.equals(that.testAliasTags) : that.testAliasTags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.executionRoleArn.hashCode();
            result = 31 * result + (this.name.hashCode());
            result = 31 * result + (this.customerEncryptionKeyArn != null ? this.customerEncryptionKeyArn.hashCode() : 0);
            result = 31 * result + (this.definition != null ? this.definition.hashCode() : 0);
            result = 31 * result + (this.definitionS3Location != null ? this.definitionS3Location.hashCode() : 0);
            result = 31 * result + (this.definitionString != null ? this.definitionString.hashCode() : 0);
            result = 31 * result + (this.definitionSubstitutions != null ? this.definitionSubstitutions.hashCode() : 0);
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            result = 31 * result + (this.testAliasTags != null ? this.testAliasTags.hashCode() : 0);
            return result;
        }
    }
}
