package software.amazon.awscdk.services.cloudwatch;

/**
 * Properties for defining a <code>CfnMetricStream</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.cloudwatch.*;
 * CfnMetricStreamProps cfnMetricStreamProps = CfnMetricStreamProps.builder()
 *         .firehoseArn("firehoseArn")
 *         .outputFormat("outputFormat")
 *         .roleArn("roleArn")
 *         // the properties below are optional
 *         .excludeFilters(List.of(MetricStreamFilterProperty.builder()
 *                 .namespace("namespace")
 *                 // the properties below are optional
 *                 .metricNames(List.of("metricNames"))
 *                 .build()))
 *         .includeFilters(List.of(MetricStreamFilterProperty.builder()
 *                 .namespace("namespace")
 *                 // the properties below are optional
 *                 .metricNames(List.of("metricNames"))
 *                 .build()))
 *         .includeLinkedAccountsMetrics(false)
 *         .name("name")
 *         .statisticsConfigurations(List.of(MetricStreamStatisticsConfigurationProperty.builder()
 *                 .additionalStatistics(List.of("additionalStatistics"))
 *                 .includeMetrics(List.of(MetricStreamStatisticsMetricProperty.builder()
 *                         .metricName("metricName")
 *                         .namespace("namespace")
 *                         .build()))
 *                 .build()))
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudwatch-metricstream.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudwatch-metricstream.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-01-25T00:20:52.345Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cloudwatch.CfnMetricStreamProps")
@software.amazon.jsii.Jsii.Proxy(CfnMetricStreamProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnMetricStreamProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ARN of the Amazon Kinesis Firehose delivery stream to use for this metric stream.
     * <p>
     * This Amazon Kinesis Firehose delivery stream must already exist and must be in the same account as the metric stream.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudwatch-metricstream.html#cfn-cloudwatch-metricstream-firehosearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudwatch-metricstream.html#cfn-cloudwatch-metricstream-firehosearn</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getFirehoseArn();

    /**
     * The output format for the stream.
     * <p>
     * Valid values are <code>json</code> , <code>opentelemetry1.0</code> and <code>opentelemetry0.7</code> For more information about metric stream output formats, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-metric-streams-formats.html">Metric streams output formats</a> .
     * <p>
     * This parameter is required.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudwatch-metricstream.html#cfn-cloudwatch-metricstream-outputformat">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudwatch-metricstream.html#cfn-cloudwatch-metricstream-outputformat</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getOutputFormat();

    /**
     * The ARN of an IAM role that this metric stream will use to access Amazon Kinesis Firehose resources.
     * <p>
     * This IAM role must already exist and must be in the same account as the metric stream. This IAM role must include the <code>firehose:PutRecord</code> and <code>firehose:PutRecordBatch</code> permissions.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudwatch-metricstream.html#cfn-cloudwatch-metricstream-rolearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudwatch-metricstream.html#cfn-cloudwatch-metricstream-rolearn</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getRoleArn();

    /**
     * If you specify this parameter, the stream sends metrics from all metric namespaces except for the namespaces that you specify here.
     * <p>
     * You cannot specify both <code>IncludeFilters</code> and <code>ExcludeFilters</code> in the same metric stream.
     * <p>
     * When you modify the <code>IncludeFilters</code> or <code>ExcludeFilters</code> of an existing metric stream in any way, the metric stream is effectively restarted, so after such a change you will get only the datapoints that have a timestamp after the time of the update.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudwatch-metricstream.html#cfn-cloudwatch-metricstream-excludefilters">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudwatch-metricstream.html#cfn-cloudwatch-metricstream-excludefilters</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getExcludeFilters() {
        return null;
    }

    /**
     * If you specify this parameter, the stream sends only the metrics from the metric namespaces that you specify here.
     * <p>
     * You cannot specify both <code>IncludeFilters</code> and <code>ExcludeFilters</code> in the same metric stream.
     * <p>
     * When you modify the <code>IncludeFilters</code> or <code>ExcludeFilters</code> of an existing metric stream in any way, the metric stream is effectively restarted, so after such a change you will get only the datapoints that have a timestamp after the time of the update.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudwatch-metricstream.html#cfn-cloudwatch-metricstream-includefilters">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudwatch-metricstream.html#cfn-cloudwatch-metricstream-includefilters</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getIncludeFilters() {
        return null;
    }

    /**
     * If you are creating a metric stream in a monitoring account, specify <code>true</code> to include metrics from source accounts that are linked to this monitoring account, in the metric stream.
     * <p>
     * The default is <code>false</code> .
     * <p>
     * For more information about linking accounts, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-Unified-Cross-Account.html">CloudWatch cross-account observability</a>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudwatch-metricstream.html#cfn-cloudwatch-metricstream-includelinkedaccountsmetrics">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudwatch-metricstream.html#cfn-cloudwatch-metricstream-includelinkedaccountsmetrics</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getIncludeLinkedAccountsMetrics() {
        return null;
    }

    /**
     * If you are creating a new metric stream, this is the name for the new stream.
     * <p>
     * The name must be different than the names of other metric streams in this account and Region.
     * <p>
     * If you are updating a metric stream, specify the name of that stream here.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudwatch-metricstream.html#cfn-cloudwatch-metricstream-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudwatch-metricstream.html#cfn-cloudwatch-metricstream-name</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getName() {
        return null;
    }

    /**
     * By default, a metric stream always sends the MAX, MIN, SUM, and SAMPLECOUNT statistics for each metric that is streamed.
     * <p>
     * You can use this parameter to have the metric stream also send additional statistics in the stream. This array can have up to 100 members.
     * <p>
     * For each entry in this array, you specify one or more metrics and the list of additional statistics to stream for those metrics. The additional statistics that you can stream depend on the stream's <code>OutputFormat</code> . If the <code>OutputFormat</code> is <code>json</code> , you can stream any additional statistic that is supported by CloudWatch , listed in <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/Statistics-definitions.html">CloudWatch statistics definitions</a> . If the <code>OutputFormat</code> is OpenTelemetry, you can stream percentile statistics.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudwatch-metricstream.html#cfn-cloudwatch-metricstream-statisticsconfigurations">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudwatch-metricstream.html#cfn-cloudwatch-metricstream-statisticsconfigurations</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getStatisticsConfigurations() {
        return null;
    }

    /**
     * An array of key-value pairs to apply to the metric stream.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html">Tag</a> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudwatch-metricstream.html#cfn-cloudwatch-metricstream-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudwatch-metricstream.html#cfn-cloudwatch-metricstream-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnMetricStreamProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnMetricStreamProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnMetricStreamProps> {
        java.lang.String firehoseArn;
        java.lang.String outputFormat;
        java.lang.String roleArn;
        java.lang.Object excludeFilters;
        java.lang.Object includeFilters;
        java.lang.Object includeLinkedAccountsMetrics;
        java.lang.String name;
        java.lang.Object statisticsConfigurations;
        java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Sets the value of {@link CfnMetricStreamProps#getFirehoseArn}
         * @param firehoseArn The ARN of the Amazon Kinesis Firehose delivery stream to use for this metric stream. This parameter is required.
         *                    This Amazon Kinesis Firehose delivery stream must already exist and must be in the same account as the metric stream.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder firehoseArn(java.lang.String firehoseArn) {
            this.firehoseArn = firehoseArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnMetricStreamProps#getOutputFormat}
         * @param outputFormat The output format for the stream. This parameter is required.
         *                     Valid values are <code>json</code> , <code>opentelemetry1.0</code> and <code>opentelemetry0.7</code> For more information about metric stream output formats, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-metric-streams-formats.html">Metric streams output formats</a> .
         *                     <p>
         *                     This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder outputFormat(java.lang.String outputFormat) {
            this.outputFormat = outputFormat;
            return this;
        }

        /**
         * Sets the value of {@link CfnMetricStreamProps#getRoleArn}
         * @param roleArn The ARN of an IAM role that this metric stream will use to access Amazon Kinesis Firehose resources. This parameter is required.
         *                This IAM role must already exist and must be in the same account as the metric stream. This IAM role must include the <code>firehose:PutRecord</code> and <code>firehose:PutRecordBatch</code> permissions.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder roleArn(java.lang.String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnMetricStreamProps#getExcludeFilters}
         * @param excludeFilters If you specify this parameter, the stream sends metrics from all metric namespaces except for the namespaces that you specify here.
         *                       You cannot specify both <code>IncludeFilters</code> and <code>ExcludeFilters</code> in the same metric stream.
         *                       <p>
         *                       When you modify the <code>IncludeFilters</code> or <code>ExcludeFilters</code> of an existing metric stream in any way, the metric stream is effectively restarted, so after such a change you will get only the datapoints that have a timestamp after the time of the update.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder excludeFilters(software.amazon.awscdk.IResolvable excludeFilters) {
            this.excludeFilters = excludeFilters;
            return this;
        }

        /**
         * Sets the value of {@link CfnMetricStreamProps#getExcludeFilters}
         * @param excludeFilters If you specify this parameter, the stream sends metrics from all metric namespaces except for the namespaces that you specify here.
         *                       You cannot specify both <code>IncludeFilters</code> and <code>ExcludeFilters</code> in the same metric stream.
         *                       <p>
         *                       When you modify the <code>IncludeFilters</code> or <code>ExcludeFilters</code> of an existing metric stream in any way, the metric stream is effectively restarted, so after such a change you will get only the datapoints that have a timestamp after the time of the update.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder excludeFilters(java.util.List<? extends java.lang.Object> excludeFilters) {
            this.excludeFilters = excludeFilters;
            return this;
        }

        /**
         * Sets the value of {@link CfnMetricStreamProps#getIncludeFilters}
         * @param includeFilters If you specify this parameter, the stream sends only the metrics from the metric namespaces that you specify here.
         *                       You cannot specify both <code>IncludeFilters</code> and <code>ExcludeFilters</code> in the same metric stream.
         *                       <p>
         *                       When you modify the <code>IncludeFilters</code> or <code>ExcludeFilters</code> of an existing metric stream in any way, the metric stream is effectively restarted, so after such a change you will get only the datapoints that have a timestamp after the time of the update.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder includeFilters(software.amazon.awscdk.IResolvable includeFilters) {
            this.includeFilters = includeFilters;
            return this;
        }

        /**
         * Sets the value of {@link CfnMetricStreamProps#getIncludeFilters}
         * @param includeFilters If you specify this parameter, the stream sends only the metrics from the metric namespaces that you specify here.
         *                       You cannot specify both <code>IncludeFilters</code> and <code>ExcludeFilters</code> in the same metric stream.
         *                       <p>
         *                       When you modify the <code>IncludeFilters</code> or <code>ExcludeFilters</code> of an existing metric stream in any way, the metric stream is effectively restarted, so after such a change you will get only the datapoints that have a timestamp after the time of the update.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder includeFilters(java.util.List<? extends java.lang.Object> includeFilters) {
            this.includeFilters = includeFilters;
            return this;
        }

        /**
         * Sets the value of {@link CfnMetricStreamProps#getIncludeLinkedAccountsMetrics}
         * @param includeLinkedAccountsMetrics If you are creating a metric stream in a monitoring account, specify <code>true</code> to include metrics from source accounts that are linked to this monitoring account, in the metric stream.
         *                                     The default is <code>false</code> .
         *                                     <p>
         *                                     For more information about linking accounts, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-Unified-Cross-Account.html">CloudWatch cross-account observability</a>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder includeLinkedAccountsMetrics(java.lang.Boolean includeLinkedAccountsMetrics) {
            this.includeLinkedAccountsMetrics = includeLinkedAccountsMetrics;
            return this;
        }

        /**
         * Sets the value of {@link CfnMetricStreamProps#getIncludeLinkedAccountsMetrics}
         * @param includeLinkedAccountsMetrics If you are creating a metric stream in a monitoring account, specify <code>true</code> to include metrics from source accounts that are linked to this monitoring account, in the metric stream.
         *                                     The default is <code>false</code> .
         *                                     <p>
         *                                     For more information about linking accounts, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-Unified-Cross-Account.html">CloudWatch cross-account observability</a>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder includeLinkedAccountsMetrics(software.amazon.awscdk.IResolvable includeLinkedAccountsMetrics) {
            this.includeLinkedAccountsMetrics = includeLinkedAccountsMetrics;
            return this;
        }

        /**
         * Sets the value of {@link CfnMetricStreamProps#getName}
         * @param name If you are creating a new metric stream, this is the name for the new stream.
         *             The name must be different than the names of other metric streams in this account and Region.
         *             <p>
         *             If you are updating a metric stream, specify the name of that stream here.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of {@link CfnMetricStreamProps#getStatisticsConfigurations}
         * @param statisticsConfigurations By default, a metric stream always sends the MAX, MIN, SUM, and SAMPLECOUNT statistics for each metric that is streamed.
         *                                 You can use this parameter to have the metric stream also send additional statistics in the stream. This array can have up to 100 members.
         *                                 <p>
         *                                 For each entry in this array, you specify one or more metrics and the list of additional statistics to stream for those metrics. The additional statistics that you can stream depend on the stream's <code>OutputFormat</code> . If the <code>OutputFormat</code> is <code>json</code> , you can stream any additional statistic that is supported by CloudWatch , listed in <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/Statistics-definitions.html">CloudWatch statistics definitions</a> . If the <code>OutputFormat</code> is OpenTelemetry, you can stream percentile statistics.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder statisticsConfigurations(software.amazon.awscdk.IResolvable statisticsConfigurations) {
            this.statisticsConfigurations = statisticsConfigurations;
            return this;
        }

        /**
         * Sets the value of {@link CfnMetricStreamProps#getStatisticsConfigurations}
         * @param statisticsConfigurations By default, a metric stream always sends the MAX, MIN, SUM, and SAMPLECOUNT statistics for each metric that is streamed.
         *                                 You can use this parameter to have the metric stream also send additional statistics in the stream. This array can have up to 100 members.
         *                                 <p>
         *                                 For each entry in this array, you specify one or more metrics and the list of additional statistics to stream for those metrics. The additional statistics that you can stream depend on the stream's <code>OutputFormat</code> . If the <code>OutputFormat</code> is <code>json</code> , you can stream any additional statistic that is supported by CloudWatch , listed in <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/Statistics-definitions.html">CloudWatch statistics definitions</a> . If the <code>OutputFormat</code> is OpenTelemetry, you can stream percentile statistics.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder statisticsConfigurations(java.util.List<? extends java.lang.Object> statisticsConfigurations) {
            this.statisticsConfigurations = statisticsConfigurations;
            return this;
        }

        /**
         * Sets the value of {@link CfnMetricStreamProps#getTags}
         * @param tags An array of key-value pairs to apply to the metric stream.
         *             For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html">Tag</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnMetricStreamProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnMetricStreamProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnMetricStreamProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnMetricStreamProps {
        private final java.lang.String firehoseArn;
        private final java.lang.String outputFormat;
        private final java.lang.String roleArn;
        private final java.lang.Object excludeFilters;
        private final java.lang.Object includeFilters;
        private final java.lang.Object includeLinkedAccountsMetrics;
        private final java.lang.String name;
        private final java.lang.Object statisticsConfigurations;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.firehoseArn = software.amazon.jsii.Kernel.get(this, "firehoseArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.outputFormat = software.amazon.jsii.Kernel.get(this, "outputFormat", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.roleArn = software.amazon.jsii.Kernel.get(this, "roleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.excludeFilters = software.amazon.jsii.Kernel.get(this, "excludeFilters", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.includeFilters = software.amazon.jsii.Kernel.get(this, "includeFilters", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.includeLinkedAccountsMetrics = software.amazon.jsii.Kernel.get(this, "includeLinkedAccountsMetrics", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.statisticsConfigurations = software.amazon.jsii.Kernel.get(this, "statisticsConfigurations", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.firehoseArn = java.util.Objects.requireNonNull(builder.firehoseArn, "firehoseArn is required");
            this.outputFormat = java.util.Objects.requireNonNull(builder.outputFormat, "outputFormat is required");
            this.roleArn = java.util.Objects.requireNonNull(builder.roleArn, "roleArn is required");
            this.excludeFilters = builder.excludeFilters;
            this.includeFilters = builder.includeFilters;
            this.includeLinkedAccountsMetrics = builder.includeLinkedAccountsMetrics;
            this.name = builder.name;
            this.statisticsConfigurations = builder.statisticsConfigurations;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
        }

        @Override
        public final java.lang.String getFirehoseArn() {
            return this.firehoseArn;
        }

        @Override
        public final java.lang.String getOutputFormat() {
            return this.outputFormat;
        }

        @Override
        public final java.lang.String getRoleArn() {
            return this.roleArn;
        }

        @Override
        public final java.lang.Object getExcludeFilters() {
            return this.excludeFilters;
        }

        @Override
        public final java.lang.Object getIncludeFilters() {
            return this.includeFilters;
        }

        @Override
        public final java.lang.Object getIncludeLinkedAccountsMetrics() {
            return this.includeLinkedAccountsMetrics;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        public final java.lang.Object getStatisticsConfigurations() {
            return this.statisticsConfigurations;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("firehoseArn", om.valueToTree(this.getFirehoseArn()));
            data.set("outputFormat", om.valueToTree(this.getOutputFormat()));
            data.set("roleArn", om.valueToTree(this.getRoleArn()));
            if (this.getExcludeFilters() != null) {
                data.set("excludeFilters", om.valueToTree(this.getExcludeFilters()));
            }
            if (this.getIncludeFilters() != null) {
                data.set("includeFilters", om.valueToTree(this.getIncludeFilters()));
            }
            if (this.getIncludeLinkedAccountsMetrics() != null) {
                data.set("includeLinkedAccountsMetrics", om.valueToTree(this.getIncludeLinkedAccountsMetrics()));
            }
            if (this.getName() != null) {
                data.set("name", om.valueToTree(this.getName()));
            }
            if (this.getStatisticsConfigurations() != null) {
                data.set("statisticsConfigurations", om.valueToTree(this.getStatisticsConfigurations()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cloudwatch.CfnMetricStreamProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnMetricStreamProps.Jsii$Proxy that = (CfnMetricStreamProps.Jsii$Proxy) o;

            if (!firehoseArn.equals(that.firehoseArn)) return false;
            if (!outputFormat.equals(that.outputFormat)) return false;
            if (!roleArn.equals(that.roleArn)) return false;
            if (this.excludeFilters != null ? !this.excludeFilters.equals(that.excludeFilters) : that.excludeFilters != null) return false;
            if (this.includeFilters != null ? !this.includeFilters.equals(that.includeFilters) : that.includeFilters != null) return false;
            if (this.includeLinkedAccountsMetrics != null ? !this.includeLinkedAccountsMetrics.equals(that.includeLinkedAccountsMetrics) : that.includeLinkedAccountsMetrics != null) return false;
            if (this.name != null ? !this.name.equals(that.name) : that.name != null) return false;
            if (this.statisticsConfigurations != null ? !this.statisticsConfigurations.equals(that.statisticsConfigurations) : that.statisticsConfigurations != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.firehoseArn.hashCode();
            result = 31 * result + (this.outputFormat.hashCode());
            result = 31 * result + (this.roleArn.hashCode());
            result = 31 * result + (this.excludeFilters != null ? this.excludeFilters.hashCode() : 0);
            result = 31 * result + (this.includeFilters != null ? this.includeFilters.hashCode() : 0);
            result = 31 * result + (this.includeLinkedAccountsMetrics != null ? this.includeLinkedAccountsMetrics.hashCode() : 0);
            result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
            result = 31 * result + (this.statisticsConfigurations != null ? this.statisticsConfigurations.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
