package software.amazon.awscdk.services.codedeploy;

/**
 * Configuration for CodeDeploy to deploy your application to one Availability Zone at a time within an AWS Region.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * ServerDeploymentConfig deploymentConfig = ServerDeploymentConfig.Builder.create(this, "DeploymentConfiguration")
 *         .minimumHealthyHosts(MinimumHealthyHosts.count(2))
 *         .zonalConfig(ZonalConfig.builder()
 *                 .monitorDuration(Duration.minutes(30))
 *                 .firstZoneMonitorDuration(Duration.minutes(60))
 *                 .minimumHealthyHostsPerZone(MinimumHealthyHostsPerZone.count(1))
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-01-25T00:20:52.671Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_codedeploy.ZonalConfig")
@software.amazon.jsii.Jsii.Proxy(ZonalConfig.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface ZonalConfig extends software.amazon.jsii.JsiiSerializable {

    /**
     * The period of time that CodeDeploy must wait after completing a deployment to the first Availability Zone.
     * <p>
     * Accepted Values:
     * <p>
     * <ul>
     * <li>0</li>
     * <li>Greater than or equal to 1</li>
     * </ul>
     * <p>
     * Default: - the same value as `monitorDuration`
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.Duration getFirstZoneMonitorDuration() {
        return null;
    }

    /**
     * The number or percentage of instances that must remain available per Availability Zone during a deployment.
     * <p>
     * This option works in conjunction with the <code>minimumHealthyHosts</code> option.
     * <p>
     * Default: - 0 percent
     * <p>
     * @see <a href="https://docs.aws.amazon.com/codedeploy/latest/userguide/instances-health.html#minimum-healthy-hosts-az">https://docs.aws.amazon.com/codedeploy/latest/userguide/instances-health.html#minimum-healthy-hosts-az</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.codedeploy.MinimumHealthyHostsPerZone getMinimumHealthyHostsPerZone() {
        return null;
    }

    /**
     * The period of time that CodeDeploy must wait after completing a deployment to an Availability Zone.
     * <p>
     * Accepted Values:
     * <p>
     * <ul>
     * <li>0</li>
     * <li>Greater than or equal to 1</li>
     * </ul>
     * <p>
     * Default: - CodeDeploy starts deploying to the next Availability Zone immediately
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.Duration getMonitorDuration() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link ZonalConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link ZonalConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<ZonalConfig> {
        software.amazon.awscdk.Duration firstZoneMonitorDuration;
        software.amazon.awscdk.services.codedeploy.MinimumHealthyHostsPerZone minimumHealthyHostsPerZone;
        software.amazon.awscdk.Duration monitorDuration;

        /**
         * Sets the value of {@link ZonalConfig#getFirstZoneMonitorDuration}
         * @param firstZoneMonitorDuration The period of time that CodeDeploy must wait after completing a deployment to the first Availability Zone.
         *                                 Accepted Values:
         *                                 <p>
         *                                 <ul>
         *                                 <li>0</li>
         *                                 <li>Greater than or equal to 1</li>
         *                                 </ul>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder firstZoneMonitorDuration(software.amazon.awscdk.Duration firstZoneMonitorDuration) {
            this.firstZoneMonitorDuration = firstZoneMonitorDuration;
            return this;
        }

        /**
         * Sets the value of {@link ZonalConfig#getMinimumHealthyHostsPerZone}
         * @param minimumHealthyHostsPerZone The number or percentage of instances that must remain available per Availability Zone during a deployment.
         *                                   This option works in conjunction with the <code>minimumHealthyHosts</code> option.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder minimumHealthyHostsPerZone(software.amazon.awscdk.services.codedeploy.MinimumHealthyHostsPerZone minimumHealthyHostsPerZone) {
            this.minimumHealthyHostsPerZone = minimumHealthyHostsPerZone;
            return this;
        }

        /**
         * Sets the value of {@link ZonalConfig#getMonitorDuration}
         * @param monitorDuration The period of time that CodeDeploy must wait after completing a deployment to an Availability Zone.
         *                        Accepted Values:
         *                        <p>
         *                        <ul>
         *                        <li>0</li>
         *                        <li>Greater than or equal to 1</li>
         *                        </ul>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder monitorDuration(software.amazon.awscdk.Duration monitorDuration) {
            this.monitorDuration = monitorDuration;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ZonalConfig}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public ZonalConfig build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link ZonalConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ZonalConfig {
        private final software.amazon.awscdk.Duration firstZoneMonitorDuration;
        private final software.amazon.awscdk.services.codedeploy.MinimumHealthyHostsPerZone minimumHealthyHostsPerZone;
        private final software.amazon.awscdk.Duration monitorDuration;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.firstZoneMonitorDuration = software.amazon.jsii.Kernel.get(this, "firstZoneMonitorDuration", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Duration.class));
            this.minimumHealthyHostsPerZone = software.amazon.jsii.Kernel.get(this, "minimumHealthyHostsPerZone", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codedeploy.MinimumHealthyHostsPerZone.class));
            this.monitorDuration = software.amazon.jsii.Kernel.get(this, "monitorDuration", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Duration.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.firstZoneMonitorDuration = builder.firstZoneMonitorDuration;
            this.minimumHealthyHostsPerZone = builder.minimumHealthyHostsPerZone;
            this.monitorDuration = builder.monitorDuration;
        }

        @Override
        public final software.amazon.awscdk.Duration getFirstZoneMonitorDuration() {
            return this.firstZoneMonitorDuration;
        }

        @Override
        public final software.amazon.awscdk.services.codedeploy.MinimumHealthyHostsPerZone getMinimumHealthyHostsPerZone() {
            return this.minimumHealthyHostsPerZone;
        }

        @Override
        public final software.amazon.awscdk.Duration getMonitorDuration() {
            return this.monitorDuration;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getFirstZoneMonitorDuration() != null) {
                data.set("firstZoneMonitorDuration", om.valueToTree(this.getFirstZoneMonitorDuration()));
            }
            if (this.getMinimumHealthyHostsPerZone() != null) {
                data.set("minimumHealthyHostsPerZone", om.valueToTree(this.getMinimumHealthyHostsPerZone()));
            }
            if (this.getMonitorDuration() != null) {
                data.set("monitorDuration", om.valueToTree(this.getMonitorDuration()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_codedeploy.ZonalConfig"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ZonalConfig.Jsii$Proxy that = (ZonalConfig.Jsii$Proxy) o;

            if (this.firstZoneMonitorDuration != null ? !this.firstZoneMonitorDuration.equals(that.firstZoneMonitorDuration) : that.firstZoneMonitorDuration != null) return false;
            if (this.minimumHealthyHostsPerZone != null ? !this.minimumHealthyHostsPerZone.equals(that.minimumHealthyHostsPerZone) : that.minimumHealthyHostsPerZone != null) return false;
            return this.monitorDuration != null ? this.monitorDuration.equals(that.monitorDuration) : that.monitorDuration == null;
        }

        @Override
        public final int hashCode() {
            int result = this.firstZoneMonitorDuration != null ? this.firstZoneMonitorDuration.hashCode() : 0;
            result = 31 * result + (this.minimumHealthyHostsPerZone != null ? this.minimumHealthyHostsPerZone.hashCode() : 0);
            result = 31 * result + (this.monitorDuration != null ? this.monitorDuration.hashCode() : 0);
            return result;
        }
    }
}
