package software.amazon.awscdk.services.codepipeline;

/**
 * Git pull request filter for trigger.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.codepipeline.*;
 * GitPullRequestFilter gitPullRequestFilter = GitPullRequestFilter.builder()
 *         .branchesExcludes(List.of("branchesExcludes"))
 *         .branchesIncludes(List.of("branchesIncludes"))
 *         .events(List.of(GitPullRequestEvent.OPEN))
 *         .filePathsExcludes(List.of("filePathsExcludes"))
 *         .filePathsIncludes(List.of("filePathsIncludes"))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-01-25T00:20:52.749Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_codepipeline.GitPullRequestFilter")
@software.amazon.jsii.Jsii.Proxy(GitPullRequestFilter.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface GitPullRequestFilter extends software.amazon.jsii.JsiiSerializable {

    /**
     * The list of patterns of Git branches that, when pull request events occurs, are to be excluded from starting the pipeline.
     * <p>
     * You can filter with glob patterns. The <code>branchesExcludes</code> takes priority
     * over the <code>branchesIncludes</code>.
     * <p>
     * Maximum length of this array is 8.
     * <p>
     * Default: - no branches.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getBranchesExcludes() {
        return null;
    }

    /**
     * The list of patterns of Git branches that, when pull request events occurs, are to be included as criteria that starts the pipeline.
     * <p>
     * You can filter with glob patterns. The <code>branchesExcludes</code> takes priority
     * over the <code>branchesIncludes</code>.
     * <p>
     * Maximum length of this array is 8.
     * <p>
     * Default: - no branches.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getBranchesIncludes() {
        return null;
    }

    /**
     * The field that specifies which pull request events to filter on (opened, updated, closed) for the trigger configuration.
     * <p>
     * Default: - all events.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.codepipeline.GitPullRequestEvent> getEvents() {
        return null;
    }

    /**
     * The list of patterns of Git repository file paths that, when pull request events occurs, are to be excluded from starting the pipeline.
     * <p>
     * You can filter with glob patterns. The <code>filePathsExcludes</code> takes priority
     * over the <code>filePathsIncludes</code>.
     * <p>
     * Maximum length of this array is 8.
     * <p>
     * Default: - no filePaths.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getFilePathsExcludes() {
        return null;
    }

    /**
     * The list of patterns of Git repository file paths that, when pull request events occurs, are to be included as criteria that starts the pipeline.
     * <p>
     * You can filter with glob patterns. The <code>filePathsExcludes</code> takes priority
     * over the <code>filePathsIncludes</code>.
     * <p>
     * Maximum length of this array is 8.
     * <p>
     * Default: - no filePaths.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getFilePathsIncludes() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link GitPullRequestFilter}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link GitPullRequestFilter}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<GitPullRequestFilter> {
        java.util.List<java.lang.String> branchesExcludes;
        java.util.List<java.lang.String> branchesIncludes;
        java.util.List<software.amazon.awscdk.services.codepipeline.GitPullRequestEvent> events;
        java.util.List<java.lang.String> filePathsExcludes;
        java.util.List<java.lang.String> filePathsIncludes;

        /**
         * Sets the value of {@link GitPullRequestFilter#getBranchesExcludes}
         * @param branchesExcludes The list of patterns of Git branches that, when pull request events occurs, are to be excluded from starting the pipeline.
         *                         You can filter with glob patterns. The <code>branchesExcludes</code> takes priority
         *                         over the <code>branchesIncludes</code>.
         *                         <p>
         *                         Maximum length of this array is 8.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder branchesExcludes(java.util.List<java.lang.String> branchesExcludes) {
            this.branchesExcludes = branchesExcludes;
            return this;
        }

        /**
         * Sets the value of {@link GitPullRequestFilter#getBranchesIncludes}
         * @param branchesIncludes The list of patterns of Git branches that, when pull request events occurs, are to be included as criteria that starts the pipeline.
         *                         You can filter with glob patterns. The <code>branchesExcludes</code> takes priority
         *                         over the <code>branchesIncludes</code>.
         *                         <p>
         *                         Maximum length of this array is 8.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder branchesIncludes(java.util.List<java.lang.String> branchesIncludes) {
            this.branchesIncludes = branchesIncludes;
            return this;
        }

        /**
         * Sets the value of {@link GitPullRequestFilter#getEvents}
         * @param events The field that specifies which pull request events to filter on (opened, updated, closed) for the trigger configuration.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder events(java.util.List<? extends software.amazon.awscdk.services.codepipeline.GitPullRequestEvent> events) {
            this.events = (java.util.List<software.amazon.awscdk.services.codepipeline.GitPullRequestEvent>)events;
            return this;
        }

        /**
         * Sets the value of {@link GitPullRequestFilter#getFilePathsExcludes}
         * @param filePathsExcludes The list of patterns of Git repository file paths that, when pull request events occurs, are to be excluded from starting the pipeline.
         *                          You can filter with glob patterns. The <code>filePathsExcludes</code> takes priority
         *                          over the <code>filePathsIncludes</code>.
         *                          <p>
         *                          Maximum length of this array is 8.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder filePathsExcludes(java.util.List<java.lang.String> filePathsExcludes) {
            this.filePathsExcludes = filePathsExcludes;
            return this;
        }

        /**
         * Sets the value of {@link GitPullRequestFilter#getFilePathsIncludes}
         * @param filePathsIncludes The list of patterns of Git repository file paths that, when pull request events occurs, are to be included as criteria that starts the pipeline.
         *                          You can filter with glob patterns. The <code>filePathsExcludes</code> takes priority
         *                          over the <code>filePathsIncludes</code>.
         *                          <p>
         *                          Maximum length of this array is 8.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder filePathsIncludes(java.util.List<java.lang.String> filePathsIncludes) {
            this.filePathsIncludes = filePathsIncludes;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link GitPullRequestFilter}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public GitPullRequestFilter build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link GitPullRequestFilter}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements GitPullRequestFilter {
        private final java.util.List<java.lang.String> branchesExcludes;
        private final java.util.List<java.lang.String> branchesIncludes;
        private final java.util.List<software.amazon.awscdk.services.codepipeline.GitPullRequestEvent> events;
        private final java.util.List<java.lang.String> filePathsExcludes;
        private final java.util.List<java.lang.String> filePathsIncludes;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.branchesExcludes = software.amazon.jsii.Kernel.get(this, "branchesExcludes", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.branchesIncludes = software.amazon.jsii.Kernel.get(this, "branchesIncludes", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.events = software.amazon.jsii.Kernel.get(this, "events", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codepipeline.GitPullRequestEvent.class)));
            this.filePathsExcludes = software.amazon.jsii.Kernel.get(this, "filePathsExcludes", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.filePathsIncludes = software.amazon.jsii.Kernel.get(this, "filePathsIncludes", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.branchesExcludes = builder.branchesExcludes;
            this.branchesIncludes = builder.branchesIncludes;
            this.events = (java.util.List<software.amazon.awscdk.services.codepipeline.GitPullRequestEvent>)builder.events;
            this.filePathsExcludes = builder.filePathsExcludes;
            this.filePathsIncludes = builder.filePathsIncludes;
        }

        @Override
        public final java.util.List<java.lang.String> getBranchesExcludes() {
            return this.branchesExcludes;
        }

        @Override
        public final java.util.List<java.lang.String> getBranchesIncludes() {
            return this.branchesIncludes;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.codepipeline.GitPullRequestEvent> getEvents() {
            return this.events;
        }

        @Override
        public final java.util.List<java.lang.String> getFilePathsExcludes() {
            return this.filePathsExcludes;
        }

        @Override
        public final java.util.List<java.lang.String> getFilePathsIncludes() {
            return this.filePathsIncludes;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getBranchesExcludes() != null) {
                data.set("branchesExcludes", om.valueToTree(this.getBranchesExcludes()));
            }
            if (this.getBranchesIncludes() != null) {
                data.set("branchesIncludes", om.valueToTree(this.getBranchesIncludes()));
            }
            if (this.getEvents() != null) {
                data.set("events", om.valueToTree(this.getEvents()));
            }
            if (this.getFilePathsExcludes() != null) {
                data.set("filePathsExcludes", om.valueToTree(this.getFilePathsExcludes()));
            }
            if (this.getFilePathsIncludes() != null) {
                data.set("filePathsIncludes", om.valueToTree(this.getFilePathsIncludes()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_codepipeline.GitPullRequestFilter"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            GitPullRequestFilter.Jsii$Proxy that = (GitPullRequestFilter.Jsii$Proxy) o;

            if (this.branchesExcludes != null ? !this.branchesExcludes.equals(that.branchesExcludes) : that.branchesExcludes != null) return false;
            if (this.branchesIncludes != null ? !this.branchesIncludes.equals(that.branchesIncludes) : that.branchesIncludes != null) return false;
            if (this.events != null ? !this.events.equals(that.events) : that.events != null) return false;
            if (this.filePathsExcludes != null ? !this.filePathsExcludes.equals(that.filePathsExcludes) : that.filePathsExcludes != null) return false;
            return this.filePathsIncludes != null ? this.filePathsIncludes.equals(that.filePathsIncludes) : that.filePathsIncludes == null;
        }

        @Override
        public final int hashCode() {
            int result = this.branchesExcludes != null ? this.branchesExcludes.hashCode() : 0;
            result = 31 * result + (this.branchesIncludes != null ? this.branchesIncludes.hashCode() : 0);
            result = 31 * result + (this.events != null ? this.events.hashCode() : 0);
            result = 31 * result + (this.filePathsExcludes != null ? this.filePathsExcludes.hashCode() : 0);
            result = 31 * result + (this.filePathsIncludes != null ? this.filePathsIncludes.hashCode() : 0);
            return result;
        }
    }
}
