package software.amazon.awscdk.services.codepipeline;

/**
 * Allows you to control where to place a new Stage when it's added to the Pipeline.
 * <p>
 * Note that you can provide only one of the below properties -
 * specifying more than one will result in a validation error.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // Insert a new Stage at an arbitrary point
 * Pipeline pipeline;
 * IStage anotherStage;
 * IStage yetAnotherStage;
 * IStage someStage = pipeline.addStage(StageOptions.builder()
 *         .stageName("SomeStage")
 *         .placement(StagePlacement.builder()
 *                 // note: you can only specify one of the below properties
 *                 .rightBefore(anotherStage)
 *                 .justAfter(yetAnotherStage)
 *                 .build())
 *         .build());
 * </pre></blockquote>
 * <p>
 * @see <a href=" #justAfter"> #justAfter</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-01-25T00:20:52.772Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_codepipeline.StagePlacement")
@software.amazon.jsii.Jsii.Proxy(StagePlacement.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface StagePlacement extends software.amazon.jsii.JsiiSerializable {

    /**
     * Inserts the new Stage as a child of the given Stage (changing its current child Stage, if it had one).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.codepipeline.IStage getJustAfter() {
        return null;
    }

    /**
     * Inserts the new Stage as a parent of the given Stage (changing its current parent Stage, if it had one).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.codepipeline.IStage getRightBefore() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link StagePlacement}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link StagePlacement}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<StagePlacement> {
        software.amazon.awscdk.services.codepipeline.IStage justAfter;
        software.amazon.awscdk.services.codepipeline.IStage rightBefore;

        /**
         * Sets the value of {@link StagePlacement#getJustAfter}
         * @param justAfter Inserts the new Stage as a child of the given Stage (changing its current child Stage, if it had one).
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder justAfter(software.amazon.awscdk.services.codepipeline.IStage justAfter) {
            this.justAfter = justAfter;
            return this;
        }

        /**
         * Sets the value of {@link StagePlacement#getRightBefore}
         * @param rightBefore Inserts the new Stage as a parent of the given Stage (changing its current parent Stage, if it had one).
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder rightBefore(software.amazon.awscdk.services.codepipeline.IStage rightBefore) {
            this.rightBefore = rightBefore;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link StagePlacement}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public StagePlacement build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link StagePlacement}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements StagePlacement {
        private final software.amazon.awscdk.services.codepipeline.IStage justAfter;
        private final software.amazon.awscdk.services.codepipeline.IStage rightBefore;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.justAfter = software.amazon.jsii.Kernel.get(this, "justAfter", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codepipeline.IStage.class));
            this.rightBefore = software.amazon.jsii.Kernel.get(this, "rightBefore", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codepipeline.IStage.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.justAfter = builder.justAfter;
            this.rightBefore = builder.rightBefore;
        }

        @Override
        public final software.amazon.awscdk.services.codepipeline.IStage getJustAfter() {
            return this.justAfter;
        }

        @Override
        public final software.amazon.awscdk.services.codepipeline.IStage getRightBefore() {
            return this.rightBefore;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getJustAfter() != null) {
                data.set("justAfter", om.valueToTree(this.getJustAfter()));
            }
            if (this.getRightBefore() != null) {
                data.set("rightBefore", om.valueToTree(this.getRightBefore()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_codepipeline.StagePlacement"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            StagePlacement.Jsii$Proxy that = (StagePlacement.Jsii$Proxy) o;

            if (this.justAfter != null ? !this.justAfter.equals(that.justAfter) : that.justAfter != null) return false;
            return this.rightBefore != null ? this.rightBefore.equals(that.rightBefore) : that.rightBefore == null;
        }

        @Override
        public final int hashCode() {
            int result = this.justAfter != null ? this.justAfter.hashCode() : 0;
            result = 31 * result + (this.rightBefore != null ? this.rightBefore.hashCode() : 0);
            return result;
        }
    }
}
