package software.amazon.awscdk.services.codepipeline.actions;

/**
 * CodePipeline action to create/update Stack Instances of a StackSet.
 * <p>
 * After the initial creation of a stack set, you can add new stack instances by
 * using CloudFormationStackInstances. Template parameter values can be
 * overridden at the stack instance level during create or update stack set
 * instance operations.
 * <p>
 * Each stack set has one template and set of template parameters. When you
 * update the template or template parameters, you update them for the entire
 * set. Then all instance statuses are set to OUTDATED until the changes are
 * deployed to that instance.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Pipeline pipeline;
 * Artifact sourceOutput;
 * pipeline.addStage(StageOptions.builder()
 *         .stageName("DeployStackSets")
 *         .actions(List.of(
 *             // First, update the StackSet itself with the newest template
 *             CloudFormationDeployStackSetAction.Builder.create()
 *                     .actionName("UpdateStackSet")
 *                     .runOrder(1)
 *                     .stackSetName("MyStackSet")
 *                     .template(StackSetTemplate.fromArtifactPath(sourceOutput.atPath("template.yaml")))
 *                     // Change this to 'StackSetDeploymentModel.organizations()' if you want to deploy to OUs
 *                     .deploymentModel(StackSetDeploymentModel.selfManaged())
 *                     // This deploys to a set of accounts
 *                     .stackInstances(StackInstances.inAccounts(List.of("111111111111"), List.of("us-east-1", "eu-west-1")))
 *                     .build(),
 *             // Afterwards, update/create additional instances in other accounts
 *             CloudFormationDeployStackInstancesAction.Builder.create()
 *                     .actionName("AddMoreInstances")
 *                     .runOrder(2)
 *                     .stackSetName("MyStackSet")
 *                     .stackInstances(StackInstances.inAccounts(List.of("222222222222", "333333333333"), List.of("us-east-1", "eu-west-1")))
 *                     .build()))
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-01-25T00:20:52.814Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_codepipeline_actions.CloudFormationDeployStackInstancesAction")
public class CloudFormationDeployStackInstancesAction extends software.amazon.awscdk.services.codepipeline.actions.Action {

    protected CloudFormationDeployStackInstancesAction(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CloudFormationDeployStackInstancesAction(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CloudFormationDeployStackInstancesAction(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codepipeline.actions.CloudFormationDeployStackInstancesActionProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * This is a renamed version of the <code>IAction.bind</code> method.
     * <p>
     * @param scope This parameter is required.
     * @param _stage This parameter is required.
     * @param options This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codepipeline.ActionConfig bound(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codepipeline.IStage _stage, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codepipeline.ActionBindOptions options) {
        return software.amazon.jsii.Kernel.call(this, "bound", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codepipeline.ActionConfig.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(_stage, "_stage is required"), java.util.Objects.requireNonNull(options, "options is required") });
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.codepipeline.actions.CloudFormationDeployStackInstancesAction}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.codepipeline.actions.CloudFormationDeployStackInstancesAction> {
        /**
         * @return a new instance of {@link Builder}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create() {
            return new Builder();
        }

        private final software.amazon.awscdk.services.codepipeline.actions.CloudFormationDeployStackInstancesActionProps.Builder props;

        private Builder() {
            this.props = new software.amazon.awscdk.services.codepipeline.actions.CloudFormationDeployStackInstancesActionProps.Builder();
        }

        /**
         * The physical, human-readable name of the Action.
         * <p>
         * Note that Action names must be unique within a single Stage.
         * <p>
         * @return {@code this}
         * @param actionName The physical, human-readable name of the Action. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder actionName(final java.lang.String actionName) {
            this.props.actionName(actionName);
            return this;
        }

        /**
         * The runOrder property for this Action.
         * <p>
         * RunOrder determines the relative order in which multiple Actions in the same Stage execute.
         * <p>
         * Default: 1
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/codepipeline/latest/userguide/reference-pipeline-structure.html">https://docs.aws.amazon.com/codepipeline/latest/userguide/reference-pipeline-structure.html</a>
         * @param runOrder The runOrder property for this Action. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder runOrder(final java.lang.Number runOrder) {
            this.props.runOrder(runOrder);
            return this;
        }

        /**
         * The name of the namespace to use for variables emitted by this action.
         * <p>
         * Default: - a name will be generated, based on the stage and action names,
         * if any of the action's variables were referenced - otherwise,
         * no namespace will be set
         * <p>
         * @return {@code this}
         * @param variablesNamespace The name of the namespace to use for variables emitted by this action. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder variablesNamespace(final java.lang.String variablesNamespace) {
            this.props.variablesNamespace(variablesNamespace);
            return this;
        }

        /**
         * The Role in which context's this Action will be executing in.
         * <p>
         * The Pipeline's Role will assume this Role
         * (the required permissions for that will be granted automatically)
         * right before executing this Action.
         * This Action will be passed into your <code>IAction.bind</code>
         * method in the <code>ActionBindOptions.role</code> property.
         * <p>
         * Default: a new Role will be generated
         * <p>
         * @return {@code this}
         * @param role The Role in which context's this Action will be executing in. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder role(final software.amazon.awscdk.services.iam.IRole role) {
            this.props.role(role);
            return this;
        }

        /**
         * The percentage of accounts per Region for which this stack operation can fail before AWS CloudFormation stops the operation in that Region.
         * <p>
         * If
         * the operation is stopped in a Region, AWS CloudFormation doesn't attempt the operation in subsequent Regions. When calculating the number
         * of accounts based on the specified percentage, AWS CloudFormation rounds down to the next whole number.
         * <p>
         * Default: 0%
         * <p>
         * @return {@code this}
         * @param failureTolerancePercentage The percentage of accounts per Region for which this stack operation can fail before AWS CloudFormation stops the operation in that Region. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder failureTolerancePercentage(final java.lang.Number failureTolerancePercentage) {
            this.props.failureTolerancePercentage(failureTolerancePercentage);
            return this;
        }

        /**
         * The maximum percentage of accounts in which to perform this operation at one time.
         * <p>
         * When calculating the number of accounts based on the specified
         * percentage, AWS CloudFormation rounds down to the next whole number. If rounding down would result in zero, AWS CloudFormation sets the number as
         * one instead. Although you use this setting to specify the maximum, for large deployments the actual number of accounts acted upon concurrently
         * may be lower due to service throttling.
         * <p>
         * Default: 1%
         * <p>
         * @return {@code this}
         * @param maxAccountConcurrencyPercentage The maximum percentage of accounts in which to perform this operation at one time. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxAccountConcurrencyPercentage(final java.lang.Number maxAccountConcurrencyPercentage) {
            this.props.maxAccountConcurrencyPercentage(maxAccountConcurrencyPercentage);
            return this;
        }

        /**
         * The AWS Region the StackSet is in.
         * <p>
         * Note that a cross-region Pipeline requires replication buckets to function correctly.
         * You can provide their names with the <code>PipelineProps.crossRegionReplicationBuckets</code> property.
         * If you don't, the CodePipeline Construct will create new Stacks in your CDK app containing those buckets,
         * that you will need to <code>cdk deploy</code> before deploying the main, Pipeline-containing Stack.
         * <p>
         * Default: - same region as the Pipeline
         * <p>
         * @return {@code this}
         * @param stackSetRegion The AWS Region the StackSet is in. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder stackSetRegion(final java.lang.String stackSetRegion) {
            this.props.stackSetRegion(stackSetRegion);
            return this;
        }

        /**
         * Specify where to create or update Stack Instances.
         * <p>
         * You can specify either AWS Accounts Ids or AWS Organizations Organizational Units.
         * <p>
         * @return {@code this}
         * @param stackInstances Specify where to create or update Stack Instances. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder stackInstances(final software.amazon.awscdk.services.codepipeline.actions.StackInstances stackInstances) {
            this.props.stackInstances(stackInstances);
            return this;
        }

        /**
         * The name of the StackSet we are adding instances to.
         * <p>
         * @return {@code this}
         * @param stackSetName The name of the StackSet we are adding instances to. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder stackSetName(final java.lang.String stackSetName) {
            this.props.stackSetName(stackSetName);
            return this;
        }

        /**
         * Parameter values that only apply to the current Stack Instances.
         * <p>
         * These parameters are shared between all instances added by this action.
         * <p>
         * Default: - no parameters will be overridden
         * <p>
         * @return {@code this}
         * @param parameterOverrides Parameter values that only apply to the current Stack Instances. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder parameterOverrides(final software.amazon.awscdk.services.codepipeline.actions.StackSetParameters parameterOverrides) {
            this.props.parameterOverrides(parameterOverrides);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.codepipeline.actions.CloudFormationDeployStackInstancesAction}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.codepipeline.actions.CloudFormationDeployStackInstancesAction build() {
            return new software.amazon.awscdk.services.codepipeline.actions.CloudFormationDeployStackInstancesAction(
                this.props.build()
            );
        }
    }
}
