package software.amazon.awscdk.services.cognito;

/**
 * Properties for defining a <code>CfnUserPoolDomain</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.cognito.*;
 * CfnUserPoolDomainProps cfnUserPoolDomainProps = CfnUserPoolDomainProps.builder()
 *         .domain("domain")
 *         .userPoolId("userPoolId")
 *         // the properties below are optional
 *         .customDomainConfig(CustomDomainConfigTypeProperty.builder()
 *                 .certificateArn("certificateArn")
 *                 .build())
 *         .managedLoginVersion(123)
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpooldomain.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpooldomain.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-01-25T00:20:52.989Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cognito.CfnUserPoolDomainProps")
@software.amazon.jsii.Jsii.Proxy(CfnUserPoolDomainProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnUserPoolDomainProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The name of the domain that you want to update.
     * <p>
     * For custom domains, this is the fully-qualified domain name, for example <code>auth.example.com</code> . For prefix domains, this is the prefix alone, such as <code>myprefix</code> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpooldomain.html#cfn-cognito-userpooldomain-domain">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpooldomain.html#cfn-cognito-userpooldomain-domain</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getDomain();

    /**
     * The ID of the user pool that is associated with the domain you're updating.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpooldomain.html#cfn-cognito-userpooldomain-userpoolid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpooldomain.html#cfn-cognito-userpooldomain-userpoolid</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getUserPoolId();

    /**
     * The configuration for a custom domain that hosts the sign-up and sign-in pages for your application.
     * <p>
     * Use this object to specify an SSL certificate that is managed by ACM.
     * <p>
     * When you create a custom domain, the passkey RP ID defaults to the custom domain. If you had a prefix domain active, this will cause passkey integration for your prefix domain to stop working due to a mismatch in RP ID. To keep the prefix domain passkey integration working, you can explicitly set RP ID to the prefix domain.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpooldomain.html#cfn-cognito-userpooldomain-customdomainconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpooldomain.html#cfn-cognito-userpooldomain-customdomainconfig</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getCustomDomainConfig() {
        return null;
    }

    /**
     * A version number that indicates the state of managed login for your domain.
     * <p>
     * Version <code>1</code> is hosted UI (classic). Version <code>2</code> is the newer managed login with the branding designer. For more information, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pools-managed-login.html">Managed login</a> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpooldomain.html#cfn-cognito-userpooldomain-managedloginversion">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpooldomain.html#cfn-cognito-userpooldomain-managedloginversion</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getManagedLoginVersion() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnUserPoolDomainProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnUserPoolDomainProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnUserPoolDomainProps> {
        java.lang.String domain;
        java.lang.String userPoolId;
        java.lang.Object customDomainConfig;
        java.lang.Number managedLoginVersion;

        /**
         * Sets the value of {@link CfnUserPoolDomainProps#getDomain}
         * @param domain The name of the domain that you want to update. This parameter is required.
         *               For custom domains, this is the fully-qualified domain name, for example <code>auth.example.com</code> . For prefix domains, this is the prefix alone, such as <code>myprefix</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder domain(java.lang.String domain) {
            this.domain = domain;
            return this;
        }

        /**
         * Sets the value of {@link CfnUserPoolDomainProps#getUserPoolId}
         * @param userPoolId The ID of the user pool that is associated with the domain you're updating. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder userPoolId(java.lang.String userPoolId) {
            this.userPoolId = userPoolId;
            return this;
        }

        /**
         * Sets the value of {@link CfnUserPoolDomainProps#getCustomDomainConfig}
         * @param customDomainConfig The configuration for a custom domain that hosts the sign-up and sign-in pages for your application.
         *                           Use this object to specify an SSL certificate that is managed by ACM.
         *                           <p>
         *                           When you create a custom domain, the passkey RP ID defaults to the custom domain. If you had a prefix domain active, this will cause passkey integration for your prefix domain to stop working due to a mismatch in RP ID. To keep the prefix domain passkey integration working, you can explicitly set RP ID to the prefix domain.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder customDomainConfig(software.amazon.awscdk.IResolvable customDomainConfig) {
            this.customDomainConfig = customDomainConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnUserPoolDomainProps#getCustomDomainConfig}
         * @param customDomainConfig The configuration for a custom domain that hosts the sign-up and sign-in pages for your application.
         *                           Use this object to specify an SSL certificate that is managed by ACM.
         *                           <p>
         *                           When you create a custom domain, the passkey RP ID defaults to the custom domain. If you had a prefix domain active, this will cause passkey integration for your prefix domain to stop working due to a mismatch in RP ID. To keep the prefix domain passkey integration working, you can explicitly set RP ID to the prefix domain.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder customDomainConfig(software.amazon.awscdk.services.cognito.CfnUserPoolDomain.CustomDomainConfigTypeProperty customDomainConfig) {
            this.customDomainConfig = customDomainConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnUserPoolDomainProps#getManagedLoginVersion}
         * @param managedLoginVersion A version number that indicates the state of managed login for your domain.
         *                            Version <code>1</code> is hosted UI (classic). Version <code>2</code> is the newer managed login with the branding designer. For more information, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pools-managed-login.html">Managed login</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder managedLoginVersion(java.lang.Number managedLoginVersion) {
            this.managedLoginVersion = managedLoginVersion;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnUserPoolDomainProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnUserPoolDomainProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnUserPoolDomainProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnUserPoolDomainProps {
        private final java.lang.String domain;
        private final java.lang.String userPoolId;
        private final java.lang.Object customDomainConfig;
        private final java.lang.Number managedLoginVersion;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.domain = software.amazon.jsii.Kernel.get(this, "domain", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.userPoolId = software.amazon.jsii.Kernel.get(this, "userPoolId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.customDomainConfig = software.amazon.jsii.Kernel.get(this, "customDomainConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.managedLoginVersion = software.amazon.jsii.Kernel.get(this, "managedLoginVersion", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.domain = java.util.Objects.requireNonNull(builder.domain, "domain is required");
            this.userPoolId = java.util.Objects.requireNonNull(builder.userPoolId, "userPoolId is required");
            this.customDomainConfig = builder.customDomainConfig;
            this.managedLoginVersion = builder.managedLoginVersion;
        }

        @Override
        public final java.lang.String getDomain() {
            return this.domain;
        }

        @Override
        public final java.lang.String getUserPoolId() {
            return this.userPoolId;
        }

        @Override
        public final java.lang.Object getCustomDomainConfig() {
            return this.customDomainConfig;
        }

        @Override
        public final java.lang.Number getManagedLoginVersion() {
            return this.managedLoginVersion;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("domain", om.valueToTree(this.getDomain()));
            data.set("userPoolId", om.valueToTree(this.getUserPoolId()));
            if (this.getCustomDomainConfig() != null) {
                data.set("customDomainConfig", om.valueToTree(this.getCustomDomainConfig()));
            }
            if (this.getManagedLoginVersion() != null) {
                data.set("managedLoginVersion", om.valueToTree(this.getManagedLoginVersion()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cognito.CfnUserPoolDomainProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnUserPoolDomainProps.Jsii$Proxy that = (CfnUserPoolDomainProps.Jsii$Proxy) o;

            if (!domain.equals(that.domain)) return false;
            if (!userPoolId.equals(that.userPoolId)) return false;
            if (this.customDomainConfig != null ? !this.customDomainConfig.equals(that.customDomainConfig) : that.customDomainConfig != null) return false;
            return this.managedLoginVersion != null ? this.managedLoginVersion.equals(that.managedLoginVersion) : that.managedLoginVersion == null;
        }

        @Override
        public final int hashCode() {
            int result = this.domain.hashCode();
            result = 31 * result + (this.userPoolId.hashCode());
            result = 31 * result + (this.customDomainConfig != null ? this.customDomainConfig.hashCode() : 0);
            result = 31 * result + (this.managedLoginVersion != null ? this.managedLoginVersion.hashCode() : 0);
            return result;
        }
    }
}
