package software.amazon.awscdk.services.cognito;

/**
 * Configuration that will be fed into CloudFormation for any custom attribute type.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.cognito.*;
 * CustomAttributeConfig customAttributeConfig = CustomAttributeConfig.builder()
 *         .dataType("dataType")
 *         // the properties below are optional
 *         .mutable(false)
 *         .numberConstraints(NumberAttributeConstraints.builder()
 *                 .max(123)
 *                 .min(123)
 *                 .build())
 *         .stringConstraints(StringAttributeConstraints.builder()
 *                 .maxLen(123)
 *                 .minLen(123)
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-01-25T00:20:53.024Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cognito.CustomAttributeConfig")
@software.amazon.jsii.Jsii.Proxy(CustomAttributeConfig.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CustomAttributeConfig extends software.amazon.jsii.JsiiSerializable {

    /**
     * The data type of the custom attribute.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_SchemaAttributeType.html#CognitoUserPools-Type-SchemaAttributeType-AttributeDataType">https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_SchemaAttributeType.html#CognitoUserPools-Type-SchemaAttributeType-AttributeDataType</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getDataType();

    /**
     * Specifies whether the value of the attribute can be changed.
     * <p>
     * For any user pool attribute that's mapped to an identity provider attribute, you must set this parameter to true.
     * Amazon Cognito updates mapped attributes when users sign in to your application through an identity provider.
     * If an attribute is immutable, Amazon Cognito throws an error when it attempts to update the attribute.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getMutable() {
        return null;
    }

    /**
     * The constraints for a custom attribute of the 'Number' data type.
     * <p>
     * Default: - None.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cognito.NumberAttributeConstraints getNumberConstraints() {
        return null;
    }

    /**
     * The constraints for a custom attribute of 'String' data type.
     * <p>
     * Default: - None.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cognito.StringAttributeConstraints getStringConstraints() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CustomAttributeConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CustomAttributeConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CustomAttributeConfig> {
        java.lang.String dataType;
        java.lang.Boolean mutable;
        software.amazon.awscdk.services.cognito.NumberAttributeConstraints numberConstraints;
        software.amazon.awscdk.services.cognito.StringAttributeConstraints stringConstraints;

        /**
         * Sets the value of {@link CustomAttributeConfig#getDataType}
         * @param dataType The data type of the custom attribute. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dataType(java.lang.String dataType) {
            this.dataType = dataType;
            return this;
        }

        /**
         * Sets the value of {@link CustomAttributeConfig#getMutable}
         * @param mutable Specifies whether the value of the attribute can be changed.
         *                For any user pool attribute that's mapped to an identity provider attribute, you must set this parameter to true.
         *                Amazon Cognito updates mapped attributes when users sign in to your application through an identity provider.
         *                If an attribute is immutable, Amazon Cognito throws an error when it attempts to update the attribute.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder mutable(java.lang.Boolean mutable) {
            this.mutable = mutable;
            return this;
        }

        /**
         * Sets the value of {@link CustomAttributeConfig#getNumberConstraints}
         * @param numberConstraints The constraints for a custom attribute of the 'Number' data type.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder numberConstraints(software.amazon.awscdk.services.cognito.NumberAttributeConstraints numberConstraints) {
            this.numberConstraints = numberConstraints;
            return this;
        }

        /**
         * Sets the value of {@link CustomAttributeConfig#getStringConstraints}
         * @param stringConstraints The constraints for a custom attribute of 'String' data type.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder stringConstraints(software.amazon.awscdk.services.cognito.StringAttributeConstraints stringConstraints) {
            this.stringConstraints = stringConstraints;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CustomAttributeConfig}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CustomAttributeConfig build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CustomAttributeConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CustomAttributeConfig {
        private final java.lang.String dataType;
        private final java.lang.Boolean mutable;
        private final software.amazon.awscdk.services.cognito.NumberAttributeConstraints numberConstraints;
        private final software.amazon.awscdk.services.cognito.StringAttributeConstraints stringConstraints;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.dataType = software.amazon.jsii.Kernel.get(this, "dataType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.mutable = software.amazon.jsii.Kernel.get(this, "mutable", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.numberConstraints = software.amazon.jsii.Kernel.get(this, "numberConstraints", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cognito.NumberAttributeConstraints.class));
            this.stringConstraints = software.amazon.jsii.Kernel.get(this, "stringConstraints", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cognito.StringAttributeConstraints.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.dataType = java.util.Objects.requireNonNull(builder.dataType, "dataType is required");
            this.mutable = builder.mutable;
            this.numberConstraints = builder.numberConstraints;
            this.stringConstraints = builder.stringConstraints;
        }

        @Override
        public final java.lang.String getDataType() {
            return this.dataType;
        }

        @Override
        public final java.lang.Boolean getMutable() {
            return this.mutable;
        }

        @Override
        public final software.amazon.awscdk.services.cognito.NumberAttributeConstraints getNumberConstraints() {
            return this.numberConstraints;
        }

        @Override
        public final software.amazon.awscdk.services.cognito.StringAttributeConstraints getStringConstraints() {
            return this.stringConstraints;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("dataType", om.valueToTree(this.getDataType()));
            if (this.getMutable() != null) {
                data.set("mutable", om.valueToTree(this.getMutable()));
            }
            if (this.getNumberConstraints() != null) {
                data.set("numberConstraints", om.valueToTree(this.getNumberConstraints()));
            }
            if (this.getStringConstraints() != null) {
                data.set("stringConstraints", om.valueToTree(this.getStringConstraints()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cognito.CustomAttributeConfig"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CustomAttributeConfig.Jsii$Proxy that = (CustomAttributeConfig.Jsii$Proxy) o;

            if (!dataType.equals(that.dataType)) return false;
            if (this.mutable != null ? !this.mutable.equals(that.mutable) : that.mutable != null) return false;
            if (this.numberConstraints != null ? !this.numberConstraints.equals(that.numberConstraints) : that.numberConstraints != null) return false;
            return this.stringConstraints != null ? this.stringConstraints.equals(that.stringConstraints) : that.stringConstraints == null;
        }

        @Override
        public final int hashCode() {
            int result = this.dataType.hashCode();
            result = 31 * result + (this.mutable != null ? this.mutable.hashCode() : 0);
            result = 31 * result + (this.numberConstraints != null ? this.numberConstraints.hashCode() : 0);
            result = 31 * result + (this.stringConstraints != null ? this.stringConstraints.hashCode() : 0);
            return result;
        }
    }
}
