package software.amazon.awscdk.services.datazone;

/**
 * Properties for defining a <code>CfnSubscriptionTarget</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.datazone.*;
 * CfnSubscriptionTargetProps cfnSubscriptionTargetProps = CfnSubscriptionTargetProps.builder()
 *         .applicableAssetTypes(List.of("applicableAssetTypes"))
 *         .authorizedPrincipals(List.of("authorizedPrincipals"))
 *         .domainIdentifier("domainIdentifier")
 *         .environmentIdentifier("environmentIdentifier")
 *         .name("name")
 *         .subscriptionTargetConfig(List.of(SubscriptionTargetFormProperty.builder()
 *                 .content("content")
 *                 .formName("formName")
 *                 .build()))
 *         .type("type")
 *         // the properties below are optional
 *         .manageAccessRole("manageAccessRole")
 *         .provider("provider")
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datazone-subscriptiontarget.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datazone-subscriptiontarget.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-01-25T00:20:53.602Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_datazone.CfnSubscriptionTargetProps")
@software.amazon.jsii.Jsii.Proxy(CfnSubscriptionTargetProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnSubscriptionTargetProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The asset types included in the subscription target.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datazone-subscriptiontarget.html#cfn-datazone-subscriptiontarget-applicableassettypes">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datazone-subscriptiontarget.html#cfn-datazone-subscriptiontarget-applicableassettypes</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getApplicableAssetTypes();

    /**
     * The authorized principals included in the subscription target.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datazone-subscriptiontarget.html#cfn-datazone-subscriptiontarget-authorizedprincipals">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datazone-subscriptiontarget.html#cfn-datazone-subscriptiontarget-authorizedprincipals</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getAuthorizedPrincipals();

    /**
     * The ID of the Amazon DataZone domain in which subscription target is created.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datazone-subscriptiontarget.html#cfn-datazone-subscriptiontarget-domainidentifier">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datazone-subscriptiontarget.html#cfn-datazone-subscriptiontarget-domainidentifier</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getDomainIdentifier();

    /**
     * The ID of the environment in which subscription target is created.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datazone-subscriptiontarget.html#cfn-datazone-subscriptiontarget-environmentidentifier">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datazone-subscriptiontarget.html#cfn-datazone-subscriptiontarget-environmentidentifier</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getEnvironmentIdentifier();

    /**
     * The name of the subscription target.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datazone-subscriptiontarget.html#cfn-datazone-subscriptiontarget-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datazone-subscriptiontarget.html#cfn-datazone-subscriptiontarget-name</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getName();

    /**
     * The configuration of the subscription target.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datazone-subscriptiontarget.html#cfn-datazone-subscriptiontarget-subscriptiontargetconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datazone-subscriptiontarget.html#cfn-datazone-subscriptiontarget-subscriptiontargetconfig</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getSubscriptionTargetConfig();

    /**
     * The type of the subscription target.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datazone-subscriptiontarget.html#cfn-datazone-subscriptiontarget-type">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datazone-subscriptiontarget.html#cfn-datazone-subscriptiontarget-type</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getType();

    /**
     * The manage access role that is used to create the subscription target.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datazone-subscriptiontarget.html#cfn-datazone-subscriptiontarget-manageaccessrole">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datazone-subscriptiontarget.html#cfn-datazone-subscriptiontarget-manageaccessrole</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getManageAccessRole() {
        return null;
    }

    /**
     * The provider of the subscription target.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datazone-subscriptiontarget.html#cfn-datazone-subscriptiontarget-provider">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datazone-subscriptiontarget.html#cfn-datazone-subscriptiontarget-provider</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getProvider() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnSubscriptionTargetProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnSubscriptionTargetProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnSubscriptionTargetProps> {
        java.util.List<java.lang.String> applicableAssetTypes;
        java.util.List<java.lang.String> authorizedPrincipals;
        java.lang.String domainIdentifier;
        java.lang.String environmentIdentifier;
        java.lang.String name;
        java.lang.Object subscriptionTargetConfig;
        java.lang.String type;
        java.lang.String manageAccessRole;
        java.lang.String provider;

        /**
         * Sets the value of {@link CfnSubscriptionTargetProps#getApplicableAssetTypes}
         * @param applicableAssetTypes The asset types included in the subscription target. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder applicableAssetTypes(java.util.List<java.lang.String> applicableAssetTypes) {
            this.applicableAssetTypes = applicableAssetTypes;
            return this;
        }

        /**
         * Sets the value of {@link CfnSubscriptionTargetProps#getAuthorizedPrincipals}
         * @param authorizedPrincipals The authorized principals included in the subscription target. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder authorizedPrincipals(java.util.List<java.lang.String> authorizedPrincipals) {
            this.authorizedPrincipals = authorizedPrincipals;
            return this;
        }

        /**
         * Sets the value of {@link CfnSubscriptionTargetProps#getDomainIdentifier}
         * @param domainIdentifier The ID of the Amazon DataZone domain in which subscription target is created. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder domainIdentifier(java.lang.String domainIdentifier) {
            this.domainIdentifier = domainIdentifier;
            return this;
        }

        /**
         * Sets the value of {@link CfnSubscriptionTargetProps#getEnvironmentIdentifier}
         * @param environmentIdentifier The ID of the environment in which subscription target is created. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder environmentIdentifier(java.lang.String environmentIdentifier) {
            this.environmentIdentifier = environmentIdentifier;
            return this;
        }

        /**
         * Sets the value of {@link CfnSubscriptionTargetProps#getName}
         * @param name The name of the subscription target. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of {@link CfnSubscriptionTargetProps#getSubscriptionTargetConfig}
         * @param subscriptionTargetConfig The configuration of the subscription target. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder subscriptionTargetConfig(software.amazon.awscdk.IResolvable subscriptionTargetConfig) {
            this.subscriptionTargetConfig = subscriptionTargetConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnSubscriptionTargetProps#getSubscriptionTargetConfig}
         * @param subscriptionTargetConfig The configuration of the subscription target. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder subscriptionTargetConfig(java.util.List<? extends java.lang.Object> subscriptionTargetConfig) {
            this.subscriptionTargetConfig = subscriptionTargetConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnSubscriptionTargetProps#getType}
         * @param type The type of the subscription target. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder type(java.lang.String type) {
            this.type = type;
            return this;
        }

        /**
         * Sets the value of {@link CfnSubscriptionTargetProps#getManageAccessRole}
         * @param manageAccessRole The manage access role that is used to create the subscription target.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder manageAccessRole(java.lang.String manageAccessRole) {
            this.manageAccessRole = manageAccessRole;
            return this;
        }

        /**
         * Sets the value of {@link CfnSubscriptionTargetProps#getProvider}
         * @param provider The provider of the subscription target.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder provider(java.lang.String provider) {
            this.provider = provider;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnSubscriptionTargetProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnSubscriptionTargetProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnSubscriptionTargetProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnSubscriptionTargetProps {
        private final java.util.List<java.lang.String> applicableAssetTypes;
        private final java.util.List<java.lang.String> authorizedPrincipals;
        private final java.lang.String domainIdentifier;
        private final java.lang.String environmentIdentifier;
        private final java.lang.String name;
        private final java.lang.Object subscriptionTargetConfig;
        private final java.lang.String type;
        private final java.lang.String manageAccessRole;
        private final java.lang.String provider;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.applicableAssetTypes = software.amazon.jsii.Kernel.get(this, "applicableAssetTypes", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.authorizedPrincipals = software.amazon.jsii.Kernel.get(this, "authorizedPrincipals", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.domainIdentifier = software.amazon.jsii.Kernel.get(this, "domainIdentifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.environmentIdentifier = software.amazon.jsii.Kernel.get(this, "environmentIdentifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.subscriptionTargetConfig = software.amazon.jsii.Kernel.get(this, "subscriptionTargetConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.type = software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.manageAccessRole = software.amazon.jsii.Kernel.get(this, "manageAccessRole", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.provider = software.amazon.jsii.Kernel.get(this, "provider", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.applicableAssetTypes = java.util.Objects.requireNonNull(builder.applicableAssetTypes, "applicableAssetTypes is required");
            this.authorizedPrincipals = java.util.Objects.requireNonNull(builder.authorizedPrincipals, "authorizedPrincipals is required");
            this.domainIdentifier = java.util.Objects.requireNonNull(builder.domainIdentifier, "domainIdentifier is required");
            this.environmentIdentifier = java.util.Objects.requireNonNull(builder.environmentIdentifier, "environmentIdentifier is required");
            this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
            this.subscriptionTargetConfig = java.util.Objects.requireNonNull(builder.subscriptionTargetConfig, "subscriptionTargetConfig is required");
            this.type = java.util.Objects.requireNonNull(builder.type, "type is required");
            this.manageAccessRole = builder.manageAccessRole;
            this.provider = builder.provider;
        }

        @Override
        public final java.util.List<java.lang.String> getApplicableAssetTypes() {
            return this.applicableAssetTypes;
        }

        @Override
        public final java.util.List<java.lang.String> getAuthorizedPrincipals() {
            return this.authorizedPrincipals;
        }

        @Override
        public final java.lang.String getDomainIdentifier() {
            return this.domainIdentifier;
        }

        @Override
        public final java.lang.String getEnvironmentIdentifier() {
            return this.environmentIdentifier;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        public final java.lang.Object getSubscriptionTargetConfig() {
            return this.subscriptionTargetConfig;
        }

        @Override
        public final java.lang.String getType() {
            return this.type;
        }

        @Override
        public final java.lang.String getManageAccessRole() {
            return this.manageAccessRole;
        }

        @Override
        public final java.lang.String getProvider() {
            return this.provider;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("applicableAssetTypes", om.valueToTree(this.getApplicableAssetTypes()));
            data.set("authorizedPrincipals", om.valueToTree(this.getAuthorizedPrincipals()));
            data.set("domainIdentifier", om.valueToTree(this.getDomainIdentifier()));
            data.set("environmentIdentifier", om.valueToTree(this.getEnvironmentIdentifier()));
            data.set("name", om.valueToTree(this.getName()));
            data.set("subscriptionTargetConfig", om.valueToTree(this.getSubscriptionTargetConfig()));
            data.set("type", om.valueToTree(this.getType()));
            if (this.getManageAccessRole() != null) {
                data.set("manageAccessRole", om.valueToTree(this.getManageAccessRole()));
            }
            if (this.getProvider() != null) {
                data.set("provider", om.valueToTree(this.getProvider()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_datazone.CfnSubscriptionTargetProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnSubscriptionTargetProps.Jsii$Proxy that = (CfnSubscriptionTargetProps.Jsii$Proxy) o;

            if (!applicableAssetTypes.equals(that.applicableAssetTypes)) return false;
            if (!authorizedPrincipals.equals(that.authorizedPrincipals)) return false;
            if (!domainIdentifier.equals(that.domainIdentifier)) return false;
            if (!environmentIdentifier.equals(that.environmentIdentifier)) return false;
            if (!name.equals(that.name)) return false;
            if (!subscriptionTargetConfig.equals(that.subscriptionTargetConfig)) return false;
            if (!type.equals(that.type)) return false;
            if (this.manageAccessRole != null ? !this.manageAccessRole.equals(that.manageAccessRole) : that.manageAccessRole != null) return false;
            return this.provider != null ? this.provider.equals(that.provider) : that.provider == null;
        }

        @Override
        public final int hashCode() {
            int result = this.applicableAssetTypes.hashCode();
            result = 31 * result + (this.authorizedPrincipals.hashCode());
            result = 31 * result + (this.domainIdentifier.hashCode());
            result = 31 * result + (this.environmentIdentifier.hashCode());
            result = 31 * result + (this.name.hashCode());
            result = 31 * result + (this.subscriptionTargetConfig.hashCode());
            result = 31 * result + (this.type.hashCode());
            result = 31 * result + (this.manageAccessRole != null ? this.manageAccessRole.hashCode() : 0);
            result = 31 * result + (this.provider != null ? this.provider.hashCode() : 0);
            return result;
        }
    }
}
