package software.amazon.awscdk.services.devicefarm;

/**
 * Properties for defining a <code>CfnNetworkProfile</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.devicefarm.*;
 * CfnNetworkProfileProps cfnNetworkProfileProps = CfnNetworkProfileProps.builder()
 *         .name("name")
 *         .projectArn("projectArn")
 *         // the properties below are optional
 *         .description("description")
 *         .downlinkBandwidthBits(123)
 *         .downlinkDelayMs(123)
 *         .downlinkJitterMs(123)
 *         .downlinkLossPercent(123)
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .uplinkBandwidthBits(123)
 *         .uplinkDelayMs(123)
 *         .uplinkJitterMs(123)
 *         .uplinkLossPercent(123)
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-devicefarm-networkprofile.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-devicefarm-networkprofile.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-01-25T00:20:53.661Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_devicefarm.CfnNetworkProfileProps")
@software.amazon.jsii.Jsii.Proxy(CfnNetworkProfileProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnNetworkProfileProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The name of the network profile.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-devicefarm-networkprofile.html#cfn-devicefarm-networkprofile-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-devicefarm-networkprofile.html#cfn-devicefarm-networkprofile-name</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getName();

    /**
     * The Amazon Resource Name (ARN) of the specified project.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-devicefarm-networkprofile.html#cfn-devicefarm-networkprofile-projectarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-devicefarm-networkprofile.html#cfn-devicefarm-networkprofile-projectarn</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getProjectArn();

    /**
     * The description of the network profile.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-devicefarm-networkprofile.html#cfn-devicefarm-networkprofile-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-devicefarm-networkprofile.html#cfn-devicefarm-networkprofile-description</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return null;
    }

    /**
     * The data throughput rate in bits per second, as an integer from 0 to 104857600.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-devicefarm-networkprofile.html#cfn-devicefarm-networkprofile-downlinkbandwidthbits">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-devicefarm-networkprofile.html#cfn-devicefarm-networkprofile-downlinkbandwidthbits</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getDownlinkBandwidthBits() {
        return null;
    }

    /**
     * Delay time for all packets to destination in milliseconds as an integer from 0 to 2000.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-devicefarm-networkprofile.html#cfn-devicefarm-networkprofile-downlinkdelayms">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-devicefarm-networkprofile.html#cfn-devicefarm-networkprofile-downlinkdelayms</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getDownlinkDelayMs() {
        return null;
    }

    /**
     * Time variation in the delay of received packets in milliseconds as an integer from 0 to 2000.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-devicefarm-networkprofile.html#cfn-devicefarm-networkprofile-downlinkjitterms">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-devicefarm-networkprofile.html#cfn-devicefarm-networkprofile-downlinkjitterms</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getDownlinkJitterMs() {
        return null;
    }

    /**
     * Proportion of received packets that fail to arrive from 0 to 100 percent.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-devicefarm-networkprofile.html#cfn-devicefarm-networkprofile-downlinklosspercent">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-devicefarm-networkprofile.html#cfn-devicefarm-networkprofile-downlinklosspercent</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getDownlinkLossPercent() {
        return null;
    }

    /**
     * An array of key-value pairs to apply to this resource.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html">Tag</a> in the <em>guide</em> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-devicefarm-networkprofile.html#cfn-devicefarm-networkprofile-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-devicefarm-networkprofile.html#cfn-devicefarm-networkprofile-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * The data throughput rate in bits per second, as an integer from 0 to 104857600.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-devicefarm-networkprofile.html#cfn-devicefarm-networkprofile-uplinkbandwidthbits">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-devicefarm-networkprofile.html#cfn-devicefarm-networkprofile-uplinkbandwidthbits</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getUplinkBandwidthBits() {
        return null;
    }

    /**
     * Delay time for all packets to destination in milliseconds as an integer from 0 to 2000.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-devicefarm-networkprofile.html#cfn-devicefarm-networkprofile-uplinkdelayms">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-devicefarm-networkprofile.html#cfn-devicefarm-networkprofile-uplinkdelayms</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getUplinkDelayMs() {
        return null;
    }

    /**
     * Time variation in the delay of received packets in milliseconds as an integer from 0 to 2000.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-devicefarm-networkprofile.html#cfn-devicefarm-networkprofile-uplinkjitterms">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-devicefarm-networkprofile.html#cfn-devicefarm-networkprofile-uplinkjitterms</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getUplinkJitterMs() {
        return null;
    }

    /**
     * Proportion of transmitted packets that fail to arrive from 0 to 100 percent.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-devicefarm-networkprofile.html#cfn-devicefarm-networkprofile-uplinklosspercent">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-devicefarm-networkprofile.html#cfn-devicefarm-networkprofile-uplinklosspercent</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getUplinkLossPercent() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnNetworkProfileProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnNetworkProfileProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnNetworkProfileProps> {
        java.lang.String name;
        java.lang.String projectArn;
        java.lang.String description;
        java.lang.Number downlinkBandwidthBits;
        java.lang.Number downlinkDelayMs;
        java.lang.Number downlinkJitterMs;
        java.lang.Number downlinkLossPercent;
        java.util.List<software.amazon.awscdk.CfnTag> tags;
        java.lang.Number uplinkBandwidthBits;
        java.lang.Number uplinkDelayMs;
        java.lang.Number uplinkJitterMs;
        java.lang.Number uplinkLossPercent;

        /**
         * Sets the value of {@link CfnNetworkProfileProps#getName}
         * @param name The name of the network profile. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of {@link CfnNetworkProfileProps#getProjectArn}
         * @param projectArn The Amazon Resource Name (ARN) of the specified project. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder projectArn(java.lang.String projectArn) {
            this.projectArn = projectArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnNetworkProfileProps#getDescription}
         * @param description The description of the network profile.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link CfnNetworkProfileProps#getDownlinkBandwidthBits}
         * @param downlinkBandwidthBits The data throughput rate in bits per second, as an integer from 0 to 104857600.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder downlinkBandwidthBits(java.lang.Number downlinkBandwidthBits) {
            this.downlinkBandwidthBits = downlinkBandwidthBits;
            return this;
        }

        /**
         * Sets the value of {@link CfnNetworkProfileProps#getDownlinkDelayMs}
         * @param downlinkDelayMs Delay time for all packets to destination in milliseconds as an integer from 0 to 2000.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder downlinkDelayMs(java.lang.Number downlinkDelayMs) {
            this.downlinkDelayMs = downlinkDelayMs;
            return this;
        }

        /**
         * Sets the value of {@link CfnNetworkProfileProps#getDownlinkJitterMs}
         * @param downlinkJitterMs Time variation in the delay of received packets in milliseconds as an integer from 0 to 2000.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder downlinkJitterMs(java.lang.Number downlinkJitterMs) {
            this.downlinkJitterMs = downlinkJitterMs;
            return this;
        }

        /**
         * Sets the value of {@link CfnNetworkProfileProps#getDownlinkLossPercent}
         * @param downlinkLossPercent Proportion of received packets that fail to arrive from 0 to 100 percent.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder downlinkLossPercent(java.lang.Number downlinkLossPercent) {
            this.downlinkLossPercent = downlinkLossPercent;
            return this;
        }

        /**
         * Sets the value of {@link CfnNetworkProfileProps#getTags}
         * @param tags An array of key-value pairs to apply to this resource.
         *             For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html">Tag</a> in the <em>guide</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Sets the value of {@link CfnNetworkProfileProps#getUplinkBandwidthBits}
         * @param uplinkBandwidthBits The data throughput rate in bits per second, as an integer from 0 to 104857600.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder uplinkBandwidthBits(java.lang.Number uplinkBandwidthBits) {
            this.uplinkBandwidthBits = uplinkBandwidthBits;
            return this;
        }

        /**
         * Sets the value of {@link CfnNetworkProfileProps#getUplinkDelayMs}
         * @param uplinkDelayMs Delay time for all packets to destination in milliseconds as an integer from 0 to 2000.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder uplinkDelayMs(java.lang.Number uplinkDelayMs) {
            this.uplinkDelayMs = uplinkDelayMs;
            return this;
        }

        /**
         * Sets the value of {@link CfnNetworkProfileProps#getUplinkJitterMs}
         * @param uplinkJitterMs Time variation in the delay of received packets in milliseconds as an integer from 0 to 2000.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder uplinkJitterMs(java.lang.Number uplinkJitterMs) {
            this.uplinkJitterMs = uplinkJitterMs;
            return this;
        }

        /**
         * Sets the value of {@link CfnNetworkProfileProps#getUplinkLossPercent}
         * @param uplinkLossPercent Proportion of transmitted packets that fail to arrive from 0 to 100 percent.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder uplinkLossPercent(java.lang.Number uplinkLossPercent) {
            this.uplinkLossPercent = uplinkLossPercent;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnNetworkProfileProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnNetworkProfileProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnNetworkProfileProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnNetworkProfileProps {
        private final java.lang.String name;
        private final java.lang.String projectArn;
        private final java.lang.String description;
        private final java.lang.Number downlinkBandwidthBits;
        private final java.lang.Number downlinkDelayMs;
        private final java.lang.Number downlinkJitterMs;
        private final java.lang.Number downlinkLossPercent;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;
        private final java.lang.Number uplinkBandwidthBits;
        private final java.lang.Number uplinkDelayMs;
        private final java.lang.Number uplinkJitterMs;
        private final java.lang.Number uplinkLossPercent;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.projectArn = software.amazon.jsii.Kernel.get(this, "projectArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.downlinkBandwidthBits = software.amazon.jsii.Kernel.get(this, "downlinkBandwidthBits", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.downlinkDelayMs = software.amazon.jsii.Kernel.get(this, "downlinkDelayMs", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.downlinkJitterMs = software.amazon.jsii.Kernel.get(this, "downlinkJitterMs", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.downlinkLossPercent = software.amazon.jsii.Kernel.get(this, "downlinkLossPercent", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
            this.uplinkBandwidthBits = software.amazon.jsii.Kernel.get(this, "uplinkBandwidthBits", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.uplinkDelayMs = software.amazon.jsii.Kernel.get(this, "uplinkDelayMs", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.uplinkJitterMs = software.amazon.jsii.Kernel.get(this, "uplinkJitterMs", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.uplinkLossPercent = software.amazon.jsii.Kernel.get(this, "uplinkLossPercent", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
            this.projectArn = java.util.Objects.requireNonNull(builder.projectArn, "projectArn is required");
            this.description = builder.description;
            this.downlinkBandwidthBits = builder.downlinkBandwidthBits;
            this.downlinkDelayMs = builder.downlinkDelayMs;
            this.downlinkJitterMs = builder.downlinkJitterMs;
            this.downlinkLossPercent = builder.downlinkLossPercent;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
            this.uplinkBandwidthBits = builder.uplinkBandwidthBits;
            this.uplinkDelayMs = builder.uplinkDelayMs;
            this.uplinkJitterMs = builder.uplinkJitterMs;
            this.uplinkLossPercent = builder.uplinkLossPercent;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        public final java.lang.String getProjectArn() {
            return this.projectArn;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public final java.lang.Number getDownlinkBandwidthBits() {
            return this.downlinkBandwidthBits;
        }

        @Override
        public final java.lang.Number getDownlinkDelayMs() {
            return this.downlinkDelayMs;
        }

        @Override
        public final java.lang.Number getDownlinkJitterMs() {
            return this.downlinkJitterMs;
        }

        @Override
        public final java.lang.Number getDownlinkLossPercent() {
            return this.downlinkLossPercent;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        public final java.lang.Number getUplinkBandwidthBits() {
            return this.uplinkBandwidthBits;
        }

        @Override
        public final java.lang.Number getUplinkDelayMs() {
            return this.uplinkDelayMs;
        }

        @Override
        public final java.lang.Number getUplinkJitterMs() {
            return this.uplinkJitterMs;
        }

        @Override
        public final java.lang.Number getUplinkLossPercent() {
            return this.uplinkLossPercent;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("name", om.valueToTree(this.getName()));
            data.set("projectArn", om.valueToTree(this.getProjectArn()));
            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getDownlinkBandwidthBits() != null) {
                data.set("downlinkBandwidthBits", om.valueToTree(this.getDownlinkBandwidthBits()));
            }
            if (this.getDownlinkDelayMs() != null) {
                data.set("downlinkDelayMs", om.valueToTree(this.getDownlinkDelayMs()));
            }
            if (this.getDownlinkJitterMs() != null) {
                data.set("downlinkJitterMs", om.valueToTree(this.getDownlinkJitterMs()));
            }
            if (this.getDownlinkLossPercent() != null) {
                data.set("downlinkLossPercent", om.valueToTree(this.getDownlinkLossPercent()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }
            if (this.getUplinkBandwidthBits() != null) {
                data.set("uplinkBandwidthBits", om.valueToTree(this.getUplinkBandwidthBits()));
            }
            if (this.getUplinkDelayMs() != null) {
                data.set("uplinkDelayMs", om.valueToTree(this.getUplinkDelayMs()));
            }
            if (this.getUplinkJitterMs() != null) {
                data.set("uplinkJitterMs", om.valueToTree(this.getUplinkJitterMs()));
            }
            if (this.getUplinkLossPercent() != null) {
                data.set("uplinkLossPercent", om.valueToTree(this.getUplinkLossPercent()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_devicefarm.CfnNetworkProfileProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnNetworkProfileProps.Jsii$Proxy that = (CfnNetworkProfileProps.Jsii$Proxy) o;

            if (!name.equals(that.name)) return false;
            if (!projectArn.equals(that.projectArn)) return false;
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            if (this.downlinkBandwidthBits != null ? !this.downlinkBandwidthBits.equals(that.downlinkBandwidthBits) : that.downlinkBandwidthBits != null) return false;
            if (this.downlinkDelayMs != null ? !this.downlinkDelayMs.equals(that.downlinkDelayMs) : that.downlinkDelayMs != null) return false;
            if (this.downlinkJitterMs != null ? !this.downlinkJitterMs.equals(that.downlinkJitterMs) : that.downlinkJitterMs != null) return false;
            if (this.downlinkLossPercent != null ? !this.downlinkLossPercent.equals(that.downlinkLossPercent) : that.downlinkLossPercent != null) return false;
            if (this.tags != null ? !this.tags.equals(that.tags) : that.tags != null) return false;
            if (this.uplinkBandwidthBits != null ? !this.uplinkBandwidthBits.equals(that.uplinkBandwidthBits) : that.uplinkBandwidthBits != null) return false;
            if (this.uplinkDelayMs != null ? !this.uplinkDelayMs.equals(that.uplinkDelayMs) : that.uplinkDelayMs != null) return false;
            if (this.uplinkJitterMs != null ? !this.uplinkJitterMs.equals(that.uplinkJitterMs) : that.uplinkJitterMs != null) return false;
            return this.uplinkLossPercent != null ? this.uplinkLossPercent.equals(that.uplinkLossPercent) : that.uplinkLossPercent == null;
        }

        @Override
        public final int hashCode() {
            int result = this.name.hashCode();
            result = 31 * result + (this.projectArn.hashCode());
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            result = 31 * result + (this.downlinkBandwidthBits != null ? this.downlinkBandwidthBits.hashCode() : 0);
            result = 31 * result + (this.downlinkDelayMs != null ? this.downlinkDelayMs.hashCode() : 0);
            result = 31 * result + (this.downlinkJitterMs != null ? this.downlinkJitterMs.hashCode() : 0);
            result = 31 * result + (this.downlinkLossPercent != null ? this.downlinkLossPercent.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            result = 31 * result + (this.uplinkBandwidthBits != null ? this.uplinkBandwidthBits.hashCode() : 0);
            result = 31 * result + (this.uplinkDelayMs != null ? this.uplinkDelayMs.hashCode() : 0);
            result = 31 * result + (this.uplinkJitterMs != null ? this.uplinkJitterMs.hashCode() : 0);
            result = 31 * result + (this.uplinkLossPercent != null ? this.uplinkLossPercent.hashCode() : 0);
            return result;
        }
    }
}
