package software.amazon.awscdk.services.dms;

/**
 * Provides information that defines a data provider.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.dms.*;
 * CfnDataProvider cfnDataProvider = CfnDataProvider.Builder.create(this, "MyCfnDataProvider")
 *         .engine("engine")
 *         // the properties below are optional
 *         .dataProviderIdentifier("dataProviderIdentifier")
 *         .dataProviderName("dataProviderName")
 *         .description("description")
 *         .exactSettings(false)
 *         .settings(SettingsProperty.builder()
 *                 .docDbSettings(DocDbSettingsProperty.builder()
 *                         .databaseName("databaseName")
 *                         .port(123)
 *                         .serverName("serverName")
 *                         // the properties below are optional
 *                         .certificateArn("certificateArn")
 *                         .sslMode("sslMode")
 *                         .build())
 *                 .mariaDbSettings(MariaDbSettingsProperty.builder()
 *                         .port(123)
 *                         .serverName("serverName")
 *                         .sslMode("sslMode")
 *                         // the properties below are optional
 *                         .certificateArn("certificateArn")
 *                         .build())
 *                 .microsoftSqlServerSettings(MicrosoftSqlServerSettingsProperty.builder()
 *                         .databaseName("databaseName")
 *                         .port(123)
 *                         .serverName("serverName")
 *                         .sslMode("sslMode")
 *                         // the properties below are optional
 *                         .certificateArn("certificateArn")
 *                         .build())
 *                 .mongoDbSettings(MongoDbSettingsProperty.builder()
 *                         .port(123)
 *                         .serverName("serverName")
 *                         // the properties below are optional
 *                         .authMechanism("authMechanism")
 *                         .authSource("authSource")
 *                         .authType("authType")
 *                         .certificateArn("certificateArn")
 *                         .databaseName("databaseName")
 *                         .sslMode("sslMode")
 *                         .build())
 *                 .mySqlSettings(MySqlSettingsProperty.builder()
 *                         .port(123)
 *                         .serverName("serverName")
 *                         .sslMode("sslMode")
 *                         // the properties below are optional
 *                         .certificateArn("certificateArn")
 *                         .build())
 *                 .oracleSettings(OracleSettingsProperty.builder()
 *                         .databaseName("databaseName")
 *                         .port(123)
 *                         .serverName("serverName")
 *                         .sslMode("sslMode")
 *                         // the properties below are optional
 *                         .asmServer("asmServer")
 *                         .certificateArn("certificateArn")
 *                         .secretsManagerOracleAsmAccessRoleArn("secretsManagerOracleAsmAccessRoleArn")
 *                         .secretsManagerOracleAsmSecretId("secretsManagerOracleAsmSecretId")
 *                         .secretsManagerSecurityDbEncryptionAccessRoleArn("secretsManagerSecurityDbEncryptionAccessRoleArn")
 *                         .secretsManagerSecurityDbEncryptionSecretId("secretsManagerSecurityDbEncryptionSecretId")
 *                         .build())
 *                 .postgreSqlSettings(PostgreSqlSettingsProperty.builder()
 *                         .databaseName("databaseName")
 *                         .port(123)
 *                         .serverName("serverName")
 *                         .sslMode("sslMode")
 *                         // the properties below are optional
 *                         .certificateArn("certificateArn")
 *                         .build())
 *                 .redshiftSettings(RedshiftSettingsProperty.builder()
 *                         .databaseName("databaseName")
 *                         .port(123)
 *                         .serverName("serverName")
 *                         .build())
 *                 .build())
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-dataprovider.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-dataprovider.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-01-25T00:20:53.730Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_dms.CfnDataProvider")
public class CfnDataProvider extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable, software.amazon.awscdk.ITaggableV2 {

    protected CfnDataProvider(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnDataProvider(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.dms.CfnDataProvider.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnDataProvider(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.dms.CfnDataProviderProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The Amazon Resource Name (ARN) string that uniquely identifies the data provider.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrDataProviderArn() {
        return software.amazon.jsii.Kernel.get(this, "attrDataProviderArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The time the data provider was created.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrDataProviderCreationTime() {
        return software.amazon.jsii.Kernel.get(this, "attrDataProviderCreationTime", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Tag Manager which manages the tags for this resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getCdkTagManager() {
        return software.amazon.jsii.Kernel.get(this, "cdkTagManager", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * The type of database engine for the data provider.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getEngine() {
        return software.amazon.jsii.Kernel.get(this, "engine", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The type of database engine for the data provider.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEngine(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "engine", java.util.Objects.requireNonNull(value, "engine is required"));
    }

    /**
     * The identifier of the data provider.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDataProviderIdentifier() {
        return software.amazon.jsii.Kernel.get(this, "dataProviderIdentifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The identifier of the data provider.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDataProviderIdentifier(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "dataProviderIdentifier", value);
    }

    /**
     * The name of the data provider.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDataProviderName() {
        return software.amazon.jsii.Kernel.get(this, "dataProviderName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the data provider.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDataProviderName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "dataProviderName", value);
    }

    /**
     * A description of the data provider.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A description of the data provider.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDescription(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "description", value);
    }

    /**
     * The property describes the exact settings which can be modified.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getExactSettings() {
        return software.amazon.jsii.Kernel.get(this, "exactSettings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The property describes the exact settings which can be modified.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setExactSettings(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "exactSettings", value);
    }

    /**
     * The property describes the exact settings which can be modified.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setExactSettings(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "exactSettings", value);
    }

    /**
     * The settings in JSON format for a data provider.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getSettings() {
        return software.amazon.jsii.Kernel.get(this, "settings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The settings in JSON format for a data provider.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSettings(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "settings", value);
    }

    /**
     * The settings in JSON format for a data provider.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSettings(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.dms.CfnDataProvider.SettingsProperty value) {
        software.amazon.jsii.Kernel.set(this, "settings", value);
    }

    /**
     * An array of key-value pairs to apply to this resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return java.util.Optional.ofNullable((java.util.List<software.amazon.awscdk.CfnTag>)(software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * An array of key-value pairs to apply to this resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTags(final @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> value) {
        software.amazon.jsii.Kernel.set(this, "tags", value);
    }
    /**
     * Provides information that defines a DocumentDB endpoint.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.dms.*;
     * DocDbSettingsProperty docDbSettingsProperty = DocDbSettingsProperty.builder()
     *         .databaseName("databaseName")
     *         .port(123)
     *         .serverName("serverName")
     *         // the properties below are optional
     *         .certificateArn("certificateArn")
     *         .sslMode("sslMode")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-dataprovider-docdbsettings.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-dataprovider-docdbsettings.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_dms.CfnDataProvider.DocDbSettingsProperty")
    @software.amazon.jsii.Jsii.Proxy(DocDbSettingsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DocDbSettingsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The database name on the DocumentDB source endpoint.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-dataprovider-docdbsettings.html#cfn-dms-dataprovider-docdbsettings-databasename">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-dataprovider-docdbsettings.html#cfn-dms-dataprovider-docdbsettings-databasename</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getDatabaseName();

        /**
         * The port value for the DocumentDB source endpoint.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-dataprovider-docdbsettings.html#cfn-dms-dataprovider-docdbsettings-port">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-dataprovider-docdbsettings.html#cfn-dms-dataprovider-docdbsettings-port</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getPort();

        /**
         * The name of the server on the DocumentDB source endpoint.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-dataprovider-docdbsettings.html#cfn-dms-dataprovider-docdbsettings-servername">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-dataprovider-docdbsettings.html#cfn-dms-dataprovider-docdbsettings-servername</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getServerName();

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-dataprovider-docdbsettings.html#cfn-dms-dataprovider-docdbsettings-certificatearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-dataprovider-docdbsettings.html#cfn-dms-dataprovider-docdbsettings-certificatearn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getCertificateArn() {
            return null;
        }

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-dataprovider-docdbsettings.html#cfn-dms-dataprovider-docdbsettings-sslmode">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-dataprovider-docdbsettings.html#cfn-dms-dataprovider-docdbsettings-sslmode</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSslMode() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link DocDbSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DocDbSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DocDbSettingsProperty> {
            java.lang.String databaseName;
            java.lang.Number port;
            java.lang.String serverName;
            java.lang.String certificateArn;
            java.lang.String sslMode;

            /**
             * Sets the value of {@link DocDbSettingsProperty#getDatabaseName}
             * @param databaseName The database name on the DocumentDB source endpoint. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder databaseName(java.lang.String databaseName) {
                this.databaseName = databaseName;
                return this;
            }

            /**
             * Sets the value of {@link DocDbSettingsProperty#getPort}
             * @param port The port value for the DocumentDB source endpoint. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder port(java.lang.Number port) {
                this.port = port;
                return this;
            }

            /**
             * Sets the value of {@link DocDbSettingsProperty#getServerName}
             * @param serverName The name of the server on the DocumentDB source endpoint. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder serverName(java.lang.String serverName) {
                this.serverName = serverName;
                return this;
            }

            /**
             * Sets the value of {@link DocDbSettingsProperty#getCertificateArn}
             * @param certificateArn the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder certificateArn(java.lang.String certificateArn) {
                this.certificateArn = certificateArn;
                return this;
            }

            /**
             * Sets the value of {@link DocDbSettingsProperty#getSslMode}
             * @param sslMode the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sslMode(java.lang.String sslMode) {
                this.sslMode = sslMode;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DocDbSettingsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DocDbSettingsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DocDbSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DocDbSettingsProperty {
            private final java.lang.String databaseName;
            private final java.lang.Number port;
            private final java.lang.String serverName;
            private final java.lang.String certificateArn;
            private final java.lang.String sslMode;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.databaseName = software.amazon.jsii.Kernel.get(this, "databaseName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.port = software.amazon.jsii.Kernel.get(this, "port", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.serverName = software.amazon.jsii.Kernel.get(this, "serverName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.certificateArn = software.amazon.jsii.Kernel.get(this, "certificateArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.sslMode = software.amazon.jsii.Kernel.get(this, "sslMode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.databaseName = java.util.Objects.requireNonNull(builder.databaseName, "databaseName is required");
                this.port = java.util.Objects.requireNonNull(builder.port, "port is required");
                this.serverName = java.util.Objects.requireNonNull(builder.serverName, "serverName is required");
                this.certificateArn = builder.certificateArn;
                this.sslMode = builder.sslMode;
            }

            @Override
            public final java.lang.String getDatabaseName() {
                return this.databaseName;
            }

            @Override
            public final java.lang.Number getPort() {
                return this.port;
            }

            @Override
            public final java.lang.String getServerName() {
                return this.serverName;
            }

            @Override
            public final java.lang.String getCertificateArn() {
                return this.certificateArn;
            }

            @Override
            public final java.lang.String getSslMode() {
                return this.sslMode;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("databaseName", om.valueToTree(this.getDatabaseName()));
                data.set("port", om.valueToTree(this.getPort()));
                data.set("serverName", om.valueToTree(this.getServerName()));
                if (this.getCertificateArn() != null) {
                    data.set("certificateArn", om.valueToTree(this.getCertificateArn()));
                }
                if (this.getSslMode() != null) {
                    data.set("sslMode", om.valueToTree(this.getSslMode()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_dms.CfnDataProvider.DocDbSettingsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DocDbSettingsProperty.Jsii$Proxy that = (DocDbSettingsProperty.Jsii$Proxy) o;

                if (!databaseName.equals(that.databaseName)) return false;
                if (!port.equals(that.port)) return false;
                if (!serverName.equals(that.serverName)) return false;
                if (this.certificateArn != null ? !this.certificateArn.equals(that.certificateArn) : that.certificateArn != null) return false;
                return this.sslMode != null ? this.sslMode.equals(that.sslMode) : that.sslMode == null;
            }

            @Override
            public final int hashCode() {
                int result = this.databaseName.hashCode();
                result = 31 * result + (this.port.hashCode());
                result = 31 * result + (this.serverName.hashCode());
                result = 31 * result + (this.certificateArn != null ? this.certificateArn.hashCode() : 0);
                result = 31 * result + (this.sslMode != null ? this.sslMode.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * MariaDbSettings property identifier.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.dms.*;
     * MariaDbSettingsProperty mariaDbSettingsProperty = MariaDbSettingsProperty.builder()
     *         .port(123)
     *         .serverName("serverName")
     *         .sslMode("sslMode")
     *         // the properties below are optional
     *         .certificateArn("certificateArn")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-dataprovider-mariadbsettings.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-dataprovider-mariadbsettings.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_dms.CfnDataProvider.MariaDbSettingsProperty")
    @software.amazon.jsii.Jsii.Proxy(MariaDbSettingsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface MariaDbSettingsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-dataprovider-mariadbsettings.html#cfn-dms-dataprovider-mariadbsettings-port">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-dataprovider-mariadbsettings.html#cfn-dms-dataprovider-mariadbsettings-port</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getPort();

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-dataprovider-mariadbsettings.html#cfn-dms-dataprovider-mariadbsettings-servername">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-dataprovider-mariadbsettings.html#cfn-dms-dataprovider-mariadbsettings-servername</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getServerName();

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-dataprovider-mariadbsettings.html#cfn-dms-dataprovider-mariadbsettings-sslmode">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-dataprovider-mariadbsettings.html#cfn-dms-dataprovider-mariadbsettings-sslmode</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getSslMode();

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-dataprovider-mariadbsettings.html#cfn-dms-dataprovider-mariadbsettings-certificatearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-dataprovider-mariadbsettings.html#cfn-dms-dataprovider-mariadbsettings-certificatearn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getCertificateArn() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link MariaDbSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link MariaDbSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<MariaDbSettingsProperty> {
            java.lang.Number port;
            java.lang.String serverName;
            java.lang.String sslMode;
            java.lang.String certificateArn;

            /**
             * Sets the value of {@link MariaDbSettingsProperty#getPort}
             * @param port the value to be set. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder port(java.lang.Number port) {
                this.port = port;
                return this;
            }

            /**
             * Sets the value of {@link MariaDbSettingsProperty#getServerName}
             * @param serverName the value to be set. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder serverName(java.lang.String serverName) {
                this.serverName = serverName;
                return this;
            }

            /**
             * Sets the value of {@link MariaDbSettingsProperty#getSslMode}
             * @param sslMode the value to be set. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sslMode(java.lang.String sslMode) {
                this.sslMode = sslMode;
                return this;
            }

            /**
             * Sets the value of {@link MariaDbSettingsProperty#getCertificateArn}
             * @param certificateArn the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder certificateArn(java.lang.String certificateArn) {
                this.certificateArn = certificateArn;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link MariaDbSettingsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public MariaDbSettingsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link MariaDbSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MariaDbSettingsProperty {
            private final java.lang.Number port;
            private final java.lang.String serverName;
            private final java.lang.String sslMode;
            private final java.lang.String certificateArn;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.port = software.amazon.jsii.Kernel.get(this, "port", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.serverName = software.amazon.jsii.Kernel.get(this, "serverName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.sslMode = software.amazon.jsii.Kernel.get(this, "sslMode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.certificateArn = software.amazon.jsii.Kernel.get(this, "certificateArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.port = java.util.Objects.requireNonNull(builder.port, "port is required");
                this.serverName = java.util.Objects.requireNonNull(builder.serverName, "serverName is required");
                this.sslMode = java.util.Objects.requireNonNull(builder.sslMode, "sslMode is required");
                this.certificateArn = builder.certificateArn;
            }

            @Override
            public final java.lang.Number getPort() {
                return this.port;
            }

            @Override
            public final java.lang.String getServerName() {
                return this.serverName;
            }

            @Override
            public final java.lang.String getSslMode() {
                return this.sslMode;
            }

            @Override
            public final java.lang.String getCertificateArn() {
                return this.certificateArn;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("port", om.valueToTree(this.getPort()));
                data.set("serverName", om.valueToTree(this.getServerName()));
                data.set("sslMode", om.valueToTree(this.getSslMode()));
                if (this.getCertificateArn() != null) {
                    data.set("certificateArn", om.valueToTree(this.getCertificateArn()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_dms.CfnDataProvider.MariaDbSettingsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                MariaDbSettingsProperty.Jsii$Proxy that = (MariaDbSettingsProperty.Jsii$Proxy) o;

                if (!port.equals(that.port)) return false;
                if (!serverName.equals(that.serverName)) return false;
                if (!sslMode.equals(that.sslMode)) return false;
                return this.certificateArn != null ? this.certificateArn.equals(that.certificateArn) : that.certificateArn == null;
            }

            @Override
            public final int hashCode() {
                int result = this.port.hashCode();
                result = 31 * result + (this.serverName.hashCode());
                result = 31 * result + (this.sslMode.hashCode());
                result = 31 * result + (this.certificateArn != null ? this.certificateArn.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Provides information that defines a Microsoft SQL Server endpoint.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.dms.*;
     * MicrosoftSqlServerSettingsProperty microsoftSqlServerSettingsProperty = MicrosoftSqlServerSettingsProperty.builder()
     *         .databaseName("databaseName")
     *         .port(123)
     *         .serverName("serverName")
     *         .sslMode("sslMode")
     *         // the properties below are optional
     *         .certificateArn("certificateArn")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-dataprovider-microsoftsqlserversettings.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-dataprovider-microsoftsqlserversettings.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_dms.CfnDataProvider.MicrosoftSqlServerSettingsProperty")
    @software.amazon.jsii.Jsii.Proxy(MicrosoftSqlServerSettingsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface MicrosoftSqlServerSettingsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Database name for the endpoint.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-dataprovider-microsoftsqlserversettings.html#cfn-dms-dataprovider-microsoftsqlserversettings-databasename">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-dataprovider-microsoftsqlserversettings.html#cfn-dms-dataprovider-microsoftsqlserversettings-databasename</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getDatabaseName();

        /**
         * Endpoint TCP port.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-dataprovider-microsoftsqlserversettings.html#cfn-dms-dataprovider-microsoftsqlserversettings-port">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-dataprovider-microsoftsqlserversettings.html#cfn-dms-dataprovider-microsoftsqlserversettings-port</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getPort();

        /**
         * Fully qualified domain name of the endpoint.
         * <p>
         * For an Amazon RDS SQL Server instance, this is the output of <a href="https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_DescribeDBInstances.html">DescribeDBInstances</a> , in the <code>[Endpoint](https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_Endpoint.html) .Address</code> field.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-dataprovider-microsoftsqlserversettings.html#cfn-dms-dataprovider-microsoftsqlserversettings-servername">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-dataprovider-microsoftsqlserversettings.html#cfn-dms-dataprovider-microsoftsqlserversettings-servername</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getServerName();

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-dataprovider-microsoftsqlserversettings.html#cfn-dms-dataprovider-microsoftsqlserversettings-sslmode">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-dataprovider-microsoftsqlserversettings.html#cfn-dms-dataprovider-microsoftsqlserversettings-sslmode</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getSslMode();

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-dataprovider-microsoftsqlserversettings.html#cfn-dms-dataprovider-microsoftsqlserversettings-certificatearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-dataprovider-microsoftsqlserversettings.html#cfn-dms-dataprovider-microsoftsqlserversettings-certificatearn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getCertificateArn() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link MicrosoftSqlServerSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link MicrosoftSqlServerSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<MicrosoftSqlServerSettingsProperty> {
            java.lang.String databaseName;
            java.lang.Number port;
            java.lang.String serverName;
            java.lang.String sslMode;
            java.lang.String certificateArn;

            /**
             * Sets the value of {@link MicrosoftSqlServerSettingsProperty#getDatabaseName}
             * @param databaseName Database name for the endpoint. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder databaseName(java.lang.String databaseName) {
                this.databaseName = databaseName;
                return this;
            }

            /**
             * Sets the value of {@link MicrosoftSqlServerSettingsProperty#getPort}
             * @param port Endpoint TCP port. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder port(java.lang.Number port) {
                this.port = port;
                return this;
            }

            /**
             * Sets the value of {@link MicrosoftSqlServerSettingsProperty#getServerName}
             * @param serverName Fully qualified domain name of the endpoint. This parameter is required.
             *                   For an Amazon RDS SQL Server instance, this is the output of <a href="https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_DescribeDBInstances.html">DescribeDBInstances</a> , in the <code>[Endpoint](https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_Endpoint.html) .Address</code> field.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder serverName(java.lang.String serverName) {
                this.serverName = serverName;
                return this;
            }

            /**
             * Sets the value of {@link MicrosoftSqlServerSettingsProperty#getSslMode}
             * @param sslMode the value to be set. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sslMode(java.lang.String sslMode) {
                this.sslMode = sslMode;
                return this;
            }

            /**
             * Sets the value of {@link MicrosoftSqlServerSettingsProperty#getCertificateArn}
             * @param certificateArn the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder certificateArn(java.lang.String certificateArn) {
                this.certificateArn = certificateArn;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link MicrosoftSqlServerSettingsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public MicrosoftSqlServerSettingsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link MicrosoftSqlServerSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MicrosoftSqlServerSettingsProperty {
            private final java.lang.String databaseName;
            private final java.lang.Number port;
            private final java.lang.String serverName;
            private final java.lang.String sslMode;
            private final java.lang.String certificateArn;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.databaseName = software.amazon.jsii.Kernel.get(this, "databaseName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.port = software.amazon.jsii.Kernel.get(this, "port", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.serverName = software.amazon.jsii.Kernel.get(this, "serverName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.sslMode = software.amazon.jsii.Kernel.get(this, "sslMode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.certificateArn = software.amazon.jsii.Kernel.get(this, "certificateArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.databaseName = java.util.Objects.requireNonNull(builder.databaseName, "databaseName is required");
                this.port = java.util.Objects.requireNonNull(builder.port, "port is required");
                this.serverName = java.util.Objects.requireNonNull(builder.serverName, "serverName is required");
                this.sslMode = java.util.Objects.requireNonNull(builder.sslMode, "sslMode is required");
                this.certificateArn = builder.certificateArn;
            }

            @Override
            public final java.lang.String getDatabaseName() {
                return this.databaseName;
            }

            @Override
            public final java.lang.Number getPort() {
                return this.port;
            }

            @Override
            public final java.lang.String getServerName() {
                return this.serverName;
            }

            @Override
            public final java.lang.String getSslMode() {
                return this.sslMode;
            }

            @Override
            public final java.lang.String getCertificateArn() {
                return this.certificateArn;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("databaseName", om.valueToTree(this.getDatabaseName()));
                data.set("port", om.valueToTree(this.getPort()));
                data.set("serverName", om.valueToTree(this.getServerName()));
                data.set("sslMode", om.valueToTree(this.getSslMode()));
                if (this.getCertificateArn() != null) {
                    data.set("certificateArn", om.valueToTree(this.getCertificateArn()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_dms.CfnDataProvider.MicrosoftSqlServerSettingsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                MicrosoftSqlServerSettingsProperty.Jsii$Proxy that = (MicrosoftSqlServerSettingsProperty.Jsii$Proxy) o;

                if (!databaseName.equals(that.databaseName)) return false;
                if (!port.equals(that.port)) return false;
                if (!serverName.equals(that.serverName)) return false;
                if (!sslMode.equals(that.sslMode)) return false;
                return this.certificateArn != null ? this.certificateArn.equals(that.certificateArn) : that.certificateArn == null;
            }

            @Override
            public final int hashCode() {
                int result = this.databaseName.hashCode();
                result = 31 * result + (this.port.hashCode());
                result = 31 * result + (this.serverName.hashCode());
                result = 31 * result + (this.sslMode.hashCode());
                result = 31 * result + (this.certificateArn != null ? this.certificateArn.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Provides information that defines a MongoDB endpoint.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.dms.*;
     * MongoDbSettingsProperty mongoDbSettingsProperty = MongoDbSettingsProperty.builder()
     *         .port(123)
     *         .serverName("serverName")
     *         // the properties below are optional
     *         .authMechanism("authMechanism")
     *         .authSource("authSource")
     *         .authType("authType")
     *         .certificateArn("certificateArn")
     *         .databaseName("databaseName")
     *         .sslMode("sslMode")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-dataprovider-mongodbsettings.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-dataprovider-mongodbsettings.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_dms.CfnDataProvider.MongoDbSettingsProperty")
    @software.amazon.jsii.Jsii.Proxy(MongoDbSettingsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface MongoDbSettingsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The port value for the MongoDB source endpoint.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-dataprovider-mongodbsettings.html#cfn-dms-dataprovider-mongodbsettings-port">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-dataprovider-mongodbsettings.html#cfn-dms-dataprovider-mongodbsettings-port</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getPort();

        /**
         * The name of the server on the MongoDB source endpoint.
         * <p>
         * For MongoDB Atlas, provide the server name for any of the servers in the replication set.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-dataprovider-mongodbsettings.html#cfn-dms-dataprovider-mongodbsettings-servername">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-dataprovider-mongodbsettings.html#cfn-dms-dataprovider-mongodbsettings-servername</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getServerName();

        /**
         * The authentication mechanism you use to access the MongoDB source endpoint.
         * <p>
         * For the default value, in MongoDB version 2.x, <code>"default"</code> is <code>"mongodb_cr"</code> . For MongoDB version 3.x or later, <code>"default"</code> is <code>"scram_sha_1"</code> . This setting isn't used when <code>AuthType</code> is set to <code>"no"</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-dataprovider-mongodbsettings.html#cfn-dms-dataprovider-mongodbsettings-authmechanism">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-dataprovider-mongodbsettings.html#cfn-dms-dataprovider-mongodbsettings-authmechanism</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAuthMechanism() {
            return null;
        }

        /**
         * The MongoDB database name. This setting isn't used when <code>AuthType</code> is set to <code>"no"</code> .
         * <p>
         * The default is <code>"admin"</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-dataprovider-mongodbsettings.html#cfn-dms-dataprovider-mongodbsettings-authsource">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-dataprovider-mongodbsettings.html#cfn-dms-dataprovider-mongodbsettings-authsource</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAuthSource() {
            return null;
        }

        /**
         * The authentication type you use to access the MongoDB source endpoint.
         * <p>
         * When when set to <code>"no"</code> , user name and password parameters are not used and can be empty.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-dataprovider-mongodbsettings.html#cfn-dms-dataprovider-mongodbsettings-authtype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-dataprovider-mongodbsettings.html#cfn-dms-dataprovider-mongodbsettings-authtype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAuthType() {
            return null;
        }

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-dataprovider-mongodbsettings.html#cfn-dms-dataprovider-mongodbsettings-certificatearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-dataprovider-mongodbsettings.html#cfn-dms-dataprovider-mongodbsettings-certificatearn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getCertificateArn() {
            return null;
        }

        /**
         * The database name on the MongoDB source endpoint.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-dataprovider-mongodbsettings.html#cfn-dms-dataprovider-mongodbsettings-databasename">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-dataprovider-mongodbsettings.html#cfn-dms-dataprovider-mongodbsettings-databasename</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDatabaseName() {
            return null;
        }

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-dataprovider-mongodbsettings.html#cfn-dms-dataprovider-mongodbsettings-sslmode">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-dataprovider-mongodbsettings.html#cfn-dms-dataprovider-mongodbsettings-sslmode</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSslMode() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link MongoDbSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link MongoDbSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<MongoDbSettingsProperty> {
            java.lang.Number port;
            java.lang.String serverName;
            java.lang.String authMechanism;
            java.lang.String authSource;
            java.lang.String authType;
            java.lang.String certificateArn;
            java.lang.String databaseName;
            java.lang.String sslMode;

            /**
             * Sets the value of {@link MongoDbSettingsProperty#getPort}
             * @param port The port value for the MongoDB source endpoint. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder port(java.lang.Number port) {
                this.port = port;
                return this;
            }

            /**
             * Sets the value of {@link MongoDbSettingsProperty#getServerName}
             * @param serverName The name of the server on the MongoDB source endpoint. This parameter is required.
             *                   For MongoDB Atlas, provide the server name for any of the servers in the replication set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder serverName(java.lang.String serverName) {
                this.serverName = serverName;
                return this;
            }

            /**
             * Sets the value of {@link MongoDbSettingsProperty#getAuthMechanism}
             * @param authMechanism The authentication mechanism you use to access the MongoDB source endpoint.
             *                      For the default value, in MongoDB version 2.x, <code>"default"</code> is <code>"mongodb_cr"</code> . For MongoDB version 3.x or later, <code>"default"</code> is <code>"scram_sha_1"</code> . This setting isn't used when <code>AuthType</code> is set to <code>"no"</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder authMechanism(java.lang.String authMechanism) {
                this.authMechanism = authMechanism;
                return this;
            }

            /**
             * Sets the value of {@link MongoDbSettingsProperty#getAuthSource}
             * @param authSource The MongoDB database name. This setting isn't used when <code>AuthType</code> is set to <code>"no"</code> .
             *                   The default is <code>"admin"</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder authSource(java.lang.String authSource) {
                this.authSource = authSource;
                return this;
            }

            /**
             * Sets the value of {@link MongoDbSettingsProperty#getAuthType}
             * @param authType The authentication type you use to access the MongoDB source endpoint.
             *                 When when set to <code>"no"</code> , user name and password parameters are not used and can be empty.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder authType(java.lang.String authType) {
                this.authType = authType;
                return this;
            }

            /**
             * Sets the value of {@link MongoDbSettingsProperty#getCertificateArn}
             * @param certificateArn the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder certificateArn(java.lang.String certificateArn) {
                this.certificateArn = certificateArn;
                return this;
            }

            /**
             * Sets the value of {@link MongoDbSettingsProperty#getDatabaseName}
             * @param databaseName The database name on the MongoDB source endpoint.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder databaseName(java.lang.String databaseName) {
                this.databaseName = databaseName;
                return this;
            }

            /**
             * Sets the value of {@link MongoDbSettingsProperty#getSslMode}
             * @param sslMode the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sslMode(java.lang.String sslMode) {
                this.sslMode = sslMode;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link MongoDbSettingsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public MongoDbSettingsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link MongoDbSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MongoDbSettingsProperty {
            private final java.lang.Number port;
            private final java.lang.String serverName;
            private final java.lang.String authMechanism;
            private final java.lang.String authSource;
            private final java.lang.String authType;
            private final java.lang.String certificateArn;
            private final java.lang.String databaseName;
            private final java.lang.String sslMode;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.port = software.amazon.jsii.Kernel.get(this, "port", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.serverName = software.amazon.jsii.Kernel.get(this, "serverName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.authMechanism = software.amazon.jsii.Kernel.get(this, "authMechanism", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.authSource = software.amazon.jsii.Kernel.get(this, "authSource", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.authType = software.amazon.jsii.Kernel.get(this, "authType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.certificateArn = software.amazon.jsii.Kernel.get(this, "certificateArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.databaseName = software.amazon.jsii.Kernel.get(this, "databaseName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.sslMode = software.amazon.jsii.Kernel.get(this, "sslMode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.port = java.util.Objects.requireNonNull(builder.port, "port is required");
                this.serverName = java.util.Objects.requireNonNull(builder.serverName, "serverName is required");
                this.authMechanism = builder.authMechanism;
                this.authSource = builder.authSource;
                this.authType = builder.authType;
                this.certificateArn = builder.certificateArn;
                this.databaseName = builder.databaseName;
                this.sslMode = builder.sslMode;
            }

            @Override
            public final java.lang.Number getPort() {
                return this.port;
            }

            @Override
            public final java.lang.String getServerName() {
                return this.serverName;
            }

            @Override
            public final java.lang.String getAuthMechanism() {
                return this.authMechanism;
            }

            @Override
            public final java.lang.String getAuthSource() {
                return this.authSource;
            }

            @Override
            public final java.lang.String getAuthType() {
                return this.authType;
            }

            @Override
            public final java.lang.String getCertificateArn() {
                return this.certificateArn;
            }

            @Override
            public final java.lang.String getDatabaseName() {
                return this.databaseName;
            }

            @Override
            public final java.lang.String getSslMode() {
                return this.sslMode;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("port", om.valueToTree(this.getPort()));
                data.set("serverName", om.valueToTree(this.getServerName()));
                if (this.getAuthMechanism() != null) {
                    data.set("authMechanism", om.valueToTree(this.getAuthMechanism()));
                }
                if (this.getAuthSource() != null) {
                    data.set("authSource", om.valueToTree(this.getAuthSource()));
                }
                if (this.getAuthType() != null) {
                    data.set("authType", om.valueToTree(this.getAuthType()));
                }
                if (this.getCertificateArn() != null) {
                    data.set("certificateArn", om.valueToTree(this.getCertificateArn()));
                }
                if (this.getDatabaseName() != null) {
                    data.set("databaseName", om.valueToTree(this.getDatabaseName()));
                }
                if (this.getSslMode() != null) {
                    data.set("sslMode", om.valueToTree(this.getSslMode()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_dms.CfnDataProvider.MongoDbSettingsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                MongoDbSettingsProperty.Jsii$Proxy that = (MongoDbSettingsProperty.Jsii$Proxy) o;

                if (!port.equals(that.port)) return false;
                if (!serverName.equals(that.serverName)) return false;
                if (this.authMechanism != null ? !this.authMechanism.equals(that.authMechanism) : that.authMechanism != null) return false;
                if (this.authSource != null ? !this.authSource.equals(that.authSource) : that.authSource != null) return false;
                if (this.authType != null ? !this.authType.equals(that.authType) : that.authType != null) return false;
                if (this.certificateArn != null ? !this.certificateArn.equals(that.certificateArn) : that.certificateArn != null) return false;
                if (this.databaseName != null ? !this.databaseName.equals(that.databaseName) : that.databaseName != null) return false;
                return this.sslMode != null ? this.sslMode.equals(that.sslMode) : that.sslMode == null;
            }

            @Override
            public final int hashCode() {
                int result = this.port.hashCode();
                result = 31 * result + (this.serverName.hashCode());
                result = 31 * result + (this.authMechanism != null ? this.authMechanism.hashCode() : 0);
                result = 31 * result + (this.authSource != null ? this.authSource.hashCode() : 0);
                result = 31 * result + (this.authType != null ? this.authType.hashCode() : 0);
                result = 31 * result + (this.certificateArn != null ? this.certificateArn.hashCode() : 0);
                result = 31 * result + (this.databaseName != null ? this.databaseName.hashCode() : 0);
                result = 31 * result + (this.sslMode != null ? this.sslMode.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Provides information that defines a MySQL endpoint.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.dms.*;
     * MySqlSettingsProperty mySqlSettingsProperty = MySqlSettingsProperty.builder()
     *         .port(123)
     *         .serverName("serverName")
     *         .sslMode("sslMode")
     *         // the properties below are optional
     *         .certificateArn("certificateArn")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-dataprovider-mysqlsettings.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-dataprovider-mysqlsettings.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_dms.CfnDataProvider.MySqlSettingsProperty")
    @software.amazon.jsii.Jsii.Proxy(MySqlSettingsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface MySqlSettingsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Endpoint TCP port.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-dataprovider-mysqlsettings.html#cfn-dms-dataprovider-mysqlsettings-port">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-dataprovider-mysqlsettings.html#cfn-dms-dataprovider-mysqlsettings-port</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getPort();

        /**
         * The host name of the endpoint database.
         * <p>
         * For an Amazon RDS MySQL instance, this is the output of <a href="https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_DescribeDBInstances.html">DescribeDBInstances</a> , in the <code>[Endpoint](https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_Endpoint.html) .Address</code> field.
         * <p>
         * For an Aurora MySQL instance, this is the output of <a href="https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_DescribeDBClusters.html">DescribeDBClusters</a> , in the <code>Endpoint</code> field.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-dataprovider-mysqlsettings.html#cfn-dms-dataprovider-mysqlsettings-servername">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-dataprovider-mysqlsettings.html#cfn-dms-dataprovider-mysqlsettings-servername</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getServerName();

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-dataprovider-mysqlsettings.html#cfn-dms-dataprovider-mysqlsettings-sslmode">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-dataprovider-mysqlsettings.html#cfn-dms-dataprovider-mysqlsettings-sslmode</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getSslMode();

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-dataprovider-mysqlsettings.html#cfn-dms-dataprovider-mysqlsettings-certificatearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-dataprovider-mysqlsettings.html#cfn-dms-dataprovider-mysqlsettings-certificatearn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getCertificateArn() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link MySqlSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link MySqlSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<MySqlSettingsProperty> {
            java.lang.Number port;
            java.lang.String serverName;
            java.lang.String sslMode;
            java.lang.String certificateArn;

            /**
             * Sets the value of {@link MySqlSettingsProperty#getPort}
             * @param port Endpoint TCP port. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder port(java.lang.Number port) {
                this.port = port;
                return this;
            }

            /**
             * Sets the value of {@link MySqlSettingsProperty#getServerName}
             * @param serverName The host name of the endpoint database. This parameter is required.
             *                   For an Amazon RDS MySQL instance, this is the output of <a href="https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_DescribeDBInstances.html">DescribeDBInstances</a> , in the <code>[Endpoint](https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_Endpoint.html) .Address</code> field.
             *                   <p>
             *                   For an Aurora MySQL instance, this is the output of <a href="https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_DescribeDBClusters.html">DescribeDBClusters</a> , in the <code>Endpoint</code> field.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder serverName(java.lang.String serverName) {
                this.serverName = serverName;
                return this;
            }

            /**
             * Sets the value of {@link MySqlSettingsProperty#getSslMode}
             * @param sslMode the value to be set. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sslMode(java.lang.String sslMode) {
                this.sslMode = sslMode;
                return this;
            }

            /**
             * Sets the value of {@link MySqlSettingsProperty#getCertificateArn}
             * @param certificateArn the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder certificateArn(java.lang.String certificateArn) {
                this.certificateArn = certificateArn;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link MySqlSettingsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public MySqlSettingsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link MySqlSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MySqlSettingsProperty {
            private final java.lang.Number port;
            private final java.lang.String serverName;
            private final java.lang.String sslMode;
            private final java.lang.String certificateArn;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.port = software.amazon.jsii.Kernel.get(this, "port", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.serverName = software.amazon.jsii.Kernel.get(this, "serverName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.sslMode = software.amazon.jsii.Kernel.get(this, "sslMode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.certificateArn = software.amazon.jsii.Kernel.get(this, "certificateArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.port = java.util.Objects.requireNonNull(builder.port, "port is required");
                this.serverName = java.util.Objects.requireNonNull(builder.serverName, "serverName is required");
                this.sslMode = java.util.Objects.requireNonNull(builder.sslMode, "sslMode is required");
                this.certificateArn = builder.certificateArn;
            }

            @Override
            public final java.lang.Number getPort() {
                return this.port;
            }

            @Override
            public final java.lang.String getServerName() {
                return this.serverName;
            }

            @Override
            public final java.lang.String getSslMode() {
                return this.sslMode;
            }

            @Override
            public final java.lang.String getCertificateArn() {
                return this.certificateArn;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("port", om.valueToTree(this.getPort()));
                data.set("serverName", om.valueToTree(this.getServerName()));
                data.set("sslMode", om.valueToTree(this.getSslMode()));
                if (this.getCertificateArn() != null) {
                    data.set("certificateArn", om.valueToTree(this.getCertificateArn()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_dms.CfnDataProvider.MySqlSettingsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                MySqlSettingsProperty.Jsii$Proxy that = (MySqlSettingsProperty.Jsii$Proxy) o;

                if (!port.equals(that.port)) return false;
                if (!serverName.equals(that.serverName)) return false;
                if (!sslMode.equals(that.sslMode)) return false;
                return this.certificateArn != null ? this.certificateArn.equals(that.certificateArn) : that.certificateArn == null;
            }

            @Override
            public final int hashCode() {
                int result = this.port.hashCode();
                result = 31 * result + (this.serverName.hashCode());
                result = 31 * result + (this.sslMode.hashCode());
                result = 31 * result + (this.certificateArn != null ? this.certificateArn.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Provides information that defines an Oracle endpoint.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.dms.*;
     * OracleSettingsProperty oracleSettingsProperty = OracleSettingsProperty.builder()
     *         .databaseName("databaseName")
     *         .port(123)
     *         .serverName("serverName")
     *         .sslMode("sslMode")
     *         // the properties below are optional
     *         .asmServer("asmServer")
     *         .certificateArn("certificateArn")
     *         .secretsManagerOracleAsmAccessRoleArn("secretsManagerOracleAsmAccessRoleArn")
     *         .secretsManagerOracleAsmSecretId("secretsManagerOracleAsmSecretId")
     *         .secretsManagerSecurityDbEncryptionAccessRoleArn("secretsManagerSecurityDbEncryptionAccessRoleArn")
     *         .secretsManagerSecurityDbEncryptionSecretId("secretsManagerSecurityDbEncryptionSecretId")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-dataprovider-oraclesettings.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-dataprovider-oraclesettings.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_dms.CfnDataProvider.OracleSettingsProperty")
    @software.amazon.jsii.Jsii.Proxy(OracleSettingsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface OracleSettingsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Database name for the endpoint.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-dataprovider-oraclesettings.html#cfn-dms-dataprovider-oraclesettings-databasename">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-dataprovider-oraclesettings.html#cfn-dms-dataprovider-oraclesettings-databasename</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getDatabaseName();

        /**
         * Endpoint TCP port.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-dataprovider-oraclesettings.html#cfn-dms-dataprovider-oraclesettings-port">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-dataprovider-oraclesettings.html#cfn-dms-dataprovider-oraclesettings-port</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getPort();

        /**
         * Fully qualified domain name of the endpoint.
         * <p>
         * For an Amazon RDS Oracle instance, this is the output of <a href="https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_DescribeDBInstances.html">DescribeDBInstances</a> , in the <code>[Endpoint](https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_Endpoint.html) .Address</code> field.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-dataprovider-oraclesettings.html#cfn-dms-dataprovider-oraclesettings-servername">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-dataprovider-oraclesettings.html#cfn-dms-dataprovider-oraclesettings-servername</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getServerName();

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-dataprovider-oraclesettings.html#cfn-dms-dataprovider-oraclesettings-sslmode">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-dataprovider-oraclesettings.html#cfn-dms-dataprovider-oraclesettings-sslmode</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getSslMode();

        /**
         * For an Oracle source endpoint, your ASM server address.
         * <p>
         * You can set this value from the <code>asm_server</code> value. You set <code>asm_server</code> as part of the extra connection attribute string to access an Oracle server with Binary Reader that uses ASM. For more information, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.Oracle.html#dms/latest/userguide/CHAP_Source.Oracle.html#CHAP_Source.Oracle.CDC.Configuration">Configuration for change data capture (CDC) on an Oracle source database</a> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-dataprovider-oraclesettings.html#cfn-dms-dataprovider-oraclesettings-asmserver">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-dataprovider-oraclesettings.html#cfn-dms-dataprovider-oraclesettings-asmserver</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAsmServer() {
            return null;
        }

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-dataprovider-oraclesettings.html#cfn-dms-dataprovider-oraclesettings-certificatearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-dataprovider-oraclesettings.html#cfn-dms-dataprovider-oraclesettings-certificatearn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getCertificateArn() {
            return null;
        }

        /**
         * Required only if your Oracle endpoint uses Automatic Storage Management (ASM).
         * <p>
         * The full ARN of the IAM role that specifies AWS DMS as the trusted entity and grants the required permissions to access the <code>SecretsManagerOracleAsmSecret</code> . This <code>SecretsManagerOracleAsmSecret</code> has the secret value that allows access to the Oracle ASM of the endpoint.
         * <p>
         * <blockquote>
         * <p>
         * You can specify one of two sets of values for these permissions. You can specify the values for this setting and <code>SecretsManagerOracleAsmSecretId</code> . Or you can specify clear-text values for <code>AsmUser</code> , <code>AsmPassword</code> , and <code>AsmServerName</code> . You can't specify both. For more information on creating this <code>SecretsManagerOracleAsmSecret</code> and the <code>SecretsManagerOracleAsmAccessRoleArn</code> and <code>SecretsManagerOracleAsmSecretId</code> required to access it, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Security.html#security-iam-secretsmanager">Using secrets to access AWS Database Migration Service resources</a> in the <em>AWS Database Migration Service User Guide</em> .
         * <p>
         * </blockquote>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-dataprovider-oraclesettings.html#cfn-dms-dataprovider-oraclesettings-secretsmanageroracleasmaccessrolearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-dataprovider-oraclesettings.html#cfn-dms-dataprovider-oraclesettings-secretsmanageroracleasmaccessrolearn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSecretsManagerOracleAsmAccessRoleArn() {
            return null;
        }

        /**
         * Required only if your Oracle endpoint uses Automatic Storage Management (ASM).
         * <p>
         * The full ARN, partial ARN, or friendly name of the <code>SecretsManagerOracleAsmSecret</code> that contains the Oracle ASM connection details for the Oracle endpoint.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-dataprovider-oraclesettings.html#cfn-dms-dataprovider-oraclesettings-secretsmanageroracleasmsecretid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-dataprovider-oraclesettings.html#cfn-dms-dataprovider-oraclesettings-secretsmanageroracleasmsecretid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSecretsManagerOracleAsmSecretId() {
            return null;
        }

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-dataprovider-oraclesettings.html#cfn-dms-dataprovider-oraclesettings-secretsmanagersecuritydbencryptionaccessrolearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-dataprovider-oraclesettings.html#cfn-dms-dataprovider-oraclesettings-secretsmanagersecuritydbencryptionaccessrolearn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSecretsManagerSecurityDbEncryptionAccessRoleArn() {
            return null;
        }

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-dataprovider-oraclesettings.html#cfn-dms-dataprovider-oraclesettings-secretsmanagersecuritydbencryptionsecretid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-dataprovider-oraclesettings.html#cfn-dms-dataprovider-oraclesettings-secretsmanagersecuritydbencryptionsecretid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSecretsManagerSecurityDbEncryptionSecretId() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link OracleSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link OracleSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<OracleSettingsProperty> {
            java.lang.String databaseName;
            java.lang.Number port;
            java.lang.String serverName;
            java.lang.String sslMode;
            java.lang.String asmServer;
            java.lang.String certificateArn;
            java.lang.String secretsManagerOracleAsmAccessRoleArn;
            java.lang.String secretsManagerOracleAsmSecretId;
            java.lang.String secretsManagerSecurityDbEncryptionAccessRoleArn;
            java.lang.String secretsManagerSecurityDbEncryptionSecretId;

            /**
             * Sets the value of {@link OracleSettingsProperty#getDatabaseName}
             * @param databaseName Database name for the endpoint. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder databaseName(java.lang.String databaseName) {
                this.databaseName = databaseName;
                return this;
            }

            /**
             * Sets the value of {@link OracleSettingsProperty#getPort}
             * @param port Endpoint TCP port. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder port(java.lang.Number port) {
                this.port = port;
                return this;
            }

            /**
             * Sets the value of {@link OracleSettingsProperty#getServerName}
             * @param serverName Fully qualified domain name of the endpoint. This parameter is required.
             *                   For an Amazon RDS Oracle instance, this is the output of <a href="https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_DescribeDBInstances.html">DescribeDBInstances</a> , in the <code>[Endpoint](https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_Endpoint.html) .Address</code> field.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder serverName(java.lang.String serverName) {
                this.serverName = serverName;
                return this;
            }

            /**
             * Sets the value of {@link OracleSettingsProperty#getSslMode}
             * @param sslMode the value to be set. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sslMode(java.lang.String sslMode) {
                this.sslMode = sslMode;
                return this;
            }

            /**
             * Sets the value of {@link OracleSettingsProperty#getAsmServer}
             * @param asmServer For an Oracle source endpoint, your ASM server address.
             *                  You can set this value from the <code>asm_server</code> value. You set <code>asm_server</code> as part of the extra connection attribute string to access an Oracle server with Binary Reader that uses ASM. For more information, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.Oracle.html#dms/latest/userguide/CHAP_Source.Oracle.html#CHAP_Source.Oracle.CDC.Configuration">Configuration for change data capture (CDC) on an Oracle source database</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder asmServer(java.lang.String asmServer) {
                this.asmServer = asmServer;
                return this;
            }

            /**
             * Sets the value of {@link OracleSettingsProperty#getCertificateArn}
             * @param certificateArn the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder certificateArn(java.lang.String certificateArn) {
                this.certificateArn = certificateArn;
                return this;
            }

            /**
             * Sets the value of {@link OracleSettingsProperty#getSecretsManagerOracleAsmAccessRoleArn}
             * @param secretsManagerOracleAsmAccessRoleArn Required only if your Oracle endpoint uses Automatic Storage Management (ASM).
             *                                             The full ARN of the IAM role that specifies AWS DMS as the trusted entity and grants the required permissions to access the <code>SecretsManagerOracleAsmSecret</code> . This <code>SecretsManagerOracleAsmSecret</code> has the secret value that allows access to the Oracle ASM of the endpoint.
             *                                             <p>
             *                                             <blockquote>
             *                                             <p>
             *                                             You can specify one of two sets of values for these permissions. You can specify the values for this setting and <code>SecretsManagerOracleAsmSecretId</code> . Or you can specify clear-text values for <code>AsmUser</code> , <code>AsmPassword</code> , and <code>AsmServerName</code> . You can't specify both. For more information on creating this <code>SecretsManagerOracleAsmSecret</code> and the <code>SecretsManagerOracleAsmAccessRoleArn</code> and <code>SecretsManagerOracleAsmSecretId</code> required to access it, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Security.html#security-iam-secretsmanager">Using secrets to access AWS Database Migration Service resources</a> in the <em>AWS Database Migration Service User Guide</em> .
             *                                             <p>
             *                                             </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder secretsManagerOracleAsmAccessRoleArn(java.lang.String secretsManagerOracleAsmAccessRoleArn) {
                this.secretsManagerOracleAsmAccessRoleArn = secretsManagerOracleAsmAccessRoleArn;
                return this;
            }

            /**
             * Sets the value of {@link OracleSettingsProperty#getSecretsManagerOracleAsmSecretId}
             * @param secretsManagerOracleAsmSecretId Required only if your Oracle endpoint uses Automatic Storage Management (ASM).
             *                                        The full ARN, partial ARN, or friendly name of the <code>SecretsManagerOracleAsmSecret</code> that contains the Oracle ASM connection details for the Oracle endpoint.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder secretsManagerOracleAsmSecretId(java.lang.String secretsManagerOracleAsmSecretId) {
                this.secretsManagerOracleAsmSecretId = secretsManagerOracleAsmSecretId;
                return this;
            }

            /**
             * Sets the value of {@link OracleSettingsProperty#getSecretsManagerSecurityDbEncryptionAccessRoleArn}
             * @param secretsManagerSecurityDbEncryptionAccessRoleArn the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder secretsManagerSecurityDbEncryptionAccessRoleArn(java.lang.String secretsManagerSecurityDbEncryptionAccessRoleArn) {
                this.secretsManagerSecurityDbEncryptionAccessRoleArn = secretsManagerSecurityDbEncryptionAccessRoleArn;
                return this;
            }

            /**
             * Sets the value of {@link OracleSettingsProperty#getSecretsManagerSecurityDbEncryptionSecretId}
             * @param secretsManagerSecurityDbEncryptionSecretId the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder secretsManagerSecurityDbEncryptionSecretId(java.lang.String secretsManagerSecurityDbEncryptionSecretId) {
                this.secretsManagerSecurityDbEncryptionSecretId = secretsManagerSecurityDbEncryptionSecretId;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link OracleSettingsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public OracleSettingsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link OracleSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements OracleSettingsProperty {
            private final java.lang.String databaseName;
            private final java.lang.Number port;
            private final java.lang.String serverName;
            private final java.lang.String sslMode;
            private final java.lang.String asmServer;
            private final java.lang.String certificateArn;
            private final java.lang.String secretsManagerOracleAsmAccessRoleArn;
            private final java.lang.String secretsManagerOracleAsmSecretId;
            private final java.lang.String secretsManagerSecurityDbEncryptionAccessRoleArn;
            private final java.lang.String secretsManagerSecurityDbEncryptionSecretId;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.databaseName = software.amazon.jsii.Kernel.get(this, "databaseName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.port = software.amazon.jsii.Kernel.get(this, "port", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.serverName = software.amazon.jsii.Kernel.get(this, "serverName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.sslMode = software.amazon.jsii.Kernel.get(this, "sslMode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.asmServer = software.amazon.jsii.Kernel.get(this, "asmServer", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.certificateArn = software.amazon.jsii.Kernel.get(this, "certificateArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.secretsManagerOracleAsmAccessRoleArn = software.amazon.jsii.Kernel.get(this, "secretsManagerOracleAsmAccessRoleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.secretsManagerOracleAsmSecretId = software.amazon.jsii.Kernel.get(this, "secretsManagerOracleAsmSecretId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.secretsManagerSecurityDbEncryptionAccessRoleArn = software.amazon.jsii.Kernel.get(this, "secretsManagerSecurityDbEncryptionAccessRoleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.secretsManagerSecurityDbEncryptionSecretId = software.amazon.jsii.Kernel.get(this, "secretsManagerSecurityDbEncryptionSecretId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.databaseName = java.util.Objects.requireNonNull(builder.databaseName, "databaseName is required");
                this.port = java.util.Objects.requireNonNull(builder.port, "port is required");
                this.serverName = java.util.Objects.requireNonNull(builder.serverName, "serverName is required");
                this.sslMode = java.util.Objects.requireNonNull(builder.sslMode, "sslMode is required");
                this.asmServer = builder.asmServer;
                this.certificateArn = builder.certificateArn;
                this.secretsManagerOracleAsmAccessRoleArn = builder.secretsManagerOracleAsmAccessRoleArn;
                this.secretsManagerOracleAsmSecretId = builder.secretsManagerOracleAsmSecretId;
                this.secretsManagerSecurityDbEncryptionAccessRoleArn = builder.secretsManagerSecurityDbEncryptionAccessRoleArn;
                this.secretsManagerSecurityDbEncryptionSecretId = builder.secretsManagerSecurityDbEncryptionSecretId;
            }

            @Override
            public final java.lang.String getDatabaseName() {
                return this.databaseName;
            }

            @Override
            public final java.lang.Number getPort() {
                return this.port;
            }

            @Override
            public final java.lang.String getServerName() {
                return this.serverName;
            }

            @Override
            public final java.lang.String getSslMode() {
                return this.sslMode;
            }

            @Override
            public final java.lang.String getAsmServer() {
                return this.asmServer;
            }

            @Override
            public final java.lang.String getCertificateArn() {
                return this.certificateArn;
            }

            @Override
            public final java.lang.String getSecretsManagerOracleAsmAccessRoleArn() {
                return this.secretsManagerOracleAsmAccessRoleArn;
            }

            @Override
            public final java.lang.String getSecretsManagerOracleAsmSecretId() {
                return this.secretsManagerOracleAsmSecretId;
            }

            @Override
            public final java.lang.String getSecretsManagerSecurityDbEncryptionAccessRoleArn() {
                return this.secretsManagerSecurityDbEncryptionAccessRoleArn;
            }

            @Override
            public final java.lang.String getSecretsManagerSecurityDbEncryptionSecretId() {
                return this.secretsManagerSecurityDbEncryptionSecretId;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("databaseName", om.valueToTree(this.getDatabaseName()));
                data.set("port", om.valueToTree(this.getPort()));
                data.set("serverName", om.valueToTree(this.getServerName()));
                data.set("sslMode", om.valueToTree(this.getSslMode()));
                if (this.getAsmServer() != null) {
                    data.set("asmServer", om.valueToTree(this.getAsmServer()));
                }
                if (this.getCertificateArn() != null) {
                    data.set("certificateArn", om.valueToTree(this.getCertificateArn()));
                }
                if (this.getSecretsManagerOracleAsmAccessRoleArn() != null) {
                    data.set("secretsManagerOracleAsmAccessRoleArn", om.valueToTree(this.getSecretsManagerOracleAsmAccessRoleArn()));
                }
                if (this.getSecretsManagerOracleAsmSecretId() != null) {
                    data.set("secretsManagerOracleAsmSecretId", om.valueToTree(this.getSecretsManagerOracleAsmSecretId()));
                }
                if (this.getSecretsManagerSecurityDbEncryptionAccessRoleArn() != null) {
                    data.set("secretsManagerSecurityDbEncryptionAccessRoleArn", om.valueToTree(this.getSecretsManagerSecurityDbEncryptionAccessRoleArn()));
                }
                if (this.getSecretsManagerSecurityDbEncryptionSecretId() != null) {
                    data.set("secretsManagerSecurityDbEncryptionSecretId", om.valueToTree(this.getSecretsManagerSecurityDbEncryptionSecretId()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_dms.CfnDataProvider.OracleSettingsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                OracleSettingsProperty.Jsii$Proxy that = (OracleSettingsProperty.Jsii$Proxy) o;

                if (!databaseName.equals(that.databaseName)) return false;
                if (!port.equals(that.port)) return false;
                if (!serverName.equals(that.serverName)) return false;
                if (!sslMode.equals(that.sslMode)) return false;
                if (this.asmServer != null ? !this.asmServer.equals(that.asmServer) : that.asmServer != null) return false;
                if (this.certificateArn != null ? !this.certificateArn.equals(that.certificateArn) : that.certificateArn != null) return false;
                if (this.secretsManagerOracleAsmAccessRoleArn != null ? !this.secretsManagerOracleAsmAccessRoleArn.equals(that.secretsManagerOracleAsmAccessRoleArn) : that.secretsManagerOracleAsmAccessRoleArn != null) return false;
                if (this.secretsManagerOracleAsmSecretId != null ? !this.secretsManagerOracleAsmSecretId.equals(that.secretsManagerOracleAsmSecretId) : that.secretsManagerOracleAsmSecretId != null) return false;
                if (this.secretsManagerSecurityDbEncryptionAccessRoleArn != null ? !this.secretsManagerSecurityDbEncryptionAccessRoleArn.equals(that.secretsManagerSecurityDbEncryptionAccessRoleArn) : that.secretsManagerSecurityDbEncryptionAccessRoleArn != null) return false;
                return this.secretsManagerSecurityDbEncryptionSecretId != null ? this.secretsManagerSecurityDbEncryptionSecretId.equals(that.secretsManagerSecurityDbEncryptionSecretId) : that.secretsManagerSecurityDbEncryptionSecretId == null;
            }

            @Override
            public final int hashCode() {
                int result = this.databaseName.hashCode();
                result = 31 * result + (this.port.hashCode());
                result = 31 * result + (this.serverName.hashCode());
                result = 31 * result + (this.sslMode.hashCode());
                result = 31 * result + (this.asmServer != null ? this.asmServer.hashCode() : 0);
                result = 31 * result + (this.certificateArn != null ? this.certificateArn.hashCode() : 0);
                result = 31 * result + (this.secretsManagerOracleAsmAccessRoleArn != null ? this.secretsManagerOracleAsmAccessRoleArn.hashCode() : 0);
                result = 31 * result + (this.secretsManagerOracleAsmSecretId != null ? this.secretsManagerOracleAsmSecretId.hashCode() : 0);
                result = 31 * result + (this.secretsManagerSecurityDbEncryptionAccessRoleArn != null ? this.secretsManagerSecurityDbEncryptionAccessRoleArn.hashCode() : 0);
                result = 31 * result + (this.secretsManagerSecurityDbEncryptionSecretId != null ? this.secretsManagerSecurityDbEncryptionSecretId.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Provides information that defines a PostgreSQL endpoint.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.dms.*;
     * PostgreSqlSettingsProperty postgreSqlSettingsProperty = PostgreSqlSettingsProperty.builder()
     *         .databaseName("databaseName")
     *         .port(123)
     *         .serverName("serverName")
     *         .sslMode("sslMode")
     *         // the properties below are optional
     *         .certificateArn("certificateArn")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-dataprovider-postgresqlsettings.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-dataprovider-postgresqlsettings.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_dms.CfnDataProvider.PostgreSqlSettingsProperty")
    @software.amazon.jsii.Jsii.Proxy(PostgreSqlSettingsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface PostgreSqlSettingsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Database name for the endpoint.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-dataprovider-postgresqlsettings.html#cfn-dms-dataprovider-postgresqlsettings-databasename">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-dataprovider-postgresqlsettings.html#cfn-dms-dataprovider-postgresqlsettings-databasename</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getDatabaseName();

        /**
         * Endpoint TCP port.
         * <p>
         * The default is 5432.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-dataprovider-postgresqlsettings.html#cfn-dms-dataprovider-postgresqlsettings-port">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-dataprovider-postgresqlsettings.html#cfn-dms-dataprovider-postgresqlsettings-port</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getPort();

        /**
         * The host name of the endpoint database.
         * <p>
         * For an Amazon RDS PostgreSQL instance, this is the output of <a href="https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_DescribeDBInstances.html">DescribeDBInstances</a> , in the <code>[Endpoint](https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_Endpoint.html) .Address</code> field.
         * <p>
         * For an Aurora PostgreSQL instance, this is the output of <a href="https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_DescribeDBClusters.html">DescribeDBClusters</a> , in the <code>Endpoint</code> field.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-dataprovider-postgresqlsettings.html#cfn-dms-dataprovider-postgresqlsettings-servername">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-dataprovider-postgresqlsettings.html#cfn-dms-dataprovider-postgresqlsettings-servername</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getServerName();

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-dataprovider-postgresqlsettings.html#cfn-dms-dataprovider-postgresqlsettings-sslmode">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-dataprovider-postgresqlsettings.html#cfn-dms-dataprovider-postgresqlsettings-sslmode</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getSslMode();

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-dataprovider-postgresqlsettings.html#cfn-dms-dataprovider-postgresqlsettings-certificatearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-dataprovider-postgresqlsettings.html#cfn-dms-dataprovider-postgresqlsettings-certificatearn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getCertificateArn() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link PostgreSqlSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link PostgreSqlSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<PostgreSqlSettingsProperty> {
            java.lang.String databaseName;
            java.lang.Number port;
            java.lang.String serverName;
            java.lang.String sslMode;
            java.lang.String certificateArn;

            /**
             * Sets the value of {@link PostgreSqlSettingsProperty#getDatabaseName}
             * @param databaseName Database name for the endpoint. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder databaseName(java.lang.String databaseName) {
                this.databaseName = databaseName;
                return this;
            }

            /**
             * Sets the value of {@link PostgreSqlSettingsProperty#getPort}
             * @param port Endpoint TCP port. This parameter is required.
             *             The default is 5432.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder port(java.lang.Number port) {
                this.port = port;
                return this;
            }

            /**
             * Sets the value of {@link PostgreSqlSettingsProperty#getServerName}
             * @param serverName The host name of the endpoint database. This parameter is required.
             *                   For an Amazon RDS PostgreSQL instance, this is the output of <a href="https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_DescribeDBInstances.html">DescribeDBInstances</a> , in the <code>[Endpoint](https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_Endpoint.html) .Address</code> field.
             *                   <p>
             *                   For an Aurora PostgreSQL instance, this is the output of <a href="https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_DescribeDBClusters.html">DescribeDBClusters</a> , in the <code>Endpoint</code> field.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder serverName(java.lang.String serverName) {
                this.serverName = serverName;
                return this;
            }

            /**
             * Sets the value of {@link PostgreSqlSettingsProperty#getSslMode}
             * @param sslMode the value to be set. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sslMode(java.lang.String sslMode) {
                this.sslMode = sslMode;
                return this;
            }

            /**
             * Sets the value of {@link PostgreSqlSettingsProperty#getCertificateArn}
             * @param certificateArn the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder certificateArn(java.lang.String certificateArn) {
                this.certificateArn = certificateArn;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link PostgreSqlSettingsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public PostgreSqlSettingsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link PostgreSqlSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PostgreSqlSettingsProperty {
            private final java.lang.String databaseName;
            private final java.lang.Number port;
            private final java.lang.String serverName;
            private final java.lang.String sslMode;
            private final java.lang.String certificateArn;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.databaseName = software.amazon.jsii.Kernel.get(this, "databaseName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.port = software.amazon.jsii.Kernel.get(this, "port", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.serverName = software.amazon.jsii.Kernel.get(this, "serverName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.sslMode = software.amazon.jsii.Kernel.get(this, "sslMode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.certificateArn = software.amazon.jsii.Kernel.get(this, "certificateArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.databaseName = java.util.Objects.requireNonNull(builder.databaseName, "databaseName is required");
                this.port = java.util.Objects.requireNonNull(builder.port, "port is required");
                this.serverName = java.util.Objects.requireNonNull(builder.serverName, "serverName is required");
                this.sslMode = java.util.Objects.requireNonNull(builder.sslMode, "sslMode is required");
                this.certificateArn = builder.certificateArn;
            }

            @Override
            public final java.lang.String getDatabaseName() {
                return this.databaseName;
            }

            @Override
            public final java.lang.Number getPort() {
                return this.port;
            }

            @Override
            public final java.lang.String getServerName() {
                return this.serverName;
            }

            @Override
            public final java.lang.String getSslMode() {
                return this.sslMode;
            }

            @Override
            public final java.lang.String getCertificateArn() {
                return this.certificateArn;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("databaseName", om.valueToTree(this.getDatabaseName()));
                data.set("port", om.valueToTree(this.getPort()));
                data.set("serverName", om.valueToTree(this.getServerName()));
                data.set("sslMode", om.valueToTree(this.getSslMode()));
                if (this.getCertificateArn() != null) {
                    data.set("certificateArn", om.valueToTree(this.getCertificateArn()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_dms.CfnDataProvider.PostgreSqlSettingsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                PostgreSqlSettingsProperty.Jsii$Proxy that = (PostgreSqlSettingsProperty.Jsii$Proxy) o;

                if (!databaseName.equals(that.databaseName)) return false;
                if (!port.equals(that.port)) return false;
                if (!serverName.equals(that.serverName)) return false;
                if (!sslMode.equals(that.sslMode)) return false;
                return this.certificateArn != null ? this.certificateArn.equals(that.certificateArn) : that.certificateArn == null;
            }

            @Override
            public final int hashCode() {
                int result = this.databaseName.hashCode();
                result = 31 * result + (this.port.hashCode());
                result = 31 * result + (this.serverName.hashCode());
                result = 31 * result + (this.sslMode.hashCode());
                result = 31 * result + (this.certificateArn != null ? this.certificateArn.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Provides information that defines an Amazon Redshift endpoint.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.dms.*;
     * RedshiftSettingsProperty redshiftSettingsProperty = RedshiftSettingsProperty.builder()
     *         .databaseName("databaseName")
     *         .port(123)
     *         .serverName("serverName")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-dataprovider-redshiftsettings.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-dataprovider-redshiftsettings.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_dms.CfnDataProvider.RedshiftSettingsProperty")
    @software.amazon.jsii.Jsii.Proxy(RedshiftSettingsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface RedshiftSettingsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the Amazon Redshift data warehouse (service) that you are working with.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-dataprovider-redshiftsettings.html#cfn-dms-dataprovider-redshiftsettings-databasename">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-dataprovider-redshiftsettings.html#cfn-dms-dataprovider-redshiftsettings-databasename</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getDatabaseName();

        /**
         * The port number for Amazon Redshift.
         * <p>
         * The default value is 5439.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-dataprovider-redshiftsettings.html#cfn-dms-dataprovider-redshiftsettings-port">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-dataprovider-redshiftsettings.html#cfn-dms-dataprovider-redshiftsettings-port</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getPort();

        /**
         * The name of the Amazon Redshift cluster you are using.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-dataprovider-redshiftsettings.html#cfn-dms-dataprovider-redshiftsettings-servername">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-dataprovider-redshiftsettings.html#cfn-dms-dataprovider-redshiftsettings-servername</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getServerName();

        /**
         * @return a {@link Builder} of {@link RedshiftSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link RedshiftSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<RedshiftSettingsProperty> {
            java.lang.String databaseName;
            java.lang.Number port;
            java.lang.String serverName;

            /**
             * Sets the value of {@link RedshiftSettingsProperty#getDatabaseName}
             * @param databaseName The name of the Amazon Redshift data warehouse (service) that you are working with. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder databaseName(java.lang.String databaseName) {
                this.databaseName = databaseName;
                return this;
            }

            /**
             * Sets the value of {@link RedshiftSettingsProperty#getPort}
             * @param port The port number for Amazon Redshift. This parameter is required.
             *             The default value is 5439.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder port(java.lang.Number port) {
                this.port = port;
                return this;
            }

            /**
             * Sets the value of {@link RedshiftSettingsProperty#getServerName}
             * @param serverName The name of the Amazon Redshift cluster you are using. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder serverName(java.lang.String serverName) {
                this.serverName = serverName;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RedshiftSettingsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public RedshiftSettingsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link RedshiftSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RedshiftSettingsProperty {
            private final java.lang.String databaseName;
            private final java.lang.Number port;
            private final java.lang.String serverName;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.databaseName = software.amazon.jsii.Kernel.get(this, "databaseName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.port = software.amazon.jsii.Kernel.get(this, "port", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.serverName = software.amazon.jsii.Kernel.get(this, "serverName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.databaseName = java.util.Objects.requireNonNull(builder.databaseName, "databaseName is required");
                this.port = java.util.Objects.requireNonNull(builder.port, "port is required");
                this.serverName = java.util.Objects.requireNonNull(builder.serverName, "serverName is required");
            }

            @Override
            public final java.lang.String getDatabaseName() {
                return this.databaseName;
            }

            @Override
            public final java.lang.Number getPort() {
                return this.port;
            }

            @Override
            public final java.lang.String getServerName() {
                return this.serverName;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("databaseName", om.valueToTree(this.getDatabaseName()));
                data.set("port", om.valueToTree(this.getPort()));
                data.set("serverName", om.valueToTree(this.getServerName()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_dms.CfnDataProvider.RedshiftSettingsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                RedshiftSettingsProperty.Jsii$Proxy that = (RedshiftSettingsProperty.Jsii$Proxy) o;

                if (!databaseName.equals(that.databaseName)) return false;
                if (!port.equals(that.port)) return false;
                return this.serverName.equals(that.serverName);
            }

            @Override
            public final int hashCode() {
                int result = this.databaseName.hashCode();
                result = 31 * result + (this.port.hashCode());
                result = 31 * result + (this.serverName.hashCode());
                return result;
            }
        }
    }
    /**
     * The property identifies the exact type of settings for the data provider.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.dms.*;
     * SettingsProperty settingsProperty = SettingsProperty.builder()
     *         .docDbSettings(DocDbSettingsProperty.builder()
     *                 .databaseName("databaseName")
     *                 .port(123)
     *                 .serverName("serverName")
     *                 // the properties below are optional
     *                 .certificateArn("certificateArn")
     *                 .sslMode("sslMode")
     *                 .build())
     *         .mariaDbSettings(MariaDbSettingsProperty.builder()
     *                 .port(123)
     *                 .serverName("serverName")
     *                 .sslMode("sslMode")
     *                 // the properties below are optional
     *                 .certificateArn("certificateArn")
     *                 .build())
     *         .microsoftSqlServerSettings(MicrosoftSqlServerSettingsProperty.builder()
     *                 .databaseName("databaseName")
     *                 .port(123)
     *                 .serverName("serverName")
     *                 .sslMode("sslMode")
     *                 // the properties below are optional
     *                 .certificateArn("certificateArn")
     *                 .build())
     *         .mongoDbSettings(MongoDbSettingsProperty.builder()
     *                 .port(123)
     *                 .serverName("serverName")
     *                 // the properties below are optional
     *                 .authMechanism("authMechanism")
     *                 .authSource("authSource")
     *                 .authType("authType")
     *                 .certificateArn("certificateArn")
     *                 .databaseName("databaseName")
     *                 .sslMode("sslMode")
     *                 .build())
     *         .mySqlSettings(MySqlSettingsProperty.builder()
     *                 .port(123)
     *                 .serverName("serverName")
     *                 .sslMode("sslMode")
     *                 // the properties below are optional
     *                 .certificateArn("certificateArn")
     *                 .build())
     *         .oracleSettings(OracleSettingsProperty.builder()
     *                 .databaseName("databaseName")
     *                 .port(123)
     *                 .serverName("serverName")
     *                 .sslMode("sslMode")
     *                 // the properties below are optional
     *                 .asmServer("asmServer")
     *                 .certificateArn("certificateArn")
     *                 .secretsManagerOracleAsmAccessRoleArn("secretsManagerOracleAsmAccessRoleArn")
     *                 .secretsManagerOracleAsmSecretId("secretsManagerOracleAsmSecretId")
     *                 .secretsManagerSecurityDbEncryptionAccessRoleArn("secretsManagerSecurityDbEncryptionAccessRoleArn")
     *                 .secretsManagerSecurityDbEncryptionSecretId("secretsManagerSecurityDbEncryptionSecretId")
     *                 .build())
     *         .postgreSqlSettings(PostgreSqlSettingsProperty.builder()
     *                 .databaseName("databaseName")
     *                 .port(123)
     *                 .serverName("serverName")
     *                 .sslMode("sslMode")
     *                 // the properties below are optional
     *                 .certificateArn("certificateArn")
     *                 .build())
     *         .redshiftSettings(RedshiftSettingsProperty.builder()
     *                 .databaseName("databaseName")
     *                 .port(123)
     *                 .serverName("serverName")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-dataprovider-settings.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-dataprovider-settings.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_dms.CfnDataProvider.SettingsProperty")
    @software.amazon.jsii.Jsii.Proxy(SettingsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SettingsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * DocDbSettings property identifier.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-dataprovider-settings.html#cfn-dms-dataprovider-settings-docdbsettings">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-dataprovider-settings.html#cfn-dms-dataprovider-settings-docdbsettings</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDocDbSettings() {
            return null;
        }

        /**
         * MariaDbSettings property identifier.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-dataprovider-settings.html#cfn-dms-dataprovider-settings-mariadbsettings">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-dataprovider-settings.html#cfn-dms-dataprovider-settings-mariadbsettings</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getMariaDbSettings() {
            return null;
        }

        /**
         * MicrosoftSqlServerSettings property identifier.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-dataprovider-settings.html#cfn-dms-dataprovider-settings-microsoftsqlserversettings">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-dataprovider-settings.html#cfn-dms-dataprovider-settings-microsoftsqlserversettings</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getMicrosoftSqlServerSettings() {
            return null;
        }

        /**
         * MongoDbSettings property identifier.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-dataprovider-settings.html#cfn-dms-dataprovider-settings-mongodbsettings">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-dataprovider-settings.html#cfn-dms-dataprovider-settings-mongodbsettings</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getMongoDbSettings() {
            return null;
        }

        /**
         * MySqlSettings property identifier.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-dataprovider-settings.html#cfn-dms-dataprovider-settings-mysqlsettings">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-dataprovider-settings.html#cfn-dms-dataprovider-settings-mysqlsettings</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getMySqlSettings() {
            return null;
        }

        /**
         * OracleSettings property identifier.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-dataprovider-settings.html#cfn-dms-dataprovider-settings-oraclesettings">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-dataprovider-settings.html#cfn-dms-dataprovider-settings-oraclesettings</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getOracleSettings() {
            return null;
        }

        /**
         * PostgreSqlSettings property identifier.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-dataprovider-settings.html#cfn-dms-dataprovider-settings-postgresqlsettings">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-dataprovider-settings.html#cfn-dms-dataprovider-settings-postgresqlsettings</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getPostgreSqlSettings() {
            return null;
        }

        /**
         * RedshiftSettings property identifier.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-dataprovider-settings.html#cfn-dms-dataprovider-settings-redshiftsettings">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-dataprovider-settings.html#cfn-dms-dataprovider-settings-redshiftsettings</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getRedshiftSettings() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link SettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SettingsProperty> {
            java.lang.Object docDbSettings;
            java.lang.Object mariaDbSettings;
            java.lang.Object microsoftSqlServerSettings;
            java.lang.Object mongoDbSettings;
            java.lang.Object mySqlSettings;
            java.lang.Object oracleSettings;
            java.lang.Object postgreSqlSettings;
            java.lang.Object redshiftSettings;

            /**
             * Sets the value of {@link SettingsProperty#getDocDbSettings}
             * @param docDbSettings DocDbSettings property identifier.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder docDbSettings(software.amazon.awscdk.IResolvable docDbSettings) {
                this.docDbSettings = docDbSettings;
                return this;
            }

            /**
             * Sets the value of {@link SettingsProperty#getDocDbSettings}
             * @param docDbSettings DocDbSettings property identifier.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder docDbSettings(software.amazon.awscdk.services.dms.CfnDataProvider.DocDbSettingsProperty docDbSettings) {
                this.docDbSettings = docDbSettings;
                return this;
            }

            /**
             * Sets the value of {@link SettingsProperty#getMariaDbSettings}
             * @param mariaDbSettings MariaDbSettings property identifier.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder mariaDbSettings(software.amazon.awscdk.IResolvable mariaDbSettings) {
                this.mariaDbSettings = mariaDbSettings;
                return this;
            }

            /**
             * Sets the value of {@link SettingsProperty#getMariaDbSettings}
             * @param mariaDbSettings MariaDbSettings property identifier.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder mariaDbSettings(software.amazon.awscdk.services.dms.CfnDataProvider.MariaDbSettingsProperty mariaDbSettings) {
                this.mariaDbSettings = mariaDbSettings;
                return this;
            }

            /**
             * Sets the value of {@link SettingsProperty#getMicrosoftSqlServerSettings}
             * @param microsoftSqlServerSettings MicrosoftSqlServerSettings property identifier.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder microsoftSqlServerSettings(software.amazon.awscdk.IResolvable microsoftSqlServerSettings) {
                this.microsoftSqlServerSettings = microsoftSqlServerSettings;
                return this;
            }

            /**
             * Sets the value of {@link SettingsProperty#getMicrosoftSqlServerSettings}
             * @param microsoftSqlServerSettings MicrosoftSqlServerSettings property identifier.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder microsoftSqlServerSettings(software.amazon.awscdk.services.dms.CfnDataProvider.MicrosoftSqlServerSettingsProperty microsoftSqlServerSettings) {
                this.microsoftSqlServerSettings = microsoftSqlServerSettings;
                return this;
            }

            /**
             * Sets the value of {@link SettingsProperty#getMongoDbSettings}
             * @param mongoDbSettings MongoDbSettings property identifier.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder mongoDbSettings(software.amazon.awscdk.IResolvable mongoDbSettings) {
                this.mongoDbSettings = mongoDbSettings;
                return this;
            }

            /**
             * Sets the value of {@link SettingsProperty#getMongoDbSettings}
             * @param mongoDbSettings MongoDbSettings property identifier.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder mongoDbSettings(software.amazon.awscdk.services.dms.CfnDataProvider.MongoDbSettingsProperty mongoDbSettings) {
                this.mongoDbSettings = mongoDbSettings;
                return this;
            }

            /**
             * Sets the value of {@link SettingsProperty#getMySqlSettings}
             * @param mySqlSettings MySqlSettings property identifier.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder mySqlSettings(software.amazon.awscdk.IResolvable mySqlSettings) {
                this.mySqlSettings = mySqlSettings;
                return this;
            }

            /**
             * Sets the value of {@link SettingsProperty#getMySqlSettings}
             * @param mySqlSettings MySqlSettings property identifier.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder mySqlSettings(software.amazon.awscdk.services.dms.CfnDataProvider.MySqlSettingsProperty mySqlSettings) {
                this.mySqlSettings = mySqlSettings;
                return this;
            }

            /**
             * Sets the value of {@link SettingsProperty#getOracleSettings}
             * @param oracleSettings OracleSettings property identifier.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder oracleSettings(software.amazon.awscdk.IResolvable oracleSettings) {
                this.oracleSettings = oracleSettings;
                return this;
            }

            /**
             * Sets the value of {@link SettingsProperty#getOracleSettings}
             * @param oracleSettings OracleSettings property identifier.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder oracleSettings(software.amazon.awscdk.services.dms.CfnDataProvider.OracleSettingsProperty oracleSettings) {
                this.oracleSettings = oracleSettings;
                return this;
            }

            /**
             * Sets the value of {@link SettingsProperty#getPostgreSqlSettings}
             * @param postgreSqlSettings PostgreSqlSettings property identifier.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder postgreSqlSettings(software.amazon.awscdk.IResolvable postgreSqlSettings) {
                this.postgreSqlSettings = postgreSqlSettings;
                return this;
            }

            /**
             * Sets the value of {@link SettingsProperty#getPostgreSqlSettings}
             * @param postgreSqlSettings PostgreSqlSettings property identifier.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder postgreSqlSettings(software.amazon.awscdk.services.dms.CfnDataProvider.PostgreSqlSettingsProperty postgreSqlSettings) {
                this.postgreSqlSettings = postgreSqlSettings;
                return this;
            }

            /**
             * Sets the value of {@link SettingsProperty#getRedshiftSettings}
             * @param redshiftSettings RedshiftSettings property identifier.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder redshiftSettings(software.amazon.awscdk.IResolvable redshiftSettings) {
                this.redshiftSettings = redshiftSettings;
                return this;
            }

            /**
             * Sets the value of {@link SettingsProperty#getRedshiftSettings}
             * @param redshiftSettings RedshiftSettings property identifier.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder redshiftSettings(software.amazon.awscdk.services.dms.CfnDataProvider.RedshiftSettingsProperty redshiftSettings) {
                this.redshiftSettings = redshiftSettings;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SettingsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SettingsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SettingsProperty {
            private final java.lang.Object docDbSettings;
            private final java.lang.Object mariaDbSettings;
            private final java.lang.Object microsoftSqlServerSettings;
            private final java.lang.Object mongoDbSettings;
            private final java.lang.Object mySqlSettings;
            private final java.lang.Object oracleSettings;
            private final java.lang.Object postgreSqlSettings;
            private final java.lang.Object redshiftSettings;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.docDbSettings = software.amazon.jsii.Kernel.get(this, "docDbSettings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.mariaDbSettings = software.amazon.jsii.Kernel.get(this, "mariaDbSettings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.microsoftSqlServerSettings = software.amazon.jsii.Kernel.get(this, "microsoftSqlServerSettings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.mongoDbSettings = software.amazon.jsii.Kernel.get(this, "mongoDbSettings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.mySqlSettings = software.amazon.jsii.Kernel.get(this, "mySqlSettings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.oracleSettings = software.amazon.jsii.Kernel.get(this, "oracleSettings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.postgreSqlSettings = software.amazon.jsii.Kernel.get(this, "postgreSqlSettings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.redshiftSettings = software.amazon.jsii.Kernel.get(this, "redshiftSettings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.docDbSettings = builder.docDbSettings;
                this.mariaDbSettings = builder.mariaDbSettings;
                this.microsoftSqlServerSettings = builder.microsoftSqlServerSettings;
                this.mongoDbSettings = builder.mongoDbSettings;
                this.mySqlSettings = builder.mySqlSettings;
                this.oracleSettings = builder.oracleSettings;
                this.postgreSqlSettings = builder.postgreSqlSettings;
                this.redshiftSettings = builder.redshiftSettings;
            }

            @Override
            public final java.lang.Object getDocDbSettings() {
                return this.docDbSettings;
            }

            @Override
            public final java.lang.Object getMariaDbSettings() {
                return this.mariaDbSettings;
            }

            @Override
            public final java.lang.Object getMicrosoftSqlServerSettings() {
                return this.microsoftSqlServerSettings;
            }

            @Override
            public final java.lang.Object getMongoDbSettings() {
                return this.mongoDbSettings;
            }

            @Override
            public final java.lang.Object getMySqlSettings() {
                return this.mySqlSettings;
            }

            @Override
            public final java.lang.Object getOracleSettings() {
                return this.oracleSettings;
            }

            @Override
            public final java.lang.Object getPostgreSqlSettings() {
                return this.postgreSqlSettings;
            }

            @Override
            public final java.lang.Object getRedshiftSettings() {
                return this.redshiftSettings;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getDocDbSettings() != null) {
                    data.set("docDbSettings", om.valueToTree(this.getDocDbSettings()));
                }
                if (this.getMariaDbSettings() != null) {
                    data.set("mariaDbSettings", om.valueToTree(this.getMariaDbSettings()));
                }
                if (this.getMicrosoftSqlServerSettings() != null) {
                    data.set("microsoftSqlServerSettings", om.valueToTree(this.getMicrosoftSqlServerSettings()));
                }
                if (this.getMongoDbSettings() != null) {
                    data.set("mongoDbSettings", om.valueToTree(this.getMongoDbSettings()));
                }
                if (this.getMySqlSettings() != null) {
                    data.set("mySqlSettings", om.valueToTree(this.getMySqlSettings()));
                }
                if (this.getOracleSettings() != null) {
                    data.set("oracleSettings", om.valueToTree(this.getOracleSettings()));
                }
                if (this.getPostgreSqlSettings() != null) {
                    data.set("postgreSqlSettings", om.valueToTree(this.getPostgreSqlSettings()));
                }
                if (this.getRedshiftSettings() != null) {
                    data.set("redshiftSettings", om.valueToTree(this.getRedshiftSettings()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_dms.CfnDataProvider.SettingsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SettingsProperty.Jsii$Proxy that = (SettingsProperty.Jsii$Proxy) o;

                if (this.docDbSettings != null ? !this.docDbSettings.equals(that.docDbSettings) : that.docDbSettings != null) return false;
                if (this.mariaDbSettings != null ? !this.mariaDbSettings.equals(that.mariaDbSettings) : that.mariaDbSettings != null) return false;
                if (this.microsoftSqlServerSettings != null ? !this.microsoftSqlServerSettings.equals(that.microsoftSqlServerSettings) : that.microsoftSqlServerSettings != null) return false;
                if (this.mongoDbSettings != null ? !this.mongoDbSettings.equals(that.mongoDbSettings) : that.mongoDbSettings != null) return false;
                if (this.mySqlSettings != null ? !this.mySqlSettings.equals(that.mySqlSettings) : that.mySqlSettings != null) return false;
                if (this.oracleSettings != null ? !this.oracleSettings.equals(that.oracleSettings) : that.oracleSettings != null) return false;
                if (this.postgreSqlSettings != null ? !this.postgreSqlSettings.equals(that.postgreSqlSettings) : that.postgreSqlSettings != null) return false;
                return this.redshiftSettings != null ? this.redshiftSettings.equals(that.redshiftSettings) : that.redshiftSettings == null;
            }

            @Override
            public final int hashCode() {
                int result = this.docDbSettings != null ? this.docDbSettings.hashCode() : 0;
                result = 31 * result + (this.mariaDbSettings != null ? this.mariaDbSettings.hashCode() : 0);
                result = 31 * result + (this.microsoftSqlServerSettings != null ? this.microsoftSqlServerSettings.hashCode() : 0);
                result = 31 * result + (this.mongoDbSettings != null ? this.mongoDbSettings.hashCode() : 0);
                result = 31 * result + (this.mySqlSettings != null ? this.mySqlSettings.hashCode() : 0);
                result = 31 * result + (this.oracleSettings != null ? this.oracleSettings.hashCode() : 0);
                result = 31 * result + (this.postgreSqlSettings != null ? this.postgreSqlSettings.hashCode() : 0);
                result = 31 * result + (this.redshiftSettings != null ? this.redshiftSettings.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.dms.CfnDataProvider}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.dms.CfnDataProvider> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.dms.CfnDataProviderProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.dms.CfnDataProviderProps.Builder();
        }

        /**
         * The type of database engine for the data provider.
         * <p>
         * Valid values include <code>"aurora"</code> , <code>"aurora-postgresql"</code> , <code>"mysql"</code> , <code>"oracle"</code> , <code>"postgres"</code> , <code>"sqlserver"</code> , <code>redshift</code> , <code>mariadb</code> , <code>mongodb</code> , and <code>docdb</code> . A value of <code>"aurora"</code> represents Amazon Aurora MySQL-Compatible Edition.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-dataprovider.html#cfn-dms-dataprovider-engine">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-dataprovider.html#cfn-dms-dataprovider-engine</a>
         * @param engine The type of database engine for the data provider. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder engine(final java.lang.String engine) {
            this.props.engine(engine);
            return this;
        }

        /**
         * The identifier of the data provider.
         * <p>
         * Identifiers must begin with a letter and must contain only ASCII letters, digits, and hyphens. They can't end with a hyphen, or contain two consecutive hyphens.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-dataprovider.html#cfn-dms-dataprovider-dataprovideridentifier">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-dataprovider.html#cfn-dms-dataprovider-dataprovideridentifier</a>
         * @param dataProviderIdentifier The identifier of the data provider. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dataProviderIdentifier(final java.lang.String dataProviderIdentifier) {
            this.props.dataProviderIdentifier(dataProviderIdentifier);
            return this;
        }

        /**
         * The name of the data provider.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-dataprovider.html#cfn-dms-dataprovider-dataprovidername">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-dataprovider.html#cfn-dms-dataprovider-dataprovidername</a>
         * @param dataProviderName The name of the data provider. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dataProviderName(final java.lang.String dataProviderName) {
            this.props.dataProviderName(dataProviderName);
            return this;
        }

        /**
         * A description of the data provider.
         * <p>
         * Descriptions can have up to 31 characters. A description can contain only ASCII letters, digits, and hyphens ('-'). Also, it can't end with a hyphen or contain two consecutive hyphens, and can only begin with a letter.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-dataprovider.html#cfn-dms-dataprovider-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-dataprovider.html#cfn-dms-dataprovider-description</a>
         * @param description A description of the data provider. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(final java.lang.String description) {
            this.props.description(description);
            return this;
        }

        /**
         * The property describes the exact settings which can be modified.
         * <p>
         * Default: - false
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-dataprovider.html#cfn-dms-dataprovider-exactsettings">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-dataprovider.html#cfn-dms-dataprovider-exactsettings</a>
         * @param exactSettings The property describes the exact settings which can be modified. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder exactSettings(final java.lang.Boolean exactSettings) {
            this.props.exactSettings(exactSettings);
            return this;
        }
        /**
         * The property describes the exact settings which can be modified.
         * <p>
         * Default: - false
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-dataprovider.html#cfn-dms-dataprovider-exactsettings">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-dataprovider.html#cfn-dms-dataprovider-exactsettings</a>
         * @param exactSettings The property describes the exact settings which can be modified. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder exactSettings(final software.amazon.awscdk.IResolvable exactSettings) {
            this.props.exactSettings(exactSettings);
            return this;
        }

        /**
         * The settings in JSON format for a data provider.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-dataprovider.html#cfn-dms-dataprovider-settings">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-dataprovider.html#cfn-dms-dataprovider-settings</a>
         * @param settings The settings in JSON format for a data provider. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder settings(final software.amazon.awscdk.IResolvable settings) {
            this.props.settings(settings);
            return this;
        }
        /**
         * The settings in JSON format for a data provider.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-dataprovider.html#cfn-dms-dataprovider-settings">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-dataprovider.html#cfn-dms-dataprovider-settings</a>
         * @param settings The settings in JSON format for a data provider. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder settings(final software.amazon.awscdk.services.dms.CfnDataProvider.SettingsProperty settings) {
            this.props.settings(settings);
            return this;
        }

        /**
         * An array of key-value pairs to apply to this resource.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-dataprovider.html#cfn-dms-dataprovider-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-dataprovider.html#cfn-dms-dataprovider-tags</a>
         * @param tags An array of key-value pairs to apply to this resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.dms.CfnDataProvider}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.dms.CfnDataProvider build() {
            return new software.amazon.awscdk.services.dms.CfnDataProvider(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
