package software.amazon.awscdk.services.dynamodb;

/**
 * Base class for a DynamoDB table.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-01-25T00:20:53.987Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_dynamodb.TableBaseV2")
public abstract class TableBaseV2 extends software.amazon.awscdk.Resource implements software.amazon.awscdk.services.dynamodb.ITableV2, software.amazon.awscdk.services.iam.IResourceWithPolicy {

    protected TableBaseV2(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected TableBaseV2(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected TableBaseV2(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.ResourceProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), props });
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected TableBaseV2(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * Adds a statement to the resource policy associated with this file system.
     * <p>
     * A resource policy will be automatically created upon the first call to <code>addToResourcePolicy</code>.
     * <p>
     * Note that this does not work with imported file systems.
     * <p>
     * @param statement The policy statement to add. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.AddToResourcePolicyResult addToResourcePolicy(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.PolicyStatement statement) {
        return software.amazon.jsii.Kernel.call(this, "addToResourcePolicy", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.AddToResourcePolicyResult.class), new Object[] { java.util.Objects.requireNonNull(statement, "statement is required") });
    }

    /**
     * Adds an IAM policy statement associated with this table to an IAM principal's policy.
     * <p>
     * Note: If <code>encryptionKey</code> is present, appropriate grants to the key needs to be added
     * separately using the <code>table.encryptionKey.grant*</code> methods.
     * <p>
     * @param grantee the principal (no-op if undefined). This parameter is required.
     * @param actions the set of actions to allow (i.e., 'dynamodb:PutItem', 'dynamodb:GetItem', etc.). This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grant(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable grantee, final @org.jetbrains.annotations.NotNull java.lang.String... actions) {
        return software.amazon.jsii.Kernel.call(this, "grant", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.Grant.class), java.util.stream.Stream.concat(java.util.Arrays.<Object>stream(new Object[] { java.util.Objects.requireNonNull(grantee, "grantee is required") }), java.util.Arrays.<Object>stream(actions)).toArray(Object[]::new));
    }

    /**
     * Permits an IAM principal to all DynamoDB operations ('dynamodb:*') on this table.
     * <p>
     * Note: Appropriate grants will also be added to the customer-managed KMS keys associated with this
     * table if one was configured.
     * <p>
     * @param grantee the principal to grant access to. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grantFullAccess(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable grantee) {
        return software.amazon.jsii.Kernel.call(this, "grantFullAccess", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.Grant.class), new Object[] { java.util.Objects.requireNonNull(grantee, "grantee is required") });
    }

    /**
     * Permits an IAM principal all data read operations on this table.
     * <p>
     * Actions: BatchGetItem, GetRecords, GetShardIterator, Query, GetItem, Scan, DescribeTable.
     * <p>
     * Note: Appropriate grants will also be added to the customer-managed KMS keys associated with this
     * table if one was configured.
     * <p>
     * @param grantee the principal to grant access to. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grantReadData(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable grantee) {
        return software.amazon.jsii.Kernel.call(this, "grantReadData", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.Grant.class), new Object[] { java.util.Objects.requireNonNull(grantee, "grantee is required") });
    }

    /**
     * Permits an IAM principal to all data read/write operations on this table.
     * <p>
     * Actions: BatchGetItem, GetRecords, GetShardIterator, Query, GetItem, Scan, BatchWriteItem, PutItem, UpdateItem,
     * DeleteItem, DescribeTable.
     * <p>
     * Note: Appropriate grants will also be added to the customer-managed KMS keys associated with this
     * table if one was configured.
     * <p>
     * @param grantee the principal to grant access to. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grantReadWriteData(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable grantee) {
        return software.amazon.jsii.Kernel.call(this, "grantReadWriteData", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.Grant.class), new Object[] { java.util.Objects.requireNonNull(grantee, "grantee is required") });
    }

    /**
     * Adds an IAM policy statement associated with this table to an IAM principal's policy.
     * <p>
     * Note: If <code>encryptionKey</code> is present, appropriate grants to the key needs to be added
     * separately using the <code>table.encryptionKey.grant*</code> methods.
     * <p>
     * @param grantee the principal (no-op if undefined). This parameter is required.
     * @param actions the set of actions to allow (i.e., 'dynamodb:DescribeStream', 'dynamodb:GetRecords', etc.). This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grantStream(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable grantee, final @org.jetbrains.annotations.NotNull java.lang.String... actions) {
        return software.amazon.jsii.Kernel.call(this, "grantStream", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.Grant.class), java.util.stream.Stream.concat(java.util.Arrays.<Object>stream(new Object[] { java.util.Objects.requireNonNull(grantee, "grantee is required") }), java.util.Arrays.<Object>stream(actions)).toArray(Object[]::new));
    }

    /**
     * Adds an IAM policy statement associated with this table to an IAM principal's policy.
     * <p>
     * Actions: DescribeStream, GetRecords, GetShardIterator, ListStreams.
     * <p>
     * Note: Appropriate grants will also be added to the customer-managed KMS keys associated with this
     * table if one was configured.
     * <p>
     * @param grantee the principal to grant access to. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grantStreamRead(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable grantee) {
        return software.amazon.jsii.Kernel.call(this, "grantStreamRead", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.Grant.class), new Object[] { java.util.Objects.requireNonNull(grantee, "grantee is required") });
    }

    /**
     * Permits an IAM principal to list streams attached to this table.
     * <p>
     * @param grantee the principal to grant access to. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grantTableListStreams(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable grantee) {
        return software.amazon.jsii.Kernel.call(this, "grantTableListStreams", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.Grant.class), new Object[] { java.util.Objects.requireNonNull(grantee, "grantee is required") });
    }

    /**
     * Permits an IAM principal all data write operations on this table.
     * <p>
     * Actions: BatchWriteItem, PutItem, UpdateItem, DeleteItem, DescribeTable.
     * <p>
     * Note: Appropriate grants will also be added to the customer-managed KMS keys associated with this
     * table if one was configured.
     * <p>
     * @param grantee the principal to grant access to. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grantWriteData(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable grantee) {
        return software.amazon.jsii.Kernel.call(this, "grantWriteData", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.Grant.class), new Object[] { java.util.Objects.requireNonNull(grantee, "grantee is required") });
    }

    /**
     * Return the given named metric for this table.
     * <p>
     * By default, the metric will be calculated as a sum over a period of 5 minutes.
     * You can customize this by using the <code>statistic</code> and <code>period</code> properties.
     * <p>
     * @param metricName This parameter is required.
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metric(final @org.jetbrains.annotations.NotNull java.lang.String metricName, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return software.amazon.jsii.Kernel.call(this, "metric", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { java.util.Objects.requireNonNull(metricName, "metricName is required"), props });
    }

    /**
     * Return the given named metric for this table.
     * <p>
     * By default, the metric will be calculated as a sum over a period of 5 minutes.
     * You can customize this by using the <code>statistic</code> and <code>period</code> properties.
     * <p>
     * @param metricName This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metric(final @org.jetbrains.annotations.NotNull java.lang.String metricName) {
        return software.amazon.jsii.Kernel.call(this, "metric", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { java.util.Objects.requireNonNull(metricName, "metricName is required") });
    }

    /**
     * Metric for the conditional check failed requests for this table.
     * <p>
     * By default, the metric will be calculated as a sum over a period of 5 minutes.
     * You can customize this by using the <code>statistic</code> and <code>period</code> properties.
     * <p>
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricConditionalCheckFailedRequests(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return software.amazon.jsii.Kernel.call(this, "metricConditionalCheckFailedRequests", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
    }

    /**
     * Metric for the conditional check failed requests for this table.
     * <p>
     * By default, the metric will be calculated as a sum over a period of 5 minutes.
     * You can customize this by using the <code>statistic</code> and <code>period</code> properties.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricConditionalCheckFailedRequests() {
        return software.amazon.jsii.Kernel.call(this, "metricConditionalCheckFailedRequests", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class));
    }

    /**
     * Metric for the consumed read capacity units for this table.
     * <p>
     * By default, the metric will be calculated as a sum over a period of 5 minutes.
     * You can customize this by using the <code>statistic</code> and <code>period</code> properties.
     * <p>
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricConsumedReadCapacityUnits(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return software.amazon.jsii.Kernel.call(this, "metricConsumedReadCapacityUnits", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
    }

    /**
     * Metric for the consumed read capacity units for this table.
     * <p>
     * By default, the metric will be calculated as a sum over a period of 5 minutes.
     * You can customize this by using the <code>statistic</code> and <code>period</code> properties.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricConsumedReadCapacityUnits() {
        return software.amazon.jsii.Kernel.call(this, "metricConsumedReadCapacityUnits", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class));
    }

    /**
     * Metric for the consumed write capacity units for this table.
     * <p>
     * By default, the metric will be calculated as a sum over a period of 5 minutes.
     * You can customize this by using the <code>statistic</code> and <code>period</code> properties.
     * <p>
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricConsumedWriteCapacityUnits(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return software.amazon.jsii.Kernel.call(this, "metricConsumedWriteCapacityUnits", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
    }

    /**
     * Metric for the consumed write capacity units for this table.
     * <p>
     * By default, the metric will be calculated as a sum over a period of 5 minutes.
     * You can customize this by using the <code>statistic</code> and <code>period</code> properties.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricConsumedWriteCapacityUnits() {
        return software.amazon.jsii.Kernel.call(this, "metricConsumedWriteCapacityUnits", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class));
    }

    /**
     * Metric for the successful request latency for this table.
     * <p>
     * By default, the metric will be calculated as an average over a period of 5 minutes.
     * You can customize this by using the <code>statistic</code> and <code>period</code> properties.
     * <p>
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricSuccessfulRequestLatency(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return software.amazon.jsii.Kernel.call(this, "metricSuccessfulRequestLatency", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
    }

    /**
     * Metric for the successful request latency for this table.
     * <p>
     * By default, the metric will be calculated as an average over a period of 5 minutes.
     * You can customize this by using the <code>statistic</code> and <code>period</code> properties.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricSuccessfulRequestLatency() {
        return software.amazon.jsii.Kernel.call(this, "metricSuccessfulRequestLatency", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class));
    }

    /**
     * (deprecated) Metric for the system errors this table.
     * <p>
     * @deprecated use <code>metricSystemErrorsForOperations</code>.
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricSystemErrors(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return software.amazon.jsii.Kernel.call(this, "metricSystemErrors", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
    }

    /**
     * (deprecated) Metric for the system errors this table.
     * <p>
     * @deprecated use <code>metricSystemErrorsForOperations</code>.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricSystemErrors() {
        return software.amazon.jsii.Kernel.call(this, "metricSystemErrors", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class));
    }

    /**
     * Metric for the system errors for this table. This will sum errors across all possible operations.
     * <p>
     * By default, each individual metric will be calculated as a sum over a period of 5 minutes.
     * You can customize this by using the <code>statistic</code> and <code>period</code> properties.
     * <p>
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.IMetric metricSystemErrorsForOperations(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.dynamodb.SystemErrorsForOperationsMetricOptions props) {
        return software.amazon.jsii.Kernel.call(this, "metricSystemErrorsForOperations", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.IMetric.class), new Object[] { props });
    }

    /**
     * Metric for the system errors for this table. This will sum errors across all possible operations.
     * <p>
     * By default, each individual metric will be calculated as a sum over a period of 5 minutes.
     * You can customize this by using the <code>statistic</code> and <code>period</code> properties.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.IMetric metricSystemErrorsForOperations() {
        return software.amazon.jsii.Kernel.call(this, "metricSystemErrorsForOperations", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.IMetric.class));
    }

    /**
     * (deprecated) How many requests are throttled on this table.
     * <p>
     * By default, each individual metric will be calculated as a sum over a period of 5 minutes.
     * You can customize this by using the <code>statistic</code> and <code>period</code> properties.
     * <p>
     * @deprecated Do not use this function. It returns an invalid metric. Use <code>metricThrottledRequestsForOperation</code> instead.
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricThrottledRequests(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return software.amazon.jsii.Kernel.call(this, "metricThrottledRequests", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
    }

    /**
     * (deprecated) How many requests are throttled on this table.
     * <p>
     * By default, each individual metric will be calculated as a sum over a period of 5 minutes.
     * You can customize this by using the <code>statistic</code> and <code>period</code> properties.
     * <p>
     * @deprecated Do not use this function. It returns an invalid metric. Use <code>metricThrottledRequestsForOperation</code> instead.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricThrottledRequests() {
        return software.amazon.jsii.Kernel.call(this, "metricThrottledRequests", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class));
    }

    /**
     * How many requests are throttled on this table for the given operation.
     * <p>
     * By default, the metric will be calculated as an average over a period of 5 minutes.
     * You can customize this by using the <code>statistic</code> and <code>period</code> properties.
     * <p>
     * @param operation This parameter is required.
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.IMetric metricThrottledRequestsForOperation(final @org.jetbrains.annotations.NotNull java.lang.String operation, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.dynamodb.OperationsMetricOptions props) {
        return software.amazon.jsii.Kernel.call(this, "metricThrottledRequestsForOperation", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.IMetric.class), new Object[] { java.util.Objects.requireNonNull(operation, "operation is required"), props });
    }

    /**
     * How many requests are throttled on this table for the given operation.
     * <p>
     * By default, the metric will be calculated as an average over a period of 5 minutes.
     * You can customize this by using the <code>statistic</code> and <code>period</code> properties.
     * <p>
     * @param operation This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.IMetric metricThrottledRequestsForOperation(final @org.jetbrains.annotations.NotNull java.lang.String operation) {
        return software.amazon.jsii.Kernel.call(this, "metricThrottledRequestsForOperation", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.IMetric.class), new Object[] { java.util.Objects.requireNonNull(operation, "operation is required") });
    }

    /**
     * How many requests are throttled on this table. This will sum errors across all possible operations.
     * <p>
     * By default, each individual metric will be calculated as a sum over a period of 5 minutes.
     * You can customize this by using the <code>statistic</code> and <code>period</code> properties.
     * <p>
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.IMetric metricThrottledRequestsForOperations(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.dynamodb.OperationsMetricOptions props) {
        return software.amazon.jsii.Kernel.call(this, "metricThrottledRequestsForOperations", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.IMetric.class), new Object[] { props });
    }

    /**
     * How many requests are throttled on this table. This will sum errors across all possible operations.
     * <p>
     * By default, each individual metric will be calculated as a sum over a period of 5 minutes.
     * You can customize this by using the <code>statistic</code> and <code>period</code> properties.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.IMetric metricThrottledRequestsForOperations() {
        return software.amazon.jsii.Kernel.call(this, "metricThrottledRequestsForOperations", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.IMetric.class));
    }

    /**
     * Metric for the user errors for this table.
     * <p>
     * Note: This metric reports user errors across all the tables in the account and region the table
     * resides in.
     * <p>
     * By default, the metric will be calculated as a sum over a period of 5 minutes.
     * You can customize this by using the <code>statistic</code> and <code>period</code> properties.
     * <p>
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricUserErrors(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return software.amazon.jsii.Kernel.call(this, "metricUserErrors", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
    }

    /**
     * Metric for the user errors for this table.
     * <p>
     * Note: This metric reports user errors across all the tables in the account and region the table
     * resides in.
     * <p>
     * By default, the metric will be calculated as a sum over a period of 5 minutes.
     * You can customize this by using the <code>statistic</code> and <code>period</code> properties.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricUserErrors() {
        return software.amazon.jsii.Kernel.call(this, "metricUserErrors", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected abstract @org.jetbrains.annotations.NotNull java.lang.Boolean getHasIndex();

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected abstract @org.jetbrains.annotations.NotNull java.lang.String getRegion();

    /**
     * The ARN of the table.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public abstract @org.jetbrains.annotations.NotNull java.lang.String getTableArn();

    /**
     * The name of the table.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public abstract @org.jetbrains.annotations.NotNull java.lang.String getTableName();

    /**
     * The KMS encryption key for the table.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public abstract @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.kms.IKey getEncryptionKey();

    /**
     * The ID of the table.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public abstract @org.jetbrains.annotations.Nullable java.lang.String getTableId();

    /**
     * The stream ARN of the table.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public abstract @org.jetbrains.annotations.Nullable java.lang.String getTableStreamArn();

    /**
     * The resource policy for the table.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public abstract @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.iam.PolicyDocument getResourcePolicy();

    /**
     * The resource policy for the table.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public abstract void setResourcePolicy(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.iam.PolicyDocument value);

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    @software.amazon.jsii.Internal
    private static final class Jsii$Proxy extends software.amazon.awscdk.services.dynamodb.TableBaseV2 implements software.amazon.awscdk.services.dynamodb.ITableV2.Jsii$Default, software.amazon.awscdk.services.iam.IResourceWithPolicy.Jsii$Default, software.amazon.awscdk.IResource.Jsii$Default, software.constructs.IConstruct.Jsii$Default {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
        }

        /**
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        protected final @org.jetbrains.annotations.NotNull java.lang.Boolean getHasIndex() {
            return software.amazon.jsii.Kernel.get(this, "hasIndex", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
        }

        /**
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        protected final @org.jetbrains.annotations.NotNull java.lang.String getRegion() {
            return software.amazon.jsii.Kernel.get(this, "region", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * The ARN of the table.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.NotNull java.lang.String getTableArn() {
            return software.amazon.jsii.Kernel.get(this, "tableArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * The name of the table.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.NotNull java.lang.String getTableName() {
            return software.amazon.jsii.Kernel.get(this, "tableName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * The KMS encryption key for the table.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.kms.IKey getEncryptionKey() {
            return software.amazon.jsii.Kernel.get(this, "encryptionKey", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.kms.IKey.class));
        }

        /**
         * The ID of the table.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.Nullable java.lang.String getTableId() {
            return software.amazon.jsii.Kernel.get(this, "tableId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * The stream ARN of the table.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.Nullable java.lang.String getTableStreamArn() {
            return software.amazon.jsii.Kernel.get(this, "tableStreamArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * The resource policy for the table.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.iam.PolicyDocument getResourcePolicy() {
            return software.amazon.jsii.Kernel.get(this, "resourcePolicy", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.PolicyDocument.class));
        }

        /**
         * The resource policy for the table.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final void setResourcePolicy(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.iam.PolicyDocument value) {
            software.amazon.jsii.Kernel.set(this, "resourcePolicy", value);
        }
    }
}
