package software.amazon.awscdk.services.dynamodb;

/**
 * Properties used to configure provisioned throughput for a DynamoDB table.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.*;
 * App app = new App();
 * Stack stack = Stack.Builder.create(app, "Stack").env(Environment.builder().region("us-west-2").build()).build();
 * TableV2 globalTable = TableV2.Builder.create(stack, "GlobalTable")
 *         .partitionKey(Attribute.builder().name("pk").type(AttributeType.STRING).build())
 *         .billing(Billing.provisioned(ThroughputProps.builder()
 *                 .readCapacity(Capacity.fixed(10))
 *                 .writeCapacity(Capacity.autoscaled(AutoscaledCapacityOptions.builder().maxCapacity(15).build()))
 *                 .build()))
 *         .replicas(List.of(ReplicaTableProps.builder()
 *                 .region("us-east-1")
 *                 .build(), ReplicaTableProps.builder()
 *                 .region("us-east-2")
 *                 .readCapacity(Capacity.autoscaled(AutoscaledCapacityOptions.builder().maxCapacity(20).targetUtilizationPercent(50).build()))
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-01-25T00:20:53.996Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_dynamodb.ThroughputProps")
@software.amazon.jsii.Jsii.Proxy(ThroughputProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface ThroughputProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The read capacity.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.dynamodb.Capacity getReadCapacity();

    /**
     * The write capacity.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.dynamodb.Capacity getWriteCapacity();

    /**
     * @return a {@link Builder} of {@link ThroughputProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link ThroughputProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<ThroughputProps> {
        software.amazon.awscdk.services.dynamodb.Capacity readCapacity;
        software.amazon.awscdk.services.dynamodb.Capacity writeCapacity;

        /**
         * Sets the value of {@link ThroughputProps#getReadCapacity}
         * @param readCapacity The read capacity. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder readCapacity(software.amazon.awscdk.services.dynamodb.Capacity readCapacity) {
            this.readCapacity = readCapacity;
            return this;
        }

        /**
         * Sets the value of {@link ThroughputProps#getWriteCapacity}
         * @param writeCapacity The write capacity. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder writeCapacity(software.amazon.awscdk.services.dynamodb.Capacity writeCapacity) {
            this.writeCapacity = writeCapacity;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ThroughputProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public ThroughputProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link ThroughputProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ThroughputProps {
        private final software.amazon.awscdk.services.dynamodb.Capacity readCapacity;
        private final software.amazon.awscdk.services.dynamodb.Capacity writeCapacity;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.readCapacity = software.amazon.jsii.Kernel.get(this, "readCapacity", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.dynamodb.Capacity.class));
            this.writeCapacity = software.amazon.jsii.Kernel.get(this, "writeCapacity", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.dynamodb.Capacity.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.readCapacity = java.util.Objects.requireNonNull(builder.readCapacity, "readCapacity is required");
            this.writeCapacity = java.util.Objects.requireNonNull(builder.writeCapacity, "writeCapacity is required");
        }

        @Override
        public final software.amazon.awscdk.services.dynamodb.Capacity getReadCapacity() {
            return this.readCapacity;
        }

        @Override
        public final software.amazon.awscdk.services.dynamodb.Capacity getWriteCapacity() {
            return this.writeCapacity;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("readCapacity", om.valueToTree(this.getReadCapacity()));
            data.set("writeCapacity", om.valueToTree(this.getWriteCapacity()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_dynamodb.ThroughputProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ThroughputProps.Jsii$Proxy that = (ThroughputProps.Jsii$Proxy) o;

            if (!readCapacity.equals(that.readCapacity)) return false;
            return this.writeCapacity.equals(that.writeCapacity);
        }

        @Override
        public final int hashCode() {
            int result = this.readCapacity.hashCode();
            result = 31 * result + (this.writeCapacity.hashCode());
            return result;
        }
    }
}
