package software.amazon.awscdk.services.ec2;

/**
 * Optional parameters used when creating a user.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.ec2.*;
 * InitUserOptions initUserOptions = InitUserOptions.builder()
 *         .groups(List.of("groups"))
 *         .homeDir("homeDir")
 *         .userId(123)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-01-25T00:20:54.612Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ec2.InitUserOptions")
@software.amazon.jsii.Jsii.Proxy(InitUserOptions.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface InitUserOptions extends software.amazon.jsii.JsiiSerializable {

    /**
     * A list of group names.
     * <p>
     * The user will be added to each group in the list.
     * <p>
     * Default: the user is not associated with any groups.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getGroups() {
        return null;
    }

    /**
     * The user's home directory.
     * <p>
     * Default: assigned by the OS
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getHomeDir() {
        return null;
    }

    /**
     * A user ID.
     * <p>
     * The creation process fails if the user name exists with a different user ID.
     * If the user ID is already assigned to an existing user the operating system may
     * reject the creation request.
     * <p>
     * Default: assigned by the OS
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getUserId() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link InitUserOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link InitUserOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<InitUserOptions> {
        java.util.List<java.lang.String> groups;
        java.lang.String homeDir;
        java.lang.Number userId;

        /**
         * Sets the value of {@link InitUserOptions#getGroups}
         * @param groups A list of group names.
         *               The user will be added to each group in the list.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder groups(java.util.List<java.lang.String> groups) {
            this.groups = groups;
            return this;
        }

        /**
         * Sets the value of {@link InitUserOptions#getHomeDir}
         * @param homeDir The user's home directory.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder homeDir(java.lang.String homeDir) {
            this.homeDir = homeDir;
            return this;
        }

        /**
         * Sets the value of {@link InitUserOptions#getUserId}
         * @param userId A user ID.
         *               The creation process fails if the user name exists with a different user ID.
         *               If the user ID is already assigned to an existing user the operating system may
         *               reject the creation request.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder userId(java.lang.Number userId) {
            this.userId = userId;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link InitUserOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public InitUserOptions build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link InitUserOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements InitUserOptions {
        private final java.util.List<java.lang.String> groups;
        private final java.lang.String homeDir;
        private final java.lang.Number userId;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.groups = software.amazon.jsii.Kernel.get(this, "groups", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.homeDir = software.amazon.jsii.Kernel.get(this, "homeDir", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.userId = software.amazon.jsii.Kernel.get(this, "userId", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.groups = builder.groups;
            this.homeDir = builder.homeDir;
            this.userId = builder.userId;
        }

        @Override
        public final java.util.List<java.lang.String> getGroups() {
            return this.groups;
        }

        @Override
        public final java.lang.String getHomeDir() {
            return this.homeDir;
        }

        @Override
        public final java.lang.Number getUserId() {
            return this.userId;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getGroups() != null) {
                data.set("groups", om.valueToTree(this.getGroups()));
            }
            if (this.getHomeDir() != null) {
                data.set("homeDir", om.valueToTree(this.getHomeDir()));
            }
            if (this.getUserId() != null) {
                data.set("userId", om.valueToTree(this.getUserId()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ec2.InitUserOptions"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            InitUserOptions.Jsii$Proxy that = (InitUserOptions.Jsii$Proxy) o;

            if (this.groups != null ? !this.groups.equals(that.groups) : that.groups != null) return false;
            if (this.homeDir != null ? !this.homeDir.equals(that.homeDir) : that.homeDir != null) return false;
            return this.userId != null ? this.userId.equals(that.userId) : that.userId == null;
        }

        @Override
        public final int hashCode() {
            int result = this.groups != null ? this.groups.hashCode() : 0;
            result = 31 * result + (this.homeDir != null ? this.homeDir.hashCode() : 0);
            result = 31 * result + (this.userId != null ? this.userId.hashCode() : 0);
            return result;
        }
    }
}
