package software.amazon.awscdk.services.ecs;

/**
 * Options for deployment alarms.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.cloudwatch.*;
 * Cluster cluster;
 * TaskDefinition taskDefinition;
 * Alarm elbAlarm;
 * FargateService service = FargateService.Builder.create(this, "Service")
 *         .cluster(cluster)
 *         .taskDefinition(taskDefinition)
 *         .minHealthyPercent(100)
 *         .deploymentAlarms(DeploymentAlarmConfig.builder()
 *                 .alarmNames(List.of(elbAlarm.getAlarmName()))
 *                 .behavior(AlarmBehavior.ROLLBACK_ON_ALARM)
 *                 .build())
 *         .build();
 * // Defining a deployment alarm after the service has been created
 * String cpuAlarmName = "MyCpuMetricAlarm";
 * Alarm.Builder.create(this, "CPUAlarm")
 *         .alarmName(cpuAlarmName)
 *         .metric(service.metricCpuUtilization())
 *         .evaluationPeriods(2)
 *         .threshold(80)
 *         .build();
 * service.enableDeploymentAlarms(List.of(cpuAlarmName), DeploymentAlarmOptions.builder()
 *         .behavior(AlarmBehavior.FAIL_ON_ALARM)
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-01-25T00:20:55.005Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ecs.DeploymentAlarmOptions")
@software.amazon.jsii.Jsii.Proxy(DeploymentAlarmOptions.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface DeploymentAlarmOptions extends software.amazon.jsii.JsiiSerializable {

    /**
     * Default rollback on alarm.
     * <p>
     * Default: AlarmBehavior.ROLLBACK_ON_ALARM
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ecs.AlarmBehavior getBehavior() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link DeploymentAlarmOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link DeploymentAlarmOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<DeploymentAlarmOptions> {
        software.amazon.awscdk.services.ecs.AlarmBehavior behavior;

        /**
         * Sets the value of {@link DeploymentAlarmOptions#getBehavior}
         * @param behavior Default rollback on alarm.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder behavior(software.amazon.awscdk.services.ecs.AlarmBehavior behavior) {
            this.behavior = behavior;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link DeploymentAlarmOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public DeploymentAlarmOptions build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link DeploymentAlarmOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DeploymentAlarmOptions {
        private final software.amazon.awscdk.services.ecs.AlarmBehavior behavior;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.behavior = software.amazon.jsii.Kernel.get(this, "behavior", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.AlarmBehavior.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.behavior = builder.behavior;
        }

        @Override
        public final software.amazon.awscdk.services.ecs.AlarmBehavior getBehavior() {
            return this.behavior;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getBehavior() != null) {
                data.set("behavior", om.valueToTree(this.getBehavior()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ecs.DeploymentAlarmOptions"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            DeploymentAlarmOptions.Jsii$Proxy that = (DeploymentAlarmOptions.Jsii$Proxy) o;

            return this.behavior != null ? this.behavior.equals(that.behavior) : that.behavior == null;
        }

        @Override
        public final int hashCode() {
            int result = this.behavior != null ? this.behavior.hashCode() : 0;
            return result;
        }
    }
}
