package software.amazon.awscdk.services.ecs;

/**
 * Interface for Service Connect configuration.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Cluster cluster;
 * TaskDefinition taskDefinition;
 * FargateService customService = FargateService.Builder.create(this, "CustomizedService")
 *         .cluster(cluster)
 *         .taskDefinition(taskDefinition)
 *         .minHealthyPercent(100)
 *         .serviceConnectConfiguration(ServiceConnectProps.builder()
 *                 .logDriver(LogDrivers.awsLogs(AwsLogDriverProps.builder()
 *                         .streamPrefix("sc-traffic")
 *                         .build()))
 *                 .services(List.of(ServiceConnectService.builder()
 *                         .portMappingName("api")
 *                         .dnsName("customized-api")
 *                         .port(80)
 *                         .ingressPortOverride(20040)
 *                         .discoveryName("custom")
 *                         .build()))
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-01-25T00:20:55.093Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ecs.ServiceConnectProps")
@software.amazon.jsii.Jsii.Proxy(ServiceConnectProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface ServiceConnectProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The log driver configuration to use for the Service Connect agent logs.
     * <p>
     * Default: - none
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ecs.LogDriver getLogDriver() {
        return null;
    }

    /**
     * The cloudmap namespace to register this service into.
     * <p>
     * Default: the cloudmap namespace specified on the cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getNamespace() {
        return null;
    }

    /**
     * The list of Services, including a port mapping, terse client alias, and optional intermediate DNS name.
     * <p>
     * This property may be left blank if the current ECS service does not need to advertise any ports via Service Connect.
     * <p>
     * Default: none
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.ecs.ServiceConnectService> getServices() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link ServiceConnectProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link ServiceConnectProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<ServiceConnectProps> {
        software.amazon.awscdk.services.ecs.LogDriver logDriver;
        java.lang.String namespace;
        java.util.List<software.amazon.awscdk.services.ecs.ServiceConnectService> services;

        /**
         * Sets the value of {@link ServiceConnectProps#getLogDriver}
         * @param logDriver The log driver configuration to use for the Service Connect agent logs.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder logDriver(software.amazon.awscdk.services.ecs.LogDriver logDriver) {
            this.logDriver = logDriver;
            return this;
        }

        /**
         * Sets the value of {@link ServiceConnectProps#getNamespace}
         * @param namespace The cloudmap namespace to register this service into.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder namespace(java.lang.String namespace) {
            this.namespace = namespace;
            return this;
        }

        /**
         * Sets the value of {@link ServiceConnectProps#getServices}
         * @param services The list of Services, including a port mapping, terse client alias, and optional intermediate DNS name.
         *                 This property may be left blank if the current ECS service does not need to advertise any ports via Service Connect.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder services(java.util.List<? extends software.amazon.awscdk.services.ecs.ServiceConnectService> services) {
            this.services = (java.util.List<software.amazon.awscdk.services.ecs.ServiceConnectService>)services;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ServiceConnectProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public ServiceConnectProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link ServiceConnectProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ServiceConnectProps {
        private final software.amazon.awscdk.services.ecs.LogDriver logDriver;
        private final java.lang.String namespace;
        private final java.util.List<software.amazon.awscdk.services.ecs.ServiceConnectService> services;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.logDriver = software.amazon.jsii.Kernel.get(this, "logDriver", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.LogDriver.class));
            this.namespace = software.amazon.jsii.Kernel.get(this, "namespace", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.services = software.amazon.jsii.Kernel.get(this, "services", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.ServiceConnectService.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.logDriver = builder.logDriver;
            this.namespace = builder.namespace;
            this.services = (java.util.List<software.amazon.awscdk.services.ecs.ServiceConnectService>)builder.services;
        }

        @Override
        public final software.amazon.awscdk.services.ecs.LogDriver getLogDriver() {
            return this.logDriver;
        }

        @Override
        public final java.lang.String getNamespace() {
            return this.namespace;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.ecs.ServiceConnectService> getServices() {
            return this.services;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getLogDriver() != null) {
                data.set("logDriver", om.valueToTree(this.getLogDriver()));
            }
            if (this.getNamespace() != null) {
                data.set("namespace", om.valueToTree(this.getNamespace()));
            }
            if (this.getServices() != null) {
                data.set("services", om.valueToTree(this.getServices()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ecs.ServiceConnectProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ServiceConnectProps.Jsii$Proxy that = (ServiceConnectProps.Jsii$Proxy) o;

            if (this.logDriver != null ? !this.logDriver.equals(that.logDriver) : that.logDriver != null) return false;
            if (this.namespace != null ? !this.namespace.equals(that.namespace) : that.namespace != null) return false;
            return this.services != null ? this.services.equals(that.services) : that.services == null;
        }

        @Override
        public final int hashCode() {
            int result = this.logDriver != null ? this.logDriver.hashCode() : 0;
            result = 31 * result + (this.namespace != null ? this.namespace.hashCode() : 0);
            result = 31 * result + (this.services != null ? this.services.hashCode() : 0);
            return result;
        }
    }
}
