package software.amazon.awscdk.services.eks;

/**
 * Options for adding an AutoScalingGroup as capacity.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Cluster cluster;
 * AutoScalingGroup asg;
 * cluster.connectAutoScalingGroupCapacity(asg, AutoScalingGroupOptions.builder().build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-01-25T00:20:55.314Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_eks.AutoScalingGroupOptions")
@software.amazon.jsii.Jsii.Proxy(AutoScalingGroupOptions.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface AutoScalingGroupOptions extends software.amazon.jsii.JsiiSerializable {

    /**
     * Configures the EC2 user-data script for instances in this autoscaling group to bootstrap the node (invoke <code>/etc/eks/bootstrap.sh</code>) and associate it with the EKS cluster.
     * <p>
     * If you wish to provide a custom user data script, set this to <code>false</code> and
     * manually invoke <code>autoscalingGroup.addUserData()</code>.
     * <p>
     * Default: true
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getBootstrapEnabled() {
        return null;
    }

    /**
     * Allows options for node bootstrapping through EC2 user data.
     * <p>
     * Default: - default options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.eks.BootstrapOptions getBootstrapOptions() {
        return null;
    }

    /**
     * Allow options to specify different machine image type.
     * <p>
     * Default: MachineImageType.AMAZON_LINUX_2
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.eks.MachineImageType getMachineImageType() {
        return null;
    }

    /**
     * Will automatically update the aws-auth ConfigMap to map the IAM instance role to RBAC.
     * <p>
     * This cannot be explicitly set to <code>true</code> if the cluster has kubectl disabled.
     * <p>
     * Default: - true if the cluster has kubectl enabled (which is the default).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getMapRole() {
        return null;
    }

    /**
     * Installs the AWS spot instance interrupt handler on the cluster if it's not already added.
     * <p>
     * Only relevant if <code>spotPrice</code> is configured on the auto-scaling group.
     * <p>
     * Default: true
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getSpotInterruptHandler() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link AutoScalingGroupOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link AutoScalingGroupOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<AutoScalingGroupOptions> {
        java.lang.Boolean bootstrapEnabled;
        software.amazon.awscdk.services.eks.BootstrapOptions bootstrapOptions;
        software.amazon.awscdk.services.eks.MachineImageType machineImageType;
        java.lang.Boolean mapRole;
        java.lang.Boolean spotInterruptHandler;

        /**
         * Sets the value of {@link AutoScalingGroupOptions#getBootstrapEnabled}
         * @param bootstrapEnabled Configures the EC2 user-data script for instances in this autoscaling group to bootstrap the node (invoke <code>/etc/eks/bootstrap.sh</code>) and associate it with the EKS cluster.
         *                         If you wish to provide a custom user data script, set this to <code>false</code> and
         *                         manually invoke <code>autoscalingGroup.addUserData()</code>.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder bootstrapEnabled(java.lang.Boolean bootstrapEnabled) {
            this.bootstrapEnabled = bootstrapEnabled;
            return this;
        }

        /**
         * Sets the value of {@link AutoScalingGroupOptions#getBootstrapOptions}
         * @param bootstrapOptions Allows options for node bootstrapping through EC2 user data.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder bootstrapOptions(software.amazon.awscdk.services.eks.BootstrapOptions bootstrapOptions) {
            this.bootstrapOptions = bootstrapOptions;
            return this;
        }

        /**
         * Sets the value of {@link AutoScalingGroupOptions#getMachineImageType}
         * @param machineImageType Allow options to specify different machine image type.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder machineImageType(software.amazon.awscdk.services.eks.MachineImageType machineImageType) {
            this.machineImageType = machineImageType;
            return this;
        }

        /**
         * Sets the value of {@link AutoScalingGroupOptions#getMapRole}
         * @param mapRole Will automatically update the aws-auth ConfigMap to map the IAM instance role to RBAC.
         *                This cannot be explicitly set to <code>true</code> if the cluster has kubectl disabled.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder mapRole(java.lang.Boolean mapRole) {
            this.mapRole = mapRole;
            return this;
        }

        /**
         * Sets the value of {@link AutoScalingGroupOptions#getSpotInterruptHandler}
         * @param spotInterruptHandler Installs the AWS spot instance interrupt handler on the cluster if it's not already added.
         *                             Only relevant if <code>spotPrice</code> is configured on the auto-scaling group.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder spotInterruptHandler(java.lang.Boolean spotInterruptHandler) {
            this.spotInterruptHandler = spotInterruptHandler;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link AutoScalingGroupOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public AutoScalingGroupOptions build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link AutoScalingGroupOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AutoScalingGroupOptions {
        private final java.lang.Boolean bootstrapEnabled;
        private final software.amazon.awscdk.services.eks.BootstrapOptions bootstrapOptions;
        private final software.amazon.awscdk.services.eks.MachineImageType machineImageType;
        private final java.lang.Boolean mapRole;
        private final java.lang.Boolean spotInterruptHandler;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.bootstrapEnabled = software.amazon.jsii.Kernel.get(this, "bootstrapEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.bootstrapOptions = software.amazon.jsii.Kernel.get(this, "bootstrapOptions", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.eks.BootstrapOptions.class));
            this.machineImageType = software.amazon.jsii.Kernel.get(this, "machineImageType", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.eks.MachineImageType.class));
            this.mapRole = software.amazon.jsii.Kernel.get(this, "mapRole", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.spotInterruptHandler = software.amazon.jsii.Kernel.get(this, "spotInterruptHandler", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.bootstrapEnabled = builder.bootstrapEnabled;
            this.bootstrapOptions = builder.bootstrapOptions;
            this.machineImageType = builder.machineImageType;
            this.mapRole = builder.mapRole;
            this.spotInterruptHandler = builder.spotInterruptHandler;
        }

        @Override
        public final java.lang.Boolean getBootstrapEnabled() {
            return this.bootstrapEnabled;
        }

        @Override
        public final software.amazon.awscdk.services.eks.BootstrapOptions getBootstrapOptions() {
            return this.bootstrapOptions;
        }

        @Override
        public final software.amazon.awscdk.services.eks.MachineImageType getMachineImageType() {
            return this.machineImageType;
        }

        @Override
        public final java.lang.Boolean getMapRole() {
            return this.mapRole;
        }

        @Override
        public final java.lang.Boolean getSpotInterruptHandler() {
            return this.spotInterruptHandler;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getBootstrapEnabled() != null) {
                data.set("bootstrapEnabled", om.valueToTree(this.getBootstrapEnabled()));
            }
            if (this.getBootstrapOptions() != null) {
                data.set("bootstrapOptions", om.valueToTree(this.getBootstrapOptions()));
            }
            if (this.getMachineImageType() != null) {
                data.set("machineImageType", om.valueToTree(this.getMachineImageType()));
            }
            if (this.getMapRole() != null) {
                data.set("mapRole", om.valueToTree(this.getMapRole()));
            }
            if (this.getSpotInterruptHandler() != null) {
                data.set("spotInterruptHandler", om.valueToTree(this.getSpotInterruptHandler()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_eks.AutoScalingGroupOptions"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            AutoScalingGroupOptions.Jsii$Proxy that = (AutoScalingGroupOptions.Jsii$Proxy) o;

            if (this.bootstrapEnabled != null ? !this.bootstrapEnabled.equals(that.bootstrapEnabled) : that.bootstrapEnabled != null) return false;
            if (this.bootstrapOptions != null ? !this.bootstrapOptions.equals(that.bootstrapOptions) : that.bootstrapOptions != null) return false;
            if (this.machineImageType != null ? !this.machineImageType.equals(that.machineImageType) : that.machineImageType != null) return false;
            if (this.mapRole != null ? !this.mapRole.equals(that.mapRole) : that.mapRole != null) return false;
            return this.spotInterruptHandler != null ? this.spotInterruptHandler.equals(that.spotInterruptHandler) : that.spotInterruptHandler == null;
        }

        @Override
        public final int hashCode() {
            int result = this.bootstrapEnabled != null ? this.bootstrapEnabled.hashCode() : 0;
            result = 31 * result + (this.bootstrapOptions != null ? this.bootstrapOptions.hashCode() : 0);
            result = 31 * result + (this.machineImageType != null ? this.machineImageType.hashCode() : 0);
            result = 31 * result + (this.mapRole != null ? this.mapRole.hashCode() : 0);
            result = 31 * result + (this.spotInterruptHandler != null ? this.spotInterruptHandler.hashCode() : 0);
            return result;
        }
    }
}
