package software.amazon.awscdk.services.eks;

/**
 * EKS node bootstrapping options.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Cluster cluster;
 * cluster.addAutoScalingGroupCapacity("spot", AutoScalingGroupCapacityOptions.builder()
 *         .instanceType(new InstanceType("t3.large"))
 *         .minCapacity(2)
 *         .bootstrapOptions(BootstrapOptions.builder()
 *                 .kubeletExtraArgs("--node-labels foo=bar,goo=far")
 *                 .awsApiRetryAttempts(5)
 *                 .build())
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-01-25T00:20:55.316Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_eks.BootstrapOptions")
@software.amazon.jsii.Jsii.Proxy(BootstrapOptions.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface BootstrapOptions extends software.amazon.jsii.JsiiSerializable {

    /**
     * Additional command line arguments to pass to the <code>/etc/eks/bootstrap.sh</code> command.
     * <p>
     * Default: - none
     * <p>
     * @see <a href="https://github.com/awslabs/amazon-eks-ami/blob/master/files/bootstrap.sh">https://github.com/awslabs/amazon-eks-ami/blob/master/files/bootstrap.sh</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getAdditionalArgs() {
        return null;
    }

    /**
     * Number of retry attempts for AWS API call (DescribeCluster).
     * <p>
     * Default: 3
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getAwsApiRetryAttempts() {
        return null;
    }

    /**
     * Overrides the IP address to use for DNS queries within the cluster.
     * <p>
     * Default: - 10.100.0.10 or 172.20.0.10 based on the IP
     * address of the primary interface.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDnsClusterIp() {
        return null;
    }

    /**
     * The contents of the <code>/etc/docker/daemon.json</code> file. Useful if you want a custom config differing from the default one in the EKS AMI.
     * <p>
     * Default: - none
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDockerConfigJson() {
        return null;
    }

    /**
     * Restores the docker default bridge network.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getEnableDockerBridge() {
        return null;
    }

    /**
     * Extra arguments to add to the kubelet. Useful for adding labels or taints.
     * <p>
     * For example, <code>--node-labels foo=bar,goo=far</code>.
     * <p>
     * Default: - none
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getKubeletExtraArgs() {
        return null;
    }

    /**
     * Sets <code>--max-pods</code> for the kubelet based on the capacity of the EC2 instance.
     * <p>
     * Default: true
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getUseMaxPods() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link BootstrapOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link BootstrapOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<BootstrapOptions> {
        java.lang.String additionalArgs;
        java.lang.Number awsApiRetryAttempts;
        java.lang.String dnsClusterIp;
        java.lang.String dockerConfigJson;
        java.lang.Boolean enableDockerBridge;
        java.lang.String kubeletExtraArgs;
        java.lang.Boolean useMaxPods;

        /**
         * Sets the value of {@link BootstrapOptions#getAdditionalArgs}
         * @param additionalArgs Additional command line arguments to pass to the <code>/etc/eks/bootstrap.sh</code> command.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder additionalArgs(java.lang.String additionalArgs) {
            this.additionalArgs = additionalArgs;
            return this;
        }

        /**
         * Sets the value of {@link BootstrapOptions#getAwsApiRetryAttempts}
         * @param awsApiRetryAttempts Number of retry attempts for AWS API call (DescribeCluster).
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder awsApiRetryAttempts(java.lang.Number awsApiRetryAttempts) {
            this.awsApiRetryAttempts = awsApiRetryAttempts;
            return this;
        }

        /**
         * Sets the value of {@link BootstrapOptions#getDnsClusterIp}
         * @param dnsClusterIp Overrides the IP address to use for DNS queries within the cluster.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dnsClusterIp(java.lang.String dnsClusterIp) {
            this.dnsClusterIp = dnsClusterIp;
            return this;
        }

        /**
         * Sets the value of {@link BootstrapOptions#getDockerConfigJson}
         * @param dockerConfigJson The contents of the <code>/etc/docker/daemon.json</code> file. Useful if you want a custom config differing from the default one in the EKS AMI.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dockerConfigJson(java.lang.String dockerConfigJson) {
            this.dockerConfigJson = dockerConfigJson;
            return this;
        }

        /**
         * Sets the value of {@link BootstrapOptions#getEnableDockerBridge}
         * @param enableDockerBridge Restores the docker default bridge network.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enableDockerBridge(java.lang.Boolean enableDockerBridge) {
            this.enableDockerBridge = enableDockerBridge;
            return this;
        }

        /**
         * Sets the value of {@link BootstrapOptions#getKubeletExtraArgs}
         * @param kubeletExtraArgs Extra arguments to add to the kubelet. Useful for adding labels or taints.
         *                         For example, <code>--node-labels foo=bar,goo=far</code>.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder kubeletExtraArgs(java.lang.String kubeletExtraArgs) {
            this.kubeletExtraArgs = kubeletExtraArgs;
            return this;
        }

        /**
         * Sets the value of {@link BootstrapOptions#getUseMaxPods}
         * @param useMaxPods Sets <code>--max-pods</code> for the kubelet based on the capacity of the EC2 instance.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder useMaxPods(java.lang.Boolean useMaxPods) {
            this.useMaxPods = useMaxPods;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link BootstrapOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public BootstrapOptions build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link BootstrapOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements BootstrapOptions {
        private final java.lang.String additionalArgs;
        private final java.lang.Number awsApiRetryAttempts;
        private final java.lang.String dnsClusterIp;
        private final java.lang.String dockerConfigJson;
        private final java.lang.Boolean enableDockerBridge;
        private final java.lang.String kubeletExtraArgs;
        private final java.lang.Boolean useMaxPods;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.additionalArgs = software.amazon.jsii.Kernel.get(this, "additionalArgs", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.awsApiRetryAttempts = software.amazon.jsii.Kernel.get(this, "awsApiRetryAttempts", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.dnsClusterIp = software.amazon.jsii.Kernel.get(this, "dnsClusterIp", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.dockerConfigJson = software.amazon.jsii.Kernel.get(this, "dockerConfigJson", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.enableDockerBridge = software.amazon.jsii.Kernel.get(this, "enableDockerBridge", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.kubeletExtraArgs = software.amazon.jsii.Kernel.get(this, "kubeletExtraArgs", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.useMaxPods = software.amazon.jsii.Kernel.get(this, "useMaxPods", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.additionalArgs = builder.additionalArgs;
            this.awsApiRetryAttempts = builder.awsApiRetryAttempts;
            this.dnsClusterIp = builder.dnsClusterIp;
            this.dockerConfigJson = builder.dockerConfigJson;
            this.enableDockerBridge = builder.enableDockerBridge;
            this.kubeletExtraArgs = builder.kubeletExtraArgs;
            this.useMaxPods = builder.useMaxPods;
        }

        @Override
        public final java.lang.String getAdditionalArgs() {
            return this.additionalArgs;
        }

        @Override
        public final java.lang.Number getAwsApiRetryAttempts() {
            return this.awsApiRetryAttempts;
        }

        @Override
        public final java.lang.String getDnsClusterIp() {
            return this.dnsClusterIp;
        }

        @Override
        public final java.lang.String getDockerConfigJson() {
            return this.dockerConfigJson;
        }

        @Override
        public final java.lang.Boolean getEnableDockerBridge() {
            return this.enableDockerBridge;
        }

        @Override
        public final java.lang.String getKubeletExtraArgs() {
            return this.kubeletExtraArgs;
        }

        @Override
        public final java.lang.Boolean getUseMaxPods() {
            return this.useMaxPods;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getAdditionalArgs() != null) {
                data.set("additionalArgs", om.valueToTree(this.getAdditionalArgs()));
            }
            if (this.getAwsApiRetryAttempts() != null) {
                data.set("awsApiRetryAttempts", om.valueToTree(this.getAwsApiRetryAttempts()));
            }
            if (this.getDnsClusterIp() != null) {
                data.set("dnsClusterIp", om.valueToTree(this.getDnsClusterIp()));
            }
            if (this.getDockerConfigJson() != null) {
                data.set("dockerConfigJson", om.valueToTree(this.getDockerConfigJson()));
            }
            if (this.getEnableDockerBridge() != null) {
                data.set("enableDockerBridge", om.valueToTree(this.getEnableDockerBridge()));
            }
            if (this.getKubeletExtraArgs() != null) {
                data.set("kubeletExtraArgs", om.valueToTree(this.getKubeletExtraArgs()));
            }
            if (this.getUseMaxPods() != null) {
                data.set("useMaxPods", om.valueToTree(this.getUseMaxPods()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_eks.BootstrapOptions"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            BootstrapOptions.Jsii$Proxy that = (BootstrapOptions.Jsii$Proxy) o;

            if (this.additionalArgs != null ? !this.additionalArgs.equals(that.additionalArgs) : that.additionalArgs != null) return false;
            if (this.awsApiRetryAttempts != null ? !this.awsApiRetryAttempts.equals(that.awsApiRetryAttempts) : that.awsApiRetryAttempts != null) return false;
            if (this.dnsClusterIp != null ? !this.dnsClusterIp.equals(that.dnsClusterIp) : that.dnsClusterIp != null) return false;
            if (this.dockerConfigJson != null ? !this.dockerConfigJson.equals(that.dockerConfigJson) : that.dockerConfigJson != null) return false;
            if (this.enableDockerBridge != null ? !this.enableDockerBridge.equals(that.enableDockerBridge) : that.enableDockerBridge != null) return false;
            if (this.kubeletExtraArgs != null ? !this.kubeletExtraArgs.equals(that.kubeletExtraArgs) : that.kubeletExtraArgs != null) return false;
            return this.useMaxPods != null ? this.useMaxPods.equals(that.useMaxPods) : that.useMaxPods == null;
        }

        @Override
        public final int hashCode() {
            int result = this.additionalArgs != null ? this.additionalArgs.hashCode() : 0;
            result = 31 * result + (this.awsApiRetryAttempts != null ? this.awsApiRetryAttempts.hashCode() : 0);
            result = 31 * result + (this.dnsClusterIp != null ? this.dnsClusterIp.hashCode() : 0);
            result = 31 * result + (this.dockerConfigJson != null ? this.dockerConfigJson.hashCode() : 0);
            result = 31 * result + (this.enableDockerBridge != null ? this.enableDockerBridge.hashCode() : 0);
            result = 31 * result + (this.kubeletExtraArgs != null ? this.kubeletExtraArgs.hashCode() : 0);
            result = 31 * result + (this.useMaxPods != null ? this.useMaxPods.hashCode() : 0);
            return result;
        }
    }
}
