package software.amazon.awscdk.services.eks;

/**
 * Defines an EKS cluster that runs entirely on AWS Fargate.
 * <p>
 * The cluster is created with a default Fargate Profile that matches the
 * "default" and "kube-system" namespaces. You can add additional profiles using
 * <code>addFargateProfile</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * FargateCluster cluster = FargateCluster.Builder.create(this, "MyCluster")
 *         .version(KubernetesVersion.V1_31)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-01-25T00:20:55.390Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_eks.FargateCluster")
public class FargateCluster extends software.amazon.awscdk.services.eks.Cluster {

    protected FargateCluster(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected FargateCluster(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public FargateCluster(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.eks.FargateClusterProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Fargate Profile that was created with the cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.eks.FargateProfile getDefaultProfile() {
        return software.amazon.jsii.Kernel.get(this, "defaultProfile", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.eks.FargateProfile.class));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.eks.FargateCluster}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.eks.FargateCluster> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.eks.FargateClusterProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.eks.FargateClusterProps.Builder();
        }

        /**
         * The Kubernetes version to run in the cluster.
         * <p>
         * @return {@code this}
         * @param version The Kubernetes version to run in the cluster. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder version(final software.amazon.awscdk.services.eks.KubernetesVersion version) {
            this.props.version(version);
            return this;
        }

        /**
         * Name for the cluster.
         * <p>
         * Default: - Automatically generated name
         * <p>
         * @return {@code this}
         * @param clusterName Name for the cluster. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder clusterName(final java.lang.String clusterName) {
            this.props.clusterName(clusterName);
            return this;
        }

        /**
         * Determines whether a CloudFormation output with the name of the cluster will be synthesized.
         * <p>
         * Default: false
         * <p>
         * @return {@code this}
         * @param outputClusterName Determines whether a CloudFormation output with the name of the cluster will be synthesized. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder outputClusterName(final java.lang.Boolean outputClusterName) {
            this.props.outputClusterName(outputClusterName);
            return this;
        }

        /**
         * Determines whether a CloudFormation output with the <code>aws eks update-kubeconfig</code> command will be synthesized.
         * <p>
         * This command will include
         * the cluster name and, if applicable, the ARN of the masters IAM role.
         * <p>
         * Default: true
         * <p>
         * @return {@code this}
         * @param outputConfigCommand Determines whether a CloudFormation output with the <code>aws eks update-kubeconfig</code> command will be synthesized. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder outputConfigCommand(final java.lang.Boolean outputConfigCommand) {
            this.props.outputConfigCommand(outputConfigCommand);
            return this;
        }

        /**
         * Role that provides permissions for the Kubernetes control plane to make calls to AWS API operations on your behalf.
         * <p>
         * Default: - A role is automatically created for you
         * <p>
         * @return {@code this}
         * @param role Role that provides permissions for the Kubernetes control plane to make calls to AWS API operations on your behalf. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder role(final software.amazon.awscdk.services.iam.IRole role) {
            this.props.role(role);
            return this;
        }

        /**
         * Security Group to use for Control Plane ENIs.
         * <p>
         * Default: - A security group is automatically created
         * <p>
         * @return {@code this}
         * @param securityGroup Security Group to use for Control Plane ENIs. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder securityGroup(final software.amazon.awscdk.services.ec2.ISecurityGroup securityGroup) {
            this.props.securityGroup(securityGroup);
            return this;
        }

        /**
         * The VPC in which to create the Cluster.
         * <p>
         * Default: - a VPC with default configuration will be created and can be accessed through `cluster.vpc`.
         * <p>
         * @return {@code this}
         * @param vpc The VPC in which to create the Cluster. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpc(final software.amazon.awscdk.services.ec2.IVpc vpc) {
            this.props.vpc(vpc);
            return this;
        }

        /**
         * Where to place EKS Control Plane ENIs.
         * <p>
         * For example, to only select private subnets, supply the following:
         * <p>
         * <code>vpcSubnets: [{ subnetType: ec2.SubnetType.PRIVATE_WITH_EGRESS }]</code>
         * <p>
         * Default: - All public and private subnets
         * <p>
         * @return {@code this}
         * @param vpcSubnets Where to place EKS Control Plane ENIs. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpcSubnets(final java.util.List<? extends software.amazon.awscdk.services.ec2.SubnetSelection> vpcSubnets) {
            this.props.vpcSubnets(vpcSubnets);
            return this;
        }

        /**
         * Install the AWS Load Balancer Controller onto the cluster.
         * <p>
         * Default: - The controller is not installed.
         * <p>
         * @return {@code this}
         * @see <a href="https://kubernetes-sigs.github.io/aws-load-balancer-controller">https://kubernetes-sigs.github.io/aws-load-balancer-controller</a>
         * @param albController Install the AWS Load Balancer Controller onto the cluster. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder albController(final software.amazon.awscdk.services.eks.AlbControllerOptions albController) {
            this.props.albController(albController);
            return this;
        }

        /**
         * The desired authentication mode for the cluster.
         * <p>
         * Default: AuthenticationMode.CONFIG_MAP
         * <p>
         * @return {@code this}
         * @param authenticationMode The desired authentication mode for the cluster. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder authenticationMode(final software.amazon.awscdk.services.eks.AuthenticationMode authenticationMode) {
            this.props.authenticationMode(authenticationMode);
            return this;
        }

        /**
         * An AWS Lambda layer that contains the <code>aws</code> CLI.
         * <p>
         * The handler expects the layer to include the following executables:
         * <p>
         * <blockquote><pre>
         * /opt/awscli/aws
         * </pre></blockquote>
         * <p>
         * Default: - a default layer with the AWS CLI 1.x
         * <p>
         * @return {@code this}
         * @param awscliLayer An AWS Lambda layer that contains the <code>aws</code> CLI. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder awscliLayer(final software.amazon.awscdk.services.lambda.ILayerVersion awscliLayer) {
            this.props.awscliLayer(awscliLayer);
            return this;
        }

        /**
         * Custom environment variables when interacting with the EKS endpoint to manage the cluster lifecycle.
         * <p>
         * Default: - No environment variables.
         * <p>
         * @return {@code this}
         * @param clusterHandlerEnvironment Custom environment variables when interacting with the EKS endpoint to manage the cluster lifecycle. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder clusterHandlerEnvironment(final java.util.Map<java.lang.String, java.lang.String> clusterHandlerEnvironment) {
            this.props.clusterHandlerEnvironment(clusterHandlerEnvironment);
            return this;
        }

        /**
         * A security group to associate with the Cluster Handler's Lambdas.
         * <p>
         * The Cluster Handler's Lambdas are responsible for calling AWS's EKS API.
         * <p>
         * Requires <code>placeClusterHandlerInVpc</code> to be set to true.
         * <p>
         * Default: - No security group.
         * <p>
         * @return {@code this}
         * @param clusterHandlerSecurityGroup A security group to associate with the Cluster Handler's Lambdas. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder clusterHandlerSecurityGroup(final software.amazon.awscdk.services.ec2.ISecurityGroup clusterHandlerSecurityGroup) {
            this.props.clusterHandlerSecurityGroup(clusterHandlerSecurityGroup);
            return this;
        }

        /**
         * The cluster log types which you want to enable.
         * <p>
         * Default: - none
         * <p>
         * @return {@code this}
         * @param clusterLogging The cluster log types which you want to enable. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder clusterLogging(final java.util.List<? extends software.amazon.awscdk.services.eks.ClusterLoggingTypes> clusterLogging) {
            this.props.clusterLogging(clusterLogging);
            return this;
        }

        /**
         * Controls the "eks.amazonaws.com/compute-type" annotation in the CoreDNS configuration on your cluster to determine which compute type to use for CoreDNS.
         * <p>
         * Default: CoreDnsComputeType.EC2 (for `FargateCluster` the default is FARGATE)
         * <p>
         * @return {@code this}
         * @param coreDnsComputeType Controls the "eks.amazonaws.com/compute-type" annotation in the CoreDNS configuration on your cluster to determine which compute type to use for CoreDNS. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder coreDnsComputeType(final software.amazon.awscdk.services.eks.CoreDnsComputeType coreDnsComputeType) {
            this.props.coreDnsComputeType(coreDnsComputeType);
            return this;
        }

        /**
         * Configure access to the Kubernetes API server endpoint..
         * <p>
         * Default: EndpointAccess.PUBLIC_AND_PRIVATE
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/eks/latest/userguide/cluster-endpoint.html">https://docs.aws.amazon.com/eks/latest/userguide/cluster-endpoint.html</a>
         * @param endpointAccess Configure access to the Kubernetes API server endpoint.. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder endpointAccess(final software.amazon.awscdk.services.eks.EndpointAccess endpointAccess) {
            this.props.endpointAccess(endpointAccess);
            return this;
        }

        /**
         * Specify which IP family is used to assign Kubernetes pod and service IP addresses.
         * <p>
         * Default: - IpFamily.IP_V4
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/eks/latest/APIReference/API_KubernetesNetworkConfigRequest.html#AmazonEKS-Type-KubernetesNetworkConfigRequest-ipFamily">https://docs.aws.amazon.com/eks/latest/APIReference/API_KubernetesNetworkConfigRequest.html#AmazonEKS-Type-KubernetesNetworkConfigRequest-ipFamily</a>
         * @param ipFamily Specify which IP family is used to assign Kubernetes pod and service IP addresses. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ipFamily(final software.amazon.awscdk.services.eks.IpFamily ipFamily) {
            this.props.ipFamily(ipFamily);
            return this;
        }

        /**
         * Environment variables for the kubectl execution.
         * <p>
         * Only relevant for kubectl enabled clusters.
         * <p>
         * Default: - No environment variables.
         * <p>
         * @return {@code this}
         * @param kubectlEnvironment Environment variables for the kubectl execution. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder kubectlEnvironment(final java.util.Map<java.lang.String, java.lang.String> kubectlEnvironment) {
            this.props.kubectlEnvironment(kubectlEnvironment);
            return this;
        }

        /**
         * An AWS Lambda Layer which includes <code>kubectl</code> and Helm.
         * <p>
         * This layer is used by the kubectl handler to apply manifests and install
         * helm charts. You must pick an appropriate releases of one of the
         * <code>&#64;aws-cdk/layer-kubectl-vXX</code> packages, that works with the version of
         * Kubernetes you have chosen. If you don't supply this value <code>kubectl</code>
         * 1.20 will be used, but that version is most likely too old.
         * <p>
         * The handler expects the layer to include the following executables:
         * <p>
         * <blockquote><pre>
         * /opt/helm/helm
         * /opt/kubectl/kubectl
         * </pre></blockquote>
         * <p>
         * Default: - a default layer with Kubectl 1.20.
         * <p>
         * @return {@code this}
         * @param kubectlLayer An AWS Lambda Layer which includes <code>kubectl</code> and Helm. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder kubectlLayer(final software.amazon.awscdk.services.lambda.ILayerVersion kubectlLayer) {
            this.props.kubectlLayer(kubectlLayer);
            return this;
        }

        /**
         * Amount of memory to allocate to the provider's lambda function.
         * <p>
         * Default: Size.gibibytes(1)
         * <p>
         * @return {@code this}
         * @param kubectlMemory Amount of memory to allocate to the provider's lambda function. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder kubectlMemory(final software.amazon.awscdk.Size kubectlMemory) {
            this.props.kubectlMemory(kubectlMemory);
            return this;
        }

        /**
         * An IAM role that will be added to the <code>system:masters</code> Kubernetes RBAC group.
         * <p>
         * Default: - no masters role.
         * <p>
         * @return {@code this}
         * @see <a href="https://kubernetes.io/docs/reference/access-authn-authz/rbac/#default-roles-and-role-bindings">https://kubernetes.io/docs/reference/access-authn-authz/rbac/#default-roles-and-role-bindings</a>
         * @param mastersRole An IAM role that will be added to the <code>system:masters</code> Kubernetes RBAC group. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder mastersRole(final software.amazon.awscdk.services.iam.IRole mastersRole) {
            this.props.mastersRole(mastersRole);
            return this;
        }

        /**
         * An AWS Lambda Layer which includes the NPM dependency <code>proxy-agent</code>.
         * <p>
         * This layer
         * is used by the onEvent handler to route AWS SDK requests through a proxy.
         * <p>
         * By default, the provider will use the layer included in the
         * "aws-lambda-layer-node-proxy-agent" SAR application which is available in all
         * commercial regions.
         * <p>
         * To deploy the layer locally define it in your app as follows:
         * <p>
         * <blockquote><pre>
         * LayerVersion layer = LayerVersion.Builder.create(this, "proxy-agent-layer")
         *         .code(Code.fromAsset(String.format("%s/layer.zip", __dirname)))
         *         .compatibleRuntimes(List.of(Runtime.NODEJS_LATEST))
         *         .build();
         * </pre></blockquote>
         * <p>
         * Default: - a layer bundled with this module.
         * <p>
         * @return {@code this}
         * @param onEventLayer An AWS Lambda Layer which includes the NPM dependency <code>proxy-agent</code>. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder onEventLayer(final software.amazon.awscdk.services.lambda.ILayerVersion onEventLayer) {
            this.props.onEventLayer(onEventLayer);
            return this;
        }

        /**
         * Determines whether a CloudFormation output with the ARN of the "masters" IAM role will be synthesized (if <code>mastersRole</code> is specified).
         * <p>
         * Default: false
         * <p>
         * @return {@code this}
         * @param outputMastersRoleArn Determines whether a CloudFormation output with the ARN of the "masters" IAM role will be synthesized (if <code>mastersRole</code> is specified). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder outputMastersRoleArn(final java.lang.Boolean outputMastersRoleArn) {
            this.props.outputMastersRoleArn(outputMastersRoleArn);
            return this;
        }

        /**
         * If set to true, the cluster handler functions will be placed in the private subnets of the cluster vpc, subject to the <code>vpcSubnets</code> selection strategy.
         * <p>
         * Default: false
         * <p>
         * @return {@code this}
         * @param placeClusterHandlerInVpc If set to true, the cluster handler functions will be placed in the private subnets of the cluster vpc, subject to the <code>vpcSubnets</code> selection strategy. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder placeClusterHandlerInVpc(final java.lang.Boolean placeClusterHandlerInVpc) {
            this.props.placeClusterHandlerInVpc(placeClusterHandlerInVpc);
            return this;
        }

        /**
         * Indicates whether Kubernetes resources added through <code>addManifest()</code> can be automatically pruned.
         * <p>
         * When this is enabled (default), prune labels will be
         * allocated and injected to each resource. These labels will then be used
         * when issuing the <code>kubectl apply</code> operation with the <code>--prune</code> switch.
         * <p>
         * Default: true
         * <p>
         * @return {@code this}
         * @param prune Indicates whether Kubernetes resources added through <code>addManifest()</code> can be automatically pruned. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder prune(final java.lang.Boolean prune) {
            this.props.prune(prune);
            return this;
        }

        /**
         * KMS secret for envelope encryption for Kubernetes secrets.
         * <p>
         * Default: - By default, Kubernetes stores all secret object data within etcd and
         *   all etcd volumes used by Amazon EKS are encrypted at the disk-level
         *   using AWS-Managed encryption keys.
         * <p>
         * @return {@code this}
         * @param secretsEncryptionKey KMS secret for envelope encryption for Kubernetes secrets. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder secretsEncryptionKey(final software.amazon.awscdk.services.kms.IKey secretsEncryptionKey) {
            this.props.secretsEncryptionKey(secretsEncryptionKey);
            return this;
        }

        /**
         * The CIDR block to assign Kubernetes service IP addresses from.
         * <p>
         * Default: - Kubernetes assigns addresses from either the
         *   10.100.0.0/16 or 172.20.0.0/16 CIDR blocks
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/eks/latest/APIReference/API_KubernetesNetworkConfigRequest.html#AmazonEKS-Type-KubernetesNetworkConfigRequest-serviceIpv4Cidr">https://docs.aws.amazon.com/eks/latest/APIReference/API_KubernetesNetworkConfigRequest.html#AmazonEKS-Type-KubernetesNetworkConfigRequest-serviceIpv4Cidr</a>
         * @param serviceIpv4Cidr The CIDR block to assign Kubernetes service IP addresses from. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder serviceIpv4Cidr(final java.lang.String serviceIpv4Cidr) {
            this.props.serviceIpv4Cidr(serviceIpv4Cidr);
            return this;
        }

        /**
         * Fargate Profile to create along with the cluster.
         * <p>
         * Default: - A profile called "default" with 'default' and 'kube-system'
         *   selectors will be created if this is left undefined.
         * <p>
         * @return {@code this}
         * @param defaultProfile Fargate Profile to create along with the cluster. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder defaultProfile(final software.amazon.awscdk.services.eks.FargateProfileOptions defaultProfile) {
            this.props.defaultProfile(defaultProfile);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.eks.FargateCluster}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.eks.FargateCluster build() {
            return new software.amazon.awscdk.services.eks.FargateCluster(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
