package software.amazon.awscdk.services.elasticloadbalancingv2;

/**
 * Elastic Load Balancing provides the following security policies for Application Load Balancers.
 * <p>
 * We recommend the Recommended policy for general use. You can
 * use the ForwardSecrecy policy if you require Forward Secrecy
 * (FS).
 * <p>
 * You can use one of the TLS policies to meet compliance and security
 * standards that require disabling certain TLS protocol versions, or to
 * support legacy clients that require deprecated ciphers.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.certificatemanager.Certificate;
 * import software.amazon.awscdk.services.ec2.InstanceType;
 * import software.amazon.awscdk.services.ecs.Cluster;
 * import software.amazon.awscdk.services.ecs.ContainerImage;
 * import software.amazon.awscdk.services.elasticloadbalancingv2.ApplicationProtocol;
 * import software.amazon.awscdk.services.elasticloadbalancingv2.SslPolicy;
 * import software.amazon.awscdk.services.route53.PublicHostedZone;
 * Vpc vpc = Vpc.Builder.create(this, "Vpc").maxAzs(1).build();
 * ApplicationMultipleTargetGroupsFargateService loadBalancedFargateService = ApplicationMultipleTargetGroupsFargateService.Builder.create(this, "myService")
 *         .cluster(Cluster.Builder.create(this, "EcsCluster").vpc(vpc).build())
 *         .memoryLimitMiB(256)
 *         .taskImageOptions(ApplicationLoadBalancedTaskImageProps.builder()
 *                 .image(ContainerImage.fromRegistry("amazon/amazon-ecs-sample"))
 *                 .build())
 *         .enableExecuteCommand(true)
 *         .loadBalancers(List.of(ApplicationLoadBalancerProps.builder()
 *                 .name("lb")
 *                 .idleTimeout(Duration.seconds(400))
 *                 .domainName("api.example.com")
 *                 .domainZone(PublicHostedZone.Builder.create(this, "HostedZone").zoneName("example.com").build())
 *                 .listeners(List.of(ApplicationListenerProps.builder()
 *                         .name("listener")
 *                         .protocol(ApplicationProtocol.HTTPS)
 *                         .certificate(Certificate.fromCertificateArn(this, "Cert", "helloworld"))
 *                         .sslPolicy(SslPolicy.TLS12_EXT)
 *                         .build()))
 *                 .build(), ApplicationLoadBalancerProps.builder()
 *                 .name("lb2")
 *                 .idleTimeout(Duration.seconds(120))
 *                 .domainName("frontend.com")
 *                 .domainZone(PublicHostedZone.Builder.create(this, "HostedZone").zoneName("frontend.com").build())
 *                 .listeners(List.of(ApplicationListenerProps.builder()
 *                         .name("listener2")
 *                         .protocol(ApplicationProtocol.HTTPS)
 *                         .certificate(Certificate.fromCertificateArn(this, "Cert2", "helloworld"))
 *                         .sslPolicy(SslPolicy.TLS12_EXT)
 *                         .build()))
 *                 .build()))
 *         .targetGroups(List.of(ApplicationTargetProps.builder()
 *                 .containerPort(80)
 *                 .listener("listener")
 *                 .build(), ApplicationTargetProps.builder()
 *                 .containerPort(90)
 *                 .pathPattern("a/b/c")
 *                 .priority(10)
 *                 .listener("listener")
 *                 .build(), ApplicationTargetProps.builder()
 *                 .containerPort(443)
 *                 .listener("listener2")
 *                 .build(), ApplicationTargetProps.builder()
 *                 .containerPort(80)
 *                 .pathPattern("a/b/c")
 *                 .priority(10)
 *                 .listener("listener2")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/application/create-https-listener.html">https://docs.aws.amazon.com/elasticloadbalancing/latest/application/create-https-listener.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-01-25T00:20:55.696Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_elasticloadbalancingv2.SslPolicy")
public enum SslPolicy {
    /**
     * The recommended security policy for TLS listeners. This is the default policy for listeners created using the AWS Management Console.
     * <p>
     * This policy includes TLS 1.3, and is backwards compatible with TLS 1.2
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    RECOMMENDED_TLS,
    /**
     * The recommended policy for http listeners.
     * <p>
     * This is the default security policy for listeners created using the AWS CLI
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    RECOMMENDED,
    /**
     * TLS1.2 and 1.3.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    TLS13_RES,
    /**
     * TLS1.2 and 1.3 and no SHA ciphers.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    TLS13_EXT1,
    /**
     * TLS1.2 and 1.3 with all ciphers.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    TLS13_EXT2,
    /**
     * TLS1.0 through 1.3 with all ciphers.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    TLS13_10,
    /**
     * TLS1.1 through 1.3 with all ciphers.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    TLS13_11,
    /**
     * TLS1.3 only.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    TLS13_13,
    /**
     * TLS 1.3 only with AES 128 and 256 GCM SHA ciphers.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    FIPS_TLS13_13,
    /**
     * TLS 1.2 and 1.3 with AES and ECDHE GCM/SHA ciphers.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    FIPS_TLS13_12_RES,
    /**
     * TLS 1.2 and 1.3 with ECDHE SHA/GCM ciphers, excluding SHA1 ciphers.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    FIPS_TLS13_12,
    /**
     * TLS 1.2 and 1.3 with all ECDHE ciphers.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    FIPS_TLS13_12_EXT0,
    /**
     * TLS 1.2 and 1.3 with all AES and ECDHE ciphers excluding SHA1 ciphers.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    FIPS_TLS13_12_EXT1,
    /**
     * TLS 1.2 and 1.3 with all ciphers.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    FIPS_TLS13_12_EXT2,
    /**
     * TLS1.1 through 1.3 with all ciphers.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    FIPS_TLS13_11,
    /**
     * TLS1.0 through 1.3 with all ciphers.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    FIPS_TLS13_10,
    /**
     * Strong foward secrecy ciphers and TLV1.2 only (2020 edition). Same as FORWARD_SECRECY_TLS12_RES, but only supports GCM versions of the TLS ciphers.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    FORWARD_SECRECY_TLS12_RES_GCM,
    /**
     * Strong forward secrecy ciphers and TLS1.2 only.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    FORWARD_SECRECY_TLS12_RES,
    /**
     * Forward secrecy ciphers and TLS1.2 only.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    FORWARD_SECRECY_TLS12,
    /**
     * Forward secrecy ciphers only with TLS1.1 and 1.2.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    FORWARD_SECRECY_TLS11,
    /**
     * Forward secrecy ciphers only.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    FORWARD_SECRECY,
    /**
     * TLS1.2 only and no SHA ciphers.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    TLS12,
    /**
     * TLS1.2 only with all ciphers.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    TLS12_EXT,
    /**
     * TLS1.1 and 1.2 with all ciphers.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    TLS11,
    /**
     * Support for DES-CBC3-SHA.
     * <p>
     * Do not use this security policy unless you must support a legacy client
     * that requires the DES-CBC3-SHA cipher, which is a weak cipher.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    LEGACY,
}
