package software.amazon.awscdk.services.evidently;

/**
 * Properties for defining a <code>CfnExperiment</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.evidently.*;
 * CfnExperimentProps cfnExperimentProps = CfnExperimentProps.builder()
 *         .metricGoals(List.of(MetricGoalObjectProperty.builder()
 *                 .desiredChange("desiredChange")
 *                 .entityIdKey("entityIdKey")
 *                 .metricName("metricName")
 *                 .valueKey("valueKey")
 *                 // the properties below are optional
 *                 .eventPattern("eventPattern")
 *                 .unitLabel("unitLabel")
 *                 .build()))
 *         .name("name")
 *         .onlineAbConfig(OnlineAbConfigObjectProperty.builder()
 *                 .controlTreatmentName("controlTreatmentName")
 *                 .treatmentWeights(List.of(TreatmentToWeightProperty.builder()
 *                         .splitWeight(123)
 *                         .treatment("treatment")
 *                         .build()))
 *                 .build())
 *         .project("project")
 *         .treatments(List.of(TreatmentObjectProperty.builder()
 *                 .feature("feature")
 *                 .treatmentName("treatmentName")
 *                 .variation("variation")
 *                 // the properties below are optional
 *                 .description("description")
 *                 .build()))
 *         // the properties below are optional
 *         .description("description")
 *         .randomizationSalt("randomizationSalt")
 *         .removeSegment(false)
 *         .runningStatus(RunningStatusObjectProperty.builder()
 *                 .status("status")
 *                 // the properties below are optional
 *                 .analysisCompleteTime("analysisCompleteTime")
 *                 .desiredState("desiredState")
 *                 .reason("reason")
 *                 .build())
 *         .samplingRate(123)
 *         .segment("segment")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-evidently-experiment.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-evidently-experiment.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-01-25T00:20:56.045Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_evidently.CfnExperimentProps")
@software.amazon.jsii.Jsii.Proxy(CfnExperimentProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnExperimentProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * An array of structures that defines the metrics used for the experiment, and whether a higher or lower value for each metric is the goal.
     * <p>
     * You can use up to three metrics in an experiment.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-evidently-experiment.html#cfn-evidently-experiment-metricgoals">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-evidently-experiment.html#cfn-evidently-experiment-metricgoals</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getMetricGoals();

    /**
     * A name for the new experiment.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-evidently-experiment.html#cfn-evidently-experiment-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-evidently-experiment.html#cfn-evidently-experiment-name</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getName();

    /**
     * A structure that contains the configuration of which variation to use as the "control" version.
     * <p>
     * The "control" version is used for comparison with other variations. This structure also specifies how much experiment traffic is allocated to each variation.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-evidently-experiment.html#cfn-evidently-experiment-onlineabconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-evidently-experiment.html#cfn-evidently-experiment-onlineabconfig</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getOnlineAbConfig();

    /**
     * The name or the ARN of the project where this experiment is to be created.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-evidently-experiment.html#cfn-evidently-experiment-project">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-evidently-experiment.html#cfn-evidently-experiment-project</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getProject();

    /**
     * An array of structures that describe the configuration of each feature variation used in the experiment.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-evidently-experiment.html#cfn-evidently-experiment-treatments">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-evidently-experiment.html#cfn-evidently-experiment-treatments</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getTreatments();

    /**
     * An optional description of the experiment.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-evidently-experiment.html#cfn-evidently-experiment-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-evidently-experiment.html#cfn-evidently-experiment-description</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return null;
    }

    /**
     * When Evidently assigns a particular user session to an experiment, it must use a randomization ID to determine which variation the user session is served.
     * <p>
     * This randomization ID is a combination of the entity ID and <code>randomizationSalt</code> . If you omit <code>randomizationSalt</code> , Evidently uses the experiment name as the <code>randomizationSalt</code> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-evidently-experiment.html#cfn-evidently-experiment-randomizationsalt">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-evidently-experiment.html#cfn-evidently-experiment-randomizationsalt</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getRandomizationSalt() {
        return null;
    }

    /**
     * Set this to <code>true</code> to remove the segment that is associated with this experiment.
     * <p>
     * You can't use this parameter if the experiment is currently running.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-evidently-experiment.html#cfn-evidently-experiment-removesegment">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-evidently-experiment.html#cfn-evidently-experiment-removesegment</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getRemoveSegment() {
        return null;
    }

    /**
     * A structure that you can use to start and stop the experiment.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-evidently-experiment.html#cfn-evidently-experiment-runningstatus">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-evidently-experiment.html#cfn-evidently-experiment-runningstatus</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getRunningStatus() {
        return null;
    }

    /**
     * The portion of the available audience that you want to allocate to this experiment, in thousandths of a percent.
     * <p>
     * The available audience is the total audience minus the audience that you have allocated to overrides or current launches of this feature.
     * <p>
     * This is represented in thousandths of a percent. For example, specify 10,000 to allocate 10% of the available audience.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-evidently-experiment.html#cfn-evidently-experiment-samplingrate">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-evidently-experiment.html#cfn-evidently-experiment-samplingrate</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getSamplingRate() {
        return null;
    }

    /**
     * Specifies an audience <em>segment</em> to use in the experiment.
     * <p>
     * When a segment is used in an experiment, only user sessions that match the segment pattern are used in the experiment.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-Evidently-segments.html#CloudWatch-Evidently-segments-syntax">Segment rule pattern syntax</a> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-evidently-experiment.html#cfn-evidently-experiment-segment">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-evidently-experiment.html#cfn-evidently-experiment-segment</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getSegment() {
        return null;
    }

    /**
     * Assigns one or more tags (key-value pairs) to the experiment.
     * <p>
     * Tags can help you organize and categorize your resources. You can also use them to scope user permissions by granting a user permission to access or change only resources with certain tag values.
     * <p>
     * Tags don't have any semantic meaning to AWS and are interpreted strictly as strings of characters.
     * <p>
     * You can associate as many as 50 tags with an experiment.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging AWS resources</a> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-evidently-experiment.html#cfn-evidently-experiment-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-evidently-experiment.html#cfn-evidently-experiment-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnExperimentProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnExperimentProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnExperimentProps> {
        java.lang.Object metricGoals;
        java.lang.String name;
        java.lang.Object onlineAbConfig;
        java.lang.String project;
        java.lang.Object treatments;
        java.lang.String description;
        java.lang.String randomizationSalt;
        java.lang.Object removeSegment;
        java.lang.Object runningStatus;
        java.lang.Number samplingRate;
        java.lang.String segment;
        java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Sets the value of {@link CfnExperimentProps#getMetricGoals}
         * @param metricGoals An array of structures that defines the metrics used for the experiment, and whether a higher or lower value for each metric is the goal. This parameter is required.
         *                    You can use up to three metrics in an experiment.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder metricGoals(software.amazon.awscdk.IResolvable metricGoals) {
            this.metricGoals = metricGoals;
            return this;
        }

        /**
         * Sets the value of {@link CfnExperimentProps#getMetricGoals}
         * @param metricGoals An array of structures that defines the metrics used for the experiment, and whether a higher or lower value for each metric is the goal. This parameter is required.
         *                    You can use up to three metrics in an experiment.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder metricGoals(java.util.List<? extends java.lang.Object> metricGoals) {
            this.metricGoals = metricGoals;
            return this;
        }

        /**
         * Sets the value of {@link CfnExperimentProps#getName}
         * @param name A name for the new experiment. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of {@link CfnExperimentProps#getOnlineAbConfig}
         * @param onlineAbConfig A structure that contains the configuration of which variation to use as the "control" version. This parameter is required.
         *                       The "control" version is used for comparison with other variations. This structure also specifies how much experiment traffic is allocated to each variation.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder onlineAbConfig(software.amazon.awscdk.IResolvable onlineAbConfig) {
            this.onlineAbConfig = onlineAbConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnExperimentProps#getOnlineAbConfig}
         * @param onlineAbConfig A structure that contains the configuration of which variation to use as the "control" version. This parameter is required.
         *                       The "control" version is used for comparison with other variations. This structure also specifies how much experiment traffic is allocated to each variation.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder onlineAbConfig(software.amazon.awscdk.services.evidently.CfnExperiment.OnlineAbConfigObjectProperty onlineAbConfig) {
            this.onlineAbConfig = onlineAbConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnExperimentProps#getProject}
         * @param project The name or the ARN of the project where this experiment is to be created. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder project(java.lang.String project) {
            this.project = project;
            return this;
        }

        /**
         * Sets the value of {@link CfnExperimentProps#getTreatments}
         * @param treatments An array of structures that describe the configuration of each feature variation used in the experiment. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder treatments(software.amazon.awscdk.IResolvable treatments) {
            this.treatments = treatments;
            return this;
        }

        /**
         * Sets the value of {@link CfnExperimentProps#getTreatments}
         * @param treatments An array of structures that describe the configuration of each feature variation used in the experiment. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder treatments(java.util.List<? extends java.lang.Object> treatments) {
            this.treatments = treatments;
            return this;
        }

        /**
         * Sets the value of {@link CfnExperimentProps#getDescription}
         * @param description An optional description of the experiment.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link CfnExperimentProps#getRandomizationSalt}
         * @param randomizationSalt When Evidently assigns a particular user session to an experiment, it must use a randomization ID to determine which variation the user session is served.
         *                          This randomization ID is a combination of the entity ID and <code>randomizationSalt</code> . If you omit <code>randomizationSalt</code> , Evidently uses the experiment name as the <code>randomizationSalt</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder randomizationSalt(java.lang.String randomizationSalt) {
            this.randomizationSalt = randomizationSalt;
            return this;
        }

        /**
         * Sets the value of {@link CfnExperimentProps#getRemoveSegment}
         * @param removeSegment Set this to <code>true</code> to remove the segment that is associated with this experiment.
         *                      You can't use this parameter if the experiment is currently running.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder removeSegment(java.lang.Boolean removeSegment) {
            this.removeSegment = removeSegment;
            return this;
        }

        /**
         * Sets the value of {@link CfnExperimentProps#getRemoveSegment}
         * @param removeSegment Set this to <code>true</code> to remove the segment that is associated with this experiment.
         *                      You can't use this parameter if the experiment is currently running.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder removeSegment(software.amazon.awscdk.IResolvable removeSegment) {
            this.removeSegment = removeSegment;
            return this;
        }

        /**
         * Sets the value of {@link CfnExperimentProps#getRunningStatus}
         * @param runningStatus A structure that you can use to start and stop the experiment.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder runningStatus(software.amazon.awscdk.IResolvable runningStatus) {
            this.runningStatus = runningStatus;
            return this;
        }

        /**
         * Sets the value of {@link CfnExperimentProps#getRunningStatus}
         * @param runningStatus A structure that you can use to start and stop the experiment.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder runningStatus(software.amazon.awscdk.services.evidently.CfnExperiment.RunningStatusObjectProperty runningStatus) {
            this.runningStatus = runningStatus;
            return this;
        }

        /**
         * Sets the value of {@link CfnExperimentProps#getSamplingRate}
         * @param samplingRate The portion of the available audience that you want to allocate to this experiment, in thousandths of a percent.
         *                     The available audience is the total audience minus the audience that you have allocated to overrides or current launches of this feature.
         *                     <p>
         *                     This is represented in thousandths of a percent. For example, specify 10,000 to allocate 10% of the available audience.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder samplingRate(java.lang.Number samplingRate) {
            this.samplingRate = samplingRate;
            return this;
        }

        /**
         * Sets the value of {@link CfnExperimentProps#getSegment}
         * @param segment Specifies an audience <em>segment</em> to use in the experiment.
         *                When a segment is used in an experiment, only user sessions that match the segment pattern are used in the experiment.
         *                <p>
         *                For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-Evidently-segments.html#CloudWatch-Evidently-segments-syntax">Segment rule pattern syntax</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder segment(java.lang.String segment) {
            this.segment = segment;
            return this;
        }

        /**
         * Sets the value of {@link CfnExperimentProps#getTags}
         * @param tags Assigns one or more tags (key-value pairs) to the experiment.
         *             Tags can help you organize and categorize your resources. You can also use them to scope user permissions by granting a user permission to access or change only resources with certain tag values.
         *             <p>
         *             Tags don't have any semantic meaning to AWS and are interpreted strictly as strings of characters.
         *             <p>
         *             You can associate as many as 50 tags with an experiment.
         *             <p>
         *             For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging AWS resources</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnExperimentProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnExperimentProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnExperimentProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnExperimentProps {
        private final java.lang.Object metricGoals;
        private final java.lang.String name;
        private final java.lang.Object onlineAbConfig;
        private final java.lang.String project;
        private final java.lang.Object treatments;
        private final java.lang.String description;
        private final java.lang.String randomizationSalt;
        private final java.lang.Object removeSegment;
        private final java.lang.Object runningStatus;
        private final java.lang.Number samplingRate;
        private final java.lang.String segment;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.metricGoals = software.amazon.jsii.Kernel.get(this, "metricGoals", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.onlineAbConfig = software.amazon.jsii.Kernel.get(this, "onlineAbConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.project = software.amazon.jsii.Kernel.get(this, "project", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.treatments = software.amazon.jsii.Kernel.get(this, "treatments", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.randomizationSalt = software.amazon.jsii.Kernel.get(this, "randomizationSalt", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.removeSegment = software.amazon.jsii.Kernel.get(this, "removeSegment", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.runningStatus = software.amazon.jsii.Kernel.get(this, "runningStatus", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.samplingRate = software.amazon.jsii.Kernel.get(this, "samplingRate", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.segment = software.amazon.jsii.Kernel.get(this, "segment", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.metricGoals = java.util.Objects.requireNonNull(builder.metricGoals, "metricGoals is required");
            this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
            this.onlineAbConfig = java.util.Objects.requireNonNull(builder.onlineAbConfig, "onlineAbConfig is required");
            this.project = java.util.Objects.requireNonNull(builder.project, "project is required");
            this.treatments = java.util.Objects.requireNonNull(builder.treatments, "treatments is required");
            this.description = builder.description;
            this.randomizationSalt = builder.randomizationSalt;
            this.removeSegment = builder.removeSegment;
            this.runningStatus = builder.runningStatus;
            this.samplingRate = builder.samplingRate;
            this.segment = builder.segment;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
        }

        @Override
        public final java.lang.Object getMetricGoals() {
            return this.metricGoals;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        public final java.lang.Object getOnlineAbConfig() {
            return this.onlineAbConfig;
        }

        @Override
        public final java.lang.String getProject() {
            return this.project;
        }

        @Override
        public final java.lang.Object getTreatments() {
            return this.treatments;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public final java.lang.String getRandomizationSalt() {
            return this.randomizationSalt;
        }

        @Override
        public final java.lang.Object getRemoveSegment() {
            return this.removeSegment;
        }

        @Override
        public final java.lang.Object getRunningStatus() {
            return this.runningStatus;
        }

        @Override
        public final java.lang.Number getSamplingRate() {
            return this.samplingRate;
        }

        @Override
        public final java.lang.String getSegment() {
            return this.segment;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("metricGoals", om.valueToTree(this.getMetricGoals()));
            data.set("name", om.valueToTree(this.getName()));
            data.set("onlineAbConfig", om.valueToTree(this.getOnlineAbConfig()));
            data.set("project", om.valueToTree(this.getProject()));
            data.set("treatments", om.valueToTree(this.getTreatments()));
            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getRandomizationSalt() != null) {
                data.set("randomizationSalt", om.valueToTree(this.getRandomizationSalt()));
            }
            if (this.getRemoveSegment() != null) {
                data.set("removeSegment", om.valueToTree(this.getRemoveSegment()));
            }
            if (this.getRunningStatus() != null) {
                data.set("runningStatus", om.valueToTree(this.getRunningStatus()));
            }
            if (this.getSamplingRate() != null) {
                data.set("samplingRate", om.valueToTree(this.getSamplingRate()));
            }
            if (this.getSegment() != null) {
                data.set("segment", om.valueToTree(this.getSegment()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_evidently.CfnExperimentProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnExperimentProps.Jsii$Proxy that = (CfnExperimentProps.Jsii$Proxy) o;

            if (!metricGoals.equals(that.metricGoals)) return false;
            if (!name.equals(that.name)) return false;
            if (!onlineAbConfig.equals(that.onlineAbConfig)) return false;
            if (!project.equals(that.project)) return false;
            if (!treatments.equals(that.treatments)) return false;
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            if (this.randomizationSalt != null ? !this.randomizationSalt.equals(that.randomizationSalt) : that.randomizationSalt != null) return false;
            if (this.removeSegment != null ? !this.removeSegment.equals(that.removeSegment) : that.removeSegment != null) return false;
            if (this.runningStatus != null ? !this.runningStatus.equals(that.runningStatus) : that.runningStatus != null) return false;
            if (this.samplingRate != null ? !this.samplingRate.equals(that.samplingRate) : that.samplingRate != null) return false;
            if (this.segment != null ? !this.segment.equals(that.segment) : that.segment != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.metricGoals.hashCode();
            result = 31 * result + (this.name.hashCode());
            result = 31 * result + (this.onlineAbConfig.hashCode());
            result = 31 * result + (this.project.hashCode());
            result = 31 * result + (this.treatments.hashCode());
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            result = 31 * result + (this.randomizationSalt != null ? this.randomizationSalt.hashCode() : 0);
            result = 31 * result + (this.removeSegment != null ? this.removeSegment.hashCode() : 0);
            result = 31 * result + (this.runningStatus != null ? this.runningStatus.hashCode() : 0);
            result = 31 * result + (this.samplingRate != null ? this.samplingRate.hashCode() : 0);
            result = 31 * result + (this.segment != null ? this.segment.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
