package software.amazon.awscdk.services.glue;

/**
 * The <code>AWS::Glue::Crawler</code> resource specifies an AWS Glue crawler.
 * <p>
 * For more information, see <a href="https://docs.aws.amazon.com/glue/latest/dg/add-crawler.html">Cataloging Tables with a Crawler</a> and <a href="https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-crawler-crawling.html#aws-glue-api-crawler-crawling-Crawler">Crawler Structure</a> in the <em>AWS Glue Developer Guide</em> .
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.glue.*;
 * Object tags;
 * CfnCrawler cfnCrawler = CfnCrawler.Builder.create(this, "MyCfnCrawler")
 *         .role("role")
 *         .targets(TargetsProperty.builder()
 *                 .catalogTargets(List.of(CatalogTargetProperty.builder()
 *                         .connectionName("connectionName")
 *                         .databaseName("databaseName")
 *                         .dlqEventQueueArn("dlqEventQueueArn")
 *                         .eventQueueArn("eventQueueArn")
 *                         .tables(List.of("tables"))
 *                         .build()))
 *                 .deltaTargets(List.of(DeltaTargetProperty.builder()
 *                         .connectionName("connectionName")
 *                         .createNativeDeltaTable(false)
 *                         .deltaTables(List.of("deltaTables"))
 *                         .writeManifest(false)
 *                         .build()))
 *                 .dynamoDbTargets(List.of(DynamoDBTargetProperty.builder()
 *                         .path("path")
 *                         .build()))
 *                 .icebergTargets(List.of(IcebergTargetProperty.builder()
 *                         .connectionName("connectionName")
 *                         .exclusions(List.of("exclusions"))
 *                         .maximumTraversalDepth(123)
 *                         .paths(List.of("paths"))
 *                         .build()))
 *                 .jdbcTargets(List.of(JdbcTargetProperty.builder()
 *                         .connectionName("connectionName")
 *                         .enableAdditionalMetadata(List.of("enableAdditionalMetadata"))
 *                         .exclusions(List.of("exclusions"))
 *                         .path("path")
 *                         .build()))
 *                 .mongoDbTargets(List.of(MongoDBTargetProperty.builder()
 *                         .connectionName("connectionName")
 *                         .path("path")
 *                         .build()))
 *                 .s3Targets(List.of(S3TargetProperty.builder()
 *                         .connectionName("connectionName")
 *                         .dlqEventQueueArn("dlqEventQueueArn")
 *                         .eventQueueArn("eventQueueArn")
 *                         .exclusions(List.of("exclusions"))
 *                         .path("path")
 *                         .sampleSize(123)
 *                         .build()))
 *                 .build())
 *         // the properties below are optional
 *         .classifiers(List.of("classifiers"))
 *         .configuration("configuration")
 *         .crawlerSecurityConfiguration("crawlerSecurityConfiguration")
 *         .databaseName("databaseName")
 *         .description("description")
 *         .lakeFormationConfiguration(LakeFormationConfigurationProperty.builder()
 *                 .accountId("accountId")
 *                 .useLakeFormationCredentials(false)
 *                 .build())
 *         .name("name")
 *         .recrawlPolicy(RecrawlPolicyProperty.builder()
 *                 .recrawlBehavior("recrawlBehavior")
 *                 .build())
 *         .schedule(ScheduleProperty.builder()
 *                 .scheduleExpression("scheduleExpression")
 *                 .build())
 *         .schemaChangePolicy(SchemaChangePolicyProperty.builder()
 *                 .deleteBehavior("deleteBehavior")
 *                 .updateBehavior("updateBehavior")
 *                 .build())
 *         .tablePrefix("tablePrefix")
 *         .tags(tags)
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-crawler.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-crawler.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-01-25T00:20:56.359Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_glue.CfnCrawler")
public class CfnCrawler extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable, software.amazon.awscdk.ITaggable {

    protected CfnCrawler(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnCrawler(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.glue.CfnCrawler.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnCrawler(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.glue.CfnCrawlerProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * Tag Manager which manages the tags for this resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     * The Amazon Resource Name (ARN) of an IAM role that's used to access customer resources, such as Amazon Simple Storage Service (Amazon S3) data.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getRole() {
        return software.amazon.jsii.Kernel.get(this, "role", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The Amazon Resource Name (ARN) of an IAM role that's used to access customer resources, such as Amazon Simple Storage Service (Amazon S3) data.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRole(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "role", java.util.Objects.requireNonNull(value, "role is required"));
    }

    /**
     * A collection of targets to crawl.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getTargets() {
        return software.amazon.jsii.Kernel.get(this, "targets", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * A collection of targets to crawl.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTargets(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "targets", java.util.Objects.requireNonNull(value, "targets is required"));
    }

    /**
     * A collection of targets to crawl.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTargets(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.glue.CfnCrawler.TargetsProperty value) {
        software.amazon.jsii.Kernel.set(this, "targets", java.util.Objects.requireNonNull(value, "targets is required"));
    }

    /**
     * A list of UTF-8 strings that specify the names of custom classifiers that are associated with the crawler.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getClassifiers() {
        return java.util.Optional.ofNullable((java.util.List<java.lang.String>)(software.amazon.jsii.Kernel.get(this, "classifiers", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * A list of UTF-8 strings that specify the names of custom classifiers that are associated with the crawler.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setClassifiers(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> value) {
        software.amazon.jsii.Kernel.set(this, "classifiers", value);
    }

    /**
     * Crawler configuration information.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getConfiguration() {
        return software.amazon.jsii.Kernel.get(this, "configuration", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Crawler configuration information.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setConfiguration(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "configuration", value);
    }

    /**
     * The name of the <code>SecurityConfiguration</code> structure to be used by this crawler.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getCrawlerSecurityConfiguration() {
        return software.amazon.jsii.Kernel.get(this, "crawlerSecurityConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the <code>SecurityConfiguration</code> structure to be used by this crawler.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCrawlerSecurityConfiguration(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "crawlerSecurityConfiguration", value);
    }

    /**
     * The name of the database in which the crawler's output is stored.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDatabaseName() {
        return software.amazon.jsii.Kernel.get(this, "databaseName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the database in which the crawler's output is stored.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDatabaseName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "databaseName", value);
    }

    /**
     * A description of the crawler.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A description of the crawler.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDescription(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "description", value);
    }

    /**
     * Specifies whether the crawler should use AWS Lake Formation credentials for the crawler instead of the IAM role credentials.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getLakeFormationConfiguration() {
        return software.amazon.jsii.Kernel.get(this, "lakeFormationConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Specifies whether the crawler should use AWS Lake Formation credentials for the crawler instead of the IAM role credentials.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setLakeFormationConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "lakeFormationConfiguration", value);
    }

    /**
     * Specifies whether the crawler should use AWS Lake Formation credentials for the crawler instead of the IAM role credentials.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setLakeFormationConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.glue.CfnCrawler.LakeFormationConfigurationProperty value) {
        software.amazon.jsii.Kernel.set(this, "lakeFormationConfiguration", value);
    }

    /**
     * The name of the crawler.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getName() {
        return software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the crawler.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "name", value);
    }

    /**
     * A policy that specifies whether to crawl the entire dataset again, or to crawl only folders that were added since the last crawler run.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getRecrawlPolicy() {
        return software.amazon.jsii.Kernel.get(this, "recrawlPolicy", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * A policy that specifies whether to crawl the entire dataset again, or to crawl only folders that were added since the last crawler run.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRecrawlPolicy(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "recrawlPolicy", value);
    }

    /**
     * A policy that specifies whether to crawl the entire dataset again, or to crawl only folders that were added since the last crawler run.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRecrawlPolicy(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.glue.CfnCrawler.RecrawlPolicyProperty value) {
        software.amazon.jsii.Kernel.set(this, "recrawlPolicy", value);
    }

    /**
     * For scheduled crawlers, the schedule when the crawler runs.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getSchedule() {
        return software.amazon.jsii.Kernel.get(this, "schedule", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * For scheduled crawlers, the schedule when the crawler runs.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSchedule(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "schedule", value);
    }

    /**
     * For scheduled crawlers, the schedule when the crawler runs.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSchedule(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.glue.CfnCrawler.ScheduleProperty value) {
        software.amazon.jsii.Kernel.set(this, "schedule", value);
    }

    /**
     * The policy that specifies update and delete behaviors for the crawler.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getSchemaChangePolicy() {
        return software.amazon.jsii.Kernel.get(this, "schemaChangePolicy", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The policy that specifies update and delete behaviors for the crawler.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSchemaChangePolicy(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "schemaChangePolicy", value);
    }

    /**
     * The policy that specifies update and delete behaviors for the crawler.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSchemaChangePolicy(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.glue.CfnCrawler.SchemaChangePolicyProperty value) {
        software.amazon.jsii.Kernel.set(this, "schemaChangePolicy", value);
    }

    /**
     * The prefix added to the names of tables that are created.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getTablePrefix() {
        return software.amazon.jsii.Kernel.get(this, "tablePrefix", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The prefix added to the names of tables that are created.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTablePrefix(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "tablePrefix", value);
    }

    /**
     * The tags to use with this crawler.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getTagsRaw() {
        return software.amazon.jsii.Kernel.get(this, "tagsRaw", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The tags to use with this crawler.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTagsRaw(final @org.jetbrains.annotations.Nullable java.lang.Object value) {
        software.amazon.jsii.Kernel.set(this, "tagsRaw", value);
    }
    /**
     * Specifies an AWS Glue Data Catalog target.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.glue.*;
     * CatalogTargetProperty catalogTargetProperty = CatalogTargetProperty.builder()
     *         .connectionName("connectionName")
     *         .databaseName("databaseName")
     *         .dlqEventQueueArn("dlqEventQueueArn")
     *         .eventQueueArn("eventQueueArn")
     *         .tables(List.of("tables"))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-crawler-catalogtarget.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-crawler-catalogtarget.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_glue.CfnCrawler.CatalogTargetProperty")
    @software.amazon.jsii.Jsii.Proxy(CatalogTargetProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CatalogTargetProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the connection for an Amazon S3-backed Data Catalog table to be a target of the crawl when using a <code>Catalog</code> connection type paired with a <code>NETWORK</code> Connection type.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-crawler-catalogtarget.html#cfn-glue-crawler-catalogtarget-connectionname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-crawler-catalogtarget.html#cfn-glue-crawler-catalogtarget-connectionname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getConnectionName() {
            return null;
        }

        /**
         * The name of the database to be synchronized.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-crawler-catalogtarget.html#cfn-glue-crawler-catalogtarget-databasename">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-crawler-catalogtarget.html#cfn-glue-crawler-catalogtarget-databasename</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDatabaseName() {
            return null;
        }

        /**
         * A valid Amazon dead-letter SQS ARN.
         * <p>
         * For example, <code>arn:aws:sqs:region:account:deadLetterQueue</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-crawler-catalogtarget.html#cfn-glue-crawler-catalogtarget-dlqeventqueuearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-crawler-catalogtarget.html#cfn-glue-crawler-catalogtarget-dlqeventqueuearn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDlqEventQueueArn() {
            return null;
        }

        /**
         * A valid Amazon SQS ARN.
         * <p>
         * For example, <code>arn:aws:sqs:region:account:sqs</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-crawler-catalogtarget.html#cfn-glue-crawler-catalogtarget-eventqueuearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-crawler-catalogtarget.html#cfn-glue-crawler-catalogtarget-eventqueuearn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getEventQueueArn() {
            return null;
        }

        /**
         * A list of the tables to be synchronized.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-crawler-catalogtarget.html#cfn-glue-crawler-catalogtarget-tables">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-crawler-catalogtarget.html#cfn-glue-crawler-catalogtarget-tables</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getTables() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link CatalogTargetProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CatalogTargetProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CatalogTargetProperty> {
            java.lang.String connectionName;
            java.lang.String databaseName;
            java.lang.String dlqEventQueueArn;
            java.lang.String eventQueueArn;
            java.util.List<java.lang.String> tables;

            /**
             * Sets the value of {@link CatalogTargetProperty#getConnectionName}
             * @param connectionName The name of the connection for an Amazon S3-backed Data Catalog table to be a target of the crawl when using a <code>Catalog</code> connection type paired with a <code>NETWORK</code> Connection type.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder connectionName(java.lang.String connectionName) {
                this.connectionName = connectionName;
                return this;
            }

            /**
             * Sets the value of {@link CatalogTargetProperty#getDatabaseName}
             * @param databaseName The name of the database to be synchronized.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder databaseName(java.lang.String databaseName) {
                this.databaseName = databaseName;
                return this;
            }

            /**
             * Sets the value of {@link CatalogTargetProperty#getDlqEventQueueArn}
             * @param dlqEventQueueArn A valid Amazon dead-letter SQS ARN.
             *                         For example, <code>arn:aws:sqs:region:account:deadLetterQueue</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dlqEventQueueArn(java.lang.String dlqEventQueueArn) {
                this.dlqEventQueueArn = dlqEventQueueArn;
                return this;
            }

            /**
             * Sets the value of {@link CatalogTargetProperty#getEventQueueArn}
             * @param eventQueueArn A valid Amazon SQS ARN.
             *                      For example, <code>arn:aws:sqs:region:account:sqs</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder eventQueueArn(java.lang.String eventQueueArn) {
                this.eventQueueArn = eventQueueArn;
                return this;
            }

            /**
             * Sets the value of {@link CatalogTargetProperty#getTables}
             * @param tables A list of the tables to be synchronized.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder tables(java.util.List<java.lang.String> tables) {
                this.tables = tables;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CatalogTargetProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CatalogTargetProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CatalogTargetProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CatalogTargetProperty {
            private final java.lang.String connectionName;
            private final java.lang.String databaseName;
            private final java.lang.String dlqEventQueueArn;
            private final java.lang.String eventQueueArn;
            private final java.util.List<java.lang.String> tables;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.connectionName = software.amazon.jsii.Kernel.get(this, "connectionName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.databaseName = software.amazon.jsii.Kernel.get(this, "databaseName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.dlqEventQueueArn = software.amazon.jsii.Kernel.get(this, "dlqEventQueueArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.eventQueueArn = software.amazon.jsii.Kernel.get(this, "eventQueueArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.tables = software.amazon.jsii.Kernel.get(this, "tables", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.connectionName = builder.connectionName;
                this.databaseName = builder.databaseName;
                this.dlqEventQueueArn = builder.dlqEventQueueArn;
                this.eventQueueArn = builder.eventQueueArn;
                this.tables = builder.tables;
            }

            @Override
            public final java.lang.String getConnectionName() {
                return this.connectionName;
            }

            @Override
            public final java.lang.String getDatabaseName() {
                return this.databaseName;
            }

            @Override
            public final java.lang.String getDlqEventQueueArn() {
                return this.dlqEventQueueArn;
            }

            @Override
            public final java.lang.String getEventQueueArn() {
                return this.eventQueueArn;
            }

            @Override
            public final java.util.List<java.lang.String> getTables() {
                return this.tables;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getConnectionName() != null) {
                    data.set("connectionName", om.valueToTree(this.getConnectionName()));
                }
                if (this.getDatabaseName() != null) {
                    data.set("databaseName", om.valueToTree(this.getDatabaseName()));
                }
                if (this.getDlqEventQueueArn() != null) {
                    data.set("dlqEventQueueArn", om.valueToTree(this.getDlqEventQueueArn()));
                }
                if (this.getEventQueueArn() != null) {
                    data.set("eventQueueArn", om.valueToTree(this.getEventQueueArn()));
                }
                if (this.getTables() != null) {
                    data.set("tables", om.valueToTree(this.getTables()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_glue.CfnCrawler.CatalogTargetProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CatalogTargetProperty.Jsii$Proxy that = (CatalogTargetProperty.Jsii$Proxy) o;

                if (this.connectionName != null ? !this.connectionName.equals(that.connectionName) : that.connectionName != null) return false;
                if (this.databaseName != null ? !this.databaseName.equals(that.databaseName) : that.databaseName != null) return false;
                if (this.dlqEventQueueArn != null ? !this.dlqEventQueueArn.equals(that.dlqEventQueueArn) : that.dlqEventQueueArn != null) return false;
                if (this.eventQueueArn != null ? !this.eventQueueArn.equals(that.eventQueueArn) : that.eventQueueArn != null) return false;
                return this.tables != null ? this.tables.equals(that.tables) : that.tables == null;
            }

            @Override
            public final int hashCode() {
                int result = this.connectionName != null ? this.connectionName.hashCode() : 0;
                result = 31 * result + (this.databaseName != null ? this.databaseName.hashCode() : 0);
                result = 31 * result + (this.dlqEventQueueArn != null ? this.dlqEventQueueArn.hashCode() : 0);
                result = 31 * result + (this.eventQueueArn != null ? this.eventQueueArn.hashCode() : 0);
                result = 31 * result + (this.tables != null ? this.tables.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Specifies a Delta data store to crawl one or more Delta tables.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.glue.*;
     * DeltaTargetProperty deltaTargetProperty = DeltaTargetProperty.builder()
     *         .connectionName("connectionName")
     *         .createNativeDeltaTable(false)
     *         .deltaTables(List.of("deltaTables"))
     *         .writeManifest(false)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-crawler-deltatarget.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-crawler-deltatarget.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_glue.CfnCrawler.DeltaTargetProperty")
    @software.amazon.jsii.Jsii.Proxy(DeltaTargetProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DeltaTargetProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the connection to use to connect to the Delta table target.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-crawler-deltatarget.html#cfn-glue-crawler-deltatarget-connectionname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-crawler-deltatarget.html#cfn-glue-crawler-deltatarget-connectionname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getConnectionName() {
            return null;
        }

        /**
         * Specifies whether the crawler will create native tables, to allow integration with query engines that support querying of the Delta transaction log directly.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-crawler-deltatarget.html#cfn-glue-crawler-deltatarget-createnativedeltatable">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-crawler-deltatarget.html#cfn-glue-crawler-deltatarget-createnativedeltatable</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCreateNativeDeltaTable() {
            return null;
        }

        /**
         * A list of the Amazon S3 paths to the Delta tables.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-crawler-deltatarget.html#cfn-glue-crawler-deltatarget-deltatables">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-crawler-deltatarget.html#cfn-glue-crawler-deltatarget-deltatables</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getDeltaTables() {
            return null;
        }

        /**
         * Specifies whether to write the manifest files to the Delta table path.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-crawler-deltatarget.html#cfn-glue-crawler-deltatarget-writemanifest">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-crawler-deltatarget.html#cfn-glue-crawler-deltatarget-writemanifest</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getWriteManifest() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link DeltaTargetProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DeltaTargetProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DeltaTargetProperty> {
            java.lang.String connectionName;
            java.lang.Object createNativeDeltaTable;
            java.util.List<java.lang.String> deltaTables;
            java.lang.Object writeManifest;

            /**
             * Sets the value of {@link DeltaTargetProperty#getConnectionName}
             * @param connectionName The name of the connection to use to connect to the Delta table target.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder connectionName(java.lang.String connectionName) {
                this.connectionName = connectionName;
                return this;
            }

            /**
             * Sets the value of {@link DeltaTargetProperty#getCreateNativeDeltaTable}
             * @param createNativeDeltaTable Specifies whether the crawler will create native tables, to allow integration with query engines that support querying of the Delta transaction log directly.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder createNativeDeltaTable(java.lang.Boolean createNativeDeltaTable) {
                this.createNativeDeltaTable = createNativeDeltaTable;
                return this;
            }

            /**
             * Sets the value of {@link DeltaTargetProperty#getCreateNativeDeltaTable}
             * @param createNativeDeltaTable Specifies whether the crawler will create native tables, to allow integration with query engines that support querying of the Delta transaction log directly.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder createNativeDeltaTable(software.amazon.awscdk.IResolvable createNativeDeltaTable) {
                this.createNativeDeltaTable = createNativeDeltaTable;
                return this;
            }

            /**
             * Sets the value of {@link DeltaTargetProperty#getDeltaTables}
             * @param deltaTables A list of the Amazon S3 paths to the Delta tables.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder deltaTables(java.util.List<java.lang.String> deltaTables) {
                this.deltaTables = deltaTables;
                return this;
            }

            /**
             * Sets the value of {@link DeltaTargetProperty#getWriteManifest}
             * @param writeManifest Specifies whether to write the manifest files to the Delta table path.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder writeManifest(java.lang.Boolean writeManifest) {
                this.writeManifest = writeManifest;
                return this;
            }

            /**
             * Sets the value of {@link DeltaTargetProperty#getWriteManifest}
             * @param writeManifest Specifies whether to write the manifest files to the Delta table path.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder writeManifest(software.amazon.awscdk.IResolvable writeManifest) {
                this.writeManifest = writeManifest;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DeltaTargetProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DeltaTargetProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DeltaTargetProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DeltaTargetProperty {
            private final java.lang.String connectionName;
            private final java.lang.Object createNativeDeltaTable;
            private final java.util.List<java.lang.String> deltaTables;
            private final java.lang.Object writeManifest;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.connectionName = software.amazon.jsii.Kernel.get(this, "connectionName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.createNativeDeltaTable = software.amazon.jsii.Kernel.get(this, "createNativeDeltaTable", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.deltaTables = software.amazon.jsii.Kernel.get(this, "deltaTables", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.writeManifest = software.amazon.jsii.Kernel.get(this, "writeManifest", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.connectionName = builder.connectionName;
                this.createNativeDeltaTable = builder.createNativeDeltaTable;
                this.deltaTables = builder.deltaTables;
                this.writeManifest = builder.writeManifest;
            }

            @Override
            public final java.lang.String getConnectionName() {
                return this.connectionName;
            }

            @Override
            public final java.lang.Object getCreateNativeDeltaTable() {
                return this.createNativeDeltaTable;
            }

            @Override
            public final java.util.List<java.lang.String> getDeltaTables() {
                return this.deltaTables;
            }

            @Override
            public final java.lang.Object getWriteManifest() {
                return this.writeManifest;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getConnectionName() != null) {
                    data.set("connectionName", om.valueToTree(this.getConnectionName()));
                }
                if (this.getCreateNativeDeltaTable() != null) {
                    data.set("createNativeDeltaTable", om.valueToTree(this.getCreateNativeDeltaTable()));
                }
                if (this.getDeltaTables() != null) {
                    data.set("deltaTables", om.valueToTree(this.getDeltaTables()));
                }
                if (this.getWriteManifest() != null) {
                    data.set("writeManifest", om.valueToTree(this.getWriteManifest()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_glue.CfnCrawler.DeltaTargetProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DeltaTargetProperty.Jsii$Proxy that = (DeltaTargetProperty.Jsii$Proxy) o;

                if (this.connectionName != null ? !this.connectionName.equals(that.connectionName) : that.connectionName != null) return false;
                if (this.createNativeDeltaTable != null ? !this.createNativeDeltaTable.equals(that.createNativeDeltaTable) : that.createNativeDeltaTable != null) return false;
                if (this.deltaTables != null ? !this.deltaTables.equals(that.deltaTables) : that.deltaTables != null) return false;
                return this.writeManifest != null ? this.writeManifest.equals(that.writeManifest) : that.writeManifest == null;
            }

            @Override
            public final int hashCode() {
                int result = this.connectionName != null ? this.connectionName.hashCode() : 0;
                result = 31 * result + (this.createNativeDeltaTable != null ? this.createNativeDeltaTable.hashCode() : 0);
                result = 31 * result + (this.deltaTables != null ? this.deltaTables.hashCode() : 0);
                result = 31 * result + (this.writeManifest != null ? this.writeManifest.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Specifies an Amazon DynamoDB table to crawl.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.glue.*;
     * DynamoDBTargetProperty dynamoDBTargetProperty = DynamoDBTargetProperty.builder()
     *         .path("path")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-crawler-dynamodbtarget.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-crawler-dynamodbtarget.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_glue.CfnCrawler.DynamoDBTargetProperty")
    @software.amazon.jsii.Jsii.Proxy(DynamoDBTargetProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DynamoDBTargetProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the DynamoDB table to crawl.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-crawler-dynamodbtarget.html#cfn-glue-crawler-dynamodbtarget-path">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-crawler-dynamodbtarget.html#cfn-glue-crawler-dynamodbtarget-path</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getPath() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link DynamoDBTargetProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DynamoDBTargetProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DynamoDBTargetProperty> {
            java.lang.String path;

            /**
             * Sets the value of {@link DynamoDBTargetProperty#getPath}
             * @param path The name of the DynamoDB table to crawl.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder path(java.lang.String path) {
                this.path = path;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DynamoDBTargetProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DynamoDBTargetProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DynamoDBTargetProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DynamoDBTargetProperty {
            private final java.lang.String path;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.path = software.amazon.jsii.Kernel.get(this, "path", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.path = builder.path;
            }

            @Override
            public final java.lang.String getPath() {
                return this.path;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getPath() != null) {
                    data.set("path", om.valueToTree(this.getPath()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_glue.CfnCrawler.DynamoDBTargetProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DynamoDBTargetProperty.Jsii$Proxy that = (DynamoDBTargetProperty.Jsii$Proxy) o;

                return this.path != null ? this.path.equals(that.path) : that.path == null;
            }

            @Override
            public final int hashCode() {
                int result = this.path != null ? this.path.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * Specifies Apache Iceberg data store targets.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.glue.*;
     * IcebergTargetProperty icebergTargetProperty = IcebergTargetProperty.builder()
     *         .connectionName("connectionName")
     *         .exclusions(List.of("exclusions"))
     *         .maximumTraversalDepth(123)
     *         .paths(List.of("paths"))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-crawler-icebergtarget.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-crawler-icebergtarget.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_glue.CfnCrawler.IcebergTargetProperty")
    @software.amazon.jsii.Jsii.Proxy(IcebergTargetProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface IcebergTargetProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the connection to use to connect to the Iceberg target.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-crawler-icebergtarget.html#cfn-glue-crawler-icebergtarget-connectionname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-crawler-icebergtarget.html#cfn-glue-crawler-icebergtarget-connectionname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getConnectionName() {
            return null;
        }

        /**
         * A list of global patterns used to exclude from the crawl.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-crawler-icebergtarget.html#cfn-glue-crawler-icebergtarget-exclusions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-crawler-icebergtarget.html#cfn-glue-crawler-icebergtarget-exclusions</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getExclusions() {
            return null;
        }

        /**
         * The maximum depth of Amazon S3 paths that the crawler can traverse to discover the Iceberg metadata folder in your Amazon S3 path.
         * <p>
         * Used to limit the crawler run time.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-crawler-icebergtarget.html#cfn-glue-crawler-icebergtarget-maximumtraversaldepth">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-crawler-icebergtarget.html#cfn-glue-crawler-icebergtarget-maximumtraversaldepth</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMaximumTraversalDepth() {
            return null;
        }

        /**
         * One or more Amazon S3 paths that contains Iceberg metadata folders as s3://bucket/prefix .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-crawler-icebergtarget.html#cfn-glue-crawler-icebergtarget-paths">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-crawler-icebergtarget.html#cfn-glue-crawler-icebergtarget-paths</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getPaths() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link IcebergTargetProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link IcebergTargetProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<IcebergTargetProperty> {
            java.lang.String connectionName;
            java.util.List<java.lang.String> exclusions;
            java.lang.Number maximumTraversalDepth;
            java.util.List<java.lang.String> paths;

            /**
             * Sets the value of {@link IcebergTargetProperty#getConnectionName}
             * @param connectionName The name of the connection to use to connect to the Iceberg target.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder connectionName(java.lang.String connectionName) {
                this.connectionName = connectionName;
                return this;
            }

            /**
             * Sets the value of {@link IcebergTargetProperty#getExclusions}
             * @param exclusions A list of global patterns used to exclude from the crawl.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder exclusions(java.util.List<java.lang.String> exclusions) {
                this.exclusions = exclusions;
                return this;
            }

            /**
             * Sets the value of {@link IcebergTargetProperty#getMaximumTraversalDepth}
             * @param maximumTraversalDepth The maximum depth of Amazon S3 paths that the crawler can traverse to discover the Iceberg metadata folder in your Amazon S3 path.
             *                              Used to limit the crawler run time.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder maximumTraversalDepth(java.lang.Number maximumTraversalDepth) {
                this.maximumTraversalDepth = maximumTraversalDepth;
                return this;
            }

            /**
             * Sets the value of {@link IcebergTargetProperty#getPaths}
             * @param paths One or more Amazon S3 paths that contains Iceberg metadata folders as s3://bucket/prefix .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder paths(java.util.List<java.lang.String> paths) {
                this.paths = paths;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link IcebergTargetProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public IcebergTargetProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link IcebergTargetProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements IcebergTargetProperty {
            private final java.lang.String connectionName;
            private final java.util.List<java.lang.String> exclusions;
            private final java.lang.Number maximumTraversalDepth;
            private final java.util.List<java.lang.String> paths;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.connectionName = software.amazon.jsii.Kernel.get(this, "connectionName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.exclusions = software.amazon.jsii.Kernel.get(this, "exclusions", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.maximumTraversalDepth = software.amazon.jsii.Kernel.get(this, "maximumTraversalDepth", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.paths = software.amazon.jsii.Kernel.get(this, "paths", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.connectionName = builder.connectionName;
                this.exclusions = builder.exclusions;
                this.maximumTraversalDepth = builder.maximumTraversalDepth;
                this.paths = builder.paths;
            }

            @Override
            public final java.lang.String getConnectionName() {
                return this.connectionName;
            }

            @Override
            public final java.util.List<java.lang.String> getExclusions() {
                return this.exclusions;
            }

            @Override
            public final java.lang.Number getMaximumTraversalDepth() {
                return this.maximumTraversalDepth;
            }

            @Override
            public final java.util.List<java.lang.String> getPaths() {
                return this.paths;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getConnectionName() != null) {
                    data.set("connectionName", om.valueToTree(this.getConnectionName()));
                }
                if (this.getExclusions() != null) {
                    data.set("exclusions", om.valueToTree(this.getExclusions()));
                }
                if (this.getMaximumTraversalDepth() != null) {
                    data.set("maximumTraversalDepth", om.valueToTree(this.getMaximumTraversalDepth()));
                }
                if (this.getPaths() != null) {
                    data.set("paths", om.valueToTree(this.getPaths()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_glue.CfnCrawler.IcebergTargetProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                IcebergTargetProperty.Jsii$Proxy that = (IcebergTargetProperty.Jsii$Proxy) o;

                if (this.connectionName != null ? !this.connectionName.equals(that.connectionName) : that.connectionName != null) return false;
                if (this.exclusions != null ? !this.exclusions.equals(that.exclusions) : that.exclusions != null) return false;
                if (this.maximumTraversalDepth != null ? !this.maximumTraversalDepth.equals(that.maximumTraversalDepth) : that.maximumTraversalDepth != null) return false;
                return this.paths != null ? this.paths.equals(that.paths) : that.paths == null;
            }

            @Override
            public final int hashCode() {
                int result = this.connectionName != null ? this.connectionName.hashCode() : 0;
                result = 31 * result + (this.exclusions != null ? this.exclusions.hashCode() : 0);
                result = 31 * result + (this.maximumTraversalDepth != null ? this.maximumTraversalDepth.hashCode() : 0);
                result = 31 * result + (this.paths != null ? this.paths.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Specifies a JDBC data store to crawl.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.glue.*;
     * JdbcTargetProperty jdbcTargetProperty = JdbcTargetProperty.builder()
     *         .connectionName("connectionName")
     *         .enableAdditionalMetadata(List.of("enableAdditionalMetadata"))
     *         .exclusions(List.of("exclusions"))
     *         .path("path")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-crawler-jdbctarget.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-crawler-jdbctarget.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_glue.CfnCrawler.JdbcTargetProperty")
    @software.amazon.jsii.Jsii.Proxy(JdbcTargetProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface JdbcTargetProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the connection to use to connect to the JDBC target.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-crawler-jdbctarget.html#cfn-glue-crawler-jdbctarget-connectionname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-crawler-jdbctarget.html#cfn-glue-crawler-jdbctarget-connectionname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getConnectionName() {
            return null;
        }

        /**
         * Specify a value of <code>RAWTYPES</code> or <code>COMMENTS</code> to enable additional metadata in table responses.
         * <p>
         * <code>RAWTYPES</code> provides the native-level datatype. <code>COMMENTS</code> provides comments associated with a column or table in the database.
         * <p>
         * If you do not need additional metadata, keep the field empty.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-crawler-jdbctarget.html#cfn-glue-crawler-jdbctarget-enableadditionalmetadata">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-crawler-jdbctarget.html#cfn-glue-crawler-jdbctarget-enableadditionalmetadata</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getEnableAdditionalMetadata() {
            return null;
        }

        /**
         * A list of glob patterns used to exclude from the crawl.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/glue/latest/dg/add-crawler.html">Catalog Tables with a Crawler</a> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-crawler-jdbctarget.html#cfn-glue-crawler-jdbctarget-exclusions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-crawler-jdbctarget.html#cfn-glue-crawler-jdbctarget-exclusions</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getExclusions() {
            return null;
        }

        /**
         * The path of the JDBC target.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-crawler-jdbctarget.html#cfn-glue-crawler-jdbctarget-path">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-crawler-jdbctarget.html#cfn-glue-crawler-jdbctarget-path</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getPath() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link JdbcTargetProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link JdbcTargetProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<JdbcTargetProperty> {
            java.lang.String connectionName;
            java.util.List<java.lang.String> enableAdditionalMetadata;
            java.util.List<java.lang.String> exclusions;
            java.lang.String path;

            /**
             * Sets the value of {@link JdbcTargetProperty#getConnectionName}
             * @param connectionName The name of the connection to use to connect to the JDBC target.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder connectionName(java.lang.String connectionName) {
                this.connectionName = connectionName;
                return this;
            }

            /**
             * Sets the value of {@link JdbcTargetProperty#getEnableAdditionalMetadata}
             * @param enableAdditionalMetadata Specify a value of <code>RAWTYPES</code> or <code>COMMENTS</code> to enable additional metadata in table responses.
             *                                 <code>RAWTYPES</code> provides the native-level datatype. <code>COMMENTS</code> provides comments associated with a column or table in the database.
             *                                 <p>
             *                                 If you do not need additional metadata, keep the field empty.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enableAdditionalMetadata(java.util.List<java.lang.String> enableAdditionalMetadata) {
                this.enableAdditionalMetadata = enableAdditionalMetadata;
                return this;
            }

            /**
             * Sets the value of {@link JdbcTargetProperty#getExclusions}
             * @param exclusions A list of glob patterns used to exclude from the crawl.
             *                   For more information, see <a href="https://docs.aws.amazon.com/glue/latest/dg/add-crawler.html">Catalog Tables with a Crawler</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder exclusions(java.util.List<java.lang.String> exclusions) {
                this.exclusions = exclusions;
                return this;
            }

            /**
             * Sets the value of {@link JdbcTargetProperty#getPath}
             * @param path The path of the JDBC target.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder path(java.lang.String path) {
                this.path = path;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link JdbcTargetProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public JdbcTargetProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link JdbcTargetProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements JdbcTargetProperty {
            private final java.lang.String connectionName;
            private final java.util.List<java.lang.String> enableAdditionalMetadata;
            private final java.util.List<java.lang.String> exclusions;
            private final java.lang.String path;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.connectionName = software.amazon.jsii.Kernel.get(this, "connectionName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.enableAdditionalMetadata = software.amazon.jsii.Kernel.get(this, "enableAdditionalMetadata", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.exclusions = software.amazon.jsii.Kernel.get(this, "exclusions", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.path = software.amazon.jsii.Kernel.get(this, "path", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.connectionName = builder.connectionName;
                this.enableAdditionalMetadata = builder.enableAdditionalMetadata;
                this.exclusions = builder.exclusions;
                this.path = builder.path;
            }

            @Override
            public final java.lang.String getConnectionName() {
                return this.connectionName;
            }

            @Override
            public final java.util.List<java.lang.String> getEnableAdditionalMetadata() {
                return this.enableAdditionalMetadata;
            }

            @Override
            public final java.util.List<java.lang.String> getExclusions() {
                return this.exclusions;
            }

            @Override
            public final java.lang.String getPath() {
                return this.path;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getConnectionName() != null) {
                    data.set("connectionName", om.valueToTree(this.getConnectionName()));
                }
                if (this.getEnableAdditionalMetadata() != null) {
                    data.set("enableAdditionalMetadata", om.valueToTree(this.getEnableAdditionalMetadata()));
                }
                if (this.getExclusions() != null) {
                    data.set("exclusions", om.valueToTree(this.getExclusions()));
                }
                if (this.getPath() != null) {
                    data.set("path", om.valueToTree(this.getPath()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_glue.CfnCrawler.JdbcTargetProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                JdbcTargetProperty.Jsii$Proxy that = (JdbcTargetProperty.Jsii$Proxy) o;

                if (this.connectionName != null ? !this.connectionName.equals(that.connectionName) : that.connectionName != null) return false;
                if (this.enableAdditionalMetadata != null ? !this.enableAdditionalMetadata.equals(that.enableAdditionalMetadata) : that.enableAdditionalMetadata != null) return false;
                if (this.exclusions != null ? !this.exclusions.equals(that.exclusions) : that.exclusions != null) return false;
                return this.path != null ? this.path.equals(that.path) : that.path == null;
            }

            @Override
            public final int hashCode() {
                int result = this.connectionName != null ? this.connectionName.hashCode() : 0;
                result = 31 * result + (this.enableAdditionalMetadata != null ? this.enableAdditionalMetadata.hashCode() : 0);
                result = 31 * result + (this.exclusions != null ? this.exclusions.hashCode() : 0);
                result = 31 * result + (this.path != null ? this.path.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Specifies AWS Lake Formation configuration settings for the crawler.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.glue.*;
     * LakeFormationConfigurationProperty lakeFormationConfigurationProperty = LakeFormationConfigurationProperty.builder()
     *         .accountId("accountId")
     *         .useLakeFormationCredentials(false)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-crawler-lakeformationconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-crawler-lakeformationconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_glue.CfnCrawler.LakeFormationConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(LakeFormationConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface LakeFormationConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Required for cross account crawls.
         * <p>
         * For same account crawls as the target data, this can be left as null.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-crawler-lakeformationconfiguration.html#cfn-glue-crawler-lakeformationconfiguration-accountid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-crawler-lakeformationconfiguration.html#cfn-glue-crawler-lakeformationconfiguration-accountid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAccountId() {
            return null;
        }

        /**
         * Specifies whether to use AWS Lake Formation credentials for the crawler instead of the IAM role credentials.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-crawler-lakeformationconfiguration.html#cfn-glue-crawler-lakeformationconfiguration-uselakeformationcredentials">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-crawler-lakeformationconfiguration.html#cfn-glue-crawler-lakeformationconfiguration-uselakeformationcredentials</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getUseLakeFormationCredentials() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link LakeFormationConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link LakeFormationConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<LakeFormationConfigurationProperty> {
            java.lang.String accountId;
            java.lang.Object useLakeFormationCredentials;

            /**
             * Sets the value of {@link LakeFormationConfigurationProperty#getAccountId}
             * @param accountId Required for cross account crawls.
             *                  For same account crawls as the target data, this can be left as null.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder accountId(java.lang.String accountId) {
                this.accountId = accountId;
                return this;
            }

            /**
             * Sets the value of {@link LakeFormationConfigurationProperty#getUseLakeFormationCredentials}
             * @param useLakeFormationCredentials Specifies whether to use AWS Lake Formation credentials for the crawler instead of the IAM role credentials.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder useLakeFormationCredentials(java.lang.Boolean useLakeFormationCredentials) {
                this.useLakeFormationCredentials = useLakeFormationCredentials;
                return this;
            }

            /**
             * Sets the value of {@link LakeFormationConfigurationProperty#getUseLakeFormationCredentials}
             * @param useLakeFormationCredentials Specifies whether to use AWS Lake Formation credentials for the crawler instead of the IAM role credentials.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder useLakeFormationCredentials(software.amazon.awscdk.IResolvable useLakeFormationCredentials) {
                this.useLakeFormationCredentials = useLakeFormationCredentials;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link LakeFormationConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public LakeFormationConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link LakeFormationConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements LakeFormationConfigurationProperty {
            private final java.lang.String accountId;
            private final java.lang.Object useLakeFormationCredentials;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.accountId = software.amazon.jsii.Kernel.get(this, "accountId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.useLakeFormationCredentials = software.amazon.jsii.Kernel.get(this, "useLakeFormationCredentials", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.accountId = builder.accountId;
                this.useLakeFormationCredentials = builder.useLakeFormationCredentials;
            }

            @Override
            public final java.lang.String getAccountId() {
                return this.accountId;
            }

            @Override
            public final java.lang.Object getUseLakeFormationCredentials() {
                return this.useLakeFormationCredentials;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAccountId() != null) {
                    data.set("accountId", om.valueToTree(this.getAccountId()));
                }
                if (this.getUseLakeFormationCredentials() != null) {
                    data.set("useLakeFormationCredentials", om.valueToTree(this.getUseLakeFormationCredentials()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_glue.CfnCrawler.LakeFormationConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                LakeFormationConfigurationProperty.Jsii$Proxy that = (LakeFormationConfigurationProperty.Jsii$Proxy) o;

                if (this.accountId != null ? !this.accountId.equals(that.accountId) : that.accountId != null) return false;
                return this.useLakeFormationCredentials != null ? this.useLakeFormationCredentials.equals(that.useLakeFormationCredentials) : that.useLakeFormationCredentials == null;
            }

            @Override
            public final int hashCode() {
                int result = this.accountId != null ? this.accountId.hashCode() : 0;
                result = 31 * result + (this.useLakeFormationCredentials != null ? this.useLakeFormationCredentials.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Specifies an Amazon DocumentDB or MongoDB data store to crawl.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.glue.*;
     * MongoDBTargetProperty mongoDBTargetProperty = MongoDBTargetProperty.builder()
     *         .connectionName("connectionName")
     *         .path("path")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-crawler-mongodbtarget.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-crawler-mongodbtarget.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_glue.CfnCrawler.MongoDBTargetProperty")
    @software.amazon.jsii.Jsii.Proxy(MongoDBTargetProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface MongoDBTargetProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the connection to use to connect to the Amazon DocumentDB or MongoDB target.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-crawler-mongodbtarget.html#cfn-glue-crawler-mongodbtarget-connectionname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-crawler-mongodbtarget.html#cfn-glue-crawler-mongodbtarget-connectionname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getConnectionName() {
            return null;
        }

        /**
         * The path of the Amazon DocumentDB or MongoDB target (database/collection).
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-crawler-mongodbtarget.html#cfn-glue-crawler-mongodbtarget-path">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-crawler-mongodbtarget.html#cfn-glue-crawler-mongodbtarget-path</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getPath() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link MongoDBTargetProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link MongoDBTargetProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<MongoDBTargetProperty> {
            java.lang.String connectionName;
            java.lang.String path;

            /**
             * Sets the value of {@link MongoDBTargetProperty#getConnectionName}
             * @param connectionName The name of the connection to use to connect to the Amazon DocumentDB or MongoDB target.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder connectionName(java.lang.String connectionName) {
                this.connectionName = connectionName;
                return this;
            }

            /**
             * Sets the value of {@link MongoDBTargetProperty#getPath}
             * @param path The path of the Amazon DocumentDB or MongoDB target (database/collection).
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder path(java.lang.String path) {
                this.path = path;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link MongoDBTargetProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public MongoDBTargetProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link MongoDBTargetProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MongoDBTargetProperty {
            private final java.lang.String connectionName;
            private final java.lang.String path;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.connectionName = software.amazon.jsii.Kernel.get(this, "connectionName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.path = software.amazon.jsii.Kernel.get(this, "path", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.connectionName = builder.connectionName;
                this.path = builder.path;
            }

            @Override
            public final java.lang.String getConnectionName() {
                return this.connectionName;
            }

            @Override
            public final java.lang.String getPath() {
                return this.path;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getConnectionName() != null) {
                    data.set("connectionName", om.valueToTree(this.getConnectionName()));
                }
                if (this.getPath() != null) {
                    data.set("path", om.valueToTree(this.getPath()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_glue.CfnCrawler.MongoDBTargetProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                MongoDBTargetProperty.Jsii$Proxy that = (MongoDBTargetProperty.Jsii$Proxy) o;

                if (this.connectionName != null ? !this.connectionName.equals(that.connectionName) : that.connectionName != null) return false;
                return this.path != null ? this.path.equals(that.path) : that.path == null;
            }

            @Override
            public final int hashCode() {
                int result = this.connectionName != null ? this.connectionName.hashCode() : 0;
                result = 31 * result + (this.path != null ? this.path.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * When crawling an Amazon S3 data source after the first crawl is complete, specifies whether to crawl the entire dataset again or to crawl only folders that were added since the last crawler run.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/glue/latest/dg/incremental-crawls.html">Incremental Crawls in AWS Glue</a> in the developer guide.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.glue.*;
     * RecrawlPolicyProperty recrawlPolicyProperty = RecrawlPolicyProperty.builder()
     *         .recrawlBehavior("recrawlBehavior")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-crawler-recrawlpolicy.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-crawler-recrawlpolicy.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_glue.CfnCrawler.RecrawlPolicyProperty")
    @software.amazon.jsii.Jsii.Proxy(RecrawlPolicyProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface RecrawlPolicyProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Specifies whether to crawl the entire dataset again or to crawl only folders that were added since the last crawler run.
         * <p>
         * A value of <code>CRAWL_EVERYTHING</code> specifies crawling the entire dataset again.
         * <p>
         * A value of <code>CRAWL_NEW_FOLDERS_ONLY</code> specifies crawling only folders that were added since the last crawler run.
         * <p>
         * A value of <code>CRAWL_EVENT_MODE</code> specifies crawling only the changes identified by Amazon S3 events.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-crawler-recrawlpolicy.html#cfn-glue-crawler-recrawlpolicy-recrawlbehavior">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-crawler-recrawlpolicy.html#cfn-glue-crawler-recrawlpolicy-recrawlbehavior</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getRecrawlBehavior() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link RecrawlPolicyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link RecrawlPolicyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<RecrawlPolicyProperty> {
            java.lang.String recrawlBehavior;

            /**
             * Sets the value of {@link RecrawlPolicyProperty#getRecrawlBehavior}
             * @param recrawlBehavior Specifies whether to crawl the entire dataset again or to crawl only folders that were added since the last crawler run.
             *                        A value of <code>CRAWL_EVERYTHING</code> specifies crawling the entire dataset again.
             *                        <p>
             *                        A value of <code>CRAWL_NEW_FOLDERS_ONLY</code> specifies crawling only folders that were added since the last crawler run.
             *                        <p>
             *                        A value of <code>CRAWL_EVENT_MODE</code> specifies crawling only the changes identified by Amazon S3 events.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder recrawlBehavior(java.lang.String recrawlBehavior) {
                this.recrawlBehavior = recrawlBehavior;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RecrawlPolicyProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public RecrawlPolicyProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link RecrawlPolicyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RecrawlPolicyProperty {
            private final java.lang.String recrawlBehavior;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.recrawlBehavior = software.amazon.jsii.Kernel.get(this, "recrawlBehavior", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.recrawlBehavior = builder.recrawlBehavior;
            }

            @Override
            public final java.lang.String getRecrawlBehavior() {
                return this.recrawlBehavior;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getRecrawlBehavior() != null) {
                    data.set("recrawlBehavior", om.valueToTree(this.getRecrawlBehavior()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_glue.CfnCrawler.RecrawlPolicyProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                RecrawlPolicyProperty.Jsii$Proxy that = (RecrawlPolicyProperty.Jsii$Proxy) o;

                return this.recrawlBehavior != null ? this.recrawlBehavior.equals(that.recrawlBehavior) : that.recrawlBehavior == null;
            }

            @Override
            public final int hashCode() {
                int result = this.recrawlBehavior != null ? this.recrawlBehavior.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * Specifies a data store in Amazon Simple Storage Service (Amazon S3).
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.glue.*;
     * S3TargetProperty s3TargetProperty = S3TargetProperty.builder()
     *         .connectionName("connectionName")
     *         .dlqEventQueueArn("dlqEventQueueArn")
     *         .eventQueueArn("eventQueueArn")
     *         .exclusions(List.of("exclusions"))
     *         .path("path")
     *         .sampleSize(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-crawler-s3target.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-crawler-s3target.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_glue.CfnCrawler.S3TargetProperty")
    @software.amazon.jsii.Jsii.Proxy(S3TargetProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface S3TargetProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of a connection which allows a job or crawler to access data in Amazon S3 within an Amazon Virtual Private Cloud environment (Amazon VPC).
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-crawler-s3target.html#cfn-glue-crawler-s3target-connectionname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-crawler-s3target.html#cfn-glue-crawler-s3target-connectionname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getConnectionName() {
            return null;
        }

        /**
         * A valid Amazon dead-letter SQS ARN.
         * <p>
         * For example, <code>arn:aws:sqs:region:account:deadLetterQueue</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-crawler-s3target.html#cfn-glue-crawler-s3target-dlqeventqueuearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-crawler-s3target.html#cfn-glue-crawler-s3target-dlqeventqueuearn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDlqEventQueueArn() {
            return null;
        }

        /**
         * A valid Amazon SQS ARN.
         * <p>
         * For example, <code>arn:aws:sqs:region:account:sqs</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-crawler-s3target.html#cfn-glue-crawler-s3target-eventqueuearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-crawler-s3target.html#cfn-glue-crawler-s3target-eventqueuearn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getEventQueueArn() {
            return null;
        }

        /**
         * A list of glob patterns used to exclude from the crawl.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/glue/latest/dg/add-crawler.html">Catalog Tables with a Crawler</a> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-crawler-s3target.html#cfn-glue-crawler-s3target-exclusions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-crawler-s3target.html#cfn-glue-crawler-s3target-exclusions</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getExclusions() {
            return null;
        }

        /**
         * The path to the Amazon S3 target.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-crawler-s3target.html#cfn-glue-crawler-s3target-path">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-crawler-s3target.html#cfn-glue-crawler-s3target-path</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getPath() {
            return null;
        }

        /**
         * Sets the number of files in each leaf folder to be crawled when crawling sample files in a dataset.
         * <p>
         * If not set, all the files are crawled. A valid value is an integer between 1 and 249.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-crawler-s3target.html#cfn-glue-crawler-s3target-samplesize">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-crawler-s3target.html#cfn-glue-crawler-s3target-samplesize</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getSampleSize() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link S3TargetProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link S3TargetProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<S3TargetProperty> {
            java.lang.String connectionName;
            java.lang.String dlqEventQueueArn;
            java.lang.String eventQueueArn;
            java.util.List<java.lang.String> exclusions;
            java.lang.String path;
            java.lang.Number sampleSize;

            /**
             * Sets the value of {@link S3TargetProperty#getConnectionName}
             * @param connectionName The name of a connection which allows a job or crawler to access data in Amazon S3 within an Amazon Virtual Private Cloud environment (Amazon VPC).
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder connectionName(java.lang.String connectionName) {
                this.connectionName = connectionName;
                return this;
            }

            /**
             * Sets the value of {@link S3TargetProperty#getDlqEventQueueArn}
             * @param dlqEventQueueArn A valid Amazon dead-letter SQS ARN.
             *                         For example, <code>arn:aws:sqs:region:account:deadLetterQueue</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dlqEventQueueArn(java.lang.String dlqEventQueueArn) {
                this.dlqEventQueueArn = dlqEventQueueArn;
                return this;
            }

            /**
             * Sets the value of {@link S3TargetProperty#getEventQueueArn}
             * @param eventQueueArn A valid Amazon SQS ARN.
             *                      For example, <code>arn:aws:sqs:region:account:sqs</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder eventQueueArn(java.lang.String eventQueueArn) {
                this.eventQueueArn = eventQueueArn;
                return this;
            }

            /**
             * Sets the value of {@link S3TargetProperty#getExclusions}
             * @param exclusions A list of glob patterns used to exclude from the crawl.
             *                   For more information, see <a href="https://docs.aws.amazon.com/glue/latest/dg/add-crawler.html">Catalog Tables with a Crawler</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder exclusions(java.util.List<java.lang.String> exclusions) {
                this.exclusions = exclusions;
                return this;
            }

            /**
             * Sets the value of {@link S3TargetProperty#getPath}
             * @param path The path to the Amazon S3 target.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder path(java.lang.String path) {
                this.path = path;
                return this;
            }

            /**
             * Sets the value of {@link S3TargetProperty#getSampleSize}
             * @param sampleSize Sets the number of files in each leaf folder to be crawled when crawling sample files in a dataset.
             *                   If not set, all the files are crawled. A valid value is an integer between 1 and 249.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sampleSize(java.lang.Number sampleSize) {
                this.sampleSize = sampleSize;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link S3TargetProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public S3TargetProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link S3TargetProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements S3TargetProperty {
            private final java.lang.String connectionName;
            private final java.lang.String dlqEventQueueArn;
            private final java.lang.String eventQueueArn;
            private final java.util.List<java.lang.String> exclusions;
            private final java.lang.String path;
            private final java.lang.Number sampleSize;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.connectionName = software.amazon.jsii.Kernel.get(this, "connectionName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.dlqEventQueueArn = software.amazon.jsii.Kernel.get(this, "dlqEventQueueArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.eventQueueArn = software.amazon.jsii.Kernel.get(this, "eventQueueArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.exclusions = software.amazon.jsii.Kernel.get(this, "exclusions", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.path = software.amazon.jsii.Kernel.get(this, "path", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.sampleSize = software.amazon.jsii.Kernel.get(this, "sampleSize", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.connectionName = builder.connectionName;
                this.dlqEventQueueArn = builder.dlqEventQueueArn;
                this.eventQueueArn = builder.eventQueueArn;
                this.exclusions = builder.exclusions;
                this.path = builder.path;
                this.sampleSize = builder.sampleSize;
            }

            @Override
            public final java.lang.String getConnectionName() {
                return this.connectionName;
            }

            @Override
            public final java.lang.String getDlqEventQueueArn() {
                return this.dlqEventQueueArn;
            }

            @Override
            public final java.lang.String getEventQueueArn() {
                return this.eventQueueArn;
            }

            @Override
            public final java.util.List<java.lang.String> getExclusions() {
                return this.exclusions;
            }

            @Override
            public final java.lang.String getPath() {
                return this.path;
            }

            @Override
            public final java.lang.Number getSampleSize() {
                return this.sampleSize;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getConnectionName() != null) {
                    data.set("connectionName", om.valueToTree(this.getConnectionName()));
                }
                if (this.getDlqEventQueueArn() != null) {
                    data.set("dlqEventQueueArn", om.valueToTree(this.getDlqEventQueueArn()));
                }
                if (this.getEventQueueArn() != null) {
                    data.set("eventQueueArn", om.valueToTree(this.getEventQueueArn()));
                }
                if (this.getExclusions() != null) {
                    data.set("exclusions", om.valueToTree(this.getExclusions()));
                }
                if (this.getPath() != null) {
                    data.set("path", om.valueToTree(this.getPath()));
                }
                if (this.getSampleSize() != null) {
                    data.set("sampleSize", om.valueToTree(this.getSampleSize()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_glue.CfnCrawler.S3TargetProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                S3TargetProperty.Jsii$Proxy that = (S3TargetProperty.Jsii$Proxy) o;

                if (this.connectionName != null ? !this.connectionName.equals(that.connectionName) : that.connectionName != null) return false;
                if (this.dlqEventQueueArn != null ? !this.dlqEventQueueArn.equals(that.dlqEventQueueArn) : that.dlqEventQueueArn != null) return false;
                if (this.eventQueueArn != null ? !this.eventQueueArn.equals(that.eventQueueArn) : that.eventQueueArn != null) return false;
                if (this.exclusions != null ? !this.exclusions.equals(that.exclusions) : that.exclusions != null) return false;
                if (this.path != null ? !this.path.equals(that.path) : that.path != null) return false;
                return this.sampleSize != null ? this.sampleSize.equals(that.sampleSize) : that.sampleSize == null;
            }

            @Override
            public final int hashCode() {
                int result = this.connectionName != null ? this.connectionName.hashCode() : 0;
                result = 31 * result + (this.dlqEventQueueArn != null ? this.dlqEventQueueArn.hashCode() : 0);
                result = 31 * result + (this.eventQueueArn != null ? this.eventQueueArn.hashCode() : 0);
                result = 31 * result + (this.exclusions != null ? this.exclusions.hashCode() : 0);
                result = 31 * result + (this.path != null ? this.path.hashCode() : 0);
                result = 31 * result + (this.sampleSize != null ? this.sampleSize.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * A scheduling object using a <code>cron</code> statement to schedule an event.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.glue.*;
     * ScheduleProperty scheduleProperty = ScheduleProperty.builder()
     *         .scheduleExpression("scheduleExpression")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-crawler-schedule.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-crawler-schedule.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_glue.CfnCrawler.ScheduleProperty")
    @software.amazon.jsii.Jsii.Proxy(ScheduleProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ScheduleProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A <code>cron</code> expression used to specify the schedule.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/glue/latest/dg/monitor-data-warehouse-schedule.html">Time-Based Schedules for Jobs and Crawlers</a> . For example, to run something every day at 12:15 UTC, specify <code>cron(15 12 * * ? *)</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-crawler-schedule.html#cfn-glue-crawler-schedule-scheduleexpression">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-crawler-schedule.html#cfn-glue-crawler-schedule-scheduleexpression</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getScheduleExpression() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ScheduleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ScheduleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ScheduleProperty> {
            java.lang.String scheduleExpression;

            /**
             * Sets the value of {@link ScheduleProperty#getScheduleExpression}
             * @param scheduleExpression A <code>cron</code> expression used to specify the schedule.
             *                           For more information, see <a href="https://docs.aws.amazon.com/glue/latest/dg/monitor-data-warehouse-schedule.html">Time-Based Schedules for Jobs and Crawlers</a> . For example, to run something every day at 12:15 UTC, specify <code>cron(15 12 * * ? *)</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder scheduleExpression(java.lang.String scheduleExpression) {
                this.scheduleExpression = scheduleExpression;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ScheduleProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ScheduleProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ScheduleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ScheduleProperty {
            private final java.lang.String scheduleExpression;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.scheduleExpression = software.amazon.jsii.Kernel.get(this, "scheduleExpression", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.scheduleExpression = builder.scheduleExpression;
            }

            @Override
            public final java.lang.String getScheduleExpression() {
                return this.scheduleExpression;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getScheduleExpression() != null) {
                    data.set("scheduleExpression", om.valueToTree(this.getScheduleExpression()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_glue.CfnCrawler.ScheduleProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ScheduleProperty.Jsii$Proxy that = (ScheduleProperty.Jsii$Proxy) o;

                return this.scheduleExpression != null ? this.scheduleExpression.equals(that.scheduleExpression) : that.scheduleExpression == null;
            }

            @Override
            public final int hashCode() {
                int result = this.scheduleExpression != null ? this.scheduleExpression.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * The policy that specifies update and delete behaviors for the crawler.
     * <p>
     * The policy tells the crawler what to do in the event that it detects a change in a table that already exists in the customer's database at the time of the crawl. The <code>SchemaChangePolicy</code> does not affect whether or how new tables and partitions are added. New tables and partitions are always created regardless of the <code>SchemaChangePolicy</code> on a crawler.
     * <p>
     * The SchemaChangePolicy consists of two components, <code>UpdateBehavior</code> and <code>DeleteBehavior</code> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.glue.*;
     * SchemaChangePolicyProperty schemaChangePolicyProperty = SchemaChangePolicyProperty.builder()
     *         .deleteBehavior("deleteBehavior")
     *         .updateBehavior("updateBehavior")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-crawler-schemachangepolicy.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-crawler-schemachangepolicy.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_glue.CfnCrawler.SchemaChangePolicyProperty")
    @software.amazon.jsii.Jsii.Proxy(SchemaChangePolicyProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SchemaChangePolicyProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The deletion behavior when the crawler finds a deleted object.
         * <p>
         * A value of <code>LOG</code> specifies that if a table or partition is found to no longer exist, do not delete it, only log that it was found to no longer exist.
         * <p>
         * A value of <code>DELETE_FROM_DATABASE</code> specifies that if a table or partition is found to have been removed, delete it from the database.
         * <p>
         * A value of <code>DEPRECATE_IN_DATABASE</code> specifies that if a table has been found to no longer exist, to add a property to the table that says "DEPRECATED" and includes a timestamp with the time of deprecation.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-crawler-schemachangepolicy.html#cfn-glue-crawler-schemachangepolicy-deletebehavior">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-crawler-schemachangepolicy.html#cfn-glue-crawler-schemachangepolicy-deletebehavior</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDeleteBehavior() {
            return null;
        }

        /**
         * The update behavior when the crawler finds a changed schema.
         * <p>
         * A value of <code>LOG</code> specifies that if a table or a partition already exists, and a change is detected, do not update it, only log that a change was detected. Add new tables and new partitions (including on existing tables).
         * <p>
         * A value of <code>UPDATE_IN_DATABASE</code> specifies that if a table or partition already exists, and a change is detected, update it. Add new tables and partitions.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-crawler-schemachangepolicy.html#cfn-glue-crawler-schemachangepolicy-updatebehavior">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-crawler-schemachangepolicy.html#cfn-glue-crawler-schemachangepolicy-updatebehavior</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getUpdateBehavior() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link SchemaChangePolicyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SchemaChangePolicyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SchemaChangePolicyProperty> {
            java.lang.String deleteBehavior;
            java.lang.String updateBehavior;

            /**
             * Sets the value of {@link SchemaChangePolicyProperty#getDeleteBehavior}
             * @param deleteBehavior The deletion behavior when the crawler finds a deleted object.
             *                       A value of <code>LOG</code> specifies that if a table or partition is found to no longer exist, do not delete it, only log that it was found to no longer exist.
             *                       <p>
             *                       A value of <code>DELETE_FROM_DATABASE</code> specifies that if a table or partition is found to have been removed, delete it from the database.
             *                       <p>
             *                       A value of <code>DEPRECATE_IN_DATABASE</code> specifies that if a table has been found to no longer exist, to add a property to the table that says "DEPRECATED" and includes a timestamp with the time of deprecation.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder deleteBehavior(java.lang.String deleteBehavior) {
                this.deleteBehavior = deleteBehavior;
                return this;
            }

            /**
             * Sets the value of {@link SchemaChangePolicyProperty#getUpdateBehavior}
             * @param updateBehavior The update behavior when the crawler finds a changed schema.
             *                       A value of <code>LOG</code> specifies that if a table or a partition already exists, and a change is detected, do not update it, only log that a change was detected. Add new tables and new partitions (including on existing tables).
             *                       <p>
             *                       A value of <code>UPDATE_IN_DATABASE</code> specifies that if a table or partition already exists, and a change is detected, update it. Add new tables and partitions.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder updateBehavior(java.lang.String updateBehavior) {
                this.updateBehavior = updateBehavior;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SchemaChangePolicyProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SchemaChangePolicyProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SchemaChangePolicyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SchemaChangePolicyProperty {
            private final java.lang.String deleteBehavior;
            private final java.lang.String updateBehavior;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.deleteBehavior = software.amazon.jsii.Kernel.get(this, "deleteBehavior", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.updateBehavior = software.amazon.jsii.Kernel.get(this, "updateBehavior", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.deleteBehavior = builder.deleteBehavior;
                this.updateBehavior = builder.updateBehavior;
            }

            @Override
            public final java.lang.String getDeleteBehavior() {
                return this.deleteBehavior;
            }

            @Override
            public final java.lang.String getUpdateBehavior() {
                return this.updateBehavior;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getDeleteBehavior() != null) {
                    data.set("deleteBehavior", om.valueToTree(this.getDeleteBehavior()));
                }
                if (this.getUpdateBehavior() != null) {
                    data.set("updateBehavior", om.valueToTree(this.getUpdateBehavior()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_glue.CfnCrawler.SchemaChangePolicyProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SchemaChangePolicyProperty.Jsii$Proxy that = (SchemaChangePolicyProperty.Jsii$Proxy) o;

                if (this.deleteBehavior != null ? !this.deleteBehavior.equals(that.deleteBehavior) : that.deleteBehavior != null) return false;
                return this.updateBehavior != null ? this.updateBehavior.equals(that.updateBehavior) : that.updateBehavior == null;
            }

            @Override
            public final int hashCode() {
                int result = this.deleteBehavior != null ? this.deleteBehavior.hashCode() : 0;
                result = 31 * result + (this.updateBehavior != null ? this.updateBehavior.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Specifies data stores to crawl.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.glue.*;
     * TargetsProperty targetsProperty = TargetsProperty.builder()
     *         .catalogTargets(List.of(CatalogTargetProperty.builder()
     *                 .connectionName("connectionName")
     *                 .databaseName("databaseName")
     *                 .dlqEventQueueArn("dlqEventQueueArn")
     *                 .eventQueueArn("eventQueueArn")
     *                 .tables(List.of("tables"))
     *                 .build()))
     *         .deltaTargets(List.of(DeltaTargetProperty.builder()
     *                 .connectionName("connectionName")
     *                 .createNativeDeltaTable(false)
     *                 .deltaTables(List.of("deltaTables"))
     *                 .writeManifest(false)
     *                 .build()))
     *         .dynamoDbTargets(List.of(DynamoDBTargetProperty.builder()
     *                 .path("path")
     *                 .build()))
     *         .icebergTargets(List.of(IcebergTargetProperty.builder()
     *                 .connectionName("connectionName")
     *                 .exclusions(List.of("exclusions"))
     *                 .maximumTraversalDepth(123)
     *                 .paths(List.of("paths"))
     *                 .build()))
     *         .jdbcTargets(List.of(JdbcTargetProperty.builder()
     *                 .connectionName("connectionName")
     *                 .enableAdditionalMetadata(List.of("enableAdditionalMetadata"))
     *                 .exclusions(List.of("exclusions"))
     *                 .path("path")
     *                 .build()))
     *         .mongoDbTargets(List.of(MongoDBTargetProperty.builder()
     *                 .connectionName("connectionName")
     *                 .path("path")
     *                 .build()))
     *         .s3Targets(List.of(S3TargetProperty.builder()
     *                 .connectionName("connectionName")
     *                 .dlqEventQueueArn("dlqEventQueueArn")
     *                 .eventQueueArn("eventQueueArn")
     *                 .exclusions(List.of("exclusions"))
     *                 .path("path")
     *                 .sampleSize(123)
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-crawler-targets.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-crawler-targets.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_glue.CfnCrawler.TargetsProperty")
    @software.amazon.jsii.Jsii.Proxy(TargetsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface TargetsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Specifies AWS Glue Data Catalog targets.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-crawler-targets.html#cfn-glue-crawler-targets-catalogtargets">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-crawler-targets.html#cfn-glue-crawler-targets-catalogtargets</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCatalogTargets() {
            return null;
        }

        /**
         * Specifies an array of Delta data store targets.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-crawler-targets.html#cfn-glue-crawler-targets-deltatargets">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-crawler-targets.html#cfn-glue-crawler-targets-deltatargets</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDeltaTargets() {
            return null;
        }

        /**
         * Specifies Amazon DynamoDB targets.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-crawler-targets.html#cfn-glue-crawler-targets-dynamodbtargets">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-crawler-targets.html#cfn-glue-crawler-targets-dynamodbtargets</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDynamoDbTargets() {
            return null;
        }

        /**
         * Specifies Apache Iceberg data store targets.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-crawler-targets.html#cfn-glue-crawler-targets-icebergtargets">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-crawler-targets.html#cfn-glue-crawler-targets-icebergtargets</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getIcebergTargets() {
            return null;
        }

        /**
         * Specifies JDBC targets.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-crawler-targets.html#cfn-glue-crawler-targets-jdbctargets">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-crawler-targets.html#cfn-glue-crawler-targets-jdbctargets</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getJdbcTargets() {
            return null;
        }

        /**
         * A list of Mongo DB targets.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-crawler-targets.html#cfn-glue-crawler-targets-mongodbtargets">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-crawler-targets.html#cfn-glue-crawler-targets-mongodbtargets</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getMongoDbTargets() {
            return null;
        }

        /**
         * Specifies Amazon Simple Storage Service (Amazon S3) targets.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-crawler-targets.html#cfn-glue-crawler-targets-s3targets">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-crawler-targets.html#cfn-glue-crawler-targets-s3targets</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getS3Targets() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link TargetsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link TargetsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<TargetsProperty> {
            java.lang.Object catalogTargets;
            java.lang.Object deltaTargets;
            java.lang.Object dynamoDbTargets;
            java.lang.Object icebergTargets;
            java.lang.Object jdbcTargets;
            java.lang.Object mongoDbTargets;
            java.lang.Object s3Targets;

            /**
             * Sets the value of {@link TargetsProperty#getCatalogTargets}
             * @param catalogTargets Specifies AWS Glue Data Catalog targets.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder catalogTargets(software.amazon.awscdk.IResolvable catalogTargets) {
                this.catalogTargets = catalogTargets;
                return this;
            }

            /**
             * Sets the value of {@link TargetsProperty#getCatalogTargets}
             * @param catalogTargets Specifies AWS Glue Data Catalog targets.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder catalogTargets(java.util.List<? extends java.lang.Object> catalogTargets) {
                this.catalogTargets = catalogTargets;
                return this;
            }

            /**
             * Sets the value of {@link TargetsProperty#getDeltaTargets}
             * @param deltaTargets Specifies an array of Delta data store targets.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder deltaTargets(software.amazon.awscdk.IResolvable deltaTargets) {
                this.deltaTargets = deltaTargets;
                return this;
            }

            /**
             * Sets the value of {@link TargetsProperty#getDeltaTargets}
             * @param deltaTargets Specifies an array of Delta data store targets.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder deltaTargets(java.util.List<? extends java.lang.Object> deltaTargets) {
                this.deltaTargets = deltaTargets;
                return this;
            }

            /**
             * Sets the value of {@link TargetsProperty#getDynamoDbTargets}
             * @param dynamoDbTargets Specifies Amazon DynamoDB targets.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dynamoDbTargets(software.amazon.awscdk.IResolvable dynamoDbTargets) {
                this.dynamoDbTargets = dynamoDbTargets;
                return this;
            }

            /**
             * Sets the value of {@link TargetsProperty#getDynamoDbTargets}
             * @param dynamoDbTargets Specifies Amazon DynamoDB targets.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dynamoDbTargets(java.util.List<? extends java.lang.Object> dynamoDbTargets) {
                this.dynamoDbTargets = dynamoDbTargets;
                return this;
            }

            /**
             * Sets the value of {@link TargetsProperty#getIcebergTargets}
             * @param icebergTargets Specifies Apache Iceberg data store targets.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder icebergTargets(software.amazon.awscdk.IResolvable icebergTargets) {
                this.icebergTargets = icebergTargets;
                return this;
            }

            /**
             * Sets the value of {@link TargetsProperty#getIcebergTargets}
             * @param icebergTargets Specifies Apache Iceberg data store targets.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder icebergTargets(java.util.List<? extends java.lang.Object> icebergTargets) {
                this.icebergTargets = icebergTargets;
                return this;
            }

            /**
             * Sets the value of {@link TargetsProperty#getJdbcTargets}
             * @param jdbcTargets Specifies JDBC targets.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder jdbcTargets(software.amazon.awscdk.IResolvable jdbcTargets) {
                this.jdbcTargets = jdbcTargets;
                return this;
            }

            /**
             * Sets the value of {@link TargetsProperty#getJdbcTargets}
             * @param jdbcTargets Specifies JDBC targets.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder jdbcTargets(java.util.List<? extends java.lang.Object> jdbcTargets) {
                this.jdbcTargets = jdbcTargets;
                return this;
            }

            /**
             * Sets the value of {@link TargetsProperty#getMongoDbTargets}
             * @param mongoDbTargets A list of Mongo DB targets.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder mongoDbTargets(software.amazon.awscdk.IResolvable mongoDbTargets) {
                this.mongoDbTargets = mongoDbTargets;
                return this;
            }

            /**
             * Sets the value of {@link TargetsProperty#getMongoDbTargets}
             * @param mongoDbTargets A list of Mongo DB targets.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder mongoDbTargets(java.util.List<? extends java.lang.Object> mongoDbTargets) {
                this.mongoDbTargets = mongoDbTargets;
                return this;
            }

            /**
             * Sets the value of {@link TargetsProperty#getS3Targets}
             * @param s3Targets Specifies Amazon Simple Storage Service (Amazon S3) targets.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3Targets(software.amazon.awscdk.IResolvable s3Targets) {
                this.s3Targets = s3Targets;
                return this;
            }

            /**
             * Sets the value of {@link TargetsProperty#getS3Targets}
             * @param s3Targets Specifies Amazon Simple Storage Service (Amazon S3) targets.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3Targets(java.util.List<? extends java.lang.Object> s3Targets) {
                this.s3Targets = s3Targets;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TargetsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public TargetsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link TargetsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TargetsProperty {
            private final java.lang.Object catalogTargets;
            private final java.lang.Object deltaTargets;
            private final java.lang.Object dynamoDbTargets;
            private final java.lang.Object icebergTargets;
            private final java.lang.Object jdbcTargets;
            private final java.lang.Object mongoDbTargets;
            private final java.lang.Object s3Targets;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.catalogTargets = software.amazon.jsii.Kernel.get(this, "catalogTargets", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.deltaTargets = software.amazon.jsii.Kernel.get(this, "deltaTargets", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.dynamoDbTargets = software.amazon.jsii.Kernel.get(this, "dynamoDbTargets", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.icebergTargets = software.amazon.jsii.Kernel.get(this, "icebergTargets", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.jdbcTargets = software.amazon.jsii.Kernel.get(this, "jdbcTargets", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.mongoDbTargets = software.amazon.jsii.Kernel.get(this, "mongoDbTargets", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.s3Targets = software.amazon.jsii.Kernel.get(this, "s3Targets", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.catalogTargets = builder.catalogTargets;
                this.deltaTargets = builder.deltaTargets;
                this.dynamoDbTargets = builder.dynamoDbTargets;
                this.icebergTargets = builder.icebergTargets;
                this.jdbcTargets = builder.jdbcTargets;
                this.mongoDbTargets = builder.mongoDbTargets;
                this.s3Targets = builder.s3Targets;
            }

            @Override
            public final java.lang.Object getCatalogTargets() {
                return this.catalogTargets;
            }

            @Override
            public final java.lang.Object getDeltaTargets() {
                return this.deltaTargets;
            }

            @Override
            public final java.lang.Object getDynamoDbTargets() {
                return this.dynamoDbTargets;
            }

            @Override
            public final java.lang.Object getIcebergTargets() {
                return this.icebergTargets;
            }

            @Override
            public final java.lang.Object getJdbcTargets() {
                return this.jdbcTargets;
            }

            @Override
            public final java.lang.Object getMongoDbTargets() {
                return this.mongoDbTargets;
            }

            @Override
            public final java.lang.Object getS3Targets() {
                return this.s3Targets;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getCatalogTargets() != null) {
                    data.set("catalogTargets", om.valueToTree(this.getCatalogTargets()));
                }
                if (this.getDeltaTargets() != null) {
                    data.set("deltaTargets", om.valueToTree(this.getDeltaTargets()));
                }
                if (this.getDynamoDbTargets() != null) {
                    data.set("dynamoDbTargets", om.valueToTree(this.getDynamoDbTargets()));
                }
                if (this.getIcebergTargets() != null) {
                    data.set("icebergTargets", om.valueToTree(this.getIcebergTargets()));
                }
                if (this.getJdbcTargets() != null) {
                    data.set("jdbcTargets", om.valueToTree(this.getJdbcTargets()));
                }
                if (this.getMongoDbTargets() != null) {
                    data.set("mongoDbTargets", om.valueToTree(this.getMongoDbTargets()));
                }
                if (this.getS3Targets() != null) {
                    data.set("s3Targets", om.valueToTree(this.getS3Targets()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_glue.CfnCrawler.TargetsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                TargetsProperty.Jsii$Proxy that = (TargetsProperty.Jsii$Proxy) o;

                if (this.catalogTargets != null ? !this.catalogTargets.equals(that.catalogTargets) : that.catalogTargets != null) return false;
                if (this.deltaTargets != null ? !this.deltaTargets.equals(that.deltaTargets) : that.deltaTargets != null) return false;
                if (this.dynamoDbTargets != null ? !this.dynamoDbTargets.equals(that.dynamoDbTargets) : that.dynamoDbTargets != null) return false;
                if (this.icebergTargets != null ? !this.icebergTargets.equals(that.icebergTargets) : that.icebergTargets != null) return false;
                if (this.jdbcTargets != null ? !this.jdbcTargets.equals(that.jdbcTargets) : that.jdbcTargets != null) return false;
                if (this.mongoDbTargets != null ? !this.mongoDbTargets.equals(that.mongoDbTargets) : that.mongoDbTargets != null) return false;
                return this.s3Targets != null ? this.s3Targets.equals(that.s3Targets) : that.s3Targets == null;
            }

            @Override
            public final int hashCode() {
                int result = this.catalogTargets != null ? this.catalogTargets.hashCode() : 0;
                result = 31 * result + (this.deltaTargets != null ? this.deltaTargets.hashCode() : 0);
                result = 31 * result + (this.dynamoDbTargets != null ? this.dynamoDbTargets.hashCode() : 0);
                result = 31 * result + (this.icebergTargets != null ? this.icebergTargets.hashCode() : 0);
                result = 31 * result + (this.jdbcTargets != null ? this.jdbcTargets.hashCode() : 0);
                result = 31 * result + (this.mongoDbTargets != null ? this.mongoDbTargets.hashCode() : 0);
                result = 31 * result + (this.s3Targets != null ? this.s3Targets.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.glue.CfnCrawler}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.glue.CfnCrawler> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.glue.CfnCrawlerProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.glue.CfnCrawlerProps.Builder();
        }

        /**
         * The Amazon Resource Name (ARN) of an IAM role that's used to access customer resources, such as Amazon Simple Storage Service (Amazon S3) data.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-crawler.html#cfn-glue-crawler-role">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-crawler.html#cfn-glue-crawler-role</a>
         * @param role The Amazon Resource Name (ARN) of an IAM role that's used to access customer resources, such as Amazon Simple Storage Service (Amazon S3) data. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder role(final java.lang.String role) {
            this.props.role(role);
            return this;
        }

        /**
         * A collection of targets to crawl.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-crawler.html#cfn-glue-crawler-targets">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-crawler.html#cfn-glue-crawler-targets</a>
         * @param targets A collection of targets to crawl. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder targets(final software.amazon.awscdk.IResolvable targets) {
            this.props.targets(targets);
            return this;
        }
        /**
         * A collection of targets to crawl.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-crawler.html#cfn-glue-crawler-targets">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-crawler.html#cfn-glue-crawler-targets</a>
         * @param targets A collection of targets to crawl. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder targets(final software.amazon.awscdk.services.glue.CfnCrawler.TargetsProperty targets) {
            this.props.targets(targets);
            return this;
        }

        /**
         * A list of UTF-8 strings that specify the names of custom classifiers that are associated with the crawler.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-crawler.html#cfn-glue-crawler-classifiers">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-crawler.html#cfn-glue-crawler-classifiers</a>
         * @param classifiers A list of UTF-8 strings that specify the names of custom classifiers that are associated with the crawler. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder classifiers(final java.util.List<java.lang.String> classifiers) {
            this.props.classifiers(classifiers);
            return this;
        }

        /**
         * Crawler configuration information.
         * <p>
         * This versioned JSON string allows users to specify aspects of a crawler's behavior. For more information, see <a href="https://docs.aws.amazon.com/glue/latest/dg/crawler-configuration.html">Configuring a Crawler</a> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-crawler.html#cfn-glue-crawler-configuration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-crawler.html#cfn-glue-crawler-configuration</a>
         * @param configuration Crawler configuration information. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder configuration(final java.lang.String configuration) {
            this.props.configuration(configuration);
            return this;
        }

        /**
         * The name of the <code>SecurityConfiguration</code> structure to be used by this crawler.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-crawler.html#cfn-glue-crawler-crawlersecurityconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-crawler.html#cfn-glue-crawler-crawlersecurityconfiguration</a>
         * @param crawlerSecurityConfiguration The name of the <code>SecurityConfiguration</code> structure to be used by this crawler. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder crawlerSecurityConfiguration(final java.lang.String crawlerSecurityConfiguration) {
            this.props.crawlerSecurityConfiguration(crawlerSecurityConfiguration);
            return this;
        }

        /**
         * The name of the database in which the crawler's output is stored.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-crawler.html#cfn-glue-crawler-databasename">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-crawler.html#cfn-glue-crawler-databasename</a>
         * @param databaseName The name of the database in which the crawler's output is stored. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder databaseName(final java.lang.String databaseName) {
            this.props.databaseName(databaseName);
            return this;
        }

        /**
         * A description of the crawler.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-crawler.html#cfn-glue-crawler-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-crawler.html#cfn-glue-crawler-description</a>
         * @param description A description of the crawler. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(final java.lang.String description) {
            this.props.description(description);
            return this;
        }

        /**
         * Specifies whether the crawler should use AWS Lake Formation credentials for the crawler instead of the IAM role credentials.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-crawler.html#cfn-glue-crawler-lakeformationconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-crawler.html#cfn-glue-crawler-lakeformationconfiguration</a>
         * @param lakeFormationConfiguration Specifies whether the crawler should use AWS Lake Formation credentials for the crawler instead of the IAM role credentials. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder lakeFormationConfiguration(final software.amazon.awscdk.IResolvable lakeFormationConfiguration) {
            this.props.lakeFormationConfiguration(lakeFormationConfiguration);
            return this;
        }
        /**
         * Specifies whether the crawler should use AWS Lake Formation credentials for the crawler instead of the IAM role credentials.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-crawler.html#cfn-glue-crawler-lakeformationconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-crawler.html#cfn-glue-crawler-lakeformationconfiguration</a>
         * @param lakeFormationConfiguration Specifies whether the crawler should use AWS Lake Formation credentials for the crawler instead of the IAM role credentials. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder lakeFormationConfiguration(final software.amazon.awscdk.services.glue.CfnCrawler.LakeFormationConfigurationProperty lakeFormationConfiguration) {
            this.props.lakeFormationConfiguration(lakeFormationConfiguration);
            return this;
        }

        /**
         * The name of the crawler.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-crawler.html#cfn-glue-crawler-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-crawler.html#cfn-glue-crawler-name</a>
         * @param name The name of the crawler. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(final java.lang.String name) {
            this.props.name(name);
            return this;
        }

        /**
         * A policy that specifies whether to crawl the entire dataset again, or to crawl only folders that were added since the last crawler run.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-crawler.html#cfn-glue-crawler-recrawlpolicy">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-crawler.html#cfn-glue-crawler-recrawlpolicy</a>
         * @param recrawlPolicy A policy that specifies whether to crawl the entire dataset again, or to crawl only folders that were added since the last crawler run. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder recrawlPolicy(final software.amazon.awscdk.IResolvable recrawlPolicy) {
            this.props.recrawlPolicy(recrawlPolicy);
            return this;
        }
        /**
         * A policy that specifies whether to crawl the entire dataset again, or to crawl only folders that were added since the last crawler run.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-crawler.html#cfn-glue-crawler-recrawlpolicy">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-crawler.html#cfn-glue-crawler-recrawlpolicy</a>
         * @param recrawlPolicy A policy that specifies whether to crawl the entire dataset again, or to crawl only folders that were added since the last crawler run. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder recrawlPolicy(final software.amazon.awscdk.services.glue.CfnCrawler.RecrawlPolicyProperty recrawlPolicy) {
            this.props.recrawlPolicy(recrawlPolicy);
            return this;
        }

        /**
         * For scheduled crawlers, the schedule when the crawler runs.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-crawler.html#cfn-glue-crawler-schedule">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-crawler.html#cfn-glue-crawler-schedule</a>
         * @param schedule For scheduled crawlers, the schedule when the crawler runs. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder schedule(final software.amazon.awscdk.IResolvable schedule) {
            this.props.schedule(schedule);
            return this;
        }
        /**
         * For scheduled crawlers, the schedule when the crawler runs.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-crawler.html#cfn-glue-crawler-schedule">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-crawler.html#cfn-glue-crawler-schedule</a>
         * @param schedule For scheduled crawlers, the schedule when the crawler runs. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder schedule(final software.amazon.awscdk.services.glue.CfnCrawler.ScheduleProperty schedule) {
            this.props.schedule(schedule);
            return this;
        }

        /**
         * The policy that specifies update and delete behaviors for the crawler.
         * <p>
         * The policy tells the crawler what to do in the event that it detects a change in a table that already exists in the customer's database at the time of the crawl. The <code>SchemaChangePolicy</code> does not affect whether or how new tables and partitions are added. New tables and partitions are always created regardless of the <code>SchemaChangePolicy</code> on a crawler.
         * <p>
         * The SchemaChangePolicy consists of two components, <code>UpdateBehavior</code> and <code>DeleteBehavior</code> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-crawler.html#cfn-glue-crawler-schemachangepolicy">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-crawler.html#cfn-glue-crawler-schemachangepolicy</a>
         * @param schemaChangePolicy The policy that specifies update and delete behaviors for the crawler. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder schemaChangePolicy(final software.amazon.awscdk.IResolvable schemaChangePolicy) {
            this.props.schemaChangePolicy(schemaChangePolicy);
            return this;
        }
        /**
         * The policy that specifies update and delete behaviors for the crawler.
         * <p>
         * The policy tells the crawler what to do in the event that it detects a change in a table that already exists in the customer's database at the time of the crawl. The <code>SchemaChangePolicy</code> does not affect whether or how new tables and partitions are added. New tables and partitions are always created regardless of the <code>SchemaChangePolicy</code> on a crawler.
         * <p>
         * The SchemaChangePolicy consists of two components, <code>UpdateBehavior</code> and <code>DeleteBehavior</code> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-crawler.html#cfn-glue-crawler-schemachangepolicy">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-crawler.html#cfn-glue-crawler-schemachangepolicy</a>
         * @param schemaChangePolicy The policy that specifies update and delete behaviors for the crawler. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder schemaChangePolicy(final software.amazon.awscdk.services.glue.CfnCrawler.SchemaChangePolicyProperty schemaChangePolicy) {
            this.props.schemaChangePolicy(schemaChangePolicy);
            return this;
        }

        /**
         * The prefix added to the names of tables that are created.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-crawler.html#cfn-glue-crawler-tableprefix">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-crawler.html#cfn-glue-crawler-tableprefix</a>
         * @param tablePrefix The prefix added to the names of tables that are created. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tablePrefix(final java.lang.String tablePrefix) {
            this.props.tablePrefix(tablePrefix);
            return this;
        }

        /**
         * The tags to use with this crawler.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-crawler.html#cfn-glue-crawler-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-crawler.html#cfn-glue-crawler-tags</a>
         * @param tags The tags to use with this crawler. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.lang.Object tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.glue.CfnCrawler}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.glue.CfnCrawler build() {
            return new software.amazon.awscdk.services.glue.CfnCrawler(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
