package software.amazon.awscdk.services.glue;

/**
 * Properties for defining a <code>CfnCrawler</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.glue.*;
 * Object tags;
 * CfnCrawlerProps cfnCrawlerProps = CfnCrawlerProps.builder()
 *         .role("role")
 *         .targets(TargetsProperty.builder()
 *                 .catalogTargets(List.of(CatalogTargetProperty.builder()
 *                         .connectionName("connectionName")
 *                         .databaseName("databaseName")
 *                         .dlqEventQueueArn("dlqEventQueueArn")
 *                         .eventQueueArn("eventQueueArn")
 *                         .tables(List.of("tables"))
 *                         .build()))
 *                 .deltaTargets(List.of(DeltaTargetProperty.builder()
 *                         .connectionName("connectionName")
 *                         .createNativeDeltaTable(false)
 *                         .deltaTables(List.of("deltaTables"))
 *                         .writeManifest(false)
 *                         .build()))
 *                 .dynamoDbTargets(List.of(DynamoDBTargetProperty.builder()
 *                         .path("path")
 *                         .build()))
 *                 .icebergTargets(List.of(IcebergTargetProperty.builder()
 *                         .connectionName("connectionName")
 *                         .exclusions(List.of("exclusions"))
 *                         .maximumTraversalDepth(123)
 *                         .paths(List.of("paths"))
 *                         .build()))
 *                 .jdbcTargets(List.of(JdbcTargetProperty.builder()
 *                         .connectionName("connectionName")
 *                         .enableAdditionalMetadata(List.of("enableAdditionalMetadata"))
 *                         .exclusions(List.of("exclusions"))
 *                         .path("path")
 *                         .build()))
 *                 .mongoDbTargets(List.of(MongoDBTargetProperty.builder()
 *                         .connectionName("connectionName")
 *                         .path("path")
 *                         .build()))
 *                 .s3Targets(List.of(S3TargetProperty.builder()
 *                         .connectionName("connectionName")
 *                         .dlqEventQueueArn("dlqEventQueueArn")
 *                         .eventQueueArn("eventQueueArn")
 *                         .exclusions(List.of("exclusions"))
 *                         .path("path")
 *                         .sampleSize(123)
 *                         .build()))
 *                 .build())
 *         // the properties below are optional
 *         .classifiers(List.of("classifiers"))
 *         .configuration("configuration")
 *         .crawlerSecurityConfiguration("crawlerSecurityConfiguration")
 *         .databaseName("databaseName")
 *         .description("description")
 *         .lakeFormationConfiguration(LakeFormationConfigurationProperty.builder()
 *                 .accountId("accountId")
 *                 .useLakeFormationCredentials(false)
 *                 .build())
 *         .name("name")
 *         .recrawlPolicy(RecrawlPolicyProperty.builder()
 *                 .recrawlBehavior("recrawlBehavior")
 *                 .build())
 *         .schedule(ScheduleProperty.builder()
 *                 .scheduleExpression("scheduleExpression")
 *                 .build())
 *         .schemaChangePolicy(SchemaChangePolicyProperty.builder()
 *                 .deleteBehavior("deleteBehavior")
 *                 .updateBehavior("updateBehavior")
 *                 .build())
 *         .tablePrefix("tablePrefix")
 *         .tags(tags)
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-crawler.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-crawler.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-01-25T00:20:56.379Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_glue.CfnCrawlerProps")
@software.amazon.jsii.Jsii.Proxy(CfnCrawlerProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnCrawlerProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The Amazon Resource Name (ARN) of an IAM role that's used to access customer resources, such as Amazon Simple Storage Service (Amazon S3) data.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-crawler.html#cfn-glue-crawler-role">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-crawler.html#cfn-glue-crawler-role</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getRole();

    /**
     * A collection of targets to crawl.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-crawler.html#cfn-glue-crawler-targets">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-crawler.html#cfn-glue-crawler-targets</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getTargets();

    /**
     * A list of UTF-8 strings that specify the names of custom classifiers that are associated with the crawler.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-crawler.html#cfn-glue-crawler-classifiers">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-crawler.html#cfn-glue-crawler-classifiers</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getClassifiers() {
        return null;
    }

    /**
     * Crawler configuration information.
     * <p>
     * This versioned JSON string allows users to specify aspects of a crawler's behavior. For more information, see <a href="https://docs.aws.amazon.com/glue/latest/dg/crawler-configuration.html">Configuring a Crawler</a> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-crawler.html#cfn-glue-crawler-configuration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-crawler.html#cfn-glue-crawler-configuration</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getConfiguration() {
        return null;
    }

    /**
     * The name of the <code>SecurityConfiguration</code> structure to be used by this crawler.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-crawler.html#cfn-glue-crawler-crawlersecurityconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-crawler.html#cfn-glue-crawler-crawlersecurityconfiguration</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getCrawlerSecurityConfiguration() {
        return null;
    }

    /**
     * The name of the database in which the crawler's output is stored.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-crawler.html#cfn-glue-crawler-databasename">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-crawler.html#cfn-glue-crawler-databasename</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDatabaseName() {
        return null;
    }

    /**
     * A description of the crawler.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-crawler.html#cfn-glue-crawler-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-crawler.html#cfn-glue-crawler-description</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return null;
    }

    /**
     * Specifies whether the crawler should use AWS Lake Formation credentials for the crawler instead of the IAM role credentials.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-crawler.html#cfn-glue-crawler-lakeformationconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-crawler.html#cfn-glue-crawler-lakeformationconfiguration</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getLakeFormationConfiguration() {
        return null;
    }

    /**
     * The name of the crawler.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-crawler.html#cfn-glue-crawler-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-crawler.html#cfn-glue-crawler-name</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getName() {
        return null;
    }

    /**
     * A policy that specifies whether to crawl the entire dataset again, or to crawl only folders that were added since the last crawler run.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-crawler.html#cfn-glue-crawler-recrawlpolicy">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-crawler.html#cfn-glue-crawler-recrawlpolicy</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getRecrawlPolicy() {
        return null;
    }

    /**
     * For scheduled crawlers, the schedule when the crawler runs.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-crawler.html#cfn-glue-crawler-schedule">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-crawler.html#cfn-glue-crawler-schedule</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getSchedule() {
        return null;
    }

    /**
     * The policy that specifies update and delete behaviors for the crawler.
     * <p>
     * The policy tells the crawler what to do in the event that it detects a change in a table that already exists in the customer's database at the time of the crawl. The <code>SchemaChangePolicy</code> does not affect whether or how new tables and partitions are added. New tables and partitions are always created regardless of the <code>SchemaChangePolicy</code> on a crawler.
     * <p>
     * The SchemaChangePolicy consists of two components, <code>UpdateBehavior</code> and <code>DeleteBehavior</code> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-crawler.html#cfn-glue-crawler-schemachangepolicy">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-crawler.html#cfn-glue-crawler-schemachangepolicy</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getSchemaChangePolicy() {
        return null;
    }

    /**
     * The prefix added to the names of tables that are created.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-crawler.html#cfn-glue-crawler-tableprefix">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-crawler.html#cfn-glue-crawler-tableprefix</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getTablePrefix() {
        return null;
    }

    /**
     * The tags to use with this crawler.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-crawler.html#cfn-glue-crawler-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-crawler.html#cfn-glue-crawler-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnCrawlerProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnCrawlerProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnCrawlerProps> {
        java.lang.String role;
        java.lang.Object targets;
        java.util.List<java.lang.String> classifiers;
        java.lang.String configuration;
        java.lang.String crawlerSecurityConfiguration;
        java.lang.String databaseName;
        java.lang.String description;
        java.lang.Object lakeFormationConfiguration;
        java.lang.String name;
        java.lang.Object recrawlPolicy;
        java.lang.Object schedule;
        java.lang.Object schemaChangePolicy;
        java.lang.String tablePrefix;
        java.lang.Object tags;

        /**
         * Sets the value of {@link CfnCrawlerProps#getRole}
         * @param role The Amazon Resource Name (ARN) of an IAM role that's used to access customer resources, such as Amazon Simple Storage Service (Amazon S3) data. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder role(java.lang.String role) {
            this.role = role;
            return this;
        }

        /**
         * Sets the value of {@link CfnCrawlerProps#getTargets}
         * @param targets A collection of targets to crawl. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder targets(software.amazon.awscdk.IResolvable targets) {
            this.targets = targets;
            return this;
        }

        /**
         * Sets the value of {@link CfnCrawlerProps#getTargets}
         * @param targets A collection of targets to crawl. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder targets(software.amazon.awscdk.services.glue.CfnCrawler.TargetsProperty targets) {
            this.targets = targets;
            return this;
        }

        /**
         * Sets the value of {@link CfnCrawlerProps#getClassifiers}
         * @param classifiers A list of UTF-8 strings that specify the names of custom classifiers that are associated with the crawler.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder classifiers(java.util.List<java.lang.String> classifiers) {
            this.classifiers = classifiers;
            return this;
        }

        /**
         * Sets the value of {@link CfnCrawlerProps#getConfiguration}
         * @param configuration Crawler configuration information.
         *                      This versioned JSON string allows users to specify aspects of a crawler's behavior. For more information, see <a href="https://docs.aws.amazon.com/glue/latest/dg/crawler-configuration.html">Configuring a Crawler</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder configuration(java.lang.String configuration) {
            this.configuration = configuration;
            return this;
        }

        /**
         * Sets the value of {@link CfnCrawlerProps#getCrawlerSecurityConfiguration}
         * @param crawlerSecurityConfiguration The name of the <code>SecurityConfiguration</code> structure to be used by this crawler.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder crawlerSecurityConfiguration(java.lang.String crawlerSecurityConfiguration) {
            this.crawlerSecurityConfiguration = crawlerSecurityConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnCrawlerProps#getDatabaseName}
         * @param databaseName The name of the database in which the crawler's output is stored.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder databaseName(java.lang.String databaseName) {
            this.databaseName = databaseName;
            return this;
        }

        /**
         * Sets the value of {@link CfnCrawlerProps#getDescription}
         * @param description A description of the crawler.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link CfnCrawlerProps#getLakeFormationConfiguration}
         * @param lakeFormationConfiguration Specifies whether the crawler should use AWS Lake Formation credentials for the crawler instead of the IAM role credentials.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder lakeFormationConfiguration(software.amazon.awscdk.IResolvable lakeFormationConfiguration) {
            this.lakeFormationConfiguration = lakeFormationConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnCrawlerProps#getLakeFormationConfiguration}
         * @param lakeFormationConfiguration Specifies whether the crawler should use AWS Lake Formation credentials for the crawler instead of the IAM role credentials.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder lakeFormationConfiguration(software.amazon.awscdk.services.glue.CfnCrawler.LakeFormationConfigurationProperty lakeFormationConfiguration) {
            this.lakeFormationConfiguration = lakeFormationConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnCrawlerProps#getName}
         * @param name The name of the crawler.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of {@link CfnCrawlerProps#getRecrawlPolicy}
         * @param recrawlPolicy A policy that specifies whether to crawl the entire dataset again, or to crawl only folders that were added since the last crawler run.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder recrawlPolicy(software.amazon.awscdk.IResolvable recrawlPolicy) {
            this.recrawlPolicy = recrawlPolicy;
            return this;
        }

        /**
         * Sets the value of {@link CfnCrawlerProps#getRecrawlPolicy}
         * @param recrawlPolicy A policy that specifies whether to crawl the entire dataset again, or to crawl only folders that were added since the last crawler run.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder recrawlPolicy(software.amazon.awscdk.services.glue.CfnCrawler.RecrawlPolicyProperty recrawlPolicy) {
            this.recrawlPolicy = recrawlPolicy;
            return this;
        }

        /**
         * Sets the value of {@link CfnCrawlerProps#getSchedule}
         * @param schedule For scheduled crawlers, the schedule when the crawler runs.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder schedule(software.amazon.awscdk.IResolvable schedule) {
            this.schedule = schedule;
            return this;
        }

        /**
         * Sets the value of {@link CfnCrawlerProps#getSchedule}
         * @param schedule For scheduled crawlers, the schedule when the crawler runs.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder schedule(software.amazon.awscdk.services.glue.CfnCrawler.ScheduleProperty schedule) {
            this.schedule = schedule;
            return this;
        }

        /**
         * Sets the value of {@link CfnCrawlerProps#getSchemaChangePolicy}
         * @param schemaChangePolicy The policy that specifies update and delete behaviors for the crawler.
         *                           The policy tells the crawler what to do in the event that it detects a change in a table that already exists in the customer's database at the time of the crawl. The <code>SchemaChangePolicy</code> does not affect whether or how new tables and partitions are added. New tables and partitions are always created regardless of the <code>SchemaChangePolicy</code> on a crawler.
         *                           <p>
         *                           The SchemaChangePolicy consists of two components, <code>UpdateBehavior</code> and <code>DeleteBehavior</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder schemaChangePolicy(software.amazon.awscdk.IResolvable schemaChangePolicy) {
            this.schemaChangePolicy = schemaChangePolicy;
            return this;
        }

        /**
         * Sets the value of {@link CfnCrawlerProps#getSchemaChangePolicy}
         * @param schemaChangePolicy The policy that specifies update and delete behaviors for the crawler.
         *                           The policy tells the crawler what to do in the event that it detects a change in a table that already exists in the customer's database at the time of the crawl. The <code>SchemaChangePolicy</code> does not affect whether or how new tables and partitions are added. New tables and partitions are always created regardless of the <code>SchemaChangePolicy</code> on a crawler.
         *                           <p>
         *                           The SchemaChangePolicy consists of two components, <code>UpdateBehavior</code> and <code>DeleteBehavior</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder schemaChangePolicy(software.amazon.awscdk.services.glue.CfnCrawler.SchemaChangePolicyProperty schemaChangePolicy) {
            this.schemaChangePolicy = schemaChangePolicy;
            return this;
        }

        /**
         * Sets the value of {@link CfnCrawlerProps#getTablePrefix}
         * @param tablePrefix The prefix added to the names of tables that are created.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tablePrefix(java.lang.String tablePrefix) {
            this.tablePrefix = tablePrefix;
            return this;
        }

        /**
         * Sets the value of {@link CfnCrawlerProps#getTags}
         * @param tags The tags to use with this crawler.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(java.lang.Object tags) {
            this.tags = tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnCrawlerProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnCrawlerProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnCrawlerProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnCrawlerProps {
        private final java.lang.String role;
        private final java.lang.Object targets;
        private final java.util.List<java.lang.String> classifiers;
        private final java.lang.String configuration;
        private final java.lang.String crawlerSecurityConfiguration;
        private final java.lang.String databaseName;
        private final java.lang.String description;
        private final java.lang.Object lakeFormationConfiguration;
        private final java.lang.String name;
        private final java.lang.Object recrawlPolicy;
        private final java.lang.Object schedule;
        private final java.lang.Object schemaChangePolicy;
        private final java.lang.String tablePrefix;
        private final java.lang.Object tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.role = software.amazon.jsii.Kernel.get(this, "role", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.targets = software.amazon.jsii.Kernel.get(this, "targets", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.classifiers = software.amazon.jsii.Kernel.get(this, "classifiers", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.configuration = software.amazon.jsii.Kernel.get(this, "configuration", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.crawlerSecurityConfiguration = software.amazon.jsii.Kernel.get(this, "crawlerSecurityConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.databaseName = software.amazon.jsii.Kernel.get(this, "databaseName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.lakeFormationConfiguration = software.amazon.jsii.Kernel.get(this, "lakeFormationConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.recrawlPolicy = software.amazon.jsii.Kernel.get(this, "recrawlPolicy", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.schedule = software.amazon.jsii.Kernel.get(this, "schedule", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.schemaChangePolicy = software.amazon.jsii.Kernel.get(this, "schemaChangePolicy", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.tablePrefix = software.amazon.jsii.Kernel.get(this, "tablePrefix", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.role = java.util.Objects.requireNonNull(builder.role, "role is required");
            this.targets = java.util.Objects.requireNonNull(builder.targets, "targets is required");
            this.classifiers = builder.classifiers;
            this.configuration = builder.configuration;
            this.crawlerSecurityConfiguration = builder.crawlerSecurityConfiguration;
            this.databaseName = builder.databaseName;
            this.description = builder.description;
            this.lakeFormationConfiguration = builder.lakeFormationConfiguration;
            this.name = builder.name;
            this.recrawlPolicy = builder.recrawlPolicy;
            this.schedule = builder.schedule;
            this.schemaChangePolicy = builder.schemaChangePolicy;
            this.tablePrefix = builder.tablePrefix;
            this.tags = builder.tags;
        }

        @Override
        public final java.lang.String getRole() {
            return this.role;
        }

        @Override
        public final java.lang.Object getTargets() {
            return this.targets;
        }

        @Override
        public final java.util.List<java.lang.String> getClassifiers() {
            return this.classifiers;
        }

        @Override
        public final java.lang.String getConfiguration() {
            return this.configuration;
        }

        @Override
        public final java.lang.String getCrawlerSecurityConfiguration() {
            return this.crawlerSecurityConfiguration;
        }

        @Override
        public final java.lang.String getDatabaseName() {
            return this.databaseName;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public final java.lang.Object getLakeFormationConfiguration() {
            return this.lakeFormationConfiguration;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        public final java.lang.Object getRecrawlPolicy() {
            return this.recrawlPolicy;
        }

        @Override
        public final java.lang.Object getSchedule() {
            return this.schedule;
        }

        @Override
        public final java.lang.Object getSchemaChangePolicy() {
            return this.schemaChangePolicy;
        }

        @Override
        public final java.lang.String getTablePrefix() {
            return this.tablePrefix;
        }

        @Override
        public final java.lang.Object getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("role", om.valueToTree(this.getRole()));
            data.set("targets", om.valueToTree(this.getTargets()));
            if (this.getClassifiers() != null) {
                data.set("classifiers", om.valueToTree(this.getClassifiers()));
            }
            if (this.getConfiguration() != null) {
                data.set("configuration", om.valueToTree(this.getConfiguration()));
            }
            if (this.getCrawlerSecurityConfiguration() != null) {
                data.set("crawlerSecurityConfiguration", om.valueToTree(this.getCrawlerSecurityConfiguration()));
            }
            if (this.getDatabaseName() != null) {
                data.set("databaseName", om.valueToTree(this.getDatabaseName()));
            }
            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getLakeFormationConfiguration() != null) {
                data.set("lakeFormationConfiguration", om.valueToTree(this.getLakeFormationConfiguration()));
            }
            if (this.getName() != null) {
                data.set("name", om.valueToTree(this.getName()));
            }
            if (this.getRecrawlPolicy() != null) {
                data.set("recrawlPolicy", om.valueToTree(this.getRecrawlPolicy()));
            }
            if (this.getSchedule() != null) {
                data.set("schedule", om.valueToTree(this.getSchedule()));
            }
            if (this.getSchemaChangePolicy() != null) {
                data.set("schemaChangePolicy", om.valueToTree(this.getSchemaChangePolicy()));
            }
            if (this.getTablePrefix() != null) {
                data.set("tablePrefix", om.valueToTree(this.getTablePrefix()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_glue.CfnCrawlerProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnCrawlerProps.Jsii$Proxy that = (CfnCrawlerProps.Jsii$Proxy) o;

            if (!role.equals(that.role)) return false;
            if (!targets.equals(that.targets)) return false;
            if (this.classifiers != null ? !this.classifiers.equals(that.classifiers) : that.classifiers != null) return false;
            if (this.configuration != null ? !this.configuration.equals(that.configuration) : that.configuration != null) return false;
            if (this.crawlerSecurityConfiguration != null ? !this.crawlerSecurityConfiguration.equals(that.crawlerSecurityConfiguration) : that.crawlerSecurityConfiguration != null) return false;
            if (this.databaseName != null ? !this.databaseName.equals(that.databaseName) : that.databaseName != null) return false;
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            if (this.lakeFormationConfiguration != null ? !this.lakeFormationConfiguration.equals(that.lakeFormationConfiguration) : that.lakeFormationConfiguration != null) return false;
            if (this.name != null ? !this.name.equals(that.name) : that.name != null) return false;
            if (this.recrawlPolicy != null ? !this.recrawlPolicy.equals(that.recrawlPolicy) : that.recrawlPolicy != null) return false;
            if (this.schedule != null ? !this.schedule.equals(that.schedule) : that.schedule != null) return false;
            if (this.schemaChangePolicy != null ? !this.schemaChangePolicy.equals(that.schemaChangePolicy) : that.schemaChangePolicy != null) return false;
            if (this.tablePrefix != null ? !this.tablePrefix.equals(that.tablePrefix) : that.tablePrefix != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.role.hashCode();
            result = 31 * result + (this.targets.hashCode());
            result = 31 * result + (this.classifiers != null ? this.classifiers.hashCode() : 0);
            result = 31 * result + (this.configuration != null ? this.configuration.hashCode() : 0);
            result = 31 * result + (this.crawlerSecurityConfiguration != null ? this.crawlerSecurityConfiguration.hashCode() : 0);
            result = 31 * result + (this.databaseName != null ? this.databaseName.hashCode() : 0);
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            result = 31 * result + (this.lakeFormationConfiguration != null ? this.lakeFormationConfiguration.hashCode() : 0);
            result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
            result = 31 * result + (this.recrawlPolicy != null ? this.recrawlPolicy.hashCode() : 0);
            result = 31 * result + (this.schedule != null ? this.schedule.hashCode() : 0);
            result = 31 * result + (this.schemaChangePolicy != null ? this.schemaChangePolicy.hashCode() : 0);
            result = 31 * result + (this.tablePrefix != null ? this.tablePrefix.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
