package software.amazon.awscdk.services.iam;

/**
 * A type of principal that has more control over its own representation in AssumeRolePolicyDocuments.
 * <p>
 * More complex types of identity providers need more control over Role's policy documents
 * than simply <code>{ Effect: 'Allow', Action: 'AssumeRole', Principal: &lt;Whatever&gt; }</code>.
 * <p>
 * If that control is necessary, they can implement <code>IAssumeRolePrincipal</code> to get full
 * access to a Role's AssumeRolePolicyDocument.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-01-25T00:20:56.729Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iam.IAssumeRolePrincipal")
@software.amazon.jsii.Jsii.Proxy(IAssumeRolePrincipal.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface IAssumeRolePrincipal extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.iam.IPrincipal {

    /**
     * Add the principal to the AssumeRolePolicyDocument.
     * <p>
     * Add the statements to the AssumeRolePolicyDocument necessary to give this principal
     * permissions to assume the given role.
     * <p>
     * @param document This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    void addToAssumeRolePolicy(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.PolicyDocument document);

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.iam.IAssumeRolePrincipal.Jsii$Default {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
        }

        /**
         * The principal to grant permissions to.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IPrincipal getGrantPrincipal() {
            return software.amazon.jsii.Kernel.get(this, "grantPrincipal", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IPrincipal.class));
        }

        /**
         * When this Principal is used in an AssumeRole policy, the action to use.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.NotNull java.lang.String getAssumeRoleAction() {
            return software.amazon.jsii.Kernel.get(this, "assumeRoleAction", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Return the policy fragment that identifies this principal in a Policy.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.PrincipalPolicyFragment getPolicyFragment() {
            return software.amazon.jsii.Kernel.get(this, "policyFragment", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.PrincipalPolicyFragment.class));
        }

        /**
         * The AWS account ID of this principal.
         * <p>
         * Can be undefined when the account is not known
         * (for example, for service principals).
         * Can be a Token - in that case,
         * it's assumed to be AWS::AccountId.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.Nullable java.lang.String getPrincipalAccount() {
            return software.amazon.jsii.Kernel.get(this, "principalAccount", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Add to the policy of this principal.
         * <p>
         * @param statement This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.AddToPrincipalPolicyResult addToPrincipalPolicy(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.PolicyStatement statement) {
            return software.amazon.jsii.Kernel.call(this, "addToPrincipalPolicy", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.AddToPrincipalPolicyResult.class), new Object[] { java.util.Objects.requireNonNull(statement, "statement is required") });
        }

        /**
         * Add the principal to the AssumeRolePolicyDocument.
         * <p>
         * Add the statements to the AssumeRolePolicyDocument necessary to give this principal
         * permissions to assume the given role.
         * <p>
         * @param document This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final void addToAssumeRolePolicy(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.PolicyDocument document) {
            software.amazon.jsii.Kernel.call(this, "addToAssumeRolePolicy", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(document, "document is required") });
        }
    }

    /**
     * Internal default implementation for {@link IAssumeRolePrincipal}.
     */
    @software.amazon.jsii.Internal
    interface Jsii$Default extends IAssumeRolePrincipal, software.amazon.awscdk.services.iam.IPrincipal.Jsii$Default {

        /**
         * The principal to grant permissions to.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IPrincipal getGrantPrincipal() {
            return software.amazon.jsii.Kernel.get(this, "grantPrincipal", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IPrincipal.class));
        }

        /**
         * When this Principal is used in an AssumeRole policy, the action to use.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.NotNull java.lang.String getAssumeRoleAction() {
            return software.amazon.jsii.Kernel.get(this, "assumeRoleAction", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Return the policy fragment that identifies this principal in a Policy.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.PrincipalPolicyFragment getPolicyFragment() {
            return software.amazon.jsii.Kernel.get(this, "policyFragment", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.PrincipalPolicyFragment.class));
        }

        /**
         * The AWS account ID of this principal.
         * <p>
         * Can be undefined when the account is not known
         * (for example, for service principals).
         * Can be a Token - in that case,
         * it's assumed to be AWS::AccountId.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getPrincipalAccount() {
            return software.amazon.jsii.Kernel.get(this, "principalAccount", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Add to the policy of this principal.
         * <p>
         * @param statement This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        default @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.AddToPrincipalPolicyResult addToPrincipalPolicy(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.PolicyStatement statement) {
            return software.amazon.jsii.Kernel.call(this, "addToPrincipalPolicy", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.AddToPrincipalPolicyResult.class), new Object[] { java.util.Objects.requireNonNull(statement, "statement is required") });
        }

        /**
         * Add the principal to the AssumeRolePolicyDocument.
         * <p>
         * Add the statements to the AssumeRolePolicyDocument necessary to give this principal
         * permissions to assume the given role.
         * <p>
         * @param document This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        default void addToAssumeRolePolicy(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.PolicyDocument document) {
            software.amazon.jsii.Kernel.call(this, "addToAssumeRolePolicy", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(document, "document is required") });
        }
    }
}
