package software.amazon.awscdk.services.iot;

/**
 * Properties for defining a <code>CfnDomainConfiguration</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.iot.*;
 * CfnDomainConfigurationProps cfnDomainConfigurationProps = CfnDomainConfigurationProps.builder()
 *         .applicationProtocol("applicationProtocol")
 *         .authenticationType("authenticationType")
 *         .authorizerConfig(AuthorizerConfigProperty.builder()
 *                 .allowAuthorizerOverride(false)
 *                 .defaultAuthorizerName("defaultAuthorizerName")
 *                 .build())
 *         .clientCertificateConfig(ClientCertificateConfigProperty.builder()
 *                 .clientCertificateCallbackArn("clientCertificateCallbackArn")
 *                 .build())
 *         .domainConfigurationName("domainConfigurationName")
 *         .domainConfigurationStatus("domainConfigurationStatus")
 *         .domainName("domainName")
 *         .serverCertificateArns(List.of("serverCertificateArns"))
 *         .serverCertificateConfig(ServerCertificateConfigProperty.builder()
 *                 .enableOcspCheck(false)
 *                 .ocspAuthorizedResponderArn("ocspAuthorizedResponderArn")
 *                 .ocspLambdaArn("ocspLambdaArn")
 *                 .build())
 *         .serviceType("serviceType")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .tlsConfig(TlsConfigProperty.builder()
 *                 .securityPolicy("securityPolicy")
 *                 .build())
 *         .validationCertificateArn("validationCertificateArn")
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-domainconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-domainconfiguration.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-01-25T00:20:56.921Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iot.CfnDomainConfigurationProps")
@software.amazon.jsii.Jsii.Proxy(CfnDomainConfigurationProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnDomainConfigurationProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * An enumerated string that speciﬁes the application-layer protocol.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-domainconfiguration.html#cfn-iot-domainconfiguration-applicationprotocol">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-domainconfiguration.html#cfn-iot-domainconfiguration-applicationprotocol</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getApplicationProtocol() {
        return null;
    }

    /**
     * An enumerated string that speciﬁes the authentication type.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-domainconfiguration.html#cfn-iot-domainconfiguration-authenticationtype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-domainconfiguration.html#cfn-iot-domainconfiguration-authenticationtype</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getAuthenticationType() {
        return null;
    }

    /**
     * An object that specifies the authorization service for a domain.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-domainconfiguration.html#cfn-iot-domainconfiguration-authorizerconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-domainconfiguration.html#cfn-iot-domainconfiguration-authorizerconfig</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getAuthorizerConfig() {
        return null;
    }

    /**
     * An object that speciﬁes the client certificate conﬁguration for a domain.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-domainconfiguration.html#cfn-iot-domainconfiguration-clientcertificateconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-domainconfiguration.html#cfn-iot-domainconfiguration-clientcertificateconfig</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getClientCertificateConfig() {
        return null;
    }

    /**
     * The name of the domain configuration.
     * <p>
     * This value must be unique to a region.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-domainconfiguration.html#cfn-iot-domainconfiguration-domainconfigurationname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-domainconfiguration.html#cfn-iot-domainconfiguration-domainconfigurationname</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDomainConfigurationName() {
        return null;
    }

    /**
     * The status to which the domain configuration should be updated.
     * <p>
     * Valid values: <code>ENABLED</code> | <code>DISABLED</code>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-domainconfiguration.html#cfn-iot-domainconfiguration-domainconfigurationstatus">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-domainconfiguration.html#cfn-iot-domainconfiguration-domainconfigurationstatus</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDomainConfigurationStatus() {
        return null;
    }

    /**
     * The name of the domain.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-domainconfiguration.html#cfn-iot-domainconfiguration-domainname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-domainconfiguration.html#cfn-iot-domainconfiguration-domainname</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDomainName() {
        return null;
    }

    /**
     * The ARNs of the certificates that AWS IoT passes to the device during the TLS handshake.
     * <p>
     * Currently you can specify only one certificate ARN. This value is not required for AWS -managed domains.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-domainconfiguration.html#cfn-iot-domainconfiguration-servercertificatearns">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-domainconfiguration.html#cfn-iot-domainconfiguration-servercertificatearns</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getServerCertificateArns() {
        return null;
    }

    /**
     * The server certificate configuration.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com//iot/latest/developerguide/iot-custom-endpoints-configurable.html">Configurable endpoints</a> from the AWS IoT Core Developer Guide.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-domainconfiguration.html#cfn-iot-domainconfiguration-servercertificateconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-domainconfiguration.html#cfn-iot-domainconfiguration-servercertificateconfig</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getServerCertificateConfig() {
        return null;
    }

    /**
     * The type of service delivered by the endpoint.
     * <p>
     * <blockquote>
     * <p>
     * AWS IoT Core currently supports only the <code>DATA</code> service type.
     * <p>
     * </blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-domainconfiguration.html#cfn-iot-domainconfiguration-servicetype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-domainconfiguration.html#cfn-iot-domainconfiguration-servicetype</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getServiceType() {
        return null;
    }

    /**
     * Metadata which can be used to manage the domain configuration.
     * <p>
     * <blockquote>
     * <p>
     * For URI Request parameters use format: ...key1=value1&amp;key2=value2...
     * <p>
     * For the CLI command-line parameter use format: &amp;&amp;tags "key1=value1&amp;key2=value2..."
     * <p>
     * For the cli-input-json file use format: "tags": "key1=value1&amp;key2=value2..."
     * <p>
     * </blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-domainconfiguration.html#cfn-iot-domainconfiguration-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-domainconfiguration.html#cfn-iot-domainconfiguration-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * An object that specifies the TLS configuration for a domain.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-domainconfiguration.html#cfn-iot-domainconfiguration-tlsconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-domainconfiguration.html#cfn-iot-domainconfiguration-tlsconfig</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getTlsConfig() {
        return null;
    }

    /**
     * The certificate used to validate the server certificate and prove domain name ownership.
     * <p>
     * This certificate must be signed by a public certificate authority. This value is not required for AWS -managed domains.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-domainconfiguration.html#cfn-iot-domainconfiguration-validationcertificatearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-domainconfiguration.html#cfn-iot-domainconfiguration-validationcertificatearn</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getValidationCertificateArn() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnDomainConfigurationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnDomainConfigurationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnDomainConfigurationProps> {
        java.lang.String applicationProtocol;
        java.lang.String authenticationType;
        java.lang.Object authorizerConfig;
        java.lang.Object clientCertificateConfig;
        java.lang.String domainConfigurationName;
        java.lang.String domainConfigurationStatus;
        java.lang.String domainName;
        java.util.List<java.lang.String> serverCertificateArns;
        java.lang.Object serverCertificateConfig;
        java.lang.String serviceType;
        java.util.List<software.amazon.awscdk.CfnTag> tags;
        java.lang.Object tlsConfig;
        java.lang.String validationCertificateArn;

        /**
         * Sets the value of {@link CfnDomainConfigurationProps#getApplicationProtocol}
         * @param applicationProtocol An enumerated string that speciﬁes the application-layer protocol.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder applicationProtocol(java.lang.String applicationProtocol) {
            this.applicationProtocol = applicationProtocol;
            return this;
        }

        /**
         * Sets the value of {@link CfnDomainConfigurationProps#getAuthenticationType}
         * @param authenticationType An enumerated string that speciﬁes the authentication type.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder authenticationType(java.lang.String authenticationType) {
            this.authenticationType = authenticationType;
            return this;
        }

        /**
         * Sets the value of {@link CfnDomainConfigurationProps#getAuthorizerConfig}
         * @param authorizerConfig An object that specifies the authorization service for a domain.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder authorizerConfig(software.amazon.awscdk.IResolvable authorizerConfig) {
            this.authorizerConfig = authorizerConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnDomainConfigurationProps#getAuthorizerConfig}
         * @param authorizerConfig An object that specifies the authorization service for a domain.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder authorizerConfig(software.amazon.awscdk.services.iot.CfnDomainConfiguration.AuthorizerConfigProperty authorizerConfig) {
            this.authorizerConfig = authorizerConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnDomainConfigurationProps#getClientCertificateConfig}
         * @param clientCertificateConfig An object that speciﬁes the client certificate conﬁguration for a domain.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder clientCertificateConfig(software.amazon.awscdk.IResolvable clientCertificateConfig) {
            this.clientCertificateConfig = clientCertificateConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnDomainConfigurationProps#getClientCertificateConfig}
         * @param clientCertificateConfig An object that speciﬁes the client certificate conﬁguration for a domain.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder clientCertificateConfig(software.amazon.awscdk.services.iot.CfnDomainConfiguration.ClientCertificateConfigProperty clientCertificateConfig) {
            this.clientCertificateConfig = clientCertificateConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnDomainConfigurationProps#getDomainConfigurationName}
         * @param domainConfigurationName The name of the domain configuration.
         *                                This value must be unique to a region.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder domainConfigurationName(java.lang.String domainConfigurationName) {
            this.domainConfigurationName = domainConfigurationName;
            return this;
        }

        /**
         * Sets the value of {@link CfnDomainConfigurationProps#getDomainConfigurationStatus}
         * @param domainConfigurationStatus The status to which the domain configuration should be updated.
         *                                  Valid values: <code>ENABLED</code> | <code>DISABLED</code>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder domainConfigurationStatus(java.lang.String domainConfigurationStatus) {
            this.domainConfigurationStatus = domainConfigurationStatus;
            return this;
        }

        /**
         * Sets the value of {@link CfnDomainConfigurationProps#getDomainName}
         * @param domainName The name of the domain.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder domainName(java.lang.String domainName) {
            this.domainName = domainName;
            return this;
        }

        /**
         * Sets the value of {@link CfnDomainConfigurationProps#getServerCertificateArns}
         * @param serverCertificateArns The ARNs of the certificates that AWS IoT passes to the device during the TLS handshake.
         *                              Currently you can specify only one certificate ARN. This value is not required for AWS -managed domains.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder serverCertificateArns(java.util.List<java.lang.String> serverCertificateArns) {
            this.serverCertificateArns = serverCertificateArns;
            return this;
        }

        /**
         * Sets the value of {@link CfnDomainConfigurationProps#getServerCertificateConfig}
         * @param serverCertificateConfig The server certificate configuration.
         *                                For more information, see <a href="https://docs.aws.amazon.com//iot/latest/developerguide/iot-custom-endpoints-configurable.html">Configurable endpoints</a> from the AWS IoT Core Developer Guide.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder serverCertificateConfig(software.amazon.awscdk.IResolvable serverCertificateConfig) {
            this.serverCertificateConfig = serverCertificateConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnDomainConfigurationProps#getServerCertificateConfig}
         * @param serverCertificateConfig The server certificate configuration.
         *                                For more information, see <a href="https://docs.aws.amazon.com//iot/latest/developerguide/iot-custom-endpoints-configurable.html">Configurable endpoints</a> from the AWS IoT Core Developer Guide.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder serverCertificateConfig(software.amazon.awscdk.services.iot.CfnDomainConfiguration.ServerCertificateConfigProperty serverCertificateConfig) {
            this.serverCertificateConfig = serverCertificateConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnDomainConfigurationProps#getServiceType}
         * @param serviceType The type of service delivered by the endpoint.
         *                    <blockquote>
         *                    <p>
         *                    AWS IoT Core currently supports only the <code>DATA</code> service type.
         *                    <p>
         *                    </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder serviceType(java.lang.String serviceType) {
            this.serviceType = serviceType;
            return this;
        }

        /**
         * Sets the value of {@link CfnDomainConfigurationProps#getTags}
         * @param tags Metadata which can be used to manage the domain configuration.
         *             <blockquote>
         *             <p>
         *             For URI Request parameters use format: ...key1=value1&amp;key2=value2...
         *             <p>
         *             For the CLI command-line parameter use format: &amp;&amp;tags "key1=value1&amp;key2=value2..."
         *             <p>
         *             For the cli-input-json file use format: "tags": "key1=value1&amp;key2=value2..."
         *             <p>
         *             </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Sets the value of {@link CfnDomainConfigurationProps#getTlsConfig}
         * @param tlsConfig An object that specifies the TLS configuration for a domain.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tlsConfig(software.amazon.awscdk.IResolvable tlsConfig) {
            this.tlsConfig = tlsConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnDomainConfigurationProps#getTlsConfig}
         * @param tlsConfig An object that specifies the TLS configuration for a domain.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tlsConfig(software.amazon.awscdk.services.iot.CfnDomainConfiguration.TlsConfigProperty tlsConfig) {
            this.tlsConfig = tlsConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnDomainConfigurationProps#getValidationCertificateArn}
         * @param validationCertificateArn The certificate used to validate the server certificate and prove domain name ownership.
         *                                 This certificate must be signed by a public certificate authority. This value is not required for AWS -managed domains.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder validationCertificateArn(java.lang.String validationCertificateArn) {
            this.validationCertificateArn = validationCertificateArn;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnDomainConfigurationProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnDomainConfigurationProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnDomainConfigurationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnDomainConfigurationProps {
        private final java.lang.String applicationProtocol;
        private final java.lang.String authenticationType;
        private final java.lang.Object authorizerConfig;
        private final java.lang.Object clientCertificateConfig;
        private final java.lang.String domainConfigurationName;
        private final java.lang.String domainConfigurationStatus;
        private final java.lang.String domainName;
        private final java.util.List<java.lang.String> serverCertificateArns;
        private final java.lang.Object serverCertificateConfig;
        private final java.lang.String serviceType;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;
        private final java.lang.Object tlsConfig;
        private final java.lang.String validationCertificateArn;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.applicationProtocol = software.amazon.jsii.Kernel.get(this, "applicationProtocol", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.authenticationType = software.amazon.jsii.Kernel.get(this, "authenticationType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.authorizerConfig = software.amazon.jsii.Kernel.get(this, "authorizerConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.clientCertificateConfig = software.amazon.jsii.Kernel.get(this, "clientCertificateConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.domainConfigurationName = software.amazon.jsii.Kernel.get(this, "domainConfigurationName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.domainConfigurationStatus = software.amazon.jsii.Kernel.get(this, "domainConfigurationStatus", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.domainName = software.amazon.jsii.Kernel.get(this, "domainName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.serverCertificateArns = software.amazon.jsii.Kernel.get(this, "serverCertificateArns", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.serverCertificateConfig = software.amazon.jsii.Kernel.get(this, "serverCertificateConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.serviceType = software.amazon.jsii.Kernel.get(this, "serviceType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
            this.tlsConfig = software.amazon.jsii.Kernel.get(this, "tlsConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.validationCertificateArn = software.amazon.jsii.Kernel.get(this, "validationCertificateArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.applicationProtocol = builder.applicationProtocol;
            this.authenticationType = builder.authenticationType;
            this.authorizerConfig = builder.authorizerConfig;
            this.clientCertificateConfig = builder.clientCertificateConfig;
            this.domainConfigurationName = builder.domainConfigurationName;
            this.domainConfigurationStatus = builder.domainConfigurationStatus;
            this.domainName = builder.domainName;
            this.serverCertificateArns = builder.serverCertificateArns;
            this.serverCertificateConfig = builder.serverCertificateConfig;
            this.serviceType = builder.serviceType;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
            this.tlsConfig = builder.tlsConfig;
            this.validationCertificateArn = builder.validationCertificateArn;
        }

        @Override
        public final java.lang.String getApplicationProtocol() {
            return this.applicationProtocol;
        }

        @Override
        public final java.lang.String getAuthenticationType() {
            return this.authenticationType;
        }

        @Override
        public final java.lang.Object getAuthorizerConfig() {
            return this.authorizerConfig;
        }

        @Override
        public final java.lang.Object getClientCertificateConfig() {
            return this.clientCertificateConfig;
        }

        @Override
        public final java.lang.String getDomainConfigurationName() {
            return this.domainConfigurationName;
        }

        @Override
        public final java.lang.String getDomainConfigurationStatus() {
            return this.domainConfigurationStatus;
        }

        @Override
        public final java.lang.String getDomainName() {
            return this.domainName;
        }

        @Override
        public final java.util.List<java.lang.String> getServerCertificateArns() {
            return this.serverCertificateArns;
        }

        @Override
        public final java.lang.Object getServerCertificateConfig() {
            return this.serverCertificateConfig;
        }

        @Override
        public final java.lang.String getServiceType() {
            return this.serviceType;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        public final java.lang.Object getTlsConfig() {
            return this.tlsConfig;
        }

        @Override
        public final java.lang.String getValidationCertificateArn() {
            return this.validationCertificateArn;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getApplicationProtocol() != null) {
                data.set("applicationProtocol", om.valueToTree(this.getApplicationProtocol()));
            }
            if (this.getAuthenticationType() != null) {
                data.set("authenticationType", om.valueToTree(this.getAuthenticationType()));
            }
            if (this.getAuthorizerConfig() != null) {
                data.set("authorizerConfig", om.valueToTree(this.getAuthorizerConfig()));
            }
            if (this.getClientCertificateConfig() != null) {
                data.set("clientCertificateConfig", om.valueToTree(this.getClientCertificateConfig()));
            }
            if (this.getDomainConfigurationName() != null) {
                data.set("domainConfigurationName", om.valueToTree(this.getDomainConfigurationName()));
            }
            if (this.getDomainConfigurationStatus() != null) {
                data.set("domainConfigurationStatus", om.valueToTree(this.getDomainConfigurationStatus()));
            }
            if (this.getDomainName() != null) {
                data.set("domainName", om.valueToTree(this.getDomainName()));
            }
            if (this.getServerCertificateArns() != null) {
                data.set("serverCertificateArns", om.valueToTree(this.getServerCertificateArns()));
            }
            if (this.getServerCertificateConfig() != null) {
                data.set("serverCertificateConfig", om.valueToTree(this.getServerCertificateConfig()));
            }
            if (this.getServiceType() != null) {
                data.set("serviceType", om.valueToTree(this.getServiceType()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }
            if (this.getTlsConfig() != null) {
                data.set("tlsConfig", om.valueToTree(this.getTlsConfig()));
            }
            if (this.getValidationCertificateArn() != null) {
                data.set("validationCertificateArn", om.valueToTree(this.getValidationCertificateArn()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iot.CfnDomainConfigurationProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnDomainConfigurationProps.Jsii$Proxy that = (CfnDomainConfigurationProps.Jsii$Proxy) o;

            if (this.applicationProtocol != null ? !this.applicationProtocol.equals(that.applicationProtocol) : that.applicationProtocol != null) return false;
            if (this.authenticationType != null ? !this.authenticationType.equals(that.authenticationType) : that.authenticationType != null) return false;
            if (this.authorizerConfig != null ? !this.authorizerConfig.equals(that.authorizerConfig) : that.authorizerConfig != null) return false;
            if (this.clientCertificateConfig != null ? !this.clientCertificateConfig.equals(that.clientCertificateConfig) : that.clientCertificateConfig != null) return false;
            if (this.domainConfigurationName != null ? !this.domainConfigurationName.equals(that.domainConfigurationName) : that.domainConfigurationName != null) return false;
            if (this.domainConfigurationStatus != null ? !this.domainConfigurationStatus.equals(that.domainConfigurationStatus) : that.domainConfigurationStatus != null) return false;
            if (this.domainName != null ? !this.domainName.equals(that.domainName) : that.domainName != null) return false;
            if (this.serverCertificateArns != null ? !this.serverCertificateArns.equals(that.serverCertificateArns) : that.serverCertificateArns != null) return false;
            if (this.serverCertificateConfig != null ? !this.serverCertificateConfig.equals(that.serverCertificateConfig) : that.serverCertificateConfig != null) return false;
            if (this.serviceType != null ? !this.serviceType.equals(that.serviceType) : that.serviceType != null) return false;
            if (this.tags != null ? !this.tags.equals(that.tags) : that.tags != null) return false;
            if (this.tlsConfig != null ? !this.tlsConfig.equals(that.tlsConfig) : that.tlsConfig != null) return false;
            return this.validationCertificateArn != null ? this.validationCertificateArn.equals(that.validationCertificateArn) : that.validationCertificateArn == null;
        }

        @Override
        public final int hashCode() {
            int result = this.applicationProtocol != null ? this.applicationProtocol.hashCode() : 0;
            result = 31 * result + (this.authenticationType != null ? this.authenticationType.hashCode() : 0);
            result = 31 * result + (this.authorizerConfig != null ? this.authorizerConfig.hashCode() : 0);
            result = 31 * result + (this.clientCertificateConfig != null ? this.clientCertificateConfig.hashCode() : 0);
            result = 31 * result + (this.domainConfigurationName != null ? this.domainConfigurationName.hashCode() : 0);
            result = 31 * result + (this.domainConfigurationStatus != null ? this.domainConfigurationStatus.hashCode() : 0);
            result = 31 * result + (this.domainName != null ? this.domainName.hashCode() : 0);
            result = 31 * result + (this.serverCertificateArns != null ? this.serverCertificateArns.hashCode() : 0);
            result = 31 * result + (this.serverCertificateConfig != null ? this.serverCertificateConfig.hashCode() : 0);
            result = 31 * result + (this.serviceType != null ? this.serviceType.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            result = 31 * result + (this.tlsConfig != null ? this.tlsConfig.hashCode() : 0);
            result = 31 * result + (this.validationCertificateArn != null ? this.validationCertificateArn.hashCode() : 0);
            return result;
        }
    }
}
