package software.amazon.awscdk.services.iottwinmaker;

/**
 * Properties for defining a <code>CfnComponentType</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.iottwinmaker.*;
 * DataTypeProperty dataTypeProperty_;
 * DataValueProperty dataValueProperty_;
 * Object relationshipValue;
 * CfnComponentTypeProps cfnComponentTypeProps = CfnComponentTypeProps.builder()
 *         .componentTypeId("componentTypeId")
 *         .workspaceId("workspaceId")
 *         // the properties below are optional
 *         .compositeComponentTypes(Map.of(
 *                 "compositeComponentTypesKey", CompositeComponentTypeProperty.builder()
 *                         .componentTypeId("componentTypeId")
 *                         .build()))
 *         .description("description")
 *         .extendsFrom(List.of("extendsFrom"))
 *         .functions(Map.of(
 *                 "functionsKey", FunctionProperty.builder()
 *                         .implementedBy(DataConnectorProperty.builder()
 *                                 .isNative(false)
 *                                 .lambda(LambdaFunctionProperty.builder()
 *                                         .arn("arn")
 *                                         .build())
 *                                 .build())
 *                         .requiredProperties(List.of("requiredProperties"))
 *                         .scope("scope")
 *                         .build()))
 *         .isSingleton(false)
 *         .propertyDefinitions(Map.of(
 *                 "propertyDefinitionsKey", PropertyDefinitionProperty.builder()
 *                         .configurations(Map.of(
 *                                 "configurationsKey", "configurations"))
 *                         .dataType(DataTypeProperty.builder()
 *                                 .type("type")
 *                                 // the properties below are optional
 *                                 .allowedValues(List.of(DataValueProperty.builder()
 *                                         .booleanValue(false)
 *                                         .doubleValue(123)
 *                                         .expression("expression")
 *                                         .integerValue(123)
 *                                         .listValue(List.of(dataValueProperty_))
 *                                         .longValue(123)
 *                                         .mapValue(Map.of(
 *                                                 "mapValueKey", dataValueProperty_))
 *                                         .relationshipValue(relationshipValue)
 *                                         .stringValue("stringValue")
 *                                         .build()))
 *                                 .nestedType(dataTypeProperty_)
 *                                 .relationship(RelationshipProperty.builder()
 *                                         .relationshipType("relationshipType")
 *                                         .targetComponentTypeId("targetComponentTypeId")
 *                                         .build())
 *                                 .unitOfMeasure("unitOfMeasure")
 *                                 .build())
 *                         .defaultValue(DataValueProperty.builder()
 *                                 .booleanValue(false)
 *                                 .doubleValue(123)
 *                                 .expression("expression")
 *                                 .integerValue(123)
 *                                 .listValue(List.of(dataValueProperty_))
 *                                 .longValue(123)
 *                                 .mapValue(Map.of(
 *                                         "mapValueKey", dataValueProperty_))
 *                                 .relationshipValue(relationshipValue)
 *                                 .stringValue("stringValue")
 *                                 .build())
 *                         .isExternalId(false)
 *                         .isRequiredInEntity(false)
 *                         .isStoredExternally(false)
 *                         .isTimeSeries(false)
 *                         .build()))
 *         .propertyGroups(Map.of(
 *                 "propertyGroupsKey", PropertyGroupProperty.builder()
 *                         .groupType("groupType")
 *                         .propertyNames(List.of("propertyNames"))
 *                         .build()))
 *         .tags(Map.of(
 *                 "tagsKey", "tags"))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iottwinmaker-componenttype.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iottwinmaker-componenttype.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-01-25T00:20:57.249Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iottwinmaker.CfnComponentTypeProps")
@software.amazon.jsii.Jsii.Proxy(CfnComponentTypeProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnComponentTypeProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ID of the component type.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iottwinmaker-componenttype.html#cfn-iottwinmaker-componenttype-componenttypeid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iottwinmaker-componenttype.html#cfn-iottwinmaker-componenttype-componenttypeid</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getComponentTypeId();

    /**
     * The ID of the workspace that contains the component type.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iottwinmaker-componenttype.html#cfn-iottwinmaker-componenttype-workspaceid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iottwinmaker-componenttype.html#cfn-iottwinmaker-componenttype-workspaceid</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getWorkspaceId();

    /**
     * Maps strings to <code>compositeComponentTypes</code> of the <code>componentType</code> .
     * <p>
     * <code>CompositeComponentType</code> is referenced by <code>componentTypeId</code> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iottwinmaker-componenttype.html#cfn-iottwinmaker-componenttype-compositecomponenttypes">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iottwinmaker-componenttype.html#cfn-iottwinmaker-componenttype-compositecomponenttypes</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getCompositeComponentTypes() {
        return null;
    }

    /**
     * The description of the component type.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iottwinmaker-componenttype.html#cfn-iottwinmaker-componenttype-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iottwinmaker-componenttype.html#cfn-iottwinmaker-componenttype-description</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return null;
    }

    /**
     * The name of the parent component type that this component type extends.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iottwinmaker-componenttype.html#cfn-iottwinmaker-componenttype-extendsfrom">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iottwinmaker-componenttype.html#cfn-iottwinmaker-componenttype-extendsfrom</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getExtendsFrom() {
        return null;
    }

    /**
     * An object that maps strings to the functions in the component type.
     * <p>
     * Each string in the mapping must be unique to this object.
     * <p>
     * For information on the FunctionResponse object see the <a href="https://docs.aws.amazon.com//iot-twinmaker/latest/apireference/API_FunctionResponse.html">FunctionResponse</a> API reference.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iottwinmaker-componenttype.html#cfn-iottwinmaker-componenttype-functions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iottwinmaker-componenttype.html#cfn-iottwinmaker-componenttype-functions</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getFunctions() {
        return null;
    }

    /**
     * A boolean value that specifies whether an entity can have more than one component of this type.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iottwinmaker-componenttype.html#cfn-iottwinmaker-componenttype-issingleton">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iottwinmaker-componenttype.html#cfn-iottwinmaker-componenttype-issingleton</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getIsSingleton() {
        return null;
    }

    /**
     * An object that maps strings to the property definitions in the component type.
     * <p>
     * Each string in the mapping must be unique to this object.
     * <p>
     * For information about the PropertyDefinitionResponse object, see the <a href="https://docs.aws.amazon.com//iot-twinmaker/latest/apireference/API_PropertyDefinitionResponse.html">PropertyDefinitionResponse</a> API reference.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iottwinmaker-componenttype.html#cfn-iottwinmaker-componenttype-propertydefinitions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iottwinmaker-componenttype.html#cfn-iottwinmaker-componenttype-propertydefinitions</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getPropertyDefinitions() {
        return null;
    }

    /**
     * An object that maps strings to the property groups in the component type.
     * <p>
     * Each string in the mapping must be unique to this object.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iottwinmaker-componenttype.html#cfn-iottwinmaker-componenttype-propertygroups">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iottwinmaker-componenttype.html#cfn-iottwinmaker-componenttype-propertygroups</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getPropertyGroups() {
        return null;
    }

    /**
     * The ComponentType tags.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iottwinmaker-componenttype.html#cfn-iottwinmaker-componenttype-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iottwinmaker-componenttype.html#cfn-iottwinmaker-componenttype-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnComponentTypeProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnComponentTypeProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnComponentTypeProps> {
        java.lang.String componentTypeId;
        java.lang.String workspaceId;
        java.lang.Object compositeComponentTypes;
        java.lang.String description;
        java.util.List<java.lang.String> extendsFrom;
        java.lang.Object functions;
        java.lang.Object isSingleton;
        java.lang.Object propertyDefinitions;
        java.lang.Object propertyGroups;
        java.util.Map<java.lang.String, java.lang.String> tags;

        /**
         * Sets the value of {@link CfnComponentTypeProps#getComponentTypeId}
         * @param componentTypeId The ID of the component type. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder componentTypeId(java.lang.String componentTypeId) {
            this.componentTypeId = componentTypeId;
            return this;
        }

        /**
         * Sets the value of {@link CfnComponentTypeProps#getWorkspaceId}
         * @param workspaceId The ID of the workspace that contains the component type. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder workspaceId(java.lang.String workspaceId) {
            this.workspaceId = workspaceId;
            return this;
        }

        /**
         * Sets the value of {@link CfnComponentTypeProps#getCompositeComponentTypes}
         * @param compositeComponentTypes Maps strings to <code>compositeComponentTypes</code> of the <code>componentType</code> .
         *                                <code>CompositeComponentType</code> is referenced by <code>componentTypeId</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder compositeComponentTypes(software.amazon.awscdk.IResolvable compositeComponentTypes) {
            this.compositeComponentTypes = compositeComponentTypes;
            return this;
        }

        /**
         * Sets the value of {@link CfnComponentTypeProps#getCompositeComponentTypes}
         * @param compositeComponentTypes Maps strings to <code>compositeComponentTypes</code> of the <code>componentType</code> .
         *                                <code>CompositeComponentType</code> is referenced by <code>componentTypeId</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder compositeComponentTypes(java.util.Map<java.lang.String, ? extends java.lang.Object> compositeComponentTypes) {
            this.compositeComponentTypes = compositeComponentTypes;
            return this;
        }

        /**
         * Sets the value of {@link CfnComponentTypeProps#getDescription}
         * @param description The description of the component type.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link CfnComponentTypeProps#getExtendsFrom}
         * @param extendsFrom The name of the parent component type that this component type extends.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder extendsFrom(java.util.List<java.lang.String> extendsFrom) {
            this.extendsFrom = extendsFrom;
            return this;
        }

        /**
         * Sets the value of {@link CfnComponentTypeProps#getFunctions}
         * @param functions An object that maps strings to the functions in the component type.
         *                  Each string in the mapping must be unique to this object.
         *                  <p>
         *                  For information on the FunctionResponse object see the <a href="https://docs.aws.amazon.com//iot-twinmaker/latest/apireference/API_FunctionResponse.html">FunctionResponse</a> API reference.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder functions(software.amazon.awscdk.IResolvable functions) {
            this.functions = functions;
            return this;
        }

        /**
         * Sets the value of {@link CfnComponentTypeProps#getFunctions}
         * @param functions An object that maps strings to the functions in the component type.
         *                  Each string in the mapping must be unique to this object.
         *                  <p>
         *                  For information on the FunctionResponse object see the <a href="https://docs.aws.amazon.com//iot-twinmaker/latest/apireference/API_FunctionResponse.html">FunctionResponse</a> API reference.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder functions(java.util.Map<java.lang.String, ? extends java.lang.Object> functions) {
            this.functions = functions;
            return this;
        }

        /**
         * Sets the value of {@link CfnComponentTypeProps#getIsSingleton}
         * @param isSingleton A boolean value that specifies whether an entity can have more than one component of this type.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder isSingleton(java.lang.Boolean isSingleton) {
            this.isSingleton = isSingleton;
            return this;
        }

        /**
         * Sets the value of {@link CfnComponentTypeProps#getIsSingleton}
         * @param isSingleton A boolean value that specifies whether an entity can have more than one component of this type.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder isSingleton(software.amazon.awscdk.IResolvable isSingleton) {
            this.isSingleton = isSingleton;
            return this;
        }

        /**
         * Sets the value of {@link CfnComponentTypeProps#getPropertyDefinitions}
         * @param propertyDefinitions An object that maps strings to the property definitions in the component type.
         *                            Each string in the mapping must be unique to this object.
         *                            <p>
         *                            For information about the PropertyDefinitionResponse object, see the <a href="https://docs.aws.amazon.com//iot-twinmaker/latest/apireference/API_PropertyDefinitionResponse.html">PropertyDefinitionResponse</a> API reference.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder propertyDefinitions(software.amazon.awscdk.IResolvable propertyDefinitions) {
            this.propertyDefinitions = propertyDefinitions;
            return this;
        }

        /**
         * Sets the value of {@link CfnComponentTypeProps#getPropertyDefinitions}
         * @param propertyDefinitions An object that maps strings to the property definitions in the component type.
         *                            Each string in the mapping must be unique to this object.
         *                            <p>
         *                            For information about the PropertyDefinitionResponse object, see the <a href="https://docs.aws.amazon.com//iot-twinmaker/latest/apireference/API_PropertyDefinitionResponse.html">PropertyDefinitionResponse</a> API reference.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder propertyDefinitions(java.util.Map<java.lang.String, ? extends java.lang.Object> propertyDefinitions) {
            this.propertyDefinitions = propertyDefinitions;
            return this;
        }

        /**
         * Sets the value of {@link CfnComponentTypeProps#getPropertyGroups}
         * @param propertyGroups An object that maps strings to the property groups in the component type.
         *                       Each string in the mapping must be unique to this object.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder propertyGroups(software.amazon.awscdk.IResolvable propertyGroups) {
            this.propertyGroups = propertyGroups;
            return this;
        }

        /**
         * Sets the value of {@link CfnComponentTypeProps#getPropertyGroups}
         * @param propertyGroups An object that maps strings to the property groups in the component type.
         *                       Each string in the mapping must be unique to this object.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder propertyGroups(java.util.Map<java.lang.String, ? extends java.lang.Object> propertyGroups) {
            this.propertyGroups = propertyGroups;
            return this;
        }

        /**
         * Sets the value of {@link CfnComponentTypeProps#getTags}
         * @param tags The ComponentType tags.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(java.util.Map<java.lang.String, java.lang.String> tags) {
            this.tags = tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnComponentTypeProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnComponentTypeProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnComponentTypeProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnComponentTypeProps {
        private final java.lang.String componentTypeId;
        private final java.lang.String workspaceId;
        private final java.lang.Object compositeComponentTypes;
        private final java.lang.String description;
        private final java.util.List<java.lang.String> extendsFrom;
        private final java.lang.Object functions;
        private final java.lang.Object isSingleton;
        private final java.lang.Object propertyDefinitions;
        private final java.lang.Object propertyGroups;
        private final java.util.Map<java.lang.String, java.lang.String> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.componentTypeId = software.amazon.jsii.Kernel.get(this, "componentTypeId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.workspaceId = software.amazon.jsii.Kernel.get(this, "workspaceId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.compositeComponentTypes = software.amazon.jsii.Kernel.get(this, "compositeComponentTypes", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.extendsFrom = software.amazon.jsii.Kernel.get(this, "extendsFrom", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.functions = software.amazon.jsii.Kernel.get(this, "functions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.isSingleton = software.amazon.jsii.Kernel.get(this, "isSingleton", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.propertyDefinitions = software.amazon.jsii.Kernel.get(this, "propertyDefinitions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.propertyGroups = software.amazon.jsii.Kernel.get(this, "propertyGroups", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.componentTypeId = java.util.Objects.requireNonNull(builder.componentTypeId, "componentTypeId is required");
            this.workspaceId = java.util.Objects.requireNonNull(builder.workspaceId, "workspaceId is required");
            this.compositeComponentTypes = builder.compositeComponentTypes;
            this.description = builder.description;
            this.extendsFrom = builder.extendsFrom;
            this.functions = builder.functions;
            this.isSingleton = builder.isSingleton;
            this.propertyDefinitions = builder.propertyDefinitions;
            this.propertyGroups = builder.propertyGroups;
            this.tags = builder.tags;
        }

        @Override
        public final java.lang.String getComponentTypeId() {
            return this.componentTypeId;
        }

        @Override
        public final java.lang.String getWorkspaceId() {
            return this.workspaceId;
        }

        @Override
        public final java.lang.Object getCompositeComponentTypes() {
            return this.compositeComponentTypes;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public final java.util.List<java.lang.String> getExtendsFrom() {
            return this.extendsFrom;
        }

        @Override
        public final java.lang.Object getFunctions() {
            return this.functions;
        }

        @Override
        public final java.lang.Object getIsSingleton() {
            return this.isSingleton;
        }

        @Override
        public final java.lang.Object getPropertyDefinitions() {
            return this.propertyDefinitions;
        }

        @Override
        public final java.lang.Object getPropertyGroups() {
            return this.propertyGroups;
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.String> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("componentTypeId", om.valueToTree(this.getComponentTypeId()));
            data.set("workspaceId", om.valueToTree(this.getWorkspaceId()));
            if (this.getCompositeComponentTypes() != null) {
                data.set("compositeComponentTypes", om.valueToTree(this.getCompositeComponentTypes()));
            }
            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getExtendsFrom() != null) {
                data.set("extendsFrom", om.valueToTree(this.getExtendsFrom()));
            }
            if (this.getFunctions() != null) {
                data.set("functions", om.valueToTree(this.getFunctions()));
            }
            if (this.getIsSingleton() != null) {
                data.set("isSingleton", om.valueToTree(this.getIsSingleton()));
            }
            if (this.getPropertyDefinitions() != null) {
                data.set("propertyDefinitions", om.valueToTree(this.getPropertyDefinitions()));
            }
            if (this.getPropertyGroups() != null) {
                data.set("propertyGroups", om.valueToTree(this.getPropertyGroups()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iottwinmaker.CfnComponentTypeProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnComponentTypeProps.Jsii$Proxy that = (CfnComponentTypeProps.Jsii$Proxy) o;

            if (!componentTypeId.equals(that.componentTypeId)) return false;
            if (!workspaceId.equals(that.workspaceId)) return false;
            if (this.compositeComponentTypes != null ? !this.compositeComponentTypes.equals(that.compositeComponentTypes) : that.compositeComponentTypes != null) return false;
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            if (this.extendsFrom != null ? !this.extendsFrom.equals(that.extendsFrom) : that.extendsFrom != null) return false;
            if (this.functions != null ? !this.functions.equals(that.functions) : that.functions != null) return false;
            if (this.isSingleton != null ? !this.isSingleton.equals(that.isSingleton) : that.isSingleton != null) return false;
            if (this.propertyDefinitions != null ? !this.propertyDefinitions.equals(that.propertyDefinitions) : that.propertyDefinitions != null) return false;
            if (this.propertyGroups != null ? !this.propertyGroups.equals(that.propertyGroups) : that.propertyGroups != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.componentTypeId.hashCode();
            result = 31 * result + (this.workspaceId.hashCode());
            result = 31 * result + (this.compositeComponentTypes != null ? this.compositeComponentTypes.hashCode() : 0);
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            result = 31 * result + (this.extendsFrom != null ? this.extendsFrom.hashCode() : 0);
            result = 31 * result + (this.functions != null ? this.functions.hashCode() : 0);
            result = 31 * result + (this.isSingleton != null ? this.isSingleton.hashCode() : 0);
            result = 31 * result + (this.propertyDefinitions != null ? this.propertyDefinitions.hashCode() : 0);
            result = 31 * result + (this.propertyGroups != null ? this.propertyGroups.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
