package software.amazon.awscdk.services.kinesis;

/**
 * Properties to associate a data stream with a policy.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Stream stream = new Stream(this, "MyStream");
 * // create a custom policy document
 * PolicyDocument policyDocument = PolicyDocument.Builder.create()
 *         .assignSids(true)
 *         .statements(List.of(
 *             PolicyStatement.Builder.create()
 *                     .actions(List.of("kinesis:GetRecords"))
 *                     .resources(List.of(stream.getStreamArn()))
 *                     .principals(List.of(new AnyPrincipal()))
 *                     .build()))
 *         .build();
 * // create a resource policy manually
 * // create a resource policy manually
 * ResourcePolicy.Builder.create(this, "ResourcePolicy")
 *         .stream(stream)
 *         .policyDocument(policyDocument)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-01-25T00:20:57.479Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_kinesis.ResourcePolicyProps")
@software.amazon.jsii.Jsii.Proxy(ResourcePolicyProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface ResourcePolicyProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The stream this policy applies to.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.kinesis.IStream getStream();

    /**
     * IAM policy document to apply to a data stream.
     * <p>
     * Default: - empty policy document
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.iam.PolicyDocument getPolicyDocument() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link ResourcePolicyProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link ResourcePolicyProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<ResourcePolicyProps> {
        software.amazon.awscdk.services.kinesis.IStream stream;
        software.amazon.awscdk.services.iam.PolicyDocument policyDocument;

        /**
         * Sets the value of {@link ResourcePolicyProps#getStream}
         * @param stream The stream this policy applies to. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder stream(software.amazon.awscdk.services.kinesis.IStream stream) {
            this.stream = stream;
            return this;
        }

        /**
         * Sets the value of {@link ResourcePolicyProps#getPolicyDocument}
         * @param policyDocument IAM policy document to apply to a data stream.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder policyDocument(software.amazon.awscdk.services.iam.PolicyDocument policyDocument) {
            this.policyDocument = policyDocument;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ResourcePolicyProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public ResourcePolicyProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link ResourcePolicyProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ResourcePolicyProps {
        private final software.amazon.awscdk.services.kinesis.IStream stream;
        private final software.amazon.awscdk.services.iam.PolicyDocument policyDocument;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.stream = software.amazon.jsii.Kernel.get(this, "stream", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.kinesis.IStream.class));
            this.policyDocument = software.amazon.jsii.Kernel.get(this, "policyDocument", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.PolicyDocument.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.stream = java.util.Objects.requireNonNull(builder.stream, "stream is required");
            this.policyDocument = builder.policyDocument;
        }

        @Override
        public final software.amazon.awscdk.services.kinesis.IStream getStream() {
            return this.stream;
        }

        @Override
        public final software.amazon.awscdk.services.iam.PolicyDocument getPolicyDocument() {
            return this.policyDocument;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("stream", om.valueToTree(this.getStream()));
            if (this.getPolicyDocument() != null) {
                data.set("policyDocument", om.valueToTree(this.getPolicyDocument()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_kinesis.ResourcePolicyProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ResourcePolicyProps.Jsii$Proxy that = (ResourcePolicyProps.Jsii$Proxy) o;

            if (!stream.equals(that.stream)) return false;
            return this.policyDocument != null ? this.policyDocument.equals(that.policyDocument) : that.policyDocument == null;
        }

        @Override
        public final int hashCode() {
            int result = this.stream.hashCode();
            result = 31 * result + (this.policyDocument != null ? this.policyDocument.hashCode() : 0);
            return result;
        }
    }
}
