package software.amazon.awscdk.services.lambda;

/**
 * Specifies a cross-origin access property for a function URL.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Function fn;
 * fn.addFunctionUrl(FunctionUrlOptions.builder()
 *         .authType(FunctionUrlAuthType.NONE)
 *         .cors(FunctionUrlCorsOptions.builder()
 *                 // Allow this to be called from websites on https://example.com.
 *                 // Can also be ['*'] to allow all domain.
 *                 .allowedOrigins(List.of("https://example.com"))
 *                 .build())
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-01-25T00:20:57.911Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lambda.FunctionUrlCorsOptions")
@software.amazon.jsii.Jsii.Proxy(FunctionUrlCorsOptions.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface FunctionUrlCorsOptions extends software.amazon.jsii.JsiiSerializable {

    /**
     * Whether to allow cookies or other credentials in requests to your function URL.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getAllowCredentials() {
        return null;
    }

    /**
     * Headers that are specified in the Access-Control-Request-Headers header.
     * <p>
     * Default: - No headers allowed.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getAllowedHeaders() {
        return null;
    }

    /**
     * An HTTP method that you allow the origin to execute.
     * <p>
     * Default: - [HttpMethod.ALL]
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.lambda.HttpMethod> getAllowedMethods() {
        return null;
    }

    /**
     * One or more origins you want customers to be able to access the bucket from.
     * <p>
     * Default: - No origins allowed.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getAllowedOrigins() {
        return null;
    }

    /**
     * One or more headers in the response that you want customers to be able to access from their applications.
     * <p>
     * Default: - No headers exposed.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getExposedHeaders() {
        return null;
    }

    /**
     * The time in seconds that your browser is to cache the preflight response for the specified resource.
     * <p>
     * Default: - Browser default of 5 seconds.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.Duration getMaxAge() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link FunctionUrlCorsOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link FunctionUrlCorsOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<FunctionUrlCorsOptions> {
        java.lang.Boolean allowCredentials;
        java.util.List<java.lang.String> allowedHeaders;
        java.util.List<software.amazon.awscdk.services.lambda.HttpMethod> allowedMethods;
        java.util.List<java.lang.String> allowedOrigins;
        java.util.List<java.lang.String> exposedHeaders;
        software.amazon.awscdk.Duration maxAge;

        /**
         * Sets the value of {@link FunctionUrlCorsOptions#getAllowCredentials}
         * @param allowCredentials Whether to allow cookies or other credentials in requests to your function URL.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder allowCredentials(java.lang.Boolean allowCredentials) {
            this.allowCredentials = allowCredentials;
            return this;
        }

        /**
         * Sets the value of {@link FunctionUrlCorsOptions#getAllowedHeaders}
         * @param allowedHeaders Headers that are specified in the Access-Control-Request-Headers header.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder allowedHeaders(java.util.List<java.lang.String> allowedHeaders) {
            this.allowedHeaders = allowedHeaders;
            return this;
        }

        /**
         * Sets the value of {@link FunctionUrlCorsOptions#getAllowedMethods}
         * @param allowedMethods An HTTP method that you allow the origin to execute.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder allowedMethods(java.util.List<? extends software.amazon.awscdk.services.lambda.HttpMethod> allowedMethods) {
            this.allowedMethods = (java.util.List<software.amazon.awscdk.services.lambda.HttpMethod>)allowedMethods;
            return this;
        }

        /**
         * Sets the value of {@link FunctionUrlCorsOptions#getAllowedOrigins}
         * @param allowedOrigins One or more origins you want customers to be able to access the bucket from.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder allowedOrigins(java.util.List<java.lang.String> allowedOrigins) {
            this.allowedOrigins = allowedOrigins;
            return this;
        }

        /**
         * Sets the value of {@link FunctionUrlCorsOptions#getExposedHeaders}
         * @param exposedHeaders One or more headers in the response that you want customers to be able to access from their applications.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder exposedHeaders(java.util.List<java.lang.String> exposedHeaders) {
            this.exposedHeaders = exposedHeaders;
            return this;
        }

        /**
         * Sets the value of {@link FunctionUrlCorsOptions#getMaxAge}
         * @param maxAge The time in seconds that your browser is to cache the preflight response for the specified resource.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxAge(software.amazon.awscdk.Duration maxAge) {
            this.maxAge = maxAge;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link FunctionUrlCorsOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public FunctionUrlCorsOptions build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link FunctionUrlCorsOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements FunctionUrlCorsOptions {
        private final java.lang.Boolean allowCredentials;
        private final java.util.List<java.lang.String> allowedHeaders;
        private final java.util.List<software.amazon.awscdk.services.lambda.HttpMethod> allowedMethods;
        private final java.util.List<java.lang.String> allowedOrigins;
        private final java.util.List<java.lang.String> exposedHeaders;
        private final software.amazon.awscdk.Duration maxAge;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.allowCredentials = software.amazon.jsii.Kernel.get(this, "allowCredentials", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.allowedHeaders = software.amazon.jsii.Kernel.get(this, "allowedHeaders", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.allowedMethods = software.amazon.jsii.Kernel.get(this, "allowedMethods", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.HttpMethod.class)));
            this.allowedOrigins = software.amazon.jsii.Kernel.get(this, "allowedOrigins", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.exposedHeaders = software.amazon.jsii.Kernel.get(this, "exposedHeaders", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.maxAge = software.amazon.jsii.Kernel.get(this, "maxAge", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Duration.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.allowCredentials = builder.allowCredentials;
            this.allowedHeaders = builder.allowedHeaders;
            this.allowedMethods = (java.util.List<software.amazon.awscdk.services.lambda.HttpMethod>)builder.allowedMethods;
            this.allowedOrigins = builder.allowedOrigins;
            this.exposedHeaders = builder.exposedHeaders;
            this.maxAge = builder.maxAge;
        }

        @Override
        public final java.lang.Boolean getAllowCredentials() {
            return this.allowCredentials;
        }

        @Override
        public final java.util.List<java.lang.String> getAllowedHeaders() {
            return this.allowedHeaders;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.lambda.HttpMethod> getAllowedMethods() {
            return this.allowedMethods;
        }

        @Override
        public final java.util.List<java.lang.String> getAllowedOrigins() {
            return this.allowedOrigins;
        }

        @Override
        public final java.util.List<java.lang.String> getExposedHeaders() {
            return this.exposedHeaders;
        }

        @Override
        public final software.amazon.awscdk.Duration getMaxAge() {
            return this.maxAge;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getAllowCredentials() != null) {
                data.set("allowCredentials", om.valueToTree(this.getAllowCredentials()));
            }
            if (this.getAllowedHeaders() != null) {
                data.set("allowedHeaders", om.valueToTree(this.getAllowedHeaders()));
            }
            if (this.getAllowedMethods() != null) {
                data.set("allowedMethods", om.valueToTree(this.getAllowedMethods()));
            }
            if (this.getAllowedOrigins() != null) {
                data.set("allowedOrigins", om.valueToTree(this.getAllowedOrigins()));
            }
            if (this.getExposedHeaders() != null) {
                data.set("exposedHeaders", om.valueToTree(this.getExposedHeaders()));
            }
            if (this.getMaxAge() != null) {
                data.set("maxAge", om.valueToTree(this.getMaxAge()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_lambda.FunctionUrlCorsOptions"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            FunctionUrlCorsOptions.Jsii$Proxy that = (FunctionUrlCorsOptions.Jsii$Proxy) o;

            if (this.allowCredentials != null ? !this.allowCredentials.equals(that.allowCredentials) : that.allowCredentials != null) return false;
            if (this.allowedHeaders != null ? !this.allowedHeaders.equals(that.allowedHeaders) : that.allowedHeaders != null) return false;
            if (this.allowedMethods != null ? !this.allowedMethods.equals(that.allowedMethods) : that.allowedMethods != null) return false;
            if (this.allowedOrigins != null ? !this.allowedOrigins.equals(that.allowedOrigins) : that.allowedOrigins != null) return false;
            if (this.exposedHeaders != null ? !this.exposedHeaders.equals(that.exposedHeaders) : that.exposedHeaders != null) return false;
            return this.maxAge != null ? this.maxAge.equals(that.maxAge) : that.maxAge == null;
        }

        @Override
        public final int hashCode() {
            int result = this.allowCredentials != null ? this.allowCredentials.hashCode() : 0;
            result = 31 * result + (this.allowedHeaders != null ? this.allowedHeaders.hashCode() : 0);
            result = 31 * result + (this.allowedMethods != null ? this.allowedMethods.hashCode() : 0);
            result = 31 * result + (this.allowedOrigins != null ? this.allowedOrigins.hashCode() : 0);
            result = 31 * result + (this.exposedHeaders != null ? this.exposedHeaders.hashCode() : 0);
            result = 31 * result + (this.maxAge != null ? this.maxAge.hashCode() : 0);
            return result;
        }
    }
}
