package software.amazon.awscdk.services.lambda.nodejs;

/**
 * Bundling options.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * NodejsFunction.Builder.create(this, "my-handler")
 *         .bundling(BundlingOptions.builder()
 *                 .dockerImage(DockerImage.fromBuild("/path/to/Dockerfile"))
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-01-25T00:20:58.003Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lambda_nodejs.BundlingOptions")
@software.amazon.jsii.Jsii.Proxy(BundlingOptions.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface BundlingOptions extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.DockerRunOptions {

    /**
     * Specify a custom hash for this asset.
     * <p>
     * For consistency, this custom hash will
     * be SHA256 hashed and encoded as hex. The resulting hash will be the asset
     * hash.
     * <p>
     * NOTE: the hash is used in order to identify a specific revision of the asset, and
     * used for optimizing and caching deployment activities related to this asset such as
     * packaging, uploading to Amazon S3, etc. If you chose to customize the hash, you will
     * need to make sure it is updated every time the asset changes, or otherwise it is
     * possible that some deployments will not be invalidated.
     * <p>
     * Default: - asset hash is calculated based on the bundled output
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getAssetHash() {
        return null;
    }

    /**
     * Use this to insert an arbitrary string at the beginning of generated JavaScript files.
     * <p>
     * This is similar to footer which inserts at the end instead of the beginning.
     * <p>
     * This is commonly used to insert comments:
     * <p>
     * Default: - no comments are passed
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getBanner() {
        return null;
    }

    /**
     * Build arguments to pass when building the bundling image.
     * <p>
     * Default: - no build arguments are passed
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> getBuildArgs() {
        return null;
    }

    /**
     * Includes AWS SDK in the bundle asset.
     * <p>
     * Default: - false
     * if `true` the `aws-sdk` will be included in the asset bundle and not be
     * resolved to the Lambda provided sdk.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getBundleAwsSDK() {
        return null;
    }

    /**
     * Which option to use to copy the source files to the docker container and output files back.
     * <p>
     * Default: - BundlingFileAccess.BIND_MOUNT
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.BundlingFileAccess getBundlingFileAccess() {
        return null;
    }

    /**
     * The charset to use for esbuild's output.
     * <p>
     * By default esbuild's output is ASCII-only. Any non-ASCII characters are escaped
     * using backslash escape sequences. Using escape sequences makes the generated output
     * slightly bigger, and also makes it harder to read. If you would like for esbuild to print
     * the original characters without using escape sequences, use <code>Charset.UTF8</code>.
     * <p>
     * Default: Charset.ASCII
     * <p>
     * @see <a href="https://esbuild.github.io/api/#charset">https://esbuild.github.io/api/#charset</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.lambda.nodejs.Charset getCharset() {
        return null;
    }

    /**
     * Command hooks.
     * <p>
     * Default: - do not run additional commands
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.lambda.nodejs.ICommandHooks getCommandHooks() {
        return null;
    }

    /**
     * Replace global identifiers with constant expressions.
     * <p>
     * For example, <code>{ 'process.env.DEBUG': 'true' }</code>.
     * <p>
     * Another example, <code>{ 'process.env.API_KEY': JSON.stringify('xxx-xxxx-xxx') }</code>.
     * <p>
     * Default: - no replacements are made
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> getDefine() {
        return null;
    }

    /**
     * A custom bundling Docker image.
     * <p>
     * This image should have esbuild installed globally. If you plan to use <code>nodeModules</code>
     * it should also have <code>npm</code>, <code>yarn</code>, <code>bun</code> or <code>pnpm</code> depending on the lock file you're using.
     * <p>
     * See https://github.com/aws/aws-cdk/blob/main/packages/aws-cdk-lib/aws-lambda-nodejs/lib/Dockerfile
     * for the default image provided by aws-cdk-lib/aws-lambda-nodejs.
     * <p>
     * Default: - use the Docker image provided by aws-cdk-lib/aws-lambda-nodejs
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.DockerImage getDockerImage() {
        return null;
    }

    /**
     * Build arguments to pass into esbuild.
     * <p>
     * For example, to add the <a href="https://esbuild.github.io/api/#log-limit">--log-limit</a> flag:
     * <p>
     * <blockquote><pre>
     * new NodejsFunction(scope, id, {
     *   ...
     *   bundling: {
     *     esbuildArgs: {
     *       "--log-limit": "0",
     *     }
     *   }
     * });
     * </pre></blockquote>
     * <p>
     * Default: - no additional esbuild arguments are passed
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.Object> getEsbuildArgs() {
        return null;
    }

    /**
     * The version of esbuild to use when running in a Docker container.
     * <p>
     * Default: - latest v0
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getEsbuildVersion() {
        return null;
    }

    /**
     * A list of modules that should be considered as externals (already available in the runtime).
     * <p>
     * Default: - no replacements are made
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getExternalModules() {
        return null;
    }

    /**
     * Use this to insert an arbitrary string at the end of generated JavaScript files.
     * <p>
     * This is similar to banner which inserts at the beginning instead of the end.
     * <p>
     * This is commonly used to insert comments
     * <p>
     * Default: - no comments are passed
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getFooter() {
        return null;
    }

    /**
     * Force bundling in a Docker container even if local bundling is possible.
     * <p>
     * This is useful if your function relies on node modules
     * that should be installed (<code>nodeModules</code>) in a Lambda compatible
     * environment.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getForceDockerBundling() {
        return null;
    }

    /**
     * Output format for the generated JavaScript files.
     * <p>
     * Default: OutputFormat.CJS
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.lambda.nodejs.OutputFormat getFormat() {
        return null;
    }

    /**
     * This option allows you to automatically replace a global variable with an import from another file.
     * <p>
     * Default: - no code is injected
     * <p>
     * @see <a href="https://esbuild.github.io/api/#inject">https://esbuild.github.io/api/#inject</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getInject() {
        return null;
    }

    /**
     * Whether to preserve the original <code>name</code> values even in minified code.
     * <p>
     * In JavaScript the <code>name</code> property on functions and classes defaults to a
     * nearby identifier in the source code.
     * <p>
     * However, minification renames symbols to reduce code size and bundling
     * sometimes need to rename symbols to avoid collisions. That changes value of
     * the <code>name</code> property for many of these cases. This is usually fine because
     * the <code>name</code> property is normally only used for debugging. However, some
     * frameworks rely on the <code>name</code> property for registration and binding purposes.
     * If this is the case, you can enable this option to preserve the original
     * <code>name</code> values even in minified code.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getKeepNames() {
        return null;
    }

    /**
     * Use loaders to change how a given input file is interpreted.
     * <p>
     * Configuring a loader for a given file type lets you load that file type with
     * an <code>import</code> statement or a <code>require</code> call.
     * <p>
     * For example, <code>{ '.png': 'dataurl' }</code>.
     * <p>
     * Default: - use esbuild default loaders
     * <p>
     * @see <a href="https://esbuild.github.io/api/#loader">https://esbuild.github.io/api/#loader</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> getLoader() {
        return null;
    }

    /**
     * Log level for esbuild.
     * <p>
     * This is also propagated to the package manager and
     * applies to its specific install command.
     * <p>
     * Default: LogLevel.WARNING
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.lambda.nodejs.LogLevel getLogLevel() {
        return null;
    }

    /**
     * How to determine the entry point for modules.
     * <p>
     * Try ['module', 'main'] to default to ES module versions.
     * <p>
     * Default: []
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getMainFields() {
        return null;
    }

    /**
     * This option tells esbuild to write out a JSON file relative to output directory with metadata about the build.
     * <p>
     * The metadata in this JSON file follows this schema (specified using TypeScript syntax):
     * <p>
     * <blockquote><pre>
     * {
     *   outputs: {
     *     [path: string]: {
     *       bytes: number
     *       inputs: {
     *         [path: string]: { bytesInOutput: number }
     *       }
     *       imports: { path: string }[]
     *       exports: string[]
     *     }
     *   }
     * }
     * </pre></blockquote>
     * <p>
     * This data can then be analyzed by other tools. For example,
     * bundle buddy can consume esbuild's metadata format and generates a treemap visualization
     * of the modules in your bundle and how much space each one takes up.
     * <p>
     * Default: false
     * <p>
     * @see <a href="https://esbuild.github.io/api/#metafile">https://esbuild.github.io/api/#metafile</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getMetafile() {
        return null;
    }

    /**
     * Whether to minify files when bundling.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getMinify() {
        return null;
    }

    /**
     * A list of modules that should be installed instead of bundled.
     * <p>
     * Modules are
     * installed in a Lambda compatible environment only when bundling runs in
     * Docker.
     * <p>
     * Default: - all modules are bundled
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getNodeModules() {
        return null;
    }

    /**
     * Run compilation using tsc before running file through bundling step.
     * <p>
     * This usually is not required unless you are using new experimental features that
     * are only supported by typescript's <code>tsc</code> compiler.
     * One example of such feature is <code>emitDecoratorMetadata</code>.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getPreCompilation() {
        return null;
    }

    /**
     * Whether to include source maps when bundling.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getSourceMap() {
        return null;
    }

    /**
     * Source map mode to be used when bundling.
     * <p>
     * Default: SourceMapMode.DEFAULT
     * <p>
     * @see <a href="https://esbuild.github.io/api/#sourcemap">https://esbuild.github.io/api/#sourcemap</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.lambda.nodejs.SourceMapMode getSourceMapMode() {
        return null;
    }

    /**
     * Whether to include original source code in source maps when bundling.
     * <p>
     * Default: true
     * <p>
     * @see <a href="https://esbuild.github.io/api/#sources-content">https://esbuild.github.io/api/#sources-content</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getSourcesContent() {
        return null;
    }

    /**
     * Target environment for the generated JavaScript code.
     * <p>
     * Default: - the node version of the runtime
     * <p>
     * @see <a href="https://esbuild.github.io/api/#target">https://esbuild.github.io/api/#target</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getTarget() {
        return null;
    }

    /**
     * Normally the esbuild automatically discovers <code>tsconfig.json</code> files and reads their contents during a build.
     * <p>
     * However, you can also configure a custom <code>tsconfig.json</code> file to use instead.
     * <p>
     * This is similar to entry path, you need to provide path to your custom <code>tsconfig.json</code>.
     * <p>
     * This can be useful if you need to do multiple builds of the same code with different settings.
     * <p>
     * For example, <code>{ 'tsconfig': 'path/custom.tsconfig.json' }</code>.
     * <p>
     * Default: - automatically discovered by `esbuild`
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getTsconfig() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link BundlingOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link BundlingOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<BundlingOptions> {
        java.lang.String assetHash;
        java.lang.String banner;
        java.util.Map<java.lang.String, java.lang.String> buildArgs;
        java.lang.Boolean bundleAwsSdk;
        software.amazon.awscdk.BundlingFileAccess bundlingFileAccess;
        software.amazon.awscdk.services.lambda.nodejs.Charset charset;
        software.amazon.awscdk.services.lambda.nodejs.ICommandHooks commandHooks;
        java.util.Map<java.lang.String, java.lang.String> define;
        software.amazon.awscdk.DockerImage dockerImage;
        java.util.Map<java.lang.String, java.lang.Object> esbuildArgs;
        java.lang.String esbuildVersion;
        java.util.List<java.lang.String> externalModules;
        java.lang.String footer;
        java.lang.Boolean forceDockerBundling;
        software.amazon.awscdk.services.lambda.nodejs.OutputFormat format;
        java.util.List<java.lang.String> inject;
        java.lang.Boolean keepNames;
        java.util.Map<java.lang.String, java.lang.String> loader;
        software.amazon.awscdk.services.lambda.nodejs.LogLevel logLevel;
        java.util.List<java.lang.String> mainFields;
        java.lang.Boolean metafile;
        java.lang.Boolean minify;
        java.util.List<java.lang.String> nodeModules;
        java.lang.Boolean preCompilation;
        java.lang.Boolean sourceMap;
        software.amazon.awscdk.services.lambda.nodejs.SourceMapMode sourceMapMode;
        java.lang.Boolean sourcesContent;
        java.lang.String target;
        java.lang.String tsconfig;
        java.util.List<java.lang.String> command;
        java.util.List<java.lang.String> entrypoint;
        java.util.Map<java.lang.String, java.lang.String> environment;
        java.lang.String network;
        java.lang.String platform;
        java.lang.String securityOpt;
        java.lang.String user;
        java.util.List<software.amazon.awscdk.DockerVolume> volumes;
        java.util.List<java.lang.String> volumesFrom;
        java.lang.String workingDirectory;

        /**
         * Sets the value of {@link BundlingOptions#getAssetHash}
         * @param assetHash Specify a custom hash for this asset.
         *                  For consistency, this custom hash will
         *                  be SHA256 hashed and encoded as hex. The resulting hash will be the asset
         *                  hash.
         *                  <p>
         *                  NOTE: the hash is used in order to identify a specific revision of the asset, and
         *                  used for optimizing and caching deployment activities related to this asset such as
         *                  packaging, uploading to Amazon S3, etc. If you chose to customize the hash, you will
         *                  need to make sure it is updated every time the asset changes, or otherwise it is
         *                  possible that some deployments will not be invalidated.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder assetHash(java.lang.String assetHash) {
            this.assetHash = assetHash;
            return this;
        }

        /**
         * Sets the value of {@link BundlingOptions#getBanner}
         * @param banner Use this to insert an arbitrary string at the beginning of generated JavaScript files.
         *               This is similar to footer which inserts at the end instead of the beginning.
         *               <p>
         *               This is commonly used to insert comments:
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder banner(java.lang.String banner) {
            this.banner = banner;
            return this;
        }

        /**
         * Sets the value of {@link BundlingOptions#getBuildArgs}
         * @param buildArgs Build arguments to pass when building the bundling image.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder buildArgs(java.util.Map<java.lang.String, java.lang.String> buildArgs) {
            this.buildArgs = buildArgs;
            return this;
        }

        /**
         * Sets the value of {@link BundlingOptions#getBundleAwsSdk}
         * @param bundleAwsSdk Includes AWS SDK in the bundle asset.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder bundleAwsSdk(java.lang.Boolean bundleAwsSdk) {
            this.bundleAwsSdk = bundleAwsSdk;
            return this;
        }

        /**
         * Sets the value of {@link BundlingOptions#getBundlingFileAccess}
         * @param bundlingFileAccess Which option to use to copy the source files to the docker container and output files back.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder bundlingFileAccess(software.amazon.awscdk.BundlingFileAccess bundlingFileAccess) {
            this.bundlingFileAccess = bundlingFileAccess;
            return this;
        }

        /**
         * Sets the value of {@link BundlingOptions#getCharset}
         * @param charset The charset to use for esbuild's output.
         *                By default esbuild's output is ASCII-only. Any non-ASCII characters are escaped
         *                using backslash escape sequences. Using escape sequences makes the generated output
         *                slightly bigger, and also makes it harder to read. If you would like for esbuild to print
         *                the original characters without using escape sequences, use <code>Charset.UTF8</code>.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder charset(software.amazon.awscdk.services.lambda.nodejs.Charset charset) {
            this.charset = charset;
            return this;
        }

        /**
         * Sets the value of {@link BundlingOptions#getCommandHooks}
         * @param commandHooks Command hooks.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder commandHooks(software.amazon.awscdk.services.lambda.nodejs.ICommandHooks commandHooks) {
            this.commandHooks = commandHooks;
            return this;
        }

        /**
         * Sets the value of {@link BundlingOptions#getDefine}
         * @param define Replace global identifiers with constant expressions.
         *               For example, <code>{ 'process.env.DEBUG': 'true' }</code>.
         *               <p>
         *               Another example, <code>{ 'process.env.API_KEY': JSON.stringify('xxx-xxxx-xxx') }</code>.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder define(java.util.Map<java.lang.String, java.lang.String> define) {
            this.define = define;
            return this;
        }

        /**
         * Sets the value of {@link BundlingOptions#getDockerImage}
         * @param dockerImage A custom bundling Docker image.
         *                    This image should have esbuild installed globally. If you plan to use <code>nodeModules</code>
         *                    it should also have <code>npm</code>, <code>yarn</code>, <code>bun</code> or <code>pnpm</code> depending on the lock file you're using.
         *                    <p>
         *                    See https://github.com/aws/aws-cdk/blob/main/packages/aws-cdk-lib/aws-lambda-nodejs/lib/Dockerfile
         *                    for the default image provided by aws-cdk-lib/aws-lambda-nodejs.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dockerImage(software.amazon.awscdk.DockerImage dockerImage) {
            this.dockerImage = dockerImage;
            return this;
        }

        /**
         * Sets the value of {@link BundlingOptions#getEsbuildArgs}
         * @param esbuildArgs Build arguments to pass into esbuild.
         *                    For example, to add the <a href="https://esbuild.github.io/api/#log-limit">--log-limit</a> flag:
         *                    <p>
         *                    <blockquote><pre>
         *                    new NodejsFunction(scope, id, {
         *                      ...
         *                      bundling: {
         *                        esbuildArgs: {
         *                          "--log-limit": "0",
         *                        }
         *                      }
         *                    });
         *                    </pre></blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder esbuildArgs(java.util.Map<java.lang.String, ? extends java.lang.Object> esbuildArgs) {
            this.esbuildArgs = (java.util.Map<java.lang.String, java.lang.Object>)esbuildArgs;
            return this;
        }

        /**
         * Sets the value of {@link BundlingOptions#getEsbuildVersion}
         * @param esbuildVersion The version of esbuild to use when running in a Docker container.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder esbuildVersion(java.lang.String esbuildVersion) {
            this.esbuildVersion = esbuildVersion;
            return this;
        }

        /**
         * Sets the value of {@link BundlingOptions#getExternalModules}
         * @param externalModules A list of modules that should be considered as externals (already available in the runtime).
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder externalModules(java.util.List<java.lang.String> externalModules) {
            this.externalModules = externalModules;
            return this;
        }

        /**
         * Sets the value of {@link BundlingOptions#getFooter}
         * @param footer Use this to insert an arbitrary string at the end of generated JavaScript files.
         *               This is similar to banner which inserts at the beginning instead of the end.
         *               <p>
         *               This is commonly used to insert comments
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder footer(java.lang.String footer) {
            this.footer = footer;
            return this;
        }

        /**
         * Sets the value of {@link BundlingOptions#getForceDockerBundling}
         * @param forceDockerBundling Force bundling in a Docker container even if local bundling is possible.
         *                            This is useful if your function relies on node modules
         *                            that should be installed (<code>nodeModules</code>) in a Lambda compatible
         *                            environment.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder forceDockerBundling(java.lang.Boolean forceDockerBundling) {
            this.forceDockerBundling = forceDockerBundling;
            return this;
        }

        /**
         * Sets the value of {@link BundlingOptions#getFormat}
         * @param format Output format for the generated JavaScript files.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder format(software.amazon.awscdk.services.lambda.nodejs.OutputFormat format) {
            this.format = format;
            return this;
        }

        /**
         * Sets the value of {@link BundlingOptions#getInject}
         * @param inject This option allows you to automatically replace a global variable with an import from another file.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder inject(java.util.List<java.lang.String> inject) {
            this.inject = inject;
            return this;
        }

        /**
         * Sets the value of {@link BundlingOptions#getKeepNames}
         * @param keepNames Whether to preserve the original <code>name</code> values even in minified code.
         *                  In JavaScript the <code>name</code> property on functions and classes defaults to a
         *                  nearby identifier in the source code.
         *                  <p>
         *                  However, minification renames symbols to reduce code size and bundling
         *                  sometimes need to rename symbols to avoid collisions. That changes value of
         *                  the <code>name</code> property for many of these cases. This is usually fine because
         *                  the <code>name</code> property is normally only used for debugging. However, some
         *                  frameworks rely on the <code>name</code> property for registration and binding purposes.
         *                  If this is the case, you can enable this option to preserve the original
         *                  <code>name</code> values even in minified code.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder keepNames(java.lang.Boolean keepNames) {
            this.keepNames = keepNames;
            return this;
        }

        /**
         * Sets the value of {@link BundlingOptions#getLoader}
         * @param loader Use loaders to change how a given input file is interpreted.
         *               Configuring a loader for a given file type lets you load that file type with
         *               an <code>import</code> statement or a <code>require</code> call.
         *               <p>
         *               For example, <code>{ '.png': 'dataurl' }</code>.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder loader(java.util.Map<java.lang.String, java.lang.String> loader) {
            this.loader = loader;
            return this;
        }

        /**
         * Sets the value of {@link BundlingOptions#getLogLevel}
         * @param logLevel Log level for esbuild.
         *                 This is also propagated to the package manager and
         *                 applies to its specific install command.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder logLevel(software.amazon.awscdk.services.lambda.nodejs.LogLevel logLevel) {
            this.logLevel = logLevel;
            return this;
        }

        /**
         * Sets the value of {@link BundlingOptions#getMainFields}
         * @param mainFields How to determine the entry point for modules.
         *                   Try ['module', 'main'] to default to ES module versions.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder mainFields(java.util.List<java.lang.String> mainFields) {
            this.mainFields = mainFields;
            return this;
        }

        /**
         * Sets the value of {@link BundlingOptions#getMetafile}
         * @param metafile This option tells esbuild to write out a JSON file relative to output directory with metadata about the build.
         *                 The metadata in this JSON file follows this schema (specified using TypeScript syntax):
         *                 <p>
         *                 <blockquote><pre>
         *                 {
         *                   outputs: {
         *                     [path: string]: {
         *                       bytes: number
         *                       inputs: {
         *                         [path: string]: { bytesInOutput: number }
         *                       }
         *                       imports: { path: string }[]
         *                       exports: string[]
         *                     }
         *                   }
         *                 }
         *                 </pre></blockquote>
         *                 <p>
         *                 This data can then be analyzed by other tools. For example,
         *                 bundle buddy can consume esbuild's metadata format and generates a treemap visualization
         *                 of the modules in your bundle and how much space each one takes up.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder metafile(java.lang.Boolean metafile) {
            this.metafile = metafile;
            return this;
        }

        /**
         * Sets the value of {@link BundlingOptions#getMinify}
         * @param minify Whether to minify files when bundling.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder minify(java.lang.Boolean minify) {
            this.minify = minify;
            return this;
        }

        /**
         * Sets the value of {@link BundlingOptions#getNodeModules}
         * @param nodeModules A list of modules that should be installed instead of bundled.
         *                    Modules are
         *                    installed in a Lambda compatible environment only when bundling runs in
         *                    Docker.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder nodeModules(java.util.List<java.lang.String> nodeModules) {
            this.nodeModules = nodeModules;
            return this;
        }

        /**
         * Sets the value of {@link BundlingOptions#getPreCompilation}
         * @param preCompilation Run compilation using tsc before running file through bundling step.
         *                       This usually is not required unless you are using new experimental features that
         *                       are only supported by typescript's <code>tsc</code> compiler.
         *                       One example of such feature is <code>emitDecoratorMetadata</code>.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder preCompilation(java.lang.Boolean preCompilation) {
            this.preCompilation = preCompilation;
            return this;
        }

        /**
         * Sets the value of {@link BundlingOptions#getSourceMap}
         * @param sourceMap Whether to include source maps when bundling.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sourceMap(java.lang.Boolean sourceMap) {
            this.sourceMap = sourceMap;
            return this;
        }

        /**
         * Sets the value of {@link BundlingOptions#getSourceMapMode}
         * @param sourceMapMode Source map mode to be used when bundling.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sourceMapMode(software.amazon.awscdk.services.lambda.nodejs.SourceMapMode sourceMapMode) {
            this.sourceMapMode = sourceMapMode;
            return this;
        }

        /**
         * Sets the value of {@link BundlingOptions#getSourcesContent}
         * @param sourcesContent Whether to include original source code in source maps when bundling.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sourcesContent(java.lang.Boolean sourcesContent) {
            this.sourcesContent = sourcesContent;
            return this;
        }

        /**
         * Sets the value of {@link BundlingOptions#getTarget}
         * @param target Target environment for the generated JavaScript code.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder target(java.lang.String target) {
            this.target = target;
            return this;
        }

        /**
         * Sets the value of {@link BundlingOptions#getTsconfig}
         * @param tsconfig Normally the esbuild automatically discovers <code>tsconfig.json</code> files and reads their contents during a build.
         *                 However, you can also configure a custom <code>tsconfig.json</code> file to use instead.
         *                 <p>
         *                 This is similar to entry path, you need to provide path to your custom <code>tsconfig.json</code>.
         *                 <p>
         *                 This can be useful if you need to do multiple builds of the same code with different settings.
         *                 <p>
         *                 For example, <code>{ 'tsconfig': 'path/custom.tsconfig.json' }</code>.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tsconfig(java.lang.String tsconfig) {
            this.tsconfig = tsconfig;
            return this;
        }

        /**
         * Sets the value of {@link BundlingOptions#getCommand}
         * @param command The command to run in the container.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder command(java.util.List<java.lang.String> command) {
            this.command = command;
            return this;
        }

        /**
         * Sets the value of {@link BundlingOptions#getEntrypoint}
         * @param entrypoint The entrypoint to run in the container.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder entrypoint(java.util.List<java.lang.String> entrypoint) {
            this.entrypoint = entrypoint;
            return this;
        }

        /**
         * Sets the value of {@link BundlingOptions#getEnvironment}
         * @param environment The environment variables to pass to the container.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder environment(java.util.Map<java.lang.String, java.lang.String> environment) {
            this.environment = environment;
            return this;
        }

        /**
         * Sets the value of {@link BundlingOptions#getNetwork}
         * @param network Docker <a href="https://docs.docker.com/engine/reference/commandline/run/#connect-a-container-to-a-network---network">Networking options</a>.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder network(java.lang.String network) {
            this.network = network;
            return this;
        }

        /**
         * Sets the value of {@link BundlingOptions#getPlatform}
         * @param platform Set platform if server is multi-platform capable. <em>Requires Docker Engine API v1.38+</em>.
         *                 Example value: <code>linux/amd64</code>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder platform(java.lang.String platform) {
            this.platform = platform;
            return this;
        }

        /**
         * Sets the value of {@link BundlingOptions#getSecurityOpt}
         * @param securityOpt <a href="https://docs.docker.com/engine/reference/run/#security-configuration">Security configuration</a> when running the docker container.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder securityOpt(java.lang.String securityOpt) {
            this.securityOpt = securityOpt;
            return this;
        }

        /**
         * Sets the value of {@link BundlingOptions#getUser}
         * @param user The user to use when running the container.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder user(java.lang.String user) {
            this.user = user;
            return this;
        }

        /**
         * Sets the value of {@link BundlingOptions#getVolumes}
         * @param volumes Docker volumes to mount.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder volumes(java.util.List<? extends software.amazon.awscdk.DockerVolume> volumes) {
            this.volumes = (java.util.List<software.amazon.awscdk.DockerVolume>)volumes;
            return this;
        }

        /**
         * Sets the value of {@link BundlingOptions#getVolumesFrom}
         * @param volumesFrom Where to mount the specified volumes from.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder volumesFrom(java.util.List<java.lang.String> volumesFrom) {
            this.volumesFrom = volumesFrom;
            return this;
        }

        /**
         * Sets the value of {@link BundlingOptions#getWorkingDirectory}
         * @param workingDirectory Working directory inside the container.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder workingDirectory(java.lang.String workingDirectory) {
            this.workingDirectory = workingDirectory;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link BundlingOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public BundlingOptions build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link BundlingOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements BundlingOptions {
        private final java.lang.String assetHash;
        private final java.lang.String banner;
        private final java.util.Map<java.lang.String, java.lang.String> buildArgs;
        private final java.lang.Boolean bundleAwsSdk;
        private final software.amazon.awscdk.BundlingFileAccess bundlingFileAccess;
        private final software.amazon.awscdk.services.lambda.nodejs.Charset charset;
        private final software.amazon.awscdk.services.lambda.nodejs.ICommandHooks commandHooks;
        private final java.util.Map<java.lang.String, java.lang.String> define;
        private final software.amazon.awscdk.DockerImage dockerImage;
        private final java.util.Map<java.lang.String, java.lang.Object> esbuildArgs;
        private final java.lang.String esbuildVersion;
        private final java.util.List<java.lang.String> externalModules;
        private final java.lang.String footer;
        private final java.lang.Boolean forceDockerBundling;
        private final software.amazon.awscdk.services.lambda.nodejs.OutputFormat format;
        private final java.util.List<java.lang.String> inject;
        private final java.lang.Boolean keepNames;
        private final java.util.Map<java.lang.String, java.lang.String> loader;
        private final software.amazon.awscdk.services.lambda.nodejs.LogLevel logLevel;
        private final java.util.List<java.lang.String> mainFields;
        private final java.lang.Boolean metafile;
        private final java.lang.Boolean minify;
        private final java.util.List<java.lang.String> nodeModules;
        private final java.lang.Boolean preCompilation;
        private final java.lang.Boolean sourceMap;
        private final software.amazon.awscdk.services.lambda.nodejs.SourceMapMode sourceMapMode;
        private final java.lang.Boolean sourcesContent;
        private final java.lang.String target;
        private final java.lang.String tsconfig;
        private final java.util.List<java.lang.String> command;
        private final java.util.List<java.lang.String> entrypoint;
        private final java.util.Map<java.lang.String, java.lang.String> environment;
        private final java.lang.String network;
        private final java.lang.String platform;
        private final java.lang.String securityOpt;
        private final java.lang.String user;
        private final java.util.List<software.amazon.awscdk.DockerVolume> volumes;
        private final java.util.List<java.lang.String> volumesFrom;
        private final java.lang.String workingDirectory;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.assetHash = software.amazon.jsii.Kernel.get(this, "assetHash", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.banner = software.amazon.jsii.Kernel.get(this, "banner", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.buildArgs = software.amazon.jsii.Kernel.get(this, "buildArgs", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.bundleAwsSdk = software.amazon.jsii.Kernel.get(this, "bundleAwsSDK", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.bundlingFileAccess = software.amazon.jsii.Kernel.get(this, "bundlingFileAccess", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.BundlingFileAccess.class));
            this.charset = software.amazon.jsii.Kernel.get(this, "charset", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.nodejs.Charset.class));
            this.commandHooks = software.amazon.jsii.Kernel.get(this, "commandHooks", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.nodejs.ICommandHooks.class));
            this.define = software.amazon.jsii.Kernel.get(this, "define", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.dockerImage = software.amazon.jsii.Kernel.get(this, "dockerImage", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.DockerImage.class));
            this.esbuildArgs = software.amazon.jsii.Kernel.get(this, "esbuildArgs", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)));
            this.esbuildVersion = software.amazon.jsii.Kernel.get(this, "esbuildVersion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.externalModules = software.amazon.jsii.Kernel.get(this, "externalModules", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.footer = software.amazon.jsii.Kernel.get(this, "footer", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.forceDockerBundling = software.amazon.jsii.Kernel.get(this, "forceDockerBundling", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.format = software.amazon.jsii.Kernel.get(this, "format", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.nodejs.OutputFormat.class));
            this.inject = software.amazon.jsii.Kernel.get(this, "inject", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.keepNames = software.amazon.jsii.Kernel.get(this, "keepNames", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.loader = software.amazon.jsii.Kernel.get(this, "loader", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.logLevel = software.amazon.jsii.Kernel.get(this, "logLevel", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.nodejs.LogLevel.class));
            this.mainFields = software.amazon.jsii.Kernel.get(this, "mainFields", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.metafile = software.amazon.jsii.Kernel.get(this, "metafile", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.minify = software.amazon.jsii.Kernel.get(this, "minify", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.nodeModules = software.amazon.jsii.Kernel.get(this, "nodeModules", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.preCompilation = software.amazon.jsii.Kernel.get(this, "preCompilation", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.sourceMap = software.amazon.jsii.Kernel.get(this, "sourceMap", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.sourceMapMode = software.amazon.jsii.Kernel.get(this, "sourceMapMode", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.nodejs.SourceMapMode.class));
            this.sourcesContent = software.amazon.jsii.Kernel.get(this, "sourcesContent", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.target = software.amazon.jsii.Kernel.get(this, "target", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.tsconfig = software.amazon.jsii.Kernel.get(this, "tsconfig", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.command = software.amazon.jsii.Kernel.get(this, "command", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.entrypoint = software.amazon.jsii.Kernel.get(this, "entrypoint", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.environment = software.amazon.jsii.Kernel.get(this, "environment", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.network = software.amazon.jsii.Kernel.get(this, "network", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.platform = software.amazon.jsii.Kernel.get(this, "platform", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.securityOpt = software.amazon.jsii.Kernel.get(this, "securityOpt", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.user = software.amazon.jsii.Kernel.get(this, "user", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.volumes = software.amazon.jsii.Kernel.get(this, "volumes", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.DockerVolume.class)));
            this.volumesFrom = software.amazon.jsii.Kernel.get(this, "volumesFrom", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.workingDirectory = software.amazon.jsii.Kernel.get(this, "workingDirectory", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.assetHash = builder.assetHash;
            this.banner = builder.banner;
            this.buildArgs = builder.buildArgs;
            this.bundleAwsSdk = builder.bundleAwsSdk;
            this.bundlingFileAccess = builder.bundlingFileAccess;
            this.charset = builder.charset;
            this.commandHooks = builder.commandHooks;
            this.define = builder.define;
            this.dockerImage = builder.dockerImage;
            this.esbuildArgs = (java.util.Map<java.lang.String, java.lang.Object>)builder.esbuildArgs;
            this.esbuildVersion = builder.esbuildVersion;
            this.externalModules = builder.externalModules;
            this.footer = builder.footer;
            this.forceDockerBundling = builder.forceDockerBundling;
            this.format = builder.format;
            this.inject = builder.inject;
            this.keepNames = builder.keepNames;
            this.loader = builder.loader;
            this.logLevel = builder.logLevel;
            this.mainFields = builder.mainFields;
            this.metafile = builder.metafile;
            this.minify = builder.minify;
            this.nodeModules = builder.nodeModules;
            this.preCompilation = builder.preCompilation;
            this.sourceMap = builder.sourceMap;
            this.sourceMapMode = builder.sourceMapMode;
            this.sourcesContent = builder.sourcesContent;
            this.target = builder.target;
            this.tsconfig = builder.tsconfig;
            this.command = builder.command;
            this.entrypoint = builder.entrypoint;
            this.environment = builder.environment;
            this.network = builder.network;
            this.platform = builder.platform;
            this.securityOpt = builder.securityOpt;
            this.user = builder.user;
            this.volumes = (java.util.List<software.amazon.awscdk.DockerVolume>)builder.volumes;
            this.volumesFrom = builder.volumesFrom;
            this.workingDirectory = builder.workingDirectory;
        }

        @Override
        public final java.lang.String getAssetHash() {
            return this.assetHash;
        }

        @Override
        public final java.lang.String getBanner() {
            return this.banner;
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.String> getBuildArgs() {
            return this.buildArgs;
        }

        @Override
        public final java.lang.Boolean getBundleAwsSDK() {
            return this.bundleAwsSdk;
        }

        @Override
        public final software.amazon.awscdk.BundlingFileAccess getBundlingFileAccess() {
            return this.bundlingFileAccess;
        }

        @Override
        public final software.amazon.awscdk.services.lambda.nodejs.Charset getCharset() {
            return this.charset;
        }

        @Override
        public final software.amazon.awscdk.services.lambda.nodejs.ICommandHooks getCommandHooks() {
            return this.commandHooks;
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.String> getDefine() {
            return this.define;
        }

        @Override
        public final software.amazon.awscdk.DockerImage getDockerImage() {
            return this.dockerImage;
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.Object> getEsbuildArgs() {
            return this.esbuildArgs;
        }

        @Override
        public final java.lang.String getEsbuildVersion() {
            return this.esbuildVersion;
        }

        @Override
        public final java.util.List<java.lang.String> getExternalModules() {
            return this.externalModules;
        }

        @Override
        public final java.lang.String getFooter() {
            return this.footer;
        }

        @Override
        public final java.lang.Boolean getForceDockerBundling() {
            return this.forceDockerBundling;
        }

        @Override
        public final software.amazon.awscdk.services.lambda.nodejs.OutputFormat getFormat() {
            return this.format;
        }

        @Override
        public final java.util.List<java.lang.String> getInject() {
            return this.inject;
        }

        @Override
        public final java.lang.Boolean getKeepNames() {
            return this.keepNames;
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.String> getLoader() {
            return this.loader;
        }

        @Override
        public final software.amazon.awscdk.services.lambda.nodejs.LogLevel getLogLevel() {
            return this.logLevel;
        }

        @Override
        public final java.util.List<java.lang.String> getMainFields() {
            return this.mainFields;
        }

        @Override
        public final java.lang.Boolean getMetafile() {
            return this.metafile;
        }

        @Override
        public final java.lang.Boolean getMinify() {
            return this.minify;
        }

        @Override
        public final java.util.List<java.lang.String> getNodeModules() {
            return this.nodeModules;
        }

        @Override
        public final java.lang.Boolean getPreCompilation() {
            return this.preCompilation;
        }

        @Override
        public final java.lang.Boolean getSourceMap() {
            return this.sourceMap;
        }

        @Override
        public final software.amazon.awscdk.services.lambda.nodejs.SourceMapMode getSourceMapMode() {
            return this.sourceMapMode;
        }

        @Override
        public final java.lang.Boolean getSourcesContent() {
            return this.sourcesContent;
        }

        @Override
        public final java.lang.String getTarget() {
            return this.target;
        }

        @Override
        public final java.lang.String getTsconfig() {
            return this.tsconfig;
        }

        @Override
        public final java.util.List<java.lang.String> getCommand() {
            return this.command;
        }

        @Override
        public final java.util.List<java.lang.String> getEntrypoint() {
            return this.entrypoint;
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.String> getEnvironment() {
            return this.environment;
        }

        @Override
        public final java.lang.String getNetwork() {
            return this.network;
        }

        @Override
        public final java.lang.String getPlatform() {
            return this.platform;
        }

        @Override
        public final java.lang.String getSecurityOpt() {
            return this.securityOpt;
        }

        @Override
        public final java.lang.String getUser() {
            return this.user;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.DockerVolume> getVolumes() {
            return this.volumes;
        }

        @Override
        public final java.util.List<java.lang.String> getVolumesFrom() {
            return this.volumesFrom;
        }

        @Override
        public final java.lang.String getWorkingDirectory() {
            return this.workingDirectory;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getAssetHash() != null) {
                data.set("assetHash", om.valueToTree(this.getAssetHash()));
            }
            if (this.getBanner() != null) {
                data.set("banner", om.valueToTree(this.getBanner()));
            }
            if (this.getBuildArgs() != null) {
                data.set("buildArgs", om.valueToTree(this.getBuildArgs()));
            }
            if (this.getBundleAwsSDK() != null) {
                data.set("bundleAwsSDK", om.valueToTree(this.getBundleAwsSDK()));
            }
            if (this.getBundlingFileAccess() != null) {
                data.set("bundlingFileAccess", om.valueToTree(this.getBundlingFileAccess()));
            }
            if (this.getCharset() != null) {
                data.set("charset", om.valueToTree(this.getCharset()));
            }
            if (this.getCommandHooks() != null) {
                data.set("commandHooks", om.valueToTree(this.getCommandHooks()));
            }
            if (this.getDefine() != null) {
                data.set("define", om.valueToTree(this.getDefine()));
            }
            if (this.getDockerImage() != null) {
                data.set("dockerImage", om.valueToTree(this.getDockerImage()));
            }
            if (this.getEsbuildArgs() != null) {
                data.set("esbuildArgs", om.valueToTree(this.getEsbuildArgs()));
            }
            if (this.getEsbuildVersion() != null) {
                data.set("esbuildVersion", om.valueToTree(this.getEsbuildVersion()));
            }
            if (this.getExternalModules() != null) {
                data.set("externalModules", om.valueToTree(this.getExternalModules()));
            }
            if (this.getFooter() != null) {
                data.set("footer", om.valueToTree(this.getFooter()));
            }
            if (this.getForceDockerBundling() != null) {
                data.set("forceDockerBundling", om.valueToTree(this.getForceDockerBundling()));
            }
            if (this.getFormat() != null) {
                data.set("format", om.valueToTree(this.getFormat()));
            }
            if (this.getInject() != null) {
                data.set("inject", om.valueToTree(this.getInject()));
            }
            if (this.getKeepNames() != null) {
                data.set("keepNames", om.valueToTree(this.getKeepNames()));
            }
            if (this.getLoader() != null) {
                data.set("loader", om.valueToTree(this.getLoader()));
            }
            if (this.getLogLevel() != null) {
                data.set("logLevel", om.valueToTree(this.getLogLevel()));
            }
            if (this.getMainFields() != null) {
                data.set("mainFields", om.valueToTree(this.getMainFields()));
            }
            if (this.getMetafile() != null) {
                data.set("metafile", om.valueToTree(this.getMetafile()));
            }
            if (this.getMinify() != null) {
                data.set("minify", om.valueToTree(this.getMinify()));
            }
            if (this.getNodeModules() != null) {
                data.set("nodeModules", om.valueToTree(this.getNodeModules()));
            }
            if (this.getPreCompilation() != null) {
                data.set("preCompilation", om.valueToTree(this.getPreCompilation()));
            }
            if (this.getSourceMap() != null) {
                data.set("sourceMap", om.valueToTree(this.getSourceMap()));
            }
            if (this.getSourceMapMode() != null) {
                data.set("sourceMapMode", om.valueToTree(this.getSourceMapMode()));
            }
            if (this.getSourcesContent() != null) {
                data.set("sourcesContent", om.valueToTree(this.getSourcesContent()));
            }
            if (this.getTarget() != null) {
                data.set("target", om.valueToTree(this.getTarget()));
            }
            if (this.getTsconfig() != null) {
                data.set("tsconfig", om.valueToTree(this.getTsconfig()));
            }
            if (this.getCommand() != null) {
                data.set("command", om.valueToTree(this.getCommand()));
            }
            if (this.getEntrypoint() != null) {
                data.set("entrypoint", om.valueToTree(this.getEntrypoint()));
            }
            if (this.getEnvironment() != null) {
                data.set("environment", om.valueToTree(this.getEnvironment()));
            }
            if (this.getNetwork() != null) {
                data.set("network", om.valueToTree(this.getNetwork()));
            }
            if (this.getPlatform() != null) {
                data.set("platform", om.valueToTree(this.getPlatform()));
            }
            if (this.getSecurityOpt() != null) {
                data.set("securityOpt", om.valueToTree(this.getSecurityOpt()));
            }
            if (this.getUser() != null) {
                data.set("user", om.valueToTree(this.getUser()));
            }
            if (this.getVolumes() != null) {
                data.set("volumes", om.valueToTree(this.getVolumes()));
            }
            if (this.getVolumesFrom() != null) {
                data.set("volumesFrom", om.valueToTree(this.getVolumesFrom()));
            }
            if (this.getWorkingDirectory() != null) {
                data.set("workingDirectory", om.valueToTree(this.getWorkingDirectory()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_lambda_nodejs.BundlingOptions"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            BundlingOptions.Jsii$Proxy that = (BundlingOptions.Jsii$Proxy) o;

            if (this.assetHash != null ? !this.assetHash.equals(that.assetHash) : that.assetHash != null) return false;
            if (this.banner != null ? !this.banner.equals(that.banner) : that.banner != null) return false;
            if (this.buildArgs != null ? !this.buildArgs.equals(that.buildArgs) : that.buildArgs != null) return false;
            if (this.bundleAwsSdk != null ? !this.bundleAwsSdk.equals(that.bundleAwsSdk) : that.bundleAwsSdk != null) return false;
            if (this.bundlingFileAccess != null ? !this.bundlingFileAccess.equals(that.bundlingFileAccess) : that.bundlingFileAccess != null) return false;
            if (this.charset != null ? !this.charset.equals(that.charset) : that.charset != null) return false;
            if (this.commandHooks != null ? !this.commandHooks.equals(that.commandHooks) : that.commandHooks != null) return false;
            if (this.define != null ? !this.define.equals(that.define) : that.define != null) return false;
            if (this.dockerImage != null ? !this.dockerImage.equals(that.dockerImage) : that.dockerImage != null) return false;
            if (this.esbuildArgs != null ? !this.esbuildArgs.equals(that.esbuildArgs) : that.esbuildArgs != null) return false;
            if (this.esbuildVersion != null ? !this.esbuildVersion.equals(that.esbuildVersion) : that.esbuildVersion != null) return false;
            if (this.externalModules != null ? !this.externalModules.equals(that.externalModules) : that.externalModules != null) return false;
            if (this.footer != null ? !this.footer.equals(that.footer) : that.footer != null) return false;
            if (this.forceDockerBundling != null ? !this.forceDockerBundling.equals(that.forceDockerBundling) : that.forceDockerBundling != null) return false;
            if (this.format != null ? !this.format.equals(that.format) : that.format != null) return false;
            if (this.inject != null ? !this.inject.equals(that.inject) : that.inject != null) return false;
            if (this.keepNames != null ? !this.keepNames.equals(that.keepNames) : that.keepNames != null) return false;
            if (this.loader != null ? !this.loader.equals(that.loader) : that.loader != null) return false;
            if (this.logLevel != null ? !this.logLevel.equals(that.logLevel) : that.logLevel != null) return false;
            if (this.mainFields != null ? !this.mainFields.equals(that.mainFields) : that.mainFields != null) return false;
            if (this.metafile != null ? !this.metafile.equals(that.metafile) : that.metafile != null) return false;
            if (this.minify != null ? !this.minify.equals(that.minify) : that.minify != null) return false;
            if (this.nodeModules != null ? !this.nodeModules.equals(that.nodeModules) : that.nodeModules != null) return false;
            if (this.preCompilation != null ? !this.preCompilation.equals(that.preCompilation) : that.preCompilation != null) return false;
            if (this.sourceMap != null ? !this.sourceMap.equals(that.sourceMap) : that.sourceMap != null) return false;
            if (this.sourceMapMode != null ? !this.sourceMapMode.equals(that.sourceMapMode) : that.sourceMapMode != null) return false;
            if (this.sourcesContent != null ? !this.sourcesContent.equals(that.sourcesContent) : that.sourcesContent != null) return false;
            if (this.target != null ? !this.target.equals(that.target) : that.target != null) return false;
            if (this.tsconfig != null ? !this.tsconfig.equals(that.tsconfig) : that.tsconfig != null) return false;
            if (this.command != null ? !this.command.equals(that.command) : that.command != null) return false;
            if (this.entrypoint != null ? !this.entrypoint.equals(that.entrypoint) : that.entrypoint != null) return false;
            if (this.environment != null ? !this.environment.equals(that.environment) : that.environment != null) return false;
            if (this.network != null ? !this.network.equals(that.network) : that.network != null) return false;
            if (this.platform != null ? !this.platform.equals(that.platform) : that.platform != null) return false;
            if (this.securityOpt != null ? !this.securityOpt.equals(that.securityOpt) : that.securityOpt != null) return false;
            if (this.user != null ? !this.user.equals(that.user) : that.user != null) return false;
            if (this.volumes != null ? !this.volumes.equals(that.volumes) : that.volumes != null) return false;
            if (this.volumesFrom != null ? !this.volumesFrom.equals(that.volumesFrom) : that.volumesFrom != null) return false;
            return this.workingDirectory != null ? this.workingDirectory.equals(that.workingDirectory) : that.workingDirectory == null;
        }

        @Override
        public final int hashCode() {
            int result = this.assetHash != null ? this.assetHash.hashCode() : 0;
            result = 31 * result + (this.banner != null ? this.banner.hashCode() : 0);
            result = 31 * result + (this.buildArgs != null ? this.buildArgs.hashCode() : 0);
            result = 31 * result + (this.bundleAwsSdk != null ? this.bundleAwsSdk.hashCode() : 0);
            result = 31 * result + (this.bundlingFileAccess != null ? this.bundlingFileAccess.hashCode() : 0);
            result = 31 * result + (this.charset != null ? this.charset.hashCode() : 0);
            result = 31 * result + (this.commandHooks != null ? this.commandHooks.hashCode() : 0);
            result = 31 * result + (this.define != null ? this.define.hashCode() : 0);
            result = 31 * result + (this.dockerImage != null ? this.dockerImage.hashCode() : 0);
            result = 31 * result + (this.esbuildArgs != null ? this.esbuildArgs.hashCode() : 0);
            result = 31 * result + (this.esbuildVersion != null ? this.esbuildVersion.hashCode() : 0);
            result = 31 * result + (this.externalModules != null ? this.externalModules.hashCode() : 0);
            result = 31 * result + (this.footer != null ? this.footer.hashCode() : 0);
            result = 31 * result + (this.forceDockerBundling != null ? this.forceDockerBundling.hashCode() : 0);
            result = 31 * result + (this.format != null ? this.format.hashCode() : 0);
            result = 31 * result + (this.inject != null ? this.inject.hashCode() : 0);
            result = 31 * result + (this.keepNames != null ? this.keepNames.hashCode() : 0);
            result = 31 * result + (this.loader != null ? this.loader.hashCode() : 0);
            result = 31 * result + (this.logLevel != null ? this.logLevel.hashCode() : 0);
            result = 31 * result + (this.mainFields != null ? this.mainFields.hashCode() : 0);
            result = 31 * result + (this.metafile != null ? this.metafile.hashCode() : 0);
            result = 31 * result + (this.minify != null ? this.minify.hashCode() : 0);
            result = 31 * result + (this.nodeModules != null ? this.nodeModules.hashCode() : 0);
            result = 31 * result + (this.preCompilation != null ? this.preCompilation.hashCode() : 0);
            result = 31 * result + (this.sourceMap != null ? this.sourceMap.hashCode() : 0);
            result = 31 * result + (this.sourceMapMode != null ? this.sourceMapMode.hashCode() : 0);
            result = 31 * result + (this.sourcesContent != null ? this.sourcesContent.hashCode() : 0);
            result = 31 * result + (this.target != null ? this.target.hashCode() : 0);
            result = 31 * result + (this.tsconfig != null ? this.tsconfig.hashCode() : 0);
            result = 31 * result + (this.command != null ? this.command.hashCode() : 0);
            result = 31 * result + (this.entrypoint != null ? this.entrypoint.hashCode() : 0);
            result = 31 * result + (this.environment != null ? this.environment.hashCode() : 0);
            result = 31 * result + (this.network != null ? this.network.hashCode() : 0);
            result = 31 * result + (this.platform != null ? this.platform.hashCode() : 0);
            result = 31 * result + (this.securityOpt != null ? this.securityOpt.hashCode() : 0);
            result = 31 * result + (this.user != null ? this.user.hashCode() : 0);
            result = 31 * result + (this.volumes != null ? this.volumes.hashCode() : 0);
            result = 31 * result + (this.volumesFrom != null ? this.volumesFrom.hashCode() : 0);
            result = 31 * result + (this.workingDirectory != null ? this.workingDirectory.hashCode() : 0);
            return result;
        }
    }
}
