package software.amazon.awscdk.services.lightsail;

/**
 * Properties for defining a <code>CfnStaticIp</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.lightsail.*;
 * CfnStaticIpProps cfnStaticIpProps = CfnStaticIpProps.builder()
 *         .staticIpName("staticIpName")
 *         // the properties below are optional
 *         .attachedTo("attachedTo")
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lightsail-staticip.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lightsail-staticip.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-01-25T00:20:58.187Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lightsail.CfnStaticIpProps")
@software.amazon.jsii.Jsii.Proxy(CfnStaticIpProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnStaticIpProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The name of the static IP.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lightsail-staticip.html#cfn-lightsail-staticip-staticipname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lightsail-staticip.html#cfn-lightsail-staticip-staticipname</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getStaticIpName();

    /**
     * The instance that the static IP is attached to.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lightsail-staticip.html#cfn-lightsail-staticip-attachedto">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lightsail-staticip.html#cfn-lightsail-staticip-attachedto</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getAttachedTo() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnStaticIpProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnStaticIpProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnStaticIpProps> {
        java.lang.String staticIpName;
        java.lang.String attachedTo;

        /**
         * Sets the value of {@link CfnStaticIpProps#getStaticIpName}
         * @param staticIpName The name of the static IP. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder staticIpName(java.lang.String staticIpName) {
            this.staticIpName = staticIpName;
            return this;
        }

        /**
         * Sets the value of {@link CfnStaticIpProps#getAttachedTo}
         * @param attachedTo The instance that the static IP is attached to.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder attachedTo(java.lang.String attachedTo) {
            this.attachedTo = attachedTo;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnStaticIpProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnStaticIpProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnStaticIpProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnStaticIpProps {
        private final java.lang.String staticIpName;
        private final java.lang.String attachedTo;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.staticIpName = software.amazon.jsii.Kernel.get(this, "staticIpName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.attachedTo = software.amazon.jsii.Kernel.get(this, "attachedTo", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.staticIpName = java.util.Objects.requireNonNull(builder.staticIpName, "staticIpName is required");
            this.attachedTo = builder.attachedTo;
        }

        @Override
        public final java.lang.String getStaticIpName() {
            return this.staticIpName;
        }

        @Override
        public final java.lang.String getAttachedTo() {
            return this.attachedTo;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("staticIpName", om.valueToTree(this.getStaticIpName()));
            if (this.getAttachedTo() != null) {
                data.set("attachedTo", om.valueToTree(this.getAttachedTo()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_lightsail.CfnStaticIpProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnStaticIpProps.Jsii$Proxy that = (CfnStaticIpProps.Jsii$Proxy) o;

            if (!staticIpName.equals(that.staticIpName)) return false;
            return this.attachedTo != null ? this.attachedTo.equals(that.attachedTo) : that.attachedTo == null;
        }

        @Override
        public final int hashCode() {
            int result = this.staticIpName.hashCode();
            result = 31 * result + (this.attachedTo != null ? this.attachedTo.hashCode() : 0);
            return result;
        }
    }
}
