package software.amazon.awscdk.services.mwaa;

/**
 * Properties for defining a <code>CfnEnvironment</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.mwaa.*;
 * Object airflowConfigurationOptions;
 * Object tags;
 * CfnEnvironmentProps cfnEnvironmentProps = CfnEnvironmentProps.builder()
 *         .name("name")
 *         // the properties below are optional
 *         .airflowConfigurationOptions(airflowConfigurationOptions)
 *         .airflowVersion("airflowVersion")
 *         .dagS3Path("dagS3Path")
 *         .endpointManagement("endpointManagement")
 *         .environmentClass("environmentClass")
 *         .executionRoleArn("executionRoleArn")
 *         .kmsKey("kmsKey")
 *         .loggingConfiguration(LoggingConfigurationProperty.builder()
 *                 .dagProcessingLogs(ModuleLoggingConfigurationProperty.builder()
 *                         .cloudWatchLogGroupArn("cloudWatchLogGroupArn")
 *                         .enabled(false)
 *                         .logLevel("logLevel")
 *                         .build())
 *                 .schedulerLogs(ModuleLoggingConfigurationProperty.builder()
 *                         .cloudWatchLogGroupArn("cloudWatchLogGroupArn")
 *                         .enabled(false)
 *                         .logLevel("logLevel")
 *                         .build())
 *                 .taskLogs(ModuleLoggingConfigurationProperty.builder()
 *                         .cloudWatchLogGroupArn("cloudWatchLogGroupArn")
 *                         .enabled(false)
 *                         .logLevel("logLevel")
 *                         .build())
 *                 .webserverLogs(ModuleLoggingConfigurationProperty.builder()
 *                         .cloudWatchLogGroupArn("cloudWatchLogGroupArn")
 *                         .enabled(false)
 *                         .logLevel("logLevel")
 *                         .build())
 *                 .workerLogs(ModuleLoggingConfigurationProperty.builder()
 *                         .cloudWatchLogGroupArn("cloudWatchLogGroupArn")
 *                         .enabled(false)
 *                         .logLevel("logLevel")
 *                         .build())
 *                 .build())
 *         .maxWebservers(123)
 *         .maxWorkers(123)
 *         .minWebservers(123)
 *         .minWorkers(123)
 *         .networkConfiguration(NetworkConfigurationProperty.builder()
 *                 .securityGroupIds(List.of("securityGroupIds"))
 *                 .subnetIds(List.of("subnetIds"))
 *                 .build())
 *         .pluginsS3ObjectVersion("pluginsS3ObjectVersion")
 *         .pluginsS3Path("pluginsS3Path")
 *         .requirementsS3ObjectVersion("requirementsS3ObjectVersion")
 *         .requirementsS3Path("requirementsS3Path")
 *         .schedulers(123)
 *         .sourceBucketArn("sourceBucketArn")
 *         .startupScriptS3ObjectVersion("startupScriptS3ObjectVersion")
 *         .startupScriptS3Path("startupScriptS3Path")
 *         .tags(tags)
 *         .webserverAccessMode("webserverAccessMode")
 *         .weeklyMaintenanceWindowStart("weeklyMaintenanceWindowStart")
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mwaa-environment.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mwaa-environment.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-01-25T00:20:58.831Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_mwaa.CfnEnvironmentProps")
@software.amazon.jsii.Jsii.Proxy(CfnEnvironmentProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnEnvironmentProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The name of your Amazon MWAA environment.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mwaa-environment.html#cfn-mwaa-environment-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mwaa-environment.html#cfn-mwaa-environment-name</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getName();

    /**
     * A list of key-value pairs containing the Airflow configuration options for your environment.
     * <p>
     * For example, <code>core.default_timezone: utc</code> . To learn more, see <a href="https://docs.aws.amazon.com/mwaa/latest/userguide/configuring-env-variables.html">Apache Airflow configuration options</a> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mwaa-environment.html#cfn-mwaa-environment-airflowconfigurationoptions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mwaa-environment.html#cfn-mwaa-environment-airflowconfigurationoptions</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getAirflowConfigurationOptions() {
        return null;
    }

    /**
     * The version of Apache Airflow to use for the environment.
     * <p>
     * If no value is specified, defaults to the latest version.
     * <p>
     * If you specify a newer version number for an existing environment, the version update requires some service interruption before taking effect.
     * <p>
     * <em>Allowed Values</em> : <code>1.10.12</code> | <code>2.0.2</code> | <code>2.2.2</code> | <code>2.4.3</code> | <code>2.5.1</code> | <code>2.6.3</code> | <code>2.7.2</code> | <code>2.8.1</code> | <code>2.9.2</code> (latest)
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mwaa-environment.html#cfn-mwaa-environment-airflowversion">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mwaa-environment.html#cfn-mwaa-environment-airflowversion</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getAirflowVersion() {
        return null;
    }

    /**
     * The relative path to the DAGs folder on your Amazon S3 bucket.
     * <p>
     * For example, <code>dags</code> . To learn more, see <a href="https://docs.aws.amazon.com/mwaa/latest/userguide/configuring-dag-folder.html">Adding or updating DAGs</a> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mwaa-environment.html#cfn-mwaa-environment-dags3path">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mwaa-environment.html#cfn-mwaa-environment-dags3path</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDagS3Path() {
        return null;
    }

    /**
     * Defines whether the VPC endpoints configured for the environment are created, and managed, by the customer or by Amazon MWAA.
     * <p>
     * If set to <code>SERVICE</code> , Amazon MWAA will create and manage the required VPC endpoints in your VPC. If set to <code>CUSTOMER</code> , you must create, and manage, the VPC endpoints in your VPC.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mwaa-environment.html#cfn-mwaa-environment-endpointmanagement">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mwaa-environment.html#cfn-mwaa-environment-endpointmanagement</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getEndpointManagement() {
        return null;
    }

    /**
     * The environment class type.
     * <p>
     * Valid values: <code>mw1.small</code> , <code>mw1.medium</code> , <code>mw1.large</code> . To learn more, see <a href="https://docs.aws.amazon.com/mwaa/latest/userguide/environment-class.html">Amazon MWAA environment class</a> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mwaa-environment.html#cfn-mwaa-environment-environmentclass">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mwaa-environment.html#cfn-mwaa-environment-environmentclass</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getEnvironmentClass() {
        return null;
    }

    /**
     * The Amazon Resource Name (ARN) of the execution role in IAM that allows MWAA to access AWS resources in your environment.
     * <p>
     * For example, <code>arn:aws:iam::123456789:role/my-execution-role</code> . To learn more, see <a href="https://docs.aws.amazon.com/mwaa/latest/userguide/mwaa-create-role.html">Amazon MWAA Execution role</a> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mwaa-environment.html#cfn-mwaa-environment-executionrolearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mwaa-environment.html#cfn-mwaa-environment-executionrolearn</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getExecutionRoleArn() {
        return null;
    }

    /**
     * The AWS Key Management Service (KMS) key to encrypt and decrypt the data in your environment.
     * <p>
     * You can use an AWS KMS key managed by MWAA, or a customer-managed KMS key (advanced).
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mwaa-environment.html#cfn-mwaa-environment-kmskey">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mwaa-environment.html#cfn-mwaa-environment-kmskey</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getKmsKey() {
        return null;
    }

    /**
     * The Apache Airflow logs being sent to CloudWatch Logs: <code>DagProcessingLogs</code> , <code>SchedulerLogs</code> , <code>TaskLogs</code> , <code>WebserverLogs</code> , <code>WorkerLogs</code> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mwaa-environment.html#cfn-mwaa-environment-loggingconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mwaa-environment.html#cfn-mwaa-environment-loggingconfiguration</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getLoggingConfiguration() {
        return null;
    }

    /**
     * The maximum number of web servers that you want to run in your environment.
     * <p>
     * Amazon MWAA scales the number of Apache Airflow web servers up to the number you specify for <code>MaxWebservers</code> when you interact with your Apache Airflow environment using Apache Airflow REST API, or the Apache Airflow CLI. For example, in scenarios where your workload requires network calls to the Apache Airflow REST API with a high transaction-per-second (TPS) rate, Amazon MWAA will increase the number of web servers up to the number set in <code>MaxWebserers</code> . As TPS rates decrease Amazon MWAA disposes of the additional web servers, and scales down to the number set in <code>MinxWebserers</code> .
     * <p>
     * Valid values: For environments larger than mw1.micro, accepts values from <code>2</code> to <code>5</code> . Defaults to <code>2</code> for all environment sizes except mw1.micro, which defaults to <code>1</code> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mwaa-environment.html#cfn-mwaa-environment-maxwebservers">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mwaa-environment.html#cfn-mwaa-environment-maxwebservers</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getMaxWebservers() {
        return null;
    }

    /**
     * The maximum number of workers that you want to run in your environment.
     * <p>
     * MWAA scales the number of Apache Airflow workers up to the number you specify in the <code>MaxWorkers</code> field. For example, <code>20</code> . When there are no more tasks running, and no more in the queue, MWAA disposes of the extra workers leaving the one worker that is included with your environment, or the number you specify in <code>MinWorkers</code> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mwaa-environment.html#cfn-mwaa-environment-maxworkers">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mwaa-environment.html#cfn-mwaa-environment-maxworkers</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getMaxWorkers() {
        return null;
    }

    /**
     * The minimum number of web servers that you want to run in your environment.
     * <p>
     * Amazon MWAA scales the number of Apache Airflow web servers up to the number you specify for <code>MaxWebservers</code> when you interact with your Apache Airflow environment using Apache Airflow REST API, or the Apache Airflow CLI. As the transaction-per-second rate, and the network load, decrease, Amazon MWAA disposes of the additional web servers, and scales down to the number set in <code>MinxWebserers</code> .
     * <p>
     * Valid values: For environments larger than mw1.micro, accepts values from <code>2</code> to <code>5</code> . Defaults to <code>2</code> for all environment sizes except mw1.micro, which defaults to <code>1</code> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mwaa-environment.html#cfn-mwaa-environment-minwebservers">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mwaa-environment.html#cfn-mwaa-environment-minwebservers</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getMinWebservers() {
        return null;
    }

    /**
     * The minimum number of workers that you want to run in your environment.
     * <p>
     * MWAA scales the number of Apache Airflow workers up to the number you specify in the <code>MaxWorkers</code> field. When there are no more tasks running, and no more in the queue, MWAA disposes of the extra workers leaving the worker count you specify in the <code>MinWorkers</code> field. For example, <code>2</code> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mwaa-environment.html#cfn-mwaa-environment-minworkers">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mwaa-environment.html#cfn-mwaa-environment-minworkers</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getMinWorkers() {
        return null;
    }

    /**
     * The VPC networking components used to secure and enable network traffic between the AWS resources for your environment.
     * <p>
     * To learn more, see <a href="https://docs.aws.amazon.com/mwaa/latest/userguide/networking-about.html">About networking on Amazon MWAA</a> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mwaa-environment.html#cfn-mwaa-environment-networkconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mwaa-environment.html#cfn-mwaa-environment-networkconfiguration</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getNetworkConfiguration() {
        return null;
    }

    /**
     * The version of the plugins.zip file on your Amazon S3 bucket. To learn more, see <a href="https://docs.aws.amazon.com/mwaa/latest/userguide/configuring-dag-import-plugins.html">Installing custom plugins</a> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mwaa-environment.html#cfn-mwaa-environment-pluginss3objectversion">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mwaa-environment.html#cfn-mwaa-environment-pluginss3objectversion</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getPluginsS3ObjectVersion() {
        return null;
    }

    /**
     * The relative path to the <code>plugins.zip</code> file on your Amazon S3 bucket. For example, <code>plugins.zip</code> . To learn more, see <a href="https://docs.aws.amazon.com/mwaa/latest/userguide/configuring-dag-import-plugins.html">Installing custom plugins</a> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mwaa-environment.html#cfn-mwaa-environment-pluginss3path">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mwaa-environment.html#cfn-mwaa-environment-pluginss3path</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getPluginsS3Path() {
        return null;
    }

    /**
     * The version of the requirements.txt file on your Amazon S3 bucket. To learn more, see <a href="https://docs.aws.amazon.com/mwaa/latest/userguide/working-dags-dependencies.html">Installing Python dependencies</a> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mwaa-environment.html#cfn-mwaa-environment-requirementss3objectversion">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mwaa-environment.html#cfn-mwaa-environment-requirementss3objectversion</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getRequirementsS3ObjectVersion() {
        return null;
    }

    /**
     * The relative path to the <code>requirements.txt</code> file on your Amazon S3 bucket. For example, <code>requirements.txt</code> . To learn more, see <a href="https://docs.aws.amazon.com/mwaa/latest/userguide/working-dags-dependencies.html">Installing Python dependencies</a> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mwaa-environment.html#cfn-mwaa-environment-requirementss3path">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mwaa-environment.html#cfn-mwaa-environment-requirementss3path</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getRequirementsS3Path() {
        return null;
    }

    /**
     * The number of schedulers that you want to run in your environment. Valid values:.
     * <p>
     * <ul>
     * <li><em>v2</em> - Accepts between 2 to 5. Defaults to 2.</li>
     * <li><em>v1</em> - Accepts 1.</li>
     * </ul>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mwaa-environment.html#cfn-mwaa-environment-schedulers">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mwaa-environment.html#cfn-mwaa-environment-schedulers</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getSchedulers() {
        return null;
    }

    /**
     * The Amazon Resource Name (ARN) of the Amazon S3 bucket where your DAG code and supporting files are stored.
     * <p>
     * For example, <code>arn:aws:s3:::my-airflow-bucket-unique-name</code> . To learn more, see <a href="https://docs.aws.amazon.com/mwaa/latest/userguide/mwaa-s3-bucket.html">Create an Amazon S3 bucket for Amazon MWAA</a> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mwaa-environment.html#cfn-mwaa-environment-sourcebucketarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mwaa-environment.html#cfn-mwaa-environment-sourcebucketarn</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getSourceBucketArn() {
        return null;
    }

    /**
     * The version of the startup shell script in your Amazon S3 bucket.
     * <p>
     * You must specify the <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/versioning-workflows.html">version ID</a> that Amazon S3 assigns to the file every time you update the script.
     * <p>
     * Version IDs are Unicode, UTF-8 encoded, URL-ready, opaque strings that are no more than 1,024 bytes long. The following is an example:
     * <p>
     * <code>3sL4kqtJlcpXroDTDmJ+rmSpXd3dIbrHY+MTRCxf3vjVBH40Nr8X8gdRQBpUMLUo</code>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/mwaa/latest/userguide/using-startup-script.html">Using a startup script</a> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mwaa-environment.html#cfn-mwaa-environment-startupscripts3objectversion">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mwaa-environment.html#cfn-mwaa-environment-startupscripts3objectversion</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getStartupScriptS3ObjectVersion() {
        return null;
    }

    /**
     * The relative path to the startup shell script in your Amazon S3 bucket. For example, <code>s3://mwaa-environment/startup.sh</code> .
     * <p>
     * Amazon MWAA runs the script as your environment starts, and before running the Apache Airflow process. You can use this script to install dependencies, modify Apache Airflow configuration options, and set environment variables. For more information, see <a href="https://docs.aws.amazon.com/mwaa/latest/userguide/using-startup-script.html">Using a startup script</a> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mwaa-environment.html#cfn-mwaa-environment-startupscripts3path">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mwaa-environment.html#cfn-mwaa-environment-startupscripts3path</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getStartupScriptS3Path() {
        return null;
    }

    /**
     * The key-value tag pairs associated to your environment. For example, <code>"Environment": "Staging"</code> . To learn more, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging</a> .
     * <p>
     * If you specify new tags for an existing environment, the update requires service interruption before taking effect.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mwaa-environment.html#cfn-mwaa-environment-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mwaa-environment.html#cfn-mwaa-environment-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getTags() {
        return null;
    }

    /**
     * The Apache Airflow <em>Web server</em> access mode.
     * <p>
     * To learn more, see <a href="https://docs.aws.amazon.com/mwaa/latest/userguide/configuring-networking.html">Apache Airflow access modes</a> . Valid values: <code>PRIVATE_ONLY</code> or <code>PUBLIC_ONLY</code> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mwaa-environment.html#cfn-mwaa-environment-webserveraccessmode">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mwaa-environment.html#cfn-mwaa-environment-webserveraccessmode</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getWebserverAccessMode() {
        return null;
    }

    /**
     * The day and time of the week to start weekly maintenance updates of your environment in the following format: <code>DAY:HH:MM</code> .
     * <p>
     * For example: <code>TUE:03:30</code> . You can specify a start time in 30 minute increments only. Supported input includes the following:
     * <p>
     * <ul>
     * <li>MON|TUE|WED|THU|FRI|SAT|SUN:([01]\d|2[0-3]):(00|30)</li>
     * </ul>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mwaa-environment.html#cfn-mwaa-environment-weeklymaintenancewindowstart">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mwaa-environment.html#cfn-mwaa-environment-weeklymaintenancewindowstart</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getWeeklyMaintenanceWindowStart() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnEnvironmentProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnEnvironmentProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnEnvironmentProps> {
        java.lang.String name;
        java.lang.Object airflowConfigurationOptions;
        java.lang.String airflowVersion;
        java.lang.String dagS3Path;
        java.lang.String endpointManagement;
        java.lang.String environmentClass;
        java.lang.String executionRoleArn;
        java.lang.String kmsKey;
        java.lang.Object loggingConfiguration;
        java.lang.Number maxWebservers;
        java.lang.Number maxWorkers;
        java.lang.Number minWebservers;
        java.lang.Number minWorkers;
        java.lang.Object networkConfiguration;
        java.lang.String pluginsS3ObjectVersion;
        java.lang.String pluginsS3Path;
        java.lang.String requirementsS3ObjectVersion;
        java.lang.String requirementsS3Path;
        java.lang.Number schedulers;
        java.lang.String sourceBucketArn;
        java.lang.String startupScriptS3ObjectVersion;
        java.lang.String startupScriptS3Path;
        java.lang.Object tags;
        java.lang.String webserverAccessMode;
        java.lang.String weeklyMaintenanceWindowStart;

        /**
         * Sets the value of {@link CfnEnvironmentProps#getName}
         * @param name The name of your Amazon MWAA environment. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of {@link CfnEnvironmentProps#getAirflowConfigurationOptions}
         * @param airflowConfigurationOptions A list of key-value pairs containing the Airflow configuration options for your environment.
         *                                    For example, <code>core.default_timezone: utc</code> . To learn more, see <a href="https://docs.aws.amazon.com/mwaa/latest/userguide/configuring-env-variables.html">Apache Airflow configuration options</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder airflowConfigurationOptions(java.lang.Object airflowConfigurationOptions) {
            this.airflowConfigurationOptions = airflowConfigurationOptions;
            return this;
        }

        /**
         * Sets the value of {@link CfnEnvironmentProps#getAirflowVersion}
         * @param airflowVersion The version of Apache Airflow to use for the environment.
         *                       If no value is specified, defaults to the latest version.
         *                       <p>
         *                       If you specify a newer version number for an existing environment, the version update requires some service interruption before taking effect.
         *                       <p>
         *                       <em>Allowed Values</em> : <code>1.10.12</code> | <code>2.0.2</code> | <code>2.2.2</code> | <code>2.4.3</code> | <code>2.5.1</code> | <code>2.6.3</code> | <code>2.7.2</code> | <code>2.8.1</code> | <code>2.9.2</code> (latest)
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder airflowVersion(java.lang.String airflowVersion) {
            this.airflowVersion = airflowVersion;
            return this;
        }

        /**
         * Sets the value of {@link CfnEnvironmentProps#getDagS3Path}
         * @param dagS3Path The relative path to the DAGs folder on your Amazon S3 bucket.
         *                  For example, <code>dags</code> . To learn more, see <a href="https://docs.aws.amazon.com/mwaa/latest/userguide/configuring-dag-folder.html">Adding or updating DAGs</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dagS3Path(java.lang.String dagS3Path) {
            this.dagS3Path = dagS3Path;
            return this;
        }

        /**
         * Sets the value of {@link CfnEnvironmentProps#getEndpointManagement}
         * @param endpointManagement Defines whether the VPC endpoints configured for the environment are created, and managed, by the customer or by Amazon MWAA.
         *                           If set to <code>SERVICE</code> , Amazon MWAA will create and manage the required VPC endpoints in your VPC. If set to <code>CUSTOMER</code> , you must create, and manage, the VPC endpoints in your VPC.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder endpointManagement(java.lang.String endpointManagement) {
            this.endpointManagement = endpointManagement;
            return this;
        }

        /**
         * Sets the value of {@link CfnEnvironmentProps#getEnvironmentClass}
         * @param environmentClass The environment class type.
         *                         Valid values: <code>mw1.small</code> , <code>mw1.medium</code> , <code>mw1.large</code> . To learn more, see <a href="https://docs.aws.amazon.com/mwaa/latest/userguide/environment-class.html">Amazon MWAA environment class</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder environmentClass(java.lang.String environmentClass) {
            this.environmentClass = environmentClass;
            return this;
        }

        /**
         * Sets the value of {@link CfnEnvironmentProps#getExecutionRoleArn}
         * @param executionRoleArn The Amazon Resource Name (ARN) of the execution role in IAM that allows MWAA to access AWS resources in your environment.
         *                         For example, <code>arn:aws:iam::123456789:role/my-execution-role</code> . To learn more, see <a href="https://docs.aws.amazon.com/mwaa/latest/userguide/mwaa-create-role.html">Amazon MWAA Execution role</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder executionRoleArn(java.lang.String executionRoleArn) {
            this.executionRoleArn = executionRoleArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnEnvironmentProps#getKmsKey}
         * @param kmsKey The AWS Key Management Service (KMS) key to encrypt and decrypt the data in your environment.
         *               You can use an AWS KMS key managed by MWAA, or a customer-managed KMS key (advanced).
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder kmsKey(java.lang.String kmsKey) {
            this.kmsKey = kmsKey;
            return this;
        }

        /**
         * Sets the value of {@link CfnEnvironmentProps#getLoggingConfiguration}
         * @param loggingConfiguration The Apache Airflow logs being sent to CloudWatch Logs: <code>DagProcessingLogs</code> , <code>SchedulerLogs</code> , <code>TaskLogs</code> , <code>WebserverLogs</code> , <code>WorkerLogs</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder loggingConfiguration(software.amazon.awscdk.IResolvable loggingConfiguration) {
            this.loggingConfiguration = loggingConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnEnvironmentProps#getLoggingConfiguration}
         * @param loggingConfiguration The Apache Airflow logs being sent to CloudWatch Logs: <code>DagProcessingLogs</code> , <code>SchedulerLogs</code> , <code>TaskLogs</code> , <code>WebserverLogs</code> , <code>WorkerLogs</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder loggingConfiguration(software.amazon.awscdk.services.mwaa.CfnEnvironment.LoggingConfigurationProperty loggingConfiguration) {
            this.loggingConfiguration = loggingConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnEnvironmentProps#getMaxWebservers}
         * @param maxWebservers The maximum number of web servers that you want to run in your environment.
         *                      Amazon MWAA scales the number of Apache Airflow web servers up to the number you specify for <code>MaxWebservers</code> when you interact with your Apache Airflow environment using Apache Airflow REST API, or the Apache Airflow CLI. For example, in scenarios where your workload requires network calls to the Apache Airflow REST API with a high transaction-per-second (TPS) rate, Amazon MWAA will increase the number of web servers up to the number set in <code>MaxWebserers</code> . As TPS rates decrease Amazon MWAA disposes of the additional web servers, and scales down to the number set in <code>MinxWebserers</code> .
         *                      <p>
         *                      Valid values: For environments larger than mw1.micro, accepts values from <code>2</code> to <code>5</code> . Defaults to <code>2</code> for all environment sizes except mw1.micro, which defaults to <code>1</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxWebservers(java.lang.Number maxWebservers) {
            this.maxWebservers = maxWebservers;
            return this;
        }

        /**
         * Sets the value of {@link CfnEnvironmentProps#getMaxWorkers}
         * @param maxWorkers The maximum number of workers that you want to run in your environment.
         *                   MWAA scales the number of Apache Airflow workers up to the number you specify in the <code>MaxWorkers</code> field. For example, <code>20</code> . When there are no more tasks running, and no more in the queue, MWAA disposes of the extra workers leaving the one worker that is included with your environment, or the number you specify in <code>MinWorkers</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxWorkers(java.lang.Number maxWorkers) {
            this.maxWorkers = maxWorkers;
            return this;
        }

        /**
         * Sets the value of {@link CfnEnvironmentProps#getMinWebservers}
         * @param minWebservers The minimum number of web servers that you want to run in your environment.
         *                      Amazon MWAA scales the number of Apache Airflow web servers up to the number you specify for <code>MaxWebservers</code> when you interact with your Apache Airflow environment using Apache Airflow REST API, or the Apache Airflow CLI. As the transaction-per-second rate, and the network load, decrease, Amazon MWAA disposes of the additional web servers, and scales down to the number set in <code>MinxWebserers</code> .
         *                      <p>
         *                      Valid values: For environments larger than mw1.micro, accepts values from <code>2</code> to <code>5</code> . Defaults to <code>2</code> for all environment sizes except mw1.micro, which defaults to <code>1</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder minWebservers(java.lang.Number minWebservers) {
            this.minWebservers = minWebservers;
            return this;
        }

        /**
         * Sets the value of {@link CfnEnvironmentProps#getMinWorkers}
         * @param minWorkers The minimum number of workers that you want to run in your environment.
         *                   MWAA scales the number of Apache Airflow workers up to the number you specify in the <code>MaxWorkers</code> field. When there are no more tasks running, and no more in the queue, MWAA disposes of the extra workers leaving the worker count you specify in the <code>MinWorkers</code> field. For example, <code>2</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder minWorkers(java.lang.Number minWorkers) {
            this.minWorkers = minWorkers;
            return this;
        }

        /**
         * Sets the value of {@link CfnEnvironmentProps#getNetworkConfiguration}
         * @param networkConfiguration The VPC networking components used to secure and enable network traffic between the AWS resources for your environment.
         *                             To learn more, see <a href="https://docs.aws.amazon.com/mwaa/latest/userguide/networking-about.html">About networking on Amazon MWAA</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder networkConfiguration(software.amazon.awscdk.IResolvable networkConfiguration) {
            this.networkConfiguration = networkConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnEnvironmentProps#getNetworkConfiguration}
         * @param networkConfiguration The VPC networking components used to secure and enable network traffic between the AWS resources for your environment.
         *                             To learn more, see <a href="https://docs.aws.amazon.com/mwaa/latest/userguide/networking-about.html">About networking on Amazon MWAA</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder networkConfiguration(software.amazon.awscdk.services.mwaa.CfnEnvironment.NetworkConfigurationProperty networkConfiguration) {
            this.networkConfiguration = networkConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnEnvironmentProps#getPluginsS3ObjectVersion}
         * @param pluginsS3ObjectVersion The version of the plugins.zip file on your Amazon S3 bucket. To learn more, see <a href="https://docs.aws.amazon.com/mwaa/latest/userguide/configuring-dag-import-plugins.html">Installing custom plugins</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder pluginsS3ObjectVersion(java.lang.String pluginsS3ObjectVersion) {
            this.pluginsS3ObjectVersion = pluginsS3ObjectVersion;
            return this;
        }

        /**
         * Sets the value of {@link CfnEnvironmentProps#getPluginsS3Path}
         * @param pluginsS3Path The relative path to the <code>plugins.zip</code> file on your Amazon S3 bucket. For example, <code>plugins.zip</code> . To learn more, see <a href="https://docs.aws.amazon.com/mwaa/latest/userguide/configuring-dag-import-plugins.html">Installing custom plugins</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder pluginsS3Path(java.lang.String pluginsS3Path) {
            this.pluginsS3Path = pluginsS3Path;
            return this;
        }

        /**
         * Sets the value of {@link CfnEnvironmentProps#getRequirementsS3ObjectVersion}
         * @param requirementsS3ObjectVersion The version of the requirements.txt file on your Amazon S3 bucket. To learn more, see <a href="https://docs.aws.amazon.com/mwaa/latest/userguide/working-dags-dependencies.html">Installing Python dependencies</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder requirementsS3ObjectVersion(java.lang.String requirementsS3ObjectVersion) {
            this.requirementsS3ObjectVersion = requirementsS3ObjectVersion;
            return this;
        }

        /**
         * Sets the value of {@link CfnEnvironmentProps#getRequirementsS3Path}
         * @param requirementsS3Path The relative path to the <code>requirements.txt</code> file on your Amazon S3 bucket. For example, <code>requirements.txt</code> . To learn more, see <a href="https://docs.aws.amazon.com/mwaa/latest/userguide/working-dags-dependencies.html">Installing Python dependencies</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder requirementsS3Path(java.lang.String requirementsS3Path) {
            this.requirementsS3Path = requirementsS3Path;
            return this;
        }

        /**
         * Sets the value of {@link CfnEnvironmentProps#getSchedulers}
         * @param schedulers The number of schedulers that you want to run in your environment. Valid values:.
         *                   <ul>
         *                   <li><em>v2</em> - Accepts between 2 to 5. Defaults to 2.</li>
         *                   <li><em>v1</em> - Accepts 1.</li>
         *                   </ul>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder schedulers(java.lang.Number schedulers) {
            this.schedulers = schedulers;
            return this;
        }

        /**
         * Sets the value of {@link CfnEnvironmentProps#getSourceBucketArn}
         * @param sourceBucketArn The Amazon Resource Name (ARN) of the Amazon S3 bucket where your DAG code and supporting files are stored.
         *                        For example, <code>arn:aws:s3:::my-airflow-bucket-unique-name</code> . To learn more, see <a href="https://docs.aws.amazon.com/mwaa/latest/userguide/mwaa-s3-bucket.html">Create an Amazon S3 bucket for Amazon MWAA</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sourceBucketArn(java.lang.String sourceBucketArn) {
            this.sourceBucketArn = sourceBucketArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnEnvironmentProps#getStartupScriptS3ObjectVersion}
         * @param startupScriptS3ObjectVersion The version of the startup shell script in your Amazon S3 bucket.
         *                                     You must specify the <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/versioning-workflows.html">version ID</a> that Amazon S3 assigns to the file every time you update the script.
         *                                     <p>
         *                                     Version IDs are Unicode, UTF-8 encoded, URL-ready, opaque strings that are no more than 1,024 bytes long. The following is an example:
         *                                     <p>
         *                                     <code>3sL4kqtJlcpXroDTDmJ+rmSpXd3dIbrHY+MTRCxf3vjVBH40Nr8X8gdRQBpUMLUo</code>
         *                                     <p>
         *                                     For more information, see <a href="https://docs.aws.amazon.com/mwaa/latest/userguide/using-startup-script.html">Using a startup script</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder startupScriptS3ObjectVersion(java.lang.String startupScriptS3ObjectVersion) {
            this.startupScriptS3ObjectVersion = startupScriptS3ObjectVersion;
            return this;
        }

        /**
         * Sets the value of {@link CfnEnvironmentProps#getStartupScriptS3Path}
         * @param startupScriptS3Path The relative path to the startup shell script in your Amazon S3 bucket. For example, <code>s3://mwaa-environment/startup.sh</code> .
         *                            Amazon MWAA runs the script as your environment starts, and before running the Apache Airflow process. You can use this script to install dependencies, modify Apache Airflow configuration options, and set environment variables. For more information, see <a href="https://docs.aws.amazon.com/mwaa/latest/userguide/using-startup-script.html">Using a startup script</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder startupScriptS3Path(java.lang.String startupScriptS3Path) {
            this.startupScriptS3Path = startupScriptS3Path;
            return this;
        }

        /**
         * Sets the value of {@link CfnEnvironmentProps#getTags}
         * @param tags The key-value tag pairs associated to your environment. For example, <code>"Environment": "Staging"</code> . To learn more, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging</a> .
         *             If you specify new tags for an existing environment, the update requires service interruption before taking effect.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(java.lang.Object tags) {
            this.tags = tags;
            return this;
        }

        /**
         * Sets the value of {@link CfnEnvironmentProps#getWebserverAccessMode}
         * @param webserverAccessMode The Apache Airflow <em>Web server</em> access mode.
         *                            To learn more, see <a href="https://docs.aws.amazon.com/mwaa/latest/userguide/configuring-networking.html">Apache Airflow access modes</a> . Valid values: <code>PRIVATE_ONLY</code> or <code>PUBLIC_ONLY</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder webserverAccessMode(java.lang.String webserverAccessMode) {
            this.webserverAccessMode = webserverAccessMode;
            return this;
        }

        /**
         * Sets the value of {@link CfnEnvironmentProps#getWeeklyMaintenanceWindowStart}
         * @param weeklyMaintenanceWindowStart The day and time of the week to start weekly maintenance updates of your environment in the following format: <code>DAY:HH:MM</code> .
         *                                     For example: <code>TUE:03:30</code> . You can specify a start time in 30 minute increments only. Supported input includes the following:
         *                                     <p>
         *                                     <ul>
         *                                     <li>MON|TUE|WED|THU|FRI|SAT|SUN:([01]\d|2[0-3]):(00|30)</li>
         *                                     </ul>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder weeklyMaintenanceWindowStart(java.lang.String weeklyMaintenanceWindowStart) {
            this.weeklyMaintenanceWindowStart = weeklyMaintenanceWindowStart;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnEnvironmentProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnEnvironmentProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnEnvironmentProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnEnvironmentProps {
        private final java.lang.String name;
        private final java.lang.Object airflowConfigurationOptions;
        private final java.lang.String airflowVersion;
        private final java.lang.String dagS3Path;
        private final java.lang.String endpointManagement;
        private final java.lang.String environmentClass;
        private final java.lang.String executionRoleArn;
        private final java.lang.String kmsKey;
        private final java.lang.Object loggingConfiguration;
        private final java.lang.Number maxWebservers;
        private final java.lang.Number maxWorkers;
        private final java.lang.Number minWebservers;
        private final java.lang.Number minWorkers;
        private final java.lang.Object networkConfiguration;
        private final java.lang.String pluginsS3ObjectVersion;
        private final java.lang.String pluginsS3Path;
        private final java.lang.String requirementsS3ObjectVersion;
        private final java.lang.String requirementsS3Path;
        private final java.lang.Number schedulers;
        private final java.lang.String sourceBucketArn;
        private final java.lang.String startupScriptS3ObjectVersion;
        private final java.lang.String startupScriptS3Path;
        private final java.lang.Object tags;
        private final java.lang.String webserverAccessMode;
        private final java.lang.String weeklyMaintenanceWindowStart;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.airflowConfigurationOptions = software.amazon.jsii.Kernel.get(this, "airflowConfigurationOptions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.airflowVersion = software.amazon.jsii.Kernel.get(this, "airflowVersion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.dagS3Path = software.amazon.jsii.Kernel.get(this, "dagS3Path", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.endpointManagement = software.amazon.jsii.Kernel.get(this, "endpointManagement", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.environmentClass = software.amazon.jsii.Kernel.get(this, "environmentClass", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.executionRoleArn = software.amazon.jsii.Kernel.get(this, "executionRoleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.kmsKey = software.amazon.jsii.Kernel.get(this, "kmsKey", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.loggingConfiguration = software.amazon.jsii.Kernel.get(this, "loggingConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.maxWebservers = software.amazon.jsii.Kernel.get(this, "maxWebservers", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.maxWorkers = software.amazon.jsii.Kernel.get(this, "maxWorkers", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.minWebservers = software.amazon.jsii.Kernel.get(this, "minWebservers", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.minWorkers = software.amazon.jsii.Kernel.get(this, "minWorkers", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.networkConfiguration = software.amazon.jsii.Kernel.get(this, "networkConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.pluginsS3ObjectVersion = software.amazon.jsii.Kernel.get(this, "pluginsS3ObjectVersion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.pluginsS3Path = software.amazon.jsii.Kernel.get(this, "pluginsS3Path", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.requirementsS3ObjectVersion = software.amazon.jsii.Kernel.get(this, "requirementsS3ObjectVersion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.requirementsS3Path = software.amazon.jsii.Kernel.get(this, "requirementsS3Path", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.schedulers = software.amazon.jsii.Kernel.get(this, "schedulers", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.sourceBucketArn = software.amazon.jsii.Kernel.get(this, "sourceBucketArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.startupScriptS3ObjectVersion = software.amazon.jsii.Kernel.get(this, "startupScriptS3ObjectVersion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.startupScriptS3Path = software.amazon.jsii.Kernel.get(this, "startupScriptS3Path", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.webserverAccessMode = software.amazon.jsii.Kernel.get(this, "webserverAccessMode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.weeklyMaintenanceWindowStart = software.amazon.jsii.Kernel.get(this, "weeklyMaintenanceWindowStart", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
            this.airflowConfigurationOptions = builder.airflowConfigurationOptions;
            this.airflowVersion = builder.airflowVersion;
            this.dagS3Path = builder.dagS3Path;
            this.endpointManagement = builder.endpointManagement;
            this.environmentClass = builder.environmentClass;
            this.executionRoleArn = builder.executionRoleArn;
            this.kmsKey = builder.kmsKey;
            this.loggingConfiguration = builder.loggingConfiguration;
            this.maxWebservers = builder.maxWebservers;
            this.maxWorkers = builder.maxWorkers;
            this.minWebservers = builder.minWebservers;
            this.minWorkers = builder.minWorkers;
            this.networkConfiguration = builder.networkConfiguration;
            this.pluginsS3ObjectVersion = builder.pluginsS3ObjectVersion;
            this.pluginsS3Path = builder.pluginsS3Path;
            this.requirementsS3ObjectVersion = builder.requirementsS3ObjectVersion;
            this.requirementsS3Path = builder.requirementsS3Path;
            this.schedulers = builder.schedulers;
            this.sourceBucketArn = builder.sourceBucketArn;
            this.startupScriptS3ObjectVersion = builder.startupScriptS3ObjectVersion;
            this.startupScriptS3Path = builder.startupScriptS3Path;
            this.tags = builder.tags;
            this.webserverAccessMode = builder.webserverAccessMode;
            this.weeklyMaintenanceWindowStart = builder.weeklyMaintenanceWindowStart;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        public final java.lang.Object getAirflowConfigurationOptions() {
            return this.airflowConfigurationOptions;
        }

        @Override
        public final java.lang.String getAirflowVersion() {
            return this.airflowVersion;
        }

        @Override
        public final java.lang.String getDagS3Path() {
            return this.dagS3Path;
        }

        @Override
        public final java.lang.String getEndpointManagement() {
            return this.endpointManagement;
        }

        @Override
        public final java.lang.String getEnvironmentClass() {
            return this.environmentClass;
        }

        @Override
        public final java.lang.String getExecutionRoleArn() {
            return this.executionRoleArn;
        }

        @Override
        public final java.lang.String getKmsKey() {
            return this.kmsKey;
        }

        @Override
        public final java.lang.Object getLoggingConfiguration() {
            return this.loggingConfiguration;
        }

        @Override
        public final java.lang.Number getMaxWebservers() {
            return this.maxWebservers;
        }

        @Override
        public final java.lang.Number getMaxWorkers() {
            return this.maxWorkers;
        }

        @Override
        public final java.lang.Number getMinWebservers() {
            return this.minWebservers;
        }

        @Override
        public final java.lang.Number getMinWorkers() {
            return this.minWorkers;
        }

        @Override
        public final java.lang.Object getNetworkConfiguration() {
            return this.networkConfiguration;
        }

        @Override
        public final java.lang.String getPluginsS3ObjectVersion() {
            return this.pluginsS3ObjectVersion;
        }

        @Override
        public final java.lang.String getPluginsS3Path() {
            return this.pluginsS3Path;
        }

        @Override
        public final java.lang.String getRequirementsS3ObjectVersion() {
            return this.requirementsS3ObjectVersion;
        }

        @Override
        public final java.lang.String getRequirementsS3Path() {
            return this.requirementsS3Path;
        }

        @Override
        public final java.lang.Number getSchedulers() {
            return this.schedulers;
        }

        @Override
        public final java.lang.String getSourceBucketArn() {
            return this.sourceBucketArn;
        }

        @Override
        public final java.lang.String getStartupScriptS3ObjectVersion() {
            return this.startupScriptS3ObjectVersion;
        }

        @Override
        public final java.lang.String getStartupScriptS3Path() {
            return this.startupScriptS3Path;
        }

        @Override
        public final java.lang.Object getTags() {
            return this.tags;
        }

        @Override
        public final java.lang.String getWebserverAccessMode() {
            return this.webserverAccessMode;
        }

        @Override
        public final java.lang.String getWeeklyMaintenanceWindowStart() {
            return this.weeklyMaintenanceWindowStart;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("name", om.valueToTree(this.getName()));
            if (this.getAirflowConfigurationOptions() != null) {
                data.set("airflowConfigurationOptions", om.valueToTree(this.getAirflowConfigurationOptions()));
            }
            if (this.getAirflowVersion() != null) {
                data.set("airflowVersion", om.valueToTree(this.getAirflowVersion()));
            }
            if (this.getDagS3Path() != null) {
                data.set("dagS3Path", om.valueToTree(this.getDagS3Path()));
            }
            if (this.getEndpointManagement() != null) {
                data.set("endpointManagement", om.valueToTree(this.getEndpointManagement()));
            }
            if (this.getEnvironmentClass() != null) {
                data.set("environmentClass", om.valueToTree(this.getEnvironmentClass()));
            }
            if (this.getExecutionRoleArn() != null) {
                data.set("executionRoleArn", om.valueToTree(this.getExecutionRoleArn()));
            }
            if (this.getKmsKey() != null) {
                data.set("kmsKey", om.valueToTree(this.getKmsKey()));
            }
            if (this.getLoggingConfiguration() != null) {
                data.set("loggingConfiguration", om.valueToTree(this.getLoggingConfiguration()));
            }
            if (this.getMaxWebservers() != null) {
                data.set("maxWebservers", om.valueToTree(this.getMaxWebservers()));
            }
            if (this.getMaxWorkers() != null) {
                data.set("maxWorkers", om.valueToTree(this.getMaxWorkers()));
            }
            if (this.getMinWebservers() != null) {
                data.set("minWebservers", om.valueToTree(this.getMinWebservers()));
            }
            if (this.getMinWorkers() != null) {
                data.set("minWorkers", om.valueToTree(this.getMinWorkers()));
            }
            if (this.getNetworkConfiguration() != null) {
                data.set("networkConfiguration", om.valueToTree(this.getNetworkConfiguration()));
            }
            if (this.getPluginsS3ObjectVersion() != null) {
                data.set("pluginsS3ObjectVersion", om.valueToTree(this.getPluginsS3ObjectVersion()));
            }
            if (this.getPluginsS3Path() != null) {
                data.set("pluginsS3Path", om.valueToTree(this.getPluginsS3Path()));
            }
            if (this.getRequirementsS3ObjectVersion() != null) {
                data.set("requirementsS3ObjectVersion", om.valueToTree(this.getRequirementsS3ObjectVersion()));
            }
            if (this.getRequirementsS3Path() != null) {
                data.set("requirementsS3Path", om.valueToTree(this.getRequirementsS3Path()));
            }
            if (this.getSchedulers() != null) {
                data.set("schedulers", om.valueToTree(this.getSchedulers()));
            }
            if (this.getSourceBucketArn() != null) {
                data.set("sourceBucketArn", om.valueToTree(this.getSourceBucketArn()));
            }
            if (this.getStartupScriptS3ObjectVersion() != null) {
                data.set("startupScriptS3ObjectVersion", om.valueToTree(this.getStartupScriptS3ObjectVersion()));
            }
            if (this.getStartupScriptS3Path() != null) {
                data.set("startupScriptS3Path", om.valueToTree(this.getStartupScriptS3Path()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }
            if (this.getWebserverAccessMode() != null) {
                data.set("webserverAccessMode", om.valueToTree(this.getWebserverAccessMode()));
            }
            if (this.getWeeklyMaintenanceWindowStart() != null) {
                data.set("weeklyMaintenanceWindowStart", om.valueToTree(this.getWeeklyMaintenanceWindowStart()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_mwaa.CfnEnvironmentProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnEnvironmentProps.Jsii$Proxy that = (CfnEnvironmentProps.Jsii$Proxy) o;

            if (!name.equals(that.name)) return false;
            if (this.airflowConfigurationOptions != null ? !this.airflowConfigurationOptions.equals(that.airflowConfigurationOptions) : that.airflowConfigurationOptions != null) return false;
            if (this.airflowVersion != null ? !this.airflowVersion.equals(that.airflowVersion) : that.airflowVersion != null) return false;
            if (this.dagS3Path != null ? !this.dagS3Path.equals(that.dagS3Path) : that.dagS3Path != null) return false;
            if (this.endpointManagement != null ? !this.endpointManagement.equals(that.endpointManagement) : that.endpointManagement != null) return false;
            if (this.environmentClass != null ? !this.environmentClass.equals(that.environmentClass) : that.environmentClass != null) return false;
            if (this.executionRoleArn != null ? !this.executionRoleArn.equals(that.executionRoleArn) : that.executionRoleArn != null) return false;
            if (this.kmsKey != null ? !this.kmsKey.equals(that.kmsKey) : that.kmsKey != null) return false;
            if (this.loggingConfiguration != null ? !this.loggingConfiguration.equals(that.loggingConfiguration) : that.loggingConfiguration != null) return false;
            if (this.maxWebservers != null ? !this.maxWebservers.equals(that.maxWebservers) : that.maxWebservers != null) return false;
            if (this.maxWorkers != null ? !this.maxWorkers.equals(that.maxWorkers) : that.maxWorkers != null) return false;
            if (this.minWebservers != null ? !this.minWebservers.equals(that.minWebservers) : that.minWebservers != null) return false;
            if (this.minWorkers != null ? !this.minWorkers.equals(that.minWorkers) : that.minWorkers != null) return false;
            if (this.networkConfiguration != null ? !this.networkConfiguration.equals(that.networkConfiguration) : that.networkConfiguration != null) return false;
            if (this.pluginsS3ObjectVersion != null ? !this.pluginsS3ObjectVersion.equals(that.pluginsS3ObjectVersion) : that.pluginsS3ObjectVersion != null) return false;
            if (this.pluginsS3Path != null ? !this.pluginsS3Path.equals(that.pluginsS3Path) : that.pluginsS3Path != null) return false;
            if (this.requirementsS3ObjectVersion != null ? !this.requirementsS3ObjectVersion.equals(that.requirementsS3ObjectVersion) : that.requirementsS3ObjectVersion != null) return false;
            if (this.requirementsS3Path != null ? !this.requirementsS3Path.equals(that.requirementsS3Path) : that.requirementsS3Path != null) return false;
            if (this.schedulers != null ? !this.schedulers.equals(that.schedulers) : that.schedulers != null) return false;
            if (this.sourceBucketArn != null ? !this.sourceBucketArn.equals(that.sourceBucketArn) : that.sourceBucketArn != null) return false;
            if (this.startupScriptS3ObjectVersion != null ? !this.startupScriptS3ObjectVersion.equals(that.startupScriptS3ObjectVersion) : that.startupScriptS3ObjectVersion != null) return false;
            if (this.startupScriptS3Path != null ? !this.startupScriptS3Path.equals(that.startupScriptS3Path) : that.startupScriptS3Path != null) return false;
            if (this.tags != null ? !this.tags.equals(that.tags) : that.tags != null) return false;
            if (this.webserverAccessMode != null ? !this.webserverAccessMode.equals(that.webserverAccessMode) : that.webserverAccessMode != null) return false;
            return this.weeklyMaintenanceWindowStart != null ? this.weeklyMaintenanceWindowStart.equals(that.weeklyMaintenanceWindowStart) : that.weeklyMaintenanceWindowStart == null;
        }

        @Override
        public final int hashCode() {
            int result = this.name.hashCode();
            result = 31 * result + (this.airflowConfigurationOptions != null ? this.airflowConfigurationOptions.hashCode() : 0);
            result = 31 * result + (this.airflowVersion != null ? this.airflowVersion.hashCode() : 0);
            result = 31 * result + (this.dagS3Path != null ? this.dagS3Path.hashCode() : 0);
            result = 31 * result + (this.endpointManagement != null ? this.endpointManagement.hashCode() : 0);
            result = 31 * result + (this.environmentClass != null ? this.environmentClass.hashCode() : 0);
            result = 31 * result + (this.executionRoleArn != null ? this.executionRoleArn.hashCode() : 0);
            result = 31 * result + (this.kmsKey != null ? this.kmsKey.hashCode() : 0);
            result = 31 * result + (this.loggingConfiguration != null ? this.loggingConfiguration.hashCode() : 0);
            result = 31 * result + (this.maxWebservers != null ? this.maxWebservers.hashCode() : 0);
            result = 31 * result + (this.maxWorkers != null ? this.maxWorkers.hashCode() : 0);
            result = 31 * result + (this.minWebservers != null ? this.minWebservers.hashCode() : 0);
            result = 31 * result + (this.minWorkers != null ? this.minWorkers.hashCode() : 0);
            result = 31 * result + (this.networkConfiguration != null ? this.networkConfiguration.hashCode() : 0);
            result = 31 * result + (this.pluginsS3ObjectVersion != null ? this.pluginsS3ObjectVersion.hashCode() : 0);
            result = 31 * result + (this.pluginsS3Path != null ? this.pluginsS3Path.hashCode() : 0);
            result = 31 * result + (this.requirementsS3ObjectVersion != null ? this.requirementsS3ObjectVersion.hashCode() : 0);
            result = 31 * result + (this.requirementsS3Path != null ? this.requirementsS3Path.hashCode() : 0);
            result = 31 * result + (this.schedulers != null ? this.schedulers.hashCode() : 0);
            result = 31 * result + (this.sourceBucketArn != null ? this.sourceBucketArn.hashCode() : 0);
            result = 31 * result + (this.startupScriptS3ObjectVersion != null ? this.startupScriptS3ObjectVersion.hashCode() : 0);
            result = 31 * result + (this.startupScriptS3Path != null ? this.startupScriptS3Path.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            result = 31 * result + (this.webserverAccessMode != null ? this.webserverAccessMode.hashCode() : 0);
            result = 31 * result + (this.weeklyMaintenanceWindowStart != null ? this.weeklyMaintenanceWindowStart.hashCode() : 0);
            return result;
        }
    }
}
