package software.amazon.awscdk.services.opsworks;

/**
 * Properties for defining a <code>CfnUserProfile</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.opsworks.*;
 * CfnUserProfileProps cfnUserProfileProps = CfnUserProfileProps.builder()
 *         .iamUserArn("iamUserArn")
 *         // the properties below are optional
 *         .allowSelfManagement(false)
 *         .sshPublicKey("sshPublicKey")
 *         .sshUsername("sshUsername")
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-userprofile.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-userprofile.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-01-25T00:20:59.163Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_opsworks.CfnUserProfileProps")
@software.amazon.jsii.Jsii.Proxy(CfnUserProfileProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnUserProfileProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The user's IAM ARN.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-userprofile.html#cfn-opsworks-userprofile-iamuserarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-userprofile.html#cfn-opsworks-userprofile-iamuserarn</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getIamUserArn();

    /**
     * Whether users can specify their own SSH public key through the My Settings page.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/security-settingsshkey.html">Managing User Permissions</a> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-userprofile.html#cfn-opsworks-userprofile-allowselfmanagement">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-userprofile.html#cfn-opsworks-userprofile-allowselfmanagement</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getAllowSelfManagement() {
        return null;
    }

    /**
     * The user's SSH public key.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-userprofile.html#cfn-opsworks-userprofile-sshpublickey">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-userprofile.html#cfn-opsworks-userprofile-sshpublickey</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getSshPublicKey() {
        return null;
    }

    /**
     * The user's SSH user name.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-userprofile.html#cfn-opsworks-userprofile-sshusername">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-userprofile.html#cfn-opsworks-userprofile-sshusername</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getSshUsername() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnUserProfileProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnUserProfileProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnUserProfileProps> {
        java.lang.String iamUserArn;
        java.lang.Object allowSelfManagement;
        java.lang.String sshPublicKey;
        java.lang.String sshUsername;

        /**
         * Sets the value of {@link CfnUserProfileProps#getIamUserArn}
         * @param iamUserArn The user's IAM ARN. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder iamUserArn(java.lang.String iamUserArn) {
            this.iamUserArn = iamUserArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnUserProfileProps#getAllowSelfManagement}
         * @param allowSelfManagement Whether users can specify their own SSH public key through the My Settings page.
         *                            For more information, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/security-settingsshkey.html">Managing User Permissions</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder allowSelfManagement(java.lang.Boolean allowSelfManagement) {
            this.allowSelfManagement = allowSelfManagement;
            return this;
        }

        /**
         * Sets the value of {@link CfnUserProfileProps#getAllowSelfManagement}
         * @param allowSelfManagement Whether users can specify their own SSH public key through the My Settings page.
         *                            For more information, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/security-settingsshkey.html">Managing User Permissions</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder allowSelfManagement(software.amazon.awscdk.IResolvable allowSelfManagement) {
            this.allowSelfManagement = allowSelfManagement;
            return this;
        }

        /**
         * Sets the value of {@link CfnUserProfileProps#getSshPublicKey}
         * @param sshPublicKey The user's SSH public key.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sshPublicKey(java.lang.String sshPublicKey) {
            this.sshPublicKey = sshPublicKey;
            return this;
        }

        /**
         * Sets the value of {@link CfnUserProfileProps#getSshUsername}
         * @param sshUsername The user's SSH user name.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sshUsername(java.lang.String sshUsername) {
            this.sshUsername = sshUsername;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnUserProfileProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnUserProfileProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnUserProfileProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnUserProfileProps {
        private final java.lang.String iamUserArn;
        private final java.lang.Object allowSelfManagement;
        private final java.lang.String sshPublicKey;
        private final java.lang.String sshUsername;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.iamUserArn = software.amazon.jsii.Kernel.get(this, "iamUserArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.allowSelfManagement = software.amazon.jsii.Kernel.get(this, "allowSelfManagement", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.sshPublicKey = software.amazon.jsii.Kernel.get(this, "sshPublicKey", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.sshUsername = software.amazon.jsii.Kernel.get(this, "sshUsername", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.iamUserArn = java.util.Objects.requireNonNull(builder.iamUserArn, "iamUserArn is required");
            this.allowSelfManagement = builder.allowSelfManagement;
            this.sshPublicKey = builder.sshPublicKey;
            this.sshUsername = builder.sshUsername;
        }

        @Override
        public final java.lang.String getIamUserArn() {
            return this.iamUserArn;
        }

        @Override
        public final java.lang.Object getAllowSelfManagement() {
            return this.allowSelfManagement;
        }

        @Override
        public final java.lang.String getSshPublicKey() {
            return this.sshPublicKey;
        }

        @Override
        public final java.lang.String getSshUsername() {
            return this.sshUsername;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("iamUserArn", om.valueToTree(this.getIamUserArn()));
            if (this.getAllowSelfManagement() != null) {
                data.set("allowSelfManagement", om.valueToTree(this.getAllowSelfManagement()));
            }
            if (this.getSshPublicKey() != null) {
                data.set("sshPublicKey", om.valueToTree(this.getSshPublicKey()));
            }
            if (this.getSshUsername() != null) {
                data.set("sshUsername", om.valueToTree(this.getSshUsername()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_opsworks.CfnUserProfileProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnUserProfileProps.Jsii$Proxy that = (CfnUserProfileProps.Jsii$Proxy) o;

            if (!iamUserArn.equals(that.iamUserArn)) return false;
            if (this.allowSelfManagement != null ? !this.allowSelfManagement.equals(that.allowSelfManagement) : that.allowSelfManagement != null) return false;
            if (this.sshPublicKey != null ? !this.sshPublicKey.equals(that.sshPublicKey) : that.sshPublicKey != null) return false;
            return this.sshUsername != null ? this.sshUsername.equals(that.sshUsername) : that.sshUsername == null;
        }

        @Override
        public final int hashCode() {
            int result = this.iamUserArn.hashCode();
            result = 31 * result + (this.allowSelfManagement != null ? this.allowSelfManagement.hashCode() : 0);
            result = 31 * result + (this.sshPublicKey != null ? this.sshPublicKey.hashCode() : 0);
            result = 31 * result + (this.sshUsername != null ? this.sshUsername.hashCode() : 0);
            return result;
        }
    }
}
