package software.amazon.awscdk.services.qbusiness;

/**
 * Properties for defining a <code>CfnDataAccessor</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.qbusiness.*;
 * AttributeFilterProperty attributeFilterProperty_;
 * CfnDataAccessorProps cfnDataAccessorProps = CfnDataAccessorProps.builder()
 *         .actionConfigurations(List.of(ActionConfigurationProperty.builder()
 *                 .action("action")
 *                 // the properties below are optional
 *                 .filterConfiguration(ActionFilterConfigurationProperty.builder()
 *                         .documentAttributeFilter(AttributeFilterProperty.builder()
 *                                 .andAllFilters(List.of(attributeFilterProperty_))
 *                                 .containsAll(DocumentAttributeProperty.builder()
 *                                         .name("name")
 *                                         .value(DocumentAttributeValueProperty.builder()
 *                                                 .dateValue("dateValue")
 *                                                 .longValue(123)
 *                                                 .stringListValue(List.of("stringListValue"))
 *                                                 .stringValue("stringValue")
 *                                                 .build())
 *                                         .build())
 *                                 .containsAny(DocumentAttributeProperty.builder()
 *                                         .name("name")
 *                                         .value(DocumentAttributeValueProperty.builder()
 *                                                 .dateValue("dateValue")
 *                                                 .longValue(123)
 *                                                 .stringListValue(List.of("stringListValue"))
 *                                                 .stringValue("stringValue")
 *                                                 .build())
 *                                         .build())
 *                                 .equalsTo(DocumentAttributeProperty.builder()
 *                                         .name("name")
 *                                         .value(DocumentAttributeValueProperty.builder()
 *                                                 .dateValue("dateValue")
 *                                                 .longValue(123)
 *                                                 .stringListValue(List.of("stringListValue"))
 *                                                 .stringValue("stringValue")
 *                                                 .build())
 *                                         .build())
 *                                 .greaterThan(DocumentAttributeProperty.builder()
 *                                         .name("name")
 *                                         .value(DocumentAttributeValueProperty.builder()
 *                                                 .dateValue("dateValue")
 *                                                 .longValue(123)
 *                                                 .stringListValue(List.of("stringListValue"))
 *                                                 .stringValue("stringValue")
 *                                                 .build())
 *                                         .build())
 *                                 .greaterThanOrEquals(DocumentAttributeProperty.builder()
 *                                         .name("name")
 *                                         .value(DocumentAttributeValueProperty.builder()
 *                                                 .dateValue("dateValue")
 *                                                 .longValue(123)
 *                                                 .stringListValue(List.of("stringListValue"))
 *                                                 .stringValue("stringValue")
 *                                                 .build())
 *                                         .build())
 *                                 .lessThan(DocumentAttributeProperty.builder()
 *                                         .name("name")
 *                                         .value(DocumentAttributeValueProperty.builder()
 *                                                 .dateValue("dateValue")
 *                                                 .longValue(123)
 *                                                 .stringListValue(List.of("stringListValue"))
 *                                                 .stringValue("stringValue")
 *                                                 .build())
 *                                         .build())
 *                                 .lessThanOrEquals(DocumentAttributeProperty.builder()
 *                                         .name("name")
 *                                         .value(DocumentAttributeValueProperty.builder()
 *                                                 .dateValue("dateValue")
 *                                                 .longValue(123)
 *                                                 .stringListValue(List.of("stringListValue"))
 *                                                 .stringValue("stringValue")
 *                                                 .build())
 *                                         .build())
 *                                 .notFilter(attributeFilterProperty_)
 *                                 .orAllFilters(List.of(attributeFilterProperty_))
 *                                 .build())
 *                         .build())
 *                 .build()))
 *         .applicationId("applicationId")
 *         .displayName("displayName")
 *         .principal("principal")
 *         // the properties below are optional
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-qbusiness-dataaccessor.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-qbusiness-dataaccessor.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-01-25T00:20:59.507Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_qbusiness.CfnDataAccessorProps")
@software.amazon.jsii.Jsii.Proxy(CfnDataAccessorProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnDataAccessorProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * A list of action configurations specifying the allowed actions and any associated filters.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-qbusiness-dataaccessor.html#cfn-qbusiness-dataaccessor-actionconfigurations">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-qbusiness-dataaccessor.html#cfn-qbusiness-dataaccessor-actionconfigurations</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getActionConfigurations();

    /**
     * The unique identifier of the Amazon Q Business application.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-qbusiness-dataaccessor.html#cfn-qbusiness-dataaccessor-applicationid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-qbusiness-dataaccessor.html#cfn-qbusiness-dataaccessor-applicationid</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getApplicationId();

    /**
     * The friendly name of the data accessor.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-qbusiness-dataaccessor.html#cfn-qbusiness-dataaccessor-displayname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-qbusiness-dataaccessor.html#cfn-qbusiness-dataaccessor-displayname</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getDisplayName();

    /**
     * The Amazon Resource Name (ARN) of the IAM role for the ISV associated with this data accessor.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-qbusiness-dataaccessor.html#cfn-qbusiness-dataaccessor-principal">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-qbusiness-dataaccessor.html#cfn-qbusiness-dataaccessor-principal</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getPrincipal();

    /**
     * The tags to associate with the data accessor.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-qbusiness-dataaccessor.html#cfn-qbusiness-dataaccessor-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-qbusiness-dataaccessor.html#cfn-qbusiness-dataaccessor-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnDataAccessorProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnDataAccessorProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnDataAccessorProps> {
        java.lang.Object actionConfigurations;
        java.lang.String applicationId;
        java.lang.String displayName;
        java.lang.String principal;
        java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Sets the value of {@link CfnDataAccessorProps#getActionConfigurations}
         * @param actionConfigurations A list of action configurations specifying the allowed actions and any associated filters. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder actionConfigurations(software.amazon.awscdk.IResolvable actionConfigurations) {
            this.actionConfigurations = actionConfigurations;
            return this;
        }

        /**
         * Sets the value of {@link CfnDataAccessorProps#getActionConfigurations}
         * @param actionConfigurations A list of action configurations specifying the allowed actions and any associated filters. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder actionConfigurations(java.util.List<? extends java.lang.Object> actionConfigurations) {
            this.actionConfigurations = actionConfigurations;
            return this;
        }

        /**
         * Sets the value of {@link CfnDataAccessorProps#getApplicationId}
         * @param applicationId The unique identifier of the Amazon Q Business application. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder applicationId(java.lang.String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        /**
         * Sets the value of {@link CfnDataAccessorProps#getDisplayName}
         * @param displayName The friendly name of the data accessor. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder displayName(java.lang.String displayName) {
            this.displayName = displayName;
            return this;
        }

        /**
         * Sets the value of {@link CfnDataAccessorProps#getPrincipal}
         * @param principal The Amazon Resource Name (ARN) of the IAM role for the ISV associated with this data accessor. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder principal(java.lang.String principal) {
            this.principal = principal;
            return this;
        }

        /**
         * Sets the value of {@link CfnDataAccessorProps#getTags}
         * @param tags The tags to associate with the data accessor.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnDataAccessorProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnDataAccessorProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnDataAccessorProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnDataAccessorProps {
        private final java.lang.Object actionConfigurations;
        private final java.lang.String applicationId;
        private final java.lang.String displayName;
        private final java.lang.String principal;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.actionConfigurations = software.amazon.jsii.Kernel.get(this, "actionConfigurations", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.applicationId = software.amazon.jsii.Kernel.get(this, "applicationId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.displayName = software.amazon.jsii.Kernel.get(this, "displayName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.principal = software.amazon.jsii.Kernel.get(this, "principal", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.actionConfigurations = java.util.Objects.requireNonNull(builder.actionConfigurations, "actionConfigurations is required");
            this.applicationId = java.util.Objects.requireNonNull(builder.applicationId, "applicationId is required");
            this.displayName = java.util.Objects.requireNonNull(builder.displayName, "displayName is required");
            this.principal = java.util.Objects.requireNonNull(builder.principal, "principal is required");
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
        }

        @Override
        public final java.lang.Object getActionConfigurations() {
            return this.actionConfigurations;
        }

        @Override
        public final java.lang.String getApplicationId() {
            return this.applicationId;
        }

        @Override
        public final java.lang.String getDisplayName() {
            return this.displayName;
        }

        @Override
        public final java.lang.String getPrincipal() {
            return this.principal;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("actionConfigurations", om.valueToTree(this.getActionConfigurations()));
            data.set("applicationId", om.valueToTree(this.getApplicationId()));
            data.set("displayName", om.valueToTree(this.getDisplayName()));
            data.set("principal", om.valueToTree(this.getPrincipal()));
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_qbusiness.CfnDataAccessorProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnDataAccessorProps.Jsii$Proxy that = (CfnDataAccessorProps.Jsii$Proxy) o;

            if (!actionConfigurations.equals(that.actionConfigurations)) return false;
            if (!applicationId.equals(that.applicationId)) return false;
            if (!displayName.equals(that.displayName)) return false;
            if (!principal.equals(that.principal)) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.actionConfigurations.hashCode();
            result = 31 * result + (this.applicationId.hashCode());
            result = 31 * result + (this.displayName.hashCode());
            result = 31 * result + (this.principal.hashCode());
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
