package software.amazon.awscdk.services.route53;

/**
 * Properties for a new health check.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * HostedZone myZone;
 * HealthCheck healthCheck = HealthCheck.Builder.create(this, "HealthCheck")
 *         .type(HealthCheckType.HTTP)
 *         .fqdn("example.com")
 *         .port(80)
 *         .resourcePath("/health")
 *         .failureThreshold(3)
 *         .requestInterval(Duration.seconds(30))
 *         .build();
 * ARecord.Builder.create(this, "ARecord")
 *         .zone(myZone)
 *         .target(RecordTarget.fromIpAddresses("1.2.3.4"))
 *         .healthCheck(healthCheck)
 *         .weight(100)
 *         .build();
 * ARecord.Builder.create(this, "ARecord2")
 *         .zone(myZone)
 *         .target(RecordTarget.fromIpAddresses("5.6.7.8"))
 *         .weight(0)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-01-25T00:21:02.868Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_route53.HealthCheckProps")
@software.amazon.jsii.Jsii.Proxy(HealthCheckProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface HealthCheckProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The type of health check to be associated with the record.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.route53.HealthCheckType getType();

    /**
     * CloudWatch alarm that you want Amazon Route 53 health checkers to use to determine whether the specified health check is healthy.
     * <p>
     * Default: - if the type is CLOUDWATCH_METRIC, this property is required. Otherwise, it is not configured.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.route53.AlarmIdentifier getAlarmIdentifier() {
        return null;
    }

    /**
     * A list of health checks to monitor for this 'CALCULATED' health check.
     * <p>
     * Default: - if the type is CALCULATED, this property is required. Otherwise, it is not configured.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.route53.IHealthCheck> getChildHealthChecks() {
        return null;
    }

    /**
     * Specify whether you want Amazon Route 53 to send the value of FullyQualifiedDomainName to the endpoint in the client_hello message during TLS negotiation.
     * <p>
     * This allows the endpoint to respond to HTTPS health check requests with the applicable SSL/TLS certificate.
     * <p>
     * Default: - if the type is HTTPS or HTTPS_STR_MATCH, this property default value is true. Otherwise, it is not configured.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getEnableSNI() {
        return null;
    }

    /**
     * The number of consecutive health checks that an endpoint must pass or fail for Amazon Route 53 to change the current status of the endpoint from unhealthy to healthy or vice versa.
     * <p>
     * Default: - if the type is CALCULATED it's not configured
     * - if the type is CLOUDWATCH_METRIC it's not configured
     * - otherwise, the default value is 3.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getFailureThreshold() {
        return null;
    }

    /**
     * Fully qualified domain name of the endpoint to be checked.
     * <p>
     * Amazon Route 53 behavior depends on whether you specify a value for IPAddress.
     * <p>
     * If you specify a value for IPAddress:
     * <p>
     * Amazon Route 53 sends health check requests to the specified IPv4 or IPv6 address and passes the value of FullyQualifiedDomainName in the Host header for all health checks except TCP health checks. This is typically the fully qualified DNS name of the endpoint on which you want Route 53 to perform health checks.
     * Note: If you specify a value for Port property other than 80 or 443, Route 53 will construct the value for Host header as FullyQualifiedDomainName:Port.
     * <p>
     * If you don't specify a value for IPAddress:
     * <p>
     * Route 53 sends a DNS request to the domain that you specify for FullyQualifiedDomainName at the interval that you specify for RequestInterval. Using an IPv4 address that DNS returns, Route 53 then checks the health of the endpoint.
     * <p>
     * Additionally, if the type of the health check is HTTP, HTTPS, HTTP_STR_MATCH, or HTTPS_STR_MATCH, Route 53 passes the value of FullyQualifiedDomainName in the Host header, as it does when you specify value for IPAddress. If the type is TCP, Route 53 doesn't pass a Host header.
     * <p>
     * Default: - not configured
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getFqdn() {
        return null;
    }

    /**
     * The number of child health checks that are associated with a CALCULATED health that Amazon Route 53 must consider healthy for the CALCULATED health check to be considered healthy.
     * <p>
     * Default: - if the type is CALCULATED, the default value is number of child health checks. Otherwise, it is not configured.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getHealthThreshold() {
        return null;
    }

    /**
     * The status of the health check when CloudWatch has insufficient data about the state of associated alarm.
     * <p>
     * Default: - if the type is CLOUDWATCH_METRIC, the default value is InsufficientDataHealthStatus.LAST_KNOWN_STATUS. Otherwise, it is not configured.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.route53.InsufficientDataHealthStatusEnum getInsufficientDataHealthStatus() {
        return null;
    }

    /**
     * Specify whether you want Amazon Route 53 to invert the status of a health check, so a health check that would normally be considered unhealthy is considered healthy, and vice versa.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getInverted() {
        return null;
    }

    /**
     * The IPv4 or IPv6 IP address for the endpoint that you want Amazon Route 53 to perform health checks on.
     * <p>
     * If you don't specify a value for IPAddress, Route 53 sends a DNS request to resolve the domain name that you specify in FullyQualifiedDomainName at the interval that you specify in RequestInterval. Using an IPv4 address that DNS returns, Route 53 then checks the health of the endpoint.
     * <p>
     * Default: - not configured
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getIpAddress() {
        return null;
    }

    /**
     * Specify whether you want Amazon Route 53 to measure the latency between health checkers in multiple AWS regions and your endpoint, and to display CloudWatch latency graphs on the Health Checks page in the Route 53 console.
     * <p>
     * Default: - if the type is CALCULATED it's not configured
     * - if the type is CLOUDWATCH_METRIC it's not configured
     * - otherwise, the default value is false.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getMeasureLatency() {
        return null;
    }

    /**
     * The port on the endpoint that you want Amazon Route 53 to perform health checks on.
     * <p>
     * Default: - if the type is HTTP or HTTP_STR_MATCH, the default value is 80.
     * - if the type is HTTPS or HTTPS_STR_MATCH, the default value is 443.
     * - otherwise, it is not configured.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getPort() {
        return null;
    }

    /**
     * An array of region identifiers that you want Amazon Route 53 health checkers to check the health of the endpoint from.
     * <p>
     * Please refer to the CloudFormation documentation for the most up-to-date list of regions.
     * <p>
     * Default: - if the type is CALCULATED, CLOUDWATCH_METRIC, or RECOVERY_CONTROL, this property is not configured.
     * - otherwise, the default value will be set by CloudFormation itself and will include all valid regions. Please refer to the CloudFormation documentation for the most up-to-date list of regions.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_HealthCheckConfig.html">https://docs.aws.amazon.com/Route53/latest/APIReference/API_HealthCheckConfig.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getRegions() {
        return null;
    }

    /**
     * The duration between the time that Amazon Route 53 gets a response from your endpoint and the time that it sends the next health check request.
     * <p>
     * Each Route 53 health checker makes requests at this interval.
     * <p>
     * Default: - if the type is CALCULATED it's not configured
     * - if the type is CLOUDWATCH_METRIC it's not configured
     * - otherwise, the default value is 30 seconds.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.Duration getRequestInterval() {
        return null;
    }

    /**
     * The path that you want Amazon Route 53 to request when performing health checks.
     * <p>
     * The path can be any value for which your endpoint will return an HTTP status code of 2xx or 3xx when the endpoint is healthy, for example the file /docs/route53-health-check.html. Route 53 automatically adds the DNS name for the service and a leading forward slash (/) character.
     * <p>
     * Default: - if the type is HTTP, HTTPS, HTTP_STR_MATCH, or HTTPS_STR_MATCH, the default value is empty string.
     * - otherwise, it is not configured.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getResourcePath() {
        return null;
    }

    /**
     * The Amazon Resource Name (ARN) of the Route 53 Application Recovery Controller routing control that you want Amazon Route 53 health checkers to use to determine whether the specified health check is healthy.
     * <p>
     * Default: - if the type is RECOVERY_CONTROL, this property is required. Otherwise, it is not configured.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getRoutingControl() {
        return null;
    }

    /**
     * The string that you want Amazon Route 53 to search for in the response body from the specified resource.
     * <p>
     * If the string appears in the response body, Route 53 considers the resource healthy.
     * <p>
     * Route 53 considers case when searching for SearchString in the response body.
     * <p>
     * Default: - if the type is HTTP_STR_MATCH or HTTPS_STR_MATCH, this property is required. Otherwise, it is not configured.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getSearchString() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link HealthCheckProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link HealthCheckProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<HealthCheckProps> {
        software.amazon.awscdk.services.route53.HealthCheckType type;
        software.amazon.awscdk.services.route53.AlarmIdentifier alarmIdentifier;
        java.util.List<software.amazon.awscdk.services.route53.IHealthCheck> childHealthChecks;
        java.lang.Boolean enableSni;
        java.lang.Number failureThreshold;
        java.lang.String fqdn;
        java.lang.Number healthThreshold;
        software.amazon.awscdk.services.route53.InsufficientDataHealthStatusEnum insufficientDataHealthStatus;
        java.lang.Boolean inverted;
        java.lang.String ipAddress;
        java.lang.Boolean measureLatency;
        java.lang.Number port;
        java.util.List<java.lang.String> regions;
        software.amazon.awscdk.Duration requestInterval;
        java.lang.String resourcePath;
        java.lang.String routingControl;
        java.lang.String searchString;

        /**
         * Sets the value of {@link HealthCheckProps#getType}
         * @param type The type of health check to be associated with the record. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder type(software.amazon.awscdk.services.route53.HealthCheckType type) {
            this.type = type;
            return this;
        }

        /**
         * Sets the value of {@link HealthCheckProps#getAlarmIdentifier}
         * @param alarmIdentifier CloudWatch alarm that you want Amazon Route 53 health checkers to use to determine whether the specified health check is healthy.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder alarmIdentifier(software.amazon.awscdk.services.route53.AlarmIdentifier alarmIdentifier) {
            this.alarmIdentifier = alarmIdentifier;
            return this;
        }

        /**
         * Sets the value of {@link HealthCheckProps#getChildHealthChecks}
         * @param childHealthChecks A list of health checks to monitor for this 'CALCULATED' health check.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder childHealthChecks(java.util.List<? extends software.amazon.awscdk.services.route53.IHealthCheck> childHealthChecks) {
            this.childHealthChecks = (java.util.List<software.amazon.awscdk.services.route53.IHealthCheck>)childHealthChecks;
            return this;
        }

        /**
         * Sets the value of {@link HealthCheckProps#getEnableSni}
         * @param enableSni Specify whether you want Amazon Route 53 to send the value of FullyQualifiedDomainName to the endpoint in the client_hello message during TLS negotiation.
         *                  This allows the endpoint to respond to HTTPS health check requests with the applicable SSL/TLS certificate.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enableSni(java.lang.Boolean enableSni) {
            this.enableSni = enableSni;
            return this;
        }

        /**
         * Sets the value of {@link HealthCheckProps#getFailureThreshold}
         * @param failureThreshold The number of consecutive health checks that an endpoint must pass or fail for Amazon Route 53 to change the current status of the endpoint from unhealthy to healthy or vice versa.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder failureThreshold(java.lang.Number failureThreshold) {
            this.failureThreshold = failureThreshold;
            return this;
        }

        /**
         * Sets the value of {@link HealthCheckProps#getFqdn}
         * @param fqdn Fully qualified domain name of the endpoint to be checked.
         *             Amazon Route 53 behavior depends on whether you specify a value for IPAddress.
         *             <p>
         *             If you specify a value for IPAddress:
         *             <p>
         *             Amazon Route 53 sends health check requests to the specified IPv4 or IPv6 address and passes the value of FullyQualifiedDomainName in the Host header for all health checks except TCP health checks. This is typically the fully qualified DNS name of the endpoint on which you want Route 53 to perform health checks.
         *             Note: If you specify a value for Port property other than 80 or 443, Route 53 will construct the value for Host header as FullyQualifiedDomainName:Port.
         *             <p>
         *             If you don't specify a value for IPAddress:
         *             <p>
         *             Route 53 sends a DNS request to the domain that you specify for FullyQualifiedDomainName at the interval that you specify for RequestInterval. Using an IPv4 address that DNS returns, Route 53 then checks the health of the endpoint.
         *             <p>
         *             Additionally, if the type of the health check is HTTP, HTTPS, HTTP_STR_MATCH, or HTTPS_STR_MATCH, Route 53 passes the value of FullyQualifiedDomainName in the Host header, as it does when you specify value for IPAddress. If the type is TCP, Route 53 doesn't pass a Host header.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder fqdn(java.lang.String fqdn) {
            this.fqdn = fqdn;
            return this;
        }

        /**
         * Sets the value of {@link HealthCheckProps#getHealthThreshold}
         * @param healthThreshold The number of child health checks that are associated with a CALCULATED health that Amazon Route 53 must consider healthy for the CALCULATED health check to be considered healthy.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder healthThreshold(java.lang.Number healthThreshold) {
            this.healthThreshold = healthThreshold;
            return this;
        }

        /**
         * Sets the value of {@link HealthCheckProps#getInsufficientDataHealthStatus}
         * @param insufficientDataHealthStatus The status of the health check when CloudWatch has insufficient data about the state of associated alarm.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder insufficientDataHealthStatus(software.amazon.awscdk.services.route53.InsufficientDataHealthStatusEnum insufficientDataHealthStatus) {
            this.insufficientDataHealthStatus = insufficientDataHealthStatus;
            return this;
        }

        /**
         * Sets the value of {@link HealthCheckProps#getInverted}
         * @param inverted Specify whether you want Amazon Route 53 to invert the status of a health check, so a health check that would normally be considered unhealthy is considered healthy, and vice versa.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder inverted(java.lang.Boolean inverted) {
            this.inverted = inverted;
            return this;
        }

        /**
         * Sets the value of {@link HealthCheckProps#getIpAddress}
         * @param ipAddress The IPv4 or IPv6 IP address for the endpoint that you want Amazon Route 53 to perform health checks on.
         *                  If you don't specify a value for IPAddress, Route 53 sends a DNS request to resolve the domain name that you specify in FullyQualifiedDomainName at the interval that you specify in RequestInterval. Using an IPv4 address that DNS returns, Route 53 then checks the health of the endpoint.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ipAddress(java.lang.String ipAddress) {
            this.ipAddress = ipAddress;
            return this;
        }

        /**
         * Sets the value of {@link HealthCheckProps#getMeasureLatency}
         * @param measureLatency Specify whether you want Amazon Route 53 to measure the latency between health checkers in multiple AWS regions and your endpoint, and to display CloudWatch latency graphs on the Health Checks page in the Route 53 console.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder measureLatency(java.lang.Boolean measureLatency) {
            this.measureLatency = measureLatency;
            return this;
        }

        /**
         * Sets the value of {@link HealthCheckProps#getPort}
         * @param port The port on the endpoint that you want Amazon Route 53 to perform health checks on.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder port(java.lang.Number port) {
            this.port = port;
            return this;
        }

        /**
         * Sets the value of {@link HealthCheckProps#getRegions}
         * @param regions An array of region identifiers that you want Amazon Route 53 health checkers to check the health of the endpoint from.
         *                Please refer to the CloudFormation documentation for the most up-to-date list of regions.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder regions(java.util.List<java.lang.String> regions) {
            this.regions = regions;
            return this;
        }

        /**
         * Sets the value of {@link HealthCheckProps#getRequestInterval}
         * @param requestInterval The duration between the time that Amazon Route 53 gets a response from your endpoint and the time that it sends the next health check request.
         *                        Each Route 53 health checker makes requests at this interval.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder requestInterval(software.amazon.awscdk.Duration requestInterval) {
            this.requestInterval = requestInterval;
            return this;
        }

        /**
         * Sets the value of {@link HealthCheckProps#getResourcePath}
         * @param resourcePath The path that you want Amazon Route 53 to request when performing health checks.
         *                     The path can be any value for which your endpoint will return an HTTP status code of 2xx or 3xx when the endpoint is healthy, for example the file /docs/route53-health-check.html. Route 53 automatically adds the DNS name for the service and a leading forward slash (/) character.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resourcePath(java.lang.String resourcePath) {
            this.resourcePath = resourcePath;
            return this;
        }

        /**
         * Sets the value of {@link HealthCheckProps#getRoutingControl}
         * @param routingControl The Amazon Resource Name (ARN) of the Route 53 Application Recovery Controller routing control that you want Amazon Route 53 health checkers to use to determine whether the specified health check is healthy.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder routingControl(java.lang.String routingControl) {
            this.routingControl = routingControl;
            return this;
        }

        /**
         * Sets the value of {@link HealthCheckProps#getSearchString}
         * @param searchString The string that you want Amazon Route 53 to search for in the response body from the specified resource.
         *                     If the string appears in the response body, Route 53 considers the resource healthy.
         *                     <p>
         *                     Route 53 considers case when searching for SearchString in the response body.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder searchString(java.lang.String searchString) {
            this.searchString = searchString;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link HealthCheckProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public HealthCheckProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link HealthCheckProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements HealthCheckProps {
        private final software.amazon.awscdk.services.route53.HealthCheckType type;
        private final software.amazon.awscdk.services.route53.AlarmIdentifier alarmIdentifier;
        private final java.util.List<software.amazon.awscdk.services.route53.IHealthCheck> childHealthChecks;
        private final java.lang.Boolean enableSni;
        private final java.lang.Number failureThreshold;
        private final java.lang.String fqdn;
        private final java.lang.Number healthThreshold;
        private final software.amazon.awscdk.services.route53.InsufficientDataHealthStatusEnum insufficientDataHealthStatus;
        private final java.lang.Boolean inverted;
        private final java.lang.String ipAddress;
        private final java.lang.Boolean measureLatency;
        private final java.lang.Number port;
        private final java.util.List<java.lang.String> regions;
        private final software.amazon.awscdk.Duration requestInterval;
        private final java.lang.String resourcePath;
        private final java.lang.String routingControl;
        private final java.lang.String searchString;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.type = software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.route53.HealthCheckType.class));
            this.alarmIdentifier = software.amazon.jsii.Kernel.get(this, "alarmIdentifier", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.route53.AlarmIdentifier.class));
            this.childHealthChecks = software.amazon.jsii.Kernel.get(this, "childHealthChecks", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.route53.IHealthCheck.class)));
            this.enableSni = software.amazon.jsii.Kernel.get(this, "enableSNI", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.failureThreshold = software.amazon.jsii.Kernel.get(this, "failureThreshold", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.fqdn = software.amazon.jsii.Kernel.get(this, "fqdn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.healthThreshold = software.amazon.jsii.Kernel.get(this, "healthThreshold", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.insufficientDataHealthStatus = software.amazon.jsii.Kernel.get(this, "insufficientDataHealthStatus", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.route53.InsufficientDataHealthStatusEnum.class));
            this.inverted = software.amazon.jsii.Kernel.get(this, "inverted", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.ipAddress = software.amazon.jsii.Kernel.get(this, "ipAddress", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.measureLatency = software.amazon.jsii.Kernel.get(this, "measureLatency", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.port = software.amazon.jsii.Kernel.get(this, "port", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.regions = software.amazon.jsii.Kernel.get(this, "regions", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.requestInterval = software.amazon.jsii.Kernel.get(this, "requestInterval", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Duration.class));
            this.resourcePath = software.amazon.jsii.Kernel.get(this, "resourcePath", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.routingControl = software.amazon.jsii.Kernel.get(this, "routingControl", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.searchString = software.amazon.jsii.Kernel.get(this, "searchString", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.type = java.util.Objects.requireNonNull(builder.type, "type is required");
            this.alarmIdentifier = builder.alarmIdentifier;
            this.childHealthChecks = (java.util.List<software.amazon.awscdk.services.route53.IHealthCheck>)builder.childHealthChecks;
            this.enableSni = builder.enableSni;
            this.failureThreshold = builder.failureThreshold;
            this.fqdn = builder.fqdn;
            this.healthThreshold = builder.healthThreshold;
            this.insufficientDataHealthStatus = builder.insufficientDataHealthStatus;
            this.inverted = builder.inverted;
            this.ipAddress = builder.ipAddress;
            this.measureLatency = builder.measureLatency;
            this.port = builder.port;
            this.regions = builder.regions;
            this.requestInterval = builder.requestInterval;
            this.resourcePath = builder.resourcePath;
            this.routingControl = builder.routingControl;
            this.searchString = builder.searchString;
        }

        @Override
        public final software.amazon.awscdk.services.route53.HealthCheckType getType() {
            return this.type;
        }

        @Override
        public final software.amazon.awscdk.services.route53.AlarmIdentifier getAlarmIdentifier() {
            return this.alarmIdentifier;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.route53.IHealthCheck> getChildHealthChecks() {
            return this.childHealthChecks;
        }

        @Override
        public final java.lang.Boolean getEnableSNI() {
            return this.enableSni;
        }

        @Override
        public final java.lang.Number getFailureThreshold() {
            return this.failureThreshold;
        }

        @Override
        public final java.lang.String getFqdn() {
            return this.fqdn;
        }

        @Override
        public final java.lang.Number getHealthThreshold() {
            return this.healthThreshold;
        }

        @Override
        public final software.amazon.awscdk.services.route53.InsufficientDataHealthStatusEnum getInsufficientDataHealthStatus() {
            return this.insufficientDataHealthStatus;
        }

        @Override
        public final java.lang.Boolean getInverted() {
            return this.inverted;
        }

        @Override
        public final java.lang.String getIpAddress() {
            return this.ipAddress;
        }

        @Override
        public final java.lang.Boolean getMeasureLatency() {
            return this.measureLatency;
        }

        @Override
        public final java.lang.Number getPort() {
            return this.port;
        }

        @Override
        public final java.util.List<java.lang.String> getRegions() {
            return this.regions;
        }

        @Override
        public final software.amazon.awscdk.Duration getRequestInterval() {
            return this.requestInterval;
        }

        @Override
        public final java.lang.String getResourcePath() {
            return this.resourcePath;
        }

        @Override
        public final java.lang.String getRoutingControl() {
            return this.routingControl;
        }

        @Override
        public final java.lang.String getSearchString() {
            return this.searchString;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("type", om.valueToTree(this.getType()));
            if (this.getAlarmIdentifier() != null) {
                data.set("alarmIdentifier", om.valueToTree(this.getAlarmIdentifier()));
            }
            if (this.getChildHealthChecks() != null) {
                data.set("childHealthChecks", om.valueToTree(this.getChildHealthChecks()));
            }
            if (this.getEnableSNI() != null) {
                data.set("enableSNI", om.valueToTree(this.getEnableSNI()));
            }
            if (this.getFailureThreshold() != null) {
                data.set("failureThreshold", om.valueToTree(this.getFailureThreshold()));
            }
            if (this.getFqdn() != null) {
                data.set("fqdn", om.valueToTree(this.getFqdn()));
            }
            if (this.getHealthThreshold() != null) {
                data.set("healthThreshold", om.valueToTree(this.getHealthThreshold()));
            }
            if (this.getInsufficientDataHealthStatus() != null) {
                data.set("insufficientDataHealthStatus", om.valueToTree(this.getInsufficientDataHealthStatus()));
            }
            if (this.getInverted() != null) {
                data.set("inverted", om.valueToTree(this.getInverted()));
            }
            if (this.getIpAddress() != null) {
                data.set("ipAddress", om.valueToTree(this.getIpAddress()));
            }
            if (this.getMeasureLatency() != null) {
                data.set("measureLatency", om.valueToTree(this.getMeasureLatency()));
            }
            if (this.getPort() != null) {
                data.set("port", om.valueToTree(this.getPort()));
            }
            if (this.getRegions() != null) {
                data.set("regions", om.valueToTree(this.getRegions()));
            }
            if (this.getRequestInterval() != null) {
                data.set("requestInterval", om.valueToTree(this.getRequestInterval()));
            }
            if (this.getResourcePath() != null) {
                data.set("resourcePath", om.valueToTree(this.getResourcePath()));
            }
            if (this.getRoutingControl() != null) {
                data.set("routingControl", om.valueToTree(this.getRoutingControl()));
            }
            if (this.getSearchString() != null) {
                data.set("searchString", om.valueToTree(this.getSearchString()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_route53.HealthCheckProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            HealthCheckProps.Jsii$Proxy that = (HealthCheckProps.Jsii$Proxy) o;

            if (!type.equals(that.type)) return false;
            if (this.alarmIdentifier != null ? !this.alarmIdentifier.equals(that.alarmIdentifier) : that.alarmIdentifier != null) return false;
            if (this.childHealthChecks != null ? !this.childHealthChecks.equals(that.childHealthChecks) : that.childHealthChecks != null) return false;
            if (this.enableSni != null ? !this.enableSni.equals(that.enableSni) : that.enableSni != null) return false;
            if (this.failureThreshold != null ? !this.failureThreshold.equals(that.failureThreshold) : that.failureThreshold != null) return false;
            if (this.fqdn != null ? !this.fqdn.equals(that.fqdn) : that.fqdn != null) return false;
            if (this.healthThreshold != null ? !this.healthThreshold.equals(that.healthThreshold) : that.healthThreshold != null) return false;
            if (this.insufficientDataHealthStatus != null ? !this.insufficientDataHealthStatus.equals(that.insufficientDataHealthStatus) : that.insufficientDataHealthStatus != null) return false;
            if (this.inverted != null ? !this.inverted.equals(that.inverted) : that.inverted != null) return false;
            if (this.ipAddress != null ? !this.ipAddress.equals(that.ipAddress) : that.ipAddress != null) return false;
            if (this.measureLatency != null ? !this.measureLatency.equals(that.measureLatency) : that.measureLatency != null) return false;
            if (this.port != null ? !this.port.equals(that.port) : that.port != null) return false;
            if (this.regions != null ? !this.regions.equals(that.regions) : that.regions != null) return false;
            if (this.requestInterval != null ? !this.requestInterval.equals(that.requestInterval) : that.requestInterval != null) return false;
            if (this.resourcePath != null ? !this.resourcePath.equals(that.resourcePath) : that.resourcePath != null) return false;
            if (this.routingControl != null ? !this.routingControl.equals(that.routingControl) : that.routingControl != null) return false;
            return this.searchString != null ? this.searchString.equals(that.searchString) : that.searchString == null;
        }

        @Override
        public final int hashCode() {
            int result = this.type.hashCode();
            result = 31 * result + (this.alarmIdentifier != null ? this.alarmIdentifier.hashCode() : 0);
            result = 31 * result + (this.childHealthChecks != null ? this.childHealthChecks.hashCode() : 0);
            result = 31 * result + (this.enableSni != null ? this.enableSni.hashCode() : 0);
            result = 31 * result + (this.failureThreshold != null ? this.failureThreshold.hashCode() : 0);
            result = 31 * result + (this.fqdn != null ? this.fqdn.hashCode() : 0);
            result = 31 * result + (this.healthThreshold != null ? this.healthThreshold.hashCode() : 0);
            result = 31 * result + (this.insufficientDataHealthStatus != null ? this.insufficientDataHealthStatus.hashCode() : 0);
            result = 31 * result + (this.inverted != null ? this.inverted.hashCode() : 0);
            result = 31 * result + (this.ipAddress != null ? this.ipAddress.hashCode() : 0);
            result = 31 * result + (this.measureLatency != null ? this.measureLatency.hashCode() : 0);
            result = 31 * result + (this.port != null ? this.port.hashCode() : 0);
            result = 31 * result + (this.regions != null ? this.regions.hashCode() : 0);
            result = 31 * result + (this.requestInterval != null ? this.requestInterval.hashCode() : 0);
            result = 31 * result + (this.resourcePath != null ? this.resourcePath.hashCode() : 0);
            result = 31 * result + (this.routingControl != null ? this.routingControl.hashCode() : 0);
            result = 31 * result + (this.searchString != null ? this.searchString.hashCode() : 0);
            return result;
        }
    }
}
