package software.amazon.awscdk.services.sagemaker;

/**
 * Properties for defining a <code>CfnInferenceExperiment</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.sagemaker.*;
 * CfnInferenceExperimentProps cfnInferenceExperimentProps = CfnInferenceExperimentProps.builder()
 *         .endpointName("endpointName")
 *         .modelVariants(List.of(ModelVariantConfigProperty.builder()
 *                 .infrastructureConfig(ModelInfrastructureConfigProperty.builder()
 *                         .infrastructureType("infrastructureType")
 *                         .realTimeInferenceConfig(RealTimeInferenceConfigProperty.builder()
 *                                 .instanceCount(123)
 *                                 .instanceType("instanceType")
 *                                 .build())
 *                         .build())
 *                 .modelName("modelName")
 *                 .variantName("variantName")
 *                 .build()))
 *         .name("name")
 *         .roleArn("roleArn")
 *         .type("type")
 *         // the properties below are optional
 *         .dataStorageConfig(DataStorageConfigProperty.builder()
 *                 .destination("destination")
 *                 // the properties below are optional
 *                 .contentType(CaptureContentTypeHeaderProperty.builder()
 *                         .csvContentTypes(List.of("csvContentTypes"))
 *                         .jsonContentTypes(List.of("jsonContentTypes"))
 *                         .build())
 *                 .kmsKey("kmsKey")
 *                 .build())
 *         .description("description")
 *         .desiredState("desiredState")
 *         .kmsKey("kmsKey")
 *         .schedule(InferenceExperimentScheduleProperty.builder()
 *                 .endTime("endTime")
 *                 .startTime("startTime")
 *                 .build())
 *         .shadowModeConfig(ShadowModeConfigProperty.builder()
 *                 .shadowModelVariants(List.of(ShadowModelVariantConfigProperty.builder()
 *                         .samplingPercentage(123)
 *                         .shadowModelVariantName("shadowModelVariantName")
 *                         .build()))
 *                 .sourceModelVariantName("sourceModelVariantName")
 *                 .build())
 *         .statusReason("statusReason")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-inferenceexperiment.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-inferenceexperiment.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-01-25T00:21:03.346Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_sagemaker.CfnInferenceExperimentProps")
@software.amazon.jsii.Jsii.Proxy(CfnInferenceExperimentProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnInferenceExperimentProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The name of the endpoint.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-inferenceexperiment.html#cfn-sagemaker-inferenceexperiment-endpointname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-inferenceexperiment.html#cfn-sagemaker-inferenceexperiment-endpointname</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getEndpointName();

    /**
     * An array of <code>ModelVariantConfigSummary</code> objects.
     * <p>
     * There is one for each variant in the inference experiment. Each <code>ModelVariantConfigSummary</code> object in the array describes the infrastructure configuration for deploying the corresponding variant.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-inferenceexperiment.html#cfn-sagemaker-inferenceexperiment-modelvariants">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-inferenceexperiment.html#cfn-sagemaker-inferenceexperiment-modelvariants</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getModelVariants();

    /**
     * The name of the inference experiment.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-inferenceexperiment.html#cfn-sagemaker-inferenceexperiment-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-inferenceexperiment.html#cfn-sagemaker-inferenceexperiment-name</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getName();

    /**
     * The ARN of the IAM role that Amazon SageMaker can assume to access model artifacts and container images, and manage Amazon SageMaker Inference endpoints for model deployment.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-inferenceexperiment.html#cfn-sagemaker-inferenceexperiment-rolearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-inferenceexperiment.html#cfn-sagemaker-inferenceexperiment-rolearn</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getRoleArn();

    /**
     * The type of the inference experiment.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-inferenceexperiment.html#cfn-sagemaker-inferenceexperiment-type">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-inferenceexperiment.html#cfn-sagemaker-inferenceexperiment-type</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getType();

    /**
     * The Amazon S3 location and configuration for storing inference request and response data.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-inferenceexperiment.html#cfn-sagemaker-inferenceexperiment-datastorageconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-inferenceexperiment.html#cfn-sagemaker-inferenceexperiment-datastorageconfig</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getDataStorageConfig() {
        return null;
    }

    /**
     * The description of the inference experiment.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-inferenceexperiment.html#cfn-sagemaker-inferenceexperiment-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-inferenceexperiment.html#cfn-sagemaker-inferenceexperiment-description</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return null;
    }

    /**
     * The desired state of the experiment after stopping. The possible states are the following:.
     * <p>
     * <ul>
     * <li><code>Completed</code> : The experiment completed successfully</li>
     * <li><code>Cancelled</code> : The experiment was canceled</li>
     * </ul>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-inferenceexperiment.html#cfn-sagemaker-inferenceexperiment-desiredstate">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-inferenceexperiment.html#cfn-sagemaker-inferenceexperiment-desiredstate</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDesiredState() {
        return null;
    }

    /**
     * The AWS Key Management Service key that Amazon SageMaker uses to encrypt captured data at rest using Amazon S3 server-side encryption.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-inferenceexperiment.html#cfn-sagemaker-inferenceexperiment-kmskey">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-inferenceexperiment.html#cfn-sagemaker-inferenceexperiment-kmskey</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getKmsKey() {
        return null;
    }

    /**
     * The duration for which the inference experiment ran or will run.
     * <p>
     * The maximum duration that you can set for an inference experiment is 30 days.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-inferenceexperiment.html#cfn-sagemaker-inferenceexperiment-schedule">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-inferenceexperiment.html#cfn-sagemaker-inferenceexperiment-schedule</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getSchedule() {
        return null;
    }

    /**
     * The configuration of <code>ShadowMode</code> inference experiment type, which shows the production variant that takes all the inference requests, and the shadow variant to which Amazon SageMaker replicates a percentage of the inference requests.
     * <p>
     * For the shadow variant it also shows the percentage of requests that Amazon SageMaker replicates.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-inferenceexperiment.html#cfn-sagemaker-inferenceexperiment-shadowmodeconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-inferenceexperiment.html#cfn-sagemaker-inferenceexperiment-shadowmodeconfig</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getShadowModeConfig() {
        return null;
    }

    /**
     * The error message for the inference experiment status result.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-inferenceexperiment.html#cfn-sagemaker-inferenceexperiment-statusreason">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-inferenceexperiment.html#cfn-sagemaker-inferenceexperiment-statusreason</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getStatusReason() {
        return null;
    }

    /**
     * An array of key-value pairs to apply to this resource.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html">Tag</a> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-inferenceexperiment.html#cfn-sagemaker-inferenceexperiment-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-inferenceexperiment.html#cfn-sagemaker-inferenceexperiment-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnInferenceExperimentProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnInferenceExperimentProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnInferenceExperimentProps> {
        java.lang.String endpointName;
        java.lang.Object modelVariants;
        java.lang.String name;
        java.lang.String roleArn;
        java.lang.String type;
        java.lang.Object dataStorageConfig;
        java.lang.String description;
        java.lang.String desiredState;
        java.lang.String kmsKey;
        java.lang.Object schedule;
        java.lang.Object shadowModeConfig;
        java.lang.String statusReason;
        java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Sets the value of {@link CfnInferenceExperimentProps#getEndpointName}
         * @param endpointName The name of the endpoint. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder endpointName(java.lang.String endpointName) {
            this.endpointName = endpointName;
            return this;
        }

        /**
         * Sets the value of {@link CfnInferenceExperimentProps#getModelVariants}
         * @param modelVariants An array of <code>ModelVariantConfigSummary</code> objects. This parameter is required.
         *                      There is one for each variant in the inference experiment. Each <code>ModelVariantConfigSummary</code> object in the array describes the infrastructure configuration for deploying the corresponding variant.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder modelVariants(software.amazon.awscdk.IResolvable modelVariants) {
            this.modelVariants = modelVariants;
            return this;
        }

        /**
         * Sets the value of {@link CfnInferenceExperimentProps#getModelVariants}
         * @param modelVariants An array of <code>ModelVariantConfigSummary</code> objects. This parameter is required.
         *                      There is one for each variant in the inference experiment. Each <code>ModelVariantConfigSummary</code> object in the array describes the infrastructure configuration for deploying the corresponding variant.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder modelVariants(java.util.List<? extends java.lang.Object> modelVariants) {
            this.modelVariants = modelVariants;
            return this;
        }

        /**
         * Sets the value of {@link CfnInferenceExperimentProps#getName}
         * @param name The name of the inference experiment. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of {@link CfnInferenceExperimentProps#getRoleArn}
         * @param roleArn The ARN of the IAM role that Amazon SageMaker can assume to access model artifacts and container images, and manage Amazon SageMaker Inference endpoints for model deployment. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder roleArn(java.lang.String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnInferenceExperimentProps#getType}
         * @param type The type of the inference experiment. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder type(java.lang.String type) {
            this.type = type;
            return this;
        }

        /**
         * Sets the value of {@link CfnInferenceExperimentProps#getDataStorageConfig}
         * @param dataStorageConfig The Amazon S3 location and configuration for storing inference request and response data.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dataStorageConfig(software.amazon.awscdk.IResolvable dataStorageConfig) {
            this.dataStorageConfig = dataStorageConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnInferenceExperimentProps#getDataStorageConfig}
         * @param dataStorageConfig The Amazon S3 location and configuration for storing inference request and response data.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dataStorageConfig(software.amazon.awscdk.services.sagemaker.CfnInferenceExperiment.DataStorageConfigProperty dataStorageConfig) {
            this.dataStorageConfig = dataStorageConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnInferenceExperimentProps#getDescription}
         * @param description The description of the inference experiment.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link CfnInferenceExperimentProps#getDesiredState}
         * @param desiredState The desired state of the experiment after stopping. The possible states are the following:.
         *                     <ul>
         *                     <li><code>Completed</code> : The experiment completed successfully</li>
         *                     <li><code>Cancelled</code> : The experiment was canceled</li>
         *                     </ul>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder desiredState(java.lang.String desiredState) {
            this.desiredState = desiredState;
            return this;
        }

        /**
         * Sets the value of {@link CfnInferenceExperimentProps#getKmsKey}
         * @param kmsKey The AWS Key Management Service key that Amazon SageMaker uses to encrypt captured data at rest using Amazon S3 server-side encryption.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder kmsKey(java.lang.String kmsKey) {
            this.kmsKey = kmsKey;
            return this;
        }

        /**
         * Sets the value of {@link CfnInferenceExperimentProps#getSchedule}
         * @param schedule The duration for which the inference experiment ran or will run.
         *                 The maximum duration that you can set for an inference experiment is 30 days.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder schedule(software.amazon.awscdk.IResolvable schedule) {
            this.schedule = schedule;
            return this;
        }

        /**
         * Sets the value of {@link CfnInferenceExperimentProps#getSchedule}
         * @param schedule The duration for which the inference experiment ran or will run.
         *                 The maximum duration that you can set for an inference experiment is 30 days.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder schedule(software.amazon.awscdk.services.sagemaker.CfnInferenceExperiment.InferenceExperimentScheduleProperty schedule) {
            this.schedule = schedule;
            return this;
        }

        /**
         * Sets the value of {@link CfnInferenceExperimentProps#getShadowModeConfig}
         * @param shadowModeConfig The configuration of <code>ShadowMode</code> inference experiment type, which shows the production variant that takes all the inference requests, and the shadow variant to which Amazon SageMaker replicates a percentage of the inference requests.
         *                         For the shadow variant it also shows the percentage of requests that Amazon SageMaker replicates.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder shadowModeConfig(software.amazon.awscdk.IResolvable shadowModeConfig) {
            this.shadowModeConfig = shadowModeConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnInferenceExperimentProps#getShadowModeConfig}
         * @param shadowModeConfig The configuration of <code>ShadowMode</code> inference experiment type, which shows the production variant that takes all the inference requests, and the shadow variant to which Amazon SageMaker replicates a percentage of the inference requests.
         *                         For the shadow variant it also shows the percentage of requests that Amazon SageMaker replicates.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder shadowModeConfig(software.amazon.awscdk.services.sagemaker.CfnInferenceExperiment.ShadowModeConfigProperty shadowModeConfig) {
            this.shadowModeConfig = shadowModeConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnInferenceExperimentProps#getStatusReason}
         * @param statusReason The error message for the inference experiment status result.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder statusReason(java.lang.String statusReason) {
            this.statusReason = statusReason;
            return this;
        }

        /**
         * Sets the value of {@link CfnInferenceExperimentProps#getTags}
         * @param tags An array of key-value pairs to apply to this resource.
         *             For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html">Tag</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnInferenceExperimentProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnInferenceExperimentProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnInferenceExperimentProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnInferenceExperimentProps {
        private final java.lang.String endpointName;
        private final java.lang.Object modelVariants;
        private final java.lang.String name;
        private final java.lang.String roleArn;
        private final java.lang.String type;
        private final java.lang.Object dataStorageConfig;
        private final java.lang.String description;
        private final java.lang.String desiredState;
        private final java.lang.String kmsKey;
        private final java.lang.Object schedule;
        private final java.lang.Object shadowModeConfig;
        private final java.lang.String statusReason;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.endpointName = software.amazon.jsii.Kernel.get(this, "endpointName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.modelVariants = software.amazon.jsii.Kernel.get(this, "modelVariants", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.roleArn = software.amazon.jsii.Kernel.get(this, "roleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.type = software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.dataStorageConfig = software.amazon.jsii.Kernel.get(this, "dataStorageConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.desiredState = software.amazon.jsii.Kernel.get(this, "desiredState", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.kmsKey = software.amazon.jsii.Kernel.get(this, "kmsKey", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.schedule = software.amazon.jsii.Kernel.get(this, "schedule", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.shadowModeConfig = software.amazon.jsii.Kernel.get(this, "shadowModeConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.statusReason = software.amazon.jsii.Kernel.get(this, "statusReason", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.endpointName = java.util.Objects.requireNonNull(builder.endpointName, "endpointName is required");
            this.modelVariants = java.util.Objects.requireNonNull(builder.modelVariants, "modelVariants is required");
            this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
            this.roleArn = java.util.Objects.requireNonNull(builder.roleArn, "roleArn is required");
            this.type = java.util.Objects.requireNonNull(builder.type, "type is required");
            this.dataStorageConfig = builder.dataStorageConfig;
            this.description = builder.description;
            this.desiredState = builder.desiredState;
            this.kmsKey = builder.kmsKey;
            this.schedule = builder.schedule;
            this.shadowModeConfig = builder.shadowModeConfig;
            this.statusReason = builder.statusReason;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
        }

        @Override
        public final java.lang.String getEndpointName() {
            return this.endpointName;
        }

        @Override
        public final java.lang.Object getModelVariants() {
            return this.modelVariants;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        public final java.lang.String getRoleArn() {
            return this.roleArn;
        }

        @Override
        public final java.lang.String getType() {
            return this.type;
        }

        @Override
        public final java.lang.Object getDataStorageConfig() {
            return this.dataStorageConfig;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public final java.lang.String getDesiredState() {
            return this.desiredState;
        }

        @Override
        public final java.lang.String getKmsKey() {
            return this.kmsKey;
        }

        @Override
        public final java.lang.Object getSchedule() {
            return this.schedule;
        }

        @Override
        public final java.lang.Object getShadowModeConfig() {
            return this.shadowModeConfig;
        }

        @Override
        public final java.lang.String getStatusReason() {
            return this.statusReason;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("endpointName", om.valueToTree(this.getEndpointName()));
            data.set("modelVariants", om.valueToTree(this.getModelVariants()));
            data.set("name", om.valueToTree(this.getName()));
            data.set("roleArn", om.valueToTree(this.getRoleArn()));
            data.set("type", om.valueToTree(this.getType()));
            if (this.getDataStorageConfig() != null) {
                data.set("dataStorageConfig", om.valueToTree(this.getDataStorageConfig()));
            }
            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getDesiredState() != null) {
                data.set("desiredState", om.valueToTree(this.getDesiredState()));
            }
            if (this.getKmsKey() != null) {
                data.set("kmsKey", om.valueToTree(this.getKmsKey()));
            }
            if (this.getSchedule() != null) {
                data.set("schedule", om.valueToTree(this.getSchedule()));
            }
            if (this.getShadowModeConfig() != null) {
                data.set("shadowModeConfig", om.valueToTree(this.getShadowModeConfig()));
            }
            if (this.getStatusReason() != null) {
                data.set("statusReason", om.valueToTree(this.getStatusReason()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_sagemaker.CfnInferenceExperimentProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnInferenceExperimentProps.Jsii$Proxy that = (CfnInferenceExperimentProps.Jsii$Proxy) o;

            if (!endpointName.equals(that.endpointName)) return false;
            if (!modelVariants.equals(that.modelVariants)) return false;
            if (!name.equals(that.name)) return false;
            if (!roleArn.equals(that.roleArn)) return false;
            if (!type.equals(that.type)) return false;
            if (this.dataStorageConfig != null ? !this.dataStorageConfig.equals(that.dataStorageConfig) : that.dataStorageConfig != null) return false;
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            if (this.desiredState != null ? !this.desiredState.equals(that.desiredState) : that.desiredState != null) return false;
            if (this.kmsKey != null ? !this.kmsKey.equals(that.kmsKey) : that.kmsKey != null) return false;
            if (this.schedule != null ? !this.schedule.equals(that.schedule) : that.schedule != null) return false;
            if (this.shadowModeConfig != null ? !this.shadowModeConfig.equals(that.shadowModeConfig) : that.shadowModeConfig != null) return false;
            if (this.statusReason != null ? !this.statusReason.equals(that.statusReason) : that.statusReason != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.endpointName.hashCode();
            result = 31 * result + (this.modelVariants.hashCode());
            result = 31 * result + (this.name.hashCode());
            result = 31 * result + (this.roleArn.hashCode());
            result = 31 * result + (this.type.hashCode());
            result = 31 * result + (this.dataStorageConfig != null ? this.dataStorageConfig.hashCode() : 0);
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            result = 31 * result + (this.desiredState != null ? this.desiredState.hashCode() : 0);
            result = 31 * result + (this.kmsKey != null ? this.kmsKey.hashCode() : 0);
            result = 31 * result + (this.schedule != null ? this.schedule.hashCode() : 0);
            result = 31 * result + (this.shadowModeConfig != null ? this.shadowModeConfig.hashCode() : 0);
            result = 31 * result + (this.statusReason != null ? this.statusReason.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
