package software.amazon.awscdk.services.sagemaker;

/**
 * Properties for defining a <code>CfnWorkteam</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.sagemaker.*;
 * CfnWorkteamProps cfnWorkteamProps = CfnWorkteamProps.builder()
 *         .description("description")
 *         .memberDefinitions(List.of(MemberDefinitionProperty.builder()
 *                 .cognitoMemberDefinition(CognitoMemberDefinitionProperty.builder()
 *                         .cognitoClientId("cognitoClientId")
 *                         .cognitoUserGroup("cognitoUserGroup")
 *                         .cognitoUserPool("cognitoUserPool")
 *                         .build())
 *                 .oidcMemberDefinition(OidcMemberDefinitionProperty.builder()
 *                         .oidcGroups(List.of("oidcGroups"))
 *                         .build())
 *                 .build()))
 *         .notificationConfiguration(NotificationConfigurationProperty.builder()
 *                 .notificationTopicArn("notificationTopicArn")
 *                 .build())
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .workforceName("workforceName")
 *         .workteamName("workteamName")
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-workteam.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-workteam.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-01-25T00:21:03.553Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_sagemaker.CfnWorkteamProps")
@software.amazon.jsii.Jsii.Proxy(CfnWorkteamProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnWorkteamProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * A description of the work team.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-workteam.html#cfn-sagemaker-workteam-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-workteam.html#cfn-sagemaker-workteam-description</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return null;
    }

    /**
     * A list of <code>MemberDefinition</code> objects that contains objects that identify the workers that make up the work team.
     * <p>
     * Workforces can be created using Amazon Cognito or your own OIDC Identity Provider (IdP). For private workforces created using Amazon Cognito use <code>CognitoMemberDefinition</code> . For workforces created using your own OIDC identity provider (IdP) use <code>OidcMemberDefinition</code> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-workteam.html#cfn-sagemaker-workteam-memberdefinitions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-workteam.html#cfn-sagemaker-workteam-memberdefinitions</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getMemberDefinitions() {
        return null;
    }

    /**
     * Configures SNS notifications of available or expiring work items for work teams.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-workteam.html#cfn-sagemaker-workteam-notificationconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-workteam.html#cfn-sagemaker-workteam-notificationconfiguration</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getNotificationConfiguration() {
        return null;
    }

    /**
     * An array of key-value pairs.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-workteam.html#cfn-sagemaker-workteam-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-workteam.html#cfn-sagemaker-workteam-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * The name of the workforce.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-workteam.html#cfn-sagemaker-workteam-workforcename">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-workteam.html#cfn-sagemaker-workteam-workforcename</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getWorkforceName() {
        return null;
    }

    /**
     * The name of the work team.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-workteam.html#cfn-sagemaker-workteam-workteamname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-workteam.html#cfn-sagemaker-workteam-workteamname</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getWorkteamName() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnWorkteamProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnWorkteamProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnWorkteamProps> {
        java.lang.String description;
        java.lang.Object memberDefinitions;
        java.lang.Object notificationConfiguration;
        java.util.List<software.amazon.awscdk.CfnTag> tags;
        java.lang.String workforceName;
        java.lang.String workteamName;

        /**
         * Sets the value of {@link CfnWorkteamProps#getDescription}
         * @param description A description of the work team.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link CfnWorkteamProps#getMemberDefinitions}
         * @param memberDefinitions A list of <code>MemberDefinition</code> objects that contains objects that identify the workers that make up the work team.
         *                          Workforces can be created using Amazon Cognito or your own OIDC Identity Provider (IdP). For private workforces created using Amazon Cognito use <code>CognitoMemberDefinition</code> . For workforces created using your own OIDC identity provider (IdP) use <code>OidcMemberDefinition</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder memberDefinitions(software.amazon.awscdk.IResolvable memberDefinitions) {
            this.memberDefinitions = memberDefinitions;
            return this;
        }

        /**
         * Sets the value of {@link CfnWorkteamProps#getMemberDefinitions}
         * @param memberDefinitions A list of <code>MemberDefinition</code> objects that contains objects that identify the workers that make up the work team.
         *                          Workforces can be created using Amazon Cognito or your own OIDC Identity Provider (IdP). For private workforces created using Amazon Cognito use <code>CognitoMemberDefinition</code> . For workforces created using your own OIDC identity provider (IdP) use <code>OidcMemberDefinition</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder memberDefinitions(java.util.List<? extends java.lang.Object> memberDefinitions) {
            this.memberDefinitions = memberDefinitions;
            return this;
        }

        /**
         * Sets the value of {@link CfnWorkteamProps#getNotificationConfiguration}
         * @param notificationConfiguration Configures SNS notifications of available or expiring work items for work teams.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder notificationConfiguration(software.amazon.awscdk.IResolvable notificationConfiguration) {
            this.notificationConfiguration = notificationConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnWorkteamProps#getNotificationConfiguration}
         * @param notificationConfiguration Configures SNS notifications of available or expiring work items for work teams.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder notificationConfiguration(software.amazon.awscdk.services.sagemaker.CfnWorkteam.NotificationConfigurationProperty notificationConfiguration) {
            this.notificationConfiguration = notificationConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnWorkteamProps#getTags}
         * @param tags An array of key-value pairs.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Sets the value of {@link CfnWorkteamProps#getWorkforceName}
         * @param workforceName The name of the workforce.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder workforceName(java.lang.String workforceName) {
            this.workforceName = workforceName;
            return this;
        }

        /**
         * Sets the value of {@link CfnWorkteamProps#getWorkteamName}
         * @param workteamName The name of the work team.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder workteamName(java.lang.String workteamName) {
            this.workteamName = workteamName;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnWorkteamProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnWorkteamProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnWorkteamProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnWorkteamProps {
        private final java.lang.String description;
        private final java.lang.Object memberDefinitions;
        private final java.lang.Object notificationConfiguration;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;
        private final java.lang.String workforceName;
        private final java.lang.String workteamName;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.memberDefinitions = software.amazon.jsii.Kernel.get(this, "memberDefinitions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.notificationConfiguration = software.amazon.jsii.Kernel.get(this, "notificationConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
            this.workforceName = software.amazon.jsii.Kernel.get(this, "workforceName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.workteamName = software.amazon.jsii.Kernel.get(this, "workteamName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.description = builder.description;
            this.memberDefinitions = builder.memberDefinitions;
            this.notificationConfiguration = builder.notificationConfiguration;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
            this.workforceName = builder.workforceName;
            this.workteamName = builder.workteamName;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public final java.lang.Object getMemberDefinitions() {
            return this.memberDefinitions;
        }

        @Override
        public final java.lang.Object getNotificationConfiguration() {
            return this.notificationConfiguration;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        public final java.lang.String getWorkforceName() {
            return this.workforceName;
        }

        @Override
        public final java.lang.String getWorkteamName() {
            return this.workteamName;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getMemberDefinitions() != null) {
                data.set("memberDefinitions", om.valueToTree(this.getMemberDefinitions()));
            }
            if (this.getNotificationConfiguration() != null) {
                data.set("notificationConfiguration", om.valueToTree(this.getNotificationConfiguration()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }
            if (this.getWorkforceName() != null) {
                data.set("workforceName", om.valueToTree(this.getWorkforceName()));
            }
            if (this.getWorkteamName() != null) {
                data.set("workteamName", om.valueToTree(this.getWorkteamName()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_sagemaker.CfnWorkteamProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnWorkteamProps.Jsii$Proxy that = (CfnWorkteamProps.Jsii$Proxy) o;

            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            if (this.memberDefinitions != null ? !this.memberDefinitions.equals(that.memberDefinitions) : that.memberDefinitions != null) return false;
            if (this.notificationConfiguration != null ? !this.notificationConfiguration.equals(that.notificationConfiguration) : that.notificationConfiguration != null) return false;
            if (this.tags != null ? !this.tags.equals(that.tags) : that.tags != null) return false;
            if (this.workforceName != null ? !this.workforceName.equals(that.workforceName) : that.workforceName != null) return false;
            return this.workteamName != null ? this.workteamName.equals(that.workteamName) : that.workteamName == null;
        }

        @Override
        public final int hashCode() {
            int result = this.description != null ? this.description.hashCode() : 0;
            result = 31 * result + (this.memberDefinitions != null ? this.memberDefinitions.hashCode() : 0);
            result = 31 * result + (this.notificationConfiguration != null ? this.notificationConfiguration.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            result = 31 * result + (this.workforceName != null ? this.workforceName.hashCode() : 0);
            result = 31 * result + (this.workteamName != null ? this.workteamName.hashCode() : 0);
            return result;
        }
    }
}
