package software.amazon.awscdk.services.sam;

/**
 * https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#awsserverlessfunction.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.sam.*;
 * Object assumeRolePolicyDocument;
 * CfnFunction cfnFunction = CfnFunction.Builder.create(this, "MyCfnFunction")
 *         .architectures(List.of("architectures"))
 *         .assumeRolePolicyDocument(assumeRolePolicyDocument)
 *         .autoPublishAlias("autoPublishAlias")
 *         .autoPublishCodeSha256("autoPublishCodeSha256")
 *         .codeSigningConfigArn("codeSigningConfigArn")
 *         .codeUri("codeUri")
 *         .deadLetterQueue(DeadLetterQueueProperty.builder()
 *                 .targetArn("targetArn")
 *                 .type("type")
 *                 .build())
 *         .deploymentPreference(DeploymentPreferenceProperty.builder()
 *                 .alarms(List.of("alarms"))
 *                 .enabled(false)
 *                 .hooks(HooksProperty.builder()
 *                         .postTraffic("postTraffic")
 *                         .preTraffic("preTraffic")
 *                         .build())
 *                 .role("role")
 *                 .type("type")
 *                 .build())
 *         .description("description")
 *         .environment(FunctionEnvironmentProperty.builder()
 *                 .variables(Map.of(
 *                         "variablesKey", "variables"))
 *                 .build())
 *         .ephemeralStorage(EphemeralStorageProperty.builder()
 *                 .size(123)
 *                 .build())
 *         .eventInvokeConfig(EventInvokeConfigProperty.builder()
 *                 .destinationConfig(EventInvokeDestinationConfigProperty.builder()
 *                         .onFailure(DestinationProperty.builder()
 *                                 .destination("destination")
 *                                 // the properties below are optional
 *                                 .type("type")
 *                                 .build())
 *                         .onSuccess(DestinationProperty.builder()
 *                                 .destination("destination")
 *                                 // the properties below are optional
 *                                 .type("type")
 *                                 .build())
 *                         .build())
 *                 .maximumEventAgeInSeconds(123)
 *                 .maximumRetryAttempts(123)
 *                 .build())
 *         .events(Map.of(
 *                 "eventsKey", EventSourceProperty.builder()
 *                         .properties(AlexaSkillEventProperty.builder()
 *                                 .skillId("skillId")
 *                                 .build())
 *                         .type("type")
 *                         .build()))
 *         .fileSystemConfigs(List.of(FileSystemConfigProperty.builder()
 *                 .arn("arn")
 *                 .localMountPath("localMountPath")
 *                 .build()))
 *         .functionName("functionName")
 *         .functionUrlConfig(FunctionUrlConfigProperty.builder()
 *                 .authType("authType")
 *                 // the properties below are optional
 *                 .cors("cors")
 *                 .invokeMode("invokeMode")
 *                 .build())
 *         .handler("handler")
 *         .imageConfig(ImageConfigProperty.builder()
 *                 .command(List.of("command"))
 *                 .entryPoint(List.of("entryPoint"))
 *                 .workingDirectory("workingDirectory")
 *                 .build())
 *         .imageUri("imageUri")
 *         .inlineCode("inlineCode")
 *         .kmsKeyArn("kmsKeyArn")
 *         .layers(List.of("layers"))
 *         .memorySize(123)
 *         .packageType("packageType")
 *         .permissionsBoundary("permissionsBoundary")
 *         .policies("policies")
 *         .provisionedConcurrencyConfig(ProvisionedConcurrencyConfigProperty.builder()
 *                 .provisionedConcurrentExecutions("provisionedConcurrentExecutions")
 *                 .build())
 *         .reservedConcurrentExecutions(123)
 *         .role("role")
 *         .runtime("runtime")
 *         .tags(Map.of(
 *                 "tagsKey", "tags"))
 *         .timeout(123)
 *         .tracing("tracing")
 *         .versionDescription("versionDescription")
 *         .vpcConfig(VpcConfigProperty.builder()
 *                 .securityGroupIds(List.of("securityGroupIds"))
 *                 .subnetIds(List.of("subnetIds"))
 *                 .build())
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-serverless-function.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-serverless-function.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-01-25T00:21:03.576Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_sam.CfnFunction")
public class CfnFunction extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable, software.amazon.awscdk.ITaggable {

    protected CfnFunction(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnFunction(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.sam.CfnFunction.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        REQUIRED_TRANSFORM = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.sam.CfnFunction.class, "REQUIRED_TRANSFORM", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnFunction(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.sam.CfnFunctionProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), props });
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnFunction(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The <code>Transform</code> a template must use in order to use this resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String REQUIRED_TRANSFORM;

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * Tag Manager which manages the tags for this resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getArchitectures() {
        return java.util.Optional.ofNullable((java.util.List<java.lang.String>)(software.amazon.jsii.Kernel.get(this, "architectures", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setArchitectures(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> value) {
        software.amazon.jsii.Kernel.set(this, "architectures", value);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getAssumeRolePolicyDocument() {
        return software.amazon.jsii.Kernel.get(this, "assumeRolePolicyDocument", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAssumeRolePolicyDocument(final @org.jetbrains.annotations.Nullable java.lang.Object value) {
        software.amazon.jsii.Kernel.set(this, "assumeRolePolicyDocument", value);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getAutoPublishAlias() {
        return software.amazon.jsii.Kernel.get(this, "autoPublishAlias", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAutoPublishAlias(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "autoPublishAlias", value);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getAutoPublishCodeSha256() {
        return software.amazon.jsii.Kernel.get(this, "autoPublishCodeSha256", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAutoPublishCodeSha256(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "autoPublishCodeSha256", value);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getCodeSigningConfigArn() {
        return software.amazon.jsii.Kernel.get(this, "codeSigningConfigArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCodeSigningConfigArn(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "codeSigningConfigArn", value);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getCodeUri() {
        return software.amazon.jsii.Kernel.get(this, "codeUri", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCodeUri(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "codeUri", value);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCodeUri(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "codeUri", value);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCodeUri(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.sam.CfnFunction.S3LocationProperty value) {
        software.amazon.jsii.Kernel.set(this, "codeUri", value);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getDeadLetterQueue() {
        return software.amazon.jsii.Kernel.get(this, "deadLetterQueue", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDeadLetterQueue(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "deadLetterQueue", value);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDeadLetterQueue(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.sam.CfnFunction.DeadLetterQueueProperty value) {
        software.amazon.jsii.Kernel.set(this, "deadLetterQueue", value);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getDeploymentPreference() {
        return software.amazon.jsii.Kernel.get(this, "deploymentPreference", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDeploymentPreference(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "deploymentPreference", value);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDeploymentPreference(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.sam.CfnFunction.DeploymentPreferenceProperty value) {
        software.amazon.jsii.Kernel.set(this, "deploymentPreference", value);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDescription(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "description", value);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getEnvironment() {
        return software.amazon.jsii.Kernel.get(this, "environment", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEnvironment(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "environment", value);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEnvironment(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.sam.CfnFunction.FunctionEnvironmentProperty value) {
        software.amazon.jsii.Kernel.set(this, "environment", value);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getEphemeralStorage() {
        return software.amazon.jsii.Kernel.get(this, "ephemeralStorage", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEphemeralStorage(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "ephemeralStorage", value);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEphemeralStorage(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.sam.CfnFunction.EphemeralStorageProperty value) {
        software.amazon.jsii.Kernel.set(this, "ephemeralStorage", value);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getEventInvokeConfig() {
        return software.amazon.jsii.Kernel.get(this, "eventInvokeConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEventInvokeConfig(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "eventInvokeConfig", value);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEventInvokeConfig(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.sam.CfnFunction.EventInvokeConfigProperty value) {
        software.amazon.jsii.Kernel.set(this, "eventInvokeConfig", value);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getEvents() {
        return software.amazon.jsii.Kernel.get(this, "events", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEvents(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "events", value);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEvents(final @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            if (!(value.keySet().toArray()[0] instanceof String)) {
                throw new IllegalArgumentException(
                    new java.lang.StringBuilder("Expected ")
                        .append("value").append(".keySet()")
                        .append(" to contain class String; received ")
                        .append(value.keySet().toArray()[0].getClass()).toString());
            }
            for (final java.util.Map.Entry<String, java.lang.Object> __item_ac66f0: value.entrySet()) {
                final java.lang.Object __val_ac66f0 = __item_ac66f0.getValue();
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.services.sam.CfnFunction.EventSourceProperty)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(\"").append((__item_ac66f0.getKey())).append("\")")
                            .append(" to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.sam.CfnFunction.EventSourceProperty; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "events", value);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getFileSystemConfigs() {
        return software.amazon.jsii.Kernel.get(this, "fileSystemConfigs", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setFileSystemConfigs(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "fileSystemConfigs", value);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setFileSystemConfigs(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.services.sam.CfnFunction.FileSystemConfigProperty)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.sam.CfnFunction.FileSystemConfigProperty; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "fileSystemConfigs", value);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getFunctionName() {
        return software.amazon.jsii.Kernel.get(this, "functionName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setFunctionName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "functionName", value);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getFunctionUrlConfig() {
        return software.amazon.jsii.Kernel.get(this, "functionUrlConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setFunctionUrlConfig(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "functionUrlConfig", value);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setFunctionUrlConfig(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.sam.CfnFunction.FunctionUrlConfigProperty value) {
        software.amazon.jsii.Kernel.set(this, "functionUrlConfig", value);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getHandler() {
        return software.amazon.jsii.Kernel.get(this, "handler", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setHandler(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "handler", value);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getImageConfig() {
        return software.amazon.jsii.Kernel.get(this, "imageConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setImageConfig(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "imageConfig", value);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setImageConfig(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.sam.CfnFunction.ImageConfigProperty value) {
        software.amazon.jsii.Kernel.set(this, "imageConfig", value);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getImageUri() {
        return software.amazon.jsii.Kernel.get(this, "imageUri", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setImageUri(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "imageUri", value);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getInlineCode() {
        return software.amazon.jsii.Kernel.get(this, "inlineCode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setInlineCode(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "inlineCode", value);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getKmsKeyArn() {
        return software.amazon.jsii.Kernel.get(this, "kmsKeyArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setKmsKeyArn(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "kmsKeyArn", value);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getLayers() {
        return java.util.Optional.ofNullable((java.util.List<java.lang.String>)(software.amazon.jsii.Kernel.get(this, "layers", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setLayers(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> value) {
        software.amazon.jsii.Kernel.set(this, "layers", value);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Number getMemorySize() {
        return software.amazon.jsii.Kernel.get(this, "memorySize", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setMemorySize(final @org.jetbrains.annotations.Nullable java.lang.Number value) {
        software.amazon.jsii.Kernel.set(this, "memorySize", value);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getPackageType() {
        return software.amazon.jsii.Kernel.get(this, "packageType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPackageType(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "packageType", value);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getPermissionsBoundary() {
        return software.amazon.jsii.Kernel.get(this, "permissionsBoundary", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPermissionsBoundary(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "permissionsBoundary", value);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getPolicies() {
        return software.amazon.jsii.Kernel.get(this, "policies", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPolicies(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "policies", value);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPolicies(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "policies", value);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPolicies(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.sam.CfnFunction.IAMPolicyDocumentProperty value) {
        software.amazon.jsii.Kernel.set(this, "policies", value);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPolicies(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof java.lang.String)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.services.sam.CfnFunction.IAMPolicyDocumentProperty)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.services.sam.CfnFunction.SAMPolicyTemplateProperty)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: java.lang.String, software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.sam.CfnFunction.IAMPolicyDocumentProperty, software.amazon.awscdk.services.sam.CfnFunction.SAMPolicyTemplateProperty; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "policies", value);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getProvisionedConcurrencyConfig() {
        return software.amazon.jsii.Kernel.get(this, "provisionedConcurrencyConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setProvisionedConcurrencyConfig(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "provisionedConcurrencyConfig", value);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setProvisionedConcurrencyConfig(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.sam.CfnFunction.ProvisionedConcurrencyConfigProperty value) {
        software.amazon.jsii.Kernel.set(this, "provisionedConcurrencyConfig", value);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Number getReservedConcurrentExecutions() {
        return software.amazon.jsii.Kernel.get(this, "reservedConcurrentExecutions", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setReservedConcurrentExecutions(final @org.jetbrains.annotations.Nullable java.lang.Number value) {
        software.amazon.jsii.Kernel.set(this, "reservedConcurrentExecutions", value);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getRole() {
        return software.amazon.jsii.Kernel.get(this, "role", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRole(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "role", value);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getRuntime() {
        return software.amazon.jsii.Kernel.get(this, "runtime", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRuntime(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "runtime", value);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> getTagsRaw() {
        return java.util.Optional.ofNullable((java.util.Map<java.lang.String, java.lang.String>)(software.amazon.jsii.Kernel.get(this, "tagsRaw", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))))).map(java.util.Collections::unmodifiableMap).orElse(null);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTagsRaw(final @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> value) {
        software.amazon.jsii.Kernel.set(this, "tagsRaw", value);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Number getTimeout() {
        return software.amazon.jsii.Kernel.get(this, "timeout", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTimeout(final @org.jetbrains.annotations.Nullable java.lang.Number value) {
        software.amazon.jsii.Kernel.set(this, "timeout", value);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getTracing() {
        return software.amazon.jsii.Kernel.get(this, "tracing", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTracing(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "tracing", value);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getVersionDescription() {
        return software.amazon.jsii.Kernel.get(this, "versionDescription", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setVersionDescription(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "versionDescription", value);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getVpcConfig() {
        return software.amazon.jsii.Kernel.get(this, "vpcConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setVpcConfig(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "vpcConfig", value);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setVpcConfig(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.sam.CfnFunction.VpcConfigProperty value) {
        software.amazon.jsii.Kernel.set(this, "vpcConfig", value);
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sam.*;
     * AlexaSkillEventProperty alexaSkillEventProperty = AlexaSkillEventProperty.builder()
     *         .skillId("skillId")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-alexaskillevent.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-alexaskillevent.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_sam.CfnFunction.AlexaSkillEventProperty")
    @software.amazon.jsii.Jsii.Proxy(AlexaSkillEventProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AlexaSkillEventProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-alexaskillevent.html#cfn-serverless-function-alexaskillevent-skillid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-alexaskillevent.html#cfn-serverless-function-alexaskillevent-skillid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getSkillId();

        /**
         * @return a {@link Builder} of {@link AlexaSkillEventProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AlexaSkillEventProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AlexaSkillEventProperty> {
            java.lang.String skillId;

            /**
             * Sets the value of {@link AlexaSkillEventProperty#getSkillId}
             * @param skillId the value to be set. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder skillId(java.lang.String skillId) {
                this.skillId = skillId;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AlexaSkillEventProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AlexaSkillEventProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AlexaSkillEventProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AlexaSkillEventProperty {
            private final java.lang.String skillId;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.skillId = software.amazon.jsii.Kernel.get(this, "skillId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.skillId = java.util.Objects.requireNonNull(builder.skillId, "skillId is required");
            }

            @Override
            public final java.lang.String getSkillId() {
                return this.skillId;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("skillId", om.valueToTree(this.getSkillId()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_sam.CfnFunction.AlexaSkillEventProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AlexaSkillEventProperty.Jsii$Proxy that = (AlexaSkillEventProperty.Jsii$Proxy) o;

                return this.skillId.equals(that.skillId);
            }

            @Override
            public final int hashCode() {
                int result = this.skillId.hashCode();
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sam.*;
     * Object customStatements;
     * ApiEventProperty apiEventProperty = ApiEventProperty.builder()
     *         .method("method")
     *         .path("path")
     *         // the properties below are optional
     *         .auth(AuthProperty.builder()
     *                 .apiKeyRequired(false)
     *                 .authorizationScopes(List.of("authorizationScopes"))
     *                 .authorizer("authorizer")
     *                 .resourcePolicy(AuthResourcePolicyProperty.builder()
     *                         .awsAccountBlacklist(List.of("awsAccountBlacklist"))
     *                         .awsAccountWhitelist(List.of("awsAccountWhitelist"))
     *                         .customStatements(List.of(customStatements))
     *                         .intrinsicVpcBlacklist(List.of("intrinsicVpcBlacklist"))
     *                         .intrinsicVpceBlacklist(List.of("intrinsicVpceBlacklist"))
     *                         .intrinsicVpceWhitelist(List.of("intrinsicVpceWhitelist"))
     *                         .intrinsicVpcWhitelist(List.of("intrinsicVpcWhitelist"))
     *                         .ipRangeBlacklist(List.of("ipRangeBlacklist"))
     *                         .ipRangeWhitelist(List.of("ipRangeWhitelist"))
     *                         .sourceVpcBlacklist(List.of("sourceVpcBlacklist"))
     *                         .sourceVpcWhitelist(List.of("sourceVpcWhitelist"))
     *                         .build())
     *                 .build())
     *         .requestModel(RequestModelProperty.builder()
     *                 .model("model")
     *                 // the properties below are optional
     *                 .required(false)
     *                 .validateBody(false)
     *                 .validateParameters(false)
     *                 .build())
     *         .requestParameters(List.of("requestParameters"))
     *         .restApiId("restApiId")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-apievent.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-apievent.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_sam.CfnFunction.ApiEventProperty")
    @software.amazon.jsii.Jsii.Proxy(ApiEventProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ApiEventProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-apievent.html#cfn-serverless-function-apievent-method">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-apievent.html#cfn-serverless-function-apievent-method</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getMethod();

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-apievent.html#cfn-serverless-function-apievent-path">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-apievent.html#cfn-serverless-function-apievent-path</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getPath();

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-apievent.html#cfn-serverless-function-apievent-auth">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-apievent.html#cfn-serverless-function-apievent-auth</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAuth() {
            return null;
        }

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-apievent.html#cfn-serverless-function-apievent-requestmodel">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-apievent.html#cfn-serverless-function-apievent-requestmodel</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getRequestModel() {
            return null;
        }

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-apievent.html#cfn-serverless-function-apievent-requestparameters">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-apievent.html#cfn-serverless-function-apievent-requestparameters</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getRequestParameters() {
            return null;
        }

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-apievent.html#cfn-serverless-function-apievent-restapiid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-apievent.html#cfn-serverless-function-apievent-restapiid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getRestApiId() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ApiEventProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ApiEventProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ApiEventProperty> {
            java.lang.String method;
            java.lang.String path;
            java.lang.Object auth;
            java.lang.Object requestModel;
            java.lang.Object requestParameters;
            java.lang.String restApiId;

            /**
             * Sets the value of {@link ApiEventProperty#getMethod}
             * @param method the value to be set. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder method(java.lang.String method) {
                this.method = method;
                return this;
            }

            /**
             * Sets the value of {@link ApiEventProperty#getPath}
             * @param path the value to be set. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder path(java.lang.String path) {
                this.path = path;
                return this;
            }

            /**
             * Sets the value of {@link ApiEventProperty#getAuth}
             * @param auth the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder auth(software.amazon.awscdk.IResolvable auth) {
                this.auth = auth;
                return this;
            }

            /**
             * Sets the value of {@link ApiEventProperty#getAuth}
             * @param auth the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder auth(software.amazon.awscdk.services.sam.CfnFunction.AuthProperty auth) {
                this.auth = auth;
                return this;
            }

            /**
             * Sets the value of {@link ApiEventProperty#getRequestModel}
             * @param requestModel the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder requestModel(software.amazon.awscdk.IResolvable requestModel) {
                this.requestModel = requestModel;
                return this;
            }

            /**
             * Sets the value of {@link ApiEventProperty#getRequestModel}
             * @param requestModel the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder requestModel(software.amazon.awscdk.services.sam.CfnFunction.RequestModelProperty requestModel) {
                this.requestModel = requestModel;
                return this;
            }

            /**
             * Sets the value of {@link ApiEventProperty#getRequestParameters}
             * @param requestParameters the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder requestParameters(software.amazon.awscdk.IResolvable requestParameters) {
                this.requestParameters = requestParameters;
                return this;
            }

            /**
             * Sets the value of {@link ApiEventProperty#getRequestParameters}
             * @param requestParameters the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder requestParameters(java.util.List<? extends java.lang.Object> requestParameters) {
                this.requestParameters = requestParameters;
                return this;
            }

            /**
             * Sets the value of {@link ApiEventProperty#getRestApiId}
             * @param restApiId the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder restApiId(java.lang.String restApiId) {
                this.restApiId = restApiId;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ApiEventProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ApiEventProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ApiEventProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ApiEventProperty {
            private final java.lang.String method;
            private final java.lang.String path;
            private final java.lang.Object auth;
            private final java.lang.Object requestModel;
            private final java.lang.Object requestParameters;
            private final java.lang.String restApiId;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.method = software.amazon.jsii.Kernel.get(this, "method", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.path = software.amazon.jsii.Kernel.get(this, "path", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.auth = software.amazon.jsii.Kernel.get(this, "auth", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.requestModel = software.amazon.jsii.Kernel.get(this, "requestModel", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.requestParameters = software.amazon.jsii.Kernel.get(this, "requestParameters", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.restApiId = software.amazon.jsii.Kernel.get(this, "restApiId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.method = java.util.Objects.requireNonNull(builder.method, "method is required");
                this.path = java.util.Objects.requireNonNull(builder.path, "path is required");
                this.auth = builder.auth;
                this.requestModel = builder.requestModel;
                this.requestParameters = builder.requestParameters;
                this.restApiId = builder.restApiId;
            }

            @Override
            public final java.lang.String getMethod() {
                return this.method;
            }

            @Override
            public final java.lang.String getPath() {
                return this.path;
            }

            @Override
            public final java.lang.Object getAuth() {
                return this.auth;
            }

            @Override
            public final java.lang.Object getRequestModel() {
                return this.requestModel;
            }

            @Override
            public final java.lang.Object getRequestParameters() {
                return this.requestParameters;
            }

            @Override
            public final java.lang.String getRestApiId() {
                return this.restApiId;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("method", om.valueToTree(this.getMethod()));
                data.set("path", om.valueToTree(this.getPath()));
                if (this.getAuth() != null) {
                    data.set("auth", om.valueToTree(this.getAuth()));
                }
                if (this.getRequestModel() != null) {
                    data.set("requestModel", om.valueToTree(this.getRequestModel()));
                }
                if (this.getRequestParameters() != null) {
                    data.set("requestParameters", om.valueToTree(this.getRequestParameters()));
                }
                if (this.getRestApiId() != null) {
                    data.set("restApiId", om.valueToTree(this.getRestApiId()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_sam.CfnFunction.ApiEventProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ApiEventProperty.Jsii$Proxy that = (ApiEventProperty.Jsii$Proxy) o;

                if (!method.equals(that.method)) return false;
                if (!path.equals(that.path)) return false;
                if (this.auth != null ? !this.auth.equals(that.auth) : that.auth != null) return false;
                if (this.requestModel != null ? !this.requestModel.equals(that.requestModel) : that.requestModel != null) return false;
                if (this.requestParameters != null ? !this.requestParameters.equals(that.requestParameters) : that.requestParameters != null) return false;
                return this.restApiId != null ? this.restApiId.equals(that.restApiId) : that.restApiId == null;
            }

            @Override
            public final int hashCode() {
                int result = this.method.hashCode();
                result = 31 * result + (this.path.hashCode());
                result = 31 * result + (this.auth != null ? this.auth.hashCode() : 0);
                result = 31 * result + (this.requestModel != null ? this.requestModel.hashCode() : 0);
                result = 31 * result + (this.requestParameters != null ? this.requestParameters.hashCode() : 0);
                result = 31 * result + (this.restApiId != null ? this.restApiId.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sam.*;
     * Object customStatements;
     * AuthProperty authProperty = AuthProperty.builder()
     *         .apiKeyRequired(false)
     *         .authorizationScopes(List.of("authorizationScopes"))
     *         .authorizer("authorizer")
     *         .resourcePolicy(AuthResourcePolicyProperty.builder()
     *                 .awsAccountBlacklist(List.of("awsAccountBlacklist"))
     *                 .awsAccountWhitelist(List.of("awsAccountWhitelist"))
     *                 .customStatements(List.of(customStatements))
     *                 .intrinsicVpcBlacklist(List.of("intrinsicVpcBlacklist"))
     *                 .intrinsicVpceBlacklist(List.of("intrinsicVpceBlacklist"))
     *                 .intrinsicVpceWhitelist(List.of("intrinsicVpceWhitelist"))
     *                 .intrinsicVpcWhitelist(List.of("intrinsicVpcWhitelist"))
     *                 .ipRangeBlacklist(List.of("ipRangeBlacklist"))
     *                 .ipRangeWhitelist(List.of("ipRangeWhitelist"))
     *                 .sourceVpcBlacklist(List.of("sourceVpcBlacklist"))
     *                 .sourceVpcWhitelist(List.of("sourceVpcWhitelist"))
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-auth.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-auth.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_sam.CfnFunction.AuthProperty")
    @software.amazon.jsii.Jsii.Proxy(AuthProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AuthProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-auth.html#cfn-serverless-function-auth-apikeyrequired">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-auth.html#cfn-serverless-function-auth-apikeyrequired</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getApiKeyRequired() {
            return null;
        }

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-auth.html#cfn-serverless-function-auth-authorizationscopes">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-auth.html#cfn-serverless-function-auth-authorizationscopes</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getAuthorizationScopes() {
            return null;
        }

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-auth.html#cfn-serverless-function-auth-authorizer">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-auth.html#cfn-serverless-function-auth-authorizer</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAuthorizer() {
            return null;
        }

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-auth.html#cfn-serverless-function-auth-resourcepolicy">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-auth.html#cfn-serverless-function-auth-resourcepolicy</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getResourcePolicy() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link AuthProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AuthProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AuthProperty> {
            java.lang.Object apiKeyRequired;
            java.util.List<java.lang.String> authorizationScopes;
            java.lang.String authorizer;
            java.lang.Object resourcePolicy;

            /**
             * Sets the value of {@link AuthProperty#getApiKeyRequired}
             * @param apiKeyRequired the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder apiKeyRequired(java.lang.Boolean apiKeyRequired) {
                this.apiKeyRequired = apiKeyRequired;
                return this;
            }

            /**
             * Sets the value of {@link AuthProperty#getApiKeyRequired}
             * @param apiKeyRequired the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder apiKeyRequired(software.amazon.awscdk.IResolvable apiKeyRequired) {
                this.apiKeyRequired = apiKeyRequired;
                return this;
            }

            /**
             * Sets the value of {@link AuthProperty#getAuthorizationScopes}
             * @param authorizationScopes the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder authorizationScopes(java.util.List<java.lang.String> authorizationScopes) {
                this.authorizationScopes = authorizationScopes;
                return this;
            }

            /**
             * Sets the value of {@link AuthProperty#getAuthorizer}
             * @param authorizer the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder authorizer(java.lang.String authorizer) {
                this.authorizer = authorizer;
                return this;
            }

            /**
             * Sets the value of {@link AuthProperty#getResourcePolicy}
             * @param resourcePolicy the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder resourcePolicy(software.amazon.awscdk.IResolvable resourcePolicy) {
                this.resourcePolicy = resourcePolicy;
                return this;
            }

            /**
             * Sets the value of {@link AuthProperty#getResourcePolicy}
             * @param resourcePolicy the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder resourcePolicy(software.amazon.awscdk.services.sam.CfnFunction.AuthResourcePolicyProperty resourcePolicy) {
                this.resourcePolicy = resourcePolicy;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AuthProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AuthProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AuthProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AuthProperty {
            private final java.lang.Object apiKeyRequired;
            private final java.util.List<java.lang.String> authorizationScopes;
            private final java.lang.String authorizer;
            private final java.lang.Object resourcePolicy;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.apiKeyRequired = software.amazon.jsii.Kernel.get(this, "apiKeyRequired", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.authorizationScopes = software.amazon.jsii.Kernel.get(this, "authorizationScopes", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.authorizer = software.amazon.jsii.Kernel.get(this, "authorizer", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.resourcePolicy = software.amazon.jsii.Kernel.get(this, "resourcePolicy", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.apiKeyRequired = builder.apiKeyRequired;
                this.authorizationScopes = builder.authorizationScopes;
                this.authorizer = builder.authorizer;
                this.resourcePolicy = builder.resourcePolicy;
            }

            @Override
            public final java.lang.Object getApiKeyRequired() {
                return this.apiKeyRequired;
            }

            @Override
            public final java.util.List<java.lang.String> getAuthorizationScopes() {
                return this.authorizationScopes;
            }

            @Override
            public final java.lang.String getAuthorizer() {
                return this.authorizer;
            }

            @Override
            public final java.lang.Object getResourcePolicy() {
                return this.resourcePolicy;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getApiKeyRequired() != null) {
                    data.set("apiKeyRequired", om.valueToTree(this.getApiKeyRequired()));
                }
                if (this.getAuthorizationScopes() != null) {
                    data.set("authorizationScopes", om.valueToTree(this.getAuthorizationScopes()));
                }
                if (this.getAuthorizer() != null) {
                    data.set("authorizer", om.valueToTree(this.getAuthorizer()));
                }
                if (this.getResourcePolicy() != null) {
                    data.set("resourcePolicy", om.valueToTree(this.getResourcePolicy()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_sam.CfnFunction.AuthProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AuthProperty.Jsii$Proxy that = (AuthProperty.Jsii$Proxy) o;

                if (this.apiKeyRequired != null ? !this.apiKeyRequired.equals(that.apiKeyRequired) : that.apiKeyRequired != null) return false;
                if (this.authorizationScopes != null ? !this.authorizationScopes.equals(that.authorizationScopes) : that.authorizationScopes != null) return false;
                if (this.authorizer != null ? !this.authorizer.equals(that.authorizer) : that.authorizer != null) return false;
                return this.resourcePolicy != null ? this.resourcePolicy.equals(that.resourcePolicy) : that.resourcePolicy == null;
            }

            @Override
            public final int hashCode() {
                int result = this.apiKeyRequired != null ? this.apiKeyRequired.hashCode() : 0;
                result = 31 * result + (this.authorizationScopes != null ? this.authorizationScopes.hashCode() : 0);
                result = 31 * result + (this.authorizer != null ? this.authorizer.hashCode() : 0);
                result = 31 * result + (this.resourcePolicy != null ? this.resourcePolicy.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sam.*;
     * Object customStatements;
     * AuthResourcePolicyProperty authResourcePolicyProperty = AuthResourcePolicyProperty.builder()
     *         .awsAccountBlacklist(List.of("awsAccountBlacklist"))
     *         .awsAccountWhitelist(List.of("awsAccountWhitelist"))
     *         .customStatements(List.of(customStatements))
     *         .intrinsicVpcBlacklist(List.of("intrinsicVpcBlacklist"))
     *         .intrinsicVpceBlacklist(List.of("intrinsicVpceBlacklist"))
     *         .intrinsicVpceWhitelist(List.of("intrinsicVpceWhitelist"))
     *         .intrinsicVpcWhitelist(List.of("intrinsicVpcWhitelist"))
     *         .ipRangeBlacklist(List.of("ipRangeBlacklist"))
     *         .ipRangeWhitelist(List.of("ipRangeWhitelist"))
     *         .sourceVpcBlacklist(List.of("sourceVpcBlacklist"))
     *         .sourceVpcWhitelist(List.of("sourceVpcWhitelist"))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-authresourcepolicy.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-authresourcepolicy.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_sam.CfnFunction.AuthResourcePolicyProperty")
    @software.amazon.jsii.Jsii.Proxy(AuthResourcePolicyProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AuthResourcePolicyProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-authresourcepolicy.html#cfn-serverless-function-authresourcepolicy-awsaccountblacklist">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-authresourcepolicy.html#cfn-serverless-function-authresourcepolicy-awsaccountblacklist</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getAwsAccountBlacklist() {
            return null;
        }

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-authresourcepolicy.html#cfn-serverless-function-authresourcepolicy-awsaccountwhitelist">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-authresourcepolicy.html#cfn-serverless-function-authresourcepolicy-awsaccountwhitelist</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getAwsAccountWhitelist() {
            return null;
        }

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-authresourcepolicy.html#cfn-serverless-function-authresourcepolicy-customstatements">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-authresourcepolicy.html#cfn-serverless-function-authresourcepolicy-customstatements</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCustomStatements() {
            return null;
        }

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-authresourcepolicy.html#cfn-serverless-function-authresourcepolicy-intrinsicvpcblacklist">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-authresourcepolicy.html#cfn-serverless-function-authresourcepolicy-intrinsicvpcblacklist</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getIntrinsicVpcBlacklist() {
            return null;
        }

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-authresourcepolicy.html#cfn-serverless-function-authresourcepolicy-intrinsicvpceblacklist">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-authresourcepolicy.html#cfn-serverless-function-authresourcepolicy-intrinsicvpceblacklist</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getIntrinsicVpceBlacklist() {
            return null;
        }

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-authresourcepolicy.html#cfn-serverless-function-authresourcepolicy-intrinsicvpcewhitelist">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-authresourcepolicy.html#cfn-serverless-function-authresourcepolicy-intrinsicvpcewhitelist</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getIntrinsicVpceWhitelist() {
            return null;
        }

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-authresourcepolicy.html#cfn-serverless-function-authresourcepolicy-intrinsicvpcwhitelist">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-authresourcepolicy.html#cfn-serverless-function-authresourcepolicy-intrinsicvpcwhitelist</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getIntrinsicVpcWhitelist() {
            return null;
        }

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-authresourcepolicy.html#cfn-serverless-function-authresourcepolicy-iprangeblacklist">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-authresourcepolicy.html#cfn-serverless-function-authresourcepolicy-iprangeblacklist</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getIpRangeBlacklist() {
            return null;
        }

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-authresourcepolicy.html#cfn-serverless-function-authresourcepolicy-iprangewhitelist">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-authresourcepolicy.html#cfn-serverless-function-authresourcepolicy-iprangewhitelist</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getIpRangeWhitelist() {
            return null;
        }

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-authresourcepolicy.html#cfn-serverless-function-authresourcepolicy-sourcevpcblacklist">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-authresourcepolicy.html#cfn-serverless-function-authresourcepolicy-sourcevpcblacklist</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getSourceVpcBlacklist() {
            return null;
        }

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-authresourcepolicy.html#cfn-serverless-function-authresourcepolicy-sourcevpcwhitelist">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-authresourcepolicy.html#cfn-serverless-function-authresourcepolicy-sourcevpcwhitelist</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getSourceVpcWhitelist() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link AuthResourcePolicyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AuthResourcePolicyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AuthResourcePolicyProperty> {
            java.util.List<java.lang.String> awsAccountBlacklist;
            java.util.List<java.lang.String> awsAccountWhitelist;
            java.lang.Object customStatements;
            java.util.List<java.lang.String> intrinsicVpcBlacklist;
            java.util.List<java.lang.String> intrinsicVpceBlacklist;
            java.util.List<java.lang.String> intrinsicVpceWhitelist;
            java.util.List<java.lang.String> intrinsicVpcWhitelist;
            java.util.List<java.lang.String> ipRangeBlacklist;
            java.util.List<java.lang.String> ipRangeWhitelist;
            java.util.List<java.lang.String> sourceVpcBlacklist;
            java.util.List<java.lang.String> sourceVpcWhitelist;

            /**
             * Sets the value of {@link AuthResourcePolicyProperty#getAwsAccountBlacklist}
             * @param awsAccountBlacklist the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder awsAccountBlacklist(java.util.List<java.lang.String> awsAccountBlacklist) {
                this.awsAccountBlacklist = awsAccountBlacklist;
                return this;
            }

            /**
             * Sets the value of {@link AuthResourcePolicyProperty#getAwsAccountWhitelist}
             * @param awsAccountWhitelist the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder awsAccountWhitelist(java.util.List<java.lang.String> awsAccountWhitelist) {
                this.awsAccountWhitelist = awsAccountWhitelist;
                return this;
            }

            /**
             * Sets the value of {@link AuthResourcePolicyProperty#getCustomStatements}
             * @param customStatements the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder customStatements(java.util.List<? extends java.lang.Object> customStatements) {
                this.customStatements = customStatements;
                return this;
            }

            /**
             * Sets the value of {@link AuthResourcePolicyProperty#getCustomStatements}
             * @param customStatements the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder customStatements(software.amazon.awscdk.IResolvable customStatements) {
                this.customStatements = customStatements;
                return this;
            }

            /**
             * Sets the value of {@link AuthResourcePolicyProperty#getIntrinsicVpcBlacklist}
             * @param intrinsicVpcBlacklist the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder intrinsicVpcBlacklist(java.util.List<java.lang.String> intrinsicVpcBlacklist) {
                this.intrinsicVpcBlacklist = intrinsicVpcBlacklist;
                return this;
            }

            /**
             * Sets the value of {@link AuthResourcePolicyProperty#getIntrinsicVpceBlacklist}
             * @param intrinsicVpceBlacklist the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder intrinsicVpceBlacklist(java.util.List<java.lang.String> intrinsicVpceBlacklist) {
                this.intrinsicVpceBlacklist = intrinsicVpceBlacklist;
                return this;
            }

            /**
             * Sets the value of {@link AuthResourcePolicyProperty#getIntrinsicVpceWhitelist}
             * @param intrinsicVpceWhitelist the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder intrinsicVpceWhitelist(java.util.List<java.lang.String> intrinsicVpceWhitelist) {
                this.intrinsicVpceWhitelist = intrinsicVpceWhitelist;
                return this;
            }

            /**
             * Sets the value of {@link AuthResourcePolicyProperty#getIntrinsicVpcWhitelist}
             * @param intrinsicVpcWhitelist the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder intrinsicVpcWhitelist(java.util.List<java.lang.String> intrinsicVpcWhitelist) {
                this.intrinsicVpcWhitelist = intrinsicVpcWhitelist;
                return this;
            }

            /**
             * Sets the value of {@link AuthResourcePolicyProperty#getIpRangeBlacklist}
             * @param ipRangeBlacklist the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ipRangeBlacklist(java.util.List<java.lang.String> ipRangeBlacklist) {
                this.ipRangeBlacklist = ipRangeBlacklist;
                return this;
            }

            /**
             * Sets the value of {@link AuthResourcePolicyProperty#getIpRangeWhitelist}
             * @param ipRangeWhitelist the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ipRangeWhitelist(java.util.List<java.lang.String> ipRangeWhitelist) {
                this.ipRangeWhitelist = ipRangeWhitelist;
                return this;
            }

            /**
             * Sets the value of {@link AuthResourcePolicyProperty#getSourceVpcBlacklist}
             * @param sourceVpcBlacklist the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sourceVpcBlacklist(java.util.List<java.lang.String> sourceVpcBlacklist) {
                this.sourceVpcBlacklist = sourceVpcBlacklist;
                return this;
            }

            /**
             * Sets the value of {@link AuthResourcePolicyProperty#getSourceVpcWhitelist}
             * @param sourceVpcWhitelist the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sourceVpcWhitelist(java.util.List<java.lang.String> sourceVpcWhitelist) {
                this.sourceVpcWhitelist = sourceVpcWhitelist;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AuthResourcePolicyProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AuthResourcePolicyProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AuthResourcePolicyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AuthResourcePolicyProperty {
            private final java.util.List<java.lang.String> awsAccountBlacklist;
            private final java.util.List<java.lang.String> awsAccountWhitelist;
            private final java.lang.Object customStatements;
            private final java.util.List<java.lang.String> intrinsicVpcBlacklist;
            private final java.util.List<java.lang.String> intrinsicVpceBlacklist;
            private final java.util.List<java.lang.String> intrinsicVpceWhitelist;
            private final java.util.List<java.lang.String> intrinsicVpcWhitelist;
            private final java.util.List<java.lang.String> ipRangeBlacklist;
            private final java.util.List<java.lang.String> ipRangeWhitelist;
            private final java.util.List<java.lang.String> sourceVpcBlacklist;
            private final java.util.List<java.lang.String> sourceVpcWhitelist;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.awsAccountBlacklist = software.amazon.jsii.Kernel.get(this, "awsAccountBlacklist", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.awsAccountWhitelist = software.amazon.jsii.Kernel.get(this, "awsAccountWhitelist", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.customStatements = software.amazon.jsii.Kernel.get(this, "customStatements", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.intrinsicVpcBlacklist = software.amazon.jsii.Kernel.get(this, "intrinsicVpcBlacklist", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.intrinsicVpceBlacklist = software.amazon.jsii.Kernel.get(this, "intrinsicVpceBlacklist", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.intrinsicVpceWhitelist = software.amazon.jsii.Kernel.get(this, "intrinsicVpceWhitelist", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.intrinsicVpcWhitelist = software.amazon.jsii.Kernel.get(this, "intrinsicVpcWhitelist", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.ipRangeBlacklist = software.amazon.jsii.Kernel.get(this, "ipRangeBlacklist", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.ipRangeWhitelist = software.amazon.jsii.Kernel.get(this, "ipRangeWhitelist", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.sourceVpcBlacklist = software.amazon.jsii.Kernel.get(this, "sourceVpcBlacklist", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.sourceVpcWhitelist = software.amazon.jsii.Kernel.get(this, "sourceVpcWhitelist", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.awsAccountBlacklist = builder.awsAccountBlacklist;
                this.awsAccountWhitelist = builder.awsAccountWhitelist;
                this.customStatements = builder.customStatements;
                this.intrinsicVpcBlacklist = builder.intrinsicVpcBlacklist;
                this.intrinsicVpceBlacklist = builder.intrinsicVpceBlacklist;
                this.intrinsicVpceWhitelist = builder.intrinsicVpceWhitelist;
                this.intrinsicVpcWhitelist = builder.intrinsicVpcWhitelist;
                this.ipRangeBlacklist = builder.ipRangeBlacklist;
                this.ipRangeWhitelist = builder.ipRangeWhitelist;
                this.sourceVpcBlacklist = builder.sourceVpcBlacklist;
                this.sourceVpcWhitelist = builder.sourceVpcWhitelist;
            }

            @Override
            public final java.util.List<java.lang.String> getAwsAccountBlacklist() {
                return this.awsAccountBlacklist;
            }

            @Override
            public final java.util.List<java.lang.String> getAwsAccountWhitelist() {
                return this.awsAccountWhitelist;
            }

            @Override
            public final java.lang.Object getCustomStatements() {
                return this.customStatements;
            }

            @Override
            public final java.util.List<java.lang.String> getIntrinsicVpcBlacklist() {
                return this.intrinsicVpcBlacklist;
            }

            @Override
            public final java.util.List<java.lang.String> getIntrinsicVpceBlacklist() {
                return this.intrinsicVpceBlacklist;
            }

            @Override
            public final java.util.List<java.lang.String> getIntrinsicVpceWhitelist() {
                return this.intrinsicVpceWhitelist;
            }

            @Override
            public final java.util.List<java.lang.String> getIntrinsicVpcWhitelist() {
                return this.intrinsicVpcWhitelist;
            }

            @Override
            public final java.util.List<java.lang.String> getIpRangeBlacklist() {
                return this.ipRangeBlacklist;
            }

            @Override
            public final java.util.List<java.lang.String> getIpRangeWhitelist() {
                return this.ipRangeWhitelist;
            }

            @Override
            public final java.util.List<java.lang.String> getSourceVpcBlacklist() {
                return this.sourceVpcBlacklist;
            }

            @Override
            public final java.util.List<java.lang.String> getSourceVpcWhitelist() {
                return this.sourceVpcWhitelist;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAwsAccountBlacklist() != null) {
                    data.set("awsAccountBlacklist", om.valueToTree(this.getAwsAccountBlacklist()));
                }
                if (this.getAwsAccountWhitelist() != null) {
                    data.set("awsAccountWhitelist", om.valueToTree(this.getAwsAccountWhitelist()));
                }
                if (this.getCustomStatements() != null) {
                    data.set("customStatements", om.valueToTree(this.getCustomStatements()));
                }
                if (this.getIntrinsicVpcBlacklist() != null) {
                    data.set("intrinsicVpcBlacklist", om.valueToTree(this.getIntrinsicVpcBlacklist()));
                }
                if (this.getIntrinsicVpceBlacklist() != null) {
                    data.set("intrinsicVpceBlacklist", om.valueToTree(this.getIntrinsicVpceBlacklist()));
                }
                if (this.getIntrinsicVpceWhitelist() != null) {
                    data.set("intrinsicVpceWhitelist", om.valueToTree(this.getIntrinsicVpceWhitelist()));
                }
                if (this.getIntrinsicVpcWhitelist() != null) {
                    data.set("intrinsicVpcWhitelist", om.valueToTree(this.getIntrinsicVpcWhitelist()));
                }
                if (this.getIpRangeBlacklist() != null) {
                    data.set("ipRangeBlacklist", om.valueToTree(this.getIpRangeBlacklist()));
                }
                if (this.getIpRangeWhitelist() != null) {
                    data.set("ipRangeWhitelist", om.valueToTree(this.getIpRangeWhitelist()));
                }
                if (this.getSourceVpcBlacklist() != null) {
                    data.set("sourceVpcBlacklist", om.valueToTree(this.getSourceVpcBlacklist()));
                }
                if (this.getSourceVpcWhitelist() != null) {
                    data.set("sourceVpcWhitelist", om.valueToTree(this.getSourceVpcWhitelist()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_sam.CfnFunction.AuthResourcePolicyProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AuthResourcePolicyProperty.Jsii$Proxy that = (AuthResourcePolicyProperty.Jsii$Proxy) o;

                if (this.awsAccountBlacklist != null ? !this.awsAccountBlacklist.equals(that.awsAccountBlacklist) : that.awsAccountBlacklist != null) return false;
                if (this.awsAccountWhitelist != null ? !this.awsAccountWhitelist.equals(that.awsAccountWhitelist) : that.awsAccountWhitelist != null) return false;
                if (this.customStatements != null ? !this.customStatements.equals(that.customStatements) : that.customStatements != null) return false;
                if (this.intrinsicVpcBlacklist != null ? !this.intrinsicVpcBlacklist.equals(that.intrinsicVpcBlacklist) : that.intrinsicVpcBlacklist != null) return false;
                if (this.intrinsicVpceBlacklist != null ? !this.intrinsicVpceBlacklist.equals(that.intrinsicVpceBlacklist) : that.intrinsicVpceBlacklist != null) return false;
                if (this.intrinsicVpceWhitelist != null ? !this.intrinsicVpceWhitelist.equals(that.intrinsicVpceWhitelist) : that.intrinsicVpceWhitelist != null) return false;
                if (this.intrinsicVpcWhitelist != null ? !this.intrinsicVpcWhitelist.equals(that.intrinsicVpcWhitelist) : that.intrinsicVpcWhitelist != null) return false;
                if (this.ipRangeBlacklist != null ? !this.ipRangeBlacklist.equals(that.ipRangeBlacklist) : that.ipRangeBlacklist != null) return false;
                if (this.ipRangeWhitelist != null ? !this.ipRangeWhitelist.equals(that.ipRangeWhitelist) : that.ipRangeWhitelist != null) return false;
                if (this.sourceVpcBlacklist != null ? !this.sourceVpcBlacklist.equals(that.sourceVpcBlacklist) : that.sourceVpcBlacklist != null) return false;
                return this.sourceVpcWhitelist != null ? this.sourceVpcWhitelist.equals(that.sourceVpcWhitelist) : that.sourceVpcWhitelist == null;
            }

            @Override
            public final int hashCode() {
                int result = this.awsAccountBlacklist != null ? this.awsAccountBlacklist.hashCode() : 0;
                result = 31 * result + (this.awsAccountWhitelist != null ? this.awsAccountWhitelist.hashCode() : 0);
                result = 31 * result + (this.customStatements != null ? this.customStatements.hashCode() : 0);
                result = 31 * result + (this.intrinsicVpcBlacklist != null ? this.intrinsicVpcBlacklist.hashCode() : 0);
                result = 31 * result + (this.intrinsicVpceBlacklist != null ? this.intrinsicVpceBlacklist.hashCode() : 0);
                result = 31 * result + (this.intrinsicVpceWhitelist != null ? this.intrinsicVpceWhitelist.hashCode() : 0);
                result = 31 * result + (this.intrinsicVpcWhitelist != null ? this.intrinsicVpcWhitelist.hashCode() : 0);
                result = 31 * result + (this.ipRangeBlacklist != null ? this.ipRangeBlacklist.hashCode() : 0);
                result = 31 * result + (this.ipRangeWhitelist != null ? this.ipRangeWhitelist.hashCode() : 0);
                result = 31 * result + (this.sourceVpcBlacklist != null ? this.sourceVpcBlacklist.hashCode() : 0);
                result = 31 * result + (this.sourceVpcWhitelist != null ? this.sourceVpcWhitelist.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sam.*;
     * BucketSAMPTProperty bucketSAMPTProperty = BucketSAMPTProperty.builder()
     *         .bucketName("bucketName")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-bucketsampt.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-bucketsampt.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_sam.CfnFunction.BucketSAMPTProperty")
    @software.amazon.jsii.Jsii.Proxy(BucketSAMPTProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface BucketSAMPTProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-bucketsampt.html#cfn-serverless-function-bucketsampt-bucketname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-bucketsampt.html#cfn-serverless-function-bucketsampt-bucketname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getBucketName();

        /**
         * @return a {@link Builder} of {@link BucketSAMPTProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link BucketSAMPTProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<BucketSAMPTProperty> {
            java.lang.String bucketName;

            /**
             * Sets the value of {@link BucketSAMPTProperty#getBucketName}
             * @param bucketName the value to be set. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder bucketName(java.lang.String bucketName) {
                this.bucketName = bucketName;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link BucketSAMPTProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public BucketSAMPTProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link BucketSAMPTProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements BucketSAMPTProperty {
            private final java.lang.String bucketName;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.bucketName = software.amazon.jsii.Kernel.get(this, "bucketName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.bucketName = java.util.Objects.requireNonNull(builder.bucketName, "bucketName is required");
            }

            @Override
            public final java.lang.String getBucketName() {
                return this.bucketName;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("bucketName", om.valueToTree(this.getBucketName()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_sam.CfnFunction.BucketSAMPTProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                BucketSAMPTProperty.Jsii$Proxy that = (BucketSAMPTProperty.Jsii$Proxy) o;

                return this.bucketName.equals(that.bucketName);
            }

            @Override
            public final int hashCode() {
                int result = this.bucketName.hashCode();
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sam.*;
     * Object pattern;
     * CloudWatchEventEventProperty cloudWatchEventEventProperty = CloudWatchEventEventProperty.builder()
     *         .pattern(pattern)
     *         // the properties below are optional
     *         .input("input")
     *         .inputPath("inputPath")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-cloudwatcheventevent.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-cloudwatcheventevent.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_sam.CfnFunction.CloudWatchEventEventProperty")
    @software.amazon.jsii.Jsii.Proxy(CloudWatchEventEventProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CloudWatchEventEventProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-cloudwatcheventevent.html#cfn-serverless-function-cloudwatcheventevent-pattern">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-cloudwatcheventevent.html#cfn-serverless-function-cloudwatcheventevent-pattern</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getPattern();

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-cloudwatcheventevent.html#cfn-serverless-function-cloudwatcheventevent-input">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-cloudwatcheventevent.html#cfn-serverless-function-cloudwatcheventevent-input</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getInput() {
            return null;
        }

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-cloudwatcheventevent.html#cfn-serverless-function-cloudwatcheventevent-inputpath">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-cloudwatcheventevent.html#cfn-serverless-function-cloudwatcheventevent-inputpath</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getInputPath() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link CloudWatchEventEventProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CloudWatchEventEventProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CloudWatchEventEventProperty> {
            java.lang.Object pattern;
            java.lang.String input;
            java.lang.String inputPath;

            /**
             * Sets the value of {@link CloudWatchEventEventProperty#getPattern}
             * @param pattern the value to be set. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder pattern(java.lang.Object pattern) {
                this.pattern = pattern;
                return this;
            }

            /**
             * Sets the value of {@link CloudWatchEventEventProperty#getInput}
             * @param input the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder input(java.lang.String input) {
                this.input = input;
                return this;
            }

            /**
             * Sets the value of {@link CloudWatchEventEventProperty#getInputPath}
             * @param inputPath the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder inputPath(java.lang.String inputPath) {
                this.inputPath = inputPath;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CloudWatchEventEventProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CloudWatchEventEventProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CloudWatchEventEventProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CloudWatchEventEventProperty {
            private final java.lang.Object pattern;
            private final java.lang.String input;
            private final java.lang.String inputPath;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.pattern = software.amazon.jsii.Kernel.get(this, "pattern", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.input = software.amazon.jsii.Kernel.get(this, "input", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.inputPath = software.amazon.jsii.Kernel.get(this, "inputPath", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.pattern = java.util.Objects.requireNonNull(builder.pattern, "pattern is required");
                this.input = builder.input;
                this.inputPath = builder.inputPath;
            }

            @Override
            public final java.lang.Object getPattern() {
                return this.pattern;
            }

            @Override
            public final java.lang.String getInput() {
                return this.input;
            }

            @Override
            public final java.lang.String getInputPath() {
                return this.inputPath;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("pattern", om.valueToTree(this.getPattern()));
                if (this.getInput() != null) {
                    data.set("input", om.valueToTree(this.getInput()));
                }
                if (this.getInputPath() != null) {
                    data.set("inputPath", om.valueToTree(this.getInputPath()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_sam.CfnFunction.CloudWatchEventEventProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CloudWatchEventEventProperty.Jsii$Proxy that = (CloudWatchEventEventProperty.Jsii$Proxy) o;

                if (!pattern.equals(that.pattern)) return false;
                if (this.input != null ? !this.input.equals(that.input) : that.input != null) return false;
                return this.inputPath != null ? this.inputPath.equals(that.inputPath) : that.inputPath == null;
            }

            @Override
            public final int hashCode() {
                int result = this.pattern.hashCode();
                result = 31 * result + (this.input != null ? this.input.hashCode() : 0);
                result = 31 * result + (this.inputPath != null ? this.inputPath.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sam.*;
     * CloudWatchLogsEventProperty cloudWatchLogsEventProperty = CloudWatchLogsEventProperty.builder()
     *         .filterPattern("filterPattern")
     *         .logGroupName("logGroupName")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-cloudwatchlogsevent.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-cloudwatchlogsevent.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_sam.CfnFunction.CloudWatchLogsEventProperty")
    @software.amazon.jsii.Jsii.Proxy(CloudWatchLogsEventProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CloudWatchLogsEventProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-cloudwatchlogsevent.html#cfn-serverless-function-cloudwatchlogsevent-filterpattern">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-cloudwatchlogsevent.html#cfn-serverless-function-cloudwatchlogsevent-filterpattern</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getFilterPattern();

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-cloudwatchlogsevent.html#cfn-serverless-function-cloudwatchlogsevent-loggroupname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-cloudwatchlogsevent.html#cfn-serverless-function-cloudwatchlogsevent-loggroupname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getLogGroupName();

        /**
         * @return a {@link Builder} of {@link CloudWatchLogsEventProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CloudWatchLogsEventProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CloudWatchLogsEventProperty> {
            java.lang.String filterPattern;
            java.lang.String logGroupName;

            /**
             * Sets the value of {@link CloudWatchLogsEventProperty#getFilterPattern}
             * @param filterPattern the value to be set. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder filterPattern(java.lang.String filterPattern) {
                this.filterPattern = filterPattern;
                return this;
            }

            /**
             * Sets the value of {@link CloudWatchLogsEventProperty#getLogGroupName}
             * @param logGroupName the value to be set. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder logGroupName(java.lang.String logGroupName) {
                this.logGroupName = logGroupName;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CloudWatchLogsEventProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CloudWatchLogsEventProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CloudWatchLogsEventProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CloudWatchLogsEventProperty {
            private final java.lang.String filterPattern;
            private final java.lang.String logGroupName;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.filterPattern = software.amazon.jsii.Kernel.get(this, "filterPattern", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.logGroupName = software.amazon.jsii.Kernel.get(this, "logGroupName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.filterPattern = java.util.Objects.requireNonNull(builder.filterPattern, "filterPattern is required");
                this.logGroupName = java.util.Objects.requireNonNull(builder.logGroupName, "logGroupName is required");
            }

            @Override
            public final java.lang.String getFilterPattern() {
                return this.filterPattern;
            }

            @Override
            public final java.lang.String getLogGroupName() {
                return this.logGroupName;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("filterPattern", om.valueToTree(this.getFilterPattern()));
                data.set("logGroupName", om.valueToTree(this.getLogGroupName()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_sam.CfnFunction.CloudWatchLogsEventProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CloudWatchLogsEventProperty.Jsii$Proxy that = (CloudWatchLogsEventProperty.Jsii$Proxy) o;

                if (!filterPattern.equals(that.filterPattern)) return false;
                return this.logGroupName.equals(that.logGroupName);
            }

            @Override
            public final int hashCode() {
                int result = this.filterPattern.hashCode();
                result = 31 * result + (this.logGroupName.hashCode());
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sam.*;
     * CognitoEventProperty cognitoEventProperty = CognitoEventProperty.builder()
     *         .trigger("trigger")
     *         .userPool("userPool")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-cognitoevent.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-cognitoevent.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_sam.CfnFunction.CognitoEventProperty")
    @software.amazon.jsii.Jsii.Proxy(CognitoEventProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CognitoEventProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-cognitoevent.html#cfn-serverless-function-cognitoevent-trigger">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-cognitoevent.html#cfn-serverless-function-cognitoevent-trigger</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getTrigger();

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-cognitoevent.html#cfn-serverless-function-cognitoevent-userpool">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-cognitoevent.html#cfn-serverless-function-cognitoevent-userpool</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getUserPool();

        /**
         * @return a {@link Builder} of {@link CognitoEventProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CognitoEventProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CognitoEventProperty> {
            java.lang.String trigger;
            java.lang.String userPool;

            /**
             * Sets the value of {@link CognitoEventProperty#getTrigger}
             * @param trigger the value to be set. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder trigger(java.lang.String trigger) {
                this.trigger = trigger;
                return this;
            }

            /**
             * Sets the value of {@link CognitoEventProperty#getUserPool}
             * @param userPool the value to be set. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder userPool(java.lang.String userPool) {
                this.userPool = userPool;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CognitoEventProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CognitoEventProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CognitoEventProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CognitoEventProperty {
            private final java.lang.String trigger;
            private final java.lang.String userPool;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.trigger = software.amazon.jsii.Kernel.get(this, "trigger", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.userPool = software.amazon.jsii.Kernel.get(this, "userPool", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.trigger = java.util.Objects.requireNonNull(builder.trigger, "trigger is required");
                this.userPool = java.util.Objects.requireNonNull(builder.userPool, "userPool is required");
            }

            @Override
            public final java.lang.String getTrigger() {
                return this.trigger;
            }

            @Override
            public final java.lang.String getUserPool() {
                return this.userPool;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("trigger", om.valueToTree(this.getTrigger()));
                data.set("userPool", om.valueToTree(this.getUserPool()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_sam.CfnFunction.CognitoEventProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CognitoEventProperty.Jsii$Proxy that = (CognitoEventProperty.Jsii$Proxy) o;

                if (!trigger.equals(that.trigger)) return false;
                return this.userPool.equals(that.userPool);
            }

            @Override
            public final int hashCode() {
                int result = this.trigger.hashCode();
                result = 31 * result + (this.userPool.hashCode());
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sam.*;
     * CollectionSAMPTProperty collectionSAMPTProperty = CollectionSAMPTProperty.builder()
     *         .collectionId("collectionId")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-collectionsampt.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-collectionsampt.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_sam.CfnFunction.CollectionSAMPTProperty")
    @software.amazon.jsii.Jsii.Proxy(CollectionSAMPTProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CollectionSAMPTProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-collectionsampt.html#cfn-serverless-function-collectionsampt-collectionid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-collectionsampt.html#cfn-serverless-function-collectionsampt-collectionid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getCollectionId();

        /**
         * @return a {@link Builder} of {@link CollectionSAMPTProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CollectionSAMPTProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CollectionSAMPTProperty> {
            java.lang.String collectionId;

            /**
             * Sets the value of {@link CollectionSAMPTProperty#getCollectionId}
             * @param collectionId the value to be set. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder collectionId(java.lang.String collectionId) {
                this.collectionId = collectionId;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CollectionSAMPTProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CollectionSAMPTProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CollectionSAMPTProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CollectionSAMPTProperty {
            private final java.lang.String collectionId;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.collectionId = software.amazon.jsii.Kernel.get(this, "collectionId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.collectionId = java.util.Objects.requireNonNull(builder.collectionId, "collectionId is required");
            }

            @Override
            public final java.lang.String getCollectionId() {
                return this.collectionId;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("collectionId", om.valueToTree(this.getCollectionId()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_sam.CfnFunction.CollectionSAMPTProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CollectionSAMPTProperty.Jsii$Proxy that = (CollectionSAMPTProperty.Jsii$Proxy) o;

                return this.collectionId.equals(that.collectionId);
            }

            @Override
            public final int hashCode() {
                int result = this.collectionId.hashCode();
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sam.*;
     * CorsConfigurationProperty corsConfigurationProperty = CorsConfigurationProperty.builder()
     *         .allowOrigin("allowOrigin")
     *         // the properties below are optional
     *         .allowCredentials(false)
     *         .allowHeaders("allowHeaders")
     *         .allowMethods("allowMethods")
     *         .maxAge("maxAge")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-corsconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-corsconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_sam.CfnFunction.CorsConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(CorsConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CorsConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-corsconfiguration.html#cfn-serverless-function-corsconfiguration-alloworigin">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-corsconfiguration.html#cfn-serverless-function-corsconfiguration-alloworigin</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getAllowOrigin();

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-corsconfiguration.html#cfn-serverless-function-corsconfiguration-allowcredentials">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-corsconfiguration.html#cfn-serverless-function-corsconfiguration-allowcredentials</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAllowCredentials() {
            return null;
        }

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-corsconfiguration.html#cfn-serverless-function-corsconfiguration-allowheaders">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-corsconfiguration.html#cfn-serverless-function-corsconfiguration-allowheaders</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAllowHeaders() {
            return null;
        }

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-corsconfiguration.html#cfn-serverless-function-corsconfiguration-allowmethods">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-corsconfiguration.html#cfn-serverless-function-corsconfiguration-allowmethods</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAllowMethods() {
            return null;
        }

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-corsconfiguration.html#cfn-serverless-function-corsconfiguration-maxage">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-corsconfiguration.html#cfn-serverless-function-corsconfiguration-maxage</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getMaxAge() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link CorsConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CorsConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CorsConfigurationProperty> {
            java.lang.String allowOrigin;
            java.lang.Object allowCredentials;
            java.lang.String allowHeaders;
            java.lang.String allowMethods;
            java.lang.String maxAge;

            /**
             * Sets the value of {@link CorsConfigurationProperty#getAllowOrigin}
             * @param allowOrigin the value to be set. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder allowOrigin(java.lang.String allowOrigin) {
                this.allowOrigin = allowOrigin;
                return this;
            }

            /**
             * Sets the value of {@link CorsConfigurationProperty#getAllowCredentials}
             * @param allowCredentials the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder allowCredentials(java.lang.Boolean allowCredentials) {
                this.allowCredentials = allowCredentials;
                return this;
            }

            /**
             * Sets the value of {@link CorsConfigurationProperty#getAllowCredentials}
             * @param allowCredentials the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder allowCredentials(software.amazon.awscdk.IResolvable allowCredentials) {
                this.allowCredentials = allowCredentials;
                return this;
            }

            /**
             * Sets the value of {@link CorsConfigurationProperty#getAllowHeaders}
             * @param allowHeaders the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder allowHeaders(java.lang.String allowHeaders) {
                this.allowHeaders = allowHeaders;
                return this;
            }

            /**
             * Sets the value of {@link CorsConfigurationProperty#getAllowMethods}
             * @param allowMethods the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder allowMethods(java.lang.String allowMethods) {
                this.allowMethods = allowMethods;
                return this;
            }

            /**
             * Sets the value of {@link CorsConfigurationProperty#getMaxAge}
             * @param maxAge the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder maxAge(java.lang.String maxAge) {
                this.maxAge = maxAge;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CorsConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CorsConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CorsConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CorsConfigurationProperty {
            private final java.lang.String allowOrigin;
            private final java.lang.Object allowCredentials;
            private final java.lang.String allowHeaders;
            private final java.lang.String allowMethods;
            private final java.lang.String maxAge;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.allowOrigin = software.amazon.jsii.Kernel.get(this, "allowOrigin", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.allowCredentials = software.amazon.jsii.Kernel.get(this, "allowCredentials", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.allowHeaders = software.amazon.jsii.Kernel.get(this, "allowHeaders", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.allowMethods = software.amazon.jsii.Kernel.get(this, "allowMethods", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.maxAge = software.amazon.jsii.Kernel.get(this, "maxAge", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.allowOrigin = java.util.Objects.requireNonNull(builder.allowOrigin, "allowOrigin is required");
                this.allowCredentials = builder.allowCredentials;
                this.allowHeaders = builder.allowHeaders;
                this.allowMethods = builder.allowMethods;
                this.maxAge = builder.maxAge;
            }

            @Override
            public final java.lang.String getAllowOrigin() {
                return this.allowOrigin;
            }

            @Override
            public final java.lang.Object getAllowCredentials() {
                return this.allowCredentials;
            }

            @Override
            public final java.lang.String getAllowHeaders() {
                return this.allowHeaders;
            }

            @Override
            public final java.lang.String getAllowMethods() {
                return this.allowMethods;
            }

            @Override
            public final java.lang.String getMaxAge() {
                return this.maxAge;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("allowOrigin", om.valueToTree(this.getAllowOrigin()));
                if (this.getAllowCredentials() != null) {
                    data.set("allowCredentials", om.valueToTree(this.getAllowCredentials()));
                }
                if (this.getAllowHeaders() != null) {
                    data.set("allowHeaders", om.valueToTree(this.getAllowHeaders()));
                }
                if (this.getAllowMethods() != null) {
                    data.set("allowMethods", om.valueToTree(this.getAllowMethods()));
                }
                if (this.getMaxAge() != null) {
                    data.set("maxAge", om.valueToTree(this.getMaxAge()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_sam.CfnFunction.CorsConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CorsConfigurationProperty.Jsii$Proxy that = (CorsConfigurationProperty.Jsii$Proxy) o;

                if (!allowOrigin.equals(that.allowOrigin)) return false;
                if (this.allowCredentials != null ? !this.allowCredentials.equals(that.allowCredentials) : that.allowCredentials != null) return false;
                if (this.allowHeaders != null ? !this.allowHeaders.equals(that.allowHeaders) : that.allowHeaders != null) return false;
                if (this.allowMethods != null ? !this.allowMethods.equals(that.allowMethods) : that.allowMethods != null) return false;
                return this.maxAge != null ? this.maxAge.equals(that.maxAge) : that.maxAge == null;
            }

            @Override
            public final int hashCode() {
                int result = this.allowOrigin.hashCode();
                result = 31 * result + (this.allowCredentials != null ? this.allowCredentials.hashCode() : 0);
                result = 31 * result + (this.allowHeaders != null ? this.allowHeaders.hashCode() : 0);
                result = 31 * result + (this.allowMethods != null ? this.allowMethods.hashCode() : 0);
                result = 31 * result + (this.maxAge != null ? this.maxAge.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sam.*;
     * DeadLetterQueueProperty deadLetterQueueProperty = DeadLetterQueueProperty.builder()
     *         .targetArn("targetArn")
     *         .type("type")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-deadletterqueue.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-deadletterqueue.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_sam.CfnFunction.DeadLetterQueueProperty")
    @software.amazon.jsii.Jsii.Proxy(DeadLetterQueueProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DeadLetterQueueProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-deadletterqueue.html#cfn-serverless-function-deadletterqueue-targetarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-deadletterqueue.html#cfn-serverless-function-deadletterqueue-targetarn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getTargetArn();

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-deadletterqueue.html#cfn-serverless-function-deadletterqueue-type">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-deadletterqueue.html#cfn-serverless-function-deadletterqueue-type</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getType();

        /**
         * @return a {@link Builder} of {@link DeadLetterQueueProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DeadLetterQueueProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DeadLetterQueueProperty> {
            java.lang.String targetArn;
            java.lang.String type;

            /**
             * Sets the value of {@link DeadLetterQueueProperty#getTargetArn}
             * @param targetArn the value to be set. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder targetArn(java.lang.String targetArn) {
                this.targetArn = targetArn;
                return this;
            }

            /**
             * Sets the value of {@link DeadLetterQueueProperty#getType}
             * @param type the value to be set. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder type(java.lang.String type) {
                this.type = type;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DeadLetterQueueProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DeadLetterQueueProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DeadLetterQueueProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DeadLetterQueueProperty {
            private final java.lang.String targetArn;
            private final java.lang.String type;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.targetArn = software.amazon.jsii.Kernel.get(this, "targetArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.type = software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.targetArn = java.util.Objects.requireNonNull(builder.targetArn, "targetArn is required");
                this.type = java.util.Objects.requireNonNull(builder.type, "type is required");
            }

            @Override
            public final java.lang.String getTargetArn() {
                return this.targetArn;
            }

            @Override
            public final java.lang.String getType() {
                return this.type;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("targetArn", om.valueToTree(this.getTargetArn()));
                data.set("type", om.valueToTree(this.getType()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_sam.CfnFunction.DeadLetterQueueProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DeadLetterQueueProperty.Jsii$Proxy that = (DeadLetterQueueProperty.Jsii$Proxy) o;

                if (!targetArn.equals(that.targetArn)) return false;
                return this.type.equals(that.type);
            }

            @Override
            public final int hashCode() {
                int result = this.targetArn.hashCode();
                result = 31 * result + (this.type.hashCode());
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sam.*;
     * DeploymentPreferenceProperty deploymentPreferenceProperty = DeploymentPreferenceProperty.builder()
     *         .alarms(List.of("alarms"))
     *         .enabled(false)
     *         .hooks(HooksProperty.builder()
     *                 .postTraffic("postTraffic")
     *                 .preTraffic("preTraffic")
     *                 .build())
     *         .role("role")
     *         .type("type")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-deploymentpreference.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-deploymentpreference.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_sam.CfnFunction.DeploymentPreferenceProperty")
    @software.amazon.jsii.Jsii.Proxy(DeploymentPreferenceProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DeploymentPreferenceProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-deploymentpreference.html#cfn-serverless-function-deploymentpreference-alarms">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-deploymentpreference.html#cfn-serverless-function-deploymentpreference-alarms</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getAlarms() {
            return null;
        }

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-deploymentpreference.html#cfn-serverless-function-deploymentpreference-enabled">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-deploymentpreference.html#cfn-serverless-function-deploymentpreference-enabled</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEnabled() {
            return null;
        }

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-deploymentpreference.html#cfn-serverless-function-deploymentpreference-hooks">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-deploymentpreference.html#cfn-serverless-function-deploymentpreference-hooks</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getHooks() {
            return null;
        }

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-deploymentpreference.html#cfn-serverless-function-deploymentpreference-role">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-deploymentpreference.html#cfn-serverless-function-deploymentpreference-role</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getRole() {
            return null;
        }

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-deploymentpreference.html#cfn-serverless-function-deploymentpreference-type">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-deploymentpreference.html#cfn-serverless-function-deploymentpreference-type</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getType() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link DeploymentPreferenceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DeploymentPreferenceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DeploymentPreferenceProperty> {
            java.util.List<java.lang.String> alarms;
            java.lang.Object enabled;
            java.lang.Object hooks;
            java.lang.String role;
            java.lang.String type;

            /**
             * Sets the value of {@link DeploymentPreferenceProperty#getAlarms}
             * @param alarms the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder alarms(java.util.List<java.lang.String> alarms) {
                this.alarms = alarms;
                return this;
            }

            /**
             * Sets the value of {@link DeploymentPreferenceProperty#getEnabled}
             * @param enabled the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enabled(java.lang.Boolean enabled) {
                this.enabled = enabled;
                return this;
            }

            /**
             * Sets the value of {@link DeploymentPreferenceProperty#getEnabled}
             * @param enabled the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enabled(software.amazon.awscdk.IResolvable enabled) {
                this.enabled = enabled;
                return this;
            }

            /**
             * Sets the value of {@link DeploymentPreferenceProperty#getHooks}
             * @param hooks the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder hooks(software.amazon.awscdk.IResolvable hooks) {
                this.hooks = hooks;
                return this;
            }

            /**
             * Sets the value of {@link DeploymentPreferenceProperty#getHooks}
             * @param hooks the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder hooks(software.amazon.awscdk.services.sam.CfnFunction.HooksProperty hooks) {
                this.hooks = hooks;
                return this;
            }

            /**
             * Sets the value of {@link DeploymentPreferenceProperty#getRole}
             * @param role the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder role(java.lang.String role) {
                this.role = role;
                return this;
            }

            /**
             * Sets the value of {@link DeploymentPreferenceProperty#getType}
             * @param type the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder type(java.lang.String type) {
                this.type = type;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DeploymentPreferenceProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DeploymentPreferenceProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DeploymentPreferenceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DeploymentPreferenceProperty {
            private final java.util.List<java.lang.String> alarms;
            private final java.lang.Object enabled;
            private final java.lang.Object hooks;
            private final java.lang.String role;
            private final java.lang.String type;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.alarms = software.amazon.jsii.Kernel.get(this, "alarms", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.enabled = software.amazon.jsii.Kernel.get(this, "enabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.hooks = software.amazon.jsii.Kernel.get(this, "hooks", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.role = software.amazon.jsii.Kernel.get(this, "role", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.type = software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.alarms = builder.alarms;
                this.enabled = builder.enabled;
                this.hooks = builder.hooks;
                this.role = builder.role;
                this.type = builder.type;
            }

            @Override
            public final java.util.List<java.lang.String> getAlarms() {
                return this.alarms;
            }

            @Override
            public final java.lang.Object getEnabled() {
                return this.enabled;
            }

            @Override
            public final java.lang.Object getHooks() {
                return this.hooks;
            }

            @Override
            public final java.lang.String getRole() {
                return this.role;
            }

            @Override
            public final java.lang.String getType() {
                return this.type;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAlarms() != null) {
                    data.set("alarms", om.valueToTree(this.getAlarms()));
                }
                if (this.getEnabled() != null) {
                    data.set("enabled", om.valueToTree(this.getEnabled()));
                }
                if (this.getHooks() != null) {
                    data.set("hooks", om.valueToTree(this.getHooks()));
                }
                if (this.getRole() != null) {
                    data.set("role", om.valueToTree(this.getRole()));
                }
                if (this.getType() != null) {
                    data.set("type", om.valueToTree(this.getType()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_sam.CfnFunction.DeploymentPreferenceProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DeploymentPreferenceProperty.Jsii$Proxy that = (DeploymentPreferenceProperty.Jsii$Proxy) o;

                if (this.alarms != null ? !this.alarms.equals(that.alarms) : that.alarms != null) return false;
                if (this.enabled != null ? !this.enabled.equals(that.enabled) : that.enabled != null) return false;
                if (this.hooks != null ? !this.hooks.equals(that.hooks) : that.hooks != null) return false;
                if (this.role != null ? !this.role.equals(that.role) : that.role != null) return false;
                return this.type != null ? this.type.equals(that.type) : that.type == null;
            }

            @Override
            public final int hashCode() {
                int result = this.alarms != null ? this.alarms.hashCode() : 0;
                result = 31 * result + (this.enabled != null ? this.enabled.hashCode() : 0);
                result = 31 * result + (this.hooks != null ? this.hooks.hashCode() : 0);
                result = 31 * result + (this.role != null ? this.role.hashCode() : 0);
                result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sam.*;
     * DestinationConfigProperty destinationConfigProperty = DestinationConfigProperty.builder()
     *         .onFailure(DestinationProperty.builder()
     *                 .destination("destination")
     *                 // the properties below are optional
     *                 .type("type")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-destinationconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-destinationconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_sam.CfnFunction.DestinationConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(DestinationConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DestinationConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-destinationconfig.html#cfn-serverless-function-destinationconfig-onfailure">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-destinationconfig.html#cfn-serverless-function-destinationconfig-onfailure</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getOnFailure();

        /**
         * @return a {@link Builder} of {@link DestinationConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DestinationConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DestinationConfigProperty> {
            java.lang.Object onFailure;

            /**
             * Sets the value of {@link DestinationConfigProperty#getOnFailure}
             * @param onFailure the value to be set. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder onFailure(software.amazon.awscdk.IResolvable onFailure) {
                this.onFailure = onFailure;
                return this;
            }

            /**
             * Sets the value of {@link DestinationConfigProperty#getOnFailure}
             * @param onFailure the value to be set. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder onFailure(software.amazon.awscdk.services.sam.CfnFunction.DestinationProperty onFailure) {
                this.onFailure = onFailure;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DestinationConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DestinationConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DestinationConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DestinationConfigProperty {
            private final java.lang.Object onFailure;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.onFailure = software.amazon.jsii.Kernel.get(this, "onFailure", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.onFailure = java.util.Objects.requireNonNull(builder.onFailure, "onFailure is required");
            }

            @Override
            public final java.lang.Object getOnFailure() {
                return this.onFailure;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("onFailure", om.valueToTree(this.getOnFailure()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_sam.CfnFunction.DestinationConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DestinationConfigProperty.Jsii$Proxy that = (DestinationConfigProperty.Jsii$Proxy) o;

                return this.onFailure.equals(that.onFailure);
            }

            @Override
            public final int hashCode() {
                int result = this.onFailure.hashCode();
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sam.*;
     * DestinationProperty destinationProperty = DestinationProperty.builder()
     *         .destination("destination")
     *         // the properties below are optional
     *         .type("type")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-destination.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-destination.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_sam.CfnFunction.DestinationProperty")
    @software.amazon.jsii.Jsii.Proxy(DestinationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DestinationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-destination.html#cfn-serverless-function-destination-destination">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-destination.html#cfn-serverless-function-destination-destination</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getDestination();

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-destination.html#cfn-serverless-function-destination-type">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-destination.html#cfn-serverless-function-destination-type</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getType() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link DestinationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DestinationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DestinationProperty> {
            java.lang.String destination;
            java.lang.String type;

            /**
             * Sets the value of {@link DestinationProperty#getDestination}
             * @param destination the value to be set. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder destination(java.lang.String destination) {
                this.destination = destination;
                return this;
            }

            /**
             * Sets the value of {@link DestinationProperty#getType}
             * @param type the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder type(java.lang.String type) {
                this.type = type;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DestinationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DestinationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DestinationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DestinationProperty {
            private final java.lang.String destination;
            private final java.lang.String type;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.destination = software.amazon.jsii.Kernel.get(this, "destination", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.type = software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.destination = java.util.Objects.requireNonNull(builder.destination, "destination is required");
                this.type = builder.type;
            }

            @Override
            public final java.lang.String getDestination() {
                return this.destination;
            }

            @Override
            public final java.lang.String getType() {
                return this.type;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("destination", om.valueToTree(this.getDestination()));
                if (this.getType() != null) {
                    data.set("type", om.valueToTree(this.getType()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_sam.CfnFunction.DestinationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DestinationProperty.Jsii$Proxy that = (DestinationProperty.Jsii$Proxy) o;

                if (!destination.equals(that.destination)) return false;
                return this.type != null ? this.type.equals(that.type) : that.type == null;
            }

            @Override
            public final int hashCode() {
                int result = this.destination.hashCode();
                result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sam.*;
     * DomainSAMPTProperty domainSAMPTProperty = DomainSAMPTProperty.builder()
     *         .domainName("domainName")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-domainsampt.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-domainsampt.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_sam.CfnFunction.DomainSAMPTProperty")
    @software.amazon.jsii.Jsii.Proxy(DomainSAMPTProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DomainSAMPTProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-domainsampt.html#cfn-serverless-function-domainsampt-domainname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-domainsampt.html#cfn-serverless-function-domainsampt-domainname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getDomainName();

        /**
         * @return a {@link Builder} of {@link DomainSAMPTProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DomainSAMPTProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DomainSAMPTProperty> {
            java.lang.String domainName;

            /**
             * Sets the value of {@link DomainSAMPTProperty#getDomainName}
             * @param domainName the value to be set. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder domainName(java.lang.String domainName) {
                this.domainName = domainName;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DomainSAMPTProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DomainSAMPTProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DomainSAMPTProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DomainSAMPTProperty {
            private final java.lang.String domainName;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.domainName = software.amazon.jsii.Kernel.get(this, "domainName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.domainName = java.util.Objects.requireNonNull(builder.domainName, "domainName is required");
            }

            @Override
            public final java.lang.String getDomainName() {
                return this.domainName;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("domainName", om.valueToTree(this.getDomainName()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_sam.CfnFunction.DomainSAMPTProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DomainSAMPTProperty.Jsii$Proxy that = (DomainSAMPTProperty.Jsii$Proxy) o;

                return this.domainName.equals(that.domainName);
            }

            @Override
            public final int hashCode() {
                int result = this.domainName.hashCode();
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sam.*;
     * DynamoDBEventProperty dynamoDBEventProperty = DynamoDBEventProperty.builder()
     *         .startingPosition("startingPosition")
     *         .stream("stream")
     *         // the properties below are optional
     *         .batchSize(123)
     *         .bisectBatchOnFunctionError(false)
     *         .destinationConfig(DestinationConfigProperty.builder()
     *                 .onFailure(DestinationProperty.builder()
     *                         .destination("destination")
     *                         // the properties below are optional
     *                         .type("type")
     *                         .build())
     *                 .build())
     *         .enabled(false)
     *         .maximumBatchingWindowInSeconds(123)
     *         .maximumRecordAgeInSeconds(123)
     *         .maximumRetryAttempts(123)
     *         .parallelizationFactor(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-dynamodbevent.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-dynamodbevent.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_sam.CfnFunction.DynamoDBEventProperty")
    @software.amazon.jsii.Jsii.Proxy(DynamoDBEventProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DynamoDBEventProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-dynamodbevent.html#cfn-serverless-function-dynamodbevent-startingposition">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-dynamodbevent.html#cfn-serverless-function-dynamodbevent-startingposition</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getStartingPosition();

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-dynamodbevent.html#cfn-serverless-function-dynamodbevent-stream">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-dynamodbevent.html#cfn-serverless-function-dynamodbevent-stream</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getStream();

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-dynamodbevent.html#cfn-serverless-function-dynamodbevent-batchsize">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-dynamodbevent.html#cfn-serverless-function-dynamodbevent-batchsize</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getBatchSize() {
            return null;
        }

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-dynamodbevent.html#cfn-serverless-function-dynamodbevent-bisectbatchonfunctionerror">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-dynamodbevent.html#cfn-serverless-function-dynamodbevent-bisectbatchonfunctionerror</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getBisectBatchOnFunctionError() {
            return null;
        }

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-dynamodbevent.html#cfn-serverless-function-dynamodbevent-destinationconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-dynamodbevent.html#cfn-serverless-function-dynamodbevent-destinationconfig</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDestinationConfig() {
            return null;
        }

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-dynamodbevent.html#cfn-serverless-function-dynamodbevent-enabled">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-dynamodbevent.html#cfn-serverless-function-dynamodbevent-enabled</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEnabled() {
            return null;
        }

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-dynamodbevent.html#cfn-serverless-function-dynamodbevent-maximumbatchingwindowinseconds">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-dynamodbevent.html#cfn-serverless-function-dynamodbevent-maximumbatchingwindowinseconds</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMaximumBatchingWindowInSeconds() {
            return null;
        }

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-dynamodbevent.html#cfn-serverless-function-dynamodbevent-maximumrecordageinseconds">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-dynamodbevent.html#cfn-serverless-function-dynamodbevent-maximumrecordageinseconds</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMaximumRecordAgeInSeconds() {
            return null;
        }

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-dynamodbevent.html#cfn-serverless-function-dynamodbevent-maximumretryattempts">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-dynamodbevent.html#cfn-serverless-function-dynamodbevent-maximumretryattempts</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMaximumRetryAttempts() {
            return null;
        }

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-dynamodbevent.html#cfn-serverless-function-dynamodbevent-parallelizationfactor">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-dynamodbevent.html#cfn-serverless-function-dynamodbevent-parallelizationfactor</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getParallelizationFactor() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link DynamoDBEventProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DynamoDBEventProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DynamoDBEventProperty> {
            java.lang.String startingPosition;
            java.lang.String stream;
            java.lang.Number batchSize;
            java.lang.Object bisectBatchOnFunctionError;
            java.lang.Object destinationConfig;
            java.lang.Object enabled;
            java.lang.Number maximumBatchingWindowInSeconds;
            java.lang.Number maximumRecordAgeInSeconds;
            java.lang.Number maximumRetryAttempts;
            java.lang.Number parallelizationFactor;

            /**
             * Sets the value of {@link DynamoDBEventProperty#getStartingPosition}
             * @param startingPosition the value to be set. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder startingPosition(java.lang.String startingPosition) {
                this.startingPosition = startingPosition;
                return this;
            }

            /**
             * Sets the value of {@link DynamoDBEventProperty#getStream}
             * @param stream the value to be set. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder stream(java.lang.String stream) {
                this.stream = stream;
                return this;
            }

            /**
             * Sets the value of {@link DynamoDBEventProperty#getBatchSize}
             * @param batchSize the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder batchSize(java.lang.Number batchSize) {
                this.batchSize = batchSize;
                return this;
            }

            /**
             * Sets the value of {@link DynamoDBEventProperty#getBisectBatchOnFunctionError}
             * @param bisectBatchOnFunctionError the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder bisectBatchOnFunctionError(java.lang.Boolean bisectBatchOnFunctionError) {
                this.bisectBatchOnFunctionError = bisectBatchOnFunctionError;
                return this;
            }

            /**
             * Sets the value of {@link DynamoDBEventProperty#getBisectBatchOnFunctionError}
             * @param bisectBatchOnFunctionError the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder bisectBatchOnFunctionError(software.amazon.awscdk.IResolvable bisectBatchOnFunctionError) {
                this.bisectBatchOnFunctionError = bisectBatchOnFunctionError;
                return this;
            }

            /**
             * Sets the value of {@link DynamoDBEventProperty#getDestinationConfig}
             * @param destinationConfig the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder destinationConfig(software.amazon.awscdk.IResolvable destinationConfig) {
                this.destinationConfig = destinationConfig;
                return this;
            }

            /**
             * Sets the value of {@link DynamoDBEventProperty#getDestinationConfig}
             * @param destinationConfig the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder destinationConfig(software.amazon.awscdk.services.sam.CfnFunction.DestinationConfigProperty destinationConfig) {
                this.destinationConfig = destinationConfig;
                return this;
            }

            /**
             * Sets the value of {@link DynamoDBEventProperty#getEnabled}
             * @param enabled the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enabled(java.lang.Boolean enabled) {
                this.enabled = enabled;
                return this;
            }

            /**
             * Sets the value of {@link DynamoDBEventProperty#getEnabled}
             * @param enabled the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enabled(software.amazon.awscdk.IResolvable enabled) {
                this.enabled = enabled;
                return this;
            }

            /**
             * Sets the value of {@link DynamoDBEventProperty#getMaximumBatchingWindowInSeconds}
             * @param maximumBatchingWindowInSeconds the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder maximumBatchingWindowInSeconds(java.lang.Number maximumBatchingWindowInSeconds) {
                this.maximumBatchingWindowInSeconds = maximumBatchingWindowInSeconds;
                return this;
            }

            /**
             * Sets the value of {@link DynamoDBEventProperty#getMaximumRecordAgeInSeconds}
             * @param maximumRecordAgeInSeconds the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder maximumRecordAgeInSeconds(java.lang.Number maximumRecordAgeInSeconds) {
                this.maximumRecordAgeInSeconds = maximumRecordAgeInSeconds;
                return this;
            }

            /**
             * Sets the value of {@link DynamoDBEventProperty#getMaximumRetryAttempts}
             * @param maximumRetryAttempts the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder maximumRetryAttempts(java.lang.Number maximumRetryAttempts) {
                this.maximumRetryAttempts = maximumRetryAttempts;
                return this;
            }

            /**
             * Sets the value of {@link DynamoDBEventProperty#getParallelizationFactor}
             * @param parallelizationFactor the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder parallelizationFactor(java.lang.Number parallelizationFactor) {
                this.parallelizationFactor = parallelizationFactor;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DynamoDBEventProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DynamoDBEventProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DynamoDBEventProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DynamoDBEventProperty {
            private final java.lang.String startingPosition;
            private final java.lang.String stream;
            private final java.lang.Number batchSize;
            private final java.lang.Object bisectBatchOnFunctionError;
            private final java.lang.Object destinationConfig;
            private final java.lang.Object enabled;
            private final java.lang.Number maximumBatchingWindowInSeconds;
            private final java.lang.Number maximumRecordAgeInSeconds;
            private final java.lang.Number maximumRetryAttempts;
            private final java.lang.Number parallelizationFactor;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.startingPosition = software.amazon.jsii.Kernel.get(this, "startingPosition", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.stream = software.amazon.jsii.Kernel.get(this, "stream", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.batchSize = software.amazon.jsii.Kernel.get(this, "batchSize", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.bisectBatchOnFunctionError = software.amazon.jsii.Kernel.get(this, "bisectBatchOnFunctionError", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.destinationConfig = software.amazon.jsii.Kernel.get(this, "destinationConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.enabled = software.amazon.jsii.Kernel.get(this, "enabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.maximumBatchingWindowInSeconds = software.amazon.jsii.Kernel.get(this, "maximumBatchingWindowInSeconds", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.maximumRecordAgeInSeconds = software.amazon.jsii.Kernel.get(this, "maximumRecordAgeInSeconds", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.maximumRetryAttempts = software.amazon.jsii.Kernel.get(this, "maximumRetryAttempts", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.parallelizationFactor = software.amazon.jsii.Kernel.get(this, "parallelizationFactor", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.startingPosition = java.util.Objects.requireNonNull(builder.startingPosition, "startingPosition is required");
                this.stream = java.util.Objects.requireNonNull(builder.stream, "stream is required");
                this.batchSize = builder.batchSize;
                this.bisectBatchOnFunctionError = builder.bisectBatchOnFunctionError;
                this.destinationConfig = builder.destinationConfig;
                this.enabled = builder.enabled;
                this.maximumBatchingWindowInSeconds = builder.maximumBatchingWindowInSeconds;
                this.maximumRecordAgeInSeconds = builder.maximumRecordAgeInSeconds;
                this.maximumRetryAttempts = builder.maximumRetryAttempts;
                this.parallelizationFactor = builder.parallelizationFactor;
            }

            @Override
            public final java.lang.String getStartingPosition() {
                return this.startingPosition;
            }

            @Override
            public final java.lang.String getStream() {
                return this.stream;
            }

            @Override
            public final java.lang.Number getBatchSize() {
                return this.batchSize;
            }

            @Override
            public final java.lang.Object getBisectBatchOnFunctionError() {
                return this.bisectBatchOnFunctionError;
            }

            @Override
            public final java.lang.Object getDestinationConfig() {
                return this.destinationConfig;
            }

            @Override
            public final java.lang.Object getEnabled() {
                return this.enabled;
            }

            @Override
            public final java.lang.Number getMaximumBatchingWindowInSeconds() {
                return this.maximumBatchingWindowInSeconds;
            }

            @Override
            public final java.lang.Number getMaximumRecordAgeInSeconds() {
                return this.maximumRecordAgeInSeconds;
            }

            @Override
            public final java.lang.Number getMaximumRetryAttempts() {
                return this.maximumRetryAttempts;
            }

            @Override
            public final java.lang.Number getParallelizationFactor() {
                return this.parallelizationFactor;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("startingPosition", om.valueToTree(this.getStartingPosition()));
                data.set("stream", om.valueToTree(this.getStream()));
                if (this.getBatchSize() != null) {
                    data.set("batchSize", om.valueToTree(this.getBatchSize()));
                }
                if (this.getBisectBatchOnFunctionError() != null) {
                    data.set("bisectBatchOnFunctionError", om.valueToTree(this.getBisectBatchOnFunctionError()));
                }
                if (this.getDestinationConfig() != null) {
                    data.set("destinationConfig", om.valueToTree(this.getDestinationConfig()));
                }
                if (this.getEnabled() != null) {
                    data.set("enabled", om.valueToTree(this.getEnabled()));
                }
                if (this.getMaximumBatchingWindowInSeconds() != null) {
                    data.set("maximumBatchingWindowInSeconds", om.valueToTree(this.getMaximumBatchingWindowInSeconds()));
                }
                if (this.getMaximumRecordAgeInSeconds() != null) {
                    data.set("maximumRecordAgeInSeconds", om.valueToTree(this.getMaximumRecordAgeInSeconds()));
                }
                if (this.getMaximumRetryAttempts() != null) {
                    data.set("maximumRetryAttempts", om.valueToTree(this.getMaximumRetryAttempts()));
                }
                if (this.getParallelizationFactor() != null) {
                    data.set("parallelizationFactor", om.valueToTree(this.getParallelizationFactor()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_sam.CfnFunction.DynamoDBEventProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DynamoDBEventProperty.Jsii$Proxy that = (DynamoDBEventProperty.Jsii$Proxy) o;

                if (!startingPosition.equals(that.startingPosition)) return false;
                if (!stream.equals(that.stream)) return false;
                if (this.batchSize != null ? !this.batchSize.equals(that.batchSize) : that.batchSize != null) return false;
                if (this.bisectBatchOnFunctionError != null ? !this.bisectBatchOnFunctionError.equals(that.bisectBatchOnFunctionError) : that.bisectBatchOnFunctionError != null) return false;
                if (this.destinationConfig != null ? !this.destinationConfig.equals(that.destinationConfig) : that.destinationConfig != null) return false;
                if (this.enabled != null ? !this.enabled.equals(that.enabled) : that.enabled != null) return false;
                if (this.maximumBatchingWindowInSeconds != null ? !this.maximumBatchingWindowInSeconds.equals(that.maximumBatchingWindowInSeconds) : that.maximumBatchingWindowInSeconds != null) return false;
                if (this.maximumRecordAgeInSeconds != null ? !this.maximumRecordAgeInSeconds.equals(that.maximumRecordAgeInSeconds) : that.maximumRecordAgeInSeconds != null) return false;
                if (this.maximumRetryAttempts != null ? !this.maximumRetryAttempts.equals(that.maximumRetryAttempts) : that.maximumRetryAttempts != null) return false;
                return this.parallelizationFactor != null ? this.parallelizationFactor.equals(that.parallelizationFactor) : that.parallelizationFactor == null;
            }

            @Override
            public final int hashCode() {
                int result = this.startingPosition.hashCode();
                result = 31 * result + (this.stream.hashCode());
                result = 31 * result + (this.batchSize != null ? this.batchSize.hashCode() : 0);
                result = 31 * result + (this.bisectBatchOnFunctionError != null ? this.bisectBatchOnFunctionError.hashCode() : 0);
                result = 31 * result + (this.destinationConfig != null ? this.destinationConfig.hashCode() : 0);
                result = 31 * result + (this.enabled != null ? this.enabled.hashCode() : 0);
                result = 31 * result + (this.maximumBatchingWindowInSeconds != null ? this.maximumBatchingWindowInSeconds.hashCode() : 0);
                result = 31 * result + (this.maximumRecordAgeInSeconds != null ? this.maximumRecordAgeInSeconds.hashCode() : 0);
                result = 31 * result + (this.maximumRetryAttempts != null ? this.maximumRetryAttempts.hashCode() : 0);
                result = 31 * result + (this.parallelizationFactor != null ? this.parallelizationFactor.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sam.*;
     * EmptySAMPTProperty emptySAMPTProperty = EmptySAMPTProperty.builder().build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-emptysampt.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-emptysampt.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_sam.CfnFunction.EmptySAMPTProperty")
    @software.amazon.jsii.Jsii.Proxy(EmptySAMPTProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface EmptySAMPTProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * @return a {@link Builder} of {@link EmptySAMPTProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link EmptySAMPTProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<EmptySAMPTProperty> {

            /**
             * Builds the configured instance.
             * @return a new instance of {@link EmptySAMPTProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public EmptySAMPTProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link EmptySAMPTProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EmptySAMPTProperty {

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();


                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_sam.CfnFunction.EmptySAMPTProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sam.*;
     * EphemeralStorageProperty ephemeralStorageProperty = EphemeralStorageProperty.builder()
     *         .size(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-ephemeralstorage.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-ephemeralstorage.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_sam.CfnFunction.EphemeralStorageProperty")
    @software.amazon.jsii.Jsii.Proxy(EphemeralStorageProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface EphemeralStorageProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-ephemeralstorage.html#cfn-serverless-function-ephemeralstorage-size">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-ephemeralstorage.html#cfn-serverless-function-ephemeralstorage-size</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getSize();

        /**
         * @return a {@link Builder} of {@link EphemeralStorageProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link EphemeralStorageProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<EphemeralStorageProperty> {
            java.lang.Number size;

            /**
             * Sets the value of {@link EphemeralStorageProperty#getSize}
             * @param size the value to be set. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder size(java.lang.Number size) {
                this.size = size;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link EphemeralStorageProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public EphemeralStorageProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link EphemeralStorageProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EphemeralStorageProperty {
            private final java.lang.Number size;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.size = software.amazon.jsii.Kernel.get(this, "size", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.size = java.util.Objects.requireNonNull(builder.size, "size is required");
            }

            @Override
            public final java.lang.Number getSize() {
                return this.size;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("size", om.valueToTree(this.getSize()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_sam.CfnFunction.EphemeralStorageProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                EphemeralStorageProperty.Jsii$Proxy that = (EphemeralStorageProperty.Jsii$Proxy) o;

                return this.size.equals(that.size);
            }

            @Override
            public final int hashCode() {
                int result = this.size.hashCode();
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sam.*;
     * Object pattern;
     * EventBridgeRuleEventProperty eventBridgeRuleEventProperty = EventBridgeRuleEventProperty.builder()
     *         .pattern(pattern)
     *         // the properties below are optional
     *         .eventBusName("eventBusName")
     *         .input("input")
     *         .inputPath("inputPath")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-eventbridgeruleevent.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-eventbridgeruleevent.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_sam.CfnFunction.EventBridgeRuleEventProperty")
    @software.amazon.jsii.Jsii.Proxy(EventBridgeRuleEventProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface EventBridgeRuleEventProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-eventbridgeruleevent.html#cfn-serverless-function-eventbridgeruleevent-pattern">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-eventbridgeruleevent.html#cfn-serverless-function-eventbridgeruleevent-pattern</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getPattern();

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-eventbridgeruleevent.html#cfn-serverless-function-eventbridgeruleevent-eventbusname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-eventbridgeruleevent.html#cfn-serverless-function-eventbridgeruleevent-eventbusname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getEventBusName() {
            return null;
        }

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-eventbridgeruleevent.html#cfn-serverless-function-eventbridgeruleevent-input">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-eventbridgeruleevent.html#cfn-serverless-function-eventbridgeruleevent-input</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getInput() {
            return null;
        }

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-eventbridgeruleevent.html#cfn-serverless-function-eventbridgeruleevent-inputpath">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-eventbridgeruleevent.html#cfn-serverless-function-eventbridgeruleevent-inputpath</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getInputPath() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link EventBridgeRuleEventProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link EventBridgeRuleEventProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<EventBridgeRuleEventProperty> {
            java.lang.Object pattern;
            java.lang.String eventBusName;
            java.lang.String input;
            java.lang.String inputPath;

            /**
             * Sets the value of {@link EventBridgeRuleEventProperty#getPattern}
             * @param pattern the value to be set. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder pattern(java.lang.Object pattern) {
                this.pattern = pattern;
                return this;
            }

            /**
             * Sets the value of {@link EventBridgeRuleEventProperty#getEventBusName}
             * @param eventBusName the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder eventBusName(java.lang.String eventBusName) {
                this.eventBusName = eventBusName;
                return this;
            }

            /**
             * Sets the value of {@link EventBridgeRuleEventProperty#getInput}
             * @param input the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder input(java.lang.String input) {
                this.input = input;
                return this;
            }

            /**
             * Sets the value of {@link EventBridgeRuleEventProperty#getInputPath}
             * @param inputPath the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder inputPath(java.lang.String inputPath) {
                this.inputPath = inputPath;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link EventBridgeRuleEventProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public EventBridgeRuleEventProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link EventBridgeRuleEventProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EventBridgeRuleEventProperty {
            private final java.lang.Object pattern;
            private final java.lang.String eventBusName;
            private final java.lang.String input;
            private final java.lang.String inputPath;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.pattern = software.amazon.jsii.Kernel.get(this, "pattern", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.eventBusName = software.amazon.jsii.Kernel.get(this, "eventBusName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.input = software.amazon.jsii.Kernel.get(this, "input", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.inputPath = software.amazon.jsii.Kernel.get(this, "inputPath", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.pattern = java.util.Objects.requireNonNull(builder.pattern, "pattern is required");
                this.eventBusName = builder.eventBusName;
                this.input = builder.input;
                this.inputPath = builder.inputPath;
            }

            @Override
            public final java.lang.Object getPattern() {
                return this.pattern;
            }

            @Override
            public final java.lang.String getEventBusName() {
                return this.eventBusName;
            }

            @Override
            public final java.lang.String getInput() {
                return this.input;
            }

            @Override
            public final java.lang.String getInputPath() {
                return this.inputPath;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("pattern", om.valueToTree(this.getPattern()));
                if (this.getEventBusName() != null) {
                    data.set("eventBusName", om.valueToTree(this.getEventBusName()));
                }
                if (this.getInput() != null) {
                    data.set("input", om.valueToTree(this.getInput()));
                }
                if (this.getInputPath() != null) {
                    data.set("inputPath", om.valueToTree(this.getInputPath()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_sam.CfnFunction.EventBridgeRuleEventProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                EventBridgeRuleEventProperty.Jsii$Proxy that = (EventBridgeRuleEventProperty.Jsii$Proxy) o;

                if (!pattern.equals(that.pattern)) return false;
                if (this.eventBusName != null ? !this.eventBusName.equals(that.eventBusName) : that.eventBusName != null) return false;
                if (this.input != null ? !this.input.equals(that.input) : that.input != null) return false;
                return this.inputPath != null ? this.inputPath.equals(that.inputPath) : that.inputPath == null;
            }

            @Override
            public final int hashCode() {
                int result = this.pattern.hashCode();
                result = 31 * result + (this.eventBusName != null ? this.eventBusName.hashCode() : 0);
                result = 31 * result + (this.input != null ? this.input.hashCode() : 0);
                result = 31 * result + (this.inputPath != null ? this.inputPath.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sam.*;
     * EventInvokeConfigProperty eventInvokeConfigProperty = EventInvokeConfigProperty.builder()
     *         .destinationConfig(EventInvokeDestinationConfigProperty.builder()
     *                 .onFailure(DestinationProperty.builder()
     *                         .destination("destination")
     *                         // the properties below are optional
     *                         .type("type")
     *                         .build())
     *                 .onSuccess(DestinationProperty.builder()
     *                         .destination("destination")
     *                         // the properties below are optional
     *                         .type("type")
     *                         .build())
     *                 .build())
     *         .maximumEventAgeInSeconds(123)
     *         .maximumRetryAttempts(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-eventinvokeconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-eventinvokeconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_sam.CfnFunction.EventInvokeConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(EventInvokeConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface EventInvokeConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-eventinvokeconfig.html#cfn-serverless-function-eventinvokeconfig-destinationconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-eventinvokeconfig.html#cfn-serverless-function-eventinvokeconfig-destinationconfig</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDestinationConfig() {
            return null;
        }

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-eventinvokeconfig.html#cfn-serverless-function-eventinvokeconfig-maximumeventageinseconds">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-eventinvokeconfig.html#cfn-serverless-function-eventinvokeconfig-maximumeventageinseconds</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMaximumEventAgeInSeconds() {
            return null;
        }

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-eventinvokeconfig.html#cfn-serverless-function-eventinvokeconfig-maximumretryattempts">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-eventinvokeconfig.html#cfn-serverless-function-eventinvokeconfig-maximumretryattempts</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMaximumRetryAttempts() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link EventInvokeConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link EventInvokeConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<EventInvokeConfigProperty> {
            java.lang.Object destinationConfig;
            java.lang.Number maximumEventAgeInSeconds;
            java.lang.Number maximumRetryAttempts;

            /**
             * Sets the value of {@link EventInvokeConfigProperty#getDestinationConfig}
             * @param destinationConfig the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder destinationConfig(software.amazon.awscdk.IResolvable destinationConfig) {
                this.destinationConfig = destinationConfig;
                return this;
            }

            /**
             * Sets the value of {@link EventInvokeConfigProperty#getDestinationConfig}
             * @param destinationConfig the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder destinationConfig(software.amazon.awscdk.services.sam.CfnFunction.EventInvokeDestinationConfigProperty destinationConfig) {
                this.destinationConfig = destinationConfig;
                return this;
            }

            /**
             * Sets the value of {@link EventInvokeConfigProperty#getMaximumEventAgeInSeconds}
             * @param maximumEventAgeInSeconds the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder maximumEventAgeInSeconds(java.lang.Number maximumEventAgeInSeconds) {
                this.maximumEventAgeInSeconds = maximumEventAgeInSeconds;
                return this;
            }

            /**
             * Sets the value of {@link EventInvokeConfigProperty#getMaximumRetryAttempts}
             * @param maximumRetryAttempts the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder maximumRetryAttempts(java.lang.Number maximumRetryAttempts) {
                this.maximumRetryAttempts = maximumRetryAttempts;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link EventInvokeConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public EventInvokeConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link EventInvokeConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EventInvokeConfigProperty {
            private final java.lang.Object destinationConfig;
            private final java.lang.Number maximumEventAgeInSeconds;
            private final java.lang.Number maximumRetryAttempts;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.destinationConfig = software.amazon.jsii.Kernel.get(this, "destinationConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.maximumEventAgeInSeconds = software.amazon.jsii.Kernel.get(this, "maximumEventAgeInSeconds", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.maximumRetryAttempts = software.amazon.jsii.Kernel.get(this, "maximumRetryAttempts", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.destinationConfig = builder.destinationConfig;
                this.maximumEventAgeInSeconds = builder.maximumEventAgeInSeconds;
                this.maximumRetryAttempts = builder.maximumRetryAttempts;
            }

            @Override
            public final java.lang.Object getDestinationConfig() {
                return this.destinationConfig;
            }

            @Override
            public final java.lang.Number getMaximumEventAgeInSeconds() {
                return this.maximumEventAgeInSeconds;
            }

            @Override
            public final java.lang.Number getMaximumRetryAttempts() {
                return this.maximumRetryAttempts;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getDestinationConfig() != null) {
                    data.set("destinationConfig", om.valueToTree(this.getDestinationConfig()));
                }
                if (this.getMaximumEventAgeInSeconds() != null) {
                    data.set("maximumEventAgeInSeconds", om.valueToTree(this.getMaximumEventAgeInSeconds()));
                }
                if (this.getMaximumRetryAttempts() != null) {
                    data.set("maximumRetryAttempts", om.valueToTree(this.getMaximumRetryAttempts()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_sam.CfnFunction.EventInvokeConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                EventInvokeConfigProperty.Jsii$Proxy that = (EventInvokeConfigProperty.Jsii$Proxy) o;

                if (this.destinationConfig != null ? !this.destinationConfig.equals(that.destinationConfig) : that.destinationConfig != null) return false;
                if (this.maximumEventAgeInSeconds != null ? !this.maximumEventAgeInSeconds.equals(that.maximumEventAgeInSeconds) : that.maximumEventAgeInSeconds != null) return false;
                return this.maximumRetryAttempts != null ? this.maximumRetryAttempts.equals(that.maximumRetryAttempts) : that.maximumRetryAttempts == null;
            }

            @Override
            public final int hashCode() {
                int result = this.destinationConfig != null ? this.destinationConfig.hashCode() : 0;
                result = 31 * result + (this.maximumEventAgeInSeconds != null ? this.maximumEventAgeInSeconds.hashCode() : 0);
                result = 31 * result + (this.maximumRetryAttempts != null ? this.maximumRetryAttempts.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sam.*;
     * EventInvokeDestinationConfigProperty eventInvokeDestinationConfigProperty = EventInvokeDestinationConfigProperty.builder()
     *         .onFailure(DestinationProperty.builder()
     *                 .destination("destination")
     *                 // the properties below are optional
     *                 .type("type")
     *                 .build())
     *         .onSuccess(DestinationProperty.builder()
     *                 .destination("destination")
     *                 // the properties below are optional
     *                 .type("type")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-eventinvokedestinationconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-eventinvokedestinationconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_sam.CfnFunction.EventInvokeDestinationConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(EventInvokeDestinationConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface EventInvokeDestinationConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-eventinvokedestinationconfig.html#cfn-serverless-function-eventinvokedestinationconfig-onfailure">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-eventinvokedestinationconfig.html#cfn-serverless-function-eventinvokedestinationconfig-onfailure</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getOnFailure();

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-eventinvokedestinationconfig.html#cfn-serverless-function-eventinvokedestinationconfig-onsuccess">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-eventinvokedestinationconfig.html#cfn-serverless-function-eventinvokedestinationconfig-onsuccess</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getOnSuccess();

        /**
         * @return a {@link Builder} of {@link EventInvokeDestinationConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link EventInvokeDestinationConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<EventInvokeDestinationConfigProperty> {
            java.lang.Object onFailure;
            java.lang.Object onSuccess;

            /**
             * Sets the value of {@link EventInvokeDestinationConfigProperty#getOnFailure}
             * @param onFailure the value to be set. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder onFailure(software.amazon.awscdk.IResolvable onFailure) {
                this.onFailure = onFailure;
                return this;
            }

            /**
             * Sets the value of {@link EventInvokeDestinationConfigProperty#getOnFailure}
             * @param onFailure the value to be set. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder onFailure(software.amazon.awscdk.services.sam.CfnFunction.DestinationProperty onFailure) {
                this.onFailure = onFailure;
                return this;
            }

            /**
             * Sets the value of {@link EventInvokeDestinationConfigProperty#getOnSuccess}
             * @param onSuccess the value to be set. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder onSuccess(software.amazon.awscdk.IResolvable onSuccess) {
                this.onSuccess = onSuccess;
                return this;
            }

            /**
             * Sets the value of {@link EventInvokeDestinationConfigProperty#getOnSuccess}
             * @param onSuccess the value to be set. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder onSuccess(software.amazon.awscdk.services.sam.CfnFunction.DestinationProperty onSuccess) {
                this.onSuccess = onSuccess;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link EventInvokeDestinationConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public EventInvokeDestinationConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link EventInvokeDestinationConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EventInvokeDestinationConfigProperty {
            private final java.lang.Object onFailure;
            private final java.lang.Object onSuccess;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.onFailure = software.amazon.jsii.Kernel.get(this, "onFailure", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.onSuccess = software.amazon.jsii.Kernel.get(this, "onSuccess", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.onFailure = java.util.Objects.requireNonNull(builder.onFailure, "onFailure is required");
                this.onSuccess = java.util.Objects.requireNonNull(builder.onSuccess, "onSuccess is required");
            }

            @Override
            public final java.lang.Object getOnFailure() {
                return this.onFailure;
            }

            @Override
            public final java.lang.Object getOnSuccess() {
                return this.onSuccess;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("onFailure", om.valueToTree(this.getOnFailure()));
                data.set("onSuccess", om.valueToTree(this.getOnSuccess()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_sam.CfnFunction.EventInvokeDestinationConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                EventInvokeDestinationConfigProperty.Jsii$Proxy that = (EventInvokeDestinationConfigProperty.Jsii$Proxy) o;

                if (!onFailure.equals(that.onFailure)) return false;
                return this.onSuccess.equals(that.onSuccess);
            }

            @Override
            public final int hashCode() {
                int result = this.onFailure.hashCode();
                result = 31 * result + (this.onSuccess.hashCode());
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sam.*;
     * EventSourceProperty eventSourceProperty = EventSourceProperty.builder()
     *         .properties(AlexaSkillEventProperty.builder()
     *                 .skillId("skillId")
     *                 .build())
     *         .type("type")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-eventsource.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-eventsource.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_sam.CfnFunction.EventSourceProperty")
    @software.amazon.jsii.Jsii.Proxy(EventSourceProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface EventSourceProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-eventsource.html#cfn-serverless-function-eventsource-properties">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-eventsource.html#cfn-serverless-function-eventsource-properties</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getProperties();

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-eventsource.html#cfn-serverless-function-eventsource-type">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-eventsource.html#cfn-serverless-function-eventsource-type</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getType();

        /**
         * @return a {@link Builder} of {@link EventSourceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link EventSourceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<EventSourceProperty> {
            java.lang.Object properties;
            java.lang.String type;

            /**
             * Sets the value of {@link EventSourceProperty#getProperties}
             * @param properties the value to be set. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder properties(software.amazon.awscdk.IResolvable properties) {
                this.properties = properties;
                return this;
            }

            /**
             * Sets the value of {@link EventSourceProperty#getProperties}
             * @param properties the value to be set. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder properties(software.amazon.awscdk.services.sam.CfnFunction.AlexaSkillEventProperty properties) {
                this.properties = properties;
                return this;
            }

            /**
             * Sets the value of {@link EventSourceProperty#getProperties}
             * @param properties the value to be set. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder properties(software.amazon.awscdk.services.sam.CfnFunction.ApiEventProperty properties) {
                this.properties = properties;
                return this;
            }

            /**
             * Sets the value of {@link EventSourceProperty#getProperties}
             * @param properties the value to be set. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder properties(software.amazon.awscdk.services.sam.CfnFunction.CloudWatchEventEventProperty properties) {
                this.properties = properties;
                return this;
            }

            /**
             * Sets the value of {@link EventSourceProperty#getProperties}
             * @param properties the value to be set. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder properties(software.amazon.awscdk.services.sam.CfnFunction.CloudWatchLogsEventProperty properties) {
                this.properties = properties;
                return this;
            }

            /**
             * Sets the value of {@link EventSourceProperty#getProperties}
             * @param properties the value to be set. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder properties(software.amazon.awscdk.services.sam.CfnFunction.CognitoEventProperty properties) {
                this.properties = properties;
                return this;
            }

            /**
             * Sets the value of {@link EventSourceProperty#getProperties}
             * @param properties the value to be set. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder properties(software.amazon.awscdk.services.sam.CfnFunction.DynamoDBEventProperty properties) {
                this.properties = properties;
                return this;
            }

            /**
             * Sets the value of {@link EventSourceProperty#getProperties}
             * @param properties the value to be set. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder properties(software.amazon.awscdk.services.sam.CfnFunction.EventBridgeRuleEventProperty properties) {
                this.properties = properties;
                return this;
            }

            /**
             * Sets the value of {@link EventSourceProperty#getProperties}
             * @param properties the value to be set. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder properties(software.amazon.awscdk.services.sam.CfnFunction.HttpApiEventProperty properties) {
                this.properties = properties;
                return this;
            }

            /**
             * Sets the value of {@link EventSourceProperty#getProperties}
             * @param properties the value to be set. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder properties(software.amazon.awscdk.services.sam.CfnFunction.IoTRuleEventProperty properties) {
                this.properties = properties;
                return this;
            }

            /**
             * Sets the value of {@link EventSourceProperty#getProperties}
             * @param properties the value to be set. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder properties(software.amazon.awscdk.services.sam.CfnFunction.KinesisEventProperty properties) {
                this.properties = properties;
                return this;
            }

            /**
             * Sets the value of {@link EventSourceProperty#getProperties}
             * @param properties the value to be set. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder properties(software.amazon.awscdk.services.sam.CfnFunction.S3EventProperty properties) {
                this.properties = properties;
                return this;
            }

            /**
             * Sets the value of {@link EventSourceProperty#getProperties}
             * @param properties the value to be set. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder properties(software.amazon.awscdk.services.sam.CfnFunction.ScheduleEventProperty properties) {
                this.properties = properties;
                return this;
            }

            /**
             * Sets the value of {@link EventSourceProperty#getProperties}
             * @param properties the value to be set. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder properties(software.amazon.awscdk.services.sam.CfnFunction.SNSEventProperty properties) {
                this.properties = properties;
                return this;
            }

            /**
             * Sets the value of {@link EventSourceProperty#getProperties}
             * @param properties the value to be set. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder properties(software.amazon.awscdk.services.sam.CfnFunction.SQSEventProperty properties) {
                this.properties = properties;
                return this;
            }

            /**
             * Sets the value of {@link EventSourceProperty#getType}
             * @param type the value to be set. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder type(java.lang.String type) {
                this.type = type;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link EventSourceProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public EventSourceProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link EventSourceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EventSourceProperty {
            private final java.lang.Object properties;
            private final java.lang.String type;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.properties = software.amazon.jsii.Kernel.get(this, "properties", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.type = software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.properties = java.util.Objects.requireNonNull(builder.properties, "properties is required");
                this.type = java.util.Objects.requireNonNull(builder.type, "type is required");
            }

            @Override
            public final java.lang.Object getProperties() {
                return this.properties;
            }

            @Override
            public final java.lang.String getType() {
                return this.type;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("properties", om.valueToTree(this.getProperties()));
                data.set("type", om.valueToTree(this.getType()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_sam.CfnFunction.EventSourceProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                EventSourceProperty.Jsii$Proxy that = (EventSourceProperty.Jsii$Proxy) o;

                if (!properties.equals(that.properties)) return false;
                return this.type.equals(that.type);
            }

            @Override
            public final int hashCode() {
                int result = this.properties.hashCode();
                result = 31 * result + (this.type.hashCode());
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sam.*;
     * FileSystemConfigProperty fileSystemConfigProperty = FileSystemConfigProperty.builder()
     *         .arn("arn")
     *         .localMountPath("localMountPath")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-filesystemconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-filesystemconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_sam.CfnFunction.FileSystemConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(FileSystemConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface FileSystemConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-filesystemconfig.html#cfn-serverless-function-filesystemconfig-arn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-filesystemconfig.html#cfn-serverless-function-filesystemconfig-arn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getArn() {
            return null;
        }

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-filesystemconfig.html#cfn-serverless-function-filesystemconfig-localmountpath">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-filesystemconfig.html#cfn-serverless-function-filesystemconfig-localmountpath</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getLocalMountPath() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link FileSystemConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link FileSystemConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<FileSystemConfigProperty> {
            java.lang.String arn;
            java.lang.String localMountPath;

            /**
             * Sets the value of {@link FileSystemConfigProperty#getArn}
             * @param arn the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder arn(java.lang.String arn) {
                this.arn = arn;
                return this;
            }

            /**
             * Sets the value of {@link FileSystemConfigProperty#getLocalMountPath}
             * @param localMountPath the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder localMountPath(java.lang.String localMountPath) {
                this.localMountPath = localMountPath;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link FileSystemConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public FileSystemConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link FileSystemConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements FileSystemConfigProperty {
            private final java.lang.String arn;
            private final java.lang.String localMountPath;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.arn = software.amazon.jsii.Kernel.get(this, "arn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.localMountPath = software.amazon.jsii.Kernel.get(this, "localMountPath", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.arn = builder.arn;
                this.localMountPath = builder.localMountPath;
            }

            @Override
            public final java.lang.String getArn() {
                return this.arn;
            }

            @Override
            public final java.lang.String getLocalMountPath() {
                return this.localMountPath;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getArn() != null) {
                    data.set("arn", om.valueToTree(this.getArn()));
                }
                if (this.getLocalMountPath() != null) {
                    data.set("localMountPath", om.valueToTree(this.getLocalMountPath()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_sam.CfnFunction.FileSystemConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                FileSystemConfigProperty.Jsii$Proxy that = (FileSystemConfigProperty.Jsii$Proxy) o;

                if (this.arn != null ? !this.arn.equals(that.arn) : that.arn != null) return false;
                return this.localMountPath != null ? this.localMountPath.equals(that.localMountPath) : that.localMountPath == null;
            }

            @Override
            public final int hashCode() {
                int result = this.arn != null ? this.arn.hashCode() : 0;
                result = 31 * result + (this.localMountPath != null ? this.localMountPath.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sam.*;
     * FunctionEnvironmentProperty functionEnvironmentProperty = FunctionEnvironmentProperty.builder()
     *         .variables(Map.of(
     *                 "variablesKey", "variables"))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-functionenvironment.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-functionenvironment.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_sam.CfnFunction.FunctionEnvironmentProperty")
    @software.amazon.jsii.Jsii.Proxy(FunctionEnvironmentProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface FunctionEnvironmentProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-functionenvironment.html#cfn-serverless-function-functionenvironment-variables">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-functionenvironment.html#cfn-serverless-function-functionenvironment-variables</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getVariables();

        /**
         * @return a {@link Builder} of {@link FunctionEnvironmentProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link FunctionEnvironmentProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<FunctionEnvironmentProperty> {
            java.lang.Object variables;

            /**
             * Sets the value of {@link FunctionEnvironmentProperty#getVariables}
             * @param variables the value to be set. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder variables(software.amazon.awscdk.IResolvable variables) {
                this.variables = variables;
                return this;
            }

            /**
             * Sets the value of {@link FunctionEnvironmentProperty#getVariables}
             * @param variables the value to be set. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder variables(java.util.Map<java.lang.String, java.lang.String> variables) {
                this.variables = variables;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link FunctionEnvironmentProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public FunctionEnvironmentProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link FunctionEnvironmentProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements FunctionEnvironmentProperty {
            private final java.lang.Object variables;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.variables = software.amazon.jsii.Kernel.get(this, "variables", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.variables = java.util.Objects.requireNonNull(builder.variables, "variables is required");
            }

            @Override
            public final java.lang.Object getVariables() {
                return this.variables;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("variables", om.valueToTree(this.getVariables()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_sam.CfnFunction.FunctionEnvironmentProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                FunctionEnvironmentProperty.Jsii$Proxy that = (FunctionEnvironmentProperty.Jsii$Proxy) o;

                return this.variables.equals(that.variables);
            }

            @Override
            public final int hashCode() {
                int result = this.variables.hashCode();
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sam.*;
     * FunctionSAMPTProperty functionSAMPTProperty = FunctionSAMPTProperty.builder()
     *         .functionName("functionName")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-functionsampt.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-functionsampt.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_sam.CfnFunction.FunctionSAMPTProperty")
    @software.amazon.jsii.Jsii.Proxy(FunctionSAMPTProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface FunctionSAMPTProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-functionsampt.html#cfn-serverless-function-functionsampt-functionname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-functionsampt.html#cfn-serverless-function-functionsampt-functionname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getFunctionName();

        /**
         * @return a {@link Builder} of {@link FunctionSAMPTProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link FunctionSAMPTProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<FunctionSAMPTProperty> {
            java.lang.String functionName;

            /**
             * Sets the value of {@link FunctionSAMPTProperty#getFunctionName}
             * @param functionName the value to be set. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder functionName(java.lang.String functionName) {
                this.functionName = functionName;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link FunctionSAMPTProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public FunctionSAMPTProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link FunctionSAMPTProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements FunctionSAMPTProperty {
            private final java.lang.String functionName;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.functionName = software.amazon.jsii.Kernel.get(this, "functionName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.functionName = java.util.Objects.requireNonNull(builder.functionName, "functionName is required");
            }

            @Override
            public final java.lang.String getFunctionName() {
                return this.functionName;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("functionName", om.valueToTree(this.getFunctionName()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_sam.CfnFunction.FunctionSAMPTProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                FunctionSAMPTProperty.Jsii$Proxy that = (FunctionSAMPTProperty.Jsii$Proxy) o;

                return this.functionName.equals(that.functionName);
            }

            @Override
            public final int hashCode() {
                int result = this.functionName.hashCode();
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sam.*;
     * FunctionUrlConfigProperty functionUrlConfigProperty = FunctionUrlConfigProperty.builder()
     *         .authType("authType")
     *         // the properties below are optional
     *         .cors("cors")
     *         .invokeMode("invokeMode")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-functionurlconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-functionurlconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_sam.CfnFunction.FunctionUrlConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(FunctionUrlConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface FunctionUrlConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-functionurlconfig.html#cfn-serverless-function-functionurlconfig-authtype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-functionurlconfig.html#cfn-serverless-function-functionurlconfig-authtype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getAuthType();

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-functionurlconfig.html#cfn-serverless-function-functionurlconfig-cors">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-functionurlconfig.html#cfn-serverless-function-functionurlconfig-cors</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCors() {
            return null;
        }

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-functionurlconfig.html#cfn-serverless-function-functionurlconfig-invokemode">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-functionurlconfig.html#cfn-serverless-function-functionurlconfig-invokemode</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getInvokeMode() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link FunctionUrlConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link FunctionUrlConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<FunctionUrlConfigProperty> {
            java.lang.String authType;
            java.lang.Object cors;
            java.lang.String invokeMode;

            /**
             * Sets the value of {@link FunctionUrlConfigProperty#getAuthType}
             * @param authType the value to be set. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder authType(java.lang.String authType) {
                this.authType = authType;
                return this;
            }

            /**
             * Sets the value of {@link FunctionUrlConfigProperty#getCors}
             * @param cors the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cors(java.lang.String cors) {
                this.cors = cors;
                return this;
            }

            /**
             * Sets the value of {@link FunctionUrlConfigProperty#getCors}
             * @param cors the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cors(software.amazon.awscdk.IResolvable cors) {
                this.cors = cors;
                return this;
            }

            /**
             * Sets the value of {@link FunctionUrlConfigProperty#getCors}
             * @param cors the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cors(software.amazon.awscdk.services.sam.CfnFunction.CorsConfigurationProperty cors) {
                this.cors = cors;
                return this;
            }

            /**
             * Sets the value of {@link FunctionUrlConfigProperty#getInvokeMode}
             * @param invokeMode the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder invokeMode(java.lang.String invokeMode) {
                this.invokeMode = invokeMode;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link FunctionUrlConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public FunctionUrlConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link FunctionUrlConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements FunctionUrlConfigProperty {
            private final java.lang.String authType;
            private final java.lang.Object cors;
            private final java.lang.String invokeMode;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.authType = software.amazon.jsii.Kernel.get(this, "authType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.cors = software.amazon.jsii.Kernel.get(this, "cors", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.invokeMode = software.amazon.jsii.Kernel.get(this, "invokeMode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.authType = java.util.Objects.requireNonNull(builder.authType, "authType is required");
                this.cors = builder.cors;
                this.invokeMode = builder.invokeMode;
            }

            @Override
            public final java.lang.String getAuthType() {
                return this.authType;
            }

            @Override
            public final java.lang.Object getCors() {
                return this.cors;
            }

            @Override
            public final java.lang.String getInvokeMode() {
                return this.invokeMode;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("authType", om.valueToTree(this.getAuthType()));
                if (this.getCors() != null) {
                    data.set("cors", om.valueToTree(this.getCors()));
                }
                if (this.getInvokeMode() != null) {
                    data.set("invokeMode", om.valueToTree(this.getInvokeMode()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_sam.CfnFunction.FunctionUrlConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                FunctionUrlConfigProperty.Jsii$Proxy that = (FunctionUrlConfigProperty.Jsii$Proxy) o;

                if (!authType.equals(that.authType)) return false;
                if (this.cors != null ? !this.cors.equals(that.cors) : that.cors != null) return false;
                return this.invokeMode != null ? this.invokeMode.equals(that.invokeMode) : that.invokeMode == null;
            }

            @Override
            public final int hashCode() {
                int result = this.authType.hashCode();
                result = 31 * result + (this.cors != null ? this.cors.hashCode() : 0);
                result = 31 * result + (this.invokeMode != null ? this.invokeMode.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sam.*;
     * HooksProperty hooksProperty = HooksProperty.builder()
     *         .postTraffic("postTraffic")
     *         .preTraffic("preTraffic")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-hooks.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-hooks.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_sam.CfnFunction.HooksProperty")
    @software.amazon.jsii.Jsii.Proxy(HooksProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface HooksProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-hooks.html#cfn-serverless-function-hooks-posttraffic">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-hooks.html#cfn-serverless-function-hooks-posttraffic</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getPostTraffic() {
            return null;
        }

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-hooks.html#cfn-serverless-function-hooks-pretraffic">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-hooks.html#cfn-serverless-function-hooks-pretraffic</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getPreTraffic() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link HooksProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link HooksProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<HooksProperty> {
            java.lang.String postTraffic;
            java.lang.String preTraffic;

            /**
             * Sets the value of {@link HooksProperty#getPostTraffic}
             * @param postTraffic the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder postTraffic(java.lang.String postTraffic) {
                this.postTraffic = postTraffic;
                return this;
            }

            /**
             * Sets the value of {@link HooksProperty#getPreTraffic}
             * @param preTraffic the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder preTraffic(java.lang.String preTraffic) {
                this.preTraffic = preTraffic;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link HooksProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public HooksProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link HooksProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements HooksProperty {
            private final java.lang.String postTraffic;
            private final java.lang.String preTraffic;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.postTraffic = software.amazon.jsii.Kernel.get(this, "postTraffic", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.preTraffic = software.amazon.jsii.Kernel.get(this, "preTraffic", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.postTraffic = builder.postTraffic;
                this.preTraffic = builder.preTraffic;
            }

            @Override
            public final java.lang.String getPostTraffic() {
                return this.postTraffic;
            }

            @Override
            public final java.lang.String getPreTraffic() {
                return this.preTraffic;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getPostTraffic() != null) {
                    data.set("postTraffic", om.valueToTree(this.getPostTraffic()));
                }
                if (this.getPreTraffic() != null) {
                    data.set("preTraffic", om.valueToTree(this.getPreTraffic()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_sam.CfnFunction.HooksProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                HooksProperty.Jsii$Proxy that = (HooksProperty.Jsii$Proxy) o;

                if (this.postTraffic != null ? !this.postTraffic.equals(that.postTraffic) : that.postTraffic != null) return false;
                return this.preTraffic != null ? this.preTraffic.equals(that.preTraffic) : that.preTraffic == null;
            }

            @Override
            public final int hashCode() {
                int result = this.postTraffic != null ? this.postTraffic.hashCode() : 0;
                result = 31 * result + (this.preTraffic != null ? this.preTraffic.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sam.*;
     * HttpApiEventProperty httpApiEventProperty = HttpApiEventProperty.builder()
     *         .apiId("apiId")
     *         .auth(HttpApiFunctionAuthProperty.builder()
     *                 .authorizationScopes(List.of("authorizationScopes"))
     *                 .authorizer("authorizer")
     *                 .build())
     *         .method("method")
     *         .path("path")
     *         .payloadFormatVersion("payloadFormatVersion")
     *         .routeSettings(RouteSettingsProperty.builder()
     *                 .dataTraceEnabled(false)
     *                 .detailedMetricsEnabled(false)
     *                 .loggingLevel("loggingLevel")
     *                 .throttlingBurstLimit(123)
     *                 .throttlingRateLimit(123)
     *                 .build())
     *         .timeoutInMillis(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-httpapievent.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-httpapievent.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_sam.CfnFunction.HttpApiEventProperty")
    @software.amazon.jsii.Jsii.Proxy(HttpApiEventProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface HttpApiEventProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-httpapievent.html#cfn-serverless-function-httpapievent-apiid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-httpapievent.html#cfn-serverless-function-httpapievent-apiid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getApiId() {
            return null;
        }

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-httpapievent.html#cfn-serverless-function-httpapievent-auth">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-httpapievent.html#cfn-serverless-function-httpapievent-auth</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAuth() {
            return null;
        }

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-httpapievent.html#cfn-serverless-function-httpapievent-method">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-httpapievent.html#cfn-serverless-function-httpapievent-method</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getMethod() {
            return null;
        }

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-httpapievent.html#cfn-serverless-function-httpapievent-path">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-httpapievent.html#cfn-serverless-function-httpapievent-path</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getPath() {
            return null;
        }

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-httpapievent.html#cfn-serverless-function-httpapievent-payloadformatversion">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-httpapievent.html#cfn-serverless-function-httpapievent-payloadformatversion</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getPayloadFormatVersion() {
            return null;
        }

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-httpapievent.html#cfn-serverless-function-httpapievent-routesettings">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-httpapievent.html#cfn-serverless-function-httpapievent-routesettings</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getRouteSettings() {
            return null;
        }

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-httpapievent.html#cfn-serverless-function-httpapievent-timeoutinmillis">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-httpapievent.html#cfn-serverless-function-httpapievent-timeoutinmillis</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getTimeoutInMillis() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link HttpApiEventProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link HttpApiEventProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<HttpApiEventProperty> {
            java.lang.String apiId;
            java.lang.Object auth;
            java.lang.String method;
            java.lang.String path;
            java.lang.String payloadFormatVersion;
            java.lang.Object routeSettings;
            java.lang.Number timeoutInMillis;

            /**
             * Sets the value of {@link HttpApiEventProperty#getApiId}
             * @param apiId the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder apiId(java.lang.String apiId) {
                this.apiId = apiId;
                return this;
            }

            /**
             * Sets the value of {@link HttpApiEventProperty#getAuth}
             * @param auth the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder auth(software.amazon.awscdk.IResolvable auth) {
                this.auth = auth;
                return this;
            }

            /**
             * Sets the value of {@link HttpApiEventProperty#getAuth}
             * @param auth the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder auth(software.amazon.awscdk.services.sam.CfnFunction.HttpApiFunctionAuthProperty auth) {
                this.auth = auth;
                return this;
            }

            /**
             * Sets the value of {@link HttpApiEventProperty#getMethod}
             * @param method the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder method(java.lang.String method) {
                this.method = method;
                return this;
            }

            /**
             * Sets the value of {@link HttpApiEventProperty#getPath}
             * @param path the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder path(java.lang.String path) {
                this.path = path;
                return this;
            }

            /**
             * Sets the value of {@link HttpApiEventProperty#getPayloadFormatVersion}
             * @param payloadFormatVersion the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder payloadFormatVersion(java.lang.String payloadFormatVersion) {
                this.payloadFormatVersion = payloadFormatVersion;
                return this;
            }

            /**
             * Sets the value of {@link HttpApiEventProperty#getRouteSettings}
             * @param routeSettings the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder routeSettings(software.amazon.awscdk.IResolvable routeSettings) {
                this.routeSettings = routeSettings;
                return this;
            }

            /**
             * Sets the value of {@link HttpApiEventProperty#getRouteSettings}
             * @param routeSettings the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder routeSettings(software.amazon.awscdk.services.sam.CfnFunction.RouteSettingsProperty routeSettings) {
                this.routeSettings = routeSettings;
                return this;
            }

            /**
             * Sets the value of {@link HttpApiEventProperty#getTimeoutInMillis}
             * @param timeoutInMillis the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder timeoutInMillis(java.lang.Number timeoutInMillis) {
                this.timeoutInMillis = timeoutInMillis;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link HttpApiEventProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public HttpApiEventProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link HttpApiEventProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements HttpApiEventProperty {
            private final java.lang.String apiId;
            private final java.lang.Object auth;
            private final java.lang.String method;
            private final java.lang.String path;
            private final java.lang.String payloadFormatVersion;
            private final java.lang.Object routeSettings;
            private final java.lang.Number timeoutInMillis;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.apiId = software.amazon.jsii.Kernel.get(this, "apiId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.auth = software.amazon.jsii.Kernel.get(this, "auth", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.method = software.amazon.jsii.Kernel.get(this, "method", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.path = software.amazon.jsii.Kernel.get(this, "path", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.payloadFormatVersion = software.amazon.jsii.Kernel.get(this, "payloadFormatVersion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.routeSettings = software.amazon.jsii.Kernel.get(this, "routeSettings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.timeoutInMillis = software.amazon.jsii.Kernel.get(this, "timeoutInMillis", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.apiId = builder.apiId;
                this.auth = builder.auth;
                this.method = builder.method;
                this.path = builder.path;
                this.payloadFormatVersion = builder.payloadFormatVersion;
                this.routeSettings = builder.routeSettings;
                this.timeoutInMillis = builder.timeoutInMillis;
            }

            @Override
            public final java.lang.String getApiId() {
                return this.apiId;
            }

            @Override
            public final java.lang.Object getAuth() {
                return this.auth;
            }

            @Override
            public final java.lang.String getMethod() {
                return this.method;
            }

            @Override
            public final java.lang.String getPath() {
                return this.path;
            }

            @Override
            public final java.lang.String getPayloadFormatVersion() {
                return this.payloadFormatVersion;
            }

            @Override
            public final java.lang.Object getRouteSettings() {
                return this.routeSettings;
            }

            @Override
            public final java.lang.Number getTimeoutInMillis() {
                return this.timeoutInMillis;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getApiId() != null) {
                    data.set("apiId", om.valueToTree(this.getApiId()));
                }
                if (this.getAuth() != null) {
                    data.set("auth", om.valueToTree(this.getAuth()));
                }
                if (this.getMethod() != null) {
                    data.set("method", om.valueToTree(this.getMethod()));
                }
                if (this.getPath() != null) {
                    data.set("path", om.valueToTree(this.getPath()));
                }
                if (this.getPayloadFormatVersion() != null) {
                    data.set("payloadFormatVersion", om.valueToTree(this.getPayloadFormatVersion()));
                }
                if (this.getRouteSettings() != null) {
                    data.set("routeSettings", om.valueToTree(this.getRouteSettings()));
                }
                if (this.getTimeoutInMillis() != null) {
                    data.set("timeoutInMillis", om.valueToTree(this.getTimeoutInMillis()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_sam.CfnFunction.HttpApiEventProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                HttpApiEventProperty.Jsii$Proxy that = (HttpApiEventProperty.Jsii$Proxy) o;

                if (this.apiId != null ? !this.apiId.equals(that.apiId) : that.apiId != null) return false;
                if (this.auth != null ? !this.auth.equals(that.auth) : that.auth != null) return false;
                if (this.method != null ? !this.method.equals(that.method) : that.method != null) return false;
                if (this.path != null ? !this.path.equals(that.path) : that.path != null) return false;
                if (this.payloadFormatVersion != null ? !this.payloadFormatVersion.equals(that.payloadFormatVersion) : that.payloadFormatVersion != null) return false;
                if (this.routeSettings != null ? !this.routeSettings.equals(that.routeSettings) : that.routeSettings != null) return false;
                return this.timeoutInMillis != null ? this.timeoutInMillis.equals(that.timeoutInMillis) : that.timeoutInMillis == null;
            }

            @Override
            public final int hashCode() {
                int result = this.apiId != null ? this.apiId.hashCode() : 0;
                result = 31 * result + (this.auth != null ? this.auth.hashCode() : 0);
                result = 31 * result + (this.method != null ? this.method.hashCode() : 0);
                result = 31 * result + (this.path != null ? this.path.hashCode() : 0);
                result = 31 * result + (this.payloadFormatVersion != null ? this.payloadFormatVersion.hashCode() : 0);
                result = 31 * result + (this.routeSettings != null ? this.routeSettings.hashCode() : 0);
                result = 31 * result + (this.timeoutInMillis != null ? this.timeoutInMillis.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sam.*;
     * HttpApiFunctionAuthProperty httpApiFunctionAuthProperty = HttpApiFunctionAuthProperty.builder()
     *         .authorizationScopes(List.of("authorizationScopes"))
     *         .authorizer("authorizer")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-httpapifunctionauth.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-httpapifunctionauth.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_sam.CfnFunction.HttpApiFunctionAuthProperty")
    @software.amazon.jsii.Jsii.Proxy(HttpApiFunctionAuthProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface HttpApiFunctionAuthProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-httpapifunctionauth.html#cfn-serverless-function-httpapifunctionauth-authorizationscopes">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-httpapifunctionauth.html#cfn-serverless-function-httpapifunctionauth-authorizationscopes</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getAuthorizationScopes() {
            return null;
        }

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-httpapifunctionauth.html#cfn-serverless-function-httpapifunctionauth-authorizer">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-httpapifunctionauth.html#cfn-serverless-function-httpapifunctionauth-authorizer</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAuthorizer() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link HttpApiFunctionAuthProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link HttpApiFunctionAuthProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<HttpApiFunctionAuthProperty> {
            java.util.List<java.lang.String> authorizationScopes;
            java.lang.String authorizer;

            /**
             * Sets the value of {@link HttpApiFunctionAuthProperty#getAuthorizationScopes}
             * @param authorizationScopes the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder authorizationScopes(java.util.List<java.lang.String> authorizationScopes) {
                this.authorizationScopes = authorizationScopes;
                return this;
            }

            /**
             * Sets the value of {@link HttpApiFunctionAuthProperty#getAuthorizer}
             * @param authorizer the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder authorizer(java.lang.String authorizer) {
                this.authorizer = authorizer;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link HttpApiFunctionAuthProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public HttpApiFunctionAuthProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link HttpApiFunctionAuthProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements HttpApiFunctionAuthProperty {
            private final java.util.List<java.lang.String> authorizationScopes;
            private final java.lang.String authorizer;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.authorizationScopes = software.amazon.jsii.Kernel.get(this, "authorizationScopes", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.authorizer = software.amazon.jsii.Kernel.get(this, "authorizer", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.authorizationScopes = builder.authorizationScopes;
                this.authorizer = builder.authorizer;
            }

            @Override
            public final java.util.List<java.lang.String> getAuthorizationScopes() {
                return this.authorizationScopes;
            }

            @Override
            public final java.lang.String getAuthorizer() {
                return this.authorizer;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAuthorizationScopes() != null) {
                    data.set("authorizationScopes", om.valueToTree(this.getAuthorizationScopes()));
                }
                if (this.getAuthorizer() != null) {
                    data.set("authorizer", om.valueToTree(this.getAuthorizer()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_sam.CfnFunction.HttpApiFunctionAuthProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                HttpApiFunctionAuthProperty.Jsii$Proxy that = (HttpApiFunctionAuthProperty.Jsii$Proxy) o;

                if (this.authorizationScopes != null ? !this.authorizationScopes.equals(that.authorizationScopes) : that.authorizationScopes != null) return false;
                return this.authorizer != null ? this.authorizer.equals(that.authorizer) : that.authorizer == null;
            }

            @Override
            public final int hashCode() {
                int result = this.authorizationScopes != null ? this.authorizationScopes.hashCode() : 0;
                result = 31 * result + (this.authorizer != null ? this.authorizer.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sam.*;
     * Object statement;
     * IAMPolicyDocumentProperty iAMPolicyDocumentProperty = Map.of(
     *         "statement", statement,
     *         // the properties below are optional
     *         "version", "version");
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-iampolicydocument.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-iampolicydocument.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_sam.CfnFunction.IAMPolicyDocumentProperty")
    @software.amazon.jsii.Jsii.Proxy(IAMPolicyDocumentProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface IAMPolicyDocumentProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-iampolicydocument.html#cfn-serverless-function-iampolicydocument-statement">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-iampolicydocument.html#cfn-serverless-function-iampolicydocument-statement</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getStatement();

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-iampolicydocument.html#cfn-serverless-function-iampolicydocument-version">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-iampolicydocument.html#cfn-serverless-function-iampolicydocument-version</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getVersion() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link IAMPolicyDocumentProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link IAMPolicyDocumentProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<IAMPolicyDocumentProperty> {
            java.lang.Object statement;
            java.lang.String version;

            /**
             * Sets the value of {@link IAMPolicyDocumentProperty#getStatement}
             * @param statement the value to be set. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder statement(java.lang.Object statement) {
                this.statement = statement;
                return this;
            }

            /**
             * Sets the value of {@link IAMPolicyDocumentProperty#getVersion}
             * @param version the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder version(java.lang.String version) {
                this.version = version;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link IAMPolicyDocumentProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public IAMPolicyDocumentProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link IAMPolicyDocumentProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements IAMPolicyDocumentProperty {
            private final java.lang.Object statement;
            private final java.lang.String version;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.statement = software.amazon.jsii.Kernel.get(this, "statement", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.version = software.amazon.jsii.Kernel.get(this, "version", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.statement = java.util.Objects.requireNonNull(builder.statement, "statement is required");
                this.version = builder.version;
            }

            @Override
            public final java.lang.Object getStatement() {
                return this.statement;
            }

            @Override
            public final java.lang.String getVersion() {
                return this.version;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("statement", om.valueToTree(this.getStatement()));
                if (this.getVersion() != null) {
                    data.set("version", om.valueToTree(this.getVersion()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_sam.CfnFunction.IAMPolicyDocumentProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                IAMPolicyDocumentProperty.Jsii$Proxy that = (IAMPolicyDocumentProperty.Jsii$Proxy) o;

                if (!statement.equals(that.statement)) return false;
                return this.version != null ? this.version.equals(that.version) : that.version == null;
            }

            @Override
            public final int hashCode() {
                int result = this.statement.hashCode();
                result = 31 * result + (this.version != null ? this.version.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sam.*;
     * IdentitySAMPTProperty identitySAMPTProperty = IdentitySAMPTProperty.builder()
     *         .identityName("identityName")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-identitysampt.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-identitysampt.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_sam.CfnFunction.IdentitySAMPTProperty")
    @software.amazon.jsii.Jsii.Proxy(IdentitySAMPTProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface IdentitySAMPTProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-identitysampt.html#cfn-serverless-function-identitysampt-identityname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-identitysampt.html#cfn-serverless-function-identitysampt-identityname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getIdentityName();

        /**
         * @return a {@link Builder} of {@link IdentitySAMPTProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link IdentitySAMPTProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<IdentitySAMPTProperty> {
            java.lang.String identityName;

            /**
             * Sets the value of {@link IdentitySAMPTProperty#getIdentityName}
             * @param identityName the value to be set. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder identityName(java.lang.String identityName) {
                this.identityName = identityName;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link IdentitySAMPTProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public IdentitySAMPTProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link IdentitySAMPTProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements IdentitySAMPTProperty {
            private final java.lang.String identityName;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.identityName = software.amazon.jsii.Kernel.get(this, "identityName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.identityName = java.util.Objects.requireNonNull(builder.identityName, "identityName is required");
            }

            @Override
            public final java.lang.String getIdentityName() {
                return this.identityName;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("identityName", om.valueToTree(this.getIdentityName()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_sam.CfnFunction.IdentitySAMPTProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                IdentitySAMPTProperty.Jsii$Proxy that = (IdentitySAMPTProperty.Jsii$Proxy) o;

                return this.identityName.equals(that.identityName);
            }

            @Override
            public final int hashCode() {
                int result = this.identityName.hashCode();
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sam.*;
     * ImageConfigProperty imageConfigProperty = ImageConfigProperty.builder()
     *         .command(List.of("command"))
     *         .entryPoint(List.of("entryPoint"))
     *         .workingDirectory("workingDirectory")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-imageconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-imageconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_sam.CfnFunction.ImageConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(ImageConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ImageConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-imageconfig.html#cfn-serverless-function-imageconfig-command">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-imageconfig.html#cfn-serverless-function-imageconfig-command</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getCommand() {
            return null;
        }

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-imageconfig.html#cfn-serverless-function-imageconfig-entrypoint">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-imageconfig.html#cfn-serverless-function-imageconfig-entrypoint</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getEntryPoint() {
            return null;
        }

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-imageconfig.html#cfn-serverless-function-imageconfig-workingdirectory">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-imageconfig.html#cfn-serverless-function-imageconfig-workingdirectory</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getWorkingDirectory() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ImageConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ImageConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ImageConfigProperty> {
            java.util.List<java.lang.String> command;
            java.util.List<java.lang.String> entryPoint;
            java.lang.String workingDirectory;

            /**
             * Sets the value of {@link ImageConfigProperty#getCommand}
             * @param command the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder command(java.util.List<java.lang.String> command) {
                this.command = command;
                return this;
            }

            /**
             * Sets the value of {@link ImageConfigProperty#getEntryPoint}
             * @param entryPoint the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder entryPoint(java.util.List<java.lang.String> entryPoint) {
                this.entryPoint = entryPoint;
                return this;
            }

            /**
             * Sets the value of {@link ImageConfigProperty#getWorkingDirectory}
             * @param workingDirectory the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder workingDirectory(java.lang.String workingDirectory) {
                this.workingDirectory = workingDirectory;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ImageConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ImageConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ImageConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ImageConfigProperty {
            private final java.util.List<java.lang.String> command;
            private final java.util.List<java.lang.String> entryPoint;
            private final java.lang.String workingDirectory;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.command = software.amazon.jsii.Kernel.get(this, "command", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.entryPoint = software.amazon.jsii.Kernel.get(this, "entryPoint", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.workingDirectory = software.amazon.jsii.Kernel.get(this, "workingDirectory", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.command = builder.command;
                this.entryPoint = builder.entryPoint;
                this.workingDirectory = builder.workingDirectory;
            }

            @Override
            public final java.util.List<java.lang.String> getCommand() {
                return this.command;
            }

            @Override
            public final java.util.List<java.lang.String> getEntryPoint() {
                return this.entryPoint;
            }

            @Override
            public final java.lang.String getWorkingDirectory() {
                return this.workingDirectory;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getCommand() != null) {
                    data.set("command", om.valueToTree(this.getCommand()));
                }
                if (this.getEntryPoint() != null) {
                    data.set("entryPoint", om.valueToTree(this.getEntryPoint()));
                }
                if (this.getWorkingDirectory() != null) {
                    data.set("workingDirectory", om.valueToTree(this.getWorkingDirectory()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_sam.CfnFunction.ImageConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ImageConfigProperty.Jsii$Proxy that = (ImageConfigProperty.Jsii$Proxy) o;

                if (this.command != null ? !this.command.equals(that.command) : that.command != null) return false;
                if (this.entryPoint != null ? !this.entryPoint.equals(that.entryPoint) : that.entryPoint != null) return false;
                return this.workingDirectory != null ? this.workingDirectory.equals(that.workingDirectory) : that.workingDirectory == null;
            }

            @Override
            public final int hashCode() {
                int result = this.command != null ? this.command.hashCode() : 0;
                result = 31 * result + (this.entryPoint != null ? this.entryPoint.hashCode() : 0);
                result = 31 * result + (this.workingDirectory != null ? this.workingDirectory.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sam.*;
     * IoTRuleEventProperty ioTRuleEventProperty = IoTRuleEventProperty.builder()
     *         .sql("sql")
     *         // the properties below are optional
     *         .awsIotSqlVersion("awsIotSqlVersion")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-iotruleevent.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-iotruleevent.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_sam.CfnFunction.IoTRuleEventProperty")
    @software.amazon.jsii.Jsii.Proxy(IoTRuleEventProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface IoTRuleEventProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-iotruleevent.html#cfn-serverless-function-iotruleevent-sql">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-iotruleevent.html#cfn-serverless-function-iotruleevent-sql</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getSql();

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-iotruleevent.html#cfn-serverless-function-iotruleevent-awsiotsqlversion">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-iotruleevent.html#cfn-serverless-function-iotruleevent-awsiotsqlversion</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAwsIotSqlVersion() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link IoTRuleEventProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link IoTRuleEventProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<IoTRuleEventProperty> {
            java.lang.String sql;
            java.lang.String awsIotSqlVersion;

            /**
             * Sets the value of {@link IoTRuleEventProperty#getSql}
             * @param sql the value to be set. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sql(java.lang.String sql) {
                this.sql = sql;
                return this;
            }

            /**
             * Sets the value of {@link IoTRuleEventProperty#getAwsIotSqlVersion}
             * @param awsIotSqlVersion the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder awsIotSqlVersion(java.lang.String awsIotSqlVersion) {
                this.awsIotSqlVersion = awsIotSqlVersion;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link IoTRuleEventProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public IoTRuleEventProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link IoTRuleEventProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements IoTRuleEventProperty {
            private final java.lang.String sql;
            private final java.lang.String awsIotSqlVersion;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.sql = software.amazon.jsii.Kernel.get(this, "sql", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.awsIotSqlVersion = software.amazon.jsii.Kernel.get(this, "awsIotSqlVersion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.sql = java.util.Objects.requireNonNull(builder.sql, "sql is required");
                this.awsIotSqlVersion = builder.awsIotSqlVersion;
            }

            @Override
            public final java.lang.String getSql() {
                return this.sql;
            }

            @Override
            public final java.lang.String getAwsIotSqlVersion() {
                return this.awsIotSqlVersion;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("sql", om.valueToTree(this.getSql()));
                if (this.getAwsIotSqlVersion() != null) {
                    data.set("awsIotSqlVersion", om.valueToTree(this.getAwsIotSqlVersion()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_sam.CfnFunction.IoTRuleEventProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                IoTRuleEventProperty.Jsii$Proxy that = (IoTRuleEventProperty.Jsii$Proxy) o;

                if (!sql.equals(that.sql)) return false;
                return this.awsIotSqlVersion != null ? this.awsIotSqlVersion.equals(that.awsIotSqlVersion) : that.awsIotSqlVersion == null;
            }

            @Override
            public final int hashCode() {
                int result = this.sql.hashCode();
                result = 31 * result + (this.awsIotSqlVersion != null ? this.awsIotSqlVersion.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sam.*;
     * KeySAMPTProperty keySAMPTProperty = KeySAMPTProperty.builder()
     *         .keyId("keyId")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-keysampt.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-keysampt.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_sam.CfnFunction.KeySAMPTProperty")
    @software.amazon.jsii.Jsii.Proxy(KeySAMPTProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface KeySAMPTProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-keysampt.html#cfn-serverless-function-keysampt-keyid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-keysampt.html#cfn-serverless-function-keysampt-keyid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getKeyId();

        /**
         * @return a {@link Builder} of {@link KeySAMPTProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link KeySAMPTProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<KeySAMPTProperty> {
            java.lang.String keyId;

            /**
             * Sets the value of {@link KeySAMPTProperty#getKeyId}
             * @param keyId the value to be set. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder keyId(java.lang.String keyId) {
                this.keyId = keyId;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link KeySAMPTProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public KeySAMPTProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link KeySAMPTProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements KeySAMPTProperty {
            private final java.lang.String keyId;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.keyId = software.amazon.jsii.Kernel.get(this, "keyId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.keyId = java.util.Objects.requireNonNull(builder.keyId, "keyId is required");
            }

            @Override
            public final java.lang.String getKeyId() {
                return this.keyId;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("keyId", om.valueToTree(this.getKeyId()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_sam.CfnFunction.KeySAMPTProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                KeySAMPTProperty.Jsii$Proxy that = (KeySAMPTProperty.Jsii$Proxy) o;

                return this.keyId.equals(that.keyId);
            }

            @Override
            public final int hashCode() {
                int result = this.keyId.hashCode();
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sam.*;
     * KinesisEventProperty kinesisEventProperty = KinesisEventProperty.builder()
     *         .startingPosition("startingPosition")
     *         .stream("stream")
     *         // the properties below are optional
     *         .batchSize(123)
     *         .enabled(false)
     *         .functionResponseTypes(List.of("functionResponseTypes"))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-kinesisevent.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-kinesisevent.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_sam.CfnFunction.KinesisEventProperty")
    @software.amazon.jsii.Jsii.Proxy(KinesisEventProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface KinesisEventProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-kinesisevent.html#cfn-serverless-function-kinesisevent-startingposition">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-kinesisevent.html#cfn-serverless-function-kinesisevent-startingposition</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getStartingPosition();

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-kinesisevent.html#cfn-serverless-function-kinesisevent-stream">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-kinesisevent.html#cfn-serverless-function-kinesisevent-stream</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getStream();

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-kinesisevent.html#cfn-serverless-function-kinesisevent-batchsize">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-kinesisevent.html#cfn-serverless-function-kinesisevent-batchsize</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getBatchSize() {
            return null;
        }

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-kinesisevent.html#cfn-serverless-function-kinesisevent-enabled">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-kinesisevent.html#cfn-serverless-function-kinesisevent-enabled</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEnabled() {
            return null;
        }

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-kinesisevent.html#cfn-serverless-function-kinesisevent-functionresponsetypes">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-kinesisevent.html#cfn-serverless-function-kinesisevent-functionresponsetypes</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getFunctionResponseTypes() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link KinesisEventProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link KinesisEventProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<KinesisEventProperty> {
            java.lang.String startingPosition;
            java.lang.String stream;
            java.lang.Number batchSize;
            java.lang.Object enabled;
            java.util.List<java.lang.String> functionResponseTypes;

            /**
             * Sets the value of {@link KinesisEventProperty#getStartingPosition}
             * @param startingPosition the value to be set. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder startingPosition(java.lang.String startingPosition) {
                this.startingPosition = startingPosition;
                return this;
            }

            /**
             * Sets the value of {@link KinesisEventProperty#getStream}
             * @param stream the value to be set. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder stream(java.lang.String stream) {
                this.stream = stream;
                return this;
            }

            /**
             * Sets the value of {@link KinesisEventProperty#getBatchSize}
             * @param batchSize the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder batchSize(java.lang.Number batchSize) {
                this.batchSize = batchSize;
                return this;
            }

            /**
             * Sets the value of {@link KinesisEventProperty#getEnabled}
             * @param enabled the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enabled(java.lang.Boolean enabled) {
                this.enabled = enabled;
                return this;
            }

            /**
             * Sets the value of {@link KinesisEventProperty#getEnabled}
             * @param enabled the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enabled(software.amazon.awscdk.IResolvable enabled) {
                this.enabled = enabled;
                return this;
            }

            /**
             * Sets the value of {@link KinesisEventProperty#getFunctionResponseTypes}
             * @param functionResponseTypes the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder functionResponseTypes(java.util.List<java.lang.String> functionResponseTypes) {
                this.functionResponseTypes = functionResponseTypes;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link KinesisEventProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public KinesisEventProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link KinesisEventProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements KinesisEventProperty {
            private final java.lang.String startingPosition;
            private final java.lang.String stream;
            private final java.lang.Number batchSize;
            private final java.lang.Object enabled;
            private final java.util.List<java.lang.String> functionResponseTypes;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.startingPosition = software.amazon.jsii.Kernel.get(this, "startingPosition", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.stream = software.amazon.jsii.Kernel.get(this, "stream", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.batchSize = software.amazon.jsii.Kernel.get(this, "batchSize", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.enabled = software.amazon.jsii.Kernel.get(this, "enabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.functionResponseTypes = software.amazon.jsii.Kernel.get(this, "functionResponseTypes", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.startingPosition = java.util.Objects.requireNonNull(builder.startingPosition, "startingPosition is required");
                this.stream = java.util.Objects.requireNonNull(builder.stream, "stream is required");
                this.batchSize = builder.batchSize;
                this.enabled = builder.enabled;
                this.functionResponseTypes = builder.functionResponseTypes;
            }

            @Override
            public final java.lang.String getStartingPosition() {
                return this.startingPosition;
            }

            @Override
            public final java.lang.String getStream() {
                return this.stream;
            }

            @Override
            public final java.lang.Number getBatchSize() {
                return this.batchSize;
            }

            @Override
            public final java.lang.Object getEnabled() {
                return this.enabled;
            }

            @Override
            public final java.util.List<java.lang.String> getFunctionResponseTypes() {
                return this.functionResponseTypes;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("startingPosition", om.valueToTree(this.getStartingPosition()));
                data.set("stream", om.valueToTree(this.getStream()));
                if (this.getBatchSize() != null) {
                    data.set("batchSize", om.valueToTree(this.getBatchSize()));
                }
                if (this.getEnabled() != null) {
                    data.set("enabled", om.valueToTree(this.getEnabled()));
                }
                if (this.getFunctionResponseTypes() != null) {
                    data.set("functionResponseTypes", om.valueToTree(this.getFunctionResponseTypes()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_sam.CfnFunction.KinesisEventProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                KinesisEventProperty.Jsii$Proxy that = (KinesisEventProperty.Jsii$Proxy) o;

                if (!startingPosition.equals(that.startingPosition)) return false;
                if (!stream.equals(that.stream)) return false;
                if (this.batchSize != null ? !this.batchSize.equals(that.batchSize) : that.batchSize != null) return false;
                if (this.enabled != null ? !this.enabled.equals(that.enabled) : that.enabled != null) return false;
                return this.functionResponseTypes != null ? this.functionResponseTypes.equals(that.functionResponseTypes) : that.functionResponseTypes == null;
            }

            @Override
            public final int hashCode() {
                int result = this.startingPosition.hashCode();
                result = 31 * result + (this.stream.hashCode());
                result = 31 * result + (this.batchSize != null ? this.batchSize.hashCode() : 0);
                result = 31 * result + (this.enabled != null ? this.enabled.hashCode() : 0);
                result = 31 * result + (this.functionResponseTypes != null ? this.functionResponseTypes.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sam.*;
     * LogGroupSAMPTProperty logGroupSAMPTProperty = LogGroupSAMPTProperty.builder()
     *         .logGroupName("logGroupName")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-loggroupsampt.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-loggroupsampt.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_sam.CfnFunction.LogGroupSAMPTProperty")
    @software.amazon.jsii.Jsii.Proxy(LogGroupSAMPTProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface LogGroupSAMPTProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-loggroupsampt.html#cfn-serverless-function-loggroupsampt-loggroupname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-loggroupsampt.html#cfn-serverless-function-loggroupsampt-loggroupname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getLogGroupName();

        /**
         * @return a {@link Builder} of {@link LogGroupSAMPTProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link LogGroupSAMPTProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<LogGroupSAMPTProperty> {
            java.lang.String logGroupName;

            /**
             * Sets the value of {@link LogGroupSAMPTProperty#getLogGroupName}
             * @param logGroupName the value to be set. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder logGroupName(java.lang.String logGroupName) {
                this.logGroupName = logGroupName;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link LogGroupSAMPTProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public LogGroupSAMPTProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link LogGroupSAMPTProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements LogGroupSAMPTProperty {
            private final java.lang.String logGroupName;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.logGroupName = software.amazon.jsii.Kernel.get(this, "logGroupName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.logGroupName = java.util.Objects.requireNonNull(builder.logGroupName, "logGroupName is required");
            }

            @Override
            public final java.lang.String getLogGroupName() {
                return this.logGroupName;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("logGroupName", om.valueToTree(this.getLogGroupName()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_sam.CfnFunction.LogGroupSAMPTProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                LogGroupSAMPTProperty.Jsii$Proxy that = (LogGroupSAMPTProperty.Jsii$Proxy) o;

                return this.logGroupName.equals(that.logGroupName);
            }

            @Override
            public final int hashCode() {
                int result = this.logGroupName.hashCode();
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sam.*;
     * ParameterNameSAMPTProperty parameterNameSAMPTProperty = ParameterNameSAMPTProperty.builder()
     *         .parameterName("parameterName")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-parameternamesampt.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-parameternamesampt.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_sam.CfnFunction.ParameterNameSAMPTProperty")
    @software.amazon.jsii.Jsii.Proxy(ParameterNameSAMPTProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ParameterNameSAMPTProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-parameternamesampt.html#cfn-serverless-function-parameternamesampt-parametername">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-parameternamesampt.html#cfn-serverless-function-parameternamesampt-parametername</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getParameterName();

        /**
         * @return a {@link Builder} of {@link ParameterNameSAMPTProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ParameterNameSAMPTProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ParameterNameSAMPTProperty> {
            java.lang.String parameterName;

            /**
             * Sets the value of {@link ParameterNameSAMPTProperty#getParameterName}
             * @param parameterName the value to be set. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder parameterName(java.lang.String parameterName) {
                this.parameterName = parameterName;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ParameterNameSAMPTProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ParameterNameSAMPTProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ParameterNameSAMPTProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ParameterNameSAMPTProperty {
            private final java.lang.String parameterName;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.parameterName = software.amazon.jsii.Kernel.get(this, "parameterName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.parameterName = java.util.Objects.requireNonNull(builder.parameterName, "parameterName is required");
            }

            @Override
            public final java.lang.String getParameterName() {
                return this.parameterName;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("parameterName", om.valueToTree(this.getParameterName()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_sam.CfnFunction.ParameterNameSAMPTProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ParameterNameSAMPTProperty.Jsii$Proxy that = (ParameterNameSAMPTProperty.Jsii$Proxy) o;

                return this.parameterName.equals(that.parameterName);
            }

            @Override
            public final int hashCode() {
                int result = this.parameterName.hashCode();
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sam.*;
     * ProvisionedConcurrencyConfigProperty provisionedConcurrencyConfigProperty = ProvisionedConcurrencyConfigProperty.builder()
     *         .provisionedConcurrentExecutions("provisionedConcurrentExecutions")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-provisionedconcurrencyconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-provisionedconcurrencyconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_sam.CfnFunction.ProvisionedConcurrencyConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(ProvisionedConcurrencyConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ProvisionedConcurrencyConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-provisionedconcurrencyconfig.html#cfn-serverless-function-provisionedconcurrencyconfig-provisionedconcurrentexecutions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-provisionedconcurrencyconfig.html#cfn-serverless-function-provisionedconcurrencyconfig-provisionedconcurrentexecutions</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getProvisionedConcurrentExecutions();

        /**
         * @return a {@link Builder} of {@link ProvisionedConcurrencyConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ProvisionedConcurrencyConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ProvisionedConcurrencyConfigProperty> {
            java.lang.String provisionedConcurrentExecutions;

            /**
             * Sets the value of {@link ProvisionedConcurrencyConfigProperty#getProvisionedConcurrentExecutions}
             * @param provisionedConcurrentExecutions the value to be set. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder provisionedConcurrentExecutions(java.lang.String provisionedConcurrentExecutions) {
                this.provisionedConcurrentExecutions = provisionedConcurrentExecutions;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ProvisionedConcurrencyConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ProvisionedConcurrencyConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ProvisionedConcurrencyConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ProvisionedConcurrencyConfigProperty {
            private final java.lang.String provisionedConcurrentExecutions;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.provisionedConcurrentExecutions = software.amazon.jsii.Kernel.get(this, "provisionedConcurrentExecutions", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.provisionedConcurrentExecutions = java.util.Objects.requireNonNull(builder.provisionedConcurrentExecutions, "provisionedConcurrentExecutions is required");
            }

            @Override
            public final java.lang.String getProvisionedConcurrentExecutions() {
                return this.provisionedConcurrentExecutions;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("provisionedConcurrentExecutions", om.valueToTree(this.getProvisionedConcurrentExecutions()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_sam.CfnFunction.ProvisionedConcurrencyConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ProvisionedConcurrencyConfigProperty.Jsii$Proxy that = (ProvisionedConcurrencyConfigProperty.Jsii$Proxy) o;

                return this.provisionedConcurrentExecutions.equals(that.provisionedConcurrentExecutions);
            }

            @Override
            public final int hashCode() {
                int result = this.provisionedConcurrentExecutions.hashCode();
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sam.*;
     * QueueSAMPTProperty queueSAMPTProperty = QueueSAMPTProperty.builder()
     *         .queueName("queueName")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-queuesampt.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-queuesampt.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_sam.CfnFunction.QueueSAMPTProperty")
    @software.amazon.jsii.Jsii.Proxy(QueueSAMPTProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface QueueSAMPTProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-queuesampt.html#cfn-serverless-function-queuesampt-queuename">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-queuesampt.html#cfn-serverless-function-queuesampt-queuename</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getQueueName();

        /**
         * @return a {@link Builder} of {@link QueueSAMPTProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link QueueSAMPTProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<QueueSAMPTProperty> {
            java.lang.String queueName;

            /**
             * Sets the value of {@link QueueSAMPTProperty#getQueueName}
             * @param queueName the value to be set. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder queueName(java.lang.String queueName) {
                this.queueName = queueName;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link QueueSAMPTProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public QueueSAMPTProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link QueueSAMPTProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements QueueSAMPTProperty {
            private final java.lang.String queueName;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.queueName = software.amazon.jsii.Kernel.get(this, "queueName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.queueName = java.util.Objects.requireNonNull(builder.queueName, "queueName is required");
            }

            @Override
            public final java.lang.String getQueueName() {
                return this.queueName;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("queueName", om.valueToTree(this.getQueueName()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_sam.CfnFunction.QueueSAMPTProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                QueueSAMPTProperty.Jsii$Proxy that = (QueueSAMPTProperty.Jsii$Proxy) o;

                return this.queueName.equals(that.queueName);
            }

            @Override
            public final int hashCode() {
                int result = this.queueName.hashCode();
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sam.*;
     * RequestModelProperty requestModelProperty = RequestModelProperty.builder()
     *         .model("model")
     *         // the properties below are optional
     *         .required(false)
     *         .validateBody(false)
     *         .validateParameters(false)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-requestmodel.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-requestmodel.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_sam.CfnFunction.RequestModelProperty")
    @software.amazon.jsii.Jsii.Proxy(RequestModelProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface RequestModelProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-requestmodel.html#cfn-serverless-function-requestmodel-model">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-requestmodel.html#cfn-serverless-function-requestmodel-model</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getModel();

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-requestmodel.html#cfn-serverless-function-requestmodel-required">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-requestmodel.html#cfn-serverless-function-requestmodel-required</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getRequired() {
            return null;
        }

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-requestmodel.html#cfn-serverless-function-requestmodel-validatebody">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-requestmodel.html#cfn-serverless-function-requestmodel-validatebody</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getValidateBody() {
            return null;
        }

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-requestmodel.html#cfn-serverless-function-requestmodel-validateparameters">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-requestmodel.html#cfn-serverless-function-requestmodel-validateparameters</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getValidateParameters() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link RequestModelProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link RequestModelProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<RequestModelProperty> {
            java.lang.String model;
            java.lang.Object required;
            java.lang.Object validateBody;
            java.lang.Object validateParameters;

            /**
             * Sets the value of {@link RequestModelProperty#getModel}
             * @param model the value to be set. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder model(java.lang.String model) {
                this.model = model;
                return this;
            }

            /**
             * Sets the value of {@link RequestModelProperty#getRequired}
             * @param required the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder required(java.lang.Boolean required) {
                this.required = required;
                return this;
            }

            /**
             * Sets the value of {@link RequestModelProperty#getRequired}
             * @param required the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder required(software.amazon.awscdk.IResolvable required) {
                this.required = required;
                return this;
            }

            /**
             * Sets the value of {@link RequestModelProperty#getValidateBody}
             * @param validateBody the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder validateBody(java.lang.Boolean validateBody) {
                this.validateBody = validateBody;
                return this;
            }

            /**
             * Sets the value of {@link RequestModelProperty#getValidateBody}
             * @param validateBody the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder validateBody(software.amazon.awscdk.IResolvable validateBody) {
                this.validateBody = validateBody;
                return this;
            }

            /**
             * Sets the value of {@link RequestModelProperty#getValidateParameters}
             * @param validateParameters the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder validateParameters(java.lang.Boolean validateParameters) {
                this.validateParameters = validateParameters;
                return this;
            }

            /**
             * Sets the value of {@link RequestModelProperty#getValidateParameters}
             * @param validateParameters the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder validateParameters(software.amazon.awscdk.IResolvable validateParameters) {
                this.validateParameters = validateParameters;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RequestModelProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public RequestModelProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link RequestModelProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RequestModelProperty {
            private final java.lang.String model;
            private final java.lang.Object required;
            private final java.lang.Object validateBody;
            private final java.lang.Object validateParameters;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.model = software.amazon.jsii.Kernel.get(this, "model", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.required = software.amazon.jsii.Kernel.get(this, "required", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.validateBody = software.amazon.jsii.Kernel.get(this, "validateBody", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.validateParameters = software.amazon.jsii.Kernel.get(this, "validateParameters", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.model = java.util.Objects.requireNonNull(builder.model, "model is required");
                this.required = builder.required;
                this.validateBody = builder.validateBody;
                this.validateParameters = builder.validateParameters;
            }

            @Override
            public final java.lang.String getModel() {
                return this.model;
            }

            @Override
            public final java.lang.Object getRequired() {
                return this.required;
            }

            @Override
            public final java.lang.Object getValidateBody() {
                return this.validateBody;
            }

            @Override
            public final java.lang.Object getValidateParameters() {
                return this.validateParameters;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("model", om.valueToTree(this.getModel()));
                if (this.getRequired() != null) {
                    data.set("required", om.valueToTree(this.getRequired()));
                }
                if (this.getValidateBody() != null) {
                    data.set("validateBody", om.valueToTree(this.getValidateBody()));
                }
                if (this.getValidateParameters() != null) {
                    data.set("validateParameters", om.valueToTree(this.getValidateParameters()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_sam.CfnFunction.RequestModelProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                RequestModelProperty.Jsii$Proxy that = (RequestModelProperty.Jsii$Proxy) o;

                if (!model.equals(that.model)) return false;
                if (this.required != null ? !this.required.equals(that.required) : that.required != null) return false;
                if (this.validateBody != null ? !this.validateBody.equals(that.validateBody) : that.validateBody != null) return false;
                return this.validateParameters != null ? this.validateParameters.equals(that.validateParameters) : that.validateParameters == null;
            }

            @Override
            public final int hashCode() {
                int result = this.model.hashCode();
                result = 31 * result + (this.required != null ? this.required.hashCode() : 0);
                result = 31 * result + (this.validateBody != null ? this.validateBody.hashCode() : 0);
                result = 31 * result + (this.validateParameters != null ? this.validateParameters.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sam.*;
     * RequestParameterProperty requestParameterProperty = RequestParameterProperty.builder()
     *         .caching(false)
     *         .required(false)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-requestparameter.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-requestparameter.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_sam.CfnFunction.RequestParameterProperty")
    @software.amazon.jsii.Jsii.Proxy(RequestParameterProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface RequestParameterProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-requestparameter.html#cfn-serverless-function-requestparameter-caching">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-requestparameter.html#cfn-serverless-function-requestparameter-caching</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCaching() {
            return null;
        }

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-requestparameter.html#cfn-serverless-function-requestparameter-required">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-requestparameter.html#cfn-serverless-function-requestparameter-required</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getRequired() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link RequestParameterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link RequestParameterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<RequestParameterProperty> {
            java.lang.Object caching;
            java.lang.Object required;

            /**
             * Sets the value of {@link RequestParameterProperty#getCaching}
             * @param caching the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder caching(java.lang.Boolean caching) {
                this.caching = caching;
                return this;
            }

            /**
             * Sets the value of {@link RequestParameterProperty#getCaching}
             * @param caching the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder caching(software.amazon.awscdk.IResolvable caching) {
                this.caching = caching;
                return this;
            }

            /**
             * Sets the value of {@link RequestParameterProperty#getRequired}
             * @param required the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder required(java.lang.Boolean required) {
                this.required = required;
                return this;
            }

            /**
             * Sets the value of {@link RequestParameterProperty#getRequired}
             * @param required the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder required(software.amazon.awscdk.IResolvable required) {
                this.required = required;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RequestParameterProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public RequestParameterProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link RequestParameterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RequestParameterProperty {
            private final java.lang.Object caching;
            private final java.lang.Object required;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.caching = software.amazon.jsii.Kernel.get(this, "caching", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.required = software.amazon.jsii.Kernel.get(this, "required", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.caching = builder.caching;
                this.required = builder.required;
            }

            @Override
            public final java.lang.Object getCaching() {
                return this.caching;
            }

            @Override
            public final java.lang.Object getRequired() {
                return this.required;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getCaching() != null) {
                    data.set("caching", om.valueToTree(this.getCaching()));
                }
                if (this.getRequired() != null) {
                    data.set("required", om.valueToTree(this.getRequired()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_sam.CfnFunction.RequestParameterProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                RequestParameterProperty.Jsii$Proxy that = (RequestParameterProperty.Jsii$Proxy) o;

                if (this.caching != null ? !this.caching.equals(that.caching) : that.caching != null) return false;
                return this.required != null ? this.required.equals(that.required) : that.required == null;
            }

            @Override
            public final int hashCode() {
                int result = this.caching != null ? this.caching.hashCode() : 0;
                result = 31 * result + (this.required != null ? this.required.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sam.*;
     * RouteSettingsProperty routeSettingsProperty = RouteSettingsProperty.builder()
     *         .dataTraceEnabled(false)
     *         .detailedMetricsEnabled(false)
     *         .loggingLevel("loggingLevel")
     *         .throttlingBurstLimit(123)
     *         .throttlingRateLimit(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-routesettings.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-routesettings.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_sam.CfnFunction.RouteSettingsProperty")
    @software.amazon.jsii.Jsii.Proxy(RouteSettingsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface RouteSettingsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-routesettings.html#cfn-serverless-function-routesettings-datatraceenabled">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-routesettings.html#cfn-serverless-function-routesettings-datatraceenabled</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDataTraceEnabled() {
            return null;
        }

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-routesettings.html#cfn-serverless-function-routesettings-detailedmetricsenabled">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-routesettings.html#cfn-serverless-function-routesettings-detailedmetricsenabled</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDetailedMetricsEnabled() {
            return null;
        }

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-routesettings.html#cfn-serverless-function-routesettings-logginglevel">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-routesettings.html#cfn-serverless-function-routesettings-logginglevel</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getLoggingLevel() {
            return null;
        }

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-routesettings.html#cfn-serverless-function-routesettings-throttlingburstlimit">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-routesettings.html#cfn-serverless-function-routesettings-throttlingburstlimit</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getThrottlingBurstLimit() {
            return null;
        }

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-routesettings.html#cfn-serverless-function-routesettings-throttlingratelimit">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-routesettings.html#cfn-serverless-function-routesettings-throttlingratelimit</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getThrottlingRateLimit() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link RouteSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link RouteSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<RouteSettingsProperty> {
            java.lang.Object dataTraceEnabled;
            java.lang.Object detailedMetricsEnabled;
            java.lang.String loggingLevel;
            java.lang.Number throttlingBurstLimit;
            java.lang.Number throttlingRateLimit;

            /**
             * Sets the value of {@link RouteSettingsProperty#getDataTraceEnabled}
             * @param dataTraceEnabled the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dataTraceEnabled(java.lang.Boolean dataTraceEnabled) {
                this.dataTraceEnabled = dataTraceEnabled;
                return this;
            }

            /**
             * Sets the value of {@link RouteSettingsProperty#getDataTraceEnabled}
             * @param dataTraceEnabled the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dataTraceEnabled(software.amazon.awscdk.IResolvable dataTraceEnabled) {
                this.dataTraceEnabled = dataTraceEnabled;
                return this;
            }

            /**
             * Sets the value of {@link RouteSettingsProperty#getDetailedMetricsEnabled}
             * @param detailedMetricsEnabled the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder detailedMetricsEnabled(java.lang.Boolean detailedMetricsEnabled) {
                this.detailedMetricsEnabled = detailedMetricsEnabled;
                return this;
            }

            /**
             * Sets the value of {@link RouteSettingsProperty#getDetailedMetricsEnabled}
             * @param detailedMetricsEnabled the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder detailedMetricsEnabled(software.amazon.awscdk.IResolvable detailedMetricsEnabled) {
                this.detailedMetricsEnabled = detailedMetricsEnabled;
                return this;
            }

            /**
             * Sets the value of {@link RouteSettingsProperty#getLoggingLevel}
             * @param loggingLevel the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder loggingLevel(java.lang.String loggingLevel) {
                this.loggingLevel = loggingLevel;
                return this;
            }

            /**
             * Sets the value of {@link RouteSettingsProperty#getThrottlingBurstLimit}
             * @param throttlingBurstLimit the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder throttlingBurstLimit(java.lang.Number throttlingBurstLimit) {
                this.throttlingBurstLimit = throttlingBurstLimit;
                return this;
            }

            /**
             * Sets the value of {@link RouteSettingsProperty#getThrottlingRateLimit}
             * @param throttlingRateLimit the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder throttlingRateLimit(java.lang.Number throttlingRateLimit) {
                this.throttlingRateLimit = throttlingRateLimit;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RouteSettingsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public RouteSettingsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link RouteSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RouteSettingsProperty {
            private final java.lang.Object dataTraceEnabled;
            private final java.lang.Object detailedMetricsEnabled;
            private final java.lang.String loggingLevel;
            private final java.lang.Number throttlingBurstLimit;
            private final java.lang.Number throttlingRateLimit;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.dataTraceEnabled = software.amazon.jsii.Kernel.get(this, "dataTraceEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.detailedMetricsEnabled = software.amazon.jsii.Kernel.get(this, "detailedMetricsEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.loggingLevel = software.amazon.jsii.Kernel.get(this, "loggingLevel", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.throttlingBurstLimit = software.amazon.jsii.Kernel.get(this, "throttlingBurstLimit", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.throttlingRateLimit = software.amazon.jsii.Kernel.get(this, "throttlingRateLimit", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.dataTraceEnabled = builder.dataTraceEnabled;
                this.detailedMetricsEnabled = builder.detailedMetricsEnabled;
                this.loggingLevel = builder.loggingLevel;
                this.throttlingBurstLimit = builder.throttlingBurstLimit;
                this.throttlingRateLimit = builder.throttlingRateLimit;
            }

            @Override
            public final java.lang.Object getDataTraceEnabled() {
                return this.dataTraceEnabled;
            }

            @Override
            public final java.lang.Object getDetailedMetricsEnabled() {
                return this.detailedMetricsEnabled;
            }

            @Override
            public final java.lang.String getLoggingLevel() {
                return this.loggingLevel;
            }

            @Override
            public final java.lang.Number getThrottlingBurstLimit() {
                return this.throttlingBurstLimit;
            }

            @Override
            public final java.lang.Number getThrottlingRateLimit() {
                return this.throttlingRateLimit;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getDataTraceEnabled() != null) {
                    data.set("dataTraceEnabled", om.valueToTree(this.getDataTraceEnabled()));
                }
                if (this.getDetailedMetricsEnabled() != null) {
                    data.set("detailedMetricsEnabled", om.valueToTree(this.getDetailedMetricsEnabled()));
                }
                if (this.getLoggingLevel() != null) {
                    data.set("loggingLevel", om.valueToTree(this.getLoggingLevel()));
                }
                if (this.getThrottlingBurstLimit() != null) {
                    data.set("throttlingBurstLimit", om.valueToTree(this.getThrottlingBurstLimit()));
                }
                if (this.getThrottlingRateLimit() != null) {
                    data.set("throttlingRateLimit", om.valueToTree(this.getThrottlingRateLimit()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_sam.CfnFunction.RouteSettingsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                RouteSettingsProperty.Jsii$Proxy that = (RouteSettingsProperty.Jsii$Proxy) o;

                if (this.dataTraceEnabled != null ? !this.dataTraceEnabled.equals(that.dataTraceEnabled) : that.dataTraceEnabled != null) return false;
                if (this.detailedMetricsEnabled != null ? !this.detailedMetricsEnabled.equals(that.detailedMetricsEnabled) : that.detailedMetricsEnabled != null) return false;
                if (this.loggingLevel != null ? !this.loggingLevel.equals(that.loggingLevel) : that.loggingLevel != null) return false;
                if (this.throttlingBurstLimit != null ? !this.throttlingBurstLimit.equals(that.throttlingBurstLimit) : that.throttlingBurstLimit != null) return false;
                return this.throttlingRateLimit != null ? this.throttlingRateLimit.equals(that.throttlingRateLimit) : that.throttlingRateLimit == null;
            }

            @Override
            public final int hashCode() {
                int result = this.dataTraceEnabled != null ? this.dataTraceEnabled.hashCode() : 0;
                result = 31 * result + (this.detailedMetricsEnabled != null ? this.detailedMetricsEnabled.hashCode() : 0);
                result = 31 * result + (this.loggingLevel != null ? this.loggingLevel.hashCode() : 0);
                result = 31 * result + (this.throttlingBurstLimit != null ? this.throttlingBurstLimit.hashCode() : 0);
                result = 31 * result + (this.throttlingRateLimit != null ? this.throttlingRateLimit.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sam.*;
     * S3EventProperty s3EventProperty = S3EventProperty.builder()
     *         .bucket("bucket")
     *         .events("events")
     *         // the properties below are optional
     *         .filter(S3NotificationFilterProperty.builder()
     *                 .s3Key(S3KeyFilterProperty.builder()
     *                         .rules(List.of(S3KeyFilterRuleProperty.builder()
     *                                 .name("name")
     *                                 .value("value")
     *                                 .build()))
     *                         .build())
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-s3event.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-s3event.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_sam.CfnFunction.S3EventProperty")
    @software.amazon.jsii.Jsii.Proxy(S3EventProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface S3EventProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-s3event.html#cfn-serverless-function-s3event-bucket">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-s3event.html#cfn-serverless-function-s3event-bucket</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getBucket();

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-s3event.html#cfn-serverless-function-s3event-events">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-s3event.html#cfn-serverless-function-s3event-events</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getEvents();

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-s3event.html#cfn-serverless-function-s3event-filter">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-s3event.html#cfn-serverless-function-s3event-filter</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getFilter() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link S3EventProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link S3EventProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<S3EventProperty> {
            java.lang.String bucket;
            java.lang.String events;
            java.lang.Object filter;

            /**
             * Sets the value of {@link S3EventProperty#getBucket}
             * @param bucket the value to be set. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder bucket(java.lang.String bucket) {
                this.bucket = bucket;
                return this;
            }

            /**
             * Sets the value of {@link S3EventProperty#getEvents}
             * @param events the value to be set. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder events(java.lang.String events) {
                this.events = events;
                return this;
            }

            /**
             * Sets the value of {@link S3EventProperty#getFilter}
             * @param filter the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder filter(software.amazon.awscdk.IResolvable filter) {
                this.filter = filter;
                return this;
            }

            /**
             * Sets the value of {@link S3EventProperty#getFilter}
             * @param filter the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder filter(software.amazon.awscdk.services.sam.CfnFunction.S3NotificationFilterProperty filter) {
                this.filter = filter;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link S3EventProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public S3EventProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link S3EventProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements S3EventProperty {
            private final java.lang.String bucket;
            private final java.lang.String events;
            private final java.lang.Object filter;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.bucket = software.amazon.jsii.Kernel.get(this, "bucket", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.events = software.amazon.jsii.Kernel.get(this, "events", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.filter = software.amazon.jsii.Kernel.get(this, "filter", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.bucket = java.util.Objects.requireNonNull(builder.bucket, "bucket is required");
                this.events = java.util.Objects.requireNonNull(builder.events, "events is required");
                this.filter = builder.filter;
            }

            @Override
            public final java.lang.String getBucket() {
                return this.bucket;
            }

            @Override
            public final java.lang.String getEvents() {
                return this.events;
            }

            @Override
            public final java.lang.Object getFilter() {
                return this.filter;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("bucket", om.valueToTree(this.getBucket()));
                data.set("events", om.valueToTree(this.getEvents()));
                if (this.getFilter() != null) {
                    data.set("filter", om.valueToTree(this.getFilter()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_sam.CfnFunction.S3EventProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                S3EventProperty.Jsii$Proxy that = (S3EventProperty.Jsii$Proxy) o;

                if (!bucket.equals(that.bucket)) return false;
                if (!events.equals(that.events)) return false;
                return this.filter != null ? this.filter.equals(that.filter) : that.filter == null;
            }

            @Override
            public final int hashCode() {
                int result = this.bucket.hashCode();
                result = 31 * result + (this.events.hashCode());
                result = 31 * result + (this.filter != null ? this.filter.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sam.*;
     * S3KeyFilterProperty s3KeyFilterProperty = S3KeyFilterProperty.builder()
     *         .rules(List.of(S3KeyFilterRuleProperty.builder()
     *                 .name("name")
     *                 .value("value")
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-s3keyfilter.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-s3keyfilter.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_sam.CfnFunction.S3KeyFilterProperty")
    @software.amazon.jsii.Jsii.Proxy(S3KeyFilterProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface S3KeyFilterProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-s3keyfilter.html#cfn-serverless-function-s3keyfilter-rules">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-s3keyfilter.html#cfn-serverless-function-s3keyfilter-rules</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getRules();

        /**
         * @return a {@link Builder} of {@link S3KeyFilterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link S3KeyFilterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<S3KeyFilterProperty> {
            java.lang.Object rules;

            /**
             * Sets the value of {@link S3KeyFilterProperty#getRules}
             * @param rules the value to be set. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder rules(software.amazon.awscdk.IResolvable rules) {
                this.rules = rules;
                return this;
            }

            /**
             * Sets the value of {@link S3KeyFilterProperty#getRules}
             * @param rules the value to be set. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder rules(java.util.List<? extends java.lang.Object> rules) {
                this.rules = rules;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link S3KeyFilterProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public S3KeyFilterProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link S3KeyFilterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements S3KeyFilterProperty {
            private final java.lang.Object rules;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.rules = software.amazon.jsii.Kernel.get(this, "rules", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.rules = java.util.Objects.requireNonNull(builder.rules, "rules is required");
            }

            @Override
            public final java.lang.Object getRules() {
                return this.rules;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("rules", om.valueToTree(this.getRules()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_sam.CfnFunction.S3KeyFilterProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                S3KeyFilterProperty.Jsii$Proxy that = (S3KeyFilterProperty.Jsii$Proxy) o;

                return this.rules.equals(that.rules);
            }

            @Override
            public final int hashCode() {
                int result = this.rules.hashCode();
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sam.*;
     * S3KeyFilterRuleProperty s3KeyFilterRuleProperty = S3KeyFilterRuleProperty.builder()
     *         .name("name")
     *         .value("value")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-s3keyfilterrule.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-s3keyfilterrule.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_sam.CfnFunction.S3KeyFilterRuleProperty")
    @software.amazon.jsii.Jsii.Proxy(S3KeyFilterRuleProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface S3KeyFilterRuleProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-s3keyfilterrule.html#cfn-serverless-function-s3keyfilterrule-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-s3keyfilterrule.html#cfn-serverless-function-s3keyfilterrule-name</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getName();

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-s3keyfilterrule.html#cfn-serverless-function-s3keyfilterrule-value">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-s3keyfilterrule.html#cfn-serverless-function-s3keyfilterrule-value</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getValue();

        /**
         * @return a {@link Builder} of {@link S3KeyFilterRuleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link S3KeyFilterRuleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<S3KeyFilterRuleProperty> {
            java.lang.String name;
            java.lang.String value;

            /**
             * Sets the value of {@link S3KeyFilterRuleProperty#getName}
             * @param name the value to be set. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Sets the value of {@link S3KeyFilterRuleProperty#getValue}
             * @param value the value to be set. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder value(java.lang.String value) {
                this.value = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link S3KeyFilterRuleProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public S3KeyFilterRuleProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link S3KeyFilterRuleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements S3KeyFilterRuleProperty {
            private final java.lang.String name;
            private final java.lang.String value;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.value = software.amazon.jsii.Kernel.get(this, "value", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
                this.value = java.util.Objects.requireNonNull(builder.value, "value is required");
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            public final java.lang.String getValue() {
                return this.value;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("name", om.valueToTree(this.getName()));
                data.set("value", om.valueToTree(this.getValue()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_sam.CfnFunction.S3KeyFilterRuleProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                S3KeyFilterRuleProperty.Jsii$Proxy that = (S3KeyFilterRuleProperty.Jsii$Proxy) o;

                if (!name.equals(that.name)) return false;
                return this.value.equals(that.value);
            }

            @Override
            public final int hashCode() {
                int result = this.name.hashCode();
                result = 31 * result + (this.value.hashCode());
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sam.*;
     * S3LocationProperty s3LocationProperty = S3LocationProperty.builder()
     *         .bucket("bucket")
     *         .key("key")
     *         // the properties below are optional
     *         .version(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-s3location.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-s3location.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_sam.CfnFunction.S3LocationProperty")
    @software.amazon.jsii.Jsii.Proxy(S3LocationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface S3LocationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-s3location.html#cfn-serverless-function-s3location-bucket">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-s3location.html#cfn-serverless-function-s3location-bucket</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getBucket();

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-s3location.html#cfn-serverless-function-s3location-key">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-s3location.html#cfn-serverless-function-s3location-key</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getKey();

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-s3location.html#cfn-serverless-function-s3location-version">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-s3location.html#cfn-serverless-function-s3location-version</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getVersion() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link S3LocationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link S3LocationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<S3LocationProperty> {
            java.lang.String bucket;
            java.lang.String key;
            java.lang.Number version;

            /**
             * Sets the value of {@link S3LocationProperty#getBucket}
             * @param bucket the value to be set. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder bucket(java.lang.String bucket) {
                this.bucket = bucket;
                return this;
            }

            /**
             * Sets the value of {@link S3LocationProperty#getKey}
             * @param key the value to be set. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder key(java.lang.String key) {
                this.key = key;
                return this;
            }

            /**
             * Sets the value of {@link S3LocationProperty#getVersion}
             * @param version the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder version(java.lang.Number version) {
                this.version = version;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link S3LocationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public S3LocationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link S3LocationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements S3LocationProperty {
            private final java.lang.String bucket;
            private final java.lang.String key;
            private final java.lang.Number version;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.bucket = software.amazon.jsii.Kernel.get(this, "bucket", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.key = software.amazon.jsii.Kernel.get(this, "key", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.version = software.amazon.jsii.Kernel.get(this, "version", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.bucket = java.util.Objects.requireNonNull(builder.bucket, "bucket is required");
                this.key = java.util.Objects.requireNonNull(builder.key, "key is required");
                this.version = builder.version;
            }

            @Override
            public final java.lang.String getBucket() {
                return this.bucket;
            }

            @Override
            public final java.lang.String getKey() {
                return this.key;
            }

            @Override
            public final java.lang.Number getVersion() {
                return this.version;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("bucket", om.valueToTree(this.getBucket()));
                data.set("key", om.valueToTree(this.getKey()));
                if (this.getVersion() != null) {
                    data.set("version", om.valueToTree(this.getVersion()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_sam.CfnFunction.S3LocationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                S3LocationProperty.Jsii$Proxy that = (S3LocationProperty.Jsii$Proxy) o;

                if (!bucket.equals(that.bucket)) return false;
                if (!key.equals(that.key)) return false;
                return this.version != null ? this.version.equals(that.version) : that.version == null;
            }

            @Override
            public final int hashCode() {
                int result = this.bucket.hashCode();
                result = 31 * result + (this.key.hashCode());
                result = 31 * result + (this.version != null ? this.version.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sam.*;
     * S3NotificationFilterProperty s3NotificationFilterProperty = S3NotificationFilterProperty.builder()
     *         .s3Key(S3KeyFilterProperty.builder()
     *                 .rules(List.of(S3KeyFilterRuleProperty.builder()
     *                         .name("name")
     *                         .value("value")
     *                         .build()))
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-s3notificationfilter.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-s3notificationfilter.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_sam.CfnFunction.S3NotificationFilterProperty")
    @software.amazon.jsii.Jsii.Proxy(S3NotificationFilterProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface S3NotificationFilterProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-s3notificationfilter.html#cfn-serverless-function-s3notificationfilter-s3key">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-s3notificationfilter.html#cfn-serverless-function-s3notificationfilter-s3key</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getS3Key();

        /**
         * @return a {@link Builder} of {@link S3NotificationFilterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link S3NotificationFilterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<S3NotificationFilterProperty> {
            java.lang.Object s3Key;

            /**
             * Sets the value of {@link S3NotificationFilterProperty#getS3Key}
             * @param s3Key the value to be set. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3Key(software.amazon.awscdk.IResolvable s3Key) {
                this.s3Key = s3Key;
                return this;
            }

            /**
             * Sets the value of {@link S3NotificationFilterProperty#getS3Key}
             * @param s3Key the value to be set. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3Key(software.amazon.awscdk.services.sam.CfnFunction.S3KeyFilterProperty s3Key) {
                this.s3Key = s3Key;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link S3NotificationFilterProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public S3NotificationFilterProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link S3NotificationFilterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements S3NotificationFilterProperty {
            private final java.lang.Object s3Key;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.s3Key = software.amazon.jsii.Kernel.get(this, "s3Key", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.s3Key = java.util.Objects.requireNonNull(builder.s3Key, "s3Key is required");
            }

            @Override
            public final java.lang.Object getS3Key() {
                return this.s3Key;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("s3Key", om.valueToTree(this.getS3Key()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_sam.CfnFunction.S3NotificationFilterProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                S3NotificationFilterProperty.Jsii$Proxy that = (S3NotificationFilterProperty.Jsii$Proxy) o;

                return this.s3Key.equals(that.s3Key);
            }

            @Override
            public final int hashCode() {
                int result = this.s3Key.hashCode();
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sam.*;
     * SAMPolicyTemplateProperty sAMPolicyTemplateProperty = SAMPolicyTemplateProperty.builder()
     *         .amiDescribePolicy(EmptySAMPTProperty.builder().build())
     *         .awsSecretsManagerGetSecretValuePolicy(SecretArnSAMPTProperty.builder()
     *                 .secretArn("secretArn")
     *                 .build())
     *         .cloudFormationDescribeStacksPolicy(EmptySAMPTProperty.builder().build())
     *         .cloudWatchPutMetricPolicy(EmptySAMPTProperty.builder().build())
     *         .dynamoDbCrudPolicy(TableSAMPTProperty.builder()
     *                 .tableName("tableName")
     *                 .build())
     *         .dynamoDbReadPolicy(TableSAMPTProperty.builder()
     *                 .tableName("tableName")
     *                 .build())
     *         .dynamoDbStreamReadPolicy(TableStreamSAMPTProperty.builder()
     *                 .streamName("streamName")
     *                 .tableName("tableName")
     *                 .build())
     *         .dynamoDbWritePolicy(TableSAMPTProperty.builder()
     *                 .tableName("tableName")
     *                 .build())
     *         .ec2DescribePolicy(EmptySAMPTProperty.builder().build())
     *         .elasticsearchHttpPostPolicy(DomainSAMPTProperty.builder()
     *                 .domainName("domainName")
     *                 .build())
     *         .filterLogEventsPolicy(LogGroupSAMPTProperty.builder()
     *                 .logGroupName("logGroupName")
     *                 .build())
     *         .kinesisCrudPolicy(StreamSAMPTProperty.builder()
     *                 .streamName("streamName")
     *                 .build())
     *         .kinesisStreamReadPolicy(StreamSAMPTProperty.builder()
     *                 .streamName("streamName")
     *                 .build())
     *         .kmsDecryptPolicy(KeySAMPTProperty.builder()
     *                 .keyId("keyId")
     *                 .build())
     *         .lambdaInvokePolicy(FunctionSAMPTProperty.builder()
     *                 .functionName("functionName")
     *                 .build())
     *         .rekognitionDetectOnlyPolicy(EmptySAMPTProperty.builder().build())
     *         .rekognitionLabelsPolicy(EmptySAMPTProperty.builder().build())
     *         .rekognitionNoDataAccessPolicy(CollectionSAMPTProperty.builder()
     *                 .collectionId("collectionId")
     *                 .build())
     *         .rekognitionReadPolicy(CollectionSAMPTProperty.builder()
     *                 .collectionId("collectionId")
     *                 .build())
     *         .rekognitionWriteOnlyAccessPolicy(CollectionSAMPTProperty.builder()
     *                 .collectionId("collectionId")
     *                 .build())
     *         .s3CrudPolicy(BucketSAMPTProperty.builder()
     *                 .bucketName("bucketName")
     *                 .build())
     *         .s3ReadPolicy(BucketSAMPTProperty.builder()
     *                 .bucketName("bucketName")
     *                 .build())
     *         .s3WritePolicy(BucketSAMPTProperty.builder()
     *                 .bucketName("bucketName")
     *                 .build())
     *         .sesBulkTemplatedCrudPolicy(IdentitySAMPTProperty.builder()
     *                 .identityName("identityName")
     *                 .build())
     *         .sesCrudPolicy(IdentitySAMPTProperty.builder()
     *                 .identityName("identityName")
     *                 .build())
     *         .sesEmailTemplateCrudPolicy(EmptySAMPTProperty.builder().build())
     *         .sesSendBouncePolicy(IdentitySAMPTProperty.builder()
     *                 .identityName("identityName")
     *                 .build())
     *         .snsCrudPolicy(TopicSAMPTProperty.builder()
     *                 .topicName("topicName")
     *                 .build())
     *         .snsPublishMessagePolicy(TopicSAMPTProperty.builder()
     *                 .topicName("topicName")
     *                 .build())
     *         .sqsPollerPolicy(QueueSAMPTProperty.builder()
     *                 .queueName("queueName")
     *                 .build())
     *         .sqsSendMessagePolicy(QueueSAMPTProperty.builder()
     *                 .queueName("queueName")
     *                 .build())
     *         .ssmParameterReadPolicy(ParameterNameSAMPTProperty.builder()
     *                 .parameterName("parameterName")
     *                 .build())
     *         .stepFunctionsExecutionPolicy(StateMachineSAMPTProperty.builder()
     *                 .stateMachineName("stateMachineName")
     *                 .build())
     *         .vpcAccessPolicy(EmptySAMPTProperty.builder().build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-sampolicytemplate.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-sampolicytemplate.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_sam.CfnFunction.SAMPolicyTemplateProperty")
    @software.amazon.jsii.Jsii.Proxy(SAMPolicyTemplateProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SAMPolicyTemplateProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-sampolicytemplate.html#cfn-serverless-function-sampolicytemplate-amidescribepolicy">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-sampolicytemplate.html#cfn-serverless-function-sampolicytemplate-amidescribepolicy</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAmiDescribePolicy() {
            return null;
        }

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-sampolicytemplate.html#cfn-serverless-function-sampolicytemplate-awssecretsmanagergetsecretvaluepolicy">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-sampolicytemplate.html#cfn-serverless-function-sampolicytemplate-awssecretsmanagergetsecretvaluepolicy</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAwsSecretsManagerGetSecretValuePolicy() {
            return null;
        }

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-sampolicytemplate.html#cfn-serverless-function-sampolicytemplate-cloudformationdescribestackspolicy">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-sampolicytemplate.html#cfn-serverless-function-sampolicytemplate-cloudformationdescribestackspolicy</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCloudFormationDescribeStacksPolicy() {
            return null;
        }

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-sampolicytemplate.html#cfn-serverless-function-sampolicytemplate-cloudwatchputmetricpolicy">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-sampolicytemplate.html#cfn-serverless-function-sampolicytemplate-cloudwatchputmetricpolicy</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCloudWatchPutMetricPolicy() {
            return null;
        }

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-sampolicytemplate.html#cfn-serverless-function-sampolicytemplate-dynamodbcrudpolicy">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-sampolicytemplate.html#cfn-serverless-function-sampolicytemplate-dynamodbcrudpolicy</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDynamoDbCrudPolicy() {
            return null;
        }

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-sampolicytemplate.html#cfn-serverless-function-sampolicytemplate-dynamodbreadpolicy">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-sampolicytemplate.html#cfn-serverless-function-sampolicytemplate-dynamodbreadpolicy</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDynamoDbReadPolicy() {
            return null;
        }

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-sampolicytemplate.html#cfn-serverless-function-sampolicytemplate-dynamodbstreamreadpolicy">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-sampolicytemplate.html#cfn-serverless-function-sampolicytemplate-dynamodbstreamreadpolicy</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDynamoDbStreamReadPolicy() {
            return null;
        }

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-sampolicytemplate.html#cfn-serverless-function-sampolicytemplate-dynamodbwritepolicy">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-sampolicytemplate.html#cfn-serverless-function-sampolicytemplate-dynamodbwritepolicy</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDynamoDbWritePolicy() {
            return null;
        }

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-sampolicytemplate.html#cfn-serverless-function-sampolicytemplate-ec2describepolicy">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-sampolicytemplate.html#cfn-serverless-function-sampolicytemplate-ec2describepolicy</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEc2DescribePolicy() {
            return null;
        }

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-sampolicytemplate.html#cfn-serverless-function-sampolicytemplate-elasticsearchhttppostpolicy">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-sampolicytemplate.html#cfn-serverless-function-sampolicytemplate-elasticsearchhttppostpolicy</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getElasticsearchHttpPostPolicy() {
            return null;
        }

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-sampolicytemplate.html#cfn-serverless-function-sampolicytemplate-filterlogeventspolicy">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-sampolicytemplate.html#cfn-serverless-function-sampolicytemplate-filterlogeventspolicy</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getFilterLogEventsPolicy() {
            return null;
        }

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-sampolicytemplate.html#cfn-serverless-function-sampolicytemplate-kinesiscrudpolicy">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-sampolicytemplate.html#cfn-serverless-function-sampolicytemplate-kinesiscrudpolicy</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getKinesisCrudPolicy() {
            return null;
        }

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-sampolicytemplate.html#cfn-serverless-function-sampolicytemplate-kinesisstreamreadpolicy">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-sampolicytemplate.html#cfn-serverless-function-sampolicytemplate-kinesisstreamreadpolicy</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getKinesisStreamReadPolicy() {
            return null;
        }

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-sampolicytemplate.html#cfn-serverless-function-sampolicytemplate-kmsdecryptpolicy">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-sampolicytemplate.html#cfn-serverless-function-sampolicytemplate-kmsdecryptpolicy</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getKmsDecryptPolicy() {
            return null;
        }

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-sampolicytemplate.html#cfn-serverless-function-sampolicytemplate-lambdainvokepolicy">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-sampolicytemplate.html#cfn-serverless-function-sampolicytemplate-lambdainvokepolicy</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getLambdaInvokePolicy() {
            return null;
        }

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-sampolicytemplate.html#cfn-serverless-function-sampolicytemplate-rekognitiondetectonlypolicy">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-sampolicytemplate.html#cfn-serverless-function-sampolicytemplate-rekognitiondetectonlypolicy</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getRekognitionDetectOnlyPolicy() {
            return null;
        }

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-sampolicytemplate.html#cfn-serverless-function-sampolicytemplate-rekognitionlabelspolicy">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-sampolicytemplate.html#cfn-serverless-function-sampolicytemplate-rekognitionlabelspolicy</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getRekognitionLabelsPolicy() {
            return null;
        }

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-sampolicytemplate.html#cfn-serverless-function-sampolicytemplate-rekognitionnodataaccesspolicy">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-sampolicytemplate.html#cfn-serverless-function-sampolicytemplate-rekognitionnodataaccesspolicy</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getRekognitionNoDataAccessPolicy() {
            return null;
        }

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-sampolicytemplate.html#cfn-serverless-function-sampolicytemplate-rekognitionreadpolicy">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-sampolicytemplate.html#cfn-serverless-function-sampolicytemplate-rekognitionreadpolicy</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getRekognitionReadPolicy() {
            return null;
        }

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-sampolicytemplate.html#cfn-serverless-function-sampolicytemplate-rekognitionwriteonlyaccesspolicy">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-sampolicytemplate.html#cfn-serverless-function-sampolicytemplate-rekognitionwriteonlyaccesspolicy</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getRekognitionWriteOnlyAccessPolicy() {
            return null;
        }

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-sampolicytemplate.html#cfn-serverless-function-sampolicytemplate-s3crudpolicy">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-sampolicytemplate.html#cfn-serverless-function-sampolicytemplate-s3crudpolicy</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getS3CrudPolicy() {
            return null;
        }

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-sampolicytemplate.html#cfn-serverless-function-sampolicytemplate-s3readpolicy">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-sampolicytemplate.html#cfn-serverless-function-sampolicytemplate-s3readpolicy</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getS3ReadPolicy() {
            return null;
        }

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-sampolicytemplate.html#cfn-serverless-function-sampolicytemplate-s3writepolicy">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-sampolicytemplate.html#cfn-serverless-function-sampolicytemplate-s3writepolicy</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getS3WritePolicy() {
            return null;
        }

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-sampolicytemplate.html#cfn-serverless-function-sampolicytemplate-sesbulktemplatedcrudpolicy">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-sampolicytemplate.html#cfn-serverless-function-sampolicytemplate-sesbulktemplatedcrudpolicy</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSesBulkTemplatedCrudPolicy() {
            return null;
        }

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-sampolicytemplate.html#cfn-serverless-function-sampolicytemplate-sescrudpolicy">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-sampolicytemplate.html#cfn-serverless-function-sampolicytemplate-sescrudpolicy</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSesCrudPolicy() {
            return null;
        }

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-sampolicytemplate.html#cfn-serverless-function-sampolicytemplate-sesemailtemplatecrudpolicy">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-sampolicytemplate.html#cfn-serverless-function-sampolicytemplate-sesemailtemplatecrudpolicy</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSesEmailTemplateCrudPolicy() {
            return null;
        }

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-sampolicytemplate.html#cfn-serverless-function-sampolicytemplate-sessendbouncepolicy">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-sampolicytemplate.html#cfn-serverless-function-sampolicytemplate-sessendbouncepolicy</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSesSendBouncePolicy() {
            return null;
        }

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-sampolicytemplate.html#cfn-serverless-function-sampolicytemplate-snscrudpolicy">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-sampolicytemplate.html#cfn-serverless-function-sampolicytemplate-snscrudpolicy</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSnsCrudPolicy() {
            return null;
        }

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-sampolicytemplate.html#cfn-serverless-function-sampolicytemplate-snspublishmessagepolicy">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-sampolicytemplate.html#cfn-serverless-function-sampolicytemplate-snspublishmessagepolicy</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSnsPublishMessagePolicy() {
            return null;
        }

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-sampolicytemplate.html#cfn-serverless-function-sampolicytemplate-sqspollerpolicy">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-sampolicytemplate.html#cfn-serverless-function-sampolicytemplate-sqspollerpolicy</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSqsPollerPolicy() {
            return null;
        }

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-sampolicytemplate.html#cfn-serverless-function-sampolicytemplate-sqssendmessagepolicy">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-sampolicytemplate.html#cfn-serverless-function-sampolicytemplate-sqssendmessagepolicy</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSqsSendMessagePolicy() {
            return null;
        }

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-sampolicytemplate.html#cfn-serverless-function-sampolicytemplate-ssmparameterreadpolicy">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-sampolicytemplate.html#cfn-serverless-function-sampolicytemplate-ssmparameterreadpolicy</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSsmParameterReadPolicy() {
            return null;
        }

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-sampolicytemplate.html#cfn-serverless-function-sampolicytemplate-stepfunctionsexecutionpolicy">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-sampolicytemplate.html#cfn-serverless-function-sampolicytemplate-stepfunctionsexecutionpolicy</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getStepFunctionsExecutionPolicy() {
            return null;
        }

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-sampolicytemplate.html#cfn-serverless-function-sampolicytemplate-vpcaccesspolicy">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-sampolicytemplate.html#cfn-serverless-function-sampolicytemplate-vpcaccesspolicy</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getVpcAccessPolicy() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link SAMPolicyTemplateProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SAMPolicyTemplateProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SAMPolicyTemplateProperty> {
            java.lang.Object amiDescribePolicy;
            java.lang.Object awsSecretsManagerGetSecretValuePolicy;
            java.lang.Object cloudFormationDescribeStacksPolicy;
            java.lang.Object cloudWatchPutMetricPolicy;
            java.lang.Object dynamoDbCrudPolicy;
            java.lang.Object dynamoDbReadPolicy;
            java.lang.Object dynamoDbStreamReadPolicy;
            java.lang.Object dynamoDbWritePolicy;
            java.lang.Object ec2DescribePolicy;
            java.lang.Object elasticsearchHttpPostPolicy;
            java.lang.Object filterLogEventsPolicy;
            java.lang.Object kinesisCrudPolicy;
            java.lang.Object kinesisStreamReadPolicy;
            java.lang.Object kmsDecryptPolicy;
            java.lang.Object lambdaInvokePolicy;
            java.lang.Object rekognitionDetectOnlyPolicy;
            java.lang.Object rekognitionLabelsPolicy;
            java.lang.Object rekognitionNoDataAccessPolicy;
            java.lang.Object rekognitionReadPolicy;
            java.lang.Object rekognitionWriteOnlyAccessPolicy;
            java.lang.Object s3CrudPolicy;
            java.lang.Object s3ReadPolicy;
            java.lang.Object s3WritePolicy;
            java.lang.Object sesBulkTemplatedCrudPolicy;
            java.lang.Object sesCrudPolicy;
            java.lang.Object sesEmailTemplateCrudPolicy;
            java.lang.Object sesSendBouncePolicy;
            java.lang.Object snsCrudPolicy;
            java.lang.Object snsPublishMessagePolicy;
            java.lang.Object sqsPollerPolicy;
            java.lang.Object sqsSendMessagePolicy;
            java.lang.Object ssmParameterReadPolicy;
            java.lang.Object stepFunctionsExecutionPolicy;
            java.lang.Object vpcAccessPolicy;

            /**
             * Sets the value of {@link SAMPolicyTemplateProperty#getAmiDescribePolicy}
             * @param amiDescribePolicy the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder amiDescribePolicy(software.amazon.awscdk.IResolvable amiDescribePolicy) {
                this.amiDescribePolicy = amiDescribePolicy;
                return this;
            }

            /**
             * Sets the value of {@link SAMPolicyTemplateProperty#getAmiDescribePolicy}
             * @param amiDescribePolicy the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder amiDescribePolicy(software.amazon.awscdk.services.sam.CfnFunction.EmptySAMPTProperty amiDescribePolicy) {
                this.amiDescribePolicy = amiDescribePolicy;
                return this;
            }

            /**
             * Sets the value of {@link SAMPolicyTemplateProperty#getAwsSecretsManagerGetSecretValuePolicy}
             * @param awsSecretsManagerGetSecretValuePolicy the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder awsSecretsManagerGetSecretValuePolicy(software.amazon.awscdk.IResolvable awsSecretsManagerGetSecretValuePolicy) {
                this.awsSecretsManagerGetSecretValuePolicy = awsSecretsManagerGetSecretValuePolicy;
                return this;
            }

            /**
             * Sets the value of {@link SAMPolicyTemplateProperty#getAwsSecretsManagerGetSecretValuePolicy}
             * @param awsSecretsManagerGetSecretValuePolicy the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder awsSecretsManagerGetSecretValuePolicy(software.amazon.awscdk.services.sam.CfnFunction.SecretArnSAMPTProperty awsSecretsManagerGetSecretValuePolicy) {
                this.awsSecretsManagerGetSecretValuePolicy = awsSecretsManagerGetSecretValuePolicy;
                return this;
            }

            /**
             * Sets the value of {@link SAMPolicyTemplateProperty#getCloudFormationDescribeStacksPolicy}
             * @param cloudFormationDescribeStacksPolicy the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cloudFormationDescribeStacksPolicy(software.amazon.awscdk.IResolvable cloudFormationDescribeStacksPolicy) {
                this.cloudFormationDescribeStacksPolicy = cloudFormationDescribeStacksPolicy;
                return this;
            }

            /**
             * Sets the value of {@link SAMPolicyTemplateProperty#getCloudFormationDescribeStacksPolicy}
             * @param cloudFormationDescribeStacksPolicy the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cloudFormationDescribeStacksPolicy(software.amazon.awscdk.services.sam.CfnFunction.EmptySAMPTProperty cloudFormationDescribeStacksPolicy) {
                this.cloudFormationDescribeStacksPolicy = cloudFormationDescribeStacksPolicy;
                return this;
            }

            /**
             * Sets the value of {@link SAMPolicyTemplateProperty#getCloudWatchPutMetricPolicy}
             * @param cloudWatchPutMetricPolicy the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cloudWatchPutMetricPolicy(software.amazon.awscdk.IResolvable cloudWatchPutMetricPolicy) {
                this.cloudWatchPutMetricPolicy = cloudWatchPutMetricPolicy;
                return this;
            }

            /**
             * Sets the value of {@link SAMPolicyTemplateProperty#getCloudWatchPutMetricPolicy}
             * @param cloudWatchPutMetricPolicy the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cloudWatchPutMetricPolicy(software.amazon.awscdk.services.sam.CfnFunction.EmptySAMPTProperty cloudWatchPutMetricPolicy) {
                this.cloudWatchPutMetricPolicy = cloudWatchPutMetricPolicy;
                return this;
            }

            /**
             * Sets the value of {@link SAMPolicyTemplateProperty#getDynamoDbCrudPolicy}
             * @param dynamoDbCrudPolicy the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dynamoDbCrudPolicy(software.amazon.awscdk.IResolvable dynamoDbCrudPolicy) {
                this.dynamoDbCrudPolicy = dynamoDbCrudPolicy;
                return this;
            }

            /**
             * Sets the value of {@link SAMPolicyTemplateProperty#getDynamoDbCrudPolicy}
             * @param dynamoDbCrudPolicy the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dynamoDbCrudPolicy(software.amazon.awscdk.services.sam.CfnFunction.TableSAMPTProperty dynamoDbCrudPolicy) {
                this.dynamoDbCrudPolicy = dynamoDbCrudPolicy;
                return this;
            }

            /**
             * Sets the value of {@link SAMPolicyTemplateProperty#getDynamoDbReadPolicy}
             * @param dynamoDbReadPolicy the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dynamoDbReadPolicy(software.amazon.awscdk.IResolvable dynamoDbReadPolicy) {
                this.dynamoDbReadPolicy = dynamoDbReadPolicy;
                return this;
            }

            /**
             * Sets the value of {@link SAMPolicyTemplateProperty#getDynamoDbReadPolicy}
             * @param dynamoDbReadPolicy the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dynamoDbReadPolicy(software.amazon.awscdk.services.sam.CfnFunction.TableSAMPTProperty dynamoDbReadPolicy) {
                this.dynamoDbReadPolicy = dynamoDbReadPolicy;
                return this;
            }

            /**
             * Sets the value of {@link SAMPolicyTemplateProperty#getDynamoDbStreamReadPolicy}
             * @param dynamoDbStreamReadPolicy the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dynamoDbStreamReadPolicy(software.amazon.awscdk.IResolvable dynamoDbStreamReadPolicy) {
                this.dynamoDbStreamReadPolicy = dynamoDbStreamReadPolicy;
                return this;
            }

            /**
             * Sets the value of {@link SAMPolicyTemplateProperty#getDynamoDbStreamReadPolicy}
             * @param dynamoDbStreamReadPolicy the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dynamoDbStreamReadPolicy(software.amazon.awscdk.services.sam.CfnFunction.TableStreamSAMPTProperty dynamoDbStreamReadPolicy) {
                this.dynamoDbStreamReadPolicy = dynamoDbStreamReadPolicy;
                return this;
            }

            /**
             * Sets the value of {@link SAMPolicyTemplateProperty#getDynamoDbWritePolicy}
             * @param dynamoDbWritePolicy the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dynamoDbWritePolicy(software.amazon.awscdk.IResolvable dynamoDbWritePolicy) {
                this.dynamoDbWritePolicy = dynamoDbWritePolicy;
                return this;
            }

            /**
             * Sets the value of {@link SAMPolicyTemplateProperty#getDynamoDbWritePolicy}
             * @param dynamoDbWritePolicy the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dynamoDbWritePolicy(software.amazon.awscdk.services.sam.CfnFunction.TableSAMPTProperty dynamoDbWritePolicy) {
                this.dynamoDbWritePolicy = dynamoDbWritePolicy;
                return this;
            }

            /**
             * Sets the value of {@link SAMPolicyTemplateProperty#getEc2DescribePolicy}
             * @param ec2DescribePolicy the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ec2DescribePolicy(software.amazon.awscdk.IResolvable ec2DescribePolicy) {
                this.ec2DescribePolicy = ec2DescribePolicy;
                return this;
            }

            /**
             * Sets the value of {@link SAMPolicyTemplateProperty#getEc2DescribePolicy}
             * @param ec2DescribePolicy the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ec2DescribePolicy(software.amazon.awscdk.services.sam.CfnFunction.EmptySAMPTProperty ec2DescribePolicy) {
                this.ec2DescribePolicy = ec2DescribePolicy;
                return this;
            }

            /**
             * Sets the value of {@link SAMPolicyTemplateProperty#getElasticsearchHttpPostPolicy}
             * @param elasticsearchHttpPostPolicy the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder elasticsearchHttpPostPolicy(software.amazon.awscdk.IResolvable elasticsearchHttpPostPolicy) {
                this.elasticsearchHttpPostPolicy = elasticsearchHttpPostPolicy;
                return this;
            }

            /**
             * Sets the value of {@link SAMPolicyTemplateProperty#getElasticsearchHttpPostPolicy}
             * @param elasticsearchHttpPostPolicy the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder elasticsearchHttpPostPolicy(software.amazon.awscdk.services.sam.CfnFunction.DomainSAMPTProperty elasticsearchHttpPostPolicy) {
                this.elasticsearchHttpPostPolicy = elasticsearchHttpPostPolicy;
                return this;
            }

            /**
             * Sets the value of {@link SAMPolicyTemplateProperty#getFilterLogEventsPolicy}
             * @param filterLogEventsPolicy the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder filterLogEventsPolicy(software.amazon.awscdk.IResolvable filterLogEventsPolicy) {
                this.filterLogEventsPolicy = filterLogEventsPolicy;
                return this;
            }

            /**
             * Sets the value of {@link SAMPolicyTemplateProperty#getFilterLogEventsPolicy}
             * @param filterLogEventsPolicy the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder filterLogEventsPolicy(software.amazon.awscdk.services.sam.CfnFunction.LogGroupSAMPTProperty filterLogEventsPolicy) {
                this.filterLogEventsPolicy = filterLogEventsPolicy;
                return this;
            }

            /**
             * Sets the value of {@link SAMPolicyTemplateProperty#getKinesisCrudPolicy}
             * @param kinesisCrudPolicy the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder kinesisCrudPolicy(software.amazon.awscdk.IResolvable kinesisCrudPolicy) {
                this.kinesisCrudPolicy = kinesisCrudPolicy;
                return this;
            }

            /**
             * Sets the value of {@link SAMPolicyTemplateProperty#getKinesisCrudPolicy}
             * @param kinesisCrudPolicy the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder kinesisCrudPolicy(software.amazon.awscdk.services.sam.CfnFunction.StreamSAMPTProperty kinesisCrudPolicy) {
                this.kinesisCrudPolicy = kinesisCrudPolicy;
                return this;
            }

            /**
             * Sets the value of {@link SAMPolicyTemplateProperty#getKinesisStreamReadPolicy}
             * @param kinesisStreamReadPolicy the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder kinesisStreamReadPolicy(software.amazon.awscdk.IResolvable kinesisStreamReadPolicy) {
                this.kinesisStreamReadPolicy = kinesisStreamReadPolicy;
                return this;
            }

            /**
             * Sets the value of {@link SAMPolicyTemplateProperty#getKinesisStreamReadPolicy}
             * @param kinesisStreamReadPolicy the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder kinesisStreamReadPolicy(software.amazon.awscdk.services.sam.CfnFunction.StreamSAMPTProperty kinesisStreamReadPolicy) {
                this.kinesisStreamReadPolicy = kinesisStreamReadPolicy;
                return this;
            }

            /**
             * Sets the value of {@link SAMPolicyTemplateProperty#getKmsDecryptPolicy}
             * @param kmsDecryptPolicy the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder kmsDecryptPolicy(software.amazon.awscdk.IResolvable kmsDecryptPolicy) {
                this.kmsDecryptPolicy = kmsDecryptPolicy;
                return this;
            }

            /**
             * Sets the value of {@link SAMPolicyTemplateProperty#getKmsDecryptPolicy}
             * @param kmsDecryptPolicy the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder kmsDecryptPolicy(software.amazon.awscdk.services.sam.CfnFunction.KeySAMPTProperty kmsDecryptPolicy) {
                this.kmsDecryptPolicy = kmsDecryptPolicy;
                return this;
            }

            /**
             * Sets the value of {@link SAMPolicyTemplateProperty#getLambdaInvokePolicy}
             * @param lambdaInvokePolicy the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder lambdaInvokePolicy(software.amazon.awscdk.IResolvable lambdaInvokePolicy) {
                this.lambdaInvokePolicy = lambdaInvokePolicy;
                return this;
            }

            /**
             * Sets the value of {@link SAMPolicyTemplateProperty#getLambdaInvokePolicy}
             * @param lambdaInvokePolicy the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder lambdaInvokePolicy(software.amazon.awscdk.services.sam.CfnFunction.FunctionSAMPTProperty lambdaInvokePolicy) {
                this.lambdaInvokePolicy = lambdaInvokePolicy;
                return this;
            }

            /**
             * Sets the value of {@link SAMPolicyTemplateProperty#getRekognitionDetectOnlyPolicy}
             * @param rekognitionDetectOnlyPolicy the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder rekognitionDetectOnlyPolicy(software.amazon.awscdk.IResolvable rekognitionDetectOnlyPolicy) {
                this.rekognitionDetectOnlyPolicy = rekognitionDetectOnlyPolicy;
                return this;
            }

            /**
             * Sets the value of {@link SAMPolicyTemplateProperty#getRekognitionDetectOnlyPolicy}
             * @param rekognitionDetectOnlyPolicy the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder rekognitionDetectOnlyPolicy(software.amazon.awscdk.services.sam.CfnFunction.EmptySAMPTProperty rekognitionDetectOnlyPolicy) {
                this.rekognitionDetectOnlyPolicy = rekognitionDetectOnlyPolicy;
                return this;
            }

            /**
             * Sets the value of {@link SAMPolicyTemplateProperty#getRekognitionLabelsPolicy}
             * @param rekognitionLabelsPolicy the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder rekognitionLabelsPolicy(software.amazon.awscdk.IResolvable rekognitionLabelsPolicy) {
                this.rekognitionLabelsPolicy = rekognitionLabelsPolicy;
                return this;
            }

            /**
             * Sets the value of {@link SAMPolicyTemplateProperty#getRekognitionLabelsPolicy}
             * @param rekognitionLabelsPolicy the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder rekognitionLabelsPolicy(software.amazon.awscdk.services.sam.CfnFunction.EmptySAMPTProperty rekognitionLabelsPolicy) {
                this.rekognitionLabelsPolicy = rekognitionLabelsPolicy;
                return this;
            }

            /**
             * Sets the value of {@link SAMPolicyTemplateProperty#getRekognitionNoDataAccessPolicy}
             * @param rekognitionNoDataAccessPolicy the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder rekognitionNoDataAccessPolicy(software.amazon.awscdk.IResolvable rekognitionNoDataAccessPolicy) {
                this.rekognitionNoDataAccessPolicy = rekognitionNoDataAccessPolicy;
                return this;
            }

            /**
             * Sets the value of {@link SAMPolicyTemplateProperty#getRekognitionNoDataAccessPolicy}
             * @param rekognitionNoDataAccessPolicy the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder rekognitionNoDataAccessPolicy(software.amazon.awscdk.services.sam.CfnFunction.CollectionSAMPTProperty rekognitionNoDataAccessPolicy) {
                this.rekognitionNoDataAccessPolicy = rekognitionNoDataAccessPolicy;
                return this;
            }

            /**
             * Sets the value of {@link SAMPolicyTemplateProperty#getRekognitionReadPolicy}
             * @param rekognitionReadPolicy the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder rekognitionReadPolicy(software.amazon.awscdk.IResolvable rekognitionReadPolicy) {
                this.rekognitionReadPolicy = rekognitionReadPolicy;
                return this;
            }

            /**
             * Sets the value of {@link SAMPolicyTemplateProperty#getRekognitionReadPolicy}
             * @param rekognitionReadPolicy the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder rekognitionReadPolicy(software.amazon.awscdk.services.sam.CfnFunction.CollectionSAMPTProperty rekognitionReadPolicy) {
                this.rekognitionReadPolicy = rekognitionReadPolicy;
                return this;
            }

            /**
             * Sets the value of {@link SAMPolicyTemplateProperty#getRekognitionWriteOnlyAccessPolicy}
             * @param rekognitionWriteOnlyAccessPolicy the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder rekognitionWriteOnlyAccessPolicy(software.amazon.awscdk.IResolvable rekognitionWriteOnlyAccessPolicy) {
                this.rekognitionWriteOnlyAccessPolicy = rekognitionWriteOnlyAccessPolicy;
                return this;
            }

            /**
             * Sets the value of {@link SAMPolicyTemplateProperty#getRekognitionWriteOnlyAccessPolicy}
             * @param rekognitionWriteOnlyAccessPolicy the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder rekognitionWriteOnlyAccessPolicy(software.amazon.awscdk.services.sam.CfnFunction.CollectionSAMPTProperty rekognitionWriteOnlyAccessPolicy) {
                this.rekognitionWriteOnlyAccessPolicy = rekognitionWriteOnlyAccessPolicy;
                return this;
            }

            /**
             * Sets the value of {@link SAMPolicyTemplateProperty#getS3CrudPolicy}
             * @param s3CrudPolicy the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3CrudPolicy(software.amazon.awscdk.IResolvable s3CrudPolicy) {
                this.s3CrudPolicy = s3CrudPolicy;
                return this;
            }

            /**
             * Sets the value of {@link SAMPolicyTemplateProperty#getS3CrudPolicy}
             * @param s3CrudPolicy the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3CrudPolicy(software.amazon.awscdk.services.sam.CfnFunction.BucketSAMPTProperty s3CrudPolicy) {
                this.s3CrudPolicy = s3CrudPolicy;
                return this;
            }

            /**
             * Sets the value of {@link SAMPolicyTemplateProperty#getS3ReadPolicy}
             * @param s3ReadPolicy the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3ReadPolicy(software.amazon.awscdk.IResolvable s3ReadPolicy) {
                this.s3ReadPolicy = s3ReadPolicy;
                return this;
            }

            /**
             * Sets the value of {@link SAMPolicyTemplateProperty#getS3ReadPolicy}
             * @param s3ReadPolicy the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3ReadPolicy(software.amazon.awscdk.services.sam.CfnFunction.BucketSAMPTProperty s3ReadPolicy) {
                this.s3ReadPolicy = s3ReadPolicy;
                return this;
            }

            /**
             * Sets the value of {@link SAMPolicyTemplateProperty#getS3WritePolicy}
             * @param s3WritePolicy the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3WritePolicy(software.amazon.awscdk.IResolvable s3WritePolicy) {
                this.s3WritePolicy = s3WritePolicy;
                return this;
            }

            /**
             * Sets the value of {@link SAMPolicyTemplateProperty#getS3WritePolicy}
             * @param s3WritePolicy the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3WritePolicy(software.amazon.awscdk.services.sam.CfnFunction.BucketSAMPTProperty s3WritePolicy) {
                this.s3WritePolicy = s3WritePolicy;
                return this;
            }

            /**
             * Sets the value of {@link SAMPolicyTemplateProperty#getSesBulkTemplatedCrudPolicy}
             * @param sesBulkTemplatedCrudPolicy the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sesBulkTemplatedCrudPolicy(software.amazon.awscdk.IResolvable sesBulkTemplatedCrudPolicy) {
                this.sesBulkTemplatedCrudPolicy = sesBulkTemplatedCrudPolicy;
                return this;
            }

            /**
             * Sets the value of {@link SAMPolicyTemplateProperty#getSesBulkTemplatedCrudPolicy}
             * @param sesBulkTemplatedCrudPolicy the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sesBulkTemplatedCrudPolicy(software.amazon.awscdk.services.sam.CfnFunction.IdentitySAMPTProperty sesBulkTemplatedCrudPolicy) {
                this.sesBulkTemplatedCrudPolicy = sesBulkTemplatedCrudPolicy;
                return this;
            }

            /**
             * Sets the value of {@link SAMPolicyTemplateProperty#getSesCrudPolicy}
             * @param sesCrudPolicy the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sesCrudPolicy(software.amazon.awscdk.IResolvable sesCrudPolicy) {
                this.sesCrudPolicy = sesCrudPolicy;
                return this;
            }

            /**
             * Sets the value of {@link SAMPolicyTemplateProperty#getSesCrudPolicy}
             * @param sesCrudPolicy the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sesCrudPolicy(software.amazon.awscdk.services.sam.CfnFunction.IdentitySAMPTProperty sesCrudPolicy) {
                this.sesCrudPolicy = sesCrudPolicy;
                return this;
            }

            /**
             * Sets the value of {@link SAMPolicyTemplateProperty#getSesEmailTemplateCrudPolicy}
             * @param sesEmailTemplateCrudPolicy the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sesEmailTemplateCrudPolicy(software.amazon.awscdk.IResolvable sesEmailTemplateCrudPolicy) {
                this.sesEmailTemplateCrudPolicy = sesEmailTemplateCrudPolicy;
                return this;
            }

            /**
             * Sets the value of {@link SAMPolicyTemplateProperty#getSesEmailTemplateCrudPolicy}
             * @param sesEmailTemplateCrudPolicy the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sesEmailTemplateCrudPolicy(software.amazon.awscdk.services.sam.CfnFunction.EmptySAMPTProperty sesEmailTemplateCrudPolicy) {
                this.sesEmailTemplateCrudPolicy = sesEmailTemplateCrudPolicy;
                return this;
            }

            /**
             * Sets the value of {@link SAMPolicyTemplateProperty#getSesSendBouncePolicy}
             * @param sesSendBouncePolicy the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sesSendBouncePolicy(software.amazon.awscdk.IResolvable sesSendBouncePolicy) {
                this.sesSendBouncePolicy = sesSendBouncePolicy;
                return this;
            }

            /**
             * Sets the value of {@link SAMPolicyTemplateProperty#getSesSendBouncePolicy}
             * @param sesSendBouncePolicy the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sesSendBouncePolicy(software.amazon.awscdk.services.sam.CfnFunction.IdentitySAMPTProperty sesSendBouncePolicy) {
                this.sesSendBouncePolicy = sesSendBouncePolicy;
                return this;
            }

            /**
             * Sets the value of {@link SAMPolicyTemplateProperty#getSnsCrudPolicy}
             * @param snsCrudPolicy the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder snsCrudPolicy(software.amazon.awscdk.IResolvable snsCrudPolicy) {
                this.snsCrudPolicy = snsCrudPolicy;
                return this;
            }

            /**
             * Sets the value of {@link SAMPolicyTemplateProperty#getSnsCrudPolicy}
             * @param snsCrudPolicy the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder snsCrudPolicy(software.amazon.awscdk.services.sam.CfnFunction.TopicSAMPTProperty snsCrudPolicy) {
                this.snsCrudPolicy = snsCrudPolicy;
                return this;
            }

            /**
             * Sets the value of {@link SAMPolicyTemplateProperty#getSnsPublishMessagePolicy}
             * @param snsPublishMessagePolicy the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder snsPublishMessagePolicy(software.amazon.awscdk.IResolvable snsPublishMessagePolicy) {
                this.snsPublishMessagePolicy = snsPublishMessagePolicy;
                return this;
            }

            /**
             * Sets the value of {@link SAMPolicyTemplateProperty#getSnsPublishMessagePolicy}
             * @param snsPublishMessagePolicy the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder snsPublishMessagePolicy(software.amazon.awscdk.services.sam.CfnFunction.TopicSAMPTProperty snsPublishMessagePolicy) {
                this.snsPublishMessagePolicy = snsPublishMessagePolicy;
                return this;
            }

            /**
             * Sets the value of {@link SAMPolicyTemplateProperty#getSqsPollerPolicy}
             * @param sqsPollerPolicy the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sqsPollerPolicy(software.amazon.awscdk.IResolvable sqsPollerPolicy) {
                this.sqsPollerPolicy = sqsPollerPolicy;
                return this;
            }

            /**
             * Sets the value of {@link SAMPolicyTemplateProperty#getSqsPollerPolicy}
             * @param sqsPollerPolicy the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sqsPollerPolicy(software.amazon.awscdk.services.sam.CfnFunction.QueueSAMPTProperty sqsPollerPolicy) {
                this.sqsPollerPolicy = sqsPollerPolicy;
                return this;
            }

            /**
             * Sets the value of {@link SAMPolicyTemplateProperty#getSqsSendMessagePolicy}
             * @param sqsSendMessagePolicy the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sqsSendMessagePolicy(software.amazon.awscdk.IResolvable sqsSendMessagePolicy) {
                this.sqsSendMessagePolicy = sqsSendMessagePolicy;
                return this;
            }

            /**
             * Sets the value of {@link SAMPolicyTemplateProperty#getSqsSendMessagePolicy}
             * @param sqsSendMessagePolicy the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sqsSendMessagePolicy(software.amazon.awscdk.services.sam.CfnFunction.QueueSAMPTProperty sqsSendMessagePolicy) {
                this.sqsSendMessagePolicy = sqsSendMessagePolicy;
                return this;
            }

            /**
             * Sets the value of {@link SAMPolicyTemplateProperty#getSsmParameterReadPolicy}
             * @param ssmParameterReadPolicy the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ssmParameterReadPolicy(software.amazon.awscdk.IResolvable ssmParameterReadPolicy) {
                this.ssmParameterReadPolicy = ssmParameterReadPolicy;
                return this;
            }

            /**
             * Sets the value of {@link SAMPolicyTemplateProperty#getSsmParameterReadPolicy}
             * @param ssmParameterReadPolicy the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ssmParameterReadPolicy(software.amazon.awscdk.services.sam.CfnFunction.ParameterNameSAMPTProperty ssmParameterReadPolicy) {
                this.ssmParameterReadPolicy = ssmParameterReadPolicy;
                return this;
            }

            /**
             * Sets the value of {@link SAMPolicyTemplateProperty#getStepFunctionsExecutionPolicy}
             * @param stepFunctionsExecutionPolicy the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder stepFunctionsExecutionPolicy(software.amazon.awscdk.IResolvable stepFunctionsExecutionPolicy) {
                this.stepFunctionsExecutionPolicy = stepFunctionsExecutionPolicy;
                return this;
            }

            /**
             * Sets the value of {@link SAMPolicyTemplateProperty#getStepFunctionsExecutionPolicy}
             * @param stepFunctionsExecutionPolicy the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder stepFunctionsExecutionPolicy(software.amazon.awscdk.services.sam.CfnFunction.StateMachineSAMPTProperty stepFunctionsExecutionPolicy) {
                this.stepFunctionsExecutionPolicy = stepFunctionsExecutionPolicy;
                return this;
            }

            /**
             * Sets the value of {@link SAMPolicyTemplateProperty#getVpcAccessPolicy}
             * @param vpcAccessPolicy the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder vpcAccessPolicy(software.amazon.awscdk.IResolvable vpcAccessPolicy) {
                this.vpcAccessPolicy = vpcAccessPolicy;
                return this;
            }

            /**
             * Sets the value of {@link SAMPolicyTemplateProperty#getVpcAccessPolicy}
             * @param vpcAccessPolicy the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder vpcAccessPolicy(software.amazon.awscdk.services.sam.CfnFunction.EmptySAMPTProperty vpcAccessPolicy) {
                this.vpcAccessPolicy = vpcAccessPolicy;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SAMPolicyTemplateProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SAMPolicyTemplateProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SAMPolicyTemplateProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SAMPolicyTemplateProperty {
            private final java.lang.Object amiDescribePolicy;
            private final java.lang.Object awsSecretsManagerGetSecretValuePolicy;
            private final java.lang.Object cloudFormationDescribeStacksPolicy;
            private final java.lang.Object cloudWatchPutMetricPolicy;
            private final java.lang.Object dynamoDbCrudPolicy;
            private final java.lang.Object dynamoDbReadPolicy;
            private final java.lang.Object dynamoDbStreamReadPolicy;
            private final java.lang.Object dynamoDbWritePolicy;
            private final java.lang.Object ec2DescribePolicy;
            private final java.lang.Object elasticsearchHttpPostPolicy;
            private final java.lang.Object filterLogEventsPolicy;
            private final java.lang.Object kinesisCrudPolicy;
            private final java.lang.Object kinesisStreamReadPolicy;
            private final java.lang.Object kmsDecryptPolicy;
            private final java.lang.Object lambdaInvokePolicy;
            private final java.lang.Object rekognitionDetectOnlyPolicy;
            private final java.lang.Object rekognitionLabelsPolicy;
            private final java.lang.Object rekognitionNoDataAccessPolicy;
            private final java.lang.Object rekognitionReadPolicy;
            private final java.lang.Object rekognitionWriteOnlyAccessPolicy;
            private final java.lang.Object s3CrudPolicy;
            private final java.lang.Object s3ReadPolicy;
            private final java.lang.Object s3WritePolicy;
            private final java.lang.Object sesBulkTemplatedCrudPolicy;
            private final java.lang.Object sesCrudPolicy;
            private final java.lang.Object sesEmailTemplateCrudPolicy;
            private final java.lang.Object sesSendBouncePolicy;
            private final java.lang.Object snsCrudPolicy;
            private final java.lang.Object snsPublishMessagePolicy;
            private final java.lang.Object sqsPollerPolicy;
            private final java.lang.Object sqsSendMessagePolicy;
            private final java.lang.Object ssmParameterReadPolicy;
            private final java.lang.Object stepFunctionsExecutionPolicy;
            private final java.lang.Object vpcAccessPolicy;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.amiDescribePolicy = software.amazon.jsii.Kernel.get(this, "amiDescribePolicy", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.awsSecretsManagerGetSecretValuePolicy = software.amazon.jsii.Kernel.get(this, "awsSecretsManagerGetSecretValuePolicy", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.cloudFormationDescribeStacksPolicy = software.amazon.jsii.Kernel.get(this, "cloudFormationDescribeStacksPolicy", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.cloudWatchPutMetricPolicy = software.amazon.jsii.Kernel.get(this, "cloudWatchPutMetricPolicy", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.dynamoDbCrudPolicy = software.amazon.jsii.Kernel.get(this, "dynamoDbCrudPolicy", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.dynamoDbReadPolicy = software.amazon.jsii.Kernel.get(this, "dynamoDbReadPolicy", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.dynamoDbStreamReadPolicy = software.amazon.jsii.Kernel.get(this, "dynamoDbStreamReadPolicy", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.dynamoDbWritePolicy = software.amazon.jsii.Kernel.get(this, "dynamoDbWritePolicy", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.ec2DescribePolicy = software.amazon.jsii.Kernel.get(this, "ec2DescribePolicy", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.elasticsearchHttpPostPolicy = software.amazon.jsii.Kernel.get(this, "elasticsearchHttpPostPolicy", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.filterLogEventsPolicy = software.amazon.jsii.Kernel.get(this, "filterLogEventsPolicy", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.kinesisCrudPolicy = software.amazon.jsii.Kernel.get(this, "kinesisCrudPolicy", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.kinesisStreamReadPolicy = software.amazon.jsii.Kernel.get(this, "kinesisStreamReadPolicy", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.kmsDecryptPolicy = software.amazon.jsii.Kernel.get(this, "kmsDecryptPolicy", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.lambdaInvokePolicy = software.amazon.jsii.Kernel.get(this, "lambdaInvokePolicy", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.rekognitionDetectOnlyPolicy = software.amazon.jsii.Kernel.get(this, "rekognitionDetectOnlyPolicy", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.rekognitionLabelsPolicy = software.amazon.jsii.Kernel.get(this, "rekognitionLabelsPolicy", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.rekognitionNoDataAccessPolicy = software.amazon.jsii.Kernel.get(this, "rekognitionNoDataAccessPolicy", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.rekognitionReadPolicy = software.amazon.jsii.Kernel.get(this, "rekognitionReadPolicy", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.rekognitionWriteOnlyAccessPolicy = software.amazon.jsii.Kernel.get(this, "rekognitionWriteOnlyAccessPolicy", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.s3CrudPolicy = software.amazon.jsii.Kernel.get(this, "s3CrudPolicy", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.s3ReadPolicy = software.amazon.jsii.Kernel.get(this, "s3ReadPolicy", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.s3WritePolicy = software.amazon.jsii.Kernel.get(this, "s3WritePolicy", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.sesBulkTemplatedCrudPolicy = software.amazon.jsii.Kernel.get(this, "sesBulkTemplatedCrudPolicy", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.sesCrudPolicy = software.amazon.jsii.Kernel.get(this, "sesCrudPolicy", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.sesEmailTemplateCrudPolicy = software.amazon.jsii.Kernel.get(this, "sesEmailTemplateCrudPolicy", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.sesSendBouncePolicy = software.amazon.jsii.Kernel.get(this, "sesSendBouncePolicy", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.snsCrudPolicy = software.amazon.jsii.Kernel.get(this, "snsCrudPolicy", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.snsPublishMessagePolicy = software.amazon.jsii.Kernel.get(this, "snsPublishMessagePolicy", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.sqsPollerPolicy = software.amazon.jsii.Kernel.get(this, "sqsPollerPolicy", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.sqsSendMessagePolicy = software.amazon.jsii.Kernel.get(this, "sqsSendMessagePolicy", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.ssmParameterReadPolicy = software.amazon.jsii.Kernel.get(this, "ssmParameterReadPolicy", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.stepFunctionsExecutionPolicy = software.amazon.jsii.Kernel.get(this, "stepFunctionsExecutionPolicy", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.vpcAccessPolicy = software.amazon.jsii.Kernel.get(this, "vpcAccessPolicy", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.amiDescribePolicy = builder.amiDescribePolicy;
                this.awsSecretsManagerGetSecretValuePolicy = builder.awsSecretsManagerGetSecretValuePolicy;
                this.cloudFormationDescribeStacksPolicy = builder.cloudFormationDescribeStacksPolicy;
                this.cloudWatchPutMetricPolicy = builder.cloudWatchPutMetricPolicy;
                this.dynamoDbCrudPolicy = builder.dynamoDbCrudPolicy;
                this.dynamoDbReadPolicy = builder.dynamoDbReadPolicy;
                this.dynamoDbStreamReadPolicy = builder.dynamoDbStreamReadPolicy;
                this.dynamoDbWritePolicy = builder.dynamoDbWritePolicy;
                this.ec2DescribePolicy = builder.ec2DescribePolicy;
                this.elasticsearchHttpPostPolicy = builder.elasticsearchHttpPostPolicy;
                this.filterLogEventsPolicy = builder.filterLogEventsPolicy;
                this.kinesisCrudPolicy = builder.kinesisCrudPolicy;
                this.kinesisStreamReadPolicy = builder.kinesisStreamReadPolicy;
                this.kmsDecryptPolicy = builder.kmsDecryptPolicy;
                this.lambdaInvokePolicy = builder.lambdaInvokePolicy;
                this.rekognitionDetectOnlyPolicy = builder.rekognitionDetectOnlyPolicy;
                this.rekognitionLabelsPolicy = builder.rekognitionLabelsPolicy;
                this.rekognitionNoDataAccessPolicy = builder.rekognitionNoDataAccessPolicy;
                this.rekognitionReadPolicy = builder.rekognitionReadPolicy;
                this.rekognitionWriteOnlyAccessPolicy = builder.rekognitionWriteOnlyAccessPolicy;
                this.s3CrudPolicy = builder.s3CrudPolicy;
                this.s3ReadPolicy = builder.s3ReadPolicy;
                this.s3WritePolicy = builder.s3WritePolicy;
                this.sesBulkTemplatedCrudPolicy = builder.sesBulkTemplatedCrudPolicy;
                this.sesCrudPolicy = builder.sesCrudPolicy;
                this.sesEmailTemplateCrudPolicy = builder.sesEmailTemplateCrudPolicy;
                this.sesSendBouncePolicy = builder.sesSendBouncePolicy;
                this.snsCrudPolicy = builder.snsCrudPolicy;
                this.snsPublishMessagePolicy = builder.snsPublishMessagePolicy;
                this.sqsPollerPolicy = builder.sqsPollerPolicy;
                this.sqsSendMessagePolicy = builder.sqsSendMessagePolicy;
                this.ssmParameterReadPolicy = builder.ssmParameterReadPolicy;
                this.stepFunctionsExecutionPolicy = builder.stepFunctionsExecutionPolicy;
                this.vpcAccessPolicy = builder.vpcAccessPolicy;
            }

            @Override
            public final java.lang.Object getAmiDescribePolicy() {
                return this.amiDescribePolicy;
            }

            @Override
            public final java.lang.Object getAwsSecretsManagerGetSecretValuePolicy() {
                return this.awsSecretsManagerGetSecretValuePolicy;
            }

            @Override
            public final java.lang.Object getCloudFormationDescribeStacksPolicy() {
                return this.cloudFormationDescribeStacksPolicy;
            }

            @Override
            public final java.lang.Object getCloudWatchPutMetricPolicy() {
                return this.cloudWatchPutMetricPolicy;
            }

            @Override
            public final java.lang.Object getDynamoDbCrudPolicy() {
                return this.dynamoDbCrudPolicy;
            }

            @Override
            public final java.lang.Object getDynamoDbReadPolicy() {
                return this.dynamoDbReadPolicy;
            }

            @Override
            public final java.lang.Object getDynamoDbStreamReadPolicy() {
                return this.dynamoDbStreamReadPolicy;
            }

            @Override
            public final java.lang.Object getDynamoDbWritePolicy() {
                return this.dynamoDbWritePolicy;
            }

            @Override
            public final java.lang.Object getEc2DescribePolicy() {
                return this.ec2DescribePolicy;
            }

            @Override
            public final java.lang.Object getElasticsearchHttpPostPolicy() {
                return this.elasticsearchHttpPostPolicy;
            }

            @Override
            public final java.lang.Object getFilterLogEventsPolicy() {
                return this.filterLogEventsPolicy;
            }

            @Override
            public final java.lang.Object getKinesisCrudPolicy() {
                return this.kinesisCrudPolicy;
            }

            @Override
            public final java.lang.Object getKinesisStreamReadPolicy() {
                return this.kinesisStreamReadPolicy;
            }

            @Override
            public final java.lang.Object getKmsDecryptPolicy() {
                return this.kmsDecryptPolicy;
            }

            @Override
            public final java.lang.Object getLambdaInvokePolicy() {
                return this.lambdaInvokePolicy;
            }

            @Override
            public final java.lang.Object getRekognitionDetectOnlyPolicy() {
                return this.rekognitionDetectOnlyPolicy;
            }

            @Override
            public final java.lang.Object getRekognitionLabelsPolicy() {
                return this.rekognitionLabelsPolicy;
            }

            @Override
            public final java.lang.Object getRekognitionNoDataAccessPolicy() {
                return this.rekognitionNoDataAccessPolicy;
            }

            @Override
            public final java.lang.Object getRekognitionReadPolicy() {
                return this.rekognitionReadPolicy;
            }

            @Override
            public final java.lang.Object getRekognitionWriteOnlyAccessPolicy() {
                return this.rekognitionWriteOnlyAccessPolicy;
            }

            @Override
            public final java.lang.Object getS3CrudPolicy() {
                return this.s3CrudPolicy;
            }

            @Override
            public final java.lang.Object getS3ReadPolicy() {
                return this.s3ReadPolicy;
            }

            @Override
            public final java.lang.Object getS3WritePolicy() {
                return this.s3WritePolicy;
            }

            @Override
            public final java.lang.Object getSesBulkTemplatedCrudPolicy() {
                return this.sesBulkTemplatedCrudPolicy;
            }

            @Override
            public final java.lang.Object getSesCrudPolicy() {
                return this.sesCrudPolicy;
            }

            @Override
            public final java.lang.Object getSesEmailTemplateCrudPolicy() {
                return this.sesEmailTemplateCrudPolicy;
            }

            @Override
            public final java.lang.Object getSesSendBouncePolicy() {
                return this.sesSendBouncePolicy;
            }

            @Override
            public final java.lang.Object getSnsCrudPolicy() {
                return this.snsCrudPolicy;
            }

            @Override
            public final java.lang.Object getSnsPublishMessagePolicy() {
                return this.snsPublishMessagePolicy;
            }

            @Override
            public final java.lang.Object getSqsPollerPolicy() {
                return this.sqsPollerPolicy;
            }

            @Override
            public final java.lang.Object getSqsSendMessagePolicy() {
                return this.sqsSendMessagePolicy;
            }

            @Override
            public final java.lang.Object getSsmParameterReadPolicy() {
                return this.ssmParameterReadPolicy;
            }

            @Override
            public final java.lang.Object getStepFunctionsExecutionPolicy() {
                return this.stepFunctionsExecutionPolicy;
            }

            @Override
            public final java.lang.Object getVpcAccessPolicy() {
                return this.vpcAccessPolicy;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAmiDescribePolicy() != null) {
                    data.set("amiDescribePolicy", om.valueToTree(this.getAmiDescribePolicy()));
                }
                if (this.getAwsSecretsManagerGetSecretValuePolicy() != null) {
                    data.set("awsSecretsManagerGetSecretValuePolicy", om.valueToTree(this.getAwsSecretsManagerGetSecretValuePolicy()));
                }
                if (this.getCloudFormationDescribeStacksPolicy() != null) {
                    data.set("cloudFormationDescribeStacksPolicy", om.valueToTree(this.getCloudFormationDescribeStacksPolicy()));
                }
                if (this.getCloudWatchPutMetricPolicy() != null) {
                    data.set("cloudWatchPutMetricPolicy", om.valueToTree(this.getCloudWatchPutMetricPolicy()));
                }
                if (this.getDynamoDbCrudPolicy() != null) {
                    data.set("dynamoDbCrudPolicy", om.valueToTree(this.getDynamoDbCrudPolicy()));
                }
                if (this.getDynamoDbReadPolicy() != null) {
                    data.set("dynamoDbReadPolicy", om.valueToTree(this.getDynamoDbReadPolicy()));
                }
                if (this.getDynamoDbStreamReadPolicy() != null) {
                    data.set("dynamoDbStreamReadPolicy", om.valueToTree(this.getDynamoDbStreamReadPolicy()));
                }
                if (this.getDynamoDbWritePolicy() != null) {
                    data.set("dynamoDbWritePolicy", om.valueToTree(this.getDynamoDbWritePolicy()));
                }
                if (this.getEc2DescribePolicy() != null) {
                    data.set("ec2DescribePolicy", om.valueToTree(this.getEc2DescribePolicy()));
                }
                if (this.getElasticsearchHttpPostPolicy() != null) {
                    data.set("elasticsearchHttpPostPolicy", om.valueToTree(this.getElasticsearchHttpPostPolicy()));
                }
                if (this.getFilterLogEventsPolicy() != null) {
                    data.set("filterLogEventsPolicy", om.valueToTree(this.getFilterLogEventsPolicy()));
                }
                if (this.getKinesisCrudPolicy() != null) {
                    data.set("kinesisCrudPolicy", om.valueToTree(this.getKinesisCrudPolicy()));
                }
                if (this.getKinesisStreamReadPolicy() != null) {
                    data.set("kinesisStreamReadPolicy", om.valueToTree(this.getKinesisStreamReadPolicy()));
                }
                if (this.getKmsDecryptPolicy() != null) {
                    data.set("kmsDecryptPolicy", om.valueToTree(this.getKmsDecryptPolicy()));
                }
                if (this.getLambdaInvokePolicy() != null) {
                    data.set("lambdaInvokePolicy", om.valueToTree(this.getLambdaInvokePolicy()));
                }
                if (this.getRekognitionDetectOnlyPolicy() != null) {
                    data.set("rekognitionDetectOnlyPolicy", om.valueToTree(this.getRekognitionDetectOnlyPolicy()));
                }
                if (this.getRekognitionLabelsPolicy() != null) {
                    data.set("rekognitionLabelsPolicy", om.valueToTree(this.getRekognitionLabelsPolicy()));
                }
                if (this.getRekognitionNoDataAccessPolicy() != null) {
                    data.set("rekognitionNoDataAccessPolicy", om.valueToTree(this.getRekognitionNoDataAccessPolicy()));
                }
                if (this.getRekognitionReadPolicy() != null) {
                    data.set("rekognitionReadPolicy", om.valueToTree(this.getRekognitionReadPolicy()));
                }
                if (this.getRekognitionWriteOnlyAccessPolicy() != null) {
                    data.set("rekognitionWriteOnlyAccessPolicy", om.valueToTree(this.getRekognitionWriteOnlyAccessPolicy()));
                }
                if (this.getS3CrudPolicy() != null) {
                    data.set("s3CrudPolicy", om.valueToTree(this.getS3CrudPolicy()));
                }
                if (this.getS3ReadPolicy() != null) {
                    data.set("s3ReadPolicy", om.valueToTree(this.getS3ReadPolicy()));
                }
                if (this.getS3WritePolicy() != null) {
                    data.set("s3WritePolicy", om.valueToTree(this.getS3WritePolicy()));
                }
                if (this.getSesBulkTemplatedCrudPolicy() != null) {
                    data.set("sesBulkTemplatedCrudPolicy", om.valueToTree(this.getSesBulkTemplatedCrudPolicy()));
                }
                if (this.getSesCrudPolicy() != null) {
                    data.set("sesCrudPolicy", om.valueToTree(this.getSesCrudPolicy()));
                }
                if (this.getSesEmailTemplateCrudPolicy() != null) {
                    data.set("sesEmailTemplateCrudPolicy", om.valueToTree(this.getSesEmailTemplateCrudPolicy()));
                }
                if (this.getSesSendBouncePolicy() != null) {
                    data.set("sesSendBouncePolicy", om.valueToTree(this.getSesSendBouncePolicy()));
                }
                if (this.getSnsCrudPolicy() != null) {
                    data.set("snsCrudPolicy", om.valueToTree(this.getSnsCrudPolicy()));
                }
                if (this.getSnsPublishMessagePolicy() != null) {
                    data.set("snsPublishMessagePolicy", om.valueToTree(this.getSnsPublishMessagePolicy()));
                }
                if (this.getSqsPollerPolicy() != null) {
                    data.set("sqsPollerPolicy", om.valueToTree(this.getSqsPollerPolicy()));
                }
                if (this.getSqsSendMessagePolicy() != null) {
                    data.set("sqsSendMessagePolicy", om.valueToTree(this.getSqsSendMessagePolicy()));
                }
                if (this.getSsmParameterReadPolicy() != null) {
                    data.set("ssmParameterReadPolicy", om.valueToTree(this.getSsmParameterReadPolicy()));
                }
                if (this.getStepFunctionsExecutionPolicy() != null) {
                    data.set("stepFunctionsExecutionPolicy", om.valueToTree(this.getStepFunctionsExecutionPolicy()));
                }
                if (this.getVpcAccessPolicy() != null) {
                    data.set("vpcAccessPolicy", om.valueToTree(this.getVpcAccessPolicy()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_sam.CfnFunction.SAMPolicyTemplateProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SAMPolicyTemplateProperty.Jsii$Proxy that = (SAMPolicyTemplateProperty.Jsii$Proxy) o;

                if (this.amiDescribePolicy != null ? !this.amiDescribePolicy.equals(that.amiDescribePolicy) : that.amiDescribePolicy != null) return false;
                if (this.awsSecretsManagerGetSecretValuePolicy != null ? !this.awsSecretsManagerGetSecretValuePolicy.equals(that.awsSecretsManagerGetSecretValuePolicy) : that.awsSecretsManagerGetSecretValuePolicy != null) return false;
                if (this.cloudFormationDescribeStacksPolicy != null ? !this.cloudFormationDescribeStacksPolicy.equals(that.cloudFormationDescribeStacksPolicy) : that.cloudFormationDescribeStacksPolicy != null) return false;
                if (this.cloudWatchPutMetricPolicy != null ? !this.cloudWatchPutMetricPolicy.equals(that.cloudWatchPutMetricPolicy) : that.cloudWatchPutMetricPolicy != null) return false;
                if (this.dynamoDbCrudPolicy != null ? !this.dynamoDbCrudPolicy.equals(that.dynamoDbCrudPolicy) : that.dynamoDbCrudPolicy != null) return false;
                if (this.dynamoDbReadPolicy != null ? !this.dynamoDbReadPolicy.equals(that.dynamoDbReadPolicy) : that.dynamoDbReadPolicy != null) return false;
                if (this.dynamoDbStreamReadPolicy != null ? !this.dynamoDbStreamReadPolicy.equals(that.dynamoDbStreamReadPolicy) : that.dynamoDbStreamReadPolicy != null) return false;
                if (this.dynamoDbWritePolicy != null ? !this.dynamoDbWritePolicy.equals(that.dynamoDbWritePolicy) : that.dynamoDbWritePolicy != null) return false;
                if (this.ec2DescribePolicy != null ? !this.ec2DescribePolicy.equals(that.ec2DescribePolicy) : that.ec2DescribePolicy != null) return false;
                if (this.elasticsearchHttpPostPolicy != null ? !this.elasticsearchHttpPostPolicy.equals(that.elasticsearchHttpPostPolicy) : that.elasticsearchHttpPostPolicy != null) return false;
                if (this.filterLogEventsPolicy != null ? !this.filterLogEventsPolicy.equals(that.filterLogEventsPolicy) : that.filterLogEventsPolicy != null) return false;
                if (this.kinesisCrudPolicy != null ? !this.kinesisCrudPolicy.equals(that.kinesisCrudPolicy) : that.kinesisCrudPolicy != null) return false;
                if (this.kinesisStreamReadPolicy != null ? !this.kinesisStreamReadPolicy.equals(that.kinesisStreamReadPolicy) : that.kinesisStreamReadPolicy != null) return false;
                if (this.kmsDecryptPolicy != null ? !this.kmsDecryptPolicy.equals(that.kmsDecryptPolicy) : that.kmsDecryptPolicy != null) return false;
                if (this.lambdaInvokePolicy != null ? !this.lambdaInvokePolicy.equals(that.lambdaInvokePolicy) : that.lambdaInvokePolicy != null) return false;
                if (this.rekognitionDetectOnlyPolicy != null ? !this.rekognitionDetectOnlyPolicy.equals(that.rekognitionDetectOnlyPolicy) : that.rekognitionDetectOnlyPolicy != null) return false;
                if (this.rekognitionLabelsPolicy != null ? !this.rekognitionLabelsPolicy.equals(that.rekognitionLabelsPolicy) : that.rekognitionLabelsPolicy != null) return false;
                if (this.rekognitionNoDataAccessPolicy != null ? !this.rekognitionNoDataAccessPolicy.equals(that.rekognitionNoDataAccessPolicy) : that.rekognitionNoDataAccessPolicy != null) return false;
                if (this.rekognitionReadPolicy != null ? !this.rekognitionReadPolicy.equals(that.rekognitionReadPolicy) : that.rekognitionReadPolicy != null) return false;
                if (this.rekognitionWriteOnlyAccessPolicy != null ? !this.rekognitionWriteOnlyAccessPolicy.equals(that.rekognitionWriteOnlyAccessPolicy) : that.rekognitionWriteOnlyAccessPolicy != null) return false;
                if (this.s3CrudPolicy != null ? !this.s3CrudPolicy.equals(that.s3CrudPolicy) : that.s3CrudPolicy != null) return false;
                if (this.s3ReadPolicy != null ? !this.s3ReadPolicy.equals(that.s3ReadPolicy) : that.s3ReadPolicy != null) return false;
                if (this.s3WritePolicy != null ? !this.s3WritePolicy.equals(that.s3WritePolicy) : that.s3WritePolicy != null) return false;
                if (this.sesBulkTemplatedCrudPolicy != null ? !this.sesBulkTemplatedCrudPolicy.equals(that.sesBulkTemplatedCrudPolicy) : that.sesBulkTemplatedCrudPolicy != null) return false;
                if (this.sesCrudPolicy != null ? !this.sesCrudPolicy.equals(that.sesCrudPolicy) : that.sesCrudPolicy != null) return false;
                if (this.sesEmailTemplateCrudPolicy != null ? !this.sesEmailTemplateCrudPolicy.equals(that.sesEmailTemplateCrudPolicy) : that.sesEmailTemplateCrudPolicy != null) return false;
                if (this.sesSendBouncePolicy != null ? !this.sesSendBouncePolicy.equals(that.sesSendBouncePolicy) : that.sesSendBouncePolicy != null) return false;
                if (this.snsCrudPolicy != null ? !this.snsCrudPolicy.equals(that.snsCrudPolicy) : that.snsCrudPolicy != null) return false;
                if (this.snsPublishMessagePolicy != null ? !this.snsPublishMessagePolicy.equals(that.snsPublishMessagePolicy) : that.snsPublishMessagePolicy != null) return false;
                if (this.sqsPollerPolicy != null ? !this.sqsPollerPolicy.equals(that.sqsPollerPolicy) : that.sqsPollerPolicy != null) return false;
                if (this.sqsSendMessagePolicy != null ? !this.sqsSendMessagePolicy.equals(that.sqsSendMessagePolicy) : that.sqsSendMessagePolicy != null) return false;
                if (this.ssmParameterReadPolicy != null ? !this.ssmParameterReadPolicy.equals(that.ssmParameterReadPolicy) : that.ssmParameterReadPolicy != null) return false;
                if (this.stepFunctionsExecutionPolicy != null ? !this.stepFunctionsExecutionPolicy.equals(that.stepFunctionsExecutionPolicy) : that.stepFunctionsExecutionPolicy != null) return false;
                return this.vpcAccessPolicy != null ? this.vpcAccessPolicy.equals(that.vpcAccessPolicy) : that.vpcAccessPolicy == null;
            }

            @Override
            public final int hashCode() {
                int result = this.amiDescribePolicy != null ? this.amiDescribePolicy.hashCode() : 0;
                result = 31 * result + (this.awsSecretsManagerGetSecretValuePolicy != null ? this.awsSecretsManagerGetSecretValuePolicy.hashCode() : 0);
                result = 31 * result + (this.cloudFormationDescribeStacksPolicy != null ? this.cloudFormationDescribeStacksPolicy.hashCode() : 0);
                result = 31 * result + (this.cloudWatchPutMetricPolicy != null ? this.cloudWatchPutMetricPolicy.hashCode() : 0);
                result = 31 * result + (this.dynamoDbCrudPolicy != null ? this.dynamoDbCrudPolicy.hashCode() : 0);
                result = 31 * result + (this.dynamoDbReadPolicy != null ? this.dynamoDbReadPolicy.hashCode() : 0);
                result = 31 * result + (this.dynamoDbStreamReadPolicy != null ? this.dynamoDbStreamReadPolicy.hashCode() : 0);
                result = 31 * result + (this.dynamoDbWritePolicy != null ? this.dynamoDbWritePolicy.hashCode() : 0);
                result = 31 * result + (this.ec2DescribePolicy != null ? this.ec2DescribePolicy.hashCode() : 0);
                result = 31 * result + (this.elasticsearchHttpPostPolicy != null ? this.elasticsearchHttpPostPolicy.hashCode() : 0);
                result = 31 * result + (this.filterLogEventsPolicy != null ? this.filterLogEventsPolicy.hashCode() : 0);
                result = 31 * result + (this.kinesisCrudPolicy != null ? this.kinesisCrudPolicy.hashCode() : 0);
                result = 31 * result + (this.kinesisStreamReadPolicy != null ? this.kinesisStreamReadPolicy.hashCode() : 0);
                result = 31 * result + (this.kmsDecryptPolicy != null ? this.kmsDecryptPolicy.hashCode() : 0);
                result = 31 * result + (this.lambdaInvokePolicy != null ? this.lambdaInvokePolicy.hashCode() : 0);
                result = 31 * result + (this.rekognitionDetectOnlyPolicy != null ? this.rekognitionDetectOnlyPolicy.hashCode() : 0);
                result = 31 * result + (this.rekognitionLabelsPolicy != null ? this.rekognitionLabelsPolicy.hashCode() : 0);
                result = 31 * result + (this.rekognitionNoDataAccessPolicy != null ? this.rekognitionNoDataAccessPolicy.hashCode() : 0);
                result = 31 * result + (this.rekognitionReadPolicy != null ? this.rekognitionReadPolicy.hashCode() : 0);
                result = 31 * result + (this.rekognitionWriteOnlyAccessPolicy != null ? this.rekognitionWriteOnlyAccessPolicy.hashCode() : 0);
                result = 31 * result + (this.s3CrudPolicy != null ? this.s3CrudPolicy.hashCode() : 0);
                result = 31 * result + (this.s3ReadPolicy != null ? this.s3ReadPolicy.hashCode() : 0);
                result = 31 * result + (this.s3WritePolicy != null ? this.s3WritePolicy.hashCode() : 0);
                result = 31 * result + (this.sesBulkTemplatedCrudPolicy != null ? this.sesBulkTemplatedCrudPolicy.hashCode() : 0);
                result = 31 * result + (this.sesCrudPolicy != null ? this.sesCrudPolicy.hashCode() : 0);
                result = 31 * result + (this.sesEmailTemplateCrudPolicy != null ? this.sesEmailTemplateCrudPolicy.hashCode() : 0);
                result = 31 * result + (this.sesSendBouncePolicy != null ? this.sesSendBouncePolicy.hashCode() : 0);
                result = 31 * result + (this.snsCrudPolicy != null ? this.snsCrudPolicy.hashCode() : 0);
                result = 31 * result + (this.snsPublishMessagePolicy != null ? this.snsPublishMessagePolicy.hashCode() : 0);
                result = 31 * result + (this.sqsPollerPolicy != null ? this.sqsPollerPolicy.hashCode() : 0);
                result = 31 * result + (this.sqsSendMessagePolicy != null ? this.sqsSendMessagePolicy.hashCode() : 0);
                result = 31 * result + (this.ssmParameterReadPolicy != null ? this.ssmParameterReadPolicy.hashCode() : 0);
                result = 31 * result + (this.stepFunctionsExecutionPolicy != null ? this.stepFunctionsExecutionPolicy.hashCode() : 0);
                result = 31 * result + (this.vpcAccessPolicy != null ? this.vpcAccessPolicy.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sam.*;
     * SNSEventProperty sNSEventProperty = SNSEventProperty.builder()
     *         .topic("topic")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-snsevent.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-snsevent.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_sam.CfnFunction.SNSEventProperty")
    @software.amazon.jsii.Jsii.Proxy(SNSEventProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SNSEventProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-snsevent.html#cfn-serverless-function-snsevent-topic">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-snsevent.html#cfn-serverless-function-snsevent-topic</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getTopic();

        /**
         * @return a {@link Builder} of {@link SNSEventProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SNSEventProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SNSEventProperty> {
            java.lang.String topic;

            /**
             * Sets the value of {@link SNSEventProperty#getTopic}
             * @param topic the value to be set. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder topic(java.lang.String topic) {
                this.topic = topic;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SNSEventProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SNSEventProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SNSEventProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SNSEventProperty {
            private final java.lang.String topic;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.topic = software.amazon.jsii.Kernel.get(this, "topic", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.topic = java.util.Objects.requireNonNull(builder.topic, "topic is required");
            }

            @Override
            public final java.lang.String getTopic() {
                return this.topic;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("topic", om.valueToTree(this.getTopic()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_sam.CfnFunction.SNSEventProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SNSEventProperty.Jsii$Proxy that = (SNSEventProperty.Jsii$Proxy) o;

                return this.topic.equals(that.topic);
            }

            @Override
            public final int hashCode() {
                int result = this.topic.hashCode();
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sam.*;
     * SQSEventProperty sQSEventProperty = SQSEventProperty.builder()
     *         .queue("queue")
     *         // the properties below are optional
     *         .batchSize(123)
     *         .enabled(false)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-sqsevent.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-sqsevent.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_sam.CfnFunction.SQSEventProperty")
    @software.amazon.jsii.Jsii.Proxy(SQSEventProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SQSEventProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-sqsevent.html#cfn-serverless-function-sqsevent-queue">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-sqsevent.html#cfn-serverless-function-sqsevent-queue</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getQueue();

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-sqsevent.html#cfn-serverless-function-sqsevent-batchsize">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-sqsevent.html#cfn-serverless-function-sqsevent-batchsize</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getBatchSize() {
            return null;
        }

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-sqsevent.html#cfn-serverless-function-sqsevent-enabled">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-sqsevent.html#cfn-serverless-function-sqsevent-enabled</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEnabled() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link SQSEventProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SQSEventProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SQSEventProperty> {
            java.lang.String queue;
            java.lang.Number batchSize;
            java.lang.Object enabled;

            /**
             * Sets the value of {@link SQSEventProperty#getQueue}
             * @param queue the value to be set. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder queue(java.lang.String queue) {
                this.queue = queue;
                return this;
            }

            /**
             * Sets the value of {@link SQSEventProperty#getBatchSize}
             * @param batchSize the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder batchSize(java.lang.Number batchSize) {
                this.batchSize = batchSize;
                return this;
            }

            /**
             * Sets the value of {@link SQSEventProperty#getEnabled}
             * @param enabled the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enabled(java.lang.Boolean enabled) {
                this.enabled = enabled;
                return this;
            }

            /**
             * Sets the value of {@link SQSEventProperty#getEnabled}
             * @param enabled the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enabled(software.amazon.awscdk.IResolvable enabled) {
                this.enabled = enabled;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SQSEventProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SQSEventProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SQSEventProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SQSEventProperty {
            private final java.lang.String queue;
            private final java.lang.Number batchSize;
            private final java.lang.Object enabled;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.queue = software.amazon.jsii.Kernel.get(this, "queue", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.batchSize = software.amazon.jsii.Kernel.get(this, "batchSize", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.enabled = software.amazon.jsii.Kernel.get(this, "enabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.queue = java.util.Objects.requireNonNull(builder.queue, "queue is required");
                this.batchSize = builder.batchSize;
                this.enabled = builder.enabled;
            }

            @Override
            public final java.lang.String getQueue() {
                return this.queue;
            }

            @Override
            public final java.lang.Number getBatchSize() {
                return this.batchSize;
            }

            @Override
            public final java.lang.Object getEnabled() {
                return this.enabled;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("queue", om.valueToTree(this.getQueue()));
                if (this.getBatchSize() != null) {
                    data.set("batchSize", om.valueToTree(this.getBatchSize()));
                }
                if (this.getEnabled() != null) {
                    data.set("enabled", om.valueToTree(this.getEnabled()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_sam.CfnFunction.SQSEventProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SQSEventProperty.Jsii$Proxy that = (SQSEventProperty.Jsii$Proxy) o;

                if (!queue.equals(that.queue)) return false;
                if (this.batchSize != null ? !this.batchSize.equals(that.batchSize) : that.batchSize != null) return false;
                return this.enabled != null ? this.enabled.equals(that.enabled) : that.enabled == null;
            }

            @Override
            public final int hashCode() {
                int result = this.queue.hashCode();
                result = 31 * result + (this.batchSize != null ? this.batchSize.hashCode() : 0);
                result = 31 * result + (this.enabled != null ? this.enabled.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sam.*;
     * ScheduleEventProperty scheduleEventProperty = ScheduleEventProperty.builder()
     *         .schedule("schedule")
     *         // the properties below are optional
     *         .description("description")
     *         .enabled(false)
     *         .input("input")
     *         .name("name")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-scheduleevent.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-scheduleevent.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_sam.CfnFunction.ScheduleEventProperty")
    @software.amazon.jsii.Jsii.Proxy(ScheduleEventProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ScheduleEventProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-scheduleevent.html#cfn-serverless-function-scheduleevent-schedule">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-scheduleevent.html#cfn-serverless-function-scheduleevent-schedule</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getSchedule();

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-scheduleevent.html#cfn-serverless-function-scheduleevent-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-scheduleevent.html#cfn-serverless-function-scheduleevent-description</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
            return null;
        }

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-scheduleevent.html#cfn-serverless-function-scheduleevent-enabled">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-scheduleevent.html#cfn-serverless-function-scheduleevent-enabled</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEnabled() {
            return null;
        }

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-scheduleevent.html#cfn-serverless-function-scheduleevent-input">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-scheduleevent.html#cfn-serverless-function-scheduleevent-input</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getInput() {
            return null;
        }

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-scheduleevent.html#cfn-serverless-function-scheduleevent-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-scheduleevent.html#cfn-serverless-function-scheduleevent-name</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getName() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ScheduleEventProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ScheduleEventProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ScheduleEventProperty> {
            java.lang.String schedule;
            java.lang.String description;
            java.lang.Object enabled;
            java.lang.String input;
            java.lang.String name;

            /**
             * Sets the value of {@link ScheduleEventProperty#getSchedule}
             * @param schedule the value to be set. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder schedule(java.lang.String schedule) {
                this.schedule = schedule;
                return this;
            }

            /**
             * Sets the value of {@link ScheduleEventProperty#getDescription}
             * @param description the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder description(java.lang.String description) {
                this.description = description;
                return this;
            }

            /**
             * Sets the value of {@link ScheduleEventProperty#getEnabled}
             * @param enabled the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enabled(java.lang.Boolean enabled) {
                this.enabled = enabled;
                return this;
            }

            /**
             * Sets the value of {@link ScheduleEventProperty#getEnabled}
             * @param enabled the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enabled(software.amazon.awscdk.IResolvable enabled) {
                this.enabled = enabled;
                return this;
            }

            /**
             * Sets the value of {@link ScheduleEventProperty#getInput}
             * @param input the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder input(java.lang.String input) {
                this.input = input;
                return this;
            }

            /**
             * Sets the value of {@link ScheduleEventProperty#getName}
             * @param name the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ScheduleEventProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ScheduleEventProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ScheduleEventProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ScheduleEventProperty {
            private final java.lang.String schedule;
            private final java.lang.String description;
            private final java.lang.Object enabled;
            private final java.lang.String input;
            private final java.lang.String name;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.schedule = software.amazon.jsii.Kernel.get(this, "schedule", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.enabled = software.amazon.jsii.Kernel.get(this, "enabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.input = software.amazon.jsii.Kernel.get(this, "input", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.schedule = java.util.Objects.requireNonNull(builder.schedule, "schedule is required");
                this.description = builder.description;
                this.enabled = builder.enabled;
                this.input = builder.input;
                this.name = builder.name;
            }

            @Override
            public final java.lang.String getSchedule() {
                return this.schedule;
            }

            @Override
            public final java.lang.String getDescription() {
                return this.description;
            }

            @Override
            public final java.lang.Object getEnabled() {
                return this.enabled;
            }

            @Override
            public final java.lang.String getInput() {
                return this.input;
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("schedule", om.valueToTree(this.getSchedule()));
                if (this.getDescription() != null) {
                    data.set("description", om.valueToTree(this.getDescription()));
                }
                if (this.getEnabled() != null) {
                    data.set("enabled", om.valueToTree(this.getEnabled()));
                }
                if (this.getInput() != null) {
                    data.set("input", om.valueToTree(this.getInput()));
                }
                if (this.getName() != null) {
                    data.set("name", om.valueToTree(this.getName()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_sam.CfnFunction.ScheduleEventProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ScheduleEventProperty.Jsii$Proxy that = (ScheduleEventProperty.Jsii$Proxy) o;

                if (!schedule.equals(that.schedule)) return false;
                if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
                if (this.enabled != null ? !this.enabled.equals(that.enabled) : that.enabled != null) return false;
                if (this.input != null ? !this.input.equals(that.input) : that.input != null) return false;
                return this.name != null ? this.name.equals(that.name) : that.name == null;
            }

            @Override
            public final int hashCode() {
                int result = this.schedule.hashCode();
                result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
                result = 31 * result + (this.enabled != null ? this.enabled.hashCode() : 0);
                result = 31 * result + (this.input != null ? this.input.hashCode() : 0);
                result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sam.*;
     * SecretArnSAMPTProperty secretArnSAMPTProperty = SecretArnSAMPTProperty.builder()
     *         .secretArn("secretArn")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-secretarnsampt.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-secretarnsampt.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_sam.CfnFunction.SecretArnSAMPTProperty")
    @software.amazon.jsii.Jsii.Proxy(SecretArnSAMPTProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SecretArnSAMPTProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-secretarnsampt.html#cfn-serverless-function-secretarnsampt-secretarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-secretarnsampt.html#cfn-serverless-function-secretarnsampt-secretarn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getSecretArn();

        /**
         * @return a {@link Builder} of {@link SecretArnSAMPTProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SecretArnSAMPTProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SecretArnSAMPTProperty> {
            java.lang.String secretArn;

            /**
             * Sets the value of {@link SecretArnSAMPTProperty#getSecretArn}
             * @param secretArn the value to be set. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder secretArn(java.lang.String secretArn) {
                this.secretArn = secretArn;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SecretArnSAMPTProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SecretArnSAMPTProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SecretArnSAMPTProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SecretArnSAMPTProperty {
            private final java.lang.String secretArn;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.secretArn = software.amazon.jsii.Kernel.get(this, "secretArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.secretArn = java.util.Objects.requireNonNull(builder.secretArn, "secretArn is required");
            }

            @Override
            public final java.lang.String getSecretArn() {
                return this.secretArn;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("secretArn", om.valueToTree(this.getSecretArn()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_sam.CfnFunction.SecretArnSAMPTProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SecretArnSAMPTProperty.Jsii$Proxy that = (SecretArnSAMPTProperty.Jsii$Proxy) o;

                return this.secretArn.equals(that.secretArn);
            }

            @Override
            public final int hashCode() {
                int result = this.secretArn.hashCode();
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sam.*;
     * StateMachineSAMPTProperty stateMachineSAMPTProperty = StateMachineSAMPTProperty.builder()
     *         .stateMachineName("stateMachineName")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-statemachinesampt.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-statemachinesampt.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_sam.CfnFunction.StateMachineSAMPTProperty")
    @software.amazon.jsii.Jsii.Proxy(StateMachineSAMPTProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface StateMachineSAMPTProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-statemachinesampt.html#cfn-serverless-function-statemachinesampt-statemachinename">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-statemachinesampt.html#cfn-serverless-function-statemachinesampt-statemachinename</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getStateMachineName();

        /**
         * @return a {@link Builder} of {@link StateMachineSAMPTProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link StateMachineSAMPTProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<StateMachineSAMPTProperty> {
            java.lang.String stateMachineName;

            /**
             * Sets the value of {@link StateMachineSAMPTProperty#getStateMachineName}
             * @param stateMachineName the value to be set. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder stateMachineName(java.lang.String stateMachineName) {
                this.stateMachineName = stateMachineName;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link StateMachineSAMPTProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public StateMachineSAMPTProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link StateMachineSAMPTProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements StateMachineSAMPTProperty {
            private final java.lang.String stateMachineName;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.stateMachineName = software.amazon.jsii.Kernel.get(this, "stateMachineName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.stateMachineName = java.util.Objects.requireNonNull(builder.stateMachineName, "stateMachineName is required");
            }

            @Override
            public final java.lang.String getStateMachineName() {
                return this.stateMachineName;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("stateMachineName", om.valueToTree(this.getStateMachineName()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_sam.CfnFunction.StateMachineSAMPTProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                StateMachineSAMPTProperty.Jsii$Proxy that = (StateMachineSAMPTProperty.Jsii$Proxy) o;

                return this.stateMachineName.equals(that.stateMachineName);
            }

            @Override
            public final int hashCode() {
                int result = this.stateMachineName.hashCode();
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sam.*;
     * StreamSAMPTProperty streamSAMPTProperty = StreamSAMPTProperty.builder()
     *         .streamName("streamName")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-streamsampt.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-streamsampt.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_sam.CfnFunction.StreamSAMPTProperty")
    @software.amazon.jsii.Jsii.Proxy(StreamSAMPTProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface StreamSAMPTProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-streamsampt.html#cfn-serverless-function-streamsampt-streamname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-streamsampt.html#cfn-serverless-function-streamsampt-streamname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getStreamName();

        /**
         * @return a {@link Builder} of {@link StreamSAMPTProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link StreamSAMPTProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<StreamSAMPTProperty> {
            java.lang.String streamName;

            /**
             * Sets the value of {@link StreamSAMPTProperty#getStreamName}
             * @param streamName the value to be set. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder streamName(java.lang.String streamName) {
                this.streamName = streamName;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link StreamSAMPTProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public StreamSAMPTProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link StreamSAMPTProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements StreamSAMPTProperty {
            private final java.lang.String streamName;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.streamName = software.amazon.jsii.Kernel.get(this, "streamName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.streamName = java.util.Objects.requireNonNull(builder.streamName, "streamName is required");
            }

            @Override
            public final java.lang.String getStreamName() {
                return this.streamName;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("streamName", om.valueToTree(this.getStreamName()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_sam.CfnFunction.StreamSAMPTProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                StreamSAMPTProperty.Jsii$Proxy that = (StreamSAMPTProperty.Jsii$Proxy) o;

                return this.streamName.equals(that.streamName);
            }

            @Override
            public final int hashCode() {
                int result = this.streamName.hashCode();
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sam.*;
     * TableSAMPTProperty tableSAMPTProperty = TableSAMPTProperty.builder()
     *         .tableName("tableName")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-tablesampt.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-tablesampt.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_sam.CfnFunction.TableSAMPTProperty")
    @software.amazon.jsii.Jsii.Proxy(TableSAMPTProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface TableSAMPTProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-tablesampt.html#cfn-serverless-function-tablesampt-tablename">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-tablesampt.html#cfn-serverless-function-tablesampt-tablename</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getTableName();

        /**
         * @return a {@link Builder} of {@link TableSAMPTProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link TableSAMPTProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<TableSAMPTProperty> {
            java.lang.String tableName;

            /**
             * Sets the value of {@link TableSAMPTProperty#getTableName}
             * @param tableName the value to be set. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder tableName(java.lang.String tableName) {
                this.tableName = tableName;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TableSAMPTProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public TableSAMPTProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link TableSAMPTProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TableSAMPTProperty {
            private final java.lang.String tableName;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.tableName = software.amazon.jsii.Kernel.get(this, "tableName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.tableName = java.util.Objects.requireNonNull(builder.tableName, "tableName is required");
            }

            @Override
            public final java.lang.String getTableName() {
                return this.tableName;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("tableName", om.valueToTree(this.getTableName()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_sam.CfnFunction.TableSAMPTProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                TableSAMPTProperty.Jsii$Proxy that = (TableSAMPTProperty.Jsii$Proxy) o;

                return this.tableName.equals(that.tableName);
            }

            @Override
            public final int hashCode() {
                int result = this.tableName.hashCode();
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sam.*;
     * TableStreamSAMPTProperty tableStreamSAMPTProperty = TableStreamSAMPTProperty.builder()
     *         .streamName("streamName")
     *         .tableName("tableName")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-tablestreamsampt.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-tablestreamsampt.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_sam.CfnFunction.TableStreamSAMPTProperty")
    @software.amazon.jsii.Jsii.Proxy(TableStreamSAMPTProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface TableStreamSAMPTProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-tablestreamsampt.html#cfn-serverless-function-tablestreamsampt-streamname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-tablestreamsampt.html#cfn-serverless-function-tablestreamsampt-streamname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getStreamName();

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-tablestreamsampt.html#cfn-serverless-function-tablestreamsampt-tablename">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-tablestreamsampt.html#cfn-serverless-function-tablestreamsampt-tablename</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getTableName();

        /**
         * @return a {@link Builder} of {@link TableStreamSAMPTProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link TableStreamSAMPTProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<TableStreamSAMPTProperty> {
            java.lang.String streamName;
            java.lang.String tableName;

            /**
             * Sets the value of {@link TableStreamSAMPTProperty#getStreamName}
             * @param streamName the value to be set. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder streamName(java.lang.String streamName) {
                this.streamName = streamName;
                return this;
            }

            /**
             * Sets the value of {@link TableStreamSAMPTProperty#getTableName}
             * @param tableName the value to be set. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder tableName(java.lang.String tableName) {
                this.tableName = tableName;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TableStreamSAMPTProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public TableStreamSAMPTProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link TableStreamSAMPTProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TableStreamSAMPTProperty {
            private final java.lang.String streamName;
            private final java.lang.String tableName;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.streamName = software.amazon.jsii.Kernel.get(this, "streamName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.tableName = software.amazon.jsii.Kernel.get(this, "tableName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.streamName = java.util.Objects.requireNonNull(builder.streamName, "streamName is required");
                this.tableName = java.util.Objects.requireNonNull(builder.tableName, "tableName is required");
            }

            @Override
            public final java.lang.String getStreamName() {
                return this.streamName;
            }

            @Override
            public final java.lang.String getTableName() {
                return this.tableName;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("streamName", om.valueToTree(this.getStreamName()));
                data.set("tableName", om.valueToTree(this.getTableName()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_sam.CfnFunction.TableStreamSAMPTProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                TableStreamSAMPTProperty.Jsii$Proxy that = (TableStreamSAMPTProperty.Jsii$Proxy) o;

                if (!streamName.equals(that.streamName)) return false;
                return this.tableName.equals(that.tableName);
            }

            @Override
            public final int hashCode() {
                int result = this.streamName.hashCode();
                result = 31 * result + (this.tableName.hashCode());
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sam.*;
     * TopicSAMPTProperty topicSAMPTProperty = TopicSAMPTProperty.builder()
     *         .topicName("topicName")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-topicsampt.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-topicsampt.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_sam.CfnFunction.TopicSAMPTProperty")
    @software.amazon.jsii.Jsii.Proxy(TopicSAMPTProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface TopicSAMPTProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-topicsampt.html#cfn-serverless-function-topicsampt-topicname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-topicsampt.html#cfn-serverless-function-topicsampt-topicname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getTopicName();

        /**
         * @return a {@link Builder} of {@link TopicSAMPTProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link TopicSAMPTProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<TopicSAMPTProperty> {
            java.lang.String topicName;

            /**
             * Sets the value of {@link TopicSAMPTProperty#getTopicName}
             * @param topicName the value to be set. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder topicName(java.lang.String topicName) {
                this.topicName = topicName;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TopicSAMPTProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public TopicSAMPTProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link TopicSAMPTProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TopicSAMPTProperty {
            private final java.lang.String topicName;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.topicName = software.amazon.jsii.Kernel.get(this, "topicName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.topicName = java.util.Objects.requireNonNull(builder.topicName, "topicName is required");
            }

            @Override
            public final java.lang.String getTopicName() {
                return this.topicName;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("topicName", om.valueToTree(this.getTopicName()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_sam.CfnFunction.TopicSAMPTProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                TopicSAMPTProperty.Jsii$Proxy that = (TopicSAMPTProperty.Jsii$Proxy) o;

                return this.topicName.equals(that.topicName);
            }

            @Override
            public final int hashCode() {
                int result = this.topicName.hashCode();
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sam.*;
     * VpcConfigProperty vpcConfigProperty = VpcConfigProperty.builder()
     *         .securityGroupIds(List.of("securityGroupIds"))
     *         .subnetIds(List.of("subnetIds"))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-vpcconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-vpcconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_sam.CfnFunction.VpcConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(VpcConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface VpcConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-vpcconfig.html#cfn-serverless-function-vpcconfig-securitygroupids">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-vpcconfig.html#cfn-serverless-function-vpcconfig-securitygroupids</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getSecurityGroupIds();

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-vpcconfig.html#cfn-serverless-function-vpcconfig-subnetids">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-serverless-function-vpcconfig.html#cfn-serverless-function-vpcconfig-subnetids</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getSubnetIds();

        /**
         * @return a {@link Builder} of {@link VpcConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link VpcConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<VpcConfigProperty> {
            java.util.List<java.lang.String> securityGroupIds;
            java.util.List<java.lang.String> subnetIds;

            /**
             * Sets the value of {@link VpcConfigProperty#getSecurityGroupIds}
             * @param securityGroupIds the value to be set. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder securityGroupIds(java.util.List<java.lang.String> securityGroupIds) {
                this.securityGroupIds = securityGroupIds;
                return this;
            }

            /**
             * Sets the value of {@link VpcConfigProperty#getSubnetIds}
             * @param subnetIds the value to be set. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder subnetIds(java.util.List<java.lang.String> subnetIds) {
                this.subnetIds = subnetIds;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link VpcConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public VpcConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link VpcConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements VpcConfigProperty {
            private final java.util.List<java.lang.String> securityGroupIds;
            private final java.util.List<java.lang.String> subnetIds;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.securityGroupIds = software.amazon.jsii.Kernel.get(this, "securityGroupIds", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.subnetIds = software.amazon.jsii.Kernel.get(this, "subnetIds", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.securityGroupIds = java.util.Objects.requireNonNull(builder.securityGroupIds, "securityGroupIds is required");
                this.subnetIds = java.util.Objects.requireNonNull(builder.subnetIds, "subnetIds is required");
            }

            @Override
            public final java.util.List<java.lang.String> getSecurityGroupIds() {
                return this.securityGroupIds;
            }

            @Override
            public final java.util.List<java.lang.String> getSubnetIds() {
                return this.subnetIds;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("securityGroupIds", om.valueToTree(this.getSecurityGroupIds()));
                data.set("subnetIds", om.valueToTree(this.getSubnetIds()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_sam.CfnFunction.VpcConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                VpcConfigProperty.Jsii$Proxy that = (VpcConfigProperty.Jsii$Proxy) o;

                if (!securityGroupIds.equals(that.securityGroupIds)) return false;
                return this.subnetIds.equals(that.subnetIds);
            }

            @Override
            public final int hashCode() {
                int result = this.securityGroupIds.hashCode();
                result = 31 * result + (this.subnetIds.hashCode());
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.sam.CfnFunction}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.sam.CfnFunction> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private software.amazon.awscdk.services.sam.CfnFunctionProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
        }

        /**
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-serverless-function.html#cfn-serverless-function-architectures">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-serverless-function.html#cfn-serverless-function-architectures</a>
         * @param architectures This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder architectures(final java.util.List<java.lang.String> architectures) {
            this.props().architectures(architectures);
            return this;
        }

        /**
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-serverless-function.html#cfn-serverless-function-assumerolepolicydocument">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-serverless-function.html#cfn-serverless-function-assumerolepolicydocument</a>
         * @param assumeRolePolicyDocument This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder assumeRolePolicyDocument(final java.lang.Object assumeRolePolicyDocument) {
            this.props().assumeRolePolicyDocument(assumeRolePolicyDocument);
            return this;
        }

        /**
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-serverless-function.html#cfn-serverless-function-autopublishalias">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-serverless-function.html#cfn-serverless-function-autopublishalias</a>
         * @param autoPublishAlias This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder autoPublishAlias(final java.lang.String autoPublishAlias) {
            this.props().autoPublishAlias(autoPublishAlias);
            return this;
        }

        /**
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-serverless-function.html#cfn-serverless-function-autopublishcodesha256">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-serverless-function.html#cfn-serverless-function-autopublishcodesha256</a>
         * @param autoPublishCodeSha256 This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder autoPublishCodeSha256(final java.lang.String autoPublishCodeSha256) {
            this.props().autoPublishCodeSha256(autoPublishCodeSha256);
            return this;
        }

        /**
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-serverless-function.html#cfn-serverless-function-codesigningconfigarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-serverless-function.html#cfn-serverless-function-codesigningconfigarn</a>
         * @param codeSigningConfigArn This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder codeSigningConfigArn(final java.lang.String codeSigningConfigArn) {
            this.props().codeSigningConfigArn(codeSigningConfigArn);
            return this;
        }

        /**
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-serverless-function.html#cfn-serverless-function-codeuri">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-serverless-function.html#cfn-serverless-function-codeuri</a>
         * @param codeUri This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder codeUri(final java.lang.String codeUri) {
            this.props().codeUri(codeUri);
            return this;
        }
        /**
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-serverless-function.html#cfn-serverless-function-codeuri">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-serverless-function.html#cfn-serverless-function-codeuri</a>
         * @param codeUri This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder codeUri(final software.amazon.awscdk.IResolvable codeUri) {
            this.props().codeUri(codeUri);
            return this;
        }
        /**
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-serverless-function.html#cfn-serverless-function-codeuri">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-serverless-function.html#cfn-serverless-function-codeuri</a>
         * @param codeUri This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder codeUri(final software.amazon.awscdk.services.sam.CfnFunction.S3LocationProperty codeUri) {
            this.props().codeUri(codeUri);
            return this;
        }

        /**
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-serverless-function.html#cfn-serverless-function-deadletterqueue">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-serverless-function.html#cfn-serverless-function-deadletterqueue</a>
         * @param deadLetterQueue This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deadLetterQueue(final software.amazon.awscdk.IResolvable deadLetterQueue) {
            this.props().deadLetterQueue(deadLetterQueue);
            return this;
        }
        /**
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-serverless-function.html#cfn-serverless-function-deadletterqueue">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-serverless-function.html#cfn-serverless-function-deadletterqueue</a>
         * @param deadLetterQueue This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deadLetterQueue(final software.amazon.awscdk.services.sam.CfnFunction.DeadLetterQueueProperty deadLetterQueue) {
            this.props().deadLetterQueue(deadLetterQueue);
            return this;
        }

        /**
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-serverless-function.html#cfn-serverless-function-deploymentpreference">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-serverless-function.html#cfn-serverless-function-deploymentpreference</a>
         * @param deploymentPreference This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deploymentPreference(final software.amazon.awscdk.IResolvable deploymentPreference) {
            this.props().deploymentPreference(deploymentPreference);
            return this;
        }
        /**
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-serverless-function.html#cfn-serverless-function-deploymentpreference">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-serverless-function.html#cfn-serverless-function-deploymentpreference</a>
         * @param deploymentPreference This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deploymentPreference(final software.amazon.awscdk.services.sam.CfnFunction.DeploymentPreferenceProperty deploymentPreference) {
            this.props().deploymentPreference(deploymentPreference);
            return this;
        }

        /**
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-serverless-function.html#cfn-serverless-function-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-serverless-function.html#cfn-serverless-function-description</a>
         * @param description This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(final java.lang.String description) {
            this.props().description(description);
            return this;
        }

        /**
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-serverless-function.html#cfn-serverless-function-environment">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-serverless-function.html#cfn-serverless-function-environment</a>
         * @param environment This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder environment(final software.amazon.awscdk.IResolvable environment) {
            this.props().environment(environment);
            return this;
        }
        /**
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-serverless-function.html#cfn-serverless-function-environment">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-serverless-function.html#cfn-serverless-function-environment</a>
         * @param environment This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder environment(final software.amazon.awscdk.services.sam.CfnFunction.FunctionEnvironmentProperty environment) {
            this.props().environment(environment);
            return this;
        }

        /**
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-serverless-function.html#cfn-serverless-function-ephemeralstorage">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-serverless-function.html#cfn-serverless-function-ephemeralstorage</a>
         * @param ephemeralStorage This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ephemeralStorage(final software.amazon.awscdk.IResolvable ephemeralStorage) {
            this.props().ephemeralStorage(ephemeralStorage);
            return this;
        }
        /**
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-serverless-function.html#cfn-serverless-function-ephemeralstorage">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-serverless-function.html#cfn-serverless-function-ephemeralstorage</a>
         * @param ephemeralStorage This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ephemeralStorage(final software.amazon.awscdk.services.sam.CfnFunction.EphemeralStorageProperty ephemeralStorage) {
            this.props().ephemeralStorage(ephemeralStorage);
            return this;
        }

        /**
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-serverless-function.html#cfn-serverless-function-eventinvokeconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-serverless-function.html#cfn-serverless-function-eventinvokeconfig</a>
         * @param eventInvokeConfig This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder eventInvokeConfig(final software.amazon.awscdk.IResolvable eventInvokeConfig) {
            this.props().eventInvokeConfig(eventInvokeConfig);
            return this;
        }
        /**
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-serverless-function.html#cfn-serverless-function-eventinvokeconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-serverless-function.html#cfn-serverless-function-eventinvokeconfig</a>
         * @param eventInvokeConfig This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder eventInvokeConfig(final software.amazon.awscdk.services.sam.CfnFunction.EventInvokeConfigProperty eventInvokeConfig) {
            this.props().eventInvokeConfig(eventInvokeConfig);
            return this;
        }

        /**
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-serverless-function.html#cfn-serverless-function-events">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-serverless-function.html#cfn-serverless-function-events</a>
         * @param events This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder events(final software.amazon.awscdk.IResolvable events) {
            this.props().events(events);
            return this;
        }
        /**
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-serverless-function.html#cfn-serverless-function-events">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-serverless-function.html#cfn-serverless-function-events</a>
         * @param events This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder events(final java.util.Map<java.lang.String, ? extends java.lang.Object> events) {
            this.props().events(events);
            return this;
        }

        /**
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-serverless-function.html#cfn-serverless-function-filesystemconfigs">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-serverless-function.html#cfn-serverless-function-filesystemconfigs</a>
         * @param fileSystemConfigs This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder fileSystemConfigs(final software.amazon.awscdk.IResolvable fileSystemConfigs) {
            this.props().fileSystemConfigs(fileSystemConfigs);
            return this;
        }
        /**
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-serverless-function.html#cfn-serverless-function-filesystemconfigs">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-serverless-function.html#cfn-serverless-function-filesystemconfigs</a>
         * @param fileSystemConfigs This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder fileSystemConfigs(final java.util.List<? extends java.lang.Object> fileSystemConfigs) {
            this.props().fileSystemConfigs(fileSystemConfigs);
            return this;
        }

        /**
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-serverless-function.html#cfn-serverless-function-functionname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-serverless-function.html#cfn-serverless-function-functionname</a>
         * @param functionName This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder functionName(final java.lang.String functionName) {
            this.props().functionName(functionName);
            return this;
        }

        /**
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-serverless-function.html#cfn-serverless-function-functionurlconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-serverless-function.html#cfn-serverless-function-functionurlconfig</a>
         * @param functionUrlConfig This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder functionUrlConfig(final software.amazon.awscdk.IResolvable functionUrlConfig) {
            this.props().functionUrlConfig(functionUrlConfig);
            return this;
        }
        /**
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-serverless-function.html#cfn-serverless-function-functionurlconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-serverless-function.html#cfn-serverless-function-functionurlconfig</a>
         * @param functionUrlConfig This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder functionUrlConfig(final software.amazon.awscdk.services.sam.CfnFunction.FunctionUrlConfigProperty functionUrlConfig) {
            this.props().functionUrlConfig(functionUrlConfig);
            return this;
        }

        /**
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-serverless-function.html#cfn-serverless-function-handler">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-serverless-function.html#cfn-serverless-function-handler</a>
         * @param handler This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder handler(final java.lang.String handler) {
            this.props().handler(handler);
            return this;
        }

        /**
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-serverless-function.html#cfn-serverless-function-imageconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-serverless-function.html#cfn-serverless-function-imageconfig</a>
         * @param imageConfig This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder imageConfig(final software.amazon.awscdk.IResolvable imageConfig) {
            this.props().imageConfig(imageConfig);
            return this;
        }
        /**
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-serverless-function.html#cfn-serverless-function-imageconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-serverless-function.html#cfn-serverless-function-imageconfig</a>
         * @param imageConfig This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder imageConfig(final software.amazon.awscdk.services.sam.CfnFunction.ImageConfigProperty imageConfig) {
            this.props().imageConfig(imageConfig);
            return this;
        }

        /**
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-serverless-function.html#cfn-serverless-function-imageuri">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-serverless-function.html#cfn-serverless-function-imageuri</a>
         * @param imageUri This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder imageUri(final java.lang.String imageUri) {
            this.props().imageUri(imageUri);
            return this;
        }

        /**
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-serverless-function.html#cfn-serverless-function-inlinecode">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-serverless-function.html#cfn-serverless-function-inlinecode</a>
         * @param inlineCode This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder inlineCode(final java.lang.String inlineCode) {
            this.props().inlineCode(inlineCode);
            return this;
        }

        /**
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-serverless-function.html#cfn-serverless-function-kmskeyarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-serverless-function.html#cfn-serverless-function-kmskeyarn</a>
         * @param kmsKeyArn This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder kmsKeyArn(final java.lang.String kmsKeyArn) {
            this.props().kmsKeyArn(kmsKeyArn);
            return this;
        }

        /**
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-serverless-function.html#cfn-serverless-function-layers">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-serverless-function.html#cfn-serverless-function-layers</a>
         * @param layers This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder layers(final java.util.List<java.lang.String> layers) {
            this.props().layers(layers);
            return this;
        }

        /**
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-serverless-function.html#cfn-serverless-function-memorysize">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-serverless-function.html#cfn-serverless-function-memorysize</a>
         * @param memorySize This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder memorySize(final java.lang.Number memorySize) {
            this.props().memorySize(memorySize);
            return this;
        }

        /**
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-serverless-function.html#cfn-serverless-function-packagetype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-serverless-function.html#cfn-serverless-function-packagetype</a>
         * @param packageType This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder packageType(final java.lang.String packageType) {
            this.props().packageType(packageType);
            return this;
        }

        /**
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-serverless-function.html#cfn-serverless-function-permissionsboundary">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-serverless-function.html#cfn-serverless-function-permissionsboundary</a>
         * @param permissionsBoundary This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder permissionsBoundary(final java.lang.String permissionsBoundary) {
            this.props().permissionsBoundary(permissionsBoundary);
            return this;
        }

        /**
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-serverless-function.html#cfn-serverless-function-policies">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-serverless-function.html#cfn-serverless-function-policies</a>
         * @param policies This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder policies(final java.lang.String policies) {
            this.props().policies(policies);
            return this;
        }
        /**
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-serverless-function.html#cfn-serverless-function-policies">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-serverless-function.html#cfn-serverless-function-policies</a>
         * @param policies This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder policies(final software.amazon.awscdk.IResolvable policies) {
            this.props().policies(policies);
            return this;
        }
        /**
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-serverless-function.html#cfn-serverless-function-policies">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-serverless-function.html#cfn-serverless-function-policies</a>
         * @param policies This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder policies(final software.amazon.awscdk.services.sam.CfnFunction.IAMPolicyDocumentProperty policies) {
            this.props().policies(policies);
            return this;
        }
        /**
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-serverless-function.html#cfn-serverless-function-policies">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-serverless-function.html#cfn-serverless-function-policies</a>
         * @param policies This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder policies(final java.util.List<? extends java.lang.Object> policies) {
            this.props().policies(policies);
            return this;
        }

        /**
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-serverless-function.html#cfn-serverless-function-provisionedconcurrencyconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-serverless-function.html#cfn-serverless-function-provisionedconcurrencyconfig</a>
         * @param provisionedConcurrencyConfig This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder provisionedConcurrencyConfig(final software.amazon.awscdk.IResolvable provisionedConcurrencyConfig) {
            this.props().provisionedConcurrencyConfig(provisionedConcurrencyConfig);
            return this;
        }
        /**
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-serverless-function.html#cfn-serverless-function-provisionedconcurrencyconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-serverless-function.html#cfn-serverless-function-provisionedconcurrencyconfig</a>
         * @param provisionedConcurrencyConfig This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder provisionedConcurrencyConfig(final software.amazon.awscdk.services.sam.CfnFunction.ProvisionedConcurrencyConfigProperty provisionedConcurrencyConfig) {
            this.props().provisionedConcurrencyConfig(provisionedConcurrencyConfig);
            return this;
        }

        /**
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-serverless-function.html#cfn-serverless-function-reservedconcurrentexecutions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-serverless-function.html#cfn-serverless-function-reservedconcurrentexecutions</a>
         * @param reservedConcurrentExecutions This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder reservedConcurrentExecutions(final java.lang.Number reservedConcurrentExecutions) {
            this.props().reservedConcurrentExecutions(reservedConcurrentExecutions);
            return this;
        }

        /**
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-serverless-function.html#cfn-serverless-function-role">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-serverless-function.html#cfn-serverless-function-role</a>
         * @param role This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder role(final java.lang.String role) {
            this.props().role(role);
            return this;
        }

        /**
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-serverless-function.html#cfn-serverless-function-runtime">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-serverless-function.html#cfn-serverless-function-runtime</a>
         * @param runtime This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder runtime(final java.lang.String runtime) {
            this.props().runtime(runtime);
            return this;
        }

        /**
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-serverless-function.html#cfn-serverless-function-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-serverless-function.html#cfn-serverless-function-tags</a>
         * @param tags This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.Map<java.lang.String, java.lang.String> tags) {
            this.props().tags(tags);
            return this;
        }

        /**
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-serverless-function.html#cfn-serverless-function-timeout">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-serverless-function.html#cfn-serverless-function-timeout</a>
         * @param timeout This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder timeout(final java.lang.Number timeout) {
            this.props().timeout(timeout);
            return this;
        }

        /**
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-serverless-function.html#cfn-serverless-function-tracing">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-serverless-function.html#cfn-serverless-function-tracing</a>
         * @param tracing This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tracing(final java.lang.String tracing) {
            this.props().tracing(tracing);
            return this;
        }

        /**
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-serverless-function.html#cfn-serverless-function-versiondescription">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-serverless-function.html#cfn-serverless-function-versiondescription</a>
         * @param versionDescription This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder versionDescription(final java.lang.String versionDescription) {
            this.props().versionDescription(versionDescription);
            return this;
        }

        /**
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-serverless-function.html#cfn-serverless-function-vpcconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-serverless-function.html#cfn-serverless-function-vpcconfig</a>
         * @param vpcConfig This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpcConfig(final software.amazon.awscdk.IResolvable vpcConfig) {
            this.props().vpcConfig(vpcConfig);
            return this;
        }
        /**
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-serverless-function.html#cfn-serverless-function-vpcconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-serverless-function.html#cfn-serverless-function-vpcconfig</a>
         * @param vpcConfig This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpcConfig(final software.amazon.awscdk.services.sam.CfnFunction.VpcConfigProperty vpcConfig) {
            this.props().vpcConfig(vpcConfig);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.sam.CfnFunction}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.sam.CfnFunction build() {
            return new software.amazon.awscdk.services.sam.CfnFunction(
                this.scope,
                this.id,
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.services.sam.CfnFunctionProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.services.sam.CfnFunctionProps.Builder();
            }
            return this.props;
        }
    }
}
