package software.amazon.awscdk.services.sam;

/**
 * Properties for defining a <code>CfnStateMachine</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.sam.*;
 * Object definition;
 * CfnStateMachineProps cfnStateMachineProps = CfnStateMachineProps.builder()
 *         .definition(definition)
 *         .definitionSubstitutions(Map.of(
 *                 "definitionSubstitutionsKey", "definitionSubstitutions"))
 *         .definitionUri("definitionUri")
 *         .events(Map.of(
 *                 "eventsKey", EventSourceProperty.builder()
 *                         .properties(ApiEventProperty.builder()
 *                                 .method("method")
 *                                 .path("path")
 *                                 // the properties below are optional
 *                                 .restApiId("restApiId")
 *                                 .build())
 *                         .type("type")
 *                         .build()))
 *         .logging(LoggingConfigurationProperty.builder()
 *                 .destinations(List.of(LogDestinationProperty.builder()
 *                         .cloudWatchLogsLogGroup(CloudWatchLogsLogGroupProperty.builder()
 *                                 .logGroupArn("logGroupArn")
 *                                 .build())
 *                         .build()))
 *                 .includeExecutionData(false)
 *                 .level("level")
 *                 .build())
 *         .name("name")
 *         .permissionsBoundaries("permissionsBoundaries")
 *         .policies("policies")
 *         .role("role")
 *         .tags(Map.of(
 *                 "tagsKey", "tags"))
 *         .tracing(TracingConfigurationProperty.builder()
 *                 .enabled(false)
 *                 .build())
 *         .type("type")
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-serverless-statemachine.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-serverless-statemachine.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-01-25T00:21:03.627Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_sam.CfnStateMachineProps")
@software.amazon.jsii.Jsii.Proxy(CfnStateMachineProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnStateMachineProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-serverless-statemachine.html#cfn-serverless-statemachine-definition">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-serverless-statemachine.html#cfn-serverless-statemachine-definition</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getDefinition() {
        return null;
    }

    /**
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-serverless-statemachine.html#cfn-serverless-statemachine-definitionsubstitutions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-serverless-statemachine.html#cfn-serverless-statemachine-definitionsubstitutions</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getDefinitionSubstitutions() {
        return null;
    }

    /**
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-serverless-statemachine.html#cfn-serverless-statemachine-definitionuri">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-serverless-statemachine.html#cfn-serverless-statemachine-definitionuri</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getDefinitionUri() {
        return null;
    }

    /**
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-serverless-statemachine.html#cfn-serverless-statemachine-events">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-serverless-statemachine.html#cfn-serverless-statemachine-events</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getEvents() {
        return null;
    }

    /**
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-serverless-statemachine.html#cfn-serverless-statemachine-logging">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-serverless-statemachine.html#cfn-serverless-statemachine-logging</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getLogging() {
        return null;
    }

    /**
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-serverless-statemachine.html#cfn-serverless-statemachine-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-serverless-statemachine.html#cfn-serverless-statemachine-name</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getName() {
        return null;
    }

    /**
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-serverless-statemachine.html#cfn-serverless-statemachine-permissionsboundaries">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-serverless-statemachine.html#cfn-serverless-statemachine-permissionsboundaries</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getPermissionsBoundaries() {
        return null;
    }

    /**
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-serverless-statemachine.html#cfn-serverless-statemachine-policies">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-serverless-statemachine.html#cfn-serverless-statemachine-policies</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getPolicies() {
        return null;
    }

    /**
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-serverless-statemachine.html#cfn-serverless-statemachine-role">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-serverless-statemachine.html#cfn-serverless-statemachine-role</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getRole() {
        return null;
    }

    /**
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-serverless-statemachine.html#cfn-serverless-statemachine-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-serverless-statemachine.html#cfn-serverless-statemachine-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> getTags() {
        return null;
    }

    /**
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-serverless-statemachine.html#cfn-serverless-statemachine-tracing">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-serverless-statemachine.html#cfn-serverless-statemachine-tracing</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getTracing() {
        return null;
    }

    /**
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-serverless-statemachine.html#cfn-serverless-statemachine-type">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-serverless-statemachine.html#cfn-serverless-statemachine-type</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getType() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnStateMachineProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnStateMachineProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnStateMachineProps> {
        java.lang.Object definition;
        java.lang.Object definitionSubstitutions;
        java.lang.Object definitionUri;
        java.lang.Object events;
        java.lang.Object logging;
        java.lang.String name;
        java.lang.String permissionsBoundaries;
        java.lang.Object policies;
        java.lang.String role;
        java.util.Map<java.lang.String, java.lang.String> tags;
        java.lang.Object tracing;
        java.lang.String type;

        /**
         * Sets the value of {@link CfnStateMachineProps#getDefinition}
         * @param definition the value to be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder definition(java.lang.Object definition) {
            this.definition = definition;
            return this;
        }

        /**
         * Sets the value of {@link CfnStateMachineProps#getDefinitionSubstitutions}
         * @param definitionSubstitutions the value to be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder definitionSubstitutions(software.amazon.awscdk.IResolvable definitionSubstitutions) {
            this.definitionSubstitutions = definitionSubstitutions;
            return this;
        }

        /**
         * Sets the value of {@link CfnStateMachineProps#getDefinitionSubstitutions}
         * @param definitionSubstitutions the value to be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder definitionSubstitutions(java.util.Map<java.lang.String, java.lang.String> definitionSubstitutions) {
            this.definitionSubstitutions = definitionSubstitutions;
            return this;
        }

        /**
         * Sets the value of {@link CfnStateMachineProps#getDefinitionUri}
         * @param definitionUri the value to be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder definitionUri(java.lang.String definitionUri) {
            this.definitionUri = definitionUri;
            return this;
        }

        /**
         * Sets the value of {@link CfnStateMachineProps#getDefinitionUri}
         * @param definitionUri the value to be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder definitionUri(software.amazon.awscdk.IResolvable definitionUri) {
            this.definitionUri = definitionUri;
            return this;
        }

        /**
         * Sets the value of {@link CfnStateMachineProps#getDefinitionUri}
         * @param definitionUri the value to be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder definitionUri(software.amazon.awscdk.services.sam.CfnStateMachine.S3LocationProperty definitionUri) {
            this.definitionUri = definitionUri;
            return this;
        }

        /**
         * Sets the value of {@link CfnStateMachineProps#getEvents}
         * @param events the value to be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder events(software.amazon.awscdk.IResolvable events) {
            this.events = events;
            return this;
        }

        /**
         * Sets the value of {@link CfnStateMachineProps#getEvents}
         * @param events the value to be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder events(java.util.Map<java.lang.String, ? extends java.lang.Object> events) {
            this.events = events;
            return this;
        }

        /**
         * Sets the value of {@link CfnStateMachineProps#getLogging}
         * @param logging the value to be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder logging(software.amazon.awscdk.IResolvable logging) {
            this.logging = logging;
            return this;
        }

        /**
         * Sets the value of {@link CfnStateMachineProps#getLogging}
         * @param logging the value to be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder logging(software.amazon.awscdk.services.sam.CfnStateMachine.LoggingConfigurationProperty logging) {
            this.logging = logging;
            return this;
        }

        /**
         * Sets the value of {@link CfnStateMachineProps#getName}
         * @param name the value to be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of {@link CfnStateMachineProps#getPermissionsBoundaries}
         * @param permissionsBoundaries the value to be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder permissionsBoundaries(java.lang.String permissionsBoundaries) {
            this.permissionsBoundaries = permissionsBoundaries;
            return this;
        }

        /**
         * Sets the value of {@link CfnStateMachineProps#getPolicies}
         * @param policies the value to be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder policies(java.lang.String policies) {
            this.policies = policies;
            return this;
        }

        /**
         * Sets the value of {@link CfnStateMachineProps#getPolicies}
         * @param policies the value to be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder policies(software.amazon.awscdk.IResolvable policies) {
            this.policies = policies;
            return this;
        }

        /**
         * Sets the value of {@link CfnStateMachineProps#getPolicies}
         * @param policies the value to be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder policies(software.amazon.awscdk.services.sam.CfnStateMachine.IAMPolicyDocumentProperty policies) {
            this.policies = policies;
            return this;
        }

        /**
         * Sets the value of {@link CfnStateMachineProps#getPolicies}
         * @param policies the value to be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder policies(java.util.List<? extends java.lang.Object> policies) {
            this.policies = policies;
            return this;
        }

        /**
         * Sets the value of {@link CfnStateMachineProps#getRole}
         * @param role the value to be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder role(java.lang.String role) {
            this.role = role;
            return this;
        }

        /**
         * Sets the value of {@link CfnStateMachineProps#getTags}
         * @param tags the value to be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(java.util.Map<java.lang.String, java.lang.String> tags) {
            this.tags = tags;
            return this;
        }

        /**
         * Sets the value of {@link CfnStateMachineProps#getTracing}
         * @param tracing the value to be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tracing(software.amazon.awscdk.IResolvable tracing) {
            this.tracing = tracing;
            return this;
        }

        /**
         * Sets the value of {@link CfnStateMachineProps#getTracing}
         * @param tracing the value to be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tracing(software.amazon.awscdk.services.sam.CfnStateMachine.TracingConfigurationProperty tracing) {
            this.tracing = tracing;
            return this;
        }

        /**
         * Sets the value of {@link CfnStateMachineProps#getType}
         * @param type the value to be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder type(java.lang.String type) {
            this.type = type;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnStateMachineProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnStateMachineProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnStateMachineProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnStateMachineProps {
        private final java.lang.Object definition;
        private final java.lang.Object definitionSubstitutions;
        private final java.lang.Object definitionUri;
        private final java.lang.Object events;
        private final java.lang.Object logging;
        private final java.lang.String name;
        private final java.lang.String permissionsBoundaries;
        private final java.lang.Object policies;
        private final java.lang.String role;
        private final java.util.Map<java.lang.String, java.lang.String> tags;
        private final java.lang.Object tracing;
        private final java.lang.String type;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.definition = software.amazon.jsii.Kernel.get(this, "definition", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.definitionSubstitutions = software.amazon.jsii.Kernel.get(this, "definitionSubstitutions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.definitionUri = software.amazon.jsii.Kernel.get(this, "definitionUri", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.events = software.amazon.jsii.Kernel.get(this, "events", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.logging = software.amazon.jsii.Kernel.get(this, "logging", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.permissionsBoundaries = software.amazon.jsii.Kernel.get(this, "permissionsBoundaries", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.policies = software.amazon.jsii.Kernel.get(this, "policies", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.role = software.amazon.jsii.Kernel.get(this, "role", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.tracing = software.amazon.jsii.Kernel.get(this, "tracing", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.type = software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.definition = builder.definition;
            this.definitionSubstitutions = builder.definitionSubstitutions;
            this.definitionUri = builder.definitionUri;
            this.events = builder.events;
            this.logging = builder.logging;
            this.name = builder.name;
            this.permissionsBoundaries = builder.permissionsBoundaries;
            this.policies = builder.policies;
            this.role = builder.role;
            this.tags = builder.tags;
            this.tracing = builder.tracing;
            this.type = builder.type;
        }

        @Override
        public final java.lang.Object getDefinition() {
            return this.definition;
        }

        @Override
        public final java.lang.Object getDefinitionSubstitutions() {
            return this.definitionSubstitutions;
        }

        @Override
        public final java.lang.Object getDefinitionUri() {
            return this.definitionUri;
        }

        @Override
        public final java.lang.Object getEvents() {
            return this.events;
        }

        @Override
        public final java.lang.Object getLogging() {
            return this.logging;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        public final java.lang.String getPermissionsBoundaries() {
            return this.permissionsBoundaries;
        }

        @Override
        public final java.lang.Object getPolicies() {
            return this.policies;
        }

        @Override
        public final java.lang.String getRole() {
            return this.role;
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.String> getTags() {
            return this.tags;
        }

        @Override
        public final java.lang.Object getTracing() {
            return this.tracing;
        }

        @Override
        public final java.lang.String getType() {
            return this.type;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getDefinition() != null) {
                data.set("definition", om.valueToTree(this.getDefinition()));
            }
            if (this.getDefinitionSubstitutions() != null) {
                data.set("definitionSubstitutions", om.valueToTree(this.getDefinitionSubstitutions()));
            }
            if (this.getDefinitionUri() != null) {
                data.set("definitionUri", om.valueToTree(this.getDefinitionUri()));
            }
            if (this.getEvents() != null) {
                data.set("events", om.valueToTree(this.getEvents()));
            }
            if (this.getLogging() != null) {
                data.set("logging", om.valueToTree(this.getLogging()));
            }
            if (this.getName() != null) {
                data.set("name", om.valueToTree(this.getName()));
            }
            if (this.getPermissionsBoundaries() != null) {
                data.set("permissionsBoundaries", om.valueToTree(this.getPermissionsBoundaries()));
            }
            if (this.getPolicies() != null) {
                data.set("policies", om.valueToTree(this.getPolicies()));
            }
            if (this.getRole() != null) {
                data.set("role", om.valueToTree(this.getRole()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }
            if (this.getTracing() != null) {
                data.set("tracing", om.valueToTree(this.getTracing()));
            }
            if (this.getType() != null) {
                data.set("type", om.valueToTree(this.getType()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_sam.CfnStateMachineProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnStateMachineProps.Jsii$Proxy that = (CfnStateMachineProps.Jsii$Proxy) o;

            if (this.definition != null ? !this.definition.equals(that.definition) : that.definition != null) return false;
            if (this.definitionSubstitutions != null ? !this.definitionSubstitutions.equals(that.definitionSubstitutions) : that.definitionSubstitutions != null) return false;
            if (this.definitionUri != null ? !this.definitionUri.equals(that.definitionUri) : that.definitionUri != null) return false;
            if (this.events != null ? !this.events.equals(that.events) : that.events != null) return false;
            if (this.logging != null ? !this.logging.equals(that.logging) : that.logging != null) return false;
            if (this.name != null ? !this.name.equals(that.name) : that.name != null) return false;
            if (this.permissionsBoundaries != null ? !this.permissionsBoundaries.equals(that.permissionsBoundaries) : that.permissionsBoundaries != null) return false;
            if (this.policies != null ? !this.policies.equals(that.policies) : that.policies != null) return false;
            if (this.role != null ? !this.role.equals(that.role) : that.role != null) return false;
            if (this.tags != null ? !this.tags.equals(that.tags) : that.tags != null) return false;
            if (this.tracing != null ? !this.tracing.equals(that.tracing) : that.tracing != null) return false;
            return this.type != null ? this.type.equals(that.type) : that.type == null;
        }

        @Override
        public final int hashCode() {
            int result = this.definition != null ? this.definition.hashCode() : 0;
            result = 31 * result + (this.definitionSubstitutions != null ? this.definitionSubstitutions.hashCode() : 0);
            result = 31 * result + (this.definitionUri != null ? this.definitionUri.hashCode() : 0);
            result = 31 * result + (this.events != null ? this.events.hashCode() : 0);
            result = 31 * result + (this.logging != null ? this.logging.hashCode() : 0);
            result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
            result = 31 * result + (this.permissionsBoundaries != null ? this.permissionsBoundaries.hashCode() : 0);
            result = 31 * result + (this.policies != null ? this.policies.hashCode() : 0);
            result = 31 * result + (this.role != null ? this.role.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            result = 31 * result + (this.tracing != null ? this.tracing.hashCode() : 0);
            result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
            return result;
        }
    }
}
