package software.amazon.awscdk.services.servicecatalog;

/**
 * A Service Catalog product stack, which is similar in form to a Cloudformation nested stack.
 * <p>
 * You can add the resources to this stack that you want to define for your service catalog product.
 * <p>
 * This stack will not be treated as an independent deployment
 * artifact (won't be listed in "cdk list" or deployable through "cdk deploy"),
 * but rather only synthesized as a template and uploaded as an asset to S3.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * public class S3BucketProduct extends ProductStack {
 *     public S3BucketProduct(Construct scope, String id) {
 *         super(scope, id);
 *         new Bucket(this, "BucketProductV2");
 *     }
 * }
 * ProductStackHistory productStackHistory = ProductStackHistory.Builder.create(this, "ProductStackHistory")
 *         .productStack(new S3BucketProduct(this, "S3BucketProduct"))
 *         .currentVersionName("v2")
 *         .currentVersionLocked(true)
 *         .build();
 * CloudFormationProduct product = CloudFormationProduct.Builder.create(this, "MyFirstProduct")
 *         .productName("My Product")
 *         .owner("Product Owner")
 *         .productVersions(List.of(productStackHistory.currentVersion(), productStackHistory.versionFromSnapshot("v1")))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-01-25T00:21:03.876Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_servicecatalog.ProductStack")
public class ProductStack extends software.amazon.awscdk.Stack {

    protected ProductStack(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected ProductStack(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public ProductStack(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.servicecatalog.ProductStackProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), props });
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public ProductStack(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * The name of the CloudFormation template file emitted to the output directory during synthesis.
     * <p>
     * Example value: <code>MyStack.template.json</code>
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getTemplateFile() {
        return software.amazon.jsii.Kernel.get(this, "templateFile", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.servicecatalog.ProductStack}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.servicecatalog.ProductStack> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private software.amazon.awscdk.services.servicecatalog.ProductStackProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
        }

        /**
         * Include runtime versioning information in this Stack.
         * <p>
         * Default: - `analyticsReporting` setting of containing `App`, or value of
         * 'aws:cdk:version-reporting' context key
         * <p>
         * @return {@code this}
         * @param analyticsReporting Include runtime versioning information in this Stack. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder analyticsReporting(final java.lang.Boolean analyticsReporting) {
            this.props().analyticsReporting(analyticsReporting);
            return this;
        }

        /**
         * A Bucket can be passed to store assets, enabling ProductStack Asset support.
         * <p>
         * Default: - No Bucket provided and Assets will not be supported.
         * <p>
         * @return {@code this}
         * @param assetBucket A Bucket can be passed to store assets, enabling ProductStack Asset support. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder assetBucket(final software.amazon.awscdk.services.s3.IBucket assetBucket) {
            this.props().assetBucket(assetBucket);
            return this;
        }

        /**
         * A description of the stack.
         * <p>
         * Default: - No description.
         * <p>
         * @return {@code this}
         * @param description A description of the stack. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(final java.lang.String description) {
            this.props().description(description);
            return this;
        }

        /**
         * The amount of memory (in MiB) to allocate to the AWS Lambda function which replicates the files from the CDK bucket to the destination bucket.
         * <p>
         * If you are deploying large files, you will need to increase this number
         * accordingly.
         * <p>
         * Default: 128
         * <p>
         * @return {@code this}
         * @param memoryLimit The amount of memory (in MiB) to allocate to the AWS Lambda function which replicates the files from the CDK bucket to the destination bucket. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder memoryLimit(final java.lang.Number memoryLimit) {
            this.props().memoryLimit(memoryLimit);
            return this;
        }

        /**
         * A ServerSideEncryption can be enabled to encrypt assets that are put into assetBucket.
         * <p>
         * Default: - No encryption is used
         * <p>
         * @return {@code this}
         * @param serverSideEncryption A ServerSideEncryption can be enabled to encrypt assets that are put into assetBucket. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder serverSideEncryption(final software.amazon.awscdk.services.s3.deployment.ServerSideEncryption serverSideEncryption) {
            this.props().serverSideEncryption(serverSideEncryption);
            return this;
        }

        /**
         * For AWS_KMS ServerSideEncryption a KMS KeyId must be provided which will be used to encrypt assets.
         * <p>
         * Default: - No KMS KeyId and SSE_KMS encryption cannot be used
         * <p>
         * @return {@code this}
         * @param serverSideEncryptionAwsKmsKeyId For AWS_KMS ServerSideEncryption a KMS KeyId must be provided which will be used to encrypt assets. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder serverSideEncryptionAwsKmsKeyId(final java.lang.String serverSideEncryptionAwsKmsKeyId) {
            this.props().serverSideEncryptionAwsKmsKeyId(serverSideEncryptionAwsKmsKeyId);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.servicecatalog.ProductStack}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.servicecatalog.ProductStack build() {
            return new software.amazon.awscdk.services.servicecatalog.ProductStack(
                this.scope,
                this.id,
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.services.servicecatalog.ProductStackProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.services.servicecatalog.ProductStackProps.Builder();
            }
            return this.props;
        }
    }
}
