package software.amazon.awscdk.services.ses;

/**
 * An event destination.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * ConfigurationSet myConfigurationSet;
 * Topic myTopic;
 * myConfigurationSet.addEventDestination("ToSns", ConfigurationSetEventDestinationOptions.builder()
 *         .destination(EventDestination.snsTopic(myTopic))
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-01-25T00:21:04.045Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ses.EventDestination")
public abstract class EventDestination extends software.amazon.jsii.JsiiObject {

    protected EventDestination(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected EventDestination(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected EventDestination() {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this);
    }

    /**
     * Use CloudWatch dimensions as event destination.
     * <p>
     * @param dimensions This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ses.EventDestination cloudWatchDimensions(final @org.jetbrains.annotations.NotNull java.util.List<? extends software.amazon.awscdk.services.ses.CloudWatchDimension> dimensions) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ses.EventDestination.class, "cloudWatchDimensions", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ses.EventDestination.class), new Object[] { java.util.Objects.requireNonNull(dimensions, "dimensions is required") });
    }

    /**
     * Use a SNS topic as event destination.
     * <p>
     * @param topic This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ses.EventDestination snsTopic(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.sns.ITopic topic) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ses.EventDestination.class, "snsTopic", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ses.EventDestination.class), new Object[] { java.util.Objects.requireNonNull(topic, "topic is required") });
    }

    /**
     * A list of CloudWatch dimensions upon which to categorize your emails.
     * <p>
     * Default: - do not send events to CloudWatch
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public abstract @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.ses.CloudWatchDimension> getDimensions();

    /**
     * A SNS topic to use as event destination.
     * <p>
     * Default: - do not send events to a SNS topic
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public abstract @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.sns.ITopic getTopic();

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    @software.amazon.jsii.Internal
    private static final class Jsii$Proxy extends software.amazon.awscdk.services.ses.EventDestination {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
        }

        /**
         * A list of CloudWatch dimensions upon which to categorize your emails.
         * <p>
         * Default: - do not send events to CloudWatch
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.ses.CloudWatchDimension> getDimensions() {
            return java.util.Optional.ofNullable((java.util.List<software.amazon.awscdk.services.ses.CloudWatchDimension>)(software.amazon.jsii.Kernel.get(this, "dimensions", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ses.CloudWatchDimension.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
        }

        /**
         * A SNS topic to use as event destination.
         * <p>
         * Default: - do not send events to a SNS topic
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.sns.ITopic getTopic() {
            return software.amazon.jsii.Kernel.get(this, "topic", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.sns.ITopic.class));
        }
    }
}
