package software.amazon.awscdk.services.ses;

/**
 * Properties for the Virtual Deliverability Manager (VDM) attributes.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.ses.*;
 * VdmAttributesProps vdmAttributesProps = VdmAttributesProps.builder()
 *         .engagementMetrics(false)
 *         .optimizedSharedDelivery(false)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-01-25T00:21:04.056Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ses.VdmAttributesProps")
@software.amazon.jsii.Jsii.Proxy(VdmAttributesProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface VdmAttributesProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * Whether engagement metrics are enabled for your account.
     * <p>
     * Default: true
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getEngagementMetrics() {
        return null;
    }

    /**
     * Whether optimized shared delivery is enabled for your account.
     * <p>
     * Default: true
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getOptimizedSharedDelivery() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link VdmAttributesProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link VdmAttributesProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<VdmAttributesProps> {
        java.lang.Boolean engagementMetrics;
        java.lang.Boolean optimizedSharedDelivery;

        /**
         * Sets the value of {@link VdmAttributesProps#getEngagementMetrics}
         * @param engagementMetrics Whether engagement metrics are enabled for your account.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder engagementMetrics(java.lang.Boolean engagementMetrics) {
            this.engagementMetrics = engagementMetrics;
            return this;
        }

        /**
         * Sets the value of {@link VdmAttributesProps#getOptimizedSharedDelivery}
         * @param optimizedSharedDelivery Whether optimized shared delivery is enabled for your account.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder optimizedSharedDelivery(java.lang.Boolean optimizedSharedDelivery) {
            this.optimizedSharedDelivery = optimizedSharedDelivery;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link VdmAttributesProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public VdmAttributesProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link VdmAttributesProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements VdmAttributesProps {
        private final java.lang.Boolean engagementMetrics;
        private final java.lang.Boolean optimizedSharedDelivery;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.engagementMetrics = software.amazon.jsii.Kernel.get(this, "engagementMetrics", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.optimizedSharedDelivery = software.amazon.jsii.Kernel.get(this, "optimizedSharedDelivery", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.engagementMetrics = builder.engagementMetrics;
            this.optimizedSharedDelivery = builder.optimizedSharedDelivery;
        }

        @Override
        public final java.lang.Boolean getEngagementMetrics() {
            return this.engagementMetrics;
        }

        @Override
        public final java.lang.Boolean getOptimizedSharedDelivery() {
            return this.optimizedSharedDelivery;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getEngagementMetrics() != null) {
                data.set("engagementMetrics", om.valueToTree(this.getEngagementMetrics()));
            }
            if (this.getOptimizedSharedDelivery() != null) {
                data.set("optimizedSharedDelivery", om.valueToTree(this.getOptimizedSharedDelivery()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ses.VdmAttributesProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            VdmAttributesProps.Jsii$Proxy that = (VdmAttributesProps.Jsii$Proxy) o;

            if (this.engagementMetrics != null ? !this.engagementMetrics.equals(that.engagementMetrics) : that.engagementMetrics != null) return false;
            return this.optimizedSharedDelivery != null ? this.optimizedSharedDelivery.equals(that.optimizedSharedDelivery) : that.optimizedSharedDelivery == null;
        }

        @Override
        public final int hashCode() {
            int result = this.engagementMetrics != null ? this.engagementMetrics.hashCode() : 0;
            result = 31 * result + (this.optimizedSharedDelivery != null ? this.optimizedSharedDelivery.hashCode() : 0);
            return result;
        }
    }
}
