package software.amazon.awscdk.services.ses.actions;

/**
 * Adds a header to the received email.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.s3.*;
 * import software.amazon.awscdk.services.ses.actions.*;
 * Bucket bucket = new Bucket(this, "Bucket");
 * Topic topic = new Topic(this, "Topic");
 * ReceiptRuleSet.Builder.create(this, "RuleSet")
 *         .rules(List.of(ReceiptRuleOptions.builder()
 *                 .recipients(List.of("hello&#64;aws.com"))
 *                 .actions(List.of(
 *                     AddHeader.Builder.create()
 *                             .name("X-Special-Header")
 *                             .value("aws")
 *                             .build(),
 *                     S3.Builder.create()
 *                             .bucket(bucket)
 *                             .objectKeyPrefix("emails/")
 *                             .topic(topic)
 *                             .build()))
 *                 .build(), ReceiptRuleOptions.builder()
 *                 .recipients(List.of("aws.com"))
 *                 .actions(List.of(
 *                     Sns.Builder.create()
 *                             .topic(topic)
 *                             .build()))
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-01-25T00:21:04.070Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ses_actions.AddHeader")
public class AddHeader extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.ses.IReceiptRuleAction {

    protected AddHeader(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected AddHeader(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public AddHeader(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ses.actions.AddHeaderProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Returns the receipt rule action specification.
     * <p>
     * @param _rule This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ses.ReceiptRuleActionConfig bind(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ses.IReceiptRule _rule) {
        return software.amazon.jsii.Kernel.call(this, "bind", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ses.ReceiptRuleActionConfig.class), new Object[] { java.util.Objects.requireNonNull(_rule, "_rule is required") });
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.ses.actions.AddHeader}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.ses.actions.AddHeader> {
        /**
         * @return a new instance of {@link Builder}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create() {
            return new Builder();
        }

        private final software.amazon.awscdk.services.ses.actions.AddHeaderProps.Builder props;

        private Builder() {
            this.props = new software.amazon.awscdk.services.ses.actions.AddHeaderProps.Builder();
        }

        /**
         * The name of the header to add.
         * <p>
         * Must be between 1 and 50 characters,
         * inclusive, and consist of alphanumeric (a-z, A-Z, 0-9) characters
         * and dashes only.
         * <p>
         * @return {@code this}
         * @param name The name of the header to add. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(final java.lang.String name) {
            this.props.name(name);
            return this;
        }

        /**
         * The value of the header to add.
         * <p>
         * Must be less than 2048 characters,
         * and must not contain newline characters ("\r" or "\n").
         * <p>
         * @return {@code this}
         * @param value The value of the header to add. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder value(final java.lang.String value) {
            this.props.value(value);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.ses.actions.AddHeader}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.ses.actions.AddHeader build() {
            return new software.amazon.awscdk.services.ses.actions.AddHeader(
                this.props.build()
            );
        }
    }
}
